#ifndef GBEMOL_APP_H
#define GBEMOL_APP_H

#include <gtk/gtk.h>
#include <stdarg.h>
#include "gbemol-mpd.h"
#include "gbemol-library.h"
#include "gbemol-info.h"
#include "gbemol-playlist.h"

#define ICON_FILE PIXMAPS_DIR"/gbemol.png"

#define GBEMOL_VERSION "0.3.2"

/*
 * Type macros.
 */

G_BEGIN_DECLS

#define GBEMOL_TYPE_APP         (gbemol_app_get_type ())
#define GBEMOL_APP(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GBEMOL_TYPE_APP, GbemolApp))
#define GBEMOL_APP_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), GBEMOL_TYPE_APP, GbemolAppClass))
#define GBEMOL_IS_APP(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GBEMOL_TYPE_APP))
#define GBEMOL_IS_APP_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GBEMOL_TYPE_APP))
#define GBEMOL_APP_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GBEMOL_TYPE_APP, GbemolAppClass))

#define GBEMOL_DEFAULT_HEIGHT 120
#define GBEMOL_DEFAULT_WIDTH  500

typedef struct _GbemolApp GbemolApp;
typedef struct _GbemolAppClass GbemolAppClass;
typedef struct _GbemolAppPrivate GbemolAppPrivate;

struct _GbemolApp {
	GtkContainer parent;

	GbemolMpd* mpd;
	GbemolLibrary* lib;
	GbemolPlaylist* pls;
	GbemolInfo* info;

	GtkWidget* notebook;
	GbemolAppPrivate* priv;
};

struct _GbemolAppClass {
	GtkContainerClass parent;
};

GType gbemol_app_get_type (void);

GbemolApp* gbemol_app_new (void);
void gbemol_app_set_mpd (GbemolApp* app, GbemolMpd* mpd);
void gbemol_app_connect_mpd (GbemolApp* app);
void gbemol_app_set_song (GbemolApp* app, GbemolMpdSong* song);
void gbemol_app_set_status (GbemolApp* app, gchar *context, gchar *msg, ...);
void gbemol_app_set_state (GbemolApp* app);
void gbemol_app_destroy (GbemolApp* app);
void gbemol_app_set_connected (GbemolApp* app, gboolean connected);
void gbemol_app_connect_mpd (GbemolApp* app);
void gbemol_app_set_time (GbemolApp* app, int elapsed, int total);
void gbemol_app_set_volume (GbemolApp* app, gint volume);
void gbemol_app_set_random (GbemolApp* app, gboolean random);
void gbemol_app_set_repeat (GbemolApp* app, gboolean repeat);
void gbemol_app_create_status_icon (GbemolApp* obj);
void gbemol_app_destroy_status_icon (GbemolApp* obj);
void gbemol_app_error_dialog_new (GbemolApp* app, gchar* primary_msg, gchar* secondary_msg);
void gbemol_app_reconnect_dialog_new (GbemolApp* app, gchar* msg);
void gbemol_app_set_top (GbemolApp* app, gboolean top);
void gbemol_app_set_stick (GbemolApp* app, gboolean stick);
void gbemol_app_show (GbemolApp* app);
void gbemol_app_hide (GbemolApp* app);
void gbemol_app_full_mode (GbemolApp* app);
void gbemol_app_compact_mode (GbemolApp* app);

G_END_DECLS

#endif
