#############################################################################
##
#W  randlist.tst                   GAP library                Frank Lübeck
##
##
#Y  Copyright (C)  2016, The GAP Group
##
gap> START_TEST("randlist.tst");
gap> l4 := [1..2^28-1];
[ 1 .. 268435455 ]
gap> bits := Concatenation([27..33],[59..65],[95..97],[127..129]);;

#
gap> Reset(GlobalMersenneTwister, 1);;
gap> List(bits,    i-> Random(1, 2^i));
[ 18829054, 164251624, 474614219, 233454245, 213348187, 3257085298, 
  1185099587, 100418839541388781, 78936154011671244, 1951632504588564735, 
  1891846953557814001, 7380160538170766753, 4588549330382399543, 
  20212399778158554723, 25871717046293081269812882956, 
  74959154262646398646743466671, 52390258479956963774859779424, 
  46150081993482768205533540973984006122, 
  264304607032107166297612477092494666822, 
  369126435272860177990538082224405421325 ]
gap> List([1..10], i-> Random(1, 10^(3*i)));
[ 796, 488110, 337484392, 594009012741, 658311342730164, 718543835420643146, 
  192531588881827984252, 93448310516637261223301, 897306488169252919346512382,
  373729190135314870329223545530 ]
gap> List([1..10], i-> Random(l4));
[ 143468941, 48373072, 9645662, 124739889, 124982356, 178658837, 173118677, 
  117495931, 138389463, 242860897 ]

#
gap> Reset(GlobalRandomSource, 1);;
gap> List(bits,    i-> Random(GlobalRandomSource, 1, 2^i));
[ 128287824, 93339996, 497514298, 126333050, 888008348, 3272686668, 
  3284765239, 246384569571494206, 899121525533970334, 2058504735678170118, 
  1295847095154625366, 1831951483667165481, 12413749580545794189, 
  21112300994467179461, 16479214171808335931562195799, 
  47077177305952446651710749862, 93051612446083908105560589039, 
  17595829529914834395994704246711425132, 
  189028623575818650885511742806844572497, 
  442802932679156364466206827982691923819 ]
gap> List([1..10], i-> Random(GlobalRandomSource, 1, 10^(3*i)));
[ 292, 540747, 68367363, 782766307890, 207951565811836, 269515013492647614, 
  168133019703503347058, 46702024622849426851426, 498676940076039327334874754,
  960893403060023160487783291143 ]
gap> List([1..10], i-> Random(GlobalRandomSource, l4));
[ 190962548, 17964291, 180726950, 185199085, 213556766, 109018187, 55718740, 
  216423086, 151137000, 48013178 ]

#
gap> rs := RandomSource(IsMersenneTwister, 1);
<RandomSource in IsMersenneTwister>
gap> List(bits,    i-> Random(rs, 1, 2^i));
[ 18829054, 164251624, 474614219, 233454245, 213348187, 3257085298, 
  1185099587, 100418839541388781, 78936154011671244, 1951632504588564735, 
  1891846953557814001, 7380160538170766753, 4588549330382399543, 
  20212399778158554723, 25871717046293081269812882956, 
  74959154262646398646743466671, 52390258479956963774859779424, 
  46150081993482768205533540973984006122, 
  264304607032107166297612477092494666822, 
  369126435272860177990538082224405421325 ]
gap> List([1..10], i-> Random(rs, 1, 10^(3*i)));
[ 796, 488110, 337484392, 594009012741, 658311342730164, 718543835420643146, 
  192531588881827984252, 93448310516637261223301, 897306488169252919346512382,
  373729190135314870329223545530 ]
gap> List([1..10], i-> Random(rs, l4));
[ 143468941, 48373072, 9645662, 124739889, 124982356, 178658837, 173118677, 
  117495931, 138389463, 242860897 ]

#
gap> rs := RandomSource(IsGAPRandomSource, 1);
<RandomSource in IsGAPRandomSource>
gap> List(bits,    i-> Random(rs, 1, 2^i));
[ 128287824, 93339996, 497514298, 126333050, 888008348, 3272686668, 
  3284765239, 246384569571494206, 899121525533970334, 2058504735678170118, 
  1295847095154625366, 1831951483667165481, 12413749580545794189, 
  21112300994467179461, 16479214171808335931562195799, 
  47077177305952446651710749862, 93051612446083908105560589039, 
  17595829529914834395994704246711425132, 
  189028623575818650885511742806844572497, 
  442802932679156364466206827982691923819 ]
gap> List([1..10], i-> Random(rs, 1, 10^(3*i)));
[ 292, 540747, 68367363, 782766307890, 207951565811836, 269515013492647614, 
  168133019703503347058, 46702024622849426851426, 498676940076039327334874754,
  960893403060023160487783291143 ]
gap> List([1..10], i-> Random(rs, l4));
[ 190962548, 17964291, 180726950, 185199085, 213556766, 109018187, 55718740, 
  216423086, 151137000, 48013178 ]

#
gap> STOP_TEST( "randlist.tst", 1);
