/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.graphApi.io.CSSColourParser;
import hypergraph.hyperbolic.LineRenderer;
import hypergraph.hyperbolic.ModelPanel;
import hypergraph.hyperbolic.ModelPanelUI;
import hypergraph.hyperbolic.ModelPoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;

public class DefaultLineRenderer
extends JComponent
implements LineRenderer {
    protected ModelPoint start;
    protected ModelPoint end;
    protected ModelPanel panel;
    private Color color;

    public void configure(ModelPanel modelPanel) {
        this.setModelPanel(modelPanel);
        this.setColor(null);
    }

    public void configure(ModelPanel modelPanel, ModelPoint modelPoint, ModelPoint modelPoint2) {
        this.configure(modelPanel);
        if (this.start == null) {
            this.start = (ModelPoint)modelPoint.clone();
        } else {
            this.start.setTo(modelPoint);
        }
        if (this.end == null) {
            this.end = (ModelPoint)modelPoint2.clone();
        } else {
            this.end.setTo(modelPoint2);
        }
        this.setBounds(0, 0, modelPanel.getWidth(), modelPanel.getHeight());
    }

    public Component getComponent() {
        return this;
    }

    public void setModelPanel(ModelPanel modelPanel) {
        this.panel = modelPanel;
    }

    public void paint(Graphics graphics) {
        if (this.start == null || this.end == null) {
            return;
        }
        graphics.setColor(this.getColor());
        ModelPanelUI modelPanelUI = this.panel.getUI();
        Point[] pointArray = this.panel.getProjector().getLineSegments(this.start, this.end, this.panel);
        int[] nArray = new int[pointArray.length];
        int[] nArray2 = new int[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            nArray[i] = pointArray[i].x;
            nArray2[i] = pointArray[i].y;
        }
        graphics.drawPolyline(nArray, nArray2, pointArray.length);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        String string = this.panel.getPropertyManager().getString("hypergraph.hyperbolic.line.color");
        return CSSColourParser.stringToColor(string);
    }
}

