# OKI MSM5232

a rather primitive (but powerful) sound generator chip used in some arcade boards and even synthesizers (like Korg Poly-800).

it has 8 channels in 2 groups (of 4 channels each). each group can be configured with an envelope and the ability to produce 2', 4', 8' and/or 16' square/noise overtones on 8 outputs (four (2', 4', 8' and 16') per group).

however, this chip cannot entirely produce sound alone. it has to be paired with either an external envelope generator or capacitors to assist the internal envelope generator.

it also has no fine tune whatsoever. the frequency resolution is exactly a semitone.

Furnace implements this chip in a way that allows the following features:
- internal (capacitors) or external (volume macro) envelope modes per group
- the ability to change the volume of each output (this can be used to generate saw waves if you set each part/overtone's volume to exactly half of the previous one)
- global fine tune
- global vibrato (some arcade boards played with the clock input to simulate vibrato)

## effects

- `10xy`: **set group control.**
  - `x` sets sustain mode.
  - `y` is a 4-bit mask which toggles overtones.
- `11xx`: **set noise mode.**
- `12xx`: **set group attack.** range is `0` to `5`.
  - only in internal (capacitor-based) envelope mode.
- `13xx`: **set group decay.** range is `0` to `11`.
  - only in internal (capacitor-based) envelope mode.

## info

this chip uses the [MSM5232](../4-instrument/msm5232.md) instrument editor.

## chip config

the following options are available in the Chip Manager window:

- **Detune**: sets detune in 128ths of a semitone.
- **Capacitor values**: allows you to change the capacitance of the 8 capacitors connected to the chip. longer values increase envelope length.
- **Initial part volume**: sets the initial volume of each "part" (octave) in a group.
- **Envelope mode**: sets whether to use an external volume input (in this case, macros) or the built-in envelope generator.
- **Global vibrato**: nudges the clock to simulate vibrato.
