/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file preferences.h
 * \brief Macros for simple configuration file handling
 */

#ifndef PREFERENCES_H
#define PREFERENCES_H

#define CREATE_STRING_PREFS(_section, _func, url) \
	const gchar *_section##Get##_func( struct sProfile *psProfile ) {\
		return prefsGetString( psProfile, url );\
	}\
	\
	void _section##Set##_func( struct sProfile *psProfile, const gchar *pnStr ) {\
		prefsSetString( psProfile, url, pnStr );\
	}

#define CREATE_INT_PREFS(_section, _func, url) \
	int _section##Get##_func( struct sProfile *psProfile ) {\
		return prefsGetInt( psProfile, url );\
	}\
	\
	void _section##Set##_func( struct sProfile *psProfile, int nNum ) {\
		prefsSetInt( psProfile, url, nNum );\
	}

#define CREATE_PATH_PREFS(_section, _func, url) \
	const gchar *_section##Get##_func( struct sProfile *psProfile ) {\
		return prefsGetPath( psProfile, url );\
	}\
	\
	void _section##Set##_func( struct sProfile *psProfile, const gchar *pnPath ) {\
		prefsSetPath( psProfile, url, pnPath );\
	}

#define CREATE_BOOL_PREFS(_section, _func, _url) \
	gboolean _section##Get##_func( struct sProfile *psProfile ) {\
		return prefsGetBool( psProfile, _url );\
	}\
	\
	void _section##Set##_func( struct sProfile *psProfile, gboolean bSet ) {\
		prefsSetBool( psProfile, _url, bSet );\
	}

#endif
