/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucar.grib.Index;
import ucar.grib.TableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.grib.GribHorizCoordSys;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.units.SimpleUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GribCoordSys {
    private GribHorizCoordSys hcs;
    private Index.GribRecord record;
    private String verticalName;
    private TableLookup lookup;
    private List<Double> levels;
    boolean dontUseVertical = false;
    String positive = "up";
    String units;

    GribCoordSys(GribHorizCoordSys hcs, Index.GribRecord record, String name, TableLookup lookup) {
        this.hcs = hcs;
        this.record = record;
        this.verticalName = name;
        this.lookup = lookup;
        this.levels = new ArrayList<Double>();
        this.dontUseVertical = !lookup.isVerticalCoordinate(record);
        this.positive = lookup.isPositiveUp(record) ? "up" : "down";
        this.units = lookup.getLevelUnit(record);
        if (GribServiceProvider.debugVert) {
            System.out.println("GribCoordSys: " + this.getVerticalDesc() + " useVertical= " + !this.dontUseVertical + " positive=" + this.positive + " units=" + this.units);
        }
    }

    String getCoordSysName() {
        return this.verticalName + "_CoordSys";
    }

    String getVerticalName() {
        return this.verticalName;
    }

    String getVerticalDesc() {
        return this.verticalName + "(" + this.record.levelType1 + ")";
    }

    int getNLevels() {
        return this.dontUseVertical ? 1 : this.levels.size();
    }

    void addLevels(List<Index.GribRecord> records) {
        for (Index.GribRecord record : records) {
            Double d = record.levelValue1;
            if (!this.levels.contains(d)) {
                this.levels.add(d);
            }
            if (!this.dontUseVertical || this.levels.size() <= 1 || !GribServiceProvider.debugVert) continue;
            System.out.println("GribCoordSys: unused level coordinate has > 1 levels = " + this.verticalName + " " + record.levelType1 + " " + this.levels.size());
        }
        Collections.sort(this.levels);
        if (this.positive.equals("down")) {
            Collections.reverse(this.levels);
        }
    }

    boolean matchLevels(List<Index.GribRecord> records) {
        ArrayList<Double> levelList = new ArrayList<Double>(records.size());
        for (Index.GribRecord record : records) {
            Double d = record.levelValue1;
            if (levelList.contains(d)) continue;
            levelList.add(d);
        }
        Collections.sort(levelList);
        if (this.positive.equals("down")) {
            Collections.reverse(levelList);
        }
        return ((Object)levelList).equals(this.levels);
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        if (this.dontUseVertical) {
            return;
        }
        int nlevs = this.levels.size();
        ncfile.addDimension(g, new Dimension(this.verticalName, nlevs));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        if (this.dontUseVertical) {
            return;
        }
        if (g == null) {
            g = ncfile.getRootGroup();
        }
        String dims = "time";
        if (!this.dontUseVertical) {
            dims = dims + " " + this.verticalName;
        }
        dims = this.hcs.isLatLon() ? dims + " lat lon" : dims + " y x";
        int nlevs = this.levels.size();
        Variable v = new Variable(ncfile, g, null, this.verticalName);
        v.setDataType(DataType.DOUBLE);
        v.addAttribute(new Attribute("long_name", this.lookup.getLevelDescription(this.record)));
        v.addAttribute(new Attribute("units", this.lookup.getLevelUnit(this.record)));
        if (this.positive != null) {
            v.addAttribute(new Attribute("positive", this.positive));
        }
        if (this.units != null) {
            AxisType axisType = SimpleUnit.isCompatible("millibar", this.units) ? AxisType.Pressure : (SimpleUnit.isCompatible("m", this.units) ? AxisType.Height : AxisType.GeoZ);
            v.addAttribute(new Attribute("GRIB_level_type", Integer.toString(this.record.levelType1)));
            v.addAttribute(new Attribute("_CoordinateAxisType", axisType.toString()));
            v.addAttribute(new Attribute("_CoordinateAxes", dims));
            if (!this.hcs.isLatLon()) {
                v.addAttribute(new Attribute("_CoordinateTransforms", this.hcs.getGridName()));
            }
        }
        double[] data = new double[nlevs];
        for (int i = 0; i < this.levels.size(); ++i) {
            data[i] = this.levels.get(i);
        }
        Array dataArray = Array.factory(DataType.DOUBLE, new int[]{nlevs}, (Object)data);
        v.setDimensions(this.verticalName);
        v.setCachedData(dataArray, false);
        ncfile.addVariable(g, v);
        if (this.record.levelType1 == 109) {
            this.findCoordinateTransform(g, "Pressure", this.record.levelType1);
        }
        this.record = null;
    }

    void findCoordinateTransform(Group g, String nameStartsWith, int levelType) {
        List<Variable> vars = g.getVariables();
        for (Variable v : vars) {
            Attribute att;
            if (!v.getName().equals(nameStartsWith) || (att = v.findAttribute("GRIB_level_type")) == null || att.getNumericValue().intValue() != levelType) continue;
            v.addAttribute(new Attribute("_CoordinateTransformType", "Vertical"));
            v.addAttribute(new Attribute("transform_name", "Existing3DField"));
        }
    }

    int getIndex(Index.GribRecord record) {
        return this.levels.indexOf(record.levelValue1);
    }
}

