/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.filter;

import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;

public class AssignableTypeFilter
extends AbstractTypeHierarchyTraversingFilter {
    private final Class targetType;

    public AssignableTypeFilter(Class targetType) {
        super(true, true);
        this.targetType = targetType;
    }

    protected boolean matchClassName(String className) {
        return this.targetType.getName().equals(className);
    }

    protected Boolean matchSuperClass(String superClassName) {
        return this.matchTargetType(superClassName);
    }

    protected Boolean matchInterface(String interfaceName) {
        return this.matchTargetType(interfaceName);
    }

    protected Boolean matchTargetType(String typeName) {
        if (this.targetType.getName().equals(typeName)) {
            return true;
        }
        if (Object.class.getName().equals(typeName)) {
            return Boolean.FALSE;
        }
        if (typeName.startsWith("java.")) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(typeName);
                return this.targetType.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

