/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class BMPReader
extends FormatReader {
    protected int offset;
    protected int bpp;
    protected byte[][] palette;
    protected int compression;
    private long global;

    public BMPReader() {
        super("Windows Bitmap", "bmp");
    }

    public boolean isThisType(byte[] block) {
        return new String(block).startsWith("BM");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.palette;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        if (this.compression != 0) {
            throw new FormatException("Compression type " + this.compression + " not supported");
        }
        this.in.seek(this.global);
        if (this.palette != null && this.palette[0].length > 0 || this.core.sizeC[0] == 1) {
            for (int y = this.core.sizeY[0] - 1; y >= 0; --y) {
                this.in.read(buf, y * this.core.sizeX[0], this.core.sizeX[0]);
            }
        } else {
            for (int y = this.core.sizeY[0] - 1; y >= 0; --y) {
                this.in.read(buf, y * this.core.sizeX[0] * 3, this.core.sizeX[0] * 3);
            }
            for (int i = 0; i < buf.length / 3; ++i) {
                byte tmp = buf[i * 3 + 2];
                buf[i * 3 + 2] = buf[i * 3];
                buf[i * 3] = tmp;
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("BMPReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Reading bitmap header");
        this.in.order(true);
        this.addMeta("Magic identifier", this.in.readString(2));
        this.addMeta("File size (in bytes)", "" + this.in.readInt());
        this.in.skipBytes(4);
        this.offset = this.in.readInt();
        this.in.skipBytes(4);
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        if (this.core.sizeX[0] < 1 || this.core.sizeY[0] < 1) {
            throw new FormatException("Invalid image dimensions: " + this.core.sizeX[0] + " x " + this.core.sizeY[0]);
        }
        this.addMeta("Image width", "" + this.core.sizeX[0]);
        this.addMeta("Image height", "" + this.core.sizeY[0]);
        this.addMeta("Color planes", "" + this.in.readShort());
        this.bpp = this.in.readShort();
        this.addMeta("Bits per pixel", "" + this.bpp);
        this.compression = this.in.readInt();
        String comp = "invalid";
        switch (this.compression) {
            case 0: {
                comp = "None";
                break;
            }
            case 1: {
                comp = "8 bit run length encoding";
                break;
            }
            case 2: {
                comp = "4 bit run length encoding";
                break;
            }
            case 3: {
                comp = "RGB bitmap with mask";
            }
        }
        this.addMeta("Compression type", comp);
        this.in.skipBytes(4);
        int pixelSizeX = this.in.readInt();
        int pixelSizeY = this.in.readInt();
        this.addMeta("X resolution", "" + pixelSizeX);
        this.addMeta("Y resolution", "" + pixelSizeY);
        int nColors = this.in.readInt();
        this.in.skipBytes(4);
        if ((long)this.offset != this.in.getFilePointer() && nColors > 0) {
            this.palette = new byte[3][nColors];
            for (int i = 0; i < nColors; ++i) {
                for (int j = this.palette.length; j > 0; --j) {
                    this.palette[j][i] = this.in.readByte();
                }
                this.in.skipBytes(1);
            }
        }
        this.global = this.in.getFilePointer();
        this.addMeta("Indexed color", this.palette == null ? "false" : "true");
        this.status("Populating metadata");
        int n = this.core.sizeC[0] = this.palette == null && this.bpp == 8 ? 1 : 3;
        if (this.bpp > 8) {
            this.bpp /= 3;
        }
        while (this.bpp % 8 != 0) {
            ++this.bpp;
        }
        switch (this.bpp) {
            case 8: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 16: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 32: {
                this.core.pixelType[0] = 5;
            }
        }
        if (this.core.sizeX[0] % 2 == 1) {
            this.core.sizeX[0] = this.core.sizeX[0] + 1;
        }
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.littleEndian[0] = true;
        this.core.interleaved[0] = true;
        this.core.imageCount[0] = 1;
        this.core.sizeZ[0] = 1;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYCTZ";
        this.core.metadataComplete[0] = true;
        this.core.indexed[0] = this.palette != null;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        float correctedX = 1.0f / (float)pixelSizeX * 1000000.0f;
        float correctedY = 1.0f / (float)pixelSizeY * 1000000.0f;
        store.setDimensions(new Float(correctedX), new Float(correctedY), null, null, null, null);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

