	SUBROUTINE TS_FIND_VAR ( dset_num,varpos,vf_num,varstrt,status )
*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
*
* Locates and opens (if not already open) the correct data file containing
* the specified variable.
* 
* programmer - mark verschell
* NOAA/PMEL, Seattle, WA - Tropical Modeling and Analysis Program
* written for VAX computer under VMS operating system
*
* revision 0.00 - 08/23/88
*
* arguments:
*	dset_num	- number (in COMMON/DSET_INFO/) of dataset
*	varpos		- location in ds_ arrays of the correct variable
*	vf_num	 	- (output) the desired file number (in /XSTEP_FILES/)
*	varstrt		- (output) record number of the first variable record
*	status		- returned error code

	INTEGER		dset_num,vf_num,varstrt,varpos,status

#ifdef unix
#include "tmap_dset.parm"
	include 'tmap_dims.parm'
	include 'tmap_errors.parm'
	include 'xstep_files.cmn_text'
	external xstep_files_data
	include 'xdset_info.cmn_text'
	external xdset_info_data
#else
	INCLUDE 'TMAP_FORMAT:TMAP_DSET.PARM'
	INCLUDE 'TMAP_FORMAT:TMAP_DIMS.PARM'
	INCLUDE 'TMAP_FORMAT:TMAP_ERRORS.PARM'
	INCLUDE 'TMAP_FORMAT:XSTEP_FILES.CMN'
	INCLUDE 'TMAP_FORMAT:XDSET_INFO.CMN'
#endif

	CHARACTER*8	variable
	INTEGER		vfcnt,ivar

	variable = ds_var_code(varpos)
* find correct file
	DO 300 vfcnt = 1,maxvarfiles
	  IF (vf_setnum(vfcnt) .NE. dset_num) GOTO 300	! right dataset?
	  IF ((vf_firstvar(vfcnt).GT. varpos) .OR.	! contains variable
     .	      (vf_lastvar(vfcnt) .LT. varpos)) GOTO 300
	  GOTO 400
  300	CONTINUE
	GOTO 9000

* found the correct one!
* check to see if file open already
  400	IF (vf_lunit(vfcnt)  .EQ. file_not_open) THEN
* let's try to open it
	  CALL TS_OPEN_VARF (vfcnt,status)
* Is it mounted?
	  IF (status .NE. merr_OK) GOTO 9990
	ENDIF

* Varfile mounted and normal so locate varstrt
	varstrt = 1 + ds_nrecb4var(varpos)

* got it
	vf_num = vfcnt
	status = merr_ok
	GOTO 9990

* ERRORS
 9000	CALL TM_ERRMSG (merr_unkvar, status, 'TS_FIND_VAR',
     .			dset_num, no_stepfile,
     .			'VAR='//variable, no_errstring, *9990)

 9990	RETURN
	END
