#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import debug
from fenrirscreenreader.core.i18n import _


class ScreenDriver:
    def __init__(self):
        self._is_initialized = False
        self.bgColorNames = {
            0: _("black"),
            1: _("blue"),
            2: _("green"),
            3: _("cyan"),
            4: _("red"),
            5: _("Magenta"),
            6: _("brown/yellow"),
            7: _("white"),
        }
        self.fgColorNames = {
            0: _("Black"),
            1: _("Blue"),
            2: _("Green"),
            3: _("Cyan"),
            4: _("Red"),
            5: _("Magenta"),
            6: _("brown/yellow"),
            7: _("Light gray"),
            8: _("Dark gray"),
            9: _("Light blue"),
            10: ("Light green"),
            11: _("Light cyan"),
            12: _("Light red"),
            13: _("Light magenta"),
            14: _("Light yellow"),
            15: _("White"),
        }

    def initialize(self, environment):
        self.env = environment
        self._is_initialized = True

    def shutdown(self):
        self._is_initialized = False

    def get_curr_screen(self):
        pass

    def inject_text_to_screen(self, text, screen=None):
        pass

    def get_curr_application(self):
        pass

    def get_session_information(self):
        pass
