#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return ""

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "keyboard", "interruptOnKeyPress"
        ):
            return
        if self.env["runtime"]["InputManager"].no_key_pressed():
            return
        if self.env["runtime"]["ScreenManager"].is_screen_change():
            return
        if len(self.env["input"]["currInput"]) <= len(
            self.env["input"]["prevInput"]
        ):
            return
        # if the filter is set
        if (
            self.env["runtime"]["SettingsManager"]
            .get_setting("keyboard", "interruptOnKeyPressFilter")
            .strip()
            != ""
        ):
            filter_list = (
                self.env["runtime"]["SettingsManager"]
                .get_setting("keyboard", "interruptOnKeyPressFilter")
                .split(",")
            )
            for currInput in self.env["input"]["currInput"]:
                if currInput not in filter_list:
                    return
        self.env["runtime"]["OutputManager"].interrupt_output()

    def set_callback(self, callback):
        pass
