/*
 * $Id: arch_i2c_slave.c,v 1.2 2010-10-16 14:58:43 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE

#include "sig_std_logic.h"

#endif /* INCLUDE */

#ifdef STATE

struct {
	unsigned int state_sda;
	unsigned int state_scl;

	enum {
		NAME_(STOP),
		NAME_(START),
		NAME_(RUNNING),
		NAME_(ADDR_R),
		NAME_(ADDR_W),
		NAME_(ADDR_R_ACK),
		NAME_(ADDR_W_ACK),
		NAME_(ADDR_R_ACK_BYTE),
		NAME_(ADDR_W_ACK_BYTE),
		NAME_(OTHER),
	} state;
	uint8_t bits;
	unsigned int bit_count;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static unsigned int
NAME_(std_logic_to_boolean)(unsigned int val)
{
	switch (val) {
	case SIG_STD_LOGIC_0:
	case SIG_STD_LOGIC_L:
		val = 0;
		break;
	case SIG_STD_LOGIC_1:
	case SIG_STD_LOGIC_H:
		val = 1;
		break;
	default:
		/* Should not happen... */
		val = 0;
		break;
	}

	return val;
}

static unsigned int
NAME_(boolean_to_std_logic)(unsigned int val)
{
	if (val) {
		return SIG_STD_LOGIC_1;
	} else {
		return SIG_STD_LOGIC_0;
	}
}

static void
NAME_(sda_in)(struct cpssp *cpssp, unsigned int val)
{
	val = NAME_(std_logic_to_boolean)(val);
	if (val == cpssp->NAME.state_sda) {
		return;
	}

	if (cpssp->NAME.state_scl) {
		if (val) {
			/* Stop condition. */
			NAME_(stop_transaction)(cpssp);
			cpssp->NAME.state = NAME_(STOP);
			NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
		} else {
			/* Start condition. */
			cpssp->NAME.state = NAME_(START);
			NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
		}
	}

	cpssp->NAME.state_sda = val;
}

static void
NAME_(scl_in)(struct cpssp *cpssp, unsigned int val)
{
	val = NAME_(std_logic_to_boolean)(val);
	if (val == cpssp->NAME.state_scl) {
		return;
	}

	if (! val) {
		/* React only on falling edge! */
		switch (cpssp->NAME.state) {
		case NAME_(STOP):
			/* Shouldn't happen... */
			NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
			break;

		case NAME_(START):
			cpssp->NAME.state = NAME_(RUNNING);
			cpssp->NAME.bit_count = 0;
			NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
			break;

		case NAME_(RUNNING):
			cpssp->NAME.bits <<= 1;
			cpssp->NAME.bits |= cpssp->NAME.state_sda;
			cpssp->NAME.bit_count++;
			if (cpssp->NAME.bit_count == 8) {
				if (! NAME_(ack_addr)(cpssp, cpssp->NAME.bits)) {
					cpssp->NAME.state = NAME_(OTHER);
					NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
				} else if (cpssp->NAME.bits & 1) {
					cpssp->NAME.state = NAME_(ADDR_R);
					NAME_(sda_out)(cpssp, SIG_STD_LOGIC_0);
				} else {
					cpssp->NAME.state = NAME_(ADDR_W);
					NAME_(sda_out)(cpssp, SIG_STD_LOGIC_0);
				}
			}
			break;

		case NAME_(ADDR_R):
		NAME_(addr_r):
			cpssp->NAME.state = NAME_(ADDR_R_ACK);
			NAME_(read_byte)(cpssp, &cpssp->NAME.bits);
			cpssp->NAME.bit_count = 0;
			NAME_(sda_out)(cpssp, NAME_(boolean_to_std_logic)((cpssp->NAME.bits >> 7) & 1));
			break;
			
		case NAME_(ADDR_R_ACK):
			cpssp->NAME.bits <<= 1;
			cpssp->NAME.bit_count++;
			if (cpssp->NAME.bit_count == 8) {
				cpssp->NAME.state = NAME_(ADDR_R_ACK_BYTE);
				NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
			} else {
				NAME_(sda_out)(cpssp, NAME_(boolean_to_std_logic)((cpssp->NAME.bits >> 7) & 1));
			}
			break;

		case NAME_(ADDR_R_ACK_BYTE):
			if (cpssp->NAME.state_sda) {
				/* No ACK */
				cpssp->NAME.state = NAME_(OTHER);
				NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
			} else {
				/* ACK */
				goto NAME_(addr_r);
			}
			break;

		case NAME_(ADDR_W):
		case NAME_(ADDR_W_ACK_BYTE):
			cpssp->NAME.state = NAME_(ADDR_W_ACK);
			cpssp->NAME.bit_count = 0;
			NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
			break;

		case NAME_(ADDR_W_ACK):
			cpssp->NAME.bits <<= 1;
			cpssp->NAME.bits |= cpssp->NAME.state_sda;
			cpssp->NAME.bit_count++;
			if (cpssp->NAME.bit_count == 8) {
				NAME_(write_byte)(cpssp, cpssp->NAME.bits);
				cpssp->NAME.state = NAME_(ADDR_W_ACK_BYTE);
				NAME_(sda_out)(cpssp, SIG_STD_LOGIC_0);
			} else {
				NAME_(sda_out)(cpssp, SIG_STD_LOGIC_Z);
			}
			break;

		case NAME_(OTHER):
			break;
		default:
			assert(0); /* Mustn't happen. */
		}
	}

	cpssp->NAME.state_scl = val;
}

#endif /* BEHAVIOR */
