/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __VAR_ASSIGN_STAT_HPP_INCLUDED
#define __VAR_ASSIGN_STAT_HPP_INCLUDED

#include "frontend/ast/SeqStat.hpp"
#include "frontend/ast/Expression.hpp"
#include "frontend/ast/Name.hpp"
#include "frontend/ast/VarDeclaration.hpp"

namespace ast {

/** variable assign statement */
class VarAssignStat : public SeqStat {
public:
	//! c'tor
	/** @param trg target of the VarAssignStat.
          * @param src source expression.
	  * @param loc Location of the variable assign statement.
          */
	VarAssignStat(
		Name *trg, 
		Expression *src,
		Location loc
		) : 	SeqStat(loc),
			target(trg), 
			source(src) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << this->target << " := " << this->source << ';';
	}


	/** target */	
	Expression *target;

	/** source that get's evaluated and assigned to target */
	Expression *source;

protected:
	/** Destructor */
	virtual ~VarAssignStat() {
		util::MiscUtil::terminate(target);
		util::MiscUtil::terminate(source);
	}
};

};

#endif /* __VAR_ASSIGN_STAT_HPP_INCLUDED */
