/* $Id: ReturnStat.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __RETURN_STAT_HPP_INCLUDED
#define __RETURN_STAT_HPP_INCLUDED

#include "frontend/ast/Expression.hpp"
#include "frontend/ast/SeqStat.hpp"

namespace ast {

//! VHDL return statement.
/** a VHDL return statement */
class ReturnStat : public SeqStat {
public:
	//! c'tor
	/** @param optExpr expression that determines the return value
	 *  @param loc location of the return statement. */
	ReturnStat(
		Expression *optExpr,
		Location loc
		) : 	SeqStat(loc),
			result(optExpr),
			enclosingSubprog(NULL) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "RETURN";
		if (this->result) {
			stream << ' ' << this->result;
		}
		stream << ';';
	}


	/** result that should get returned (optional) */
	Expression *result;

	/** enclosing subprogram declaration */
	Callable *enclosingSubprog;

protected:
	/** Destructor */
	virtual ~ReturnStat() {
		util::MiscUtil::terminate(result);
		util::MiscUtil::terminate(enclosingSubprog);
	}
};

}; /* namespace ast */

#endif /* __RETURN_STAT_HPP_INCLUDED */
