# Contribution Guidelines

The following documents constitutes a set of guidelines to which contributors must adhere.

* [Contributions Licensing](#contributions-licensing)
* [Developer Certificate of Origin](#developer-certificate-of-origin)
* [Code Coverage](#code-coverage)
## Contributions Licensing

Any contribution that you make to this repository will
be under the Apache 2 License, as dictated by that
[license](http://www.apache.org/licenses/LICENSE-2.0.html):

~~~
5. Submission of Contributions. Unless You explicitly state otherwise,
   any Contribution intentionally submitted for inclusion in the Work
   by You to the Licensor shall be under the terms and conditions of
   this License, without any additional terms or conditions.
   Notwithstanding the above, nothing herein shall supersede or modify
   the terms of any separate license agreement you may have executed
   with Licensor regarding such Contributions.
~~~

## Developer Certificate of Origin

Contributors must sign-off each commit by adding a `Signed-off-by: ...`
line to commit messages to certify that they have the right to submit
the code they are contributing to the project according to the
[Developer Certificate of Origin (DCO)](https://developercertificate.org/).

## Code Coverage

As stated in [QUALITY.md](QUALITY.md), all contributions to the project must increase line code coverage.
Because of this, contributors are asked to locally run a coverage assessment that ensures that code coverage has increased when compared to the latest execution of the [nightly coverage CI job](http://jenkins.eprosima.com:8080/job/nightly_fastdds_coverage_linux/).
