/*
 * --- GSMP-COPYRIGHT-NOTE-BEGIN ---
 * 
 * This copyright note is auto-generated by ./scripts/Create-CopyPatch.
 * Please add additional copyright information _after_ the line containing
 * the GSMP-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
 * the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
 * 
 * GSMP: utility/include/Attribute.hh
 * General Sound Manipulation Program is Copyright (C) 2000 - 2004
 *   Valentin Ziegler and René Rebe
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2. A copy of the GNU General
 * Public License can be found in the file LICENSE.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT-
 * ABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * --- GSMP-COPYRIGHT-NOTE-END ---
 */

/* Short Description:
 *   A attribute / property implementation.
 */

#ifndef UTILITY__ATTRIBUTE_HH__
#define UTILITY__ATTRIBUTE_HH__

#include <sigc++/signal.h>

namespace Utility
{
  
  // the public base of all attributes just holding the value and
  // a Get() method
  template <class T>
  class PublicAttribute {
  public:
    const T& Get () const {
      return value;
    };
  protected:
    T value;
  };
  
  // the real Attribute with control about signalling ...
  template <class T, bool do_signal = true>
  class Attribute : public PublicAttribute<T>
  {
  public:
    const T& Set (const T& n_value) { this->value = n_value; };
  };
  
  template <class T>
  class Attribute <T, true>  : public PublicAttribute<T>
  {
  public:
    sigc::signal <void, const T&> changed;
    
    const T& Set (const T& n_value) {
      this->value = n_value;
      changed.emit (this->value);
    };
  };
  
} // end namespace Utility

#endif // UTILITY__ATTRIBUTE_HH__
