!{\src2tex{textfont=tt}}
!!****m* etsf_dims/etsf_io_dims_merge
!! NAME
!!  etsf_io_dims_merge
!!
!! FUNCTION
!!    It is a checking routine. For all variable, it checks that values are the same
!!    in source and destination. For my_<something> variables, if values are different
!!    then output value is the sum of previous value and input value. This is useful
!!    when the dimensions have split definition. In that case, merging all input file
!!    dimensions will check classical dimensions and sum all split dimensions. At
!!    the end, if my_<something> is equal to <something> then the merging of the
!!    files will end up in suppressing the split for the <something> variable. In
!!    the other case (my_<something> < <something>), the resulting merge file
!!    will still have a split dimension <something> but with more values.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * dims <type(etsf_dims)> = 
!!     the dimensions to be merge into argument @output_dims. If the dimension begin
!!     with my_something, if the value is different from the something dimension, it
!!     is added into @output_dims. If the dimension is a regular one, the equity is
!!     only checked between dims and output_dims.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!! SIDE EFFECTS
!! * output_dims <type(etsf_dims)> = 
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_dims_merge(output_dims, dims, lstat, error_data)

  !Arguments ------------------------------------
  type(etsf_dims), intent(inout) :: output_dims
  type(etsf_dims), intent(in) :: dims
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_dims_merge'


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_dims_merge : enter'
!ENDDEBUG

  lstat = .false.
  
  if (output_dims%character_string_length /= dims%character_string_length) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%complex /= dims%complex) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%max_number_of_angular_momenta /= dims%max_number_of_angular_momenta) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%max_number_of_basis_grid_points /= dims%max_number_of_basis_grid_points) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%max_number_of_coefficients /= dims%max_number_of_coefficients) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%max_number_of_projectors /= dims%max_number_of_projectors) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%max_number_of_states /= dims%max_number_of_states) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_atoms /= dims%number_of_atoms) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_atom_species /= dims%number_of_atom_species) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_cartesian_directions /= dims%number_of_cartesian_directions) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_coefficients_dielectric_function /= dims%number_of_coefficients_dielectric_function) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_components /= dims%number_of_components) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_frequencies_dielectric_function /= dims%number_of_frequencies_dielectric_function) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_grid_points_vector1 /= dims%number_of_grid_points_vector1) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_grid_points_vector2 /= dims%number_of_grid_points_vector2) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_grid_points_vector3 /= dims%number_of_grid_points_vector3) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_kpoints /= dims%number_of_kpoints) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_localization_regions /= dims%number_of_localization_regions) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_qpoints_dielectric_function /= dims%number_of_qpoints_dielectric_function) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_qpoints_gamma_limit /= dims%number_of_qpoints_gamma_limit) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_reduced_dimensions /= dims%number_of_reduced_dimensions) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_spinor_components /= dims%number_of_spinor_components) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_spins /= dims%number_of_spins) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_symmetry_operations /= dims%number_of_symmetry_operations) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%number_of_vectors /= dims%number_of_vectors) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%real_or_complex_coefficients /= dims%real_or_complex_coefficients) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%real_or_complex_density /= dims%real_or_complex_density) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%real_or_complex_gw_corrections /= dims%real_or_complex_gw_corrections) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%real_or_complex_potential /= dims%real_or_complex_potential) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%real_or_complex_wavefunctions /= dims%real_or_complex_wavefunctions) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%symbol_length /= dims%symbol_length) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
      & ERROR_TYPE_DIM, my_name, &
      & errmess = "incompatible dimension for merge.")
    return
  end if
  
  if (output_dims%my_max_number_of_coefficients /= output_dims%max_number_of_coefficients) then
    output_dims%my_max_number_of_coefficients = output_dims%my_max_number_of_coefficients + &
      & dims%my_max_number_of_coefficients
  end if
  
  if (output_dims%my_max_number_of_states /= output_dims%max_number_of_states) then
    output_dims%my_max_number_of_states = output_dims%my_max_number_of_states + &
      & dims%my_max_number_of_states
  end if
  
  if (output_dims%my_number_of_components /= output_dims%number_of_components) then
    output_dims%my_number_of_components = output_dims%my_number_of_components + &
      & dims%my_number_of_components
  end if
  
  if (output_dims%my_number_of_grid_points_vect1 /= output_dims%number_of_grid_points_vector1) then
    output_dims%my_number_of_grid_points_vect1 = output_dims%my_number_of_grid_points_vect1 + &
      & dims%my_number_of_grid_points_vect1
  end if
  
  if (output_dims%my_number_of_grid_points_vect2 /= output_dims%number_of_grid_points_vector2) then
    output_dims%my_number_of_grid_points_vect2 = output_dims%my_number_of_grid_points_vect2 + &
      & dims%my_number_of_grid_points_vect2
  end if
  
  if (output_dims%my_number_of_grid_points_vect3 /= output_dims%number_of_grid_points_vector3) then
    output_dims%my_number_of_grid_points_vect3 = output_dims%my_number_of_grid_points_vect3 + &
      & dims%my_number_of_grid_points_vect3
  end if
  
  if (output_dims%my_number_of_kpoints /= output_dims%number_of_kpoints) then
    output_dims%my_number_of_kpoints = output_dims%my_number_of_kpoints + &
      & dims%my_number_of_kpoints
  end if
  
  if (output_dims%my_number_of_spins /= output_dims%number_of_spins) then
    output_dims%my_number_of_spins = output_dims%my_number_of_spins + &
      & dims%my_number_of_spins
  end if
  lstat = .true.


!DEBUG
!write (*,*) 'etsf_io_dims_merge : exit'
!ENDDEBUG

end subroutine etsf_io_dims_merge
!!***
