/*
	Copyright (c) 2010 by Dennis Schridde

	This file is part of dovecot-metadata.

	dovecot-metadata is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	dovecot-metadata is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with dovecot-metadata.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef DOVECOT_METADATA_ENTRY_H
#define DOVECOT_METADATA_ENTRY_H

#include "metadata-global.h"

#include <stdbool.h>

#include "mail-storage.h"

enum metadata_entry_subject {
	ENTRY_SUBJECT_SERVER = 0,
	ENTRY_SUBJECT_MAILBOX = 1,
	ENTRY_SUBJECT_MAX,
	ENTRY_SUBJECT_INVALID = ENTRY_SUBJECT_MAX
};

enum metadata_entry_scope {
	ENTRY_SCOPE_PRIVATE = 0,
	ENTRY_SCOPE_SHARED = 1,
	ENTRY_SCOPE_MAX,
	ENTRY_SCOPE_INVALID = ENTRY_SCOPE_MAX,
	ENTRY_SCOPE_NONE
};

enum metadata_entry_type {
	ENTRY_TYPE_VENDOR = 0,
	ENTRY_TYPE_RFC = 1,
	ENTRY_TYPE_MAX,
	ENTRY_TYPE_INVALID = ENTRY_TYPE_MAX,
	ENTRY_TYPE_NONE
};

struct metadata_entry *
metadata_entry_alloc(struct mailbox *mailbox, const char *name, const char *value)
	ATTR_NONNULL(2);

void
metadata_entry_free(struct metadata_entry *entry)
	ATTR_NONNULL(1);

bool
metadata_entry_is_valid(struct metadata_entry *entry)
	ATTR_NONNULL(1);

const char *
metadata_entry_get_name(struct metadata_entry *entry)
	ATTR_NONNULL(1);

const char *
metadata_entry_get_value(struct metadata_entry *entry)
	ATTR_NONNULL(1);

enum metadata_entry_subject
metadata_entry_get_subject(struct metadata_entry *entry)
	ATTR_NONNULL(1);

enum metadata_entry_scope
metadata_entry_get_scope(struct metadata_entry *entry)
	ATTR_NONNULL(1);

enum metadata_entry_type
metadata_entry_get_type(struct metadata_entry *entry)
	ATTR_NONNULL(1);

#endif
