/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.adl.util.debug.DebugIndicator;

public class CMIRequest
implements Serializable {
    private String request;
    private String model;
    private String baseCategory;
    private int numSub = 10;
    private String[] subcategory;
    private int numOfSubCategories = 0;
    private int numOfSubCatReturned = 0;
    private int numInd = 10;
    private Integer[] index;
    private int numOfInd = 0;
    private int numOfIndReturned = 0;
    private String element;
    private String setValue;
    private int totalNumberOfTokens = 0;
    private int tokensRequested = 1;
    private int tokensProcessed = 0;
    private boolean getRequest;
    private boolean setRequest;
    private int numPat = 10;
    private Integer[] pattern;
    private static int MODEL = 1;
    private static int BASE_CATEGORY = 2;
    private static int SUB_CATEGORY = 3;
    private static int ARRAY_INDEX = 4;
    private static int ELEMENT = 5;
    private static int VALUE = 6;
    static int pattern_counter = 2;

    static void incrementPatternCount() {
        ++pattern_counter;
    }

    static void resetPatternCounter() {
        pattern_counter = 2;
    }

    public CMIRequest(String theRequest, boolean getRequestFlag) {
        if (DebugIndicator.ON) {
            if (getRequestFlag) {
                System.out.println("Building CMIRequest for a LMSGetValue(" + theRequest + ") ");
            } else {
                System.out.println("Building CMIRequest for a LMSSetValue(" + theRequest + ") ");
            }
        }
        this.request = theRequest;
        this.model = new String("");
        this.baseCategory = new String("");
        this.element = new String("");
        this.setValue = new String("");
        this.getRequest = getRequestFlag;
        this.index = new Integer[this.numInd];
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = new Integer(-1);
        }
        this.pattern = new Integer[this.numPat];
        for (int j = 0; j < this.pattern.length; ++j) {
            this.pattern[j] = new Integer(-1);
        }
        this.subcategory = new String[this.numSub];
        for (int z = 0; z < this.subcategory.length; ++z) {
            this.subcategory[z] = new String("-1");
        }
        String theSetValue = new String("");
        String theNewRequest = new String("");
        if (this.getRequest) {
            this.setRequest = false;
            this.parseGetRequest(theRequest);
        } else {
            this.setRequest = true;
            StringTokenizer setTok = new StringTokenizer(theRequest, ",", false);
            int numTokensForSet = setTok.countTokens();
            int numTokensProcessed = 0;
            theNewRequest = setTok.nextToken();
            ++numTokensProcessed;
            if (DebugIndicator.ON) {
                System.out.println("Request: [" + theNewRequest + "]");
            }
            if (numTokensForSet == 1) {
                theSetValue = new String("");
            } else {
                while (numTokensProcessed < numTokensForSet) {
                    theSetValue = theSetValue + setTok.nextToken();
                    if (++numTokensProcessed == numTokensForSet) continue;
                    theSetValue = theSetValue + ",";
                }
                if (DebugIndicator.ON) {
                    System.out.println("Set Value: [" + theSetValue + "]");
                }
            }
            ++this.totalNumberOfTokens;
            this.parseSetRequest(theNewRequest, theSetValue);
        }
        if (DebugIndicator.ON) {
            this.showRequest();
        }
    }

    public String getModel() {
        return this.model;
    }

    public boolean isForASetRequest() {
        return this.setRequest;
    }

    public boolean isAKeywordRequest() {
        boolean result = false;
        if (this.isAChildrenRequest() || this.isACountRequest() || this.isAVersionRequest()) {
            result = true;
        }
        return result;
    }

    public boolean isAChildrenRequest() {
        boolean result = false;
        if (this.element.equals("_children")) {
            result = true;
        }
        return result;
    }

    public boolean isACountRequest() {
        boolean result = false;
        if (this.element.equals("_count")) {
            result = true;
        }
        return result;
    }

    public boolean isAVersionRequest() {
        boolean result = false;
        if (this.element.equals("_version")) {
            result = true;
        }
        return result;
    }

    public String getRequest() {
        return this.request;
    }

    public String getBaseCategory() {
        ++this.tokensRequested;
        return this.baseCategory;
    }

    public String getValue() {
        return this.setValue;
    }

    public String getElement() {
        return this.element;
    }

    public int getTotalNumTokens() {
        return this.totalNumberOfTokens;
    }

    public int getNumSubCat() {
        return this.numOfSubCategories;
    }

    public int getNumIndices() {
        return this.numOfInd;
    }

    public Integer getIndex(int position) {
        return this.index[position];
    }

    public String getSubCategory(int position) {
        String subCat = new String("-1");
        if (position >= 0 && position < 10) {
            subCat = this.subcategory[position];
        }
        return subCat;
    }

    private void parseGetRequest(String theRequest) {
        StringTokenizer stk = new StringTokenizer(theRequest, ".", false);
        this.totalNumberOfTokens += stk.countTokens();
        this.model = stk.nextToken();
        ++this.tokensProcessed;
        this.pattern[0] = new Integer(MODEL);
        this.baseCategory = stk.nextToken();
        ++this.tokensProcessed;
        this.pattern[1] = new Integer(BASE_CATEGORY);
        if (stk.hasMoreTokens()) {
            boolean done = false;
            while (!done) {
                if (this.onLastToken()) {
                    int tmpIndex;
                    String temp = stk.nextToken();
                    try {
                        Integer tmpInt = new Integer(temp);
                        tmpIndex = this.findNextIndexLoc();
                        this.index[tmpIndex] = tmpInt;
                        ++this.numOfInd;
                        int tmpIndex1 = this.findNextPatternLoc();
                        this.pattern[tmpIndex1] = new Integer(ARRAY_INDEX);
                        this.element = this.subcategory[this.numOfSubCategories - 1];
                        tmpIndex1 = this.findNextPatternLoc();
                        this.pattern[tmpIndex1] = new Integer(ELEMENT);
                    }
                    catch (NumberFormatException nfe) {
                        this.element = temp;
                        tmpIndex = this.findNextPatternLoc();
                        this.pattern[tmpIndex] = new Integer(ELEMENT);
                    }
                    ++this.tokensProcessed;
                    done = true;
                    continue;
                }
                this.determineNextToken(stk);
            }
        } else {
            this.element = this.baseCategory;
        }
    }

    private void parseSetRequest(String theRequest, String theSetValue) {
        if (DebugIndicator.ON) {
            System.out.println("In CMIRequest::parseSetRequest");
        }
        StringTokenizer stk = new StringTokenizer(theRequest, ".", false);
        this.totalNumberOfTokens += stk.countTokens();
        this.model = stk.nextToken();
        ++this.tokensProcessed;
        this.pattern[0] = new Integer(MODEL);
        this.baseCategory = stk.nextToken();
        ++this.tokensProcessed;
        this.pattern[1] = new Integer(BASE_CATEGORY);
        if (stk.hasMoreTokens()) {
            boolean done = false;
            while (!done) {
                int tmpIndex;
                if (this.onLastToken()) {
                    this.setValue = theSetValue;
                    ++this.tokensProcessed;
                    tmpIndex = this.findNextPatternLoc();
                    this.pattern[tmpIndex] = new Integer(VALUE);
                    done = true;
                    continue;
                }
                if (this.totalNumberOfTokens - this.tokensProcessed == 2) {
                    this.element = stk.nextToken();
                    ++this.tokensProcessed;
                    tmpIndex = this.findNextPatternLoc();
                    this.pattern[tmpIndex] = new Integer(ELEMENT);
                    continue;
                }
                this.determineNextToken(stk);
            }
        } else {
            this.setValue = theSetValue;
            ++this.tokensProcessed;
            int tmpIndex = this.findNextPatternLoc();
            this.pattern[tmpIndex] = new Integer(VALUE);
        }
    }

    private void determineNextToken(StringTokenizer stk) {
        String temp = stk.nextToken();
        ++this.tokensProcessed;
        try {
            Integer tmpInt = new Integer(temp);
            int tmpIndex = this.findNextIndexLoc();
            this.index[tmpIndex] = tmpInt;
            ++this.numOfInd;
            int tmpIndex1 = this.findNextPatternLoc();
            this.pattern[tmpIndex1] = new Integer(ARRAY_INDEX);
        }
        catch (NumberFormatException nfe) {
            int tmpIndex = this.findNextSubLoc();
            this.subcategory[tmpIndex] = temp;
            ++this.numOfSubCategories;
            int tmpIndex1 = this.findNextPatternLoc();
            this.pattern[tmpIndex1] = new Integer(SUB_CATEGORY);
        }
    }

    private boolean onLastToken() {
        boolean rtrnFlag = false;
        if (this.totalNumberOfTokens - this.tokensProcessed == 1) {
            rtrnFlag = true;
        }
        return rtrnFlag;
    }

    public String getNextToken() {
        String rtrnValue = new String("");
        try {
            Integer tmpPat = this.pattern[pattern_counter];
            int tmpPattern = tmpPat;
            if (tmpPattern == SUB_CATEGORY) {
                try {
                    rtrnValue = this.subcategory[this.numOfSubCatReturned];
                    ++this.numOfSubCatReturned;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    System.out.println(ioobe);
                }
            } else if (tmpPattern == ARRAY_INDEX) {
                try {
                    Integer tmpIndex = this.index[this.numOfIndReturned];
                    ++this.numOfIndReturned;
                    rtrnValue = tmpIndex.toString();
                }
                catch (IndexOutOfBoundsException ioobe) {
                    System.out.println(ioobe);
                }
            } else if (tmpPattern == ELEMENT) {
                rtrnValue = this.element;
                CMIRequest.resetPatternCounter();
            } else if (tmpPattern == VALUE) {
                rtrnValue = this.setValue;
            }
            if (tmpPattern != ELEMENT) {
                CMIRequest.incrementPatternCount();
            }
            ++this.tokensRequested;
        }
        catch (IndexOutOfBoundsException ioobe) {
            System.out.println(ioobe);
        }
        return rtrnValue;
    }

    public boolean hasMoreTokensToProcess() {
        boolean rtrnFlag = true;
        if (this.setRequest) {
            if (this.totalNumberOfTokens - 1 - this.tokensRequested == 0) {
                rtrnFlag = false;
            }
        } else if (this.totalNumberOfTokens - this.tokensRequested == 0) {
            rtrnFlag = false;
        }
        return rtrnFlag;
    }

    public void done() {
        CMIRequest.resetPatternCounter();
        this.tokensRequested = 1;
        this.numOfSubCatReturned = 0;
        this.numOfIndReturned = 0;
    }

    private int findNextPatternLoc() {
        int result = -1;
        int value = -1;
        for (int i = 0; i <= this.numPat; ++i) {
            if (value != this.pattern[i]) continue;
            result = i;
            break;
        }
        return result;
    }

    private int findNextIndexLoc() {
        int result = -1;
        int value = -1;
        for (int i = 0; i <= this.numInd; ++i) {
            if (value != this.index[i]) continue;
            result = i;
            break;
        }
        return result;
    }

    private int findNextSubLoc() {
        int result = -1;
        String tmpString = new String("-1");
        for (int i = 0; i <= this.numSub; ++i) {
            if (!this.subcategory[i].equalsIgnoreCase(tmpString)) continue;
            result = i;
            break;
        }
        return result;
    }

    public void showRequest() {
        if (DebugIndicator.ON) {
            System.out.println("Base Category: " + this.baseCategory);
            System.out.println("Element: " + this.element);
            System.out.println("Model: " + this.model);
            System.out.println("Number of Indices: " + this.numOfInd);
            System.out.println("Number of SubCategories: " + this.numOfSubCategories);
            for (int i = 0; i < this.numOfSubCategories; ++i) {
                System.out.println("Subcategory[" + i + "]: " + this.subcategory[i]);
            }
            for (int j = 0; j < this.numOfInd; ++j) {
                System.out.println("Index[" + j + "]: " + this.index[j]);
            }
            for (int x = 0; x < this.numPat; ++x) {
                if (this.pattern[x] <= -1) continue;
                System.out.println("Pattern[" + x + "]: " + this.pattern[x]);
            }
            if (this.isForASetRequest()) {
                System.out.println("Set Value: " + this.setValue);
            }
        }
    }
}

