# Generated by Django 4.0a1 on 2021-09-22 18:51

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Occupation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=200)),
                ("boolean", models.BooleanField(null=True)),
                (
                    "boolean_with_choices",
                    models.BooleanField(choices=[(True, "Yes"), (False, "No")], null=True),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Person",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("first_name", models.CharField(max_length=200)),
                ("last_name", models.CharField(max_length=200, verbose_name="surname")),
                (
                    "trans_test",
                    models.CharField(blank=True, max_length=200, verbose_name="translation test"),
                ),
                (
                    "trans_test_lazy",
                    models.CharField(
                        blank=True, max_length=200, verbose_name="translation test lazy"
                    ),
                ),
                ("safe", models.CharField(blank=True, max_length=200, verbose_name="<b>Safe</b>")),
                ("website", models.URLField(blank=True, null=True, verbose_name="web site")),
                ("birthdate", models.DateField(null=True)),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                ("friends", models.ManyToManyField(to="app.Person")),
                (
                    "occupation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="people",
                        to="app.occupation",
                        verbose_name="occupation of the person",
                    ),
                ),
            ],
            options={
                "verbose_name": "person",
                "verbose_name_plural": "people",
            },
        ),
        migrations.CreateModel(
            name="Region",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=200)),
                (
                    "mayor",
                    models.OneToOneField(
                        null=True, on_delete=django.db.models.deletion.CASCADE, to="app.person"
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="PersonInformation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="info_list",
                        to="app.person",
                        verbose_name="Information",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="occupation",
            name="region",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, to="app.region"
            ),
        ),
        migrations.CreateModel(
            name="Group",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=200)),
                ("members", models.ManyToManyField(to="app.Person")),
            ],
        ),
        migrations.CreateModel(
            name="PersonProxy",
            fields=[],
            options={
                "ordering": ("last_name",),
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("app.person",),
        ),
    ]
