/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "delay.h"
#include "utils.h"
#include <string.h>
#include <stdlib.h>
#include <iostream>
using namespace std;

void delay::zero () {
  nsamples = 0;
  samples = 0;
  fbk = 0;
  vol = 0;
  id = 0;
}

delay::delay (float t, const string& fn, const string& vn) :

fbk_fname (fn), vol_fname (vn), fbk_crv (fn), vol_crv (vn),
fbk_lis (this, &fbk_sol, fbk), vol_lis (this, &vol_sol, vol)

{

  zero ();

  fbk_sol (&fbk_crv);
  vol_sol (&vol_crv);

  set (t);

}

delay::~delay() {

  float* bf [3] = {samples, fbk, vol};

  for (int i = 0; i < 3; ++i) if (bf[i]) {
    free (bf[i]);
  }

  fbk_crv.save (fbk_fname);
  vol_crv.save (vol_fname);

}

void delay::check_buffer () {
  static const float thou_1 = 1./1000;
  static const int size_of_float = sizeof (float);
  extern int SAMPLE_RATE;
  int n = (int) (msecs * SAMPLE_RATE * thou_1 + 0.5);
  if (n < 1) n = 1;
  if (n > nsamples) {
    float** nbf[3] = {&samples, &fbk, &vol};
    for (int i = 0; i < 3; ++i) {
      if (nbf[i]) free (*nbf[i]);
      *nbf[i] = (float *) calloc (n, size_of_float);
    }
  }
  nsamples = n;
  clamp<int>(0, id, nsamples);
}

void delay::set (float t) {
  msecs = t;
  check_buffer ();
  float dx = 1./(nsamples - 1), x = -dx;
  fbk_sol (x, dx, nsamples, fbk);
  vol_sol (x, dx, nsamples, vol);
  fbk_lis.result = fbk;
  vol_lis.result = vol;
}

void delay::get (float& t) {
  t = msecs;
}

void delay::operator() (float* out, int n, float fdr) {

  float f;
  for (int i = 0; i < n; ++i) {
    f = out[i] + fbk[id] * samples[id];
    out[i] += (fdr * vol[id] * f);
    samples[id] = f;
    if (++id >= nsamples) id = 0;
  }
}

