class MirrorFailure(Exception):
	pass

class DependencyResolutionFailure(MirrorFailure):
	def __init__(self, badDepsByPackage):
		self._badDepsByPackage = badDepsByPackage
		MirrorFailure.__init__(self)

	def format(self, prefix=None, linePrefix=""):
		lines = []
		if prefix is not None:
			lines.append(prefix)

		def renderDep(dep):
			return "".join(dep)

		def renderAlternatives(deps):
			return "|".join([renderDep(x) for x in deps])

		for packageName, dependencies in self._badDepsByPackage.iteritems():
			lines.append("%s%s needs [%s]" % (linePrefix, packageName, ",".join(
				[renderAlternatives(x) for x in dependencies]
			)))
		return "\n".join(lines)

