//
// C++ Implementation: session
//
// Description: 
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "session.h"
#include "userlistmodel.h"
#include <QtGui>
#include <QMenu>

Session::Session(int aId,
				 QWidget *parent)
: QWidget(parent),
  contextMenu(new QMenu(this)), 
  myId(aId)
{
	ui.setupUi(this);
	userModel = new UserListModel;
	ui.userView->setModel(userModel);

	ui.userView->header()->setClickable(true);
    ui.userView->header()->setSortIndicatorShown(true);
	
	createMenu();
}


Session::~Session()
{
	delete userModel;
}

void Session::onFailed( const QString &reason )
{
	ui.mainChat->append(reason);
}

void Session::onPrivateChatMessage( const QString & /*from*/, const QString & msg )
{
	ui.mainChat->append(QString(tr("Private Message: ")) + msg);
}

void Session::onUsersUpdated( QList<User*> users )
{
	userModel->enableUpdateSignals( false );
	for(int i=0;i < users.size();i++)
		userModel->setUser( users[i] );	
	userModel->enableUpdateSignals( true );
	userModel->signalLayoutChanged();
}

void Session::onUserRemoved( int id )
{
	userModel->removeUser(id);
}

void Session::onChatMessage( const QString &msg )
{
	ui.mainChat->append(msg);
}

void Session::onHubStats( qint64 totshared )
{
	shared = totshared;
}

void Session::onGetFileList()
{
	QModelIndexList selected = ui.userView->selectionModel()->selectedIndexes();
	// We should only have one selected item
	getFileList(selected.front());
}

void Session::on_chatEdit_returnPressed( )
{
	if( ui.chatEdit->text().length() > 0 )
		emit sendChat(myId,ui.chatEdit->text());
	ui.chatEdit->clear();
}

void Session::on_userView_doubleClicked( const QModelIndex& index )
{
	getFileList( index );
}

void Session::on_userView_customContextMenuRequested( const QPoint& pos )
{
	// Show the menu
	contextMenu->popup( ui.userView->mapToGlobal(pos) );
}

void Session::createMenu()
{	
	QAction* getFileListAct = contextMenu->addAction( tr("Get file list") );
	connect( getFileListAct, SIGNAL(triggered()), this, SLOT(onGetFileList()) );
	
	QAction* sendMsgAct = contextMenu->addAction( tr("Open private chat") );
	connect( sendMsgAct, SIGNAL(triggered()), this, SLOT(onOpenChat()) );
	
	QAction* addFavUserAct = contextMenu->addAction( tr("Add to favourites") );
	connect( addFavUserAct, SIGNAL(triggered()), this, SLOT( onAddFav() ) );
}


void Session::getFileList( const QModelIndex& index )
{
	if( index.isValid() ) {
		emit getUserFileList(userModel->getUser(index)->id);
	}	
}

