{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetSpeed: Single;
    procedure SetSpeed(const Value: Single);
    function GetVariation: Single;
    procedure SetVariation(const Value: Single);
    function GetMass: Single;
    procedure SetMass(const Value: Single);
    function GetSurfaceArea: Single;
    procedure SetSurfaceArea(const Value: Single);
  public
    { X3D field "speed". } { }
    property Speed: Single read GetSpeed write SetSpeed;
    { X3D field "variation". } { }
    property Variation: Single read GetVariation write SetVariation;
    { X3D field "mass". } { }
    property Mass: Single read GetMass write SetMass;
    { X3D field "surfaceArea". } { }
    property SurfaceArea: Single read GetSurfaceArea write SetSurfaceArea;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractParticleEmitterNode ----------------------------------------------- }

function TAbstractParticleEmitterNode.GetSpeed: Single;
begin
  Result := FdSpeed.Value;
end;

procedure TAbstractParticleEmitterNode.SetSpeed(const Value: Single);
begin
  FdSpeed.Send(Value);
end;

function TAbstractParticleEmitterNode.GetVariation: Single;
begin
  Result := FdVariation.Value;
end;

procedure TAbstractParticleEmitterNode.SetVariation(const Value: Single);
begin
  FdVariation.Send(Value);
end;

function TAbstractParticleEmitterNode.GetMass: Single;
begin
  Result := FdMass.Value;
end;

procedure TAbstractParticleEmitterNode.SetMass(const Value: Single);
begin
  FdMass.Send(Value);
end;

function TAbstractParticleEmitterNode.GetSurfaceArea: Single;
begin
  Result := FdSurfaceArea.Value;
end;

procedure TAbstractParticleEmitterNode.SetSurfaceArea(const Value: Single);
begin
  FdSurfaceArea.Send(Value);
end;

{$endif read_implementation}
