size_t StreamBuf::getOffset()
{
    size_t offs;

    switch (d_last)
    {
        default:        // no buffers so far: use offset
            offs = offset;
        break;

        case READ:      // use the lastused read offset
            offs = bufbeg + (gptr() - eback());
            setg(0, 0, 0);
        break;

        case WRITE:     // use the lastused write offset
            offs = bufbeg + (pptr() - pbase());
            setp(0, 0);
        break;
    }

    bufLimits(offs);  // set the buffer limits

    return offs;
}
