#!/usr/bin/env python

from distutils.core import (
    Command,
    setup,
    )
import subprocess
import sys


class Check(Command):
    description = "run all tests or a single test module"
    user_options = [
        ('module=', 'm', 'The test module to run'),
        ]

    def initialize_options(self):
        self.module = 'discover'

    def finalize_options(self):
        self.module = [self.module]

    def run(self):
        command = [sys.executable, '-m', 'testtools.run']
        command += self.module
        raise SystemExit(subprocess.call(command))


if __name__ == '__main__':
    setup(name="bzr-dbus",
      version="0.1~",
      description="dbus core plugin for bzr.",
      author="Robert Collins",
      author_email="robert.collins@canonical.com",
      license="GPLV2",
      url="https://launchpad.net/bzr-dbus",
      data_files=[('share/dbus-1/services',
          ['org.bazaarvcs.plugins.dbus.Broadcast.service'])],
      packages=['bzrlib.plugins.dbus',
                'bzrlib.plugins.dbus.tests',
                ],
      package_dir={'bzrlib.plugins.dbus': '.'},
      cmdclass={'check': Check},
      )
