# Search for installed software required by BornAgain

# list of extra dependencies (needed for a self-contained package)
set(BA_Dependencies "")

if(WIN32)
    set(CMAKE_FIND_LIBRARY_SUFFIXES .dll.a .lib)
endif()

find_package(LibHeinz 2.0.0 REQUIRED CONFIG)
message(STATUS "LibHeinz: version=${LibHeinz_VERSION}, incl=${LibHeinz_INCLUDE_DIR}")

find_package(formfactor 0.3.0 REQUIRED CONFIG)
# absolute path is needed for deployment in Python wheel
get_target_property(formfactor_LIBRARIES formfactor IMPORTED_LOCATION_RELEASE)
if(NOT formfactor_LIBRARIES)
    get_target_property(formfactor_LIBRARIES formfactor IMPORTED_LOCATION_NOCONFIG)
endif()
if(NOT formfactor_LIBRARIES)
    message(FATAL_ERROR "Formfactor libraries not found (path: '${formfactor_DIR}').")
endif()
message(STATUS "formfactor: version=${formfactor_VERSION}, incl=${formfactor_INCLUDE_DIR}, "
    "lib=${formfactor_LIBRARIES}")

list(APPEND BA_Dependencies "${formfactor_LIBRARIES}")

find_package(Threads REQUIRED)
find_package(FFTW3 REQUIRED)

list(APPEND BA_Dependencies "${FFTW3_LIBRARIES}")

find_package(GSL REQUIRED)
message(STATUS "GSL: version=${GSL_VERSION}, incl=${GSL_INCLUDE_DIR}, libs=${GSL_LIBRARIES}")

list(APPEND BA_Dependencies "${GSL_LIBRARIES}")

if(WIN32)
    find_package(cerf CONFIG REQUIRED COMPONENTS shared CXX)
    add_compile_definitions(CERF_AS_CPP=ON)
    get_property(Cerf_LIBRARIES TARGET cerf::cerfcpp PROPERTY LOCATION)
    message(STATUS "cerf: C++ version = ${cerf_VERSION}, lib=${Cerf_LIBRARIES}")
    set(cerf_target cerf::cerfcpp)
else()
    # For the time being, under *nix we request the C version of libcerf.
    find_package(cerf CONFIG REQUIRED COMPONENTS shared C)
    get_property(Cerf_LIBRARIES TARGET cerf::cerf PROPERTY LOCATION)
    message(STATUS "cerf: C version = ${cerf_VERSION}, lib=${Cerf_LIBRARIES}")
    set(cerf_target cerf::cerf)
endif()

list(APPEND BA_Dependencies "${Cerf_LIBRARIES}")

# --- Boost ---
set(Boost_NO_BOOST_CMAKE ON) # prevent shortcut
set(Boost_USE_STATIC_LIBS OFF)
set(Boost_USE_MULTITHREADED ON)
set(Boost_USE_STATIC_RUNTIME OFF)
add_definitions(-DBOOST_ALL_DYN_LINK) # line is needed for MSVC
add_definitions(-DBOOST_UUID_FORCE_AUTO_LINK) # line is needed to link bcrypt for MSVC
# amends problems with bimap and MSVC, serialization of bimap is currently not needed
add_definitions(-DBOOST_BIMAP_DISABLE_SERIALIZATION)

# Boost component libraries (do not list headers here)
set(boost_libraries_required iostreams program_options)

if(WIN32)
    # On Windows, additional libaries are required for Boost::iostream
    list(APPEND boost_libraries_required zlib bzip2)
endif()

message(STATUS "Boost required libraries: ${boost_libraries_required}")
find_package(Boost 1.65.1 COMPONENTS ${boost_libraries_required})
# remove the extra added library Boost::regex
# NOTE: The CMake `FindBoost` module internally adds Boost::regex as an extra dependency for Boost::iostream; yet this is unnecessary;
# see <https://gitlab.kitware.com/cmake/cmake/-/issues/23406>
list(FILTER Boost_LIBRARIES EXCLUDE REGEX "regex")

message(STATUS "Boost: includes at ${Boost_INCLUDE_DIRS}, libraries at ${Boost_LIBRARY_DIRS}")
message(STATUS "Boost libraries: ${Boost_LIBRARIES}; ${Boost_Additional_Libraries}")

if(NOT Boost_FOUND)
    message(FATAL_ERROR "Not all required Boost component libraries were found")
endif()

list(APPEND BA_Dependencies "${Boost_LIBRARIES}")

# === optional packages ===

# --- Tiff ---
if(BA_TIFF_SUPPORT)
    message(STATUS "Looking for libtiff (use -DBA_TIFF_SUPPORT=OFF to disable)")
    find_package(TIFF 4.0.2 REQUIRED COMPONENTS CXX)

    list(APPEND BA_Dependencies "${TIFF_LIBRARIES}")
endif()
