//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/IShape2DView.h
//! @brief     Defines interface IShape2DView.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_ISHAPE2DVIEW_H
#define BORNAGAIN_GUI_VIEW_MASK_ISHAPE2DVIEW_H

#include "GUI/View/Mask/MaskEditorHelper.h"
#include <QGraphicsObject>
#include <QPainter>

class MaskItemObject;
class ISceneAdaptor;

//! Main interface class for views representing MaskItems, Projections on graphics scene.

class IShape2DView : public QGraphicsObject {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::IMASKVIEW; }

    QRectF boundingRect() const override;

    virtual MaskItemObject* parameterizedItem() const = 0;

    void setSceneAdaptor(const ISceneAdaptor* adaptor);

    virtual void addView(IShape2DView* childView);

protected slots:
    //! update visual appearance of view (triggered by ISceneAdaptor)
    virtual void update_view() = 0;
    virtual void onChangedX() {}
    virtual void onChangedY() {}
    virtual void onPropertyChange() {}

protected:
    explicit IShape2DView(MaskItemObject* item);

    void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*) override;

    //! Returns the shape with all masking already applied.
    QPainterPath maskedShape() const;

    qreal toSceneX(qreal value) const;
    qreal toSceneY(qreal value) const;

    //! convert scene coordinates to ColorMap plot coordinates
    qreal fromSceneX(qreal value) const;
    qreal fromSceneY(qreal value) const;
    void setBlockOnProperty(bool value);
    bool blockOnProperty() const;

    const ISceneAdaptor* m_adaptor;
    QRectF m_bounding_rect;
    bool m_block_on_property_change;

private:
    void onGeometryChange();
    void onVisibilityChange();
};

#endif // BORNAGAIN_GUI_VIEW_MASK_ISHAPE2DVIEW_H
