    // by X
inline char *MemoryBridge::beginPtr()
{
    return requireAccess().beginPtr();
}

    // by X
inline std::streamsize MemoryBridge::blockBegin() const
{
    return requireAccess().blockBegin();
}

    // by X
inline std::streamsize MemoryBridge::blockEnd() const
{
    return requireAccess().blockEnd();
}

    // by X
inline std::streamsize MemoryBridge::blockSize() const
{
    return requireAccess().blockEnd() - requireAccess().blockBegin();
}

    // by X
inline void MemoryBridge::bufLimits()
{
    requireAccess().bufLimits(d_offset);
}

    // by sharedbuf/info.f
inline void MemoryBridge::info(std::ostream &out) const
{
    requireAccess().info(out);
}

    // by memorybuf/underflow.cc memorybuf/overflow.cc
inline char *MemoryBridge::endPtr()
{
    return requireAccess().endPtr();
}

    // by memorybuf/underflow.cc memorybuf/xsgetn.cc
inline char *MemoryBridge::endReadPtr()
{
    return requireAccess().endReadPtr(d_offset);
}

    // by memorybuf/overflow.cc
inline void MemoryBridge::extend()
{
    d_accessPtr = requireAccess().extend(d_offset, d_accessPtr);
}

    // by memorybuf/memorybuf.f  id()
inline int MemoryBridge::id() const
{
    return requireAccess().id();
}

    // by memorybuf/underflow.cc
inline bool MemoryBridge::load()
{
    return requireAccess().load(d_offset);
}

    // by memorybuf/overflow.cc, memorybuf/maxend.f
inline std::streamsize MemoryBridge::maxEnd() const
{
    return requireAccess().maxEnd();
}

    // by
inline std::streamsize MemoryBridge::offset() const
{
    return d_offset;
}

    // by
inline void MemoryBridge::offset(std::streamsize pos)
{
    d_offset = pos;
}

    // by memorybuf/underflw.cc
inline char *MemoryBridge::offsetPtr()
{
    return requireAccess().offsetPtr(d_offset);
}

    // by many .f files and some .cc files
// static
inline MemoryAccess &MemoryBridge::requireAccess() const
{
    return *(this->*d_access)();
}

inline void MemoryBridge::setErase(bool erase)
{
    d_erase = erase;
}

    // by memorybuf/truncate.f
inline void MemoryBridge::truncate(std::streamsize size)
{
    requireAccess().truncate(size);
}

    // by X
inline size_t MemoryBridge::write(char const *dest, std::streamsize len)
{
    return requireAccess().write(dest, len, d_offset);
}

    // by memorybuf/writtenuntil.f
inline std::streamsize MemoryBridge::writtenUntil() const
{
    return requireAccess().writtenUntil();
}

    // by X
    // nUsed: # positions currently used in MemoryBuf's setp buffer
inline void MemoryBridge::writtenUntil(std::streamsize offset)
{
    return requireAccess().writtenUntil(offset);
}
