# Copyright 2018 OpenStack Foundation.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""resource_properties_in_instance_plugin

Revision ID: c0ae6b08b0d7
Revises: 75a74e4539cb
Create Date: 2018-03-19 08:02:03.269871

"""

# revision identifiers, used by Alembic.
revision = 'c0ae6b08b0d7'
down_revision = '75a74e4539cb'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects.mysql import MEDIUMTEXT


def MediumText():
    return sa.Text().with_variant(MEDIUMTEXT(), 'mysql')


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('instance_reservations',
                  sa.Column('resource_properties',
                            MediumText(), nullable=True, default=""))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('instance_reservations', 'resource_properties')
    # ### end Alembic commands ###
