#!/usr/bin/env python3
#
# Copyright 2018 WebAssembly Community Group participants
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import sys

input_file = sys.argv[1]
output_file = sys.argv[2]

with open(input_file) as f:
    wat = f.read()

output = """\
// Automatically generated by embedwat.py

#include "passes/intrinsics-module.h"

static const char theModule[%d] = {
""" % (len(wat) + 1)

for c in wat:
    output += str(ord(c)) + ', '

output += '''0
};

namespace wasm {
const char* IntrinsicsModuleWast = theModule;
}
'''

with open(output_file, 'w') as f:
    f.write(output)
