if (typeof Test === 'undefined') require('../tester');

Test('absoluteValue', function () {

    function t(expected, value){
        Test.areEqual(String(expected), new BigNumber(String(value)).absoluteValue().toString());
    }

    Test.areEqual(BigNumber.prototype.absoluteValue, BigNumber.prototype.abs);

    BigNumber.config({
        DECIMAL_PLACES: 20,
        ROUNDING_MODE: 4,
        RANGE: 1E9,
        EXPONENTIAL_AT: [-7, 21]
    });

    t(1, 1);
    t(1, -1);
    t(0.5, '0.5');
    t(0.5, '-0.5');
    t(0.1, 0.1);
    t(0.1, -0.1);
    t(1.1, 1.1);
    t(1.1, -1.1);
    t(1.5, '1.5');
    t(1.5, '-1.5');

    t(0.00001, '-1e-5');
    t(9000000000, '-9e9');
    t(123456.7891011, -123456.7891011);
    t(999.999, '-999.999');
    t(99, 99);
    t(1, new BigNumber(-1));
    t(0.001, new BigNumber(0.001));
    t(0.001, new BigNumber('-0.001'));

    t('Infinity', Infinity);
    t('Infinity', -Infinity);
    t(NaN, NaN);
    t(NaN, -NaN);
    t(0, 0);
    t(0, -0);

    var minusZero = 1 / (-1 / 0);

    t(0, 0);
    t(0, -0);
    t(0, minusZero);

    Test.areEqual('-0', new BigNumber('-0').valueOf());
    Test.areEqual('-0', new BigNumber(-0).valueOf());
    Test.areEqual('-0', new BigNumber(minusZero).valueOf());
    Test.areEqual('0', new BigNumber(-0).abs().valueOf());
    Test.areEqual('0', new BigNumber(minusZero).abs().valueOf());
    Test.areEqual('0', new BigNumber('-0').abs().valueOf());

    BigNumber.config({EXPONENTIAL_AT: 100});

    t(Number.MIN_VALUE, Number.MIN_VALUE);
    t(Number.MIN_VALUE, -Number.MIN_VALUE);
    t(Number.MAX_VALUE, Number.MAX_VALUE);
    t(Number.MAX_VALUE, -Number.MAX_VALUE);

    var two_30 = 1 << 30;

    t(two_30, two_30);
    t(two_30, -two_30);

    t(two_30 + 1, two_30 + 1);
    t(two_30 + 1, -two_30 - 1);

    t(two_30 - 1, two_30 - 1);
    t(two_30 - 1, -two_30 + 1);

    var two_31 = 2 * two_30;

    t(two_31, two_31);
    t(two_31, -two_31);

    t(two_31 + 1, two_31 + 1);
    t(two_31 + 1, -two_31 - 1);

    t(two_31 - 1, two_31 - 1);
    t(two_31 - 1, -two_31 + 1);

    BigNumber.config({ EXPONENTIAL_AT: [-7, 21] });

    t(NaN, 'NaN');
    t('0', '0');
    t('1', '-1');
    t('11.121', '11.121');
    t('0.023842', '-0.023842');
    t('1.19', '-1.19');
    t('9.622e-11', '-0.00000000009622');
    t('5.09e-10', '-0.000000000509');
    t('3838.2', '3838.2');
    t('127', '127.0');
    t('4.23073', '4.23073');
    t('2.5469', '-2.5469');
    t('29949', '-29949');
    t('277.1', '-277.10');
    t('4.97898e-15', '-0.00000000000000497898');
    t('53.456', '53.456');
    t('100564', '-100564');
    t('12431.9', '-12431.9');
    t('97633.7', '-97633.7');
    t('220', '220');
    t('188.67', '-188.67');
    t('35', '-35');
    t('2.6', '-2.6');
    t('2.2e-19', '-0.000000000000000000220');
    t('1.469', '-1.469');
    t('150.7', '-150.7');
    t('74', '-74');
    t('3.52e-9', '-0.00000000352');
    t('2221.7', '-2221.7');
    t('0.000004211', '-0.000004211');
    t('1', '-1');
    t('5.886', '-5.886');
    t('16', '16');
    t('4.4493e-9', '0.0000000044493');
    t('47.6', '47.6');
    t('1.6', '-1.60');
    t('1', '-1');
    t('1.5', '-1.5');
    t('5', '-5');
    t('1', '-1');
    t('8027', '8027');
    t('6.36e-16', '-0.000000000000000636');
    t('3.87766', '3.87766');
    t('7.4', '-7.4');
    t('4.449', '-4.449');
    t('5.2218e-19', '-0.000000000000000000522180');
    t('1.3769e-11', '-0.000000000013769');
    t('7.898e-13', '-0.0000000000007898');
    t('522.9', '-522.9');
    t('16.1', '-16.1');
    t('2.15', '2.15');
    t('4.3', '4.3');
    t('3', '-3');
    t('2.8', '-2.8');
    t('1', '-1');
    t('0.0000128696', '-0.0000128696');
    t('13.33', '-13.33');
    t('0.00000132177', '-0.00000132177');
    t('1.41516', '-1.41516');
    t('180.4', '-180.4');
    t('115079', '-115079');
    t('959', '959');
    t('714.4', '714.4');
    t('1.4544', '1.4544');
    t('53.691', '53.691');
    t('2.03832e-12', '-0.00000000000203832');
    t('1', '-1');
    t('10.8', '10.8');
    t('6189.2', '-6189.2');
    t('6.30866', '6.30866');
    t('62306', '62306');
    t('4', '-4.0');
    t('997.1', '-997.1');
    t('27.4', '-27.40');
    t('9242', '9242');
    t('31.1', '-31.1');
    t('23.4', '23.4');
    t('451818', '-451818');
    t('7', '-7');
    t('1.9', '-1.9');
    t('2', '-2');
    t('112.983', '-112.983');
    t('9.36e-8', '-0.0000000936');
    t('12.8515', '12.8515');
    t('73.1', '-73.1');
    t('18.15', '18.150');
    t('11997.8', '11997.8');
    t('23.1', '-23.1');
    t('82.022', '-82.022');
    t('3.916e-20', '-0.00000000000000000003916');
    t('3.3', '-3.3');
    t('892.1', '-892.1');
    t('24.4', '24.4');
    t('72', '72.0');
    t('0.0013346', '0.0013346');
    t('10.4', '-10.4');
    t('367.5', '367.5');
    t('7', '-7');
    t('127.195', '127.195');
    t('7.89e-13', '-0.000000000000789');
    t('63', '-63');
    t('85821.2', '-85821.2');
    t('95.6', '95.6');
    t('8.9e-14', '-0.000000000000089');
    t('112.1', '-112.1');
    t('3.68', '-3.68');
    t('9', '-9');
    t('0.0000975', '-0.0000975');
    t('393.6', '-393.6');
    t('7.4', '-7.4');
    t('69.62', '-69.62');
    t('5201.3', '5201.3');
    t('163', '163');
    t('4.30732', '4.30732');
    t('224.49', '-224.49');
    t('319.8', '-319.8');
    t('88.1', '-88.1');
    t('2.7762e-8', '0.000000027762');
    t('2.043e-7', '-0.0000002043');
    t('75459.3', '-75459.3');
    t('0.178', '0.178');
    t('0.00001633', '0.00001633');
    t('955', '955');
    t('373898', '-373898');
    t('9780.1', '9780.1');
    t('503.47', '503.47');
    t('3.44562', '-3.44562');
    t('1.6', '-1.6');
    t('1.22442', '-1.22442');
    t('1.4', '1.4');
    t('1219.1', '-1219.1');
    t('2.7', '-2.7');
    t('1057', '-1057');
    t('1938', '1938');
    t('1.1983', '1.1983');
    t('0.0012', '-0.0012');
    t('95.713', '-95.713');
    t('2', '-2');
    t('17.24', '-17.24');
    t('10.3', '-10.3');
    t('1', '-1');
    t('65.8', '-65.8');
    t('2.9', '2.9');
    t('54149', '54149');
    t('8', '-8');
    t('1', '1.0');
    t('4', '-4');
    t('6.3', '-6.3');
    t('5.25e-9', '0.00000000525');
    t('52.3', '-52.3');
    t('75290', '-75290');
    t('5.9', '-5.9');
    t('13.7', '13.7');
    t('2.3982e-9', '0.0000000023982');
    t('91.5', '-91.50');
    t('2072.39', '2072.39');
    t('385.6', '385.6');
    t('4.77', '4.77');
    t('18.72', '18.720');
    t('2817', '-2817');
    t('44535', '-44535');
    t('655', '655');
    t('2e-15', '-0.0000000000000020');
    t('0.625', '0.6250');
    t('2', '-2');
    t('5.315', '5.315');
    t('70.9', '70.90');
    t('6.4', '6.4');
    t('1824', '1824');
    t('52.595', '52.595');
    t('3662', '3662.0');
    t('3.1', '3.1');
    t('1.05032e-7', '0.000000105032');
    t('997.063', '-997.063');
    t('41746', '-41746');
    t('24.0402', '24.0402');
    t('0.009135', '0.009135');
    t('2.34e-9', '-0.00000000234');
    t('13.1', '13.1');
    t('228.8', '228.8');
    t('565.85', '565.85');
    t('4e-20', '0.000000000000000000040');
    t('1.73', '1.73');
    t('38.9', '38.9');
    t('1.02e-14', '-0.0000000000000102');
    t('302.8', '-302.8');
    t('7', '-7');
    t('1', '-1');
    t('0.00247', '0.00247');
    t('2', '-2');
    t('3.26', '-3.26');
    t('8.8', '8.8');
    t('90.6', '90.6');
    t('8.3053e-17', '-0.000000000000000083053');
    t('2.5', '-2.5');
    t('376.2', '-376.2');
    t('1.29', '1.29');
    t('1.379', '-1.379');
    t('40921.5', '-40921.5');
    t('1', '-1');
    t('12.5', '12.5');
    t('10.1', '10.1');
    t('1', '-1');
    t('226636', '226636');
    t('1', '-1');
    t('1.7', '-1.7');
    t('31.31', '31.31');
    t('79.9', '-79.9');
    t('4.027e-13', '0.0000000000004027');
    t('43.838', '43.838');
    t('6.47', '-6.47');
    t('5.292e-19', '0.0000000000000000005292');
    t('4.6', '-4.6');
    t('15918', '-15918.0');
    t('239.45', '239.45');
    t('1.02', '-1.02');
    t('14101', '-14101');
    t('7', '-7');
    t('367.34', '367.34');
    t('5', '-5');
    t('19.9', '-19.9');
    t('269.45', '-269.45');
    t('10.34', '-10.34');
    t('3.32882e-12', '-0.00000000000332882');
    t('5.9', '5.9');
    t('9', '-9.0');
    t('1.3597', '-1.3597');
    t('8', '8.0');
    t('1', '1.0');
    t('312.5', '312.5');
    t('1.554', '-1.554');
    t('210.985', '-210.985');
    t('1', '-1');
    t('1.24', '-1.24');
    t('513865', '-513865');
    t('6748', '-6748');
    t('591.51', '-591.51');
    t('2.2', '-2.2');
    t('19.5495', '19.5495');
    t('3.3', '3.3');
    t('30', '-30');
    t('94', '-94');
    t('217.55', '217.55');
    t('2', '-2');
    t('99', '99');
    t('4.067', '-4.067');
    t('702.57', '702.57');
    t('3.7', '-3.70');
    t('4', '4.0');
    t('192944', '192944');
    t('0.000022', '0.000022');
    t('47.6', '47.60');
    t('0.391', '0.3910');
    t('35', '-35');
    t('100', '-100');
    t('3.3', '-3.3');
    t('32.432', '32.432');
    t('1.07849e-18', '0.00000000000000000107849');
    t('2', '-2.0');
    t('23.27', '23.27');
    t('4.054e-15', '-0.000000000000004054');
    t('7.6', '-7.6');
    t('1305', '1305');
    t('1.501', '-1.501');
    t('3.4', '3.4');
    t('22.5', '-22.5');
    t('1.0916', '1.0916');
    t('2', '-2');
    t('58.271', '58.271');
    t('1.73e-12', '0.00000000000173');
    t('1.3458e-15', '0.0000000000000013458');
    t('309.87', '-309.87');
    t('5.318', '-5.318');
    t('1.5302e-8', '0.000000015302');
    t('596765', '596765');
    t('54.42', '-54.42');
    t('6.549e-20', '0.00000000000000000006549');
    t('29', '29');
    t('46.025', '46.025');
    t('2556.78', '-2556.78');
    t('0.00287721', '0.00287721');
    t('1.63', '-1.63');
    t('0.00041', '0.00041');
    t('698', '698');
    t('134.4', '134.4');
    t('2.1', '2.1');
    t('2.07', '-2.07');
    t('122.869', '122.869');
    t('0.00017', '-0.00017');
    t('18.6', '18.6');
    t('7', '-7');
    t('0.0180557', '0.0180557');
    t('5', '-5');
    t('6.2', '-6.2');
    t('8', '-8');
    t('450.96', '-450.96');
    t('20.2', '-20.2');
    t('176.52', '176.52');
    t('0.00017', '-0.000170');
    t('5', '-5');
    t('1', '-1');
    t('1.37856e-14', '0.0000000000000137856');
    t('76.3048', '76.3048');
    t('1803.7', '-1803.7');
    t('74', '74');
    t('1.7e-12', '0.0000000000017');
    t('48.7', '-48.7');
    t('4.48', '-4.48');
    t('1.4', '-1.4');
    t('7.69', '-7.69');
    t('23.5987', '23.5987');
    t('3074', '3074.0');
    t('8.06e-15', '-0.00000000000000806');
    t('21.3757', '-21.3757');
    t('35', '35');
    t('11.056', '11.0560');
    t('3.36e-14', '-0.0000000000000336');
    t('49139.4', '-49139.4');
    t('32.654', '-32.654');
    t('34035.4', '34035.4');
    t('15.22', '15.22');
    t('62', '62.0');
    t('8.89156', '-8.89156');
    t('14', '14');
    t('0.006', '-0.0060');
    t('1.5', '1.5');
    t('7', '-7');
    t('1.6e-11', '0.000000000016');
    t('26.6427', '26.6427');
    t('1.5e-18', '-0.0000000000000000015');
    t('1.52838e-15', '0.00000000000000152838');
    t('119.1', '119.1');
    t('0.004283', '0.004283');
    t('818', '-818');
    t('194', '194');
    t('104.788', '-104.788');
    t('3.74e-11', '0.0000000000374');
    t('6.162', '-6.162');
    t('5.19214e-18', '-0.00000000000000000519214');
    t('1.4', '-1.4');
    t('1.27', '-1.27');
    t('7.83822e-12', '-0.00000000000783822');
    t('1', '-1');
    t('4.4', '4.4');
    t('7.37382e-12', '0.00000000000737382');
    t('13.618', '13.618');
    t('1.03', '-1.03');
    t('3.7457e-13', '0.00000000000037457');
    t('5.2', '-5.2');
    t('3.5', '3.5');
    t('364', '-364');
    t('7.336', '7.336');
    t('1.1447e-16', '-0.00000000000000011447');
    t('510.63', '-510.63');
    t('5.8', '5.8');
    t('7.8', '7.8');
    t('2.96', '-2.96');
    t('15.64', '-15.64');
    t('187863', '-187863');
    t('2.73', '-2.73');
    t('2.671', '-2.671');
    t('18.179', '-18.179');
    t('855885', '855885');
    t('4.16', '4.16');
    t('5.722e-18', '0.000000000000000005722');
    t('67.62', '67.62');
    t('813.31', '813.31');
    t('40.2', '40.20');
    t('0.00002515', '0.00002515');
    t('0.0196', '0.01960');
    t('13.165', '13.165');
    t('6.743', '-6.743');
    t('1', '-1');
    t('200.56', '-200.56');
    t('1.932', '1.932');
    t('92.9', '92.90');
    t('16.74', '16.74');
    t('4.5554e-7', '-0.00000045554');
    t('2.1296e-15', '-0.0000000000000021296');
    t('2.088', '2.088');
    t('2577', '2577');
    t('45.4', '-45.4');
    t('41.3', '-41.3');
    t('3.63', '-3.63');
    t('1.09', '-1.09');
    t('1', '-1');
    t('3.7', '-3.7');
    t('204.54', '204.54');
    t('235.6', '235.6');
    t('384', '-384');
    t('0.0207', '0.02070');
    t('680', '680');
    t('1.09', '1.09');
    t('109.2', '109.2');
    t('0.00010117', '0.00010117');
    t('13.81', '13.81');
    t('192.3', '192.3');
    t('1', '-1');
    t('1.2', '1.2');
    t('4.1', '-4.1');
    t('2.5', '2.5');
    t('8.4076', '-8.4076');
    t('0.0517', '0.0517');
    t('6.3923', '-6.3923');
    t('506.179', '-506.179');
    t('375886', '375886');
    t('618858', '-618858');
    t('8.5e-11', '0.000000000085');
    t('6', '-6.0');
    t('2.4', '2.40');
    t('0.0000013', '-0.0000013');
    t('1.064', '-1.064');
    t('1', '-1');
    t('4', '-4');
    t('4.5', '-4.5');
    t('93.6206', '93.6206');
    t('3.07e-18', '0.00000000000000000307');

    BigNumber.config({EXPONENTIAL_AT: 0});

    t('5.2452468128e+1', '-5.2452468128e+1');
    t('1.41525905257189365008396e+16', '1.41525905257189365008396e+16');
    t('2.743068083928e+11', '2.743068083928e+11');
    t('1.52993064722314247378724599e+26', '-1.52993064722314247378724599e+26');
    t('3.7205576746e+10', '3.7205576746e+10');
    t('8.680996444609343472665e+17', '8.680996444609343472665e+17');
    t('1.254549e+3', '1.254549e+3');
    t('6.23417196172381875892300762819e-18', '6.23417196172381875892300762819e-18');
    t('1.31179940821919284431e+19', '1.31179940821919284431e+19');
    t('9.7697726168e+7', '9.7697726168e+7');
    t('2.663e-10', '-2.663e-10');
    t('1.26574209965030360615518e+17', '-1.26574209965030360615518e+17');
    t('1.052e+3', '1.052e+3');
    t('4.452945872502e+6', '-4.452945872502e+6');
    t('2.95732460816619226e+13', '2.95732460816619226e+13');
    t('1.1923100194288654481424e+18', '-1.1923100194288654481424e+18');
    t('8.99315449050893705e+6', '8.99315449050893705e+6');
    t('5.200726538434486963e+8', '5.200726538434486963e+8');
    t('1.182618278949368566264898065e+18', '1.182618278949368566264898065e+18');
    t('3.815873266712e-20', '-3.815873266712e-20');
    t('1.316675370382742615e+6', '-1.316675370382742615e+6');
    t('2.1032502e+6', '-2.1032502e+6');
    t('1.8e+1', '1.8e+1');
    t('1.033525906631680944018544811261e-13', '1.033525906631680944018544811261e-13');
    t('1.102361746443461856816e+14', '-1.102361746443461856816e+14');
    t('8.595358491143959e+1', '8.595358491143959e+1');
    t('3.6908859412618413e+9', '-3.6908859412618413e+9');
    t('2.25907048615912944e+5', '-2.25907048615912944e+5');
    t('1.7441871813329475518e+19', '-1.7441871813329475518e+19');
    t('3.805493087068952925e-11', '-3.805493087068952925e-11');
    t('3.58049465451e+9', '-3.58049465451e+9');
    t('8.0688614291e+10', '-8.0688614291e+10');
    t('3.337855e+4', '-3.337855e+4');
    t('2.59977855e+8', '2.59977855e+8');
    t('4.96353e+4', '-4.96353e+4');
    t('7.47233581107861762e-13', '7.47233581107861762e-13');
    t('1.73948e-2', '1.73948e-2');
    t('5.784e-15', '5.784e-15');
    t('4.448338479762497e-8', '4.448338479762497e-8');
    t('3.9008023052e+8', '3.9008023052e+8');
    t('3e+0', '3e+0');
    t('8.61435e-9', '8.61435e-9');
    t('4.37e+1', '-4.37e+1');
    t('8.4034159379836e-18', '-8.4034159379836e-18');
    t('2.002857355721079885824481e+7', '2.002857355721079885824481e+7');
    t('7.000871862e+6', '-7.000871862e+6');
    t('2.2902057767e+9', '2.2902057767e+9');
    t('5.9896443375617e+8', '5.9896443375617e+8');
    t('1.53503650707e-11', '-1.53503650707e-11');
    t('2.0508347e+6', '2.0508347e+6');
    t('4.789433e+2', '-4.789433e+2');
    t('8.28161975302168665599e+11', '8.28161975302168665599e+11');
    t('1.2518396296278445e-5', '1.2518396296278445e-5');
    t('1.44290332e+8', '-1.44290332e+8');
    t('4.6570237501625609051773e-12', '4.6570237501625609051773e-12');
    t('7.8514960198282212436e+19', '7.8514960198282212436e+19');
    t('1.6197e-20', '1.6197e-20');
    t('6.51635176e+0', '-6.51635176e+0');
    t('4.49618e+3', '-4.49618e+3');
    t('1.32052259561417e-1', '-1.32052259561417e-1');
    t('2.09089580968e-18', '2.09089580968e-18');
    t('1.4064735615678257623873854709e-1', '1.4064735615678257623873854709e-1');
    t('3.14172e+0', '-3.14172e+0');
    t('1.7458792e+1', '1.7458792e+1');
    t('9.97831655282e+11', '9.97831655282e+11');
    t('1.94594e+1', '-1.94594e+1');
    t('1.2174602334491e+5', '-1.2174602334491e+5');
    t('1.12135222651239e+6', '-1.12135222651239e+6');
    t('6.3160490484343918e-20', '6.3160490484343918e-20');
    t('1.9238315686509393329629520842e+24', '1.9238315686509393329629520842e+24');
    t('9.915274405618026e+11', '-9.915274405618026e+11');
    t('2.3564687894712721487205001557e+28', '2.3564687894712721487205001557e+28');
    t('8.127315365677288172165e+2', '8.127315365677288172165e+2');
    t('4.93e+0', '-4.93e+0');
    t('1.41530382e+0', '-1.41530382e+0');
    t('4.86451432707435321820779e+19', '-4.86451432707435321820779e+19');
    t('1.4162540859e+0', '-1.4162540859e+0');
    t('4.646e+2', '-4.646e+2');
    t('2.1172e-14', '-2.1172e-14');
    t('8.69000536011392432707132752e-11', '8.69000536011392432707132752e-11');
    t('2.52776394053478133209e+20', '2.52776394053478133209e+20');
    t('8.500211152e+9', '8.500211152e+9');
    t('1.36178922026634255436879e+23', '1.36178922026634255436879e+23');
    t('4.6398705910903109e+3', '-4.6398705910903109e+3');
    t('2.15872185740218265392874524e+18', '2.15872185740218265392874524e+18');
    t('2.4663508855569609277266393e-3', '-2.4663508855569609277266393e-3');
    t('5.247072789229625795e+11', '-5.247072789229625795e+11');
    t('1.142743622516581e-15', '-1.142743622516581e-15');
    t('3.70055552960951165e-4', '-3.70055552960951165e-4');
    t('1.01218e+3', '1.01218e+3');
    t('3.622286100282e+2', '3.622286100282e+2');
    t('9.5526239814e+3', '9.5526239814e+3');
    t('2.7619598176203983624994361644e+28', '2.7619598176203983624994361644e+28');
    t('6.8696488497688008067537526e-6', '6.8696488497688008067537526e-6');
    t('2.48936e+1', '2.48936e+1');
    t('3.27658301230616e+14', '3.27658301230616e+14');
    t('2.1887387e+0', '-2.1887387e+0');
    t('1.4779696309033248e+16', '1.4779696309033248e+16');
    t('1.471782313713309789663e+4', '1.471782313713309789663e+4');
    t('2.0674554e+2', '-2.0674554e+2');
    t('1.763392540310312024e+9', '1.763392540310312024e+9');
    t('2.66209467493293140387227569744e+26', '-2.66209467493293140387227569744e+26');
    t('1.4522423854706487171671160683e-16', '1.4522423854706487171671160683e-16');
    t('5.5534571375626084341933639e-18', '-5.5534571375626084341933639e-18');
    t('3.670610508911e-18', '-3.670610508911e-18');
    t('1.8e+1', '1.8e+1');
    t('4.21466540619392e+14', '-4.21466540619392e+14');
    t('4.57881788773078611890575215e-13', '-4.57881788773078611890575215e-13');
    t('1.14912007700989046355e+20', '1.14912007700989046355e+20');
    t('1.10572e+0', '1.10572e+0');
    t('5.45027073427600086838788178e+8', '5.45027073427600086838788178e+8');
    t('5.3607527344097728e-14', '-5.3607527344097728e-14');
    t('1.20985e+0', '1.20985e+0');
    t('2.173758396975e+4', '-2.173758396975e+4');
    t('1.443459545123362e+10', '1.443459545123362e+10');
    t('8.26154936079048787963e-19', '8.26154936079048787963e-19');
    t('1.24e+0', '-1.24e+0');
    t('6.61e+1', '6.61e+1');
    t('8.37241281e-15', '-8.37241281e-15');
    t('1.4673863119972e+5', '1.4673863119972e+5');
    t('1.052445707646628e+15', '1.052445707646628e+15');
    t('2.770216401480935105227985046e+0', '2.770216401480935105227985046e+0');
    t('1e-2', '-1e-2');
    t('2.0530189404000503380382112e+7', '-2.0530189404000503380382112e+7');
    t('7.73428930734513129e+5', '7.73428930734513129e+5');
    t('2.969e-2', '2.969e-2');
    t('3.355869237729311e-19', '3.355869237729311e-19');
    t('7.585426017526e+3', '7.585426017526e+3');
    t('1.6544419963706446557685646278e+23', '-1.6544419963706446557685646278e+23');
    t('2.92136474375552641396809118574e-18', '2.92136474375552641396809118574e-18');
    t('3.38424409165604660854e+4', '-3.38424409165604660854e+4');
    t('1.173591570196350093112e+11', '-1.173591570196350093112e+11');
    t('7.8375092064291352e+1', '-7.8375092064291352e+1');
    t('1.88191e+3', '1.88191e+3');
    t('4.6761e-2', '-4.6761e-2');
    t('5.988129995539574e+10', '5.988129995539574e+10');
    t('2.5390529009345115e+2', '2.5390529009345115e+2');
    t('2.132229656150917182e+5', '-2.132229656150917182e+5');
    t('1.0719725506854825717e-19', '-1.0719725506854825717e-19');
    t('4.3681500769125575941008112847e+28', '-4.3681500769125575941008112847e+28');
    t('1.35927075893264893848008382e-13', '-1.35927075893264893848008382e-13');
    t('1.9240692976139e-18', '-1.9240692976139e-18');
    t('4.49668506275546883445e+20', '4.49668506275546883445e+20');
    t('5.19198662387790072e+9', '5.19198662387790072e+9');
    t('1.51188431866457089e+16', '-1.51188431866457089e+16');
    t('1.4463331863500941e+12', '1.4463331863500941e+12');
    t('1e+0', '-1e+0');
    t('2.50029927958615945e+1', '-2.50029927958615945e+1');
    t('1.001415164502846757e+3', '-1.001415164502846757e+3');
    t('1.45526428e+8', '-1.45526428e+8');
    t('5.813181844e-3', '-5.813181844e-3');
    t('2.4481022856740302965057941113e+10', '2.4481022856740302965057941113e+10');
    t('5.55e+1', '-5.55e+1');
    t('3.36356932710712e+11', '-3.36356932710712e+11');
    t('5.28080163e+8', '5.28080163e+8');
    t('5.3879740593083469994135e+13', '-5.3879740593083469994135e+13');
    t('6.6759148438881472902e+19', '-6.6759148438881472902e+19');
    t('1.26e-20', '1.26e-20');
    t('1.005680289388988e+10', '-1.005680289388988e+10');
    t('1.4855958598e+0', '-1.4855958598e+0');
    t('2.94014963598446075495453768e+24', '-2.94014963598446075495453768e+24');
    t('5.219896118644e+12', '-5.219896118644e+12');
    t('6.8e+0', '-6.8e+0');
    t('5.492e-9', '-5.492e-9');
    t('1.0038e+4', '-1.0038e+4');
    t('2.781382585e+5', '2.781382585e+5');
    t('3.30150670653876784e+17', '-3.30150670653876784e+17');
    t('1.87927e+5', '-1.87927e+5');
    t('1.4774557974305197453804758396e+16', '-1.4774557974305197453804758396e+16');
    t('6.05644990832733182152086098e+18', '-6.05644990832733182152086098e+18');
    t('2.78459055955765755e-14', '-2.78459055955765755e-14');
    t('2.66385931106395122e+6', '2.66385931106395122e+6');
    t('3.3683073647556597682246e-9', '-3.3683073647556597682246e-9');
    t('7.081e+2', '7.081e+2');
    t('2.73122035866217320954404e+6', '2.73122035866217320954404e+6');
    t('1.2434001e-7', '1.2434001e-7');
    t('1.135877627944001e+14', '1.135877627944001e+14');
    t('5.59534951548380080886141393126e+21', '5.59534951548380080886141393126e+21');
    t('5.7723782191795798882571e+9', '-5.7723782191795798882571e+9');
    t('1.5162957113185485632499369443e-12', '-1.5162957113185485632499369443e-12');
    t('4.29309951955288963780116e+6', '4.29309951955288963780116e+6');
    t('3.9722643229317825409e+13', '3.9722643229317825409e+13');
    t('1.011489199242414759e-17', '1.011489199242414759e-17');
    t('1.253643670639200989056241e-19', '-1.253643670639200989056241e-19');
    t('4.4836025129185e+8', '4.4836025129185e+8');
    t('6.3777231879677253018091496e-20', '6.3777231879677253018091496e-20');
    t('4.76278478201471177044e+11', '4.76278478201471177044e+11');
    t('1.05e+2', '-1.05e+2');
    t('8.2407974521826916377252018422e+18', '8.2407974521826916377252018422e+18');
    t('2.00932156087e+4', '2.00932156087e+4');
    t('1.965992456941204354956867603e-17', '-1.965992456941204354956867603e-17');
    t('5.333218599567659131313e+2', '-5.333218599567659131313e+2');
    t('1.286162439284e+10', '-1.286162439284e+10');
    t('8.1336617205815143346477183e+16', '-8.1336617205815143346477183e+16');
    t('1.762845949430042e+13', '-1.762845949430042e+13');
    t('7.837280986421e+12', '7.837280986421e+12');
    t('2.84048190010833793e+13', '2.84048190010833793e+13');
    t('3.25755301782427035301e+20', '-3.25755301782427035301e+20');
    t('2.58959421885729898387238225e+13', '2.58959421885729898387238225e+13');
    t('1.8851093513683294449e+10', '-1.8851093513683294449e+10');
    t('1.21916240456196024666e+20', '-1.21916240456196024666e+20');
    t('5.840503333749926899855535241e-6', '5.840503333749926899855535241e-6');
    t('2.998914116e+4', '2.998914116e+4');
    t('5.97277308650934e+10', '5.97277308650934e+10');
    t('6.56e+2', '6.56e+2');
    t('1.56235984592541e+12', '-1.56235984592541e+12');
    t('3.71e+1', '3.71e+1');
    t('5.41937441824138694e+16', '-5.41937441824138694e+16');
    t('6.116633e-5', '-6.116633e-5');
    t('5.45e+2', '-5.45e+2');
    t('2.9449785444e+3', '-2.9449785444e+3');
    t('6.6706550091070638245894e+7', '-6.6706550091070638245894e+7');
    t('1.39231027e-9', '1.39231027e-9');
    t('7.45311483e+8', '7.45311483e+8');
    t('7.6856950378651228179663e+18', '7.6856950378651228179663e+18');
    t('3.094636736003620629e+8', '-3.094636736003620629e+8');
    t('5.876896131624540495694931644e+7', '-5.876896131624540495694931644e+7');
    t('1.10975974e+8', '-1.10975974e+8');
    t('1.741e+0', '1.741e+0');
    t('2.351595813466272408066e-4', '-2.351595813466272408066e-4');
    t('1.519156959043394168562e+20', '1.519156959043394168562e+20');
    t('1.620081571051799e+7', '1.620081571051799e+7');
    t('7.316815038867932520586761e+23', '7.316815038867932520586761e+23');
    t('3.094134522833396822e+0', '3.094134522833396822e+0');
    t('1.168234556e+2', '-1.168234556e+2');
    t('1.503324779432e+4', '1.503324779432e+4');
    t('5.6710777e-9', '5.6710777e-9');
    t('2.1463873346182e-6', '2.1463873346182e-6');
    t('1.2934324795526700185311026007e+28', '-1.2934324795526700185311026007e+28');
    t('1.237009087265757433674283664e+11', '1.237009087265757433674283664e+11');
    t('1.226806049797304683867e-18', '1.226806049797304683867e-18');
    t('5e+0', '-5e+0');
    t('1.091168788407093537887970016e+15', '-1.091168788407093537887970016e+15');
    t('3.87166413612272027e+12', '3.87166413612272027e+12');
    t('1.411514e+5', '1.411514e+5');
    t('1.0053454672509859631996e+22', '1.0053454672509859631996e+22');
    t('6.9265714e+0', '6.9265714e+0');
    t('1.04627709e+4', '1.04627709e+4');
    t('1.74378341199e+9', '1.74378341199e+9');
    t('8.427721739784805398864e+21', '-8.427721739784805398864e+21');
    t('3.0433401636913618083715e-20', '3.0433401636913618083715e-20');
    t('8.596751182989204e-17', '8.596751182989204e-17');
    t('2.83012114501087201358049280895e-3', '2.83012114501087201358049280895e-3');
    t('6.0621417107465763e-13', '6.0621417107465763e-13');
    t('7.927e+0', '7.927e+0');
    t('1.95309091153617e+6', '-1.95309091153617e+6');
    t('3.479245772e-4', '3.479245772e-4');
    t('9.1256366370332e-20', '-9.1256366370332e-20');
    t('6.357737394e-19', '-6.357737394e-19');
    t('4.016038725869e-1', '4.016038725869e-1');
    t('2.3600611340992838105408e-2', '-2.3600611340992838105408e-2');
    t('1.1982e+3', '1.1982e+3');
    t('1.895744317788222501065084139e+17', '1.895744317788222501065084139e+17');
    t('3.2450271098259184465439822499e+5', '3.2450271098259184465439822499e+5');
    t('1.1699868235212007000965506e+25', '-1.1699868235212007000965506e+25');
    t('7.988985662262809183538221216e+27', '-7.988985662262809183538221216e+27');
    t('1.476540158366695285164548325e+7', '-1.476540158366695285164548325e+7');
    t('8.8357361253e+1', '-8.8357361253e+1');
    t('2.6019583787920961e+15', '-2.6019583787920961e+15');
    t('2.617913486220978003463345e+24', '2.617913486220978003463345e+24');
    t('8.22380392476331112656616e+14', '-8.22380392476331112656616e+14');
    t('5.738943e+2', '-5.738943e+2');
    t('1.04315155601043625824403526143e+24', '-1.04315155601043625824403526143e+24');
    t('5.1800101324564241e-1', '-5.1800101324564241e-1');
    t('3.5101750876959537987e-8', '3.5101750876959537987e-8');
    t('2.1857385393e+3', '-2.1857385393e+3');
    t('2.29674272702302434336e+13', '2.29674272702302434336e+13');
    t('2.64606405319747e+14', '2.64606405319747e+14');
    t('2.1888980498865372455451e+1', '-2.1888980498865372455451e+1');
    t('1.51602e+0', '-1.51602e+0');
    t('5.8047548e+7', '5.8047548e+7');
    t('1.17525103769842428108679e+6', '-1.17525103769842428108679e+6');
    t('8.47642371517851e-1', '-8.47642371517851e-1');
    t('6.0574e+0', '-6.0574e+0');
    t('2.59202859815854485362744156646e-3', '2.59202859815854485362744156646e-3');
    t('1.040746238422014004691755e+15', '1.040746238422014004691755e+15');
    t('1.7064734811115159257936e+22', '-1.7064734811115159257936e+22');
    t('7.26051238227573319908663048e+26', '7.26051238227573319908663048e+26');
    t('7.4795685183599759424050861e+6', '-7.4795685183599759424050861e+6');
    t('2.9817e-16', '-2.9817e-16');
    t('2.298907884272330951e+6', '2.298907884272330951e+6');
    t('4.0531847e-8', '4.0531847e-8');
    t('2.6189e+4', '-2.6189e+4');
    t('3.911906e+3', '-3.911906e+3');
    t('9.408498865993245868145865993e+2', '-9.408498865993245868145865993e+2');
    t('4.05451047373376774e-7', '4.05451047373376774e-7');
    t('2.08836709959016517e+6', '-2.08836709959016517e+6');
    t('6.3417891663e+10', '6.3417891663e+10');
    t('8.08596745e+9', '8.08596745e+9');
    t('2.5865615419545921e+13', '2.5865615419545921e+13');
    t('1.5731674925482283378868e+22', '-1.5731674925482283378868e+22');
    t('1.19068602e+1', '-1.19068602e+1');
    t('5.3687670881355020502668e-3', '-5.3687670881355020502668e-3');
    t('1.2488884456407e+10', '-1.2488884456407e+10');
    t('2.51800212e+3', '-2.51800212e+3');
    t('3.738131519976930832896022e+24', '-3.738131519976930832896022e+24');
    t('6e+0', '6e+0');
    t('1.24131e+5', '-1.24131e+5');
    t('9.22635e+3', '-9.22635e+3');
    t('4e+0', '4e+0');
    t('1.83e+1', '1.83e+1');
    t('1.846025e+6', '-1.846025e+6');
    t('1.27e+1', '1.27e+1');
    t('2.24e+1', '2.24e+1');
    t('2.476323257183413822109348e-18', '-2.476323257183413822109348e-18');
    t('1.926752842e-7', '1.926752842e-7');
    t('8.80612762892681839383e-19', '8.80612762892681839383e-19');
    t('1.101085e+3', '-1.101085e+3');
    t('3.4906077350467600648759e+22', '3.4906077350467600648759e+22');
    t('1.04494855994965735236868e+23', '1.04494855994965735236868e+23');
    t('1.58387879923230822739579e+19', '1.58387879923230822739579e+19');
    t('4.213902971419525700930675e+19', '-4.213902971419525700930675e+19');
    t('9.13804011600009749427632034e+0', '9.13804011600009749427632034e+0');
    t('1.84491548817806624708211e+23', '-1.84491548817806624708211e+23');
    t('1.948625124086563483825890385e+22', '1.948625124086563483825890385e+22');
    t('1.3e+0', '1.3e+0');
    t('1.32939216745e+12', '1.32939216745e+12');
    t('7.078251628e+6', '7.078251628e+6');
    t('1.7313022e+2', '1.7313022e+2');
    t('3.415584872774897359156e+0', '3.415584872774897359156e+0');
    t('5.51297107980065895009041695e+23', '5.51297107980065895009041695e+23');
    t('2.5113503918614988744859e-15', '2.5113503918614988744859e-15');
    t('1.630239450859331215249576367e+27', '1.630239450859331215249576367e+27');
    t('5.4721390329589760404415744136e+18', '-5.4721390329589760404415744136e+18');
    t('2.945751278429364126367812e-17', '2.945751278429364126367812e-17');
    t('4.2782880893227686126997e+4', '4.2782880893227686126997e+4');
    t('1.9847055931e+1', '-1.9847055931e+1');
    t('2.261026e+3', '-2.261026e+3');
    t('1.52615708575e+9', '1.52615708575e+9');
    t('4.55553743697189921932e+5', '-4.55553743697189921932e+5');
    t('4.222829719336993778496867e+12', '4.222829719336993778496867e+12');
    t('4.485e+3', '4.485e+3');
    t('5.2e+0', '-5.2e+0');
    t('1.845091473820299081635836e+6', '1.845091473820299081635836e+6');
    t('5.46863948617381450255744e-14', '-5.46863948617381450255744e-14');
    t('3.0245e+4', '3.0245e+4');
    t('1.53486267119215101935302e-6', '-1.53486267119215101935302e-6');
    t('6.4843132478784299210571e+16', '6.4843132478784299210571e+16');
    t('4.386363241636966071e+13', '-4.386363241636966071e+13');
    t('7.581683508504e+6', '7.581683508504e+6');
    t('1.09730944345409824e+16', '1.09730944345409824e+16');
    t('3.594503e+6', '-3.594503e+6');
    t('4.443273220375505949638436659e+1', '4.443273220375505949638436659e+1');
    t('1.70867026016477719112e+20', '-1.70867026016477719112e+20');
    t('1.29553439888e+11', '-1.29553439888e+11');
    t('1.1130502308247230952431e-11', '1.1130502308247230952431e-11');
    t('6.058565749e+10', '-6.058565749e+10');
    t('3.87180284987679e-10', '-3.87180284987679e-10');
    t('3.49184930268913133535e+19', '3.49184930268913133535e+19');
    t('9e+0', '9e+0');
    t('1.28461567447442016927071963077e-8', '-1.28461567447442016927071963077e-8');
    t('2.72815445800161137e-19', '2.72815445800161137e-19');
    t('5.849268583211e-4', '5.849268583211e-4');
    t('3.19417089569942412006e+3', '-3.19417089569942412006e+3');
    t('1.9e+1', '-1.9e+1');
    t('3.3872886317814608310483125577e+6', '3.3872886317814608310483125577e+6');
    t('3.99977971703789643632671956e+9', '-3.99977971703789643632671956e+9');
    t('1.998549e-5', '1.998549e-5');
    t('7.18512424913e-15', '7.18512424913e-15');
    t('9.365052273317995234261e+21', '9.365052273317995234261e+21');
    t('2.569e+3', '-2.569e+3');
    t('9.460553674215355e+3', '-9.460553674215355e+3');
    t('1.22541e+2', '-1.22541e+2');
    t('2.180882957e-2', '-2.180882957e-2');
    t('3.963983308804e-5', '3.963983308804e-5');
    t('4.9059909584804e+11', '4.9059909584804e+11');
    t('3.89345544e+8', '-3.89345544e+8');
    t('3.13811755993550161609599737307e+9', '3.13811755993550161609599737307e+9');
    t('2.1684124657298e+7', '2.1684124657298e+7');
    t('4e+0', '4e+0');
    t('1.89e+1', '-1.89e+1');
    t('1.0500428125617165569673e+6', '1.0500428125617165569673e+6');
    t('3.45971690973815432646e+9', '-3.45971690973815432646e+9');
    t('4e+0', '-4e+0');
    t('1.2826728638181755448600624e+4', '-1.2826728638181755448600624e+4');
    t('5.2490288314345e+5', '5.2490288314345e+5');
    t('8.46401e+0', '8.46401e+0');
    t('2.15070506987596858e-9', '2.15070506987596858e-9');
    t('1.4569180505e+5', '-1.4569180505e+5');
    t('1.75535288191468954993283e+8', '-1.75535288191468954993283e+8');
    t('1.83e-19', '1.83e-19');
    t('3.77847393193912874449578e+6', '3.77847393193912874449578e+6');
    t('2.823610210086368e+0', '2.823610210086368e+0');
    t('3.2326e+4', '-3.2326e+4');
    t('7.21208310236919171558e+7', '-7.21208310236919171558e+7');
    t('2.537182162994085967e+11', '2.537182162994085967e+11');
    t('2.4881474405e-15', '2.4881474405e-15');
    t('6.8484737e+6', '6.8484737e+6');
    t('8.09636762896763e+1', '8.09636762896763e+1');
    t('1.387805e+1', '-1.387805e+1');
    t('1.949086825141843503e-3', '-1.949086825141843503e-3');
    t('8.22006002683570972726913386e+26', '-8.22006002683570972726913386e+26');
    t('8.82e+1', '-8.82e+1');
    t('9.8e+0', '-9.8e+0');
    t('5.73018e+5', '-5.73018e+5');
    t('2.039854296e-18', '2.039854296e-18');
    t('3.85806698884e+2', '3.85806698884e+2');
    t('7.761351239715879e-15', '-7.761351239715879e-15');
    t('2.37976961448611739e-13', '2.37976961448611739e-13');
    t('1.625694436559179391897024e-12', '-1.625694436559179391897024e-12');
    t('2.612e+1', '-2.612e+1');
    t('8.317023570754122191146041e+24', '8.317023570754122191146041e+24');
    t('8.128823e-9', '8.128823e-9');
    t('3.316888938212137e-7', '3.316888938212137e-7');
    t('4.590734e+2', '4.590734e+2');
    t('9.95284154681380079083087718e-7', '9.95284154681380079083087718e-7');
    t('1.379051e-15', '1.379051e-15');
    t('2.543347781939297185736e+21', '-2.543347781939297185736e+21');
    t('1.41496183748704601485699e-10', '-1.41496183748704601485699e-10');
    t('3.11665e+5', '-3.11665e+5');
    t('6.4377728353162694052697e+1', '6.4377728353162694052697e+1');
    t('1.36920115218557491e+17', '1.36920115218557491e+17');
    t('1.27e+1', '-1.27e+1');
    t('5.1e-4', '5.1e-4');
    t('4.124e+3', '4.124e+3');
    t('7.96e+0', '7.96e+0');
    t('1.0109019145999979839008159507e-20', '1.0109019145999979839008159507e-20');
    t('1.507784067070212e+12', '1.507784067070212e+12');
    t('5.03530585620864526983697e+10', '5.03530585620864526983697e+10');
    t('5.87771648701709094e-3', '-5.87771648701709094e-3');
    t('2.6641175511284360931e+19', '2.6641175511284360931e+19');
    t('3.5430949752e+3', '-3.5430949752e+3');
    t('1.434481e+6', '1.434481e+6');
    t('6.95e+0', '6.95e+0');
    t('2.7922814988487634078255e+17', '2.7922814988487634078255e+17');
    t('1e+0', '-1e+0');
    t('1.34094272275111823704509269719e+9', '-1.34094272275111823704509269719e+9');
    t('5.2e+0', '5.2e+0');
    t('5.961731008805248930549e+0', '5.961731008805248930549e+0');
    t('1.95863217313239788358925850999e+27', '1.95863217313239788358925850999e+27');
    t('1.115927378282807678794111117e+18', '-1.115927378282807678794111117e+18');
    t('6.6448e-6', '-6.6448e-6');
    t('1.210298078691983e-7', '1.210298078691983e-7');
    t('1.55022703113469956595e+8', '-1.55022703113469956595e+8');
    t('2.519409262126392490249e+9', '-2.519409262126392490249e+9');
    t('8.3744112435155841906e+19', '8.3744112435155841906e+19');
    t('5.56052914013431e-4', '5.56052914013431e-4');
    t('1.847716075495989e+13', '-1.847716075495989e+13');
    t('5.78580529835020695846e+19', '-5.78580529835020695846e+19');
    t('7.3177e-15', '-7.3177e-15');
    t('5.8018949e+6', '-5.8018949e+6');
    t('1.234850494854913982840923624126e+30', '1.234850494854913982840923624126e+30');
    t('3.1e+0', '3.1e+0');
    t('3.085340434810406103e+4', '3.085340434810406103e+4');
    t('1.461332e+6', '1.461332e+6');
    t('2.042933164181166e-9', '2.042933164181166e-9');
    t('1.14852656434391849784404293276e-6', '1.14852656434391849784404293276e-6');
    t('8.56930722573e-11', '8.56930722573e-11');
    t('7.753629727831898e+11', '7.753629727831898e+11');
    t('2.5807119689e+5', '-2.5807119689e+5');
    t('6.5889872564e+7', '6.5889872564e+7');
    t('6.2e+0', '6.2e+0');
    t('7.16926024589772e+14', '-7.16926024589772e+14');
    t('2.444762609546357e-12', '2.444762609546357e-12');
    t('1.58017211706879e+2', '-1.58017211706879e+2');
    t('2.74612804105217564273009e+23', '-2.74612804105217564273009e+23');
    t('8.2105e+3', '-8.2105e+3');
    t('6.2289747e+7', '-6.2289747e+7');
    t('4.47847136680063365276e+21', '-4.47847136680063365276e+21');
    t('7.599263848474204e+15', '-7.599263848474204e+15');
    t('9.534064037670226206e-11', '-9.534064037670226206e-11');
    t('5.3511395608925655035624181e+7', '-5.3511395608925655035624181e+7');
    t('2.536656469414e+8', '2.536656469414e+8');
    t('4.454301005499233196018257e+16', '-4.454301005499233196018257e+16');
    t('2.3289800995961777747097e+10', '-2.3289800995961777747097e+10');
    t('2.7363696755334e+6', '-2.7363696755334e+6');
    t('2.56e+2', '2.56e+2');
    t('7.3430201092837e+2', '7.3430201092837e+2');
    t('1.114804e+5', '1.114804e+5');
    t('3.1845809556698336607622e+4', '-3.1845809556698336607622e+4');
    t('1.7780378655260403138e+19', '-1.7780378655260403138e+19');
    t('3.608970926e-15', '3.608970926e-15');
    t('1.949e+3', '-1.949e+3');
    t('1.9021837e+4', '-1.9021837e+4');
    t('1.5e+0', '1.5e+0');
    t('3.1155266673e+10', '-3.1155266673e+10');
    t('4e+0', '-4e+0');
    t('9.09316542545977506e+14', '9.09316542545977506e+14');
    t('2.15531740334146749845e+8', '2.15531740334146749845e+8');
    t('1.5605317646e+8', '1.5605317646e+8');
    t('3.8806066633613066e+13', '-3.8806066633613066e+13');
    t('1.653298e+6', '1.653298e+6');
    t('7.920024310736e-20', '7.920024310736e-20');
    t('2.27611872e+8', '2.27611872e+8');
    t('2.76569307109179036145271e-15', '-2.76569307109179036145271e-15');
    t('1.425171314e+8', '1.425171314e+8');
    t('1.3702555167748408653e+11', '-1.3702555167748408653e+11');
    t('5.146936435e+9', '5.146936435e+9');
    t('4.183285814905222880076696e+19', '-4.183285814905222880076696e+19');
    t('2.270923702039578057376e-16', '2.270923702039578057376e-16');
    t('9.4963549e-12', '9.4963549e-12');
    t('1.453060439e-3', '1.453060439e-3');
    t('2.97303365e+2', '2.97303365e+2');
    t('1.16485757109e+2', '-1.16485757109e+2');
    t('7.7984946334626919799413338378e+5', '-7.7984946334626919799413338378e+5');
    t('1.905453e+5', '1.905453e+5');
    t('5.36989497616503e-20', '5.36989497616503e-20');
    t('4.3e+0', '4.3e+0');
    t('2.70434008699476809368089518776e+25', '-2.70434008699476809368089518776e+25');
    t('2.8813069851e+10', '2.8813069851e+10');
    t('7e+0', '7e+0');
    t('1.0577487e-18', '-1.0577487e-18');
    t('6.8e+1', '6.8e+1');
    t('1e+0', '-1e+0');
    t('8.446803887694575079e+6', '-8.446803887694575079e+6');
    t('2.3384835e-6', '-2.3384835e-6');
    t('1.072e-13', '1.072e-13');
    t('7.13295350162e-5', '7.13295350162e-5');
    t('4.59897478609e+3', '4.59897478609e+3');
    t('4.11875744698515118e+11', '4.11875744698515118e+11');
    t('3.12339620225171e+5', '3.12339620225171e+5');
    t('3.79932554e+1', '3.79932554e+1');
    t('2.457332691061964e+4', '-2.457332691061964e+4');
    t('3.944602320705902e+6', '-3.944602320705902e+6');
    t('3.164305812145e+4', '-3.164305812145e+4');
    t('7.22239735515689399e+1', '-7.22239735515689399e+1');
    t('5.261981e+3', '-5.261981e+3');
    t('2.3642968462845e+7', '2.3642968462845e+7');
    t('3.9326785e+3', '-3.9326785e+3');
    t('8.5853e-11', '-8.5853e-11');
    t('2.60532943946e+0', '2.60532943946e+0');
    t('3.64630216318427246476533e+18', '-3.64630216318427246476533e+18');
    t('3.031732127749e-3', '3.031732127749e-3');
    t('2.49298080885329502254338e-12', '-2.49298080885329502254338e-12');
    t('8.81838341457179780743504843e+2', '-8.81838341457179780743504843e+2');
    t('2.285650225267766689304972e+5', '2.285650225267766689304972e+5');
    t('4.5790517211306242e+7', '4.5790517211306242e+7');
    t('3.0033340092338313923473428e+16', '-3.0033340092338313923473428e+16');
    t('2.83879929283797623e+1', '-2.83879929283797623e+1');
    t('4.5266377717178121183759377414e-5', '4.5266377717178121183759377414e-5');
    t('5.3781e+4', '-5.3781e+4');
    t('6.722035208213298413522819127e-18', '-6.722035208213298413522819127e-18');
    t('3.02865707828281230987116e+23', '-3.02865707828281230987116e+23');
    t('5.5879983320336874473209567979e+28', '-5.5879983320336874473209567979e+28');
});
