#include "bsecxxapi.hh"


/*-------- begin ../../sfi/sfidl generated code --------*/


static const SfiConstants bse_musical_tuning_type_vals[17] = {
  { "bse-musical-tuning-kirnberger-3", 31, 16 },
  { "bse-musical-tuning-werckmeister-3", 33, 12 },
  { "bse-musical-tuning-werckmeister-4", 33, 13 },
  { "bse-musical-tuning-werckmeister-5", 33, 14 },
  { "bse-musical-tuning-werckmeister-6", 33, 15 },
  { "bse-musical-tuning-silbermann-sorge", 35, 11 },
  { "bse-musical-tuning-diatonic-scale", 33, 4 },
  { "bse-musical-tuning-indian-scale", 31, 5 },
  { "bse-musical-tuning-quarter-comma-meantone", 41, 10 },
  { "bse-musical-tuning-pythagorean-tuning", 37, 6 },
  { "bse-musical-tuning-young", 24, 17 },
  { "bse-musical-tuning-pentatonic-gogo", 34, 9 },
  { "bse-musical-tuning-pentatonic-blues", 35, 8 },
  { "bse-musical-tuning-12-tet", 25, 1 },
  { "bse-musical-tuning-5-tet", 24, 3 },
  { "bse-musical-tuning-7-tet", 24, 2 },
  { "bse-musical-tuning-pentatonic-5-limit", 37, 7 },
};

const gchar*
bse_musical_tuning_type_to_choice (Bse::MusicalTuningType value)
{
  g_return_val_if_fail (value >= 1 && value <= 17, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_musical_tuning_type_vals), bse_musical_tuning_type_vals, value);
}

Bse::MusicalTuningType
bse_musical_tuning_type_from_choice (const gchar *choice)
{
  return (Bse::MusicalTuningType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_musical_tuning_type_vals), bse_musical_tuning_type_vals, choice) : 0);
}

static const SfiConstants bse_midi_signal_type_vals[172] = {
  { "bse-midi-signal-control-0", 25, 45 },
  { "bse-midi-signal-continuous-0", 28, 6 },
  { "bse-midi-signal-control-100", 27, 145 },
  { "bse-midi-signal-control-10", 26, 55 },
  { "bse-midi-signal-continuous-10", 29, 16 },
  { "bse-midi-signal-control-110", 27, 155 },
  { "bse-midi-signal-control-20", 26, 65 },
  { "bse-midi-signal-continuous-20", 29, 26 },
  { "bse-midi-signal-control-120", 27, 165 },
  { "bse-midi-signal-control-30", 26, 75 },
  { "bse-midi-signal-continuous-30", 29, 36 },
  { "bse-midi-signal-control-40", 26, 85 },
  { "bse-midi-signal-control-50", 26, 95 },
  { "bse-midi-signal-control-60", 26, 105 },
  { "bse-midi-signal-control-70", 26, 115 },
  { "bse-midi-signal-control-80", 26, 125 },
  { "bse-midi-signal-control-90", 26, 135 },
  { "bse-midi-signal-control-1", 25, 46 },
  { "bse-midi-signal-continuous-1", 28, 7 },
  { "bse-midi-signal-control-101", 27, 146 },
  { "bse-midi-signal-control-11", 26, 56 },
  { "bse-midi-signal-continuous-11", 29, 17 },
  { "bse-midi-signal-control-111", 27, 156 },
  { "bse-midi-signal-control-21", 26, 66 },
  { "bse-midi-signal-continuous-21", 29, 27 },
  { "bse-midi-signal-control-121", 27, 166 },
  { "bse-midi-signal-control-31", 26, 76 },
  { "bse-midi-signal-continuous-31", 29, 37 },
  { "bse-midi-signal-control-41", 26, 86 },
  { "bse-midi-signal-control-51", 26, 96 },
  { "bse-midi-signal-control-61", 26, 106 },
  { "bse-midi-signal-control-71", 26, 116 },
  { "bse-midi-signal-control-81", 26, 126 },
  { "bse-midi-signal-control-91", 26, 136 },
  { "bse-midi-signal-control-2", 25, 47 },
  { "bse-midi-signal-continuous-2", 28, 8 },
  { "bse-midi-signal-control-102", 27, 147 },
  { "bse-midi-signal-control-12", 26, 57 },
  { "bse-midi-signal-continuous-12", 29, 18 },
  { "bse-midi-signal-control-112", 27, 157 },
  { "bse-midi-signal-control-22", 26, 67 },
  { "bse-midi-signal-continuous-22", 29, 28 },
  { "bse-midi-signal-control-122", 27, 167 },
  { "bse-midi-signal-control-32", 26, 77 },
  { "bse-midi-signal-control-42", 26, 87 },
  { "bse-midi-signal-control-52", 26, 97 },
  { "bse-midi-signal-control-62", 26, 107 },
  { "bse-midi-signal-control-72", 26, 117 },
  { "bse-midi-signal-control-82", 26, 127 },
  { "bse-midi-signal-control-92", 26, 137 },
  { "bse-midi-signal-control-3", 25, 48 },
  { "bse-midi-signal-continuous-3", 28, 9 },
  { "bse-midi-signal-control-103", 27, 148 },
  { "bse-midi-signal-control-13", 26, 58 },
  { "bse-midi-signal-continuous-13", 29, 19 },
  { "bse-midi-signal-control-113", 27, 158 },
  { "bse-midi-signal-control-23", 26, 68 },
  { "bse-midi-signal-continuous-23", 29, 29 },
  { "bse-midi-signal-control-123", 27, 168 },
  { "bse-midi-signal-control-33", 26, 78 },
  { "bse-midi-signal-control-43", 26, 88 },
  { "bse-midi-signal-control-53", 26, 98 },
  { "bse-midi-signal-control-63", 26, 108 },
  { "bse-midi-signal-control-73", 26, 118 },
  { "bse-midi-signal-control-83", 26, 128 },
  { "bse-midi-signal-control-93", 26, 138 },
  { "bse-midi-signal-control-4", 25, 49 },
  { "bse-midi-signal-continuous-4", 28, 10 },
  { "bse-midi-signal-control-104", 27, 149 },
  { "bse-midi-signal-control-14", 26, 59 },
  { "bse-midi-signal-continuous-14", 29, 20 },
  { "bse-midi-signal-control-114", 27, 159 },
  { "bse-midi-signal-control-24", 26, 69 },
  { "bse-midi-signal-continuous-24", 29, 30 },
  { "bse-midi-signal-control-124", 27, 169 },
  { "bse-midi-signal-control-34", 26, 79 },
  { "bse-midi-signal-control-44", 26, 89 },
  { "bse-midi-signal-control-54", 26, 99 },
  { "bse-midi-signal-control-64", 26, 109 },
  { "bse-midi-signal-control-74", 26, 119 },
  { "bse-midi-signal-control-84", 26, 129 },
  { "bse-midi-signal-control-94", 26, 139 },
  { "bse-midi-signal-control-5", 25, 50 },
  { "bse-midi-signal-continuous-5", 28, 11 },
  { "bse-midi-signal-control-105", 27, 150 },
  { "bse-midi-signal-control-15", 26, 60 },
  { "bse-midi-signal-continuous-15", 29, 21 },
  { "bse-midi-signal-control-115", 27, 160 },
  { "bse-midi-signal-control-25", 26, 70 },
  { "bse-midi-signal-continuous-25", 29, 31 },
  { "bse-midi-signal-control-125", 27, 170 },
  { "bse-midi-signal-control-35", 26, 80 },
  { "bse-midi-signal-control-45", 26, 90 },
  { "bse-midi-signal-control-55", 26, 100 },
  { "bse-midi-signal-control-65", 26, 110 },
  { "bse-midi-signal-control-75", 26, 120 },
  { "bse-midi-signal-control-85", 26, 130 },
  { "bse-midi-signal-control-95", 26, 140 },
  { "bse-midi-signal-control-6", 25, 51 },
  { "bse-midi-signal-continuous-6", 28, 12 },
  { "bse-midi-signal-control-106", 27, 151 },
  { "bse-midi-signal-control-16", 26, 61 },
  { "bse-midi-signal-continuous-16", 29, 22 },
  { "bse-midi-signal-control-116", 27, 161 },
  { "bse-midi-signal-control-26", 26, 71 },
  { "bse-midi-signal-continuous-26", 29, 32 },
  { "bse-midi-signal-control-126", 27, 171 },
  { "bse-midi-signal-control-36", 26, 81 },
  { "bse-midi-signal-control-46", 26, 91 },
  { "bse-midi-signal-control-56", 26, 101 },
  { "bse-midi-signal-control-66", 26, 111 },
  { "bse-midi-signal-control-76", 26, 121 },
  { "bse-midi-signal-control-86", 26, 131 },
  { "bse-midi-signal-control-96", 26, 141 },
  { "bse-midi-signal-control-7", 25, 52 },
  { "bse-midi-signal-continuous-7", 28, 13 },
  { "bse-midi-signal-control-107", 27, 152 },
  { "bse-midi-signal-control-17", 26, 62 },
  { "bse-midi-signal-continuous-17", 29, 23 },
  { "bse-midi-signal-control-117", 27, 162 },
  { "bse-midi-signal-control-27", 26, 72 },
  { "bse-midi-signal-continuous-27", 29, 33 },
  { "bse-midi-signal-control-127", 27, 172 },
  { "bse-midi-signal-control-37", 26, 82 },
  { "bse-midi-signal-control-47", 26, 92 },
  { "bse-midi-signal-control-57", 26, 102 },
  { "bse-midi-signal-control-67", 26, 112 },
  { "bse-midi-signal-control-77", 26, 122 },
  { "bse-midi-signal-control-87", 26, 132 },
  { "bse-midi-signal-control-97", 26, 142 },
  { "bse-midi-signal-control-8", 25, 53 },
  { "bse-midi-signal-continuous-8", 28, 14 },
  { "bse-midi-signal-control-108", 27, 153 },
  { "bse-midi-signal-control-18", 26, 63 },
  { "bse-midi-signal-continuous-18", 29, 24 },
  { "bse-midi-signal-control-118", 27, 163 },
  { "bse-midi-signal-control-28", 26, 73 },
  { "bse-midi-signal-continuous-28", 29, 34 },
  { "bse-midi-signal-control-38", 26, 83 },
  { "bse-midi-signal-control-48", 26, 93 },
  { "bse-midi-signal-control-58", 26, 103 },
  { "bse-midi-signal-control-68", 26, 113 },
  { "bse-midi-signal-control-78", 26, 123 },
  { "bse-midi-signal-control-88", 26, 133 },
  { "bse-midi-signal-control-98", 26, 143 },
  { "bse-midi-signal-control-9", 25, 54 },
  { "bse-midi-signal-continuous-9", 28, 15 },
  { "bse-midi-signal-control-109", 27, 154 },
  { "bse-midi-signal-control-19", 26, 64 },
  { "bse-midi-signal-continuous-19", 29, 25 },
  { "bse-midi-signal-control-119", 27, 164 },
  { "bse-midi-signal-control-29", 26, 74 },
  { "bse-midi-signal-continuous-29", 29, 35 },
  { "bse-midi-signal-control-39", 26, 84 },
  { "bse-midi-signal-control-49", 26, 94 },
  { "bse-midi-signal-control-59", 26, 104 },
  { "bse-midi-signal-control-69", 26, 114 },
  { "bse-midi-signal-control-79", 26, 124 },
  { "bse-midi-signal-control-89", 26, 134 },
  { "bse-midi-signal-control-99", 26, 144 },
  { "bse-midi-signal-pitch-bend", 26, 3 },
  { "bse-midi-signal-fine-tune", 25, 5 },
  { "bse-midi-signal-pressure", 24, 2 },
  { "bse-midi-signal-constant-negative-high", 38, 42 },
  { "bse-midi-signal-constant-high", 29, 38 },
  { "bse-midi-signal-program", 23, 1 },
  { "bse-midi-signal-parameter", 25, 43 },
  { "bse-midi-signal-non-parameter", 29, 44 },
  { "bse-midi-signal-constant-negative-center", 40, 41 },
  { "bse-midi-signal-constant-center", 31, 39 },
  { "bse-midi-signal-constant-low", 28, 40 },
  { "bse-midi-signal-velocity", 24, 4 },
};

const gchar*
bse_midi_signal_type_to_choice (Bse::MidiSignalType value)
{
  g_return_val_if_fail (value >= 1 && value <= 172, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_midi_signal_type_vals), bse_midi_signal_type_vals, value);
}

Bse::MidiSignalType
bse_midi_signal_type_from_choice (const gchar *choice)
{
  return (Bse::MidiSignalType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_midi_signal_type_vals), bse_midi_signal_type_vals, choice) : 0);
}

static const SfiConstants bse_midi_control_type_vals[161] = {
  { "bse-midi-control-0", 18, 33 },
  { "bse-midi-control-continuous-0", 29, 1 },
  { "bse-midi-control-100", 20, 133 },
  { "bse-midi-control-10", 19, 43 },
  { "bse-midi-control-continuous-10", 30, 11 },
  { "bse-midi-control-110", 20, 143 },
  { "bse-midi-control-20", 19, 53 },
  { "bse-midi-control-continuous-20", 30, 21 },
  { "bse-midi-control-120", 20, 153 },
  { "bse-midi-control-30", 19, 63 },
  { "bse-midi-control-continuous-30", 30, 31 },
  { "bse-midi-control-40", 19, 73 },
  { "bse-midi-control-50", 19, 83 },
  { "bse-midi-control-60", 19, 93 },
  { "bse-midi-control-70", 19, 103 },
  { "bse-midi-control-80", 19, 113 },
  { "bse-midi-control-90", 19, 123 },
  { "bse-midi-control-1", 18, 34 },
  { "bse-midi-control-continuous-1", 29, 2 },
  { "bse-midi-control-101", 20, 134 },
  { "bse-midi-control-11", 19, 44 },
  { "bse-midi-control-continuous-11", 30, 12 },
  { "bse-midi-control-111", 20, 144 },
  { "bse-midi-control-21", 19, 54 },
  { "bse-midi-control-continuous-21", 30, 22 },
  { "bse-midi-control-121", 20, 154 },
  { "bse-midi-control-31", 19, 64 },
  { "bse-midi-control-continuous-31", 30, 32 },
  { "bse-midi-control-41", 19, 74 },
  { "bse-midi-control-51", 19, 84 },
  { "bse-midi-control-61", 19, 94 },
  { "bse-midi-control-71", 19, 104 },
  { "bse-midi-control-81", 19, 114 },
  { "bse-midi-control-91", 19, 124 },
  { "bse-midi-control-2", 18, 35 },
  { "bse-midi-control-continuous-2", 29, 3 },
  { "bse-midi-control-102", 20, 135 },
  { "bse-midi-control-12", 19, 45 },
  { "bse-midi-control-continuous-12", 30, 13 },
  { "bse-midi-control-112", 20, 145 },
  { "bse-midi-control-22", 19, 55 },
  { "bse-midi-control-continuous-22", 30, 23 },
  { "bse-midi-control-122", 20, 155 },
  { "bse-midi-control-32", 19, 65 },
  { "bse-midi-control-42", 19, 75 },
  { "bse-midi-control-52", 19, 85 },
  { "bse-midi-control-62", 19, 95 },
  { "bse-midi-control-72", 19, 105 },
  { "bse-midi-control-82", 19, 115 },
  { "bse-midi-control-92", 19, 125 },
  { "bse-midi-control-3", 18, 36 },
  { "bse-midi-control-continuous-3", 29, 4 },
  { "bse-midi-control-103", 20, 136 },
  { "bse-midi-control-13", 19, 46 },
  { "bse-midi-control-continuous-13", 30, 14 },
  { "bse-midi-control-113", 20, 146 },
  { "bse-midi-control-23", 19, 56 },
  { "bse-midi-control-continuous-23", 30, 24 },
  { "bse-midi-control-123", 20, 156 },
  { "bse-midi-control-33", 19, 66 },
  { "bse-midi-control-43", 19, 76 },
  { "bse-midi-control-53", 19, 86 },
  { "bse-midi-control-63", 19, 96 },
  { "bse-midi-control-73", 19, 106 },
  { "bse-midi-control-83", 19, 116 },
  { "bse-midi-control-93", 19, 126 },
  { "bse-midi-control-4", 18, 37 },
  { "bse-midi-control-continuous-4", 29, 5 },
  { "bse-midi-control-104", 20, 137 },
  { "bse-midi-control-14", 19, 47 },
  { "bse-midi-control-continuous-14", 30, 15 },
  { "bse-midi-control-114", 20, 147 },
  { "bse-midi-control-24", 19, 57 },
  { "bse-midi-control-continuous-24", 30, 25 },
  { "bse-midi-control-124", 20, 157 },
  { "bse-midi-control-34", 19, 67 },
  { "bse-midi-control-44", 19, 77 },
  { "bse-midi-control-54", 19, 87 },
  { "bse-midi-control-64", 19, 97 },
  { "bse-midi-control-74", 19, 107 },
  { "bse-midi-control-84", 19, 117 },
  { "bse-midi-control-94", 19, 127 },
  { "bse-midi-control-5", 18, 38 },
  { "bse-midi-control-continuous-5", 29, 6 },
  { "bse-midi-control-105", 20, 138 },
  { "bse-midi-control-15", 19, 48 },
  { "bse-midi-control-continuous-15", 30, 16 },
  { "bse-midi-control-115", 20, 148 },
  { "bse-midi-control-25", 19, 58 },
  { "bse-midi-control-continuous-25", 30, 26 },
  { "bse-midi-control-125", 20, 158 },
  { "bse-midi-control-35", 19, 68 },
  { "bse-midi-control-45", 19, 78 },
  { "bse-midi-control-55", 19, 88 },
  { "bse-midi-control-65", 19, 98 },
  { "bse-midi-control-75", 19, 108 },
  { "bse-midi-control-85", 19, 118 },
  { "bse-midi-control-95", 19, 128 },
  { "bse-midi-control-6", 18, 39 },
  { "bse-midi-control-continuous-6", 29, 7 },
  { "bse-midi-control-106", 20, 139 },
  { "bse-midi-control-16", 19, 49 },
  { "bse-midi-control-continuous-16", 30, 17 },
  { "bse-midi-control-116", 20, 149 },
  { "bse-midi-control-26", 19, 59 },
  { "bse-midi-control-continuous-26", 30, 27 },
  { "bse-midi-control-126", 20, 159 },
  { "bse-midi-control-36", 19, 69 },
  { "bse-midi-control-46", 19, 79 },
  { "bse-midi-control-56", 19, 89 },
  { "bse-midi-control-66", 19, 99 },
  { "bse-midi-control-76", 19, 109 },
  { "bse-midi-control-86", 19, 119 },
  { "bse-midi-control-96", 19, 129 },
  { "bse-midi-control-7", 18, 40 },
  { "bse-midi-control-continuous-7", 29, 8 },
  { "bse-midi-control-107", 20, 140 },
  { "bse-midi-control-17", 19, 50 },
  { "bse-midi-control-continuous-17", 30, 18 },
  { "bse-midi-control-117", 20, 150 },
  { "bse-midi-control-27", 19, 60 },
  { "bse-midi-control-continuous-27", 30, 28 },
  { "bse-midi-control-127", 20, 160 },
  { "bse-midi-control-37", 19, 70 },
  { "bse-midi-control-47", 19, 80 },
  { "bse-midi-control-57", 19, 90 },
  { "bse-midi-control-67", 19, 100 },
  { "bse-midi-control-77", 19, 110 },
  { "bse-midi-control-87", 19, 120 },
  { "bse-midi-control-97", 19, 130 },
  { "bse-midi-control-8", 18, 41 },
  { "bse-midi-control-continuous-8", 29, 9 },
  { "bse-midi-control-108", 20, 141 },
  { "bse-midi-control-18", 19, 51 },
  { "bse-midi-control-continuous-18", 30, 19 },
  { "bse-midi-control-118", 20, 151 },
  { "bse-midi-control-28", 19, 61 },
  { "bse-midi-control-continuous-28", 30, 29 },
  { "bse-midi-control-38", 19, 71 },
  { "bse-midi-control-48", 19, 81 },
  { "bse-midi-control-58", 19, 91 },
  { "bse-midi-control-68", 19, 101 },
  { "bse-midi-control-78", 19, 111 },
  { "bse-midi-control-88", 19, 121 },
  { "bse-midi-control-98", 19, 131 },
  { "bse-midi-control-9", 18, 42 },
  { "bse-midi-control-continuous-9", 29, 10 },
  { "bse-midi-control-109", 20, 142 },
  { "bse-midi-control-19", 19, 52 },
  { "bse-midi-control-continuous-19", 30, 20 },
  { "bse-midi-control-119", 20, 152 },
  { "bse-midi-control-29", 19, 62 },
  { "bse-midi-control-continuous-29", 30, 30 },
  { "bse-midi-control-39", 19, 72 },
  { "bse-midi-control-49", 19, 82 },
  { "bse-midi-control-59", 19, 92 },
  { "bse-midi-control-69", 19, 102 },
  { "bse-midi-control-79", 19, 112 },
  { "bse-midi-control-89", 19, 122 },
  { "bse-midi-control-99", 19, 132 },
  { "bse-midi-control-none", 21, 0 },
};

const gchar*
bse_midi_control_type_to_choice (Bse::MidiControlType value)
{
  g_return_val_if_fail (value >= 0 && value <= 160, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_midi_control_type_vals), bse_midi_control_type_vals, value);
}

Bse::MidiControlType
bse_midi_control_type_from_choice (const gchar *choice)
{
  return (Bse::MidiControlType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_midi_control_type_vals), bse_midi_control_type_vals, choice) : 0);
}

static const SfiConstants bse_midi_channel_event_type_vals[18] = {
  { "bse-midi-event-pitch-bend", 25, 7 },
  { "bse-midi-event-control-change", 29, 4 },
  { "bse-midi-event-program-change", 29, 5 },
  { "bse-midi-event-none", 19, 0 },
  { "bse-midi-event-tune", 19, 11 },
  { "bse-midi-event-channel-pressure", 31, 6 },
  { "bse-midi-event-key-pressure", 27, 3 },
  { "bse-midi-event-song-continue", 28, 14 },
  { "bse-midi-event-note-off", 23, 1 },
  { "bse-midi-event-active-sensing", 29, 16 },
  { "bse-midi-event-timing-clock", 27, 12 },
  { "bse-midi-event-note-on", 22, 2 },
  { "bse-midi-event-song-stop", 24, 15 },
  { "bse-midi-event-song-pointer", 27, 9 },
  { "bse-midi-event-song-select", 26, 10 },
  { "bse-midi-event-system-reset", 27, 17 },
  { "bse-midi-event-song-start", 25, 13 },
  { "bse-midi-event-sys-ex", 21, 8 },
};

const gchar*
bse_midi_channel_event_type_to_choice (Bse::MidiChannelEventType value)
{
  g_return_val_if_fail (value >= 0 && value <= 17, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_midi_channel_event_type_vals), bse_midi_channel_event_type_vals, value);
}

Bse::MidiChannelEventType
bse_midi_channel_event_type_from_choice (const gchar *choice)
{
  return (Bse::MidiChannelEventType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_midi_channel_event_type_vals), bse_midi_channel_event_type_vals, choice) : 0);
}

static const SfiConstants bse_msg_type_vals[8] = {
  { "bse-msg-none", 12, 0 },
  { "bse-msg-diag", 12, 6 },
  { "bse-msg-warning", 15, 3 },
  { "bse-msg-debug", 13, 7 },
  { "bse-msg-info", 12, 5 },
  { "bse-msg-error", 13, 2 },
  { "bse-msg-always", 14, 1 },
  { "bse-msg-script", 14, 4 },
};

const gchar*
bse_msg_type_to_choice (Bse::MsgType value)
{
  g_return_val_if_fail (value >= 0 && value <= 7, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_msg_type_vals), bse_msg_type_vals, value);
}

Bse::MsgType
bse_msg_type_from_choice (const gchar *choice)
{
  return (Bse::MsgType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_msg_type_vals), bse_msg_type_vals, choice) : 0);
}

static const SfiConstants bse_thread_state_vals[8] = {
  { "bse-thread-state-dead", 21, 8 },
  { "bse-thread-state-traced", 23, 5 },
  { "bse-thread-state-zombie", 23, 7 },
  { "bse-thread-state-paging", 23, 6 },
  { "bse-thread-state-running", 24, 2 },
  { "bse-thread-state-sleeping", 25, 3 },
  { "bse-thread-state-unknown", 24, 1 },
  { "bse-thread-state-diskwait", 25, 4 },
};

const gchar*
bse_thread_state_to_choice (Bse::ThreadState value)
{
  g_return_val_if_fail (value >= 1 && value <= 8, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_thread_state_vals), bse_thread_state_vals, value);
}

Bse::ThreadState
bse_thread_state_from_choice (const gchar *choice)
{
  return (Bse::ThreadState) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_thread_state_vals), bse_thread_state_vals, choice) : 0);
}

static const SfiConstants bse_biquad_filter_type_vals[2] = {
  { "bse-biquad-filter-resonant-highpass", 35, 2 },
  { "bse-biquad-filter-resonant-lowpass", 34, 1 },
};

const gchar*
bse_biquad_filter_type_to_choice (Bse::BiquadFilterType value)
{
  g_return_val_if_fail (value >= 1 && value <= 2, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_biquad_filter_type_vals), bse_biquad_filter_type_vals, value);
}

Bse::BiquadFilterType
bse_biquad_filter_type_from_choice (const gchar *choice)
{
  return (Bse::BiquadFilterType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_biquad_filter_type_vals), bse_biquad_filter_type_vals, choice) : 0);
}

static const SfiConstants bse_registration_type_vals[3] = {
  { "bse-register-done", 17, 3 },
  { "bse-register-plugin", 19, 1 },
  { "bse-register-script", 19, 2 },
};

const gchar*
bse_registration_type_to_choice (Bse::RegistrationType value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_registration_type_vals), bse_registration_type_vals, value);
}

Bse::RegistrationType
bse_registration_type_from_choice (const gchar *choice)
{
  return (Bse::RegistrationType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_registration_type_vals), bse_registration_type_vals, choice) : 0);
}

static const SfiConstants bse_error_type_vals[68] = {
  { "bse-error-no-data", 17, 21 },
  { "bse-error-device-async", 22, 36 },
  { "bse-error-data-unmatched", 24, 26 },
  { "bse-error-file-read-failed", 26, 13 },
  { "bse-error-file-write-failed", 27, 14 },
  { "bse-error-file-seek-failed", 26, 12 },
  { "bse-error-file-open-failed", 26, 11 },
  { "bse-error-source-channels-connected", 35, 50 },
  { "bse-error-unimplemented", 23, 30 },
  { "bse-error-source-type-invalid", 29, 55 },
  { "bse-error-source-connection-invalid", 35, 51 },
  { "bse-error-format-invalid", 24, 24 },
  { "bse-error-proc-not-found", 24, 56 },
  { "bse-error-file-not-found", 24, 9 },
  { "bse-error-wave-not-found", 24, 28 },
  { "bse-error-no-space", 18, 17 },
  { "bse-error-device-not-available", 30, 35 },
  { "bse-error-source-no-such-module", 31, 44 },
  { "bse-error-none", 14, 0 },
  { "bse-error-codec-failure", 23, 29 },
  { "bse-error-source-ichannel-in-use", 32, 49 },
  { "bse-error-file-eof", 18, 7 },
  { "bse-error-devices-mismatch", 26, 43 },
  { "bse-error-source-parent-mismatch", 32, 52 },
  { "bse-error-source-bad-loopback", 29, 53 },
  { "bse-error-internal", 18, 1 },
  { "bse-error-proc-param-inval", 26, 58 },
  { "bse-error-source-private-ichannel", 33, 48 },
  { "bse-error-source-no-such-ichannel", 33, 45 },
  { "bse-error-source-no-such-ochannel", 33, 46 },
  { "bse-error-invalid-midi-control", 30, 32 },
  { "bse-error-invalid-duration", 26, 66 },
  { "bse-error-source-no-such-connection", 35, 47 },
  { "bse-error-proc-execution", 24, 59 },
  { "bse-error-spawn", 15, 34 },
  { "bse-error-unknown", 17, 2 },
  { "bse-error-format-unknown", 24, 25 },
  { "bse-error-no-seek-info", 22, 20 },
  { "bse-error-io", 12, 3 },
  { "bse-error-invalid-overlap", 25, 67 },
  { "bse-error-temp", 14, 27 },
  { "bse-error-no-header", 19, 19 },
  { "bse-error-device-buffer", 23, 39 },
  { "bse-error-not-owner", 19, 64 },
  { "bse-error-file-is-dir", 21, 10 },
  { "bse-error-parse-error", 21, 33 },
  { "bse-error-no-files", 18, 16 },
  { "bse-error-many-files", 20, 15 },
  { "bse-error-device-channels", 25, 41 },
  { "bse-error-wrong-n-channels", 26, 23 },
  { "bse-error-perms", 15, 4 },
  { "bse-error-file-exists", 21, 6 },
  { "bse-error-device-format", 23, 38 },
  { "bse-error-no-target", 19, 63 },
  { "bse-error-invalid-offset", 24, 65 },
  { "bse-error-no-event", 18, 62 },
  { "bse-error-data-corrupt", 22, 22 },
  { "bse-error-proc-abort", 20, 60 },
  { "bse-error-device-latency", 24, 40 },
  { "bse-error-device-frequency", 26, 42 },
  { "bse-error-no-memory", 19, 18 },
  { "bse-error-no-entry", 18, 61 },
  { "bse-error-proc-busy", 19, 57 },
  { "bse-error-device-busy", 21, 37 },
  { "bse-error-source-busy", 21, 54 },
  { "bse-error-file-busy", 19, 5 },
  { "bse-error-file-empty", 20, 8 },
  { "bse-error-invalid-property", 26, 31 },
};

const gchar*
bse_error_type_to_choice (Bse::ErrorType value)
{
  g_return_val_if_fail (value >= 0 && value <= 67, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_error_type_vals), bse_error_type_vals, value);
}

Bse::ErrorType
bse_error_type_from_choice (const gchar *choice)
{
  return (Bse::ErrorType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_error_type_vals), bse_error_type_vals, choice) : 0);
}

static const SfiConstants bse_project_state_vals[3] = {
  { "bse-project-active", 18, 1 },
  { "bse-project-inactive", 20, 0 },
  { "bse-project-playing", 19, 2 },
};

const gchar*
bse_project_state_to_choice (Bse::ProjectState value)
{
  g_return_val_if_fail (value >= 0 && value <= 2, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_project_state_vals), bse_project_state_vals, value);
}

Bse::ProjectState
bse_project_state_from_choice (const gchar *choice)
{
  return (Bse::ProjectState) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_project_state_vals), bse_project_state_vals, choice) : 0);
}

static const SfiConstants bse_standard_osc_wave_type_vals[9] = {
  { "bse-standard-osc-triangle", 25, 2 },
  { "bse-standard-osc-sine", 21, 1 },
  { "bse-standard-osc-square", 23, 8 },
  { "bse-standard-osc-peak-rise", 26, 5 },
  { "bse-standard-osc-saw-rise", 25, 3 },
  { "bse-standard-osc-pulse", 22, 9 },
  { "bse-standard-osc-peak-fall", 26, 6 },
  { "bse-standard-osc-saw-fall", 25, 4 },
  { "bse-standard-osc-moog-saw", 25, 7 },
};

const gchar*
bse_standard_osc_wave_type_to_choice (Bse::StandardOscWaveType value)
{
  g_return_val_if_fail (value >= 1 && value <= 9, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_standard_osc_wave_type_vals), bse_standard_osc_wave_type_vals, value);
}

Bse::StandardOscWaveType
bse_standard_osc_wave_type_from_choice (const gchar *choice)
{
  return (Bse::StandardOscWaveType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_standard_osc_wave_type_vals), bse_standard_osc_wave_type_vals, choice) : 0);
}


void
Bse::Item::add_parasite (const Sfi::String& path, SfiRec* parasite) {
  sfi_glue_vcall_void ("BseItem+add-parasite", 'p', _object_id, 's', path.c_str(), 'R', parasite, 0);
}

SfiBool
Bse::Item::check_is_a (const Sfi::String& type_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseItem+check-is-a", 'p', _object_id, 's', type_name.c_str(), 0);
  return _retval;
}

void
Bse::Item::clear_undo (void) {
  sfi_glue_vcall_void ("BseItem+clear-undo", 'p', _object_id, 0);
}

Bse::Item
Bse::Item::common_ancestor (Bse::Item item2) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+common-ancestor", 'p', _object_id, 'p', item2._proxy(), 0);
  return _retval;
}

SfiBool
Bse::Item::editable_property (const Sfi::String& property_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseItem+editable-property", 'p', _object_id, 's', property_name.c_str(), 0);
  return _retval;
}

Bse::IconHandle
Bse::Item::get_icon (void) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseItem+get-icon", 'p', _object_id, 0);
  return Bse::Icon::from_rec (_retval);
}

Sfi::String
Bse::Item::get_name (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-name", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Item::get_name_or_type (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-name-or-type", 'p', _object_id, 0);
  return _retval;
}

SfiRec*
Bse::Item::get_parasite (const Sfi::String& path) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseItem+get-parasite", 'p', _object_id, 's', path.c_str(), 0);
  return _retval;
}

Bse::Item
Bse::Item::get_parent (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+get-parent", 'p', _object_id, 0);
  return _retval;
}

Bse::Item
Bse::Item::get_project (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+get-project", 'p', _object_id, 0);
  return _retval;
}

Bse::PropertyCandidatesHandle
Bse::Item::get_property_candidates (const Sfi::String& property_name) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseItem+get-property-candidates", 'p', _object_id, 's', property_name.c_str(), 0);
  return Bse::PropertyCandidates::from_rec (_retval);
}

SfiInt
Bse::Item::get_seqid (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+get-seqid", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Item::get_type (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Item::get_type_authors (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-authors", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Item::get_type_blurb (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-blurb", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Item::get_type_license (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-license", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Item::get_type_name (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-name", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Item::get_uname_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-uname-path", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Item::group_undo (const Sfi::String& name) {
  sfi_glue_vcall_void ("BseItem+group-undo", 'p', _object_id, 's', name.c_str(), 0);
}

SfiBool
Bse::Item::internal (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseItem+internal", 'p', _object_id, 0);
  return _retval;
}

Bse::StringSeq
Bse::Item::list_parasites (const Sfi::String& path) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseItem+list-parasites", 'p', _object_id, 's', path.c_str(), 0);
  return Bse::StringSeq::from_seq (_retval);
}

void
Bse::Item::redo (void) {
  sfi_glue_vcall_void ("BseItem+redo", 'p', _object_id, 0);
}

SfiInt
Bse::Item::redo_depth (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+redo-depth", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Item::set_name (const Sfi::String& name) {
  sfi_glue_vcall_void ("BseItem+set-name", 'p', _object_id, 's', name.c_str(), 0);
}

void
Bse::Item::set_parasite (const Sfi::String& path, SfiRec* parasite) {
  sfi_glue_vcall_void ("BseItem+set-parasite", 'p', _object_id, 's', path.c_str(), 'R', parasite, 0);
}

void
Bse::Item::undo (void) {
  sfi_glue_vcall_void ("BseItem+undo", 'p', _object_id, 0);
}

SfiInt
Bse::Item::undo_depth (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+undo-depth", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Item::ungroup_undo (void) {
  sfi_glue_vcall_void ("BseItem+ungroup-undo", 'p', _object_id, 0);
}

void
Bse::Item::unuse (void) {
  sfi_glue_vcall_void ("BseItem+unuse", 'p', _object_id, 0);
}

Bse::Item
Bse::Item::use (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+use", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Item::seqid ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "seqid");
  return sfi_value_get_int (val);
}

void
Bse::Item::set_seqid (SfiInt new_seqid)
{
  GValue *val = sfi_value_int (new_seqid);
  sfi_glue_proxy_set_property (_proxy(), "seqid", val);
  sfi_value_free (val);
}

SfiInt
Bse::DataPocket::create_entry (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+create-entry", 'p', _object_id, 0);
  return _retval;
}

Bse::ErrorType
Bse::DataPocket::delete_entry (SfiInt entry_id) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+delete-entry", 'p', _object_id, 'i', entry_id, 0);
  return bse_error_type_from_choice (_retval);
}

SfiReal
Bse::DataPocket::get_float (SfiInt entry_id, const Sfi::String& name) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseDataPocket+get-float", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 0);
  return _retval;
}

SfiInt
Bse::DataPocket::get_int (SfiInt entry_id, const Sfi::String& name) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-int", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 0);
  return _retval;
}

SfiInt
Bse::DataPocket::get_n_entries (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-n-entries", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::DataPocket::get_nth_entry_id (SfiInt entry_index) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-nth-entry-id", 'p', _object_id, 'i', entry_index, 0);
  return _retval;
}

Bse::Item
Bse::DataPocket::get_object (SfiInt entry_id, const Sfi::String& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseDataPocket+get-object", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 0);
  return _retval;
}

Sfi::String
Bse::DataPocket::get_string (SfiInt entry_id, const Sfi::String& name) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseDataPocket+get-string", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 0);
  return _retval;
}

Bse::ErrorType
Bse::DataPocket::set_float (SfiInt entry_id, const Sfi::String& name, SfiReal number) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-float", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 'r', number, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::DataPocket::set_int (SfiInt entry_id, const Sfi::String& name, SfiInt number) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-int", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 'i', number, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::DataPocket::set_object (SfiInt entry_id, const Sfi::String& name, Bse::Item item) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-object", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 'p', item._proxy(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::DataPocket::set_string (SfiInt entry_id, const Sfi::String& name, const Sfi::String& string) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-string", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 's', string.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::EditableSample::close (void) {
  sfi_glue_vcall_void ("BseEditableSample+close", 'p', _object_id, 0);
}

Bse::FloatSeq
Bse::EditableSample::collect_stats (SfiInt voffset, SfiReal offset_scale, SfiInt block_size, SfiInt stepping, SfiInt max_pairs) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseEditableSample+collect-stats", 'p', _object_id, 'i', voffset, 'r', offset_scale, 'i', block_size, 'i', stepping, 'i', max_pairs, 0);
  return Bse::FloatSeq::from_seq (_retval);
}

SfiInt
Bse::EditableSample::get_length (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseEditableSample+get-length", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::EditableSample::get_n_channels (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseEditableSample+get-n-channels", 'p', _object_id, 0);
  return _retval;
}

SfiReal
Bse::EditableSample::get_osc_freq (void) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseEditableSample+get-osc-freq", 'p', _object_id, 0);
  return _retval;
}

Bse::ErrorType
Bse::EditableSample::open (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseEditableSample+open", 'p', _object_id, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::FloatSeq
Bse::EditableSample::read_samples (SfiInt voffset) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseEditableSample+read-samples", 'p', _object_id, 'i', voffset, 0);
  return Bse::FloatSeq::from_seq (_retval);
}

Sfi::String
Bse::Janitor::get_action (SfiInt nth_action) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action", 'p', _object_id, 'i', nth_action, 0);
  return _retval;
}

Sfi::String
Bse::Janitor::get_action_blurb (SfiInt nth_action) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action-blurb", 'p', _object_id, 'i', nth_action, 0);
  return _retval;
}

Sfi::String
Bse::Janitor::get_action_name (SfiInt nth_action) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action-name", 'p', _object_id, 'i', nth_action, 0);
  return _retval;
}

Sfi::String
Bse::Janitor::get_proc_name (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-proc-name", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Janitor::get_script_name (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-script-name", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Janitor::kill (void) {
  sfi_glue_vcall_void ("BseJanitor+kill", 'p', _object_id, 0);
}

SfiInt
Bse::Janitor::n_actions (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseJanitor+n-actions", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Janitor::trigger_action (const Sfi::String& action) {
  sfi_glue_vcall_void ("BseJanitor+trigger-action", 'p', _object_id, 's', action.c_str(), 0);
}

Sfi::String
Bse::Janitor::ident ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "ident");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Janitor::set_ident (const Sfi::String& new_ident)
{
  GValue *val = sfi_value_string (new_ident.c_str());
  sfi_glue_proxy_set_property (_proxy(), "ident", val);
  sfi_value_free (val);
}

SfiBool
Bse::Janitor::connected ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "connected");
  return sfi_value_get_bool (val);
}

void
Bse::Janitor::set_connected (SfiBool new_connected)
{
  GValue *val = sfi_value_bool (new_connected);
  sfi_glue_proxy_set_property (_proxy(), "connected", val);
  sfi_value_free (val);
}

Sfi::String
Bse::Janitor::status_message ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "status-message");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Janitor::set_status_message (const Sfi::String& new_status_message)
{
  GValue *val = sfi_value_string (new_status_message.c_str());
  sfi_glue_proxy_set_property (_proxy(), "status-message", val);
  sfi_value_free (val);
}

SfiInt
Bse::Janitor::exit_code ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "exit-code");
  return sfi_value_get_int (val);
}

void
Bse::Janitor::set_exit_code (SfiInt new_exit_code)
{
  GValue *val = sfi_value_int (new_exit_code);
  sfi_glue_proxy_set_property (_proxy(), "exit-code", val);
  sfi_value_free (val);
}

Sfi::String
Bse::Janitor::exit_reason ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "exit-reason");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Janitor::set_exit_reason (const Sfi::String& new_exit_reason)
{
  GValue *val = sfi_value_string (new_exit_reason.c_str());
  sfi_glue_proxy_set_property (_proxy(), "exit-reason", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiNotifier::current_time (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseMidiNotifier+current-time", 'p', _object_id, 0);
  return _retval;
}

Bse::ErrorType
Bse::Part::change_control (SfiInt id, SfiInt tick, Bse::MidiSignalType control_type, SfiReal value) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+change-control", 'p', _object_id, 'i', id, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 'r', value, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Part::change_note (SfiInt id, SfiInt tick, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+change-note", 'p', _object_id, 'i', id, 'i', tick, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::PartNoteSeq
Bse::Part::check_overlap (SfiInt tick, SfiInt duration, SfiInt note) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+check-overlap", 'p', _object_id, 'i', tick, 'i', duration, 'i', note, 0);
  return Bse::PartNoteSeq::from_seq (_retval);
}

Bse::ErrorType
Bse::Part::delete_event (SfiInt id) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+delete-event", 'p', _object_id, 'i', id, 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Part::deselect_controls (SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  sfi_glue_vcall_void ("BsePart+deselect-controls", 'p', _object_id, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
}

void
Bse::Part::deselect_event (SfiInt id) {
  sfi_glue_vcall_void ("BsePart+deselect-event", 'p', _object_id, 'i', id, 0);
}

void
Bse::Part::deselect_notes (SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+deselect-notes", 'p', _object_id, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

Bse::PartControlSeq
Bse::Part::get_channel_controls (SfiInt channel, SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+get-channel-controls", 'p', _object_id, 'i', channel, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  return Bse::PartControlSeq::from_seq (_retval);
}

Bse::PartControlSeq
Bse::Part::get_controls (SfiInt tick, Bse::MidiSignalType control_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+get-controls", 'p', _object_id, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  return Bse::PartControlSeq::from_seq (_retval);
}

SfiInt
Bse::Part::get_max_note (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+get-max-note", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Part::get_min_note (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+get-min-note", 'p', _object_id, 0);
  return _retval;
}

Bse::PartNoteSeq
Bse::Part::get_notes (SfiInt tick, SfiInt note) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+get-notes", 'p', _object_id, 'i', tick, 'i', note, 0);
  return Bse::PartNoteSeq::from_seq (_retval);
}

Bse::SongTimingHandle
Bse::Part::get_timing (SfiInt tick) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BsePart+get-timing", 'p', _object_id, 'i', tick, 0);
  return Bse::SongTiming::from_rec (_retval);
}

SfiInt
Bse::Part::insert_control (SfiInt tick, Bse::MidiSignalType control_type, SfiReal value) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+insert-control", 'p', _object_id, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 'r', value, 0);
  return _retval;
}

SfiInt
Bse::Part::insert_note (SfiInt channel, SfiInt tick, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+insert-note", 'p', _object_id, 'i', channel, 'i', tick, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
  return _retval;
}

SfiInt
Bse::Part::insert_note_auto (SfiInt tick, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+insert-note-auto", 'p', _object_id, 'i', tick, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
  return _retval;
}

SfiBool
Bse::Part::is_event_selected (SfiInt id) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BsePart+is-event-selected", 'p', _object_id, 'i', id, 0);
  return _retval;
}

Bse::PartControlSeq
Bse::Part::list_controls (SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-controls", 'p', _object_id, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  return Bse::PartControlSeq::from_seq (_retval);
}

Bse::PartLinkSeq
Bse::Part::list_links (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-links", 'p', _object_id, 0);
  return Bse::PartLinkSeq::from_seq (_retval);
}

Bse::PartNoteSeq
Bse::Part::list_notes_crossing (SfiInt tick, SfiInt duration) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-notes-crossing", 'p', _object_id, 'i', tick, 'i', duration, 0);
  return Bse::PartNoteSeq::from_seq (_retval);
}

Bse::PartNoteSeq
Bse::Part::list_notes_within (SfiInt channel, SfiInt tick, SfiInt duration) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-notes-within", 'p', _object_id, 'i', channel, 'i', tick, 'i', duration, 0);
  return Bse::PartNoteSeq::from_seq (_retval);
}

Bse::PartControlSeq
Bse::Part::list_selected_controls (Bse::MidiSignalType control_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-selected-controls", 'p', _object_id, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  return Bse::PartControlSeq::from_seq (_retval);
}

Bse::PartNoteSeq
Bse::Part::list_selected_notes (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-selected-notes", 'p', _object_id, 0);
  return Bse::PartNoteSeq::from_seq (_retval);
}

void
Bse::Part::queue_controls (SfiInt tick, SfiInt duration) {
  sfi_glue_vcall_void ("BsePart+queue-controls", 'p', _object_id, 'i', tick, 'i', duration, 0);
}

void
Bse::Part::queue_notes (SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+queue-notes", 'p', _object_id, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

void
Bse::Part::select_controls (SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  sfi_glue_vcall_void ("BsePart+select-controls", 'p', _object_id, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
}

void
Bse::Part::select_controls_exclusive (SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  sfi_glue_vcall_void ("BsePart+select-controls-exclusive", 'p', _object_id, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
}

void
Bse::Part::select_event (SfiInt id) {
  sfi_glue_vcall_void ("BsePart+select-event", 'p', _object_id, 'i', id, 0);
}

void
Bse::Part::select_notes (SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+select-notes", 'p', _object_id, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

void
Bse::Part::select_notes_exclusive (SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+select-notes-exclusive", 'p', _object_id, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

SfiInt
Bse::Part::n_channels ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "n-channels");
  return sfi_value_get_int (val);
}

void
Bse::Part::set_n_channels (SfiInt new_n_channels)
{
  GValue *val = sfi_value_int (new_n_channels);
  sfi_glue_proxy_set_property (_proxy(), "n-channels", val);
  sfi_value_free (val);
}

SfiInt
Bse::Part::last_tick ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "last-tick");
  return sfi_value_get_int (val);
}

void
Bse::Part::set_last_tick (SfiInt new_last_tick)
{
  GValue *val = sfi_value_int (new_last_tick);
  sfi_glue_proxy_set_property (_proxy(), "last-tick", val);
  sfi_value_free (val);
}

void
Bse::Source::clear_inputs (void) {
  sfi_glue_vcall_void ("BseSource+clear-inputs", 'p', _object_id, 0);
}

void
Bse::Source::clear_outputs (void) {
  sfi_glue_vcall_void ("BseSource+clear-outputs", 'p', _object_id, 0);
}

SfiInt
Bse::Source::get_automation_channel (const Sfi::String& property_name) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+get-automation-channel", 'p', _object_id, 's', property_name.c_str(), 0);
  return _retval;
}

Bse::MidiControlType
Bse::Source::get_automation_control (const Sfi::String& property_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+get-automation-control", 'p', _object_id, 's', property_name.c_str(), 0);
  return bse_midi_control_type_from_choice (_retval);
}

SfiBool
Bse::Source::has_output (SfiInt ochannel) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+has-output", 'p', _object_id, 'i', ochannel, 0);
  return _retval;
}

SfiBool
Bse::Source::has_outputs (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+has-outputs", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Source::ichannel_blurb (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-blurb", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

SfiInt
Bse::Source::ichannel_get_n_joints (SfiInt input_channel) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+ichannel-get-n-joints", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

SfiInt
Bse::Source::ichannel_get_ochannel (SfiInt input_channel, SfiInt input_joint) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+ichannel-get-ochannel", 'p', _object_id, 'i', input_channel, 'i', input_joint, 0);
  return _retval;
}

Bse::Source
Bse::Source::ichannel_get_osource (SfiInt input_channel, SfiInt input_joint) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSource+ichannel-get-osource", 'p', _object_id, 'i', input_channel, 'i', input_joint, 0);
  return _retval;
}

Sfi::String
Bse::Source::ichannel_ident (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-ident", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

Sfi::String
Bse::Source::ichannel_label (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-label", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

SfiBool
Bse::Source::is_joint_ichannel (const Sfi::String& input_channel) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+is-joint-ichannel", 'p', _object_id, 's', input_channel.c_str(), 0);
  return _retval;
}

SfiBool
Bse::Source::is_joint_ichannel_by_id (SfiInt input_channel) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+is-joint-ichannel-by-id", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

SfiBool
Bse::Source::is_prepared (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+is-prepared", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Source::n_ichannels (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+n-ichannels", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Source::n_ochannels (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+n-ochannels", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Source::ochannel_blurb (SfiInt output_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-blurb", 'p', _object_id, 'i', output_channel, 0);
  return _retval;
}

Sfi::String
Bse::Source::ochannel_ident (SfiInt output_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-ident", 'p', _object_id, 'i', output_channel, 0);
  return _retval;
}

Sfi::String
Bse::Source::ochannel_label (SfiInt output_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-label", 'p', _object_id, 'i', output_channel, 0);
  return _retval;
}

Bse::ErrorType
Bse::Source::set_automation (const Sfi::String& property_name, SfiInt midi_channel, Bse::MidiControlType control_type) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+set-automation", 'p', _object_id, 's', property_name.c_str(), 'i', midi_channel, 'C', bse_midi_control_type_to_choice (control_type), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Source::set_input (const Sfi::String& input_channel, Bse::Source omodule, const Sfi::String& output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+set-input", 'p', _object_id, 's', input_channel.c_str(), 'p', omodule._proxy(), 's', output_channel.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Source::set_input_by_id (SfiInt input_channel, Bse::Source omodule, SfiInt output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+set-input-by-id", 'p', _object_id, 'i', input_channel, 'p', omodule._proxy(), 'i', output_channel, 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Source::set_pos (SfiReal x_pos, SfiReal y_pos) {
  sfi_glue_vcall_void ("BseSource+set-pos", 'p', _object_id, 'r', x_pos, 'r', y_pos, 0);
}

Bse::ErrorType
Bse::Source::unset_input (const Sfi::String& input_channel, Bse::Source omodule, const Sfi::String& output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+unset-input", 'p', _object_id, 's', input_channel.c_str(), 'p', omodule._proxy(), 's', output_channel.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Source::unset_input_by_id (SfiInt input_channel, Bse::Source omodule, SfiInt output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+unset-input-by-id", 'p', _object_id, 'i', input_channel, 'p', omodule._proxy(), 'i', output_channel, 0);
  return bse_error_type_from_choice (_retval);
}

SfiReal
Bse::Source::pos_x ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pos-x");
  return sfi_value_get_real (val);
}

void
Bse::Source::set_pos_x (SfiReal new_pos_x)
{
  GValue *val = sfi_value_real (new_pos_x);
  sfi_glue_proxy_set_property (_proxy(), "pos-x", val);
  sfi_value_free (val);
}

SfiReal
Bse::Source::pos_y ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pos-y");
  return sfi_value_get_real (val);
}

void
Bse::Source::set_pos_y (SfiReal new_pos_y)
{
  GValue *val = sfi_value_real (new_pos_y);
  sfi_glue_proxy_set_property (_proxy(), "pos-y", val);
  sfi_value_free (val);
}

Bse::BiquadFilterType
Bse::BiquadFilter::filter_type ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "filter-type");
  return bse_biquad_filter_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::BiquadFilter::set_filter_type (Bse::BiquadFilterType new_filter_type)
{
  GValue *val = sfi_value_choice (bse_biquad_filter_type_to_choice (new_filter_type));
  sfi_glue_proxy_set_property (_proxy(), "filter-type", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::freq ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "freq");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_freq (SfiReal new_freq)
{
  GValue *val = sfi_value_real (new_freq);
  sfi_glue_proxy_set_property (_proxy(), "freq", val);
  sfi_value_free (val);
}

SfiInt
Bse::BiquadFilter::note ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note");
  return sfi_value_get_int (val);
}

void
Bse::BiquadFilter::set_note (SfiInt new_note)
{
  GValue *val = sfi_value_int (new_note);
  sfi_glue_proxy_set_property (_proxy(), "note", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::gain ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_gain (SfiReal new_gain)
{
  GValue *val = sfi_value_real (new_gain);
  sfi_glue_proxy_set_property (_proxy(), "gain", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::fm_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-perc");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_fm_perc (SfiReal new_fm_perc)
{
  GValue *val = sfi_value_real (new_fm_perc);
  sfi_glue_proxy_set_property (_proxy(), "fm-perc", val);
  sfi_value_free (val);
}

SfiBool
Bse::BiquadFilter::exponential_fm ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "exponential-fm");
  return sfi_value_get_bool (val);
}

void
Bse::BiquadFilter::set_exponential_fm (SfiBool new_exponential_fm)
{
  GValue *val = sfi_value_bool (new_exponential_fm);
  sfi_glue_proxy_set_property (_proxy(), "exponential-fm", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::fm_n_octaves ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-n-octaves");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_fm_n_octaves (SfiReal new_fm_n_octaves)
{
  GValue *val = sfi_value_real (new_fm_n_octaves);
  sfi_glue_proxy_set_property (_proxy(), "fm-n-octaves", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::gain_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain-perc");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_gain_perc (SfiReal new_gain_perc)
{
  GValue *val = sfi_value_real (new_gain_perc);
  sfi_glue_proxy_set_property (_proxy(), "gain-perc", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-1");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_1 (SfiReal new_value_1)
{
  GValue *val = sfi_value_real (new_value_1);
  sfi_glue_proxy_set_property (_proxy(), "value-1", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-1");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_1 (SfiReal new_frequency_1)
{
  GValue *val = sfi_value_real (new_frequency_1);
  sfi_glue_proxy_set_property (_proxy(), "frequency-1", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-1");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_1 (SfiInt new_note_1)
{
  GValue *val = sfi_value_int (new_note_1);
  sfi_glue_proxy_set_property (_proxy(), "note-1", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-2");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_2 (SfiReal new_value_2)
{
  GValue *val = sfi_value_real (new_value_2);
  sfi_glue_proxy_set_property (_proxy(), "value-2", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-2");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_2 (SfiReal new_frequency_2)
{
  GValue *val = sfi_value_real (new_frequency_2);
  sfi_glue_proxy_set_property (_proxy(), "frequency-2", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-2");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_2 (SfiInt new_note_2)
{
  GValue *val = sfi_value_int (new_note_2);
  sfi_glue_proxy_set_property (_proxy(), "note-2", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-3");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_3 (SfiReal new_value_3)
{
  GValue *val = sfi_value_real (new_value_3);
  sfi_glue_proxy_set_property (_proxy(), "value-3", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-3");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_3 (SfiReal new_frequency_3)
{
  GValue *val = sfi_value_real (new_frequency_3);
  sfi_glue_proxy_set_property (_proxy(), "frequency-3", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-3");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_3 (SfiInt new_note_3)
{
  GValue *val = sfi_value_int (new_note_3);
  sfi_glue_proxy_set_property (_proxy(), "note-3", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-4");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_4 (SfiReal new_value_4)
{
  GValue *val = sfi_value_real (new_value_4);
  sfi_glue_proxy_set_property (_proxy(), "value-4", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-4");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_4 (SfiReal new_frequency_4)
{
  GValue *val = sfi_value_real (new_frequency_4);
  sfi_glue_proxy_set_property (_proxy(), "frequency-4", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-4");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_4 (SfiInt new_note_4)
{
  GValue *val = sfi_value_int (new_note_4);
  sfi_glue_proxy_set_property (_proxy(), "note-4", val);
  sfi_value_free (val);
}

Bse::Item
Bse::Container::get_item (const Sfi::String& item_type, SfiInt seq_id) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseContainer+get-item", 'p', _object_id, 's', item_type.c_str(), 'i', seq_id, 0);
  return _retval;
}

Bse::ItemSeq
Bse::Container::list_children (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseContainer+list-children", 'p', _object_id, 0);
  return Bse::ItemSeq::from_seq (_retval);
}

Bse::Item
Bse::Container::lookup_item (const Sfi::String& uname) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseContainer+lookup-item", 'p', _object_id, 's', uname.c_str(), 0);
  return _retval;
}

SfiInt
Bse::MidiController::midi_channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "midi-channel");
  return sfi_value_get_int (val);
}

void
Bse::MidiController::set_midi_channel (SfiInt new_midi_channel)
{
  GValue *val = sfi_value_int (new_midi_channel);
  sfi_glue_proxy_set_property (_proxy(), "midi-channel", val);
  sfi_value_free (val);
}

Bse::MidiSignalType
Bse::MidiController::control_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "control-1");
  return bse_midi_signal_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::MidiController::set_control_1 (Bse::MidiSignalType new_control_1)
{
  GValue *val = sfi_value_choice (bse_midi_signal_type_to_choice (new_control_1));
  sfi_glue_proxy_set_property (_proxy(), "control-1", val);
  sfi_value_free (val);
}

Bse::MidiSignalType
Bse::MidiController::control_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "control-2");
  return bse_midi_signal_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::MidiController::set_control_2 (Bse::MidiSignalType new_control_2)
{
  GValue *val = sfi_value_choice (bse_midi_signal_type_to_choice (new_control_2));
  sfi_glue_proxy_set_property (_proxy(), "control-2", val);
  sfi_value_free (val);
}

Bse::MidiSignalType
Bse::MidiController::control_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "control-3");
  return bse_midi_signal_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::MidiController::set_control_3 (Bse::MidiSignalType new_control_3)
{
  GValue *val = sfi_value_choice (bse_midi_signal_type_to_choice (new_control_3));
  sfi_glue_proxy_set_property (_proxy(), "control-3", val);
  sfi_value_free (val);
}

Bse::MidiSignalType
Bse::MidiController::control_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "control-4");
  return bse_midi_signal_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::MidiController::set_control_4 (Bse::MidiSignalType new_control_4)
{
  GValue *val = sfi_value_choice (bse_midi_signal_type_to_choice (new_control_4));
  sfi_glue_proxy_set_property (_proxy(), "control-4", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiInput::midi_channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "midi-channel");
  return sfi_value_get_int (val);
}

void
Bse::MidiInput::set_midi_channel (SfiInt new_midi_channel)
{
  GValue *val = sfi_value_int (new_midi_channel);
  sfi_glue_proxy_set_property (_proxy(), "midi-channel", val);
  sfi_value_free (val);
}

SfiReal
Bse::PcmInput::gain_volume_f ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain-volume-f");
  return sfi_value_get_real (val);
}

void
Bse::PcmInput::set_gain_volume_f (SfiReal new_gain_volume_f)
{
  GValue *val = sfi_value_real (new_gain_volume_f);
  sfi_glue_proxy_set_property (_proxy(), "gain-volume-f", val);
  sfi_value_free (val);
}

SfiReal
Bse::PcmInput::gain_volume_d_b ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain-volume-d-b");
  return sfi_value_get_real (val);
}

void
Bse::PcmInput::set_gain_volume_d_b (SfiReal new_gain_volume_d_b)
{
  GValue *val = sfi_value_real (new_gain_volume_d_b);
  sfi_glue_proxy_set_property (_proxy(), "gain-volume-d-b", val);
  sfi_value_free (val);
}

SfiInt
Bse::PcmInput::gain_volume_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain-volume-perc");
  return sfi_value_get_int (val);
}

void
Bse::PcmInput::set_gain_volume_perc (SfiInt new_gain_volume_perc)
{
  GValue *val = sfi_value_int (new_gain_volume_perc);
  sfi_glue_proxy_set_property (_proxy(), "gain-volume-perc", val);
  sfi_value_free (val);
}

SfiReal
Bse::PcmOutput::master_volume_f ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "master-volume-f");
  return sfi_value_get_real (val);
}

void
Bse::PcmOutput::set_master_volume_f (SfiReal new_master_volume_f)
{
  GValue *val = sfi_value_real (new_master_volume_f);
  sfi_glue_proxy_set_property (_proxy(), "master-volume-f", val);
  sfi_value_free (val);
}

SfiReal
Bse::PcmOutput::master_volume_d_b ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "master-volume-d-b");
  return sfi_value_get_real (val);
}

void
Bse::PcmOutput::set_master_volume_d_b (SfiReal new_master_volume_d_b)
{
  GValue *val = sfi_value_real (new_master_volume_d_b);
  sfi_glue_proxy_set_property (_proxy(), "master-volume-d-b", val);
  sfi_value_free (val);
}

SfiInt
Bse::PcmOutput::master_volume_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "master-volume-perc");
  return sfi_value_get_int (val);
}

void
Bse::PcmOutput::set_master_volume_perc (SfiInt new_master_volume_perc)
{
  GValue *val = sfi_value_int (new_master_volume_perc);
  sfi_glue_proxy_set_property (_proxy(), "master-volume-perc", val);
  sfi_value_free (val);
}

SfiInt
Bse::Snooper::context_id ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "context-id");
  return sfi_value_get_int (val);
}

void
Bse::Snooper::set_context_id (SfiInt new_context_id)
{
  GValue *val = sfi_value_int (new_context_id);
  sfi_glue_proxy_set_property (_proxy(), "context-id", val);
  sfi_value_free (val);
}

Bse::StandardOscWaveType
Bse::StandardOsc::wave_form ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave-form");
  return bse_standard_osc_wave_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::StandardOsc::set_wave_form (Bse::StandardOscWaveType new_wave_form)
{
  GValue *val = sfi_value_choice (bse_standard_osc_wave_type_to_choice (new_wave_form));
  sfi_glue_proxy_set_property (_proxy(), "wave-form", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::phase ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "phase");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_phase (SfiReal new_phase)
{
  GValue *val = sfi_value_real (new_phase);
  sfi_glue_proxy_set_property (_proxy(), "phase", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::base_freq ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "base-freq");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_base_freq (SfiReal new_base_freq)
{
  GValue *val = sfi_value_real (new_base_freq);
  sfi_glue_proxy_set_property (_proxy(), "base-freq", val);
  sfi_value_free (val);
}

SfiInt
Bse::StandardOsc::base_note ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "base-note");
  return sfi_value_get_int (val);
}

void
Bse::StandardOsc::set_base_note (SfiInt new_base_note)
{
  GValue *val = sfi_value_int (new_base_note);
  sfi_glue_proxy_set_property (_proxy(), "base-note", val);
  sfi_value_free (val);
}

SfiInt
Bse::StandardOsc::transpose ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "transpose");
  return sfi_value_get_int (val);
}

void
Bse::StandardOsc::set_transpose (SfiInt new_transpose)
{
  GValue *val = sfi_value_int (new_transpose);
  sfi_glue_proxy_set_property (_proxy(), "transpose", val);
  sfi_value_free (val);
}

SfiInt
Bse::StandardOsc::fine_tune ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fine-tune");
  return sfi_value_get_int (val);
}

void
Bse::StandardOsc::set_fine_tune (SfiInt new_fine_tune)
{
  GValue *val = sfi_value_int (new_fine_tune);
  sfi_glue_proxy_set_property (_proxy(), "fine-tune", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::fm_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-perc");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_fm_perc (SfiReal new_fm_perc)
{
  GValue *val = sfi_value_real (new_fm_perc);
  sfi_glue_proxy_set_property (_proxy(), "fm-perc", val);
  sfi_value_free (val);
}

SfiBool
Bse::StandardOsc::exponential_fm ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "exponential-fm");
  return sfi_value_get_bool (val);
}

void
Bse::StandardOsc::set_exponential_fm (SfiBool new_exponential_fm)
{
  GValue *val = sfi_value_bool (new_exponential_fm);
  sfi_glue_proxy_set_property (_proxy(), "exponential-fm", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::fm_n_octaves ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-n-octaves");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_fm_n_octaves (SfiReal new_fm_n_octaves)
{
  GValue *val = sfi_value_real (new_fm_n_octaves);
  sfi_glue_proxy_set_property (_proxy(), "fm-n-octaves", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::self_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "self-perc");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_self_perc (SfiReal new_self_perc)
{
  GValue *val = sfi_value_real (new_self_perc);
  sfi_glue_proxy_set_property (_proxy(), "self-perc", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::pulse_width ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pulse-width");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_pulse_width (SfiReal new_pulse_width)
{
  GValue *val = sfi_value_real (new_pulse_width);
  sfi_glue_proxy_set_property (_proxy(), "pulse-width", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::pulse_mod_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pulse-mod-perc");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_pulse_mod_perc (SfiReal new_pulse_mod_perc)
{
  GValue *val = sfi_value_real (new_pulse_mod_perc);
  sfi_glue_proxy_set_property (_proxy(), "pulse-mod-perc", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubIPort::in_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-1");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubIPort::set_in_port_1 (const Sfi::String& new_in_port_1)
{
  GValue *val = sfi_value_string (new_in_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-1", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubIPort::in_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-2");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubIPort::set_in_port_2 (const Sfi::String& new_in_port_2)
{
  GValue *val = sfi_value_string (new_in_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-2", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubIPort::in_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-3");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubIPort::set_in_port_3 (const Sfi::String& new_in_port_3)
{
  GValue *val = sfi_value_string (new_in_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-3", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubIPort::in_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-4");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubIPort::set_in_port_4 (const Sfi::String& new_in_port_4)
{
  GValue *val = sfi_value_string (new_in_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-4", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubOPort::out_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-1");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubOPort::set_out_port_1 (const Sfi::String& new_out_port_1)
{
  GValue *val = sfi_value_string (new_out_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-1", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubOPort::out_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-2");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubOPort::set_out_port_2 (const Sfi::String& new_out_port_2)
{
  GValue *val = sfi_value_string (new_out_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-2", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubOPort::out_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-3");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubOPort::set_out_port_3 (const Sfi::String& new_out_port_3)
{
  GValue *val = sfi_value_string (new_out_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-3", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubOPort::out_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-4");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubOPort::set_out_port_4 (const Sfi::String& new_out_port_4)
{
  GValue *val = sfi_value_string (new_out_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-4", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::SubSynth::snet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "snet");
  return sfi_value_get_proxy (val);
}

void
Bse::SubSynth::set_snet (Bse::CSynth new_snet)
{
  GValue *val = sfi_value_proxy (new_snet);
  sfi_glue_proxy_set_property (_proxy(), "snet", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::in_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-1");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_in_port_1 (const Sfi::String& new_in_port_1)
{
  GValue *val = sfi_value_string (new_in_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-1", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::out_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-1");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_out_port_1 (const Sfi::String& new_out_port_1)
{
  GValue *val = sfi_value_string (new_out_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-1", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::in_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-2");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_in_port_2 (const Sfi::String& new_in_port_2)
{
  GValue *val = sfi_value_string (new_in_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-2", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::out_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-2");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_out_port_2 (const Sfi::String& new_out_port_2)
{
  GValue *val = sfi_value_string (new_out_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-2", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::in_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-3");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_in_port_3 (const Sfi::String& new_in_port_3)
{
  GValue *val = sfi_value_string (new_in_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-3", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::out_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-3");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_out_port_3 (const Sfi::String& new_out_port_3)
{
  GValue *val = sfi_value_string (new_out_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-3", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::in_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-4");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_in_port_4 (const Sfi::String& new_in_port_4)
{
  GValue *val = sfi_value_string (new_in_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-4", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::out_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-4");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_out_port_4 (const Sfi::String& new_out_port_4)
{
  GValue *val = sfi_value_string (new_out_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-4", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::in_port_5 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-5");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_in_port_5 (const Sfi::String& new_in_port_5)
{
  GValue *val = sfi_value_string (new_in_port_5.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-5", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::out_port_5 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-5");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_out_port_5 (const Sfi::String& new_out_port_5)
{
  GValue *val = sfi_value_string (new_out_port_5.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-5", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::in_port_6 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-6");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_in_port_6 (const Sfi::String& new_in_port_6)
{
  GValue *val = sfi_value_string (new_in_port_6.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-6", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::out_port_6 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-6");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_out_port_6 (const Sfi::String& new_out_port_6)
{
  GValue *val = sfi_value_string (new_out_port_6.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-6", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::in_port_7 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-7");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_in_port_7 (const Sfi::String& new_in_port_7)
{
  GValue *val = sfi_value_string (new_in_port_7.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-7", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::out_port_7 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-7");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_out_port_7 (const Sfi::String& new_out_port_7)
{
  GValue *val = sfi_value_string (new_out_port_7.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-7", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::in_port_8 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-8");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_in_port_8 (const Sfi::String& new_in_port_8)
{
  GValue *val = sfi_value_string (new_in_port_8.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-8", val);
  sfi_value_free (val);
}

Sfi::String
Bse::SubSynth::out_port_8 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-8");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::SubSynth::set_out_port_8 (const Sfi::String& new_out_port_8)
{
  GValue *val = sfi_value_string (new_out_port_8.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-8", val);
  sfi_value_free (val);
}

SfiReal
Bse::Wave::chunk_get_mix_freq (SfiInt chunk_index) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseWave+chunk-get-mix-freq", 'p', _object_id, 'i', chunk_index, 0);
  return _retval;
}

SfiReal
Bse::Wave::chunk_get_osc_freq (SfiInt chunk_index) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseWave+chunk-get-osc-freq", 'p', _object_id, 'i', chunk_index, 0);
  return _retval;
}

Bse::ErrorType
Bse::Wave::load_wave (const Sfi::String& file_name, const Sfi::String& wave_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseWave+load-wave", 'p', _object_id, 's', file_name.c_str(), 's', wave_name.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

SfiInt
Bse::Wave::n_wave_chunks (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseWave+n-wave-chunks", 'p', _object_id, 0);
  return _retval;
}

Bse::EditableSample
Bse::Wave::use_editable (SfiInt chunk_index) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseWave+use-editable", 'p', _object_id, 'i', chunk_index, 0);
  return _retval;
}

SfiBool
Bse::Wave::locator_set ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "locator-set");
  return sfi_value_get_bool (val);
}

void
Bse::Wave::set_locator_set (SfiBool new_locator_set)
{
  GValue *val = sfi_value_bool (new_locator_set);
  sfi_glue_proxy_set_property (_proxy(), "locator-set", val);
  sfi_value_free (val);
}

Sfi::String
Bse::Wave::file_name ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "file-name");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Wave::set_file_name (const Sfi::String& new_file_name)
{
  GValue *val = sfi_value_string (new_file_name.c_str());
  sfi_glue_proxy_set_property (_proxy(), "file-name", val);
  sfi_value_free (val);
}

Sfi::String
Bse::Wave::wave_name ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave-name");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Wave::set_wave_name (const Sfi::String& new_wave_name)
{
  GValue *val = sfi_value_string (new_wave_name.c_str());
  sfi_glue_proxy_set_property (_proxy(), "wave-name", val);
  sfi_value_free (val);
}

void
Bse::WaveOsc::request_pcm_position (void) {
  sfi_glue_vcall_void ("BseWaveOsc+request-pcm-position", 'p', _object_id, 0);
}

void
Bse::WaveOsc::set_from_editable_sample (Bse::EditableSample esample) {
  sfi_glue_vcall_void ("BseWaveOsc+set-from-editable-sample", 'p', _object_id, 'p', esample._proxy(), 0);
}

Bse::Wave
Bse::WaveOsc::wave ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave");
  return sfi_value_get_proxy (val);
}

void
Bse::WaveOsc::set_wave (Bse::Wave new_wave)
{
  GValue *val = sfi_value_proxy (new_wave);
  sfi_glue_proxy_set_property (_proxy(), "wave", val);
  sfi_value_free (val);
}

SfiInt
Bse::WaveOsc::channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "channel");
  return sfi_value_get_int (val);
}

void
Bse::WaveOsc::set_channel (SfiInt new_channel)
{
  GValue *val = sfi_value_int (new_channel);
  sfi_glue_proxy_set_property (_proxy(), "channel", val);
  sfi_value_free (val);
}

SfiReal
Bse::WaveOsc::fm_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-perc");
  return sfi_value_get_real (val);
}

void
Bse::WaveOsc::set_fm_perc (SfiReal new_fm_perc)
{
  GValue *val = sfi_value_real (new_fm_perc);
  sfi_glue_proxy_set_property (_proxy(), "fm-perc", val);
  sfi_value_free (val);
}

SfiBool
Bse::WaveOsc::exponential_fm ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "exponential-fm");
  return sfi_value_get_bool (val);
}

void
Bse::WaveOsc::set_exponential_fm (SfiBool new_exponential_fm)
{
  GValue *val = sfi_value_bool (new_exponential_fm);
  sfi_glue_proxy_set_property (_proxy(), "exponential-fm", val);
  sfi_value_free (val);
}

SfiReal
Bse::WaveOsc::fm_n_octaves ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-n-octaves");
  return sfi_value_get_real (val);
}

void
Bse::WaveOsc::set_fm_n_octaves (SfiReal new_fm_n_octaves)
{
  GValue *val = sfi_value_real (new_fm_n_octaves);
  sfi_glue_proxy_set_property (_proxy(), "fm-n-octaves", val);
  sfi_value_free (val);
}

Bse::ErrorType
Bse::Bus::connect_bus (Bse::Bus bus) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseBus+connect-bus", 'p', _object_id, 'p', bus._proxy(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Bus::connect_track (Bse::Track track) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseBus+connect-track", 'p', _object_id, 'p', track._proxy(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Bus::disconnect_bus (Bse::Bus bus) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseBus+disconnect-bus", 'p', _object_id, 'p', bus._proxy(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Bus::disconnect_track (Bse::Track track) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseBus+disconnect-track", 'p', _object_id, 'p', track._proxy(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Bus::ensure_output (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseBus+ensure-output", 'p', _object_id, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ItemSeq
Bse::Bus::inputs ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "inputs");
  return Bse::ItemSeq::from_seq (sfi_value_get_seq (val));
}

void
Bse::Bus::set_inputs (const Bse::ItemSeq& new_inputs)
{
  GValue *val = sfi_value_new_take_seq (Bse::ItemSeq::to_seq (new_inputs));
  sfi_glue_proxy_set_property (_proxy(), "inputs", val);
  sfi_value_free (val);
}

Bse::ItemSeq
Bse::Bus::outputs ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "outputs");
  return Bse::ItemSeq::from_seq (sfi_value_get_seq (val));
}

void
Bse::Bus::set_outputs (const Bse::ItemSeq& new_outputs)
{
  GValue *val = sfi_value_new_take_seq (Bse::ItemSeq::to_seq (new_outputs));
  sfi_glue_proxy_set_property (_proxy(), "outputs", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::Bus::snet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "snet");
  return sfi_value_get_proxy (val);
}

void
Bse::Bus::set_snet (Bse::CSynth new_snet)
{
  GValue *val = sfi_value_proxy (new_snet);
  sfi_glue_proxy_set_property (_proxy(), "snet", val);
  sfi_value_free (val);
}

SfiBool
Bse::Bus::mute ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "mute");
  return sfi_value_get_bool (val);
}

void
Bse::Bus::set_mute (SfiBool new_mute)
{
  GValue *val = sfi_value_bool (new_mute);
  sfi_glue_proxy_set_property (_proxy(), "mute", val);
  sfi_value_free (val);
}

SfiBool
Bse::Bus::solo ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "solo");
  return sfi_value_get_bool (val);
}

void
Bse::Bus::set_solo (SfiBool new_solo)
{
  GValue *val = sfi_value_bool (new_solo);
  sfi_glue_proxy_set_property (_proxy(), "solo", val);
  sfi_value_free (val);
}

SfiBool
Bse::Bus::sync ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "sync");
  return sfi_value_get_bool (val);
}

void
Bse::Bus::set_sync (SfiBool new_sync)
{
  GValue *val = sfi_value_bool (new_sync);
  sfi_glue_proxy_set_property (_proxy(), "sync", val);
  sfi_value_free (val);
}

SfiReal
Bse::Bus::left_volume ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "left-volume");
  return sfi_value_get_real (val);
}

void
Bse::Bus::set_left_volume (SfiReal new_left_volume)
{
  GValue *val = sfi_value_real (new_left_volume);
  sfi_glue_proxy_set_property (_proxy(), "left-volume", val);
  sfi_value_free (val);
}

SfiReal
Bse::Bus::right_volume ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "right-volume");
  return sfi_value_get_real (val);
}

void
Bse::Bus::set_right_volume (SfiReal new_right_volume)
{
  GValue *val = sfi_value_real (new_right_volume);
  sfi_glue_proxy_set_property (_proxy(), "right-volume", val);
  sfi_value_free (val);
}

SfiBool
Bse::Bus::master_output ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "master-output");
  return sfi_value_get_bool (val);
}

void
Bse::Bus::set_master_output (SfiBool new_master_output)
{
  GValue *val = sfi_value_bool (new_master_output);
  sfi_glue_proxy_set_property (_proxy(), "master-output", val);
  sfi_value_free (val);
}

Sfi::String
Bse::InstrumentInput::in_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-1");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::InstrumentInput::set_in_port_1 (const Sfi::String& new_in_port_1)
{
  GValue *val = sfi_value_string (new_in_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-1", val);
  sfi_value_free (val);
}

Sfi::String
Bse::InstrumentInput::in_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-2");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::InstrumentInput::set_in_port_2 (const Sfi::String& new_in_port_2)
{
  GValue *val = sfi_value_string (new_in_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-2", val);
  sfi_value_free (val);
}

Sfi::String
Bse::InstrumentInput::in_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-3");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::InstrumentInput::set_in_port_3 (const Sfi::String& new_in_port_3)
{
  GValue *val = sfi_value_string (new_in_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-3", val);
  sfi_value_free (val);
}

Sfi::String
Bse::InstrumentInput::in_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-4");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::InstrumentInput::set_in_port_4 (const Sfi::String& new_in_port_4)
{
  GValue *val = sfi_value_string (new_in_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-4", val);
  sfi_value_free (val);
}

Sfi::String
Bse::InstrumentOutput::out_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-1");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::InstrumentOutput::set_out_port_1 (const Sfi::String& new_out_port_1)
{
  GValue *val = sfi_value_string (new_out_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-1", val);
  sfi_value_free (val);
}

Sfi::String
Bse::InstrumentOutput::out_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-2");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::InstrumentOutput::set_out_port_2 (const Sfi::String& new_out_port_2)
{
  GValue *val = sfi_value_string (new_out_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-2", val);
  sfi_value_free (val);
}

Sfi::String
Bse::InstrumentOutput::out_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-3");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::InstrumentOutput::set_out_port_3 (const Sfi::String& new_out_port_3)
{
  GValue *val = sfi_value_string (new_out_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-3", val);
  sfi_value_free (val);
}

Sfi::String
Bse::InstrumentOutput::out_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-4");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::InstrumentOutput::set_out_port_4 (const Sfi::String& new_out_port_4)
{
  GValue *val = sfi_value_string (new_out_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-4", val);
  sfi_value_free (val);
}

Bse::ErrorType
Bse::Project::import_midi_file (const Sfi::String& file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+import-midi-file", 'p', _object_id, 's', file_name.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Project::restore_from_file (const Sfi::String& file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+restore-from-file", 'p', _object_id, 's', file_name.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Project::store_bse (Bse::Super super, const Sfi::String& file_name, SfiBool self_contained) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+store-bse", 'p', _object_id, 'p', super._proxy(), 's', file_name.c_str(), 'b', self_contained, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Project::activate (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+activate", 'p', _object_id, 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Project::auto_deactivate (SfiInt msec_delay) {
  sfi_glue_vcall_void ("BseProject+auto-deactivate", 'p', _object_id, 'i', msec_delay, 0);
}

SfiBool
Bse::Project::can_play (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+can-play", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Project::change_name (const Sfi::String& name) {
  sfi_glue_vcall_void ("BseProject+change-name", 'p', _object_id, 's', name.c_str(), 0);
}

void
Bse::Project::clean_dirty (void) {
  sfi_glue_vcall_void ("BseProject+clean-dirty", 'p', _object_id, 0);
}

void
Bse::Project::clear_undo (void) {
  sfi_glue_vcall_void ("BseProject+clear-undo", 'p', _object_id, 0);
}

Bse::CSynth
Bse::Project::create_csynth (const Sfi::String& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-csynth", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

Bse::MidiSynth
Bse::Project::create_midi_synth (const Sfi::String& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-midi-synth", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

Bse::Song
Bse::Project::create_song (const Sfi::String& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-song", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

void
Bse::Project::deactivate (void) {
  sfi_glue_vcall_void ("BseProject+deactivate", 'p', _object_id, 0);
}

Bse::Item
Bse::Project::find_item (const Sfi::String& uname_path) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+find-item", 'p', _object_id, 's', uname_path.c_str(), 0);
  return _retval;
}

Bse::DataPocket
Bse::Project::get_data_pocket (const Sfi::String& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+get-data-pocket", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

Bse::MidiNotifier
Bse::Project::get_midi_notifier (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+get-midi-notifier", 'p', _object_id, 0);
  return _retval;
}

Bse::ProjectState
Bse::Project::get_state (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+get-state", 'p', _object_id, 0);
  return bse_project_state_from_choice (_retval);
}

Bse::ItemSeq
Bse::Project::get_supers (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseProject+get-supers", 'p', _object_id, 0);
  return Bse::ItemSeq::from_seq (_retval);
}

Bse::WaveRepo
Bse::Project::get_wave_repo (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+get-wave-repo", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Project::inject_midi_control (SfiInt midi_channel, SfiInt midi_control, SfiReal control_value) {
  sfi_glue_vcall_void ("BseProject+inject-midi-control", 'p', _object_id, 'i', midi_channel, 'i', midi_control, 'r', control_value, 0);
}

SfiBool
Bse::Project::is_active (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+is-active", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::Project::is_dirty (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+is-dirty", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::Project::is_playing (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+is-playing", 'p', _object_id, 0);
  return _retval;
}

Bse::StringSeq
Bse::Project::list_uname_paths (const Sfi::String& item_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseProject+list-uname-paths", 'p', _object_id, 's', item_type.c_str(), 0);
  return Bse::StringSeq::from_seq (_retval);
}

Bse::ItemSeq
Bse::Project::match_items_by_uname (const Sfi::String& item_type, const Sfi::String& uname) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseProject+match-items-by-uname", 'p', _object_id, 's', item_type.c_str(), 's', uname.c_str(), 0);
  return Bse::ItemSeq::from_seq (_retval);
}

Bse::ErrorType
Bse::Project::play (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+play", 'p', _object_id, 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Project::redo (void) {
  sfi_glue_vcall_void ("BseProject+redo", 'p', _object_id, 0);
}

SfiInt
Bse::Project::redo_depth (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseProject+redo-depth", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Project::remove_snet (Bse::SNet snet) {
  sfi_glue_vcall_void ("BseProject+remove-snet", 'p', _object_id, 'p', snet._proxy(), 0);
}

void
Bse::Project::start_playback (void) {
  sfi_glue_vcall_void ("BseProject+start-playback", 'p', _object_id, 0);
}

void
Bse::Project::stop (void) {
  sfi_glue_vcall_void ("BseProject+stop", 'p', _object_id, 0);
}

void
Bse::Project::stop_playback (void) {
  sfi_glue_vcall_void ("BseProject+stop-playback", 'p', _object_id, 0);
}

void
Bse::Project::undo (void) {
  sfi_glue_vcall_void ("BseProject+undo", 'p', _object_id, 0);
}

SfiInt
Bse::Project::undo_depth (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseProject+undo-depth", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::Project::dirty ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "dirty");
  return sfi_value_get_bool (val);
}

void
Bse::Project::set_dirty (SfiBool new_dirty)
{
  GValue *val = sfi_value_bool (new_dirty);
  sfi_glue_proxy_set_property (_proxy(), "dirty", val);
  sfi_value_free (val);
}

SfiBool
Bse::Server::can_load (const Sfi::String& file_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseServer+can-load", 'p', _object_id, 's', file_name.c_str(), 0);
  return _retval;
}

Sfi::String
Bse::Server::get_custom_effect_dir (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-custom-effect-dir", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_custom_instrument_dir (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-custom-instrument-dir", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_demo_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-demo-path", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_effect_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-effect-path", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_instrument_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-instrument-path", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_ladspa_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-ladspa-path", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_mp3_version (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-mp3-version", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_plugin_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-plugin-path", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_sample_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-sample-path", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_script_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-script-path", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_version (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-version", 'p', _object_id, 0);
  return _retval;
}

Sfi::String
Bse::Server::get_vorbis_version (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-vorbis-version", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Server::n_scripts (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseServer+n-scripts", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::Server::preferences_locked (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseServer+preferences-locked", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Server::register_core_plugins (void) {
  sfi_glue_vcall_void ("BseServer+register-core-plugins", 'p', _object_id, 0);
}

void
Bse::Server::register_ladspa_plugins (void) {
  sfi_glue_vcall_void ("BseServer+register-ladspa-plugins", 'p', _object_id, 0);
}

void
Bse::Server::register_scripts (void) {
  sfi_glue_vcall_void ("BseServer+register-scripts", 'p', _object_id, 0);
}

void
Bse::Server::save_preferences (void) {
  sfi_glue_vcall_void ("BseServer+save-preferences", 'p', _object_id, 0);
}

void
Bse::Server::start_recording (const Sfi::String& wave_file, SfiReal n_seconds) {
  sfi_glue_vcall_void ("BseServer+start-recording", 'p', _object_id, 's', wave_file.c_str(), 'r', n_seconds, 0);
}

Bse::Project
Bse::Server::use_new_project (const Sfi::String& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseServer+use-new-project", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

SfiRec*
Bse::Server::bse_preferences ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "bse-preferences");
  return sfi_rec_ref (sfi_value_get_rec (val));
}

void
Bse::Server::set_bse_preferences (SfiRec* new_bse_preferences)
{
  GValue *val = sfi_value_rec (new_bse_preferences);
  sfi_glue_proxy_set_property (_proxy(), "bse-preferences", val);
  sfi_value_free (val);
}

Sfi::String
Bse::Server::wave_file ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave-file");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Server::set_wave_file (const Sfi::String& new_wave_file)
{
  GValue *val = sfi_value_string (new_wave_file.c_str());
  sfi_glue_proxy_set_property (_proxy(), "wave-file", val);
  sfi_value_free (val);
}

SfiBool
Bse::Server::log_messages ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "log-messages");
  return sfi_value_get_bool (val);
}

void
Bse::Server::set_log_messages (SfiBool new_log_messages)
{
  GValue *val = sfi_value_bool (new_log_messages);
  sfi_glue_proxy_set_property (_proxy(), "log-messages", val);
  sfi_value_free (val);
}

Sfi::String
Bse::Super::author ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "author");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Super::set_author (const Sfi::String& new_author)
{
  GValue *val = sfi_value_string (new_author.c_str());
  sfi_glue_proxy_set_property (_proxy(), "author", val);
  sfi_value_free (val);
}

Sfi::String
Bse::Super::license ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "license");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Super::set_license (const Sfi::String& new_license)
{
  GValue *val = sfi_value_string (new_license.c_str());
  sfi_glue_proxy_set_property (_proxy(), "license", val);
  sfi_value_free (val);
}

Sfi::String
Bse::Super::copyright ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "copyright");
  return ::Sfi::String::value_get_string (val);
}

void
Bse::Super::set_copyright (const Sfi::String& new_copyright)
{
  GValue *val = sfi_value_string (new_copyright.c_str());
  sfi_glue_proxy_set_property (_proxy(), "copyright", val);
  sfi_value_free (val);
}

SfiNum
Bse::Super::creation_time ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "creation-time");
  return sfi_value_get_num (val);
}

void
Bse::Super::set_creation_time (SfiNum new_creation_time)
{
  GValue *val = sfi_value_num (new_creation_time);
  sfi_glue_proxy_set_property (_proxy(), "creation-time", val);
  sfi_value_free (val);
}

SfiNum
Bse::Super::modification_time ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "modification-time");
  return sfi_value_get_num (val);
}

void
Bse::Super::set_modification_time (SfiNum new_modification_time)
{
  GValue *val = sfi_value_num (new_modification_time);
  sfi_glue_proxy_set_property (_proxy(), "modification-time", val);
  sfi_value_free (val);
}

Bse::ErrorType
Bse::Track::ensure_output (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseTrack+ensure-output", 'p', _object_id, 0);
  return bse_error_type_from_choice (_retval);
}

SfiInt
Bse::Track::get_last_tick (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseTrack+get-last-tick", 'p', _object_id, 0);
  return _retval;
}

Bse::Source
Bse::Track::get_output_source (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseTrack+get-output-source", 'p', _object_id, 0);
  return _retval;
}

Bse::Part
Bse::Track::get_part (SfiInt tick) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseTrack+get-part", 'p', _object_id, 'i', tick, 0);
  return _retval;
}

Bse::SongTimingHandle
Bse::Track::get_timing (SfiInt tick) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseTrack+get-timing", 'p', _object_id, 'i', tick, 0);
  return Bse::SongTiming::from_rec (_retval);
}

SfiInt
Bse::Track::insert_part (SfiInt tick, Bse::Part part) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseTrack+insert-part", 'p', _object_id, 'i', tick, 'p', part._proxy(), 0);
  return _retval;
}

Bse::TrackPartSeq
Bse::Track::list_parts (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseTrack+list-parts", 'p', _object_id, 0);
  return Bse::TrackPartSeq::from_seq (_retval);
}

Bse::ItemSeq
Bse::Track::list_parts_uniq (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseTrack+list-parts-uniq", 'p', _object_id, 0);
  return Bse::ItemSeq::from_seq (_retval);
}

void
Bse::Track::remove_link (SfiInt id) {
  sfi_glue_vcall_void ("BseTrack+remove-link", 'p', _object_id, 'i', id, 0);
}

void
Bse::Track::remove_tick (SfiInt tick) {
  sfi_glue_vcall_void ("BseTrack+remove-tick", 'p', _object_id, 'i', tick, 0);
}

SfiBool
Bse::Track::muted ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "muted");
  return sfi_value_get_bool (val);
}

void
Bse::Track::set_muted (SfiBool new_muted)
{
  GValue *val = sfi_value_bool (new_muted);
  sfi_glue_proxy_set_property (_proxy(), "muted", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::Track::snet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "snet");
  return sfi_value_get_proxy (val);
}

void
Bse::Track::set_snet (Bse::CSynth new_snet)
{
  GValue *val = sfi_value_proxy (new_snet);
  sfi_glue_proxy_set_property (_proxy(), "snet", val);
  sfi_value_free (val);
}

Bse::Wave
Bse::Track::wave ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave");
  return sfi_value_get_proxy (val);
}

void
Bse::Track::set_wave (Bse::Wave new_wave)
{
  GValue *val = sfi_value_proxy (new_wave);
  sfi_glue_proxy_set_property (_proxy(), "wave", val);
  sfi_value_free (val);
}

SfiInt
Bse::Track::midi_channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "midi-channel");
  return sfi_value_get_int (val);
}

void
Bse::Track::set_midi_channel (SfiInt new_midi_channel)
{
  GValue *val = sfi_value_int (new_midi_channel);
  sfi_glue_proxy_set_property (_proxy(), "midi-channel", val);
  sfi_value_free (val);
}

SfiInt
Bse::Track::n_voices ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "n-voices");
  return sfi_value_get_int (val);
}

void
Bse::Track::set_n_voices (SfiInt new_n_voices)
{
  GValue *val = sfi_value_int (new_n_voices);
  sfi_glue_proxy_set_property (_proxy(), "n-voices", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::Track::pnet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pnet");
  return sfi_value_get_proxy (val);
}

void
Bse::Track::set_pnet (Bse::CSynth new_pnet)
{
  GValue *val = sfi_value_proxy (new_pnet);
  sfi_glue_proxy_set_property (_proxy(), "pnet", val);
  sfi_value_free (val);
}

Bse::ItemSeq
Bse::Track::outputs ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "outputs");
  return Bse::ItemSeq::from_seq (sfi_value_get_seq (val));
}

void
Bse::Track::set_outputs (const Bse::ItemSeq& new_outputs)
{
  GValue *val = sfi_value_new_take_seq (Bse::ItemSeq::to_seq (new_outputs));
  sfi_glue_proxy_set_property (_proxy(), "outputs", val);
  sfi_value_free (val);
}

Bse::ErrorType
Bse::SNet::can_create_source (const Sfi::String& module_type) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSNet+can-create-source", 'p', _object_id, 's', module_type.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::Source
Bse::SNet::create_source (const Sfi::String& module_type) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSNet+create-source", 'p', _object_id, 's', module_type.c_str(), 0);
  return _retval;
}

Bse::ErrorType
Bse::SNet::remove_source (Bse::Source module) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSNet+remove-source", 'p', _object_id, 'p', module._proxy(), 0);
  return bse_error_type_from_choice (_retval);
}

SfiBool
Bse::SNet::supports_user_synths (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSNet+supports-user-synths", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::SNet::auto_activate ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "auto-activate");
  return sfi_value_get_bool (val);
}

void
Bse::SNet::set_auto_activate (SfiBool new_auto_activate)
{
  GValue *val = sfi_value_bool (new_auto_activate);
  sfi_glue_proxy_set_property (_proxy(), "auto-activate", val);
  sfi_value_free (val);
}

Bse::ErrorType
Bse::WaveRepo::load_file (const Sfi::String& file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseWaveRepo+load-file", 'p', _object_id, 's', file_name.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::WaveRepo::remove_wave (Bse::Wave wave) {
  sfi_glue_vcall_void ("BseWaveRepo+remove-wave", 'p', _object_id, 'p', wave._proxy(), 0);
}

SfiInt
Bse::MidiSynth::midi_channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "midi-channel");
  return sfi_value_get_int (val);
}

void
Bse::MidiSynth::set_midi_channel (SfiInt new_midi_channel)
{
  GValue *val = sfi_value_int (new_midi_channel);
  sfi_glue_proxy_set_property (_proxy(), "midi-channel", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiSynth::n_voices ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "n-voices");
  return sfi_value_get_int (val);
}

void
Bse::MidiSynth::set_n_voices (SfiInt new_n_voices)
{
  GValue *val = sfi_value_int (new_n_voices);
  sfi_glue_proxy_set_property (_proxy(), "n-voices", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::MidiSynth::snet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "snet");
  return sfi_value_get_proxy (val);
}

void
Bse::MidiSynth::set_snet (Bse::CSynth new_snet)
{
  GValue *val = sfi_value_proxy (new_snet);
  sfi_glue_proxy_set_property (_proxy(), "snet", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::MidiSynth::pnet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pnet");
  return sfi_value_get_proxy (val);
}

void
Bse::MidiSynth::set_pnet (Bse::CSynth new_pnet)
{
  GValue *val = sfi_value_proxy (new_pnet);
  sfi_glue_proxy_set_property (_proxy(), "pnet", val);
  sfi_value_free (val);
}

SfiReal
Bse::MidiSynth::volume_f ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-f");
  return sfi_value_get_real (val);
}

void
Bse::MidiSynth::set_volume_f (SfiReal new_volume_f)
{
  GValue *val = sfi_value_real (new_volume_f);
  sfi_glue_proxy_set_property (_proxy(), "volume-f", val);
  sfi_value_free (val);
}

SfiReal
Bse::MidiSynth::volume_d_b ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-d-b");
  return sfi_value_get_real (val);
}

void
Bse::MidiSynth::set_volume_d_b (SfiReal new_volume_d_b)
{
  GValue *val = sfi_value_real (new_volume_d_b);
  sfi_glue_proxy_set_property (_proxy(), "volume-d-b", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiSynth::volume_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-perc");
  return sfi_value_get_int (val);
}

void
Bse::MidiSynth::set_volume_perc (SfiInt new_volume_perc)
{
  GValue *val = sfi_value_int (new_volume_perc);
  sfi_glue_proxy_set_property (_proxy(), "volume-perc", val);
  sfi_value_free (val);
}

SfiBool
Bse::MidiSynth::auto_activate ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "auto-activate");
  return sfi_value_get_bool (val);
}

void
Bse::MidiSynth::set_auto_activate (SfiBool new_auto_activate)
{
  GValue *val = sfi_value_bool (new_auto_activate);
  sfi_glue_proxy_set_property (_proxy(), "auto-activate", val);
  sfi_value_free (val);
}

Bse::Bus
Bse::Song::create_bus (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+create-bus", 'p', _object_id, 0);
  return _retval;
}

Bse::Part
Bse::Song::create_part (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+create-part", 'p', _object_id, 0);
  return _retval;
}

Bse::Track
Bse::Song::create_track (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+create-track", 'p', _object_id, 0);
  return _retval;
}

Bse::Bus
Bse::Song::ensure_master_bus (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+ensure-master-bus", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Song::ensure_track_links (void) {
  sfi_glue_vcall_void ("BseSong+ensure-track-links", 'p', _object_id, 0);
}

Bse::Track
Bse::Song::find_any_track_for_part (Bse::Part part) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+find-any-track-for-part", 'p', _object_id, 'p', part._proxy(), 0);
  return _retval;
}

Bse::Track
Bse::Song::find_track_for_part (Bse::Part part) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+find-track-for-part", 'p', _object_id, 'p', part._proxy(), 0);
  return _retval;
}

Bse::Bus
Bse::Song::get_master_bus (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+get-master-bus", 'p', _object_id, 0);
  return _retval;
}

Bse::SongTimingHandle
Bse::Song::get_timing (SfiInt tick) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseSong+get-timing", 'p', _object_id, 'i', tick, 0);
  return Bse::SongTiming::from_rec (_retval);
}

void
Bse::Song::remove_bus (Bse::Bus bus) {
  sfi_glue_vcall_void ("BseSong+remove-bus", 'p', _object_id, 'p', bus._proxy(), 0);
}

void
Bse::Song::remove_part (Bse::Part part) {
  sfi_glue_vcall_void ("BseSong+remove-part", 'p', _object_id, 'p', part._proxy(), 0);
}

void
Bse::Song::remove_track (Bse::Track track) {
  sfi_glue_vcall_void ("BseSong+remove-track", 'p', _object_id, 'p', track._proxy(), 0);
}

void
Bse::Song::synthesize_note (Bse::Track track, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  sfi_glue_vcall_void ("BseSong+synthesize-note", 'p', _object_id, 'p', track._proxy(), 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
}

Bse::MusicalTuningType
Bse::Song::musical_tuning ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "musical-tuning");
  return bse_musical_tuning_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::Song::set_musical_tuning (Bse::MusicalTuningType new_musical_tuning)
{
  GValue *val = sfi_value_choice (bse_musical_tuning_type_to_choice (new_musical_tuning));
  sfi_glue_proxy_set_property (_proxy(), "musical-tuning", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::tpqn ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "tpqn");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_tpqn (SfiInt new_tpqn)
{
  GValue *val = sfi_value_int (new_tpqn);
  sfi_glue_proxy_set_property (_proxy(), "tpqn", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::numerator ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "numerator");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_numerator (SfiInt new_numerator)
{
  GValue *val = sfi_value_int (new_numerator);
  sfi_glue_proxy_set_property (_proxy(), "numerator", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::denominator ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "denominator");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_denominator (SfiInt new_denominator)
{
  GValue *val = sfi_value_int (new_denominator);
  sfi_glue_proxy_set_property (_proxy(), "denominator", val);
  sfi_value_free (val);
}

SfiReal
Bse::Song::bpm ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "bpm");
  return sfi_value_get_real (val);
}

void
Bse::Song::set_bpm (SfiReal new_bpm)
{
  GValue *val = sfi_value_real (new_bpm);
  sfi_glue_proxy_set_property (_proxy(), "bpm", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::Song::pnet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pnet");
  return sfi_value_get_proxy (val);
}

void
Bse::Song::set_pnet (Bse::CSynth new_pnet)
{
  GValue *val = sfi_value_proxy (new_pnet);
  sfi_glue_proxy_set_property (_proxy(), "pnet", val);
  sfi_value_free (val);
}

SfiBool
Bse::Song::auto_activate ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "auto-activate");
  return sfi_value_get_bool (val);
}

void
Bse::Song::set_auto_activate (SfiBool new_auto_activate)
{
  GValue *val = sfi_value_bool (new_auto_activate);
  sfi_glue_proxy_set_property (_proxy(), "auto-activate", val);
  sfi_value_free (val);
}

SfiBool
Bse::Song::loop_enabled ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "loop-enabled");
  return sfi_value_get_bool (val);
}

void
Bse::Song::set_loop_enabled (SfiBool new_loop_enabled)
{
  GValue *val = sfi_value_bool (new_loop_enabled);
  sfi_glue_proxy_set_property (_proxy(), "loop-enabled", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::loop_left ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "loop-left");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_loop_left (SfiInt new_loop_left)
{
  GValue *val = sfi_value_int (new_loop_left);
  sfi_glue_proxy_set_property (_proxy(), "loop-left", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::loop_right ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "loop-right");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_loop_right (SfiInt new_loop_right)
{
  GValue *val = sfi_value_int (new_loop_right);
  sfi_glue_proxy_set_property (_proxy(), "loop-right", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::tick_pointer ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "tick-pointer");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_tick_pointer (SfiInt new_tick_pointer)
{
  GValue *val = sfi_value_int (new_tick_pointer);
  sfi_glue_proxy_set_property (_proxy(), "tick-pointer", val);
  sfi_value_free (val);
}


void
Bse::source_request_probes (Bse::Source source, SfiInt ochannel_id, const Bse::ProbeFeaturesHandle& probe_features) {
  SfiRec* probe_features__c = Bse::ProbeFeatures::to_rec (probe_features);
  sfi_glue_vcall_void ("bse-source-request-probes", 'p', source._proxy(), 'i', ochannel_id, 'R', probe_features__c, 0);
  sfi_rec_unref (probe_features__c);
}

void
Bse::source_mass_request (const Bse::ProbeRequestSeq& prseq) {
  SfiSeq* prseq__c = Bse::ProbeRequestSeq::to_seq (prseq);
  sfi_glue_vcall_void ("bse-source-mass-request", 'Q', prseq__c, 0);
  sfi_seq_unref (prseq__c);
}

SfiNum
Bse::source_get_tick_stamp (Bse::Source obj) {
  SfiNum _retval;
  _retval = sfi_glue_vcall_num ("bse-source-get-tick-stamp", 'p', obj._proxy(), 0);
  return _retval;
}

SfiInt
Bse::source_get_mix_freq (Bse::Source obj) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("bse-source-get-mix-freq", 'p', obj._proxy(), 0);
  return _retval;
}

Bse::ThreadTotalsHandle
Bse::collect_thread_totals (void) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-collect-thread-totals", 0);
  return Bse::ThreadTotals::from_rec (_retval);
}

Bse::CategoryHandle
Bse::category_from_id (SfiInt category_id) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-category-from-id", 'i', category_id, 0);
  return Bse::Category::from_rec (_retval);
}

Bse::CategorySeq
Bse::categories_match (const Sfi::String& pattern) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("bse-categories-match", 's', pattern.c_str(), 0);
  return Bse::CategorySeq::from_seq (_retval);
}

Bse::CategorySeq
Bse::categories_match_method (const Sfi::String& pattern, const Sfi::String& type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("bse-categories-match-method", 's', pattern.c_str(), 's', type.c_str(), 0);
  return Bse::CategorySeq::from_seq (_retval);
}

Bse::CategorySeq
Bse::categories_match_typed (const Sfi::String& pattern, const Sfi::String& type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("bse-categories-match-typed", 's', pattern.c_str(), 's', type.c_str(), 0);
  return Bse::CategorySeq::from_seq (_retval);
}

Bse::NoteDescriptionHandle
Bse::note_describe (Bse::MusicalTuningType musical_tuning, SfiInt note, SfiInt fine_tune) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-note-describe", 'C', bse_musical_tuning_type_to_choice (musical_tuning), 'i', note, 'i', fine_tune, 0);
  return Bse::NoteDescription::from_rec (_retval);
}

Bse::NoteDescriptionHandle
Bse::note_describe_from_freq (Bse::MusicalTuningType musical_tuning, SfiReal freq) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-note-describe-from-freq", 'C', bse_musical_tuning_type_to_choice (musical_tuning), 'r', freq, 0);
  return Bse::NoteDescription::from_rec (_retval);
}

Sfi::String
Bse::error_blurb (Bse::ErrorType error) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-error-blurb", 'C', bse_error_type_to_choice (error), 0);
  return _retval;
}

Sfi::String
Bse::error_name (Bse::ErrorType error) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-error-name", 'C', bse_error_type_to_choice (error), 0);
  return _retval;
}

Bse::NoteDescriptionHandle
Bse::note_construct (Bse::MusicalTuningType musical_tuning, SfiInt semitone, SfiInt octave, SfiInt fine_tune) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-note-construct", 'C', bse_musical_tuning_type_to_choice (musical_tuning), 'i', semitone, 'i', octave, 'i', fine_tune, 0);
  return Bse::NoteDescription::from_rec (_retval);
}

Bse::NoteDescriptionHandle
Bse::note_from_string (Bse::MusicalTuningType musical_tuning, const Sfi::String& name) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-note-from-string", 'C', bse_musical_tuning_type_to_choice (musical_tuning), 's', name.c_str(), 0);
  return Bse::NoteDescription::from_rec (_retval);
}

SfiInt
Bse::note_from_freq (Bse::MusicalTuningType musical_tuning, SfiReal frequency) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("bse-note-from-freq", 'C', bse_musical_tuning_type_to_choice (musical_tuning), 'r', frequency, 0);
  return _retval;
}

SfiReal
Bse::note_to_freq (Bse::MusicalTuningType musical_tuning, SfiInt note, SfiInt fine_tune) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("bse-note-to-freq", 'C', bse_musical_tuning_type_to_choice (musical_tuning), 'i', note, 'i', fine_tune, 0);
  return _retval;
}

SfiBool
Bse::proxy_check (Bse::Item item, const Sfi::String& type_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("bse-proxy-check", 'p', item._proxy(), 's', type_name.c_str(), 0);
  return _retval;
}

Bse::SampleFileInfoHandle
Bse::sample_file_info (const Sfi::String& file_name) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-sample-file-info", 's', file_name.c_str(), 0);
  return Bse::SampleFileInfo::from_rec (_retval);
}

void
Bse::script_add_action (const Sfi::String& action, const Sfi::String& name, const Sfi::String& blurb) {
  sfi_glue_vcall_void ("bse-script-add-action", 's', action.c_str(), 's', name.c_str(), 's', blurb.c_str(), 0);
}

Bse::Janitor
Bse::script_janitor (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("bse-script-janitor", 0);
  return _retval;
}

void
Bse::script_send_message (const Sfi::String& domain, const Sfi::String& msg_type, const Sfi::String& title, const Sfi::String& primary, const Sfi::String& secondary, const Sfi::String& details, const Sfi::String& config_check) {
  sfi_glue_vcall_void ("bse-script-send-message", 's', domain.c_str(), 's', msg_type.c_str(), 's', title.c_str(), 's', primary.c_str(), 's', secondary.c_str(), 's', details.c_str(), 's', config_check.c_str(), 0);
}

void
Bse::script_progress (SfiReal progress) {
  sfi_glue_vcall_void ("bse-script-progress", 'r', progress, 0);
}

void
Bse::script_quit (void) {
  sfi_glue_vcall_void ("bse-script-quit", 0);
}

void
Bse::script_remove_action (const Sfi::String& action) {
  sfi_glue_vcall_void ("bse-script-remove-action", 's', action.c_str(), 0);
}

void
Bse::script_set_status (const Sfi::String& message) {
  sfi_glue_vcall_void ("bse-script-set-status", 's', message.c_str(), 0);
}

void
Bse::wave_osc_mass_seek_perc (const Bse::ItemSeq& wosc_seq, SfiReal pos_perc) {
  SfiSeq* wosc_seq__c = Bse::ItemSeq::to_seq (wosc_seq);
  sfi_glue_vcall_void ("bse-wave-osc-mass-seek-perc", 'Q', wosc_seq__c, 'r', pos_perc, 0);
  sfi_seq_unref (wosc_seq__c);
}

SfiReal
Bse::string_extract_number (const Sfi::String& string, const Sfi::String& format, SfiReal aux_base, SfiReal dflt) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("bse-string-extract-number", 's', string.c_str(), 's', format.c_str(), 'r', aux_base, 'r', dflt, 0);
  return _retval;
}

Sfi::String
Bse::type_authors (const Sfi::String& type) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-type-authors", 's', type.c_str(), 0);
  return _retval;
}

Sfi::String
Bse::type_blurb (const Sfi::String& type) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-type-blurb", 's', type.c_str(), 0);
  return _retval;
}

Sfi::String
Bse::type_license (const Sfi::String& type) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-type-license", 's', type.c_str(), 0);
  return _retval;
}

Sfi::String
Bse::type_options (const Sfi::String& type) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-type-options", 's', type.c_str(), 0);
  return _retval;
}



/*-------- end ../../sfi/sfidl generated code --------*/



/*-------- begin ../../sfi/sfidl generated code --------*/


static const SfiConstants namespace_funkyness_type_vals[3] = {
  { "namespace-non-funky", 19, 3 },
  { "namespace-moderately-funky", 26, 2 },
  { "namespace-really-funky", 22, 1 },
};

const gchar*
namespace_funkyness_type_to_choice (Namespace::FunkynessType value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (namespace_funkyness_type_vals), namespace_funkyness_type_vals, value);
}

Namespace::FunkynessType
namespace_funkyness_type_from_choice (const gchar *choice)
{
  return (Namespace::FunkynessType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (namespace_funkyness_type_vals), namespace_funkyness_type_vals, choice) : 0);
}


SfiInt
Namespace::TestObject::aninteger ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "aninteger");
  return sfi_value_get_int (val);
}

void
Namespace::TestObject::set_aninteger (SfiInt new_aninteger)
{
  GValue *val = sfi_value_int (new_aninteger);
  sfi_glue_proxy_set_property (_proxy(), "aninteger", val);
  sfi_value_free (val);
}

Namespace::TestRecordHandle
Namespace::TestObject::r ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "r");
  return Namespace::TestRecord::from_rec (sfi_value_get_rec (val));
}

void
Namespace::TestObject::set_r (const Namespace::TestRecordHandle& new_r)
{
  GValue *val = sfi_value_new_take_rec (Namespace::TestRecord::to_rec (new_r));
  sfi_glue_proxy_set_property (_proxy(), "r", val);
  sfi_value_free (val);
}

Namespace::TestSequence
Namespace::TestObject::s ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "s");
  return Namespace::TestSequence::from_seq (sfi_value_get_seq (val));
}

void
Namespace::TestObject::set_s (const Namespace::TestSequence& new_s)
{
  GValue *val = sfi_value_new_take_seq (Namespace::TestSequence::to_seq (new_s));
  sfi_glue_proxy_set_property (_proxy(), "s", val);
  sfi_value_free (val);
}

SfiRec*
Namespace::TestObject::rr ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "rr");
  return sfi_rec_ref (sfi_value_get_rec (val));
}

void
Namespace::TestObject::set_rr (SfiRec* new_rr)
{
  GValue *val = sfi_value_rec (new_rr);
  sfi_glue_proxy_set_property (_proxy(), "rr", val);
  sfi_value_free (val);
}

Bse::Effect
Namespace::TestObject::ef ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "ef");
  return sfi_value_get_proxy (val);
}

void
Namespace::TestObject::set_ef (Bse::Effect new_ef)
{
  GValue *val = sfi_value_proxy (new_ef);
  sfi_glue_proxy_set_property (_proxy(), "ef", val);
  sfi_value_free (val);
}

Bse::Item
Namespace::TestObject::it ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "it");
  return sfi_value_get_proxy (val);
}

void
Namespace::TestObject::set_it (Bse::Item new_it)
{
  GValue *val = sfi_value_proxy (new_it);
  sfi_glue_proxy_set_property (_proxy(), "it", val);
  sfi_value_free (val);
}


SfiInt
Namespace::test_exception (SfiInt i, Namespace::TestObject o, SfiInt bar, Namespace::FunkynessType ft) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("namespace-test-exception", 'i', i, 'p', o._proxy(), 'i', bar, 'C', namespace_funkyness_type_to_choice (ft), 0);
  return _retval;
}



/*-------- end ../../sfi/sfidl generated code --------*/


