
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseprocedure.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include "bseplugin.hh"
#include "bseprocedure.hh"
#include "bsescripthelper.hh"
#include "bseserver.hh"
#line 6 "bseprocedure.proc"
#include "bsemath.hh"    
#include "bsemain.hh"
#include "bsecxxplugin.hh"
#line 9 "bseprocedure.proc"
#include <string.h>     
#line 10 "bseprocedure.proc"
#include <stdlib.h>     
/* --- bse-note-to-freq --- */
static void
bse_note_to_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 13 "bseprocedure.proc"
 {
#line 15 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY, 0, BSE_MAX_FREQUENCY, 0.1,
			  SFI_PARAM_STANDARD);
#line 22 "bseprocedure.proc"
}  }
static BseErrorType
#line 22 "bseprocedure.proc"
bse_note_to_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 25 "bseprocedure.proc"
{
#line 26 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = (BseMusicalTuningType) g_value_get_enum (in_values++);
  int                  note           = sfi_value_get_int (in_values++);
  int                  fine_tune      = sfi_value_get_int (in_values++);
  BseNoteDescription *info;
  gfloat freq;
#line 32 "bseprocedure.proc"
  
  info = bse_note_description (musical_tuning, note, fine_tune);
  if (!info->name)
    freq = 0;
  else
    freq = info->freq;
  bse_note_description_free (info);
#line 39 "bseprocedure.proc"
  
  sfi_value_set_real (out_values++, freq);
  return BSE_ERROR_NONE;
}
/* --- bse-note-from-freq --- */
static void
bse_note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 43 "bseprocedure.proc"
 {
#line 45 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY, 0, BSE_MAX_FREQUENCY, 0.1,
			  SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_note ("note", "Note", NULL, SFI_KAMMER_NOTE, SFI_MIN_NOTE, SFI_MAX_NOTE, TRUE, SFI_PARAM_STANDARD);
#line 51 "bseprocedure.proc"
}  }
static BseErrorType
#line 51 "bseprocedure.proc"
bse_note_from_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 54 "bseprocedure.proc"
{
#line 55 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = (BseMusicalTuningType) g_value_get_enum (in_values++);
  float                frequency      = sfi_value_get_real (in_values++);
#line 58 "bseprocedure.proc"
  
  sfi_value_set_int (out_values++, bse_note_from_freq (musical_tuning, frequency));
  return BSE_ERROR_NONE;
}
/* --- bse-note-describe --- */
static void
bse_note_describe_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 62 "bseprocedure.proc"
 {
#line 64 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
                                BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_STANDARD);
}
#line 71 "bseprocedure.proc"
 }
static BseErrorType
#line 71 "bseprocedure.proc"
bse_note_describe_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 74 "bseprocedure.proc"
{
#line 75 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = (BseMusicalTuningType) g_value_get_enum (in_values++);
  int                  note	      = sfi_value_get_int (in_values++);
  int                  fine_tune      = sfi_value_get_int (in_values++);
#line 79 "bseprocedure.proc"
  
  bse_value_take_boxed (out_values++, bse_note_description (musical_tuning, note, fine_tune));
  return BSE_ERROR_NONE;
}
/* --- bse-note-describe-from-freq --- */
static void
bse_note_describe_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 83 "bseprocedure.proc"
 {
#line 85 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("freq", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY,
			  0, BSE_MAX_FREQUENCY,
			  10.0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
                                BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_STANDARD);
}
#line 94 "bseprocedure.proc"
 }
static BseErrorType
#line 94 "bseprocedure.proc"
bse_note_describe_from_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 97 "bseprocedure.proc"
{
#line 98 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = (BseMusicalTuningType) g_value_get_enum (in_values++);
  float                freq	      = sfi_value_get_real (in_values++);
  gint note;
#line 102 "bseprocedure.proc"
  
  note = bse_note_from_freq (musical_tuning, freq);
  bse_value_take_boxed (out_values++, bse_note_description (musical_tuning, note, 0));
  return BSE_ERROR_NONE;
}
/* --- bse-note-from-string --- */
static void
bse_note_from_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 107 "bseprocedure.proc"
 {
#line 109 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", NULL,
			    "", SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
                                BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_STANDARD);
}
#line 116 "bseprocedure.proc"
 }
static BseErrorType
#line 116 "bseprocedure.proc"
bse_note_from_string_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 119 "bseprocedure.proc"
{
#line 120 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = (BseMusicalTuningType) g_value_get_enum (in_values++);
  const char *name = sfi_value_get_string (in_values++);
  gint note;
#line 124 "bseprocedure.proc"
  
  note = bse_note_from_string (name);
  bse_value_take_boxed (out_values++, bse_note_description (musical_tuning, note, 0));
  return BSE_ERROR_NONE;
}
/* --- bse-note-construct --- */
static void
bse_note_construct_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 129 "bseprocedure.proc"
 {
#line 131 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_enum ("musical_tuning", "Musical Tuning", NULL,
			       BSE_MUSICAL_TUNING_12_TET, BSE_TYPE_MUSICAL_TUNING_TYPE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("semitone", NULL, NULL,
			 9, 0, 11, 1,
			 SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_octave ("octave", NULL, NULL);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
                                BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_STANDARD);
}
#line 141 "bseprocedure.proc"
 }
static BseErrorType
#line 141 "bseprocedure.proc"
bse_note_construct_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 144 "bseprocedure.proc"
{
#line 145 "bseprocedure.proc"
  
  BseMusicalTuningType musical_tuning = (BseMusicalTuningType) g_value_get_enum (in_values++);
  guint                semitone	      = sfi_value_get_int (in_values++);
  int                  octave	      = sfi_value_get_int (in_values++);
  int                  fine_tune      = sfi_value_get_int (in_values++);
  int note;
#line 151 "bseprocedure.proc"
  
  note = BSE_NOTE_GENERIC (octave, semitone);
  bse_value_take_boxed (out_values++, bse_note_description (musical_tuning, note, fine_tune));
  return BSE_ERROR_NONE;
}
/* --- bse-type-options --- */
static void
bse_type_options_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 156 "bseprocedure.proc"
 {
#line 158 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 160 "bseprocedure.proc"
}  }
static BseErrorType
#line 160 "bseprocedure.proc"
bse_type_options_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 163 "bseprocedure.proc"
{
#line 164 "bseprocedure.proc"
  
  const char *stype = sfi_value_get_string (in_values++);
  GType type;
#line 167 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;
  type = g_type_from_name (stype);
#line 171 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_options (type) : NULL);
  return BSE_ERROR_NONE;
}
/* --- bse-type-blurb --- */
static void
bse_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 175 "bseprocedure.proc"
 {
#line 177 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 179 "bseprocedure.proc"
}  }
static BseErrorType
#line 179 "bseprocedure.proc"
bse_type_blurb_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 182 "bseprocedure.proc"
{
#line 183 "bseprocedure.proc"
  
  const char *stype = sfi_value_get_string (in_values++);
  GType type;
#line 186 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;
  type = g_type_from_name (stype);
#line 190 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_blurb (type) : NULL);
  return BSE_ERROR_NONE;
}
/* --- bse-type-authors --- */
static void
bse_type_authors_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 194 "bseprocedure.proc"
 {
#line 196 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 198 "bseprocedure.proc"
}  }
static BseErrorType
#line 198 "bseprocedure.proc"
bse_type_authors_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 201 "bseprocedure.proc"
{
#line 202 "bseprocedure.proc"
  
  const char *stype = sfi_value_get_string (in_values++);
  GType type;
#line 205 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;
  type = g_type_from_name (stype);
#line 209 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_authors (type) : NULL);
  return BSE_ERROR_NONE;
}
/* --- bse-type-license --- */
static void
bse_type_license_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 213 "bseprocedure.proc"
 {
#line 215 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 217 "bseprocedure.proc"
}  }
static BseErrorType
#line 217 "bseprocedure.proc"
bse_type_license_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 220 "bseprocedure.proc"
{
#line 221 "bseprocedure.proc"
  
  const char *stype = sfi_value_get_string (in_values++);
  GType type;
#line 224 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;
  type = g_type_from_name (stype);
#line 228 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_license (type) : NULL);
  return BSE_ERROR_NONE;
}
static gdouble
str2num (const gchar *str,
         guint        nth)
{
  const char *num_any = ".0123456789", *num_first = num_any + 1;
  while (nth--)
    {
#line 239 "bseprocedure.proc"
      
      if (*str && strchr (num_first, *str))
        do
          str++;
        while (*str && strchr (num_any, *str));
#line 244 "bseprocedure.proc"
      
      while (*str && !strchr (num_first, *str))
        str++;
      if (!*str)
#line 248 "bseprocedure.proc"
        return 0;       
    }
  if (strchr (num_first, *str))
    return g_strtod (str, NULL);
#line 252 "bseprocedure.proc"
  return 0; 
}
/* --- bse-string-extract-number --- */
static void
bse_string_extract_number_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 254 "bseprocedure.proc"
 {
#line 256 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("format", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("aux_base", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("dflt", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_real ("number", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
#line 261 "bseprocedure.proc"
}  }
static BseErrorType
#line 261 "bseprocedure.proc"
bse_string_extract_number_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 264 "bseprocedure.proc"
{
#line 265 "bseprocedure.proc"
  
  const char *string   = sfi_value_get_string (in_values++);
  const char *format   = sfi_value_get_string (in_values++);
  SfiReal aux_base = sfi_value_get_real (in_values++);
  SfiReal dflt     = sfi_value_get_real (in_values++);
  SfiReal number = dflt;
  if (string)
    {
      if (format)
        {
          gchar *base, *ep = NULL;
          switch (*format)
            {
              glong l;
            case '#':
              number = str2num (++format, 0);
              break;
            case 'n':
              l = strtol (++format, &ep, 10);
              number = str2num (string, l);
              break;
            case 'b':
              l = strtol (++format, &ep, 10);
              base = g_path_get_basename (string);
              number = str2num  (base ? base : string, l);
              g_free (base);
              break;
            case 'c':
              format++;
              number = aux_base;
              if (*format == '*')
                {
                  gdouble factor = g_strtod (++format, &ep);
                  number *= factor;
                }
              else
                ep = (char*) format;
              break;
            default:
#line 304 "bseprocedure.proc"
              
              number = 0;
              break;
            }
          if (ep && *ep)
            {
#line 310 "bseprocedure.proc"
              if (*ep == 'm')       
                number = bse_temp_freq (BSE_CONFIG (kammer_freq),
                                        number - BSE_CONFIG (midi_kammer_note));
#line 313 "bseprocedure.proc"
              else 
                number = 0;
            }
        }
      else
        number = str2num (string, 0);
    }
  sfi_value_set_real (out_values++, number);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_bse_note_to_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the frequency of a certain note.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 14;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_to_freq = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "bse-note-to-freq", 
    NULL,
    "/Proc/Note to Freq",
    NULL,
    __enode_bse_note_to_freq__fill_strings,
  },
  0, bse_note_to_freq_setup, bse_note_to_freq_exec, 
};
static void
__enode_bse_note_from_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the note of a certain frequency.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 44;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_from_freq = {
  { (BseExportNode*) &__enode_bse_note_to_freq, BSE_EXPORT_NODE_PROC,
    "bse-note-from-freq", 
    NULL,
    "/Proc/Note from Freq",
    NULL,
    __enode_bse_note_from_freq__fill_strings,
  },
  0, bse_note_from_freq_setup, bse_note_from_freq_exec, 
};
static void
__enode_bse_note_describe__fill_strings (BseExportStrings *es)
{
  es->blurb = "Describe a note, providing information about its octave, semitone, frequency, etc.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 63;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_describe = {
  { (BseExportNode*) &__enode_bse_note_from_freq, BSE_EXPORT_NODE_PROC,
    "bse-note-describe", 
    NULL,
    "/Proc/Describe Note",
    NULL,
    __enode_bse_note_describe__fill_strings,
  },
  0, bse_note_describe_setup, bse_note_describe_exec, 
};
static void
__enode_bse_note_describe_from_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Describe a note, given its frequency.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 84;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_describe_from_freq = {
  { (BseExportNode*) &__enode_bse_note_describe, BSE_EXPORT_NODE_PROC,
    "bse-note-describe-from-freq", 
    NULL,
    "/Proc/Describe Note From Freq",
    NULL,
    __enode_bse_note_describe_from_freq__fill_strings,
  },
  0, bse_note_describe_from_freq_setup, bse_note_describe_from_freq_exec, 
};
static void
__enode_bse_note_from_string__fill_strings (BseExportStrings *es)
{
  es->blurb = "Describe a note, given its name and octave offset.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 108;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_from_string = {
  { (BseExportNode*) &__enode_bse_note_describe_from_freq, BSE_EXPORT_NODE_PROC,
    "bse-note-from-string", 
    NULL,
    "/Proc/Note From String",
    NULL,
    __enode_bse_note_from_string__fill_strings,
  },
  0, bse_note_from_string_setup, bse_note_from_string_exec, 
};
static void
__enode_bse_note_construct__fill_strings (BseExportStrings *es)
{
  es->blurb = "Describe a note, given its semitone, octave and fine tune.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 130;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_note_construct = {
  { (BseExportNode*) &__enode_bse_note_from_string, BSE_EXPORT_NODE_PROC,
    "bse-note-construct", 
    NULL,
    "/Proc/Note Construction",
    NULL,
    __enode_bse_note_construct__fill_strings,
  },
  0, bse_note_construct_setup, bse_note_construct_exec, 
};
static void
__enode_bse_type_options__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the options of a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 157;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_type_options = {
  { (BseExportNode*) &__enode_bse_note_construct, BSE_EXPORT_NODE_PROC,
    "bse-type-options", 
    NULL,
    "/Proc/Type Options",
    NULL,
    __enode_bse_type_options__fill_strings,
  },
  0, bse_type_options_setup, bse_type_options_exec, 
};
static void
__enode_bse_type_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the description of a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 176;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_type_blurb = {
  { (BseExportNode*) &__enode_bse_type_options, BSE_EXPORT_NODE_PROC,
    "bse-type-blurb", 
    NULL,
    "/Proc/Type Blurb",
    NULL,
    __enode_bse_type_blurb__fill_strings,
  },
  0, bse_type_blurb_setup, bse_type_blurb_exec, 
};
static void
__enode_bse_type_authors__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the authors who implemented a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 195;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_type_authors = {
  { (BseExportNode*) &__enode_bse_type_blurb, BSE_EXPORT_NODE_PROC,
    "bse-type-authors", 
    NULL,
    "/Proc/Type Authors",
    NULL,
    __enode_bse_type_authors__fill_strings,
  },
  0, bse_type_authors_setup, bse_type_authors_exec, 
};
static void
__enode_bse_type_license__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the license of a type impementation.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 214;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_type_license = {
  { (BseExportNode*) &__enode_bse_type_authors, BSE_EXPORT_NODE_PROC,
    "bse-type-license", 
    NULL,
    "/Proc/Type License",
    NULL,
    __enode_bse_type_license__fill_strings,
  },
  0, bse_type_license_setup, bse_type_license_exec, 
};
static void
__enode_bse_string_extract_number__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve numbers from a string.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 255;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_string_extract_number = {
  { (BseExportNode*) &__enode_bse_type_license, BSE_EXPORT_NODE_PROC,
    "bse-string-extract-number", 
    NULL,
    "/Proc/String Extract Number",
    NULL,
    __enode_bse_string_extract_number__fill_strings,
  },
  0, bse_string_extract_number_setup, bse_string_extract_number_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bseprocedure_genprc_cc (void)
{
  return (BseExportNode*) &__enode_bse_string_extract_number;
}

/*
 * Generated data ends here
 */
