//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_41.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot41(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[41] = {1.495412318839393e-02,1.346196530603572e-01,3.741245717669348e-01,7.338179903846087e-01,1.214227085453374e+00,
    1.816061387586076e+00,2.540218630400303e+00,3.387792277962293e+00,4.360080886504365e+00,5.458599499786691e+00,6.685093329091552e+00,8.041554030961123e+00,
    9.530238971637578e+00,1.115369396095140e+01,1.291478005572015e+01,1.481670518107030e+01,1.686306150767552e+01,1.905786976774064e+01,2.140563201216782e+01,
    2.391139473325466e+01,2.658082484085170e+01,2.942030174226932e+01,3.243702982159083e+01,3.563917706876438e+01,3.903604766610029e+01,4.263829930114852e+01,
    4.645822032213911e+01,5.051008837465523e+01,5.481064218713176e+01,5.937971402598654e+01,6.424109620464289e+01,6.942375878668088e+01,7.496361285123034e+01,
    8.090615698271444e+01,8.731062698640064e+01,9.425686768829939e+01,1.018575395655076e+02,1.102819365820350e+02,1.198090785376495e+02,1.309732808502122e+02,
    1.451511799576251e+02};
  constexpr double aw[41] = {2.409512031980955e-01,2.138535989833046e-01,1.684288790881375e-01,1.176734858934138e-01,7.289127392474089e-02,
    4.000382672300703e-02,1.943433713864227e-02,8.348509096446632e-03,3.167083927136288e-03,1.059421789854996e-03,3.119500328225102e-04,8.069562974703131e-05,
    1.829749053132399e-05,3.627548088743567e-06,6.270222683683111e-07,9.419324500196609e-08,1.225398304711123e-08,1.375070911649690e-09,1.325031121542562e-10,
    1.090961318304441e-11,7.631990251021066e-13,4.507842471875929e-14,2.232059383733774e-15,9.190509652018277e-17,3.117988425407376e-18,8.624530360938065e-20,
    1.921543143288940e-21,3.400135276844942e-23,4.700029149891438e-25,4.977034813475706e-27,3.943908754083598e-29,2.272930361646040e-31,9.196366050568663e-34,
    2.498147611480457e-36,4.299097107561103e-39,4.334876123369952e-42,2.294487143412411e-45,5.407934160768677e-49,4.333162815666903e-53,7.068304065463833e-58,
    6.390084617936297e-64};
  constexpr double x[15744] = {  7.162598842487031e-04, -4.313292778373942e-06,  1.947382724785179e-08, -7.811573259033619e-11,  2.935870828682837e-13,
 -1.058517543377415e-15,  3.707319008409632e-18, -1.270724034044082e-20,  4.282822060611644e-23, -1.423923371884718e-25,  4.680487715542327e-28, -1.523495561776137e-30,
  6.440329178977883e-03, -3.867373058797770e-05,  1.736154665140016e-07, -6.898250572001446e-10,  2.555567237277297e-12, -9.028272713132108e-15,  3.076067747551729e-17,
 -1.016896904706066e-19,  3.271703553727580e-22, -1.025577819244530e-24,  3.130779706106532e-27, -9.288070785994918e-30,  1.785644895117920e-02, -1.066199943533484e-04,
  4.731967185590221e-07, -1.844130414029309e-09,  6.631864038410227e-12, -2.243913610311819e-14,  7.194404236822033e-17, -2.185489002486084e-19,  6.247163490292792e-22,
 -1.652303474495700e-24,  3.890806090357972e-27, -7.320224167404303e-30,  3.490074150595784e-02, -2.066198010731064e-04,  9.012529468140015e-07, -3.409276811649895e-09,
  1.169609345224719e-11, -3.682628392477501e-14,  1.057691902259860e-16, -2.695289820418933e-19,  5.619863419648128e-22, -6.677247044083009e-25, -1.655749248091902e-27,
  1.662834608356758e-29,  5.747778975251127e-02, -3.364167342403465e-04,  1.433414420239871e-06, -5.203237164723557e-09,  1.667122364377253e-11, -4.684845768740035e-14,
  1.096045676657471e-16, -1.737045160421330e-19, -8.810075218570156e-23,  2.271485718514667e-24, -1.228405152570559e-26,  4.771241819417894e-29,  8.546111542605958e-02,
 -4.930796965724920e-04,  2.039140269253505e-06, -7.010881732220851e-09,  2.039849374266737e-11, -4.758977719251115e-14,  6.793147661983086e-17,  9.310457023104789e-20,
 -1.212276699863908e-21,  5.832262782622912e-24, -1.988823942365073e-26,  4.852062324898236e-29,  1.186938148299960e-01, -6.730672692551008e-04,  2.683268792676753e-06,
 -8.604418597318012e-09,  2.182293231873378e-11, -3.582390002760432e-14, -2.109947273833946e-17,  4.747251574718312e-19, -2.332216383074793e-21,  7.467263852650604e-24,
 -1.447319995960951e-26, -7.629930442204509e-30,  1.569893504400105e-01, -8.723056593362541e-04,  3.327808364849804e-06, -9.765277098738042e-09,  2.016860667043041e-11,
 -1.096315325941176e-14, -1.429302567362897e-16,  8.429968503632998e-19, -2.784648436092658e-21,  4.885531512317825e-24,  7.448108770769115e-27, -1.011686484650226e-28,
  2.001324962473129e-01, -1.086278629524816e-03,  3.933881042526253e-06, -1.030546469029146e-08,  1.507783818355396e-11,  2.452530540255543e-14, -2.687594049883096e-16,
  1.037904723338588e-18, -2.039864031565412e-21, -2.262548658985650e-24,  3.719165027873947e-26, -1.638258498687961e-28,  2.478804342214338e-01, -1.310127544972961e-03,
  4.463722930084798e-06, -1.008645762572511e-08,  6.693335470882301e-12,  6.534885927369856e-14, -3.623125283493767e-16,  9.268458432519353e-19, -1.490735717487381e-23,
 -1.153740172959613e-23,  5.619569600980281e-26, -1.221414412579766e-28,  2.999639987394018e-01, -1.538759444741101e-03,  4.882641850852554e-06, -9.033886284833194e-09,
 -4.330080221431404e-12,  1.042460074834062e-13, -3.895757737486642e-16,  4.620049147731740e-19,  2.776333393695693e-21, -1.839673202700934e-23,  4.650604941752039e-26,
  3.895695447087517e-29,  3.560890652531415e-01, -1.766960856338570e-03,  5.160834117570005e-06, -7.146631526934266e-09, -1.688777693386581e-11,  1.333212799598699e-13,
 -3.289078931421059e-16, -2.862521607601143e-19,  5.333625582692326e-21, -1.829739636092277e-23,  3.711370544984877e-27,  2.424471660230890e-28,  4.159380788474372e-01,
 -1.989514924419465e-03,  5.274968210802243e-06, -4.499430358593296e-09, -2.955488131020081e-11,  1.456057620578668e-13, -1.786884628098902e-16, -1.135028190312583e-18,
  6.527012034013852e-21, -9.244474736520708e-24, -5.626290063460467e-26,  3.516316462282345e-28,  4.791717176745710e-01, -2.201319323337740e-03,  5.209453757021383e-06,
 -1.238657282129792e-09, -4.076672665444886e-11,  1.365348565580071e-13,  3.981935180502609e-17, -1.835639167201473e-18,  5.569319047661718e-21,  6.578793359702598e-24,
 -1.024073400067105e-25,  2.585157657221569e-28,  5.454306855378599e-01, -2.397502371209743e-03,  4.957328928587260e-06,  2.428446398888609e-09, -4.902626164430547e-11,
  1.050399377661861e-13,  2.855266574168728e-16, -2.148874982675840e-18,  2.407440010544531e-21,  2.314212391889598e-23, -1.047236947788069e-25, -2.873277292008003e-29,
  6.143376271353034e-01, -2.573534763097535e-03,  4.520717641221606e-06,  6.250231936785878e-09, -5.311015876483631e-11,  5.401688476278020e-14,  5.060794690029544e-16,
 -1.925095839434771e-18, -2.148744719548185e-21,  3.296426124759443e-23, -5.264695908163366e-26, -3.659541974504874e-28,  6.854991586685192e-01, -2.725334394818724e-03,
  3.910828891433152e-06,  9.951404002227409e-09, -5.224487621900949e-11, -9.949484476745203e-15,  6.499939802238148e-16, -1.162046701215637e-18, -6.643177282842813e-21,
  3.058343426162164e-23,  3.542711317668181e-26, -5.474599874382135e-28,  7.585080056749278e-01, -2.849361857697844e-03,  3.147493292556882e-06,  1.325628730523833e-08,
 -4.622745098649610e-11, -7.758218538032226e-14,  6.793829688910843e-16, -1.912064012495717e-20, -9.477528592447118e-21,  1.544025896852159e-23,  1.185632170562391e-25,
 -4.355958221250393e-28,  8.329452390584671e-01, -2.942704348256785e-03,  2.258255253416997e-06,  1.591254870447672e-08, -3.547293114068398e-11, -1.384634990155689e-13,
  5.799926351381466e-16,  1.219641126680497e-18, -9.516757613101937e-21, -7.342261108813126e-24,  1.536453229435556e-25, -6.108108920859081e-29,  9.083825993836313e-01,
 -3.003145954209431e-03,  1.277062148434347e-06,  1.771325025940789e-08, -2.098017564161652e-11, -1.828598834093829e-13,  3.658382585586447e-16,  2.224614111965857e-18,
 -6.555380769638066e-21, -2.884831893744830e-23,  1.189869334254947e-25,  3.788479920569284e-28,  9.843848985690539e-01, -3.029222546751721e-03,  2.426130860466543e-07,
  1.851522538671299e-08, -4.218941595946662e-12, -2.034773525730574e-13,  7.703940942764981e-17,  2.717972128796207e-18, -1.447260789262524e-21, -4.018819559402910e-23,
  2.767819661557531e-26,  6.326028570297003e-28,  1.060512487181912e+00, -3.020259825282795e-03, -8.035516319480462e-07,  1.825207175433606e-08,  1.304780359958109e-11,
 -1.968091028283168e-13, -2.288174793348109e-16,  2.558568054914733e-18,  4.169142644066153e-21, -3.650019048799415e-23, -7.766656910091843e-26,  5.490678495885160e-28,
  1.136323774606890e+00, -2.976393419259021e-03, -1.819124579889538e-06,  1.694051757568797e-08,  2.898312716882481e-11, -1.638093280686665e-13, -4.897708956575993e-16,
  1.786611676920907e-18,  8.455075715698146e-21, -1.921970376999175e-23, -1.466192810502777e-25,  1.743244856374580e-28,  1.211377788458920e+00, -2.898570346409691e-03,
 -2.763163005013309e-06,  1.467950385451784e-08,  4.190752803784616e-11, -1.097538290599419e-13, -6.538130535435581e-16,  6.129951511160628e-19,  1.004152685058669e-20,
  4.511536824181230e-24, -1.473174786051149e-25, -2.751721294316639e-28,  1.285236758744803e+00, -2.788531549243744e-03, -3.598167851766660e-06,  1.164198268804064e-08,
  5.051093906701671e-11, -4.330491086766328e-14, -6.908647861583486e-16, -6.439444833488317e-19,  8.522199250756831e-21,  2.504820352993679e-23, -8.277810888102865e-26,
 -5.468663872846823e-28,  1.357468711473923e+00, -2.648775673624674e-03, -4.292000538997658e-06,  8.060101582700968e-09,  5.401608473988590e-11,  2.504587289419216e-14,
 -5.993754844635682e-16, -1.654141942754950e-18,  4.576024222240164e-21,  3.453492529407529e-23,  1.189488128012023e-26, -5.059152450562829e-28,  1.427650055692527e+00,
 -2.482504704063912e-03, -4.819534871578985e-06,  4.205063579736827e-09,  5.227044526046997e-11,  8.485996432115898e-14, -4.059040103394010e-16, -2.173207220060233e-18,
 -3.240979628693885e-22,  3.024771742617003e-23,  8.942807598530538e-26, -2.087546495213175e-28,  1.495368147290228e+00, -2.293552519263589e-03, -5.163953951089707e-06,
  3.634634175918796e-10,  4.575392953698889e-11,  1.275964210359185e-13, -1.578607307421983e-16, -2.110354687991190e-18, -4.491750940609923e-21,  1.543890990377649e-23,
  1.156960330307318e-25,  1.472109092127288e-28,  1.560223812422320e+00, -2.086297866672182e-03, -5.317619538969653e-06, -3.187749759390623e-09,  3.550119923704041e-11,
  1.480632760921198e-13,  8.862668174975686e-17, -1.545859185158598e-18, -6.657538381772139e-21, -2.598509213805869e-24,  8.607619464053273e-26,  3.573629420219122e-28,
  1.621833813028096e+00, -1.865563664418087e-03, -5.282463196397506e-06, -6.205379353165541e-09,  2.294972674535845e-11,  1.451989693124421e-13,  2.825052313358316e-16,
 -6.942355405128015e-19, -6.397798810909677e-21, -1.616302558192638e-23,  2.437599085818886e-26,  3.339056574140056e-28,  1.679833236723794e+00, -1.636504911003493e-03,
 -5.069873584645196e-06, -8.500916740201429e-09,  9.735340645818528e-12,  1.220427241821975e-13,  3.896442789115441e-16,  1.724307226691425e-19, -4.202671698870753e-21,
 -2.061627889595434e-23, -3.353460334356155e-26,  1.409605756618901e-28,  1.733877793328822e+00, -1.404487806041242e-03, -4.700081245922349e-06, -9.956340953378381e-09,
 -2.535378984029337e-12,  8.491736901062637e-14,  3.997319696021232e-16,  8.136798014754501e-19, -1.181577099339316e-21, -1.603894405509510e-23, -6.056803617945671e-26,
 -7.141807488758930e-29,  1.783646000466058e+00, -1.174962948393851e-03, -4.201069534823435e-06, -1.053328721957909e-08, -1.250311638539658e-11,  4.200778742403452e-14,
  3.266213416417353e-16,  1.091983974384857e-18,  1.444619411017827e-21, -6.447984880692693e-24, -5.133487806914710e-26, -1.770160574223993e-28,  1.828841241086990e+00,
 -9.533356718363234e-04, -3.607066601044415e-06, -1.027470776165695e-08, -1.923292267045963e-11,  1.639488883198227e-15,  2.023524529741880e-16,  1.003376493414720e-18,
  2.835679285031948e-21,  2.763397901317633e-24, -2.074476215330901e-26, -1.472737597119940e-28,  1.869193676458061e+00, -7.448366948429680e-04, -2.956696920134731e-06,
 -9.298859399677414e-09, -2.232513652772939e-11, -2.938099062122013e-14,  6.680536466020286e-17,  6.600203707262877e-19,  2.803273984838857e-21,  7.657591468743116e-24,
  8.752918757249725e-27, -4.557320461617834e-29,  1.904461999234679e+00, -5.543962938507316e-04, -2.290890425232766e-06, -7.786187835457052e-09, -2.194469733694493e-11,
 -4.702132808046128e-14, -4.391693462846059e-17,  2.347719466963731e-19,  1.769307714348039e-21,  7.370069658121188e-24,  2.180453922547000e-26,  3.901460588713954e-29,
  1.934435013200384e+00, -3.865251522763512e-04, -1.650661595915526e-06, -5.960366134540033e-09, -1.876561284102449e-11, -5.062339929016424e-14, -1.070362948025991e-16,
 -1.091429368940611e-19,  4.659058267311124e-22,  3.841278067731787e-24,  1.736159852436662e-26,  5.947833238758144e-29,  1.958933031056614e+00, -2.452048777422746e-04,
 -1.074878936505811e-06, -4.065316128082163e-09, -1.384005599635061e-11, -4.274162869297940e-14, -1.179606184919973e-16, -2.762233010320469e-19, -4.562031123862605e-22,
  9.756702138240664e-26,  5.295391552654081e-27,  3.067454776056098e-29,  1.977809100563286e+00, -1.337908507383287e-04, -5.981462404198679e-07, -2.340436978327099e-09,
 -8.412874438731396e-12, -2.827954718200010e-14, -8.930476974286298e-17, -2.637345628577960e-19, -7.169834092996166e-22, -1.726892029845563e-24, -3.302054307967478e-27,
 -2.628312734784560e-30,  1.990950194952502e+00, -5.492900909932025e-05, -2.489081244638334e-07, -9.964331180846913e-10, -3.710429923549996e-12, -1.313616076181129e-14,
 -4.468511221823952e-17, -1.467901539850825e-19, -4.664634079673082e-22, -1.432702260913622e-24, -4.238273966625208e-27, -1.198974406984110e-29,  1.998280268116452e+00,
 -1.047704517859652e-05, -4.783098618187222e-08, -1.938799514670819e-10, -7.357121941010940e-13, -2.675513277508733e-15, -9.440479422254709e-18, -3.255464794527409e-20,
 -1.102141851929808e-22, -3.674187809252321e-25, -1.208517362215252e-27, -3.927279108604685e-30,  6.993124682305123e-04, -4.161173437996668e-06,  1.856393953089661e-08,
 -7.358298597350843e-11,  2.732784492761576e-13, -9.736612636093107e-16,  3.369957716282452e-18, -1.141526900894845e-20,  3.802354790455913e-23, -1.249444304492605e-25,
  4.059296588520465e-28, -1.306035858277059e-30,  6.288360640953529e-03, -3.731723681141412e-05,  1.655770689606382e-07, -6.503413403444061e-10,  2.382159685868414e-12,
 -8.323034411797815e-15,  2.805455583107397e-17, -9.178757967155547e-20,  2.924085567058948e-22, -9.081566485529768e-25,  2.748962326240246e-27, -8.095430173986732e-30,
  1.743740246977443e-02, -1.029211685058750e-04,  4.516893010115912e-07, -1.741519076797441e-09,  6.199863662938114e-12, -2.078370644627887e-14,  6.609581434592069e-17,
 -1.994802916078258e-19,  5.679579873100916e-22, -1.503023312466226e-24,  3.575561138443619e-27, -6.996864088030324e-30,  3.408842766239017e-02, -1.995702965406011e-04,
  8.614405845436819e-07, -3.227896128461840e-09,  1.098435149426822e-11, -3.437637558871501e-14,  9.847045170837195e-17, -2.519414470641485e-19,  5.369222723662337e-22,
 -7.204277832419705e-25, -1.005439352325917e-27,  1.305162253255861e-29,  5.615466830927444e-02, -3.251947099788189e-04,  1.372545550190458e-06, -4.943852073760264e-09,
  1.576016428660193e-11, -4.427655908551813e-14,  1.047130124275824e-16, -1.753062130690063e-19, -1.468435628051200e-23,  1.820089052698087e-24, -1.033429594858576e-26,
  4.105045810273756e-29,  8.352089779544766e-02, -4.770976201081697e-04,  1.956936823793061e-06, -6.692030804122362e-09,  1.946319106294214e-11, -4.593233359294237e-14,
  7.002579814635217e-17,  5.752169241913214e-20, -1.016127223040879e-21,  5.078658328507629e-24, -1.781212649659660e-26,  4.575932328695544e-29,  1.160438324258614e-01,
 -6.520082497780180e-04,  2.582087050103514e-06, -8.261006647134582e-09,  2.110242457637979e-11, -3.617896863146149e-14, -8.812387968252948e-18,  4.042831647898627e-19,
 -2.073869743783073e-21,  6.884521067574488e-24, -1.459702742940803e-26,  1.565291922395782e-30,  1.535526382967408e-01, -8.461464576929639e-04,  3.212553407983268e-06,
 -9.444512031315762e-09,  1.991690091740702e-11, -1.412013740859534e-14, -1.205470655441164e-16,  7.567513385496419e-19, -2.604421966230285e-21,  5.100698492302877e-24,
  3.459998636216523e-27, -8.060438909128032e-29,  1.958495464468071e-01, -1.055298107267706e-03,  3.811678016846829e-06, -1.006063594547251e-08,  1.550615759824616e-11,
  1.841637418196325e-14, -2.406222098343198e-16,  9.715991787867318e-19, -2.096227438363054e-21, -9.138201846844812e-25,  3.037474510774512e-26, -1.459931165649396e-28,
  2.427105797350305e-01, -1.274899994606529e-03,  4.343369622716658e-06, -9.969372078406284e-09,  7.915457884405503e-12,  5.696435635944296e-14, -3.364269321161094e-16,
  9.201464653478465e-19, -3.911055505983344e-22, -9.398892521152591e-24,  5.069459835595359e-26, -1.269915987547913e-28,  2.938863951967215e-01, -1.500132959081784e-03,
  4.773886696965790e-06, -9.086991642794197e-09, -2.337561096028543e-12,  9.506086274385097e-14, -3.754928261377728e-16,  5.406127643372326e-19,  2.147845600387541e-21,
 -1.651339288902517e-23,  4.739875434073162e-26,  2.953371707670639e-30,  3.491032458084168e-01, -1.726021615336938e-03,  5.073539908771289e-06, -7.395935834892074e-09,
 -1.430084135156976e-11,  1.253499890680264e-13, -3.346321942731987e-16, -1.260668410138094e-19,  4.680023289752944e-21, -1.795081873020291e-23,  1.324691892160751e-26,
  1.915857413963850e-28,  4.080640656251741e-01, -1.947538970563001e-03,  5.218233094405173e-06, -4.949254932314559e-09, -2.668810492633269e-11,  1.409591488572733e-13,
 -2.075981056367512e-16, -9.318931927007591e-19,  6.157356254815279e-21, -1.119379084887240e-23, -4.141878646737310e-26,  3.220351401933758e-28,  4.704496821228927e-01,
 -2.159714029595709e-03,  5.190766498208387e-06, -1.869044517554701e-09, -3.803053120155399e-11,  1.368940760307585e-13, -9.053390694312354e-18, -1.654399414533523e-18,
  5.735237510166158e-21,  2.717896499137068e-24, -9.046861948283296e-26,  2.817338644033685e-28,  5.359201592651442e-01, -2.357740347518273e-03,  4.981834241181027e-06,
  1.661184638286617e-09, -4.686176198816360e-11,  1.111800017128581e-13,  2.265561647824644e-16, -2.059316580278511e-18,  3.165062432939588e-21,  1.895096486929869e-23,
 -1.042859300498346e-25,  4.653322483503472e-29,  6.041162743020382e-01, -2.537083370496318e-03,  4.590659587663477e-06,  5.409753572931112e-09, -5.191276367237380e-11,
  6.550927119615070e-14,  4.513894777682909e-16, -1.975304673572759e-18, -1.003587500139777e-21,  3.056164421655581e-23, -6.685591107809266e-26, -2.797983847329025e-28,
  6.746611305831078e-01, -2.693584316574583e-03,  4.025226379018750e-06,  9.114730175609421e-09, -5.229062267398787e-11,  5.236927577280619e-15,  6.146477265269305e-16,
 -1.356785358852649e-18, -5.522382219177153e-21,  3.152879366385769e-23,  1.212009999605697e-26, -5.091825217327137e-28,  7.471619077150830e-01, -2.823558295605979e-03,
  3.302082568429714e-06,  1.250512006347774e-08, -4.761626096761091e-11, -6.131714402174385e-14,  6.746915248631795e-16, -3.126310667175989e-19, -8.841070833508492e-21,
  1.978462566468360e-23,  9.832871015846805e-26, -4.804127136978803e-28,  8.212117492103667e-01, -2.923884358024605e-03,  2.445711530689669e-06,  1.532359494592811e-08,
 -3.810041547414042e-11, -1.241684909420477e-13,  6.098477593048174e-16,  9.120546267991536e-19, -9.671405253723399e-21, -1.283338003687214e-24,  1.485013334780828e-25,
 -1.707806594949123e-28,  8.963917863493799e-01, -2.992085202361550e-03,  1.487487969277279e-06,  1.734880766078439e-08, -2.454465315990677e-11, -1.733569251154291e-13,
  4.250412447220146e-16,  1.999174609679933e-18, -7.504517732681291e-21, -2.378694026622764e-23,  1.332853739986725e-25,  2.695623189724884e-28,  9.722732953216893e-01,
 -3.026394367301777e-03,  4.642568730918134e-07,  1.841529216806317e-08, -8.263867515433889e-12, -2.007217292487095e-13,  1.522785938624835e-16,  2.648778970697591e-18,
 -2.867482485494246e-21, -3.853385911308975e-23,  5.475876320307609e-26,  5.942122819146172e-28,  1.048419982825781e+00, -3.025808890857995e-03, -5.834049751113009e-07,
  1.842907339052927e-08,  9.062580866803044e-12, -2.014272022330379e-13, -1.555113321867887e-16,  2.670405352205003e-18,  2.805214803943269e-21, -3.910459305366372e-23,
 -5.212223161072830e-26,  6.082364849281506e-28,  1.124390393212037e+00, -2.990125640696785e-03, -1.613166123943053e-06,  1.737741700666512e-08,  2.559360277718518e-11,
 -1.749336338686842e-13, -4.360698843733845e-16,  2.044988782920342e-18,  7.659772826625093e-21, -2.489555908846220e-23, -1.363018696426441e-25,  2.939004423858863e-28,
  1.199740427973099e+00, -2.919959807750447e-03, -2.583061017779786e-06,  1.533161760874565e-08,  3.955711473980371e-11, -1.252029569567269e-13, -6.321344058708978e-16,
  9.357634173685883e-19,  1.009522106982698e-20, -1.593923832097948e-24, -1.571979997325284e-25, -1.712209417863889e-28,  1.274025965954895e+00, -2.816744409618043e-03,
 -3.453646524206590e-06,  1.244232247419867e-08,  4.947773554651380e-11, -6.007040561322131e-14, -7.049465527587247e-16, -3.574921406864093e-19,  9.358585132091867e-21,
  2.126164385225557e-23, -1.063625977142273e-25, -5.211325676539030e-28,  1.346805570124399e+00, -2.682710067770740e-03, -4.190079819634897e-06,  8.927569257572436e-09,
  5.436949088754631e-11,  1.012276743138093e-14, -6.434541001216090e-16, -1.487769905031422e-18,  5.822308551162065e-21,  3.454675518218676e-23, -1.174255658632093e-26,
 -5.661366419348616e-28,  1.417643264140611e+00, -2.520844796978033e-03, -4.764001909390845e-06,  5.054418302473123e-09,  5.386529705170915e-11,  7.438792887551336e-14,
 -4.667304980464389e-16, -2.165484955463849e-18,  8.267347616548435e-22,  3.361254884136438e-23,  7.809795385008055e-26, -3.069344962226674e-28,  1.486111359396581e+00,
 -2.334834067051171e-03, -5.155116521591897e-06,  1.115715491257418e-09,  4.826310345259742e-11,  1.230829879372272e-13, -2.188729753545817e-16, -2.244293208387930e-18,
 -3.851263632772640e-21,  2.017677522854410e-23,  1.206844148042588e-25,  7.680460881304107e-29,  1.551793310704060e+00, -2.128981952913999e-03, -5.352366366089706e-06,
 -2.595940028790176e-09,  3.848010445997558e-11,  1.496467721915022e-13,  4.235089997438676e-17, -1.759701902746360e-18, -6.685323449189593e-21,  1.158476753485324e-24,
  1.017334895974963e-25,  3.518780004546130e-28,  1.614286576457097e+00, -1.908114762811253e-03, -5.354627569321379e-06, -5.814590535479349e-09,  2.591981104419125e-11,
  1.517221670909161e-13,  2.601144603636351e-16, -9.080572265242067e-19, -6.958445868438848e-21, -1.487986624990256e-23,  4.012997074884828e-26,  3.816386427556528e-28,
  1.673205457019864e+00, -1.677469106858513e-03, -5.170867794962470e-06, -8.325114998598919e-09,  1.227001934695082e-11,  1.314362320205574e-13,  3.924761962090553e-16,
  2.582446836546921e-20, -4.967359389009273e-21, -2.181720171351536e-23, -2.609207310228480e-26,  1.985423459238803e-28,  1.728183883323711e+00, -1.442566917498415e-03,
 -4.819742978848821e-06, -9.982791325227628e-09, -7.392749119778721e-13,  9.477950973096575e-14,  4.218954876871355e-16,  7.661576247242129e-19, -1.803275566567744e-21,
 -1.851671505017774e-23, -6.311085602006007e-26, -4.261039672784117e-29,  1.778878126316632e+00, -1.209080436635679e-03, -4.328640147218490e-06, -1.072617943474845e-08,
 -1.158206886121868e-11,  5.021860094757999e-14,  3.578062713665417e-16,  1.134086044723717e-18,  1.173627980900366e-21, -8.659931695807482e-24, -5.932413438429101e-26,
 -1.854588639999179e-28,  1.824969397076300e+00, -9.826906177176748e-04, -3.732207491414868e-06, -1.058189860082369e-08, -1.914923928483815e-11,  6.843421946419645e-15,
  2.317311171899090e-16,  1.095536669664174e-18,  2.918594513000280e-21,  1.796378274308536e-24, -2.779885383852143e-26, -1.737159643095126e-28,  1.866166307183673e+00,
 -7.689427319535493e-04, -3.070445537690841e-06, -9.660668959376197e-09, -2.289517264946702e-11, -2.754550135113436e-14,  8.658370212961443e-17,  7.541992373366455e-19,
  3.084716516081898e-21,  7.962099636918259e-24,  6.329076163723930e-27, -6.527264177879422e-29,  1.902207159540748e+00, -5.731031950592794e-04, -2.386462583393315e-06,
 -8.144881319691395e-09, -2.289509737275383e-11, -4.798980206203568e-14, -3.650956405137128e-17,  2.958066065498537e-19,  2.050737578785978e-21,  8.275939565142110e-24,
  2.346950847015492e-26,  3.633538695381624e-29,  1.932862041709325e+00, -4.000217247242341e-04, -1.724021354689979e-06, -6.268856266257612e-09, -1.980400780682637e-11,
 -5.322712497933834e-14, -1.098617963437871e-16, -9.188209056940310e-20,  6.173432101658285e-22,  4.590321995571220e-24,  2.014702019066451e-26,  6.722379661109263e-29,
  1.957934699117125e+00, -2.540028748835139e-04, -1.125020090415482e-06, -4.293752164529294e-09, -1.472383409930714e-11, -4.566713942193377e-14, -1.258984145871989e-16,
 -2.907219700106572e-19, -4.485356691379795e-22,  3.382680218674154e-25,  6.788573338473606e-27,  3.739353679728985e-29,  1.977264185659091e+00, -1.386906936926536e-04,
 -6.270581688045713e-07, -2.479686708457423e-09, -9.000510323181795e-12, -3.051412744099610e-14, -9.702007498698624e-17, -2.876984237903446e-19, -7.815544020611430e-22,
 -1.861010613650388e-24, -3.396356892751074e-27, -1.594477478285527e-30,  1.990726419205581e+00, -5.696913247423812e-05, -2.612303856622403e-07, -1.057961480380245e-09,
 -3.984219409634632e-12, -1.425966053173555e-14, -4.901220530806400e-17, -1.625759985769440e-19, -5.212236127270534e-22, -1.613251294296371e-24, -4.801104960039967e-27,
 -1.362773787027139e-29,  1.998237579617105e+00, -1.086920356776697e-05, -5.022998054987939e-08, -2.060920563324728e-10, -7.915641214425584e-13, -2.913434243795591e-15,
 -1.040344251838968e-17, -3.630281382851720e-20, -1.243547190079251e-22, -4.194015287748257e-25, -1.395417064419494e-27, -4.586219241126519e-30,  6.829593082271114e-04,
 -4.016121025282526e-06,  1.770654975751926e-08, -6.936202841425437e-11,  2.545888173724336e-13, -8.964843624875923e-16,  3.066710242465158e-18, -1.026745866905535e-20,
  3.380448692189874e-23, -1.098000644581103e-25,  3.526314200930612e-28, -1.121588538646512e-30,  6.141692399233533e-03, -3.602320111422741e-05,  1.579962831634662e-07,
 -6.135227429099827e-10,  2.222229255849278e-12, -7.679537816365423e-15,  2.561073505138486e-17, -8.293305975673554e-20,  2.616112140243598e-22, -8.050071196648383e-25,
  2.416040639037117e-27, -7.061696552202933e-30,  1.703281480890843e-02, -9.938959169110267e-05,  4.313728158428166e-07, -1.645562325013946e-09,  5.799610513538762e-12,
 -1.926242756835048e-14,  6.075687033984886e-17, -1.821443698224457e-19,  5.163503450459489e-22, -1.366048946409612e-24,  3.275942373083555e-27, -6.614862447176988e-30,
  3.330368835561195e-02, -1.928307745644276e-04,  8.237380498067996e-07, -3.057520683040689e-09,  1.031989541908867e-11, -3.209581977801578e-14,  9.165268430952637e-17,
 -2.351815942594638e-19,  5.103930724882319e-22, -7.500607814040452e-25, -4.973963713684154e-28,  1.014098908416969e-29,  5.487548042968486e-02, -3.144474301336779e-04,
  1.314703516294888e-06, -4.698638817982530e-09,  1.489936660576616e-11, -4.182234499690398e-14,  9.980716132440693e-17, -1.748040966418009e-19,  4.381714175411422e-23,
  1.441060963012932e-24, -8.659777934889917e-27,  3.519087383655426e-29,  8.164331709242185e-02, -4.617581182298849e-04,  1.878470902276181e-06, -6.387877123232030e-09,
  1.856146275174089e-11, -4.423589734809648e-14,  7.120770840203020e-17,  2.779730294193409e-20, -8.456432887110751e-22,  4.405528915409021e-24, -1.586749950080636e-26,
  4.258337413881795e-29,  1.134764930138028e-01, -6.317423968848883e-04,  2.484956897952158e-06, -7.929164263496097e-09,  2.037760934551464e-11, -3.626190092870591e-14,
  1.614904043010271e-18,  3.417723951039517e-19, -1.836500305651780e-21,  6.304175924044845e-24, -1.437077408819417e-26,  8.362715702527986e-30,  1.502187431561318e-01,
 -8.208939720583485e-04,  3.101121476895557e-06, -9.128250994975673e-09,  1.960723523703917e-11, -1.676824566280345e-14, -1.004970522530625e-16,  6.763679392068408e-19,
 -2.419110814255816e-21,  5.173566671377931e-24,  3.119463511608633e-28, -6.295293331843772e-29,  1.916885822464323e-01, -1.025283349983743e-03,  3.692450139993600e-06,
 -9.809895462450473e-09,  1.581890006472042e-11,  1.296029619265098e-14, -2.143598877171536e-16,  9.042157831672173e-19, -2.108755433082966e-21,  1.779436071004966e-25,
  2.434264901782351e-26, -1.282622405060517e-28,  2.376797191484448e-01, -1.240629330701029e-03,  4.224533241005657e-06, -9.834040425475881e-09,  8.976080854464163e-12,
  4.919756603957839e-14, -3.108861863774452e-16,  9.025977344965976e-19, -6.943154695956661e-22, -7.483158410204773e-24,  4.509262089541627e-26, -1.269403314879554e-28,
  2.879615542250840e-01, -1.462378535584099e-03,  4.664679559858449e-06, -9.109667245479442e-09, -5.251981540648828e-13,  8.623791119221107e-14, -3.594801967607753e-16,
  6.001977412201347e-19,  1.587440266397777e-21, -1.462370089524177e-23,  4.688002779951934e-26, -2.531804877926010e-29,  3.422797686505872e-01, -1.685792003123459e-03,
  4.983497112926298e-06, -7.605130561948391e-09, -1.187435427543546e-11,  1.172927878438742e-13, -3.361617447870356e-16,  1.347213877006979e-20,  4.045234431893820e-21,
 -1.726642119158324e-23,  2.063295122559516e-26,  1.449158541022466e-28,  4.003570153610403e-01, -1.906037716752351e-03,  5.156372110001581e-06, -5.353990331174120e-09,
 -2.392074557915285e-11,  1.356855601027264e-13, -2.309953222754141e-16, -7.415980423433203e-19,  5.727883172481124e-21, -1.257709002892316e-23, -2.799948179731731e-26,
  2.872939725452531e-28,  4.618937218915195e-01, -2.118287748125751e-03,  5.164777302717027e-06, -2.455657146089462e-09, -3.529846719780288e-11,  1.361417211126877e-13,
 -5.279731638453364e-17, -1.469980234826837e-18,  5.770967549530057e-21, -6.491886233960473e-25, -7.781626351075964e-26,  2.912934188626567e-28,  5.265690157031508e-01,
 -2.317818512308930e-03,  4.997344010409754e-06,  9.294612849928385e-10, -4.458839728507874e-11,  1.159374658845114e-13,  1.704101002059130e-16, -1.947918737894352e-18,
  3.772881805777548e-21,  1.483973379759960e-23, -1.008232766434821e-25,  1.086347109697157e-28,  5.940417827162096e-01, -2.500112442590546e-03,  4.650638096503489e-06,
  4.590200592087199e-09, -5.049873927491291e-11,  7.567628490132158e-14,  3.957929275389644e-16, -1.990354662887704e-18,  4.575823846033163e-23,  2.766638499659720e-23,
 -7.728851500985992e-26, -1.949283336781069e-28,  6.639518695957425e-01, -2.660959208441485e-03,  4.129589257865371e-06,  8.279706359468270e-09, -5.204154460033719e-11,
  1.951367524892503e-14,  5.743547605517408e-16, -1.515290400007352e-18, -4.383886616626178e-21,  3.158019531685424e-23, -9.163272789572112e-27, -4.561490856645471e-28,
  7.359214398425346e-01, -2.796554428421632e-03,  3.447535219222677e-06,  1.173432539997497e-08, -4.868154926303831e-11, -4.526087655392856e-14,  6.620892995912872e-16,
 -5.834321587788361e-19, -8.063199364647466e-21,  2.328682087004721e-23,  7.661812199320597e-26, -5.028027189980911e-28,  8.095564928831398e-01, -2.903593680063616e-03,
  2.625857677157561e-06,  1.469492463469898e-08, -4.043553406322205e-11, -1.092606682638419e-13,  6.310536334989266e-16,  6.029604112934910e-19, -9.612764477047671e-21,
  4.477094641752427e-24,  1.388222368993982e-25, -2.665705022801598e-28,  8.844485540889191e-01, -2.979359491794378e-03,  1.693204805112867e-06,  1.692892889015116e-08,
 -2.790539110184304e-11, -1.625121028330218e-13,  4.775348354322374e-16,  1.746378912557101e-18, -8.262330558588394e-21, -1.825207584313228e-23,  1.426151625975798e-25,
  1.539540739761418e-28,  9.601765419508617e-01, -3.021798929747486e-03,  6.843152831260274e-07,  1.825117839599458e-08, -1.223580677490145e-11, -1.961886875062209e-13,
  2.249545330677756e-16,  2.535296941717907e-18, -4.209122709332988e-21, -3.583724599834347e-23,  7.961968978440093e-26,  5.321804278181511e-28,  1.036308816467191e+00,
 -3.029589377474087e-03, -3.615196156297954e-07,  1.854166913322925e-08,  5.002817437587014e-12, -2.042533882013358e-13, -7.969744199483814e-17,  2.737298702009499e-18,
  1.366484398405106e-21, -4.064215921460819e-23, -2.450306770545062e-26,  6.429437513591930e-28,  1.112405410147802e+00, -3.002190161706921e-03, -1.402297377784058e-06,
  1.775837659018961e-08,  2.199505085891538e-11, -1.846853622064060e-13, -3.755207005417102e-16,  2.274736746831503e-18,  6.668820165400462e-21, -3.005527894468798e-23,
 -1.208675963773334e-25,  4.059152864531053e-28,  1.188020439901087e+00, -2.939877814329302e-03, -2.395369401627415e-06,  1.594368423231898e-08,  3.690365393010692e-11,
 -1.400233586060536e-13, -6.014277251185902e-16,  1.256666100174426e-18,  9.923148977591698e-21, -7.998581088957178e-24, -1.621725308279156e-25, -5.290233530603676e-29,
  1.262704694460072e+00, -2.843762989682582e-03, -3.299631423879972e-06,  1.322343294200744e-08,  4.810650725340529e-11, -7.707472280151744e-14, -7.106547288879013e-16,
 -4.663593288315220e-20,  1.004201283251984e-20,  1.656160201196842e-23, -1.282713859206002e-25, -4.705920788055505e-28,  1.336008387962685e+00, -2.715787384635399e-03,
 -4.077725592098452e-06,  9.798247920297678e-09,  5.441425665804596e-11, -5.797823492457475e-15, -6.823172290330298e-16, -1.281697350116871e-18,  7.051402464053571e-21,
  3.356469005051209e-23, -3.767763894701640e-26, -6.095805139901063e-28,  1.407484065886182e+00, -2.558699439800413e-03, -4.698130752848224e-06,  5.927535960243556e-09,
  5.523614926074343e-11,  6.246292240710255e-14, -5.268076516696522e-16, -2.119093879112788e-18,  2.089493853620462e-21,  3.643687414805975e-23,  6.238826751808962e-26,
 -4.070918883172731e-28,  1.476689644835631e+00, -2.376008132191398e-03, -5.137014426475040e-06,  1.907311406913380e-09,  5.066707463768115e-11,  1.170627324488780e-13,
 -2.833226808590146e-16, -2.354974963751931e-18, -3.037412215841166e-21,  2.504738414685572e-23,  1.222147240260848e-25, -9.853565996009987e-30,  1.543191562815705e+00,
 -2.171914794638729e-03, -5.379724657465879e-06, -1.956276834813778e-09,  4.147908844874920e-11,  1.500478271816259e-13, -9.903735078369751e-18, -1.972149587216748e-18,
 -6.566683378599644e-21,  5.532336038848745e-24,  1.168012093122049e-25,  3.301064362514905e-28,  1.606568011715843e+00, -1.951223600746318e-03, -5.421813143256863e-06,
 -5.375267926398415e-09,  2.901449028588986e-11,  1.576341621115394e-13,  2.314933473252948e-16, -1.138954857507060e-18, -7.461060724262956e-21, -1.292574661147462e-23,
  5.788854685303918e-26,  4.244944035059409e-28,  1.666412218978245e+00, -1.719232114184877e-03, -5.269502847482365e-06, -8.107253189633499e-09,  1.499290090989932e-11,
  1.408456432936748e-13,  3.908544978690860e-16, -1.458809851626203e-19, -5.769291930544603e-21, -2.266766036307405e-23, -1.596128530337137e-26,  2.629942133316277e-28,
  1.722335740984518e+00, -1.481604088720732e-03, -4.939543088950816e-06, -9.978897682099466e-09,  1.259271468121540e-12,  1.051552763144017e-13,  4.424363294501301e-16,
  6.972969198271736e-19, -2.515673145452669e-21, -2.106797399777346e-23, -6.416893215288460e-26, -3.712904897761708e-30,  1.773971726795105e+00, -1.244227485331518e-03,
 -4.458431493720569e-06, -1.090298011200082e-08, -1.048923058054249e-11,  5.919094337525456e-14,  3.900362402816796e-16,  1.166179981146853e-18,  8.171765076233610e-22,
 -1.119755535446340e-23, -6.758297687036456e-26, -1.889893877890275e-28,  1.820978107724216e+00, -1.013061404957138e-03, -3.861023077149686e-06, -1.088687868442474e-08,
 -1.895421593351584e-11,  1.278367442055967e-14,  2.637217772373819e-16,  1.189736360730666e-18,  2.961332279777651e-21,  5.233380688143640e-25, -3.605941752046031e-26,
 -2.020248008009976e-28,  1.863040666070436e+00, -7.939762769512383e-04, -3.188589295970282e-06, -1.003127871277236e-08, -2.342353328713524e-11, -2.520266076957714e-14,
  1.091266385286120e-16,  8.575391807752877e-19,  3.375156069872542e-21,  8.151079410201094e-24,  2.944842283737070e-27, -8.931843668654730e-29,  1.899875935459935e+00,
 -5.925921507355294e-04, -2.486430908039648e-06, -8.518925901375474e-09, -2.386294530376363e-11, -4.875894326764593e-14, -2.726214972820964e-17,  3.663813889722937e-19,
  2.365943427199402e-21,  9.245415870126338e-24,  2.496804206645344e-26,  3.134517521316381e-29,  1.931233886323093e+00, -4.141202691928095e-04, -1.801184410882216e-06,
 -6.594380823490359e-09, -2.089511332053469e-11, -5.589228976187859e-14, -1.121319391967738e-16, -6.932161907306736e-20,  7.978352542621119e-22,  5.457755807608028e-24,
  2.328478758826060e-26,  7.547556756916983e-29,  1.956900355224150e+00, -2.632132110881320e-04, -1.177989284202440e-06, -4.536807220648285e-09, -1.566806019207305e-11,
 -4.878799265095298e-14, -1.342373500858672e-16, -3.048245098503961e-19, -4.310533559358177e-22,  6.449736393852145e-25,  8.605000204386379e-27,  4.540047928098145e-29,
  1.976699197979031e+00, -1.438286793611389e-04, -6.576990150417515e-07, -2.628706438732490e-09, -9.634745061828969e-12, -3.294216485684950e-14, -1.054360266319613e-16,
 -3.138064407009081e-19, -8.510095044611639e-22, -1.997869767560245e-24, -3.435868744139703e-27, -1.189255519178832e-31,  1.990494281025392e+00, -5.911086351601326e-05,
 -2.743180312057155e-07, -1.124056030867917e-09, -4.281554245176336e-12, -1.549251875718701e-14, -5.380684356259008e-17, -1.802226557267180e-19, -5.829067605083505e-22,
 -1.817817976954748e-24, -5.440759475112191e-27, -1.548585838076198e-29,  1.998193283150236e+00, -1.128115565461832e-05, -5.278104315645109e-08, -2.192371517189386e-10,
 -8.524143518815300e-13, -3.175778622477401e-15, -1.147798117421051e-17, -4.053492042465364e-20, -1.405084915751235e-22, -4.794738822890624e-25, -1.613870432425649e-27,
 -5.365056912300117e-30,  6.671729534056400e-04, -3.877730093579501e-06,  1.689806695523752e-08, -6.542814143699695e-11,  2.373724705708482e-13, -8.262145031528785e-16,
  2.793790436014826e-18, -9.246331230088641e-21,  3.009412615776850e-23, -9.663382210496585e-26,  3.068217649389203e-28, -9.648504452771354e-31,  6.000081745793638e-03,
 -3.478808695399690e-05,  1.508423818248742e-07, -5.791631773083587e-10,  2.074601761494574e-12, -7.091825822712583e-15,  2.340158404382875e-17, -7.500712440136855e-20,
  2.342981287026446e-22, -7.143066302946920e-25,  2.125511206321029e-27, -6.165192361715312e-30,  1.664203553354740e-02, -9.601604743453327e-05,  4.121703693284471e-07,
 -1.555773019245222e-09,  5.428539967599750e-12, -1.786364061563682e-14,  5.588093692822580e-17, -1.663832748272831e-19,  4.694622108951407e-22, -1.240711887767426e-24,
  2.993934189462439e-27, -6.200017087519409e-30,  3.254531659406378e-02, -1.863848721673515e-04,  7.880177094321172e-07, -2.897420378444767e-09,  9.699451707824246e-12,
 -2.997335585543215e-14,  8.529217389659470e-17, -2.192840625492686e-19,  4.831335717332397e-22, -7.617635679614933e-25, -1.049180458120361e-28,  7.781323357630794e-30,
  5.363837450746058e-02, -3.041513467715116e-04,  1.259723003972154e-06, -4.466812039644833e-09,  1.408647798265559e-11, -3.948550324027931e-14,  9.493961616259462e-17,
 -1.726358161363860e-19,  8.981917023688764e-23,  1.124078438981414e-24, -7.226666829067341e-27,  3.006592125232133e-29,  7.982586171499159e-02, -4.470319870299176e-04,
  1.803569382905314e-06, -6.097878396477491e-09,  1.769388250190277e-11, -4.252048804317319e-14,  7.163017500426295e-17,  3.155411314026422e-21, -6.980262577450612e-22,
  3.807315704947206e-24, -1.406782012914332e-26,  3.920009178452548e-29,  1.109886878725159e-01, -6.122378539649073e-04,  2.391739259862472e-06, -7.608919175436956e-09,
  1.965350059867462e-11, -3.611474273675697e-14,  1.039511084351468e-17,  2.865254636070282e-19, -1.619793860159774e-21,  5.738259200472798e-24, -1.388977616773301e-26,
  1.321361527859100e-29,  1.469840989589936e-01, -7.965178494307665e-04,  2.993453285216559e-06, -8.817342914796369e-09,  1.924924055556202e-11, -1.896149074336986e-14,
 -8.261452509547903e-17,  6.019336361265047e-19, -2.233263243496346e-21,  5.135235080803130e-24, -2.119634183891055e-27, -4.799807206768640e-29,  1.876457885948760e-01,
 -9.962103031794010e-04,  3.576257680380237e-06, -9.554990468231004e-09,  1.602867101721894e-11,  8.111862501142878e-15, -1.899843278045774e-16,  8.370152969092219e-19,
 -2.086136427168284e-21,  1.043865443652580e-24,  1.907778916896796e-26, -1.111955417300250e-28,  2.327840505125654e-01, -1.207302585030476e-03,  4.107417640235232e-06,
 -9.682948372331885e-09,  9.887452594984780e-12,  4.203682301704149e-14, -2.859625831468144e-16,  8.764065777804196e-19, -9.325810529628488e-22, -5.790289792693149e-24,
  3.957818867367412e-26, -1.231977485238782e-28,  2.821859825883381e-01, -1.425498377922038e-03,  4.555368548314551e-06, -9.104735301278434e-09,  1.114673719821864e-12,
  7.781731952981595e-14, -3.420400646246577e-16,  6.429318994055291e-19,  1.094409840333774e-21, -1.277753232488570e-23,  4.527315056667091e-26, -4.664795440814106e-29,
  3.356157542736947e-01, -1.646292126872630e-03,  4.891171602433261e-06, -7.776791355091240e-09, -9.609073600720185e-12,  1.092434918145931e-13, -3.340645016372148e-16,
  1.331451763918097e-19,  3.439919888930852e-21, -1.632622039585036e-23,  2.607365944253998e-26,  1.032615621630640e-28,  3.928149506283672e-01, -1.865050033599529e-03,
  5.089916392792066e-06, -5.715320481533513e-09, -2.126404995766299e-11,  1.299127819592864e-13, -2.492634440843444e-16, -5.657422651036947e-19,  5.257895699875270e-21,
 -1.345515932286854e-23, -1.617728258599618e-26,  2.498016750645826e-28,  4.535030074234871e-01, -2.077096796009942e-03,  5.132010357298668e-06, -2.998732412835112e-09,
 -3.259153036666846e-11,  1.344014975280564e-13, -9.137902056170091e-17, -1.286258851342441e-18,  5.694661011100094e-21, -3.505313758820756e-24, -6.500438415635694e-26,
  2.893536609754144e-28,  5.173777529092410e-01, -2.277807096550419e-03,  5.004294248164898e-06,  2.348008450564492e-10, -4.223309492125493e-11,  1.193869163838927e-13,
  1.176334486825491e-16, -1.819406906529787e-18,  4.235812241128093e-21,  1.091767516638603e-23, -9.492596709686336e-26,  1.572016690898567e-28,  5.841160727748851e-01,
 -2.462700625560089e-03,  4.700924191074859e-06,  3.794826149624102e-09, -4.889473271719700e-11,  8.450762003107707e-14,  3.402288831372380e-16, -1.973566558576725e-18,
  9.842529385952694e-22,  2.442734289347745e-23, -8.407947506991436e-26, -1.147716445360541e-28,  6.533747155089789e-01, -2.627539189319449e-03,  4.223965010924541e-06,
  7.450898095168487e-09, -5.151694011207798e-11,  3.277424679583604e-14,  5.301328336829415e-16, -1.637493507047487e-18, -3.258270489839721e-21,  3.083035668160633e-23,
 -2.786467734482059e-26, -3.925105115253310e-28,  7.247912557236980e-01, -2.768424203647033e-03,  3.583646603362855e-06,  1.094903616725004e-08, -4.942933591079010e-11,
 -2.959512841223776e-14,  6.422708798139687e-16, -8.274932490516404e-19, -7.175059772138330e-21,  2.590725230533832e-23,  5.439497944249117e-26, -5.040011457832409e-28,
  7.979852329605549e-01, -2.881892621433119e-03,  2.798245529217056e-06,  1.403130239379714e-08, -4.246810591598698e-11, -9.394735947166222e-14,  6.436617371120572e-16,
  2.989780312431018e-19, -9.354688753034859e-21,  9.770951274329789e-24,  1.252985720552902e-25, -3.450745645171307e-28,  8.725594829610689e-01, -2.965009097925517e-03,
  1.893567837484856e-06,  1.645707948212028e-08, -3.103722084914652e-11, -1.504949275393723e-13,  5.226410568265547e-16,  1.472583320490112e-18, -8.815402743059221e-21,
 -1.244633499552142e-23,  1.468250844502090e-25,  3.777673309738391e-29,  9.481016772767934e-01, -3.015451975241239e-03,  9.020263173578613e-07,  1.802433248546239e-08,
 -1.609992501873726e-11, -1.899543081328573e-13,  2.938678502695076e-16,  2.380621884106182e-18, -5.436500005776932e-21, -3.220701412858080e-23,  1.012925947935675e-25,
  4.499676009832894e-28,  1.024186085321364e+00, -3.031590484525057e-03, -1.386743880565261e-07,  1.858895587526665e-08,  9.048502607144808e-13, -2.052428105455937e-13,
 -2.661875323547673e-18,  2.757482790354956e-18, -1.074142564713105e-22, -4.105209161715411e-23,  4.067141125821624e-27,  6.512702214650944e-28,  1.100375570451667e+00,
 -3.012550439792963e-03, -1.187208752171569e-06,  1.808028014320233e-08,  1.821649801541699e-11, -1.929104652390472e-13, -3.090095405691583e-16,  2.469930816035622e-18,
  5.504386564914448e-21, -3.450259634342505e-23, -1.007796505157131e-25,  5.044969607659022e-28,  1.176223828337399e+00, -2.958265652774099e-03, -2.200597361675569e-06,
  1.651096730124435e-08,  3.396187837417241e-11, -1.539998129902863e-13, -5.618477333930726e-16,  1.568345369710169e-18,  9.518211690368627e-21, -1.449493702810706e-23,
 -1.617143565375588e-25,  7.481731598469840e-29,  1.251277871690321e+00, -2.869512354496206e-03, -3.136385874627933e-06,  1.397987862466616e-08,  4.639453976294487e-11,
 -9.410927952989158e-14, -7.073793707190776e-16,  2.832183909789279e-19,  1.054106750654286e-20,  1.103702126136476e-23, -1.474091409768272e-25, -3.953062826562936e-28,
  1.325080760357614e+00, -2.747924087446151e-03, -3.954929589291414e-06,  1.066704690456432e-08,  5.413177363601771e-11, -2.257748464000401e-14, -7.148664546810674e-16,
 -1.037063067325271e-18,  8.226061695210032e-21,  3.151293877949894e-23, -6.507201084006000e-26, -6.317736610409630e-28,  1.397174569857781e+00, -2.595984849483531e-03,
 -4.621658705463438e-06,  6.820601436667272e-09,  5.635421201913535e-11,  4.911630718951293e-14, -5.850057683270909e-16, -2.030797578267517e-18,  3.441559216682309e-21,
  3.854514157471338e-23,  4.231591568480046e-26, -5.043748912572978e-28,  1.467103584719299e+00, -2.416998739788392e-03, -5.109186647487788e-06,  2.736322579569704e-09,
  5.293493765515514e-11,  1.094616000939120e-13, -3.504804706611598e-16, -2.436803921086483e-18, -2.048077509573097e-21,  2.989840856256035e-23,  1.195960267652189e-25,
 -1.114807774378091e-28,  1.534417695594036e+00, -2.215034982980614e-03, -5.399119049582159e-06, -1.268635881142711e-09,  4.447307344308594e-11,  1.491239671096117e-13,
 -6.802926630571588e-17, -2.178167316232168e-18, -6.280015186508601e-21,  1.048436113906014e-23,  1.305041759058211e-25,  2.894500738186217e-28,  1.598675971242068e+00,
 -1.994847985302165e-03, -5.483425981737949e-06, -4.885524082140679e-09,  3.222000758615248e-11,  1.627799213523027e-13,  1.961935030420573e-16, -1.384669932306011e-18,
 -7.880106108314547e-21, -1.022575873872353e-23,  7.736264645949067e-26,  4.590037352824684e-28,  1.659450368368393e+00, -1.761772989660547e-03, -5.365255962895971e-06,
 -7.844323571692021e-09,  1.790317696680908e-11,  1.501555156320445e-13,  3.840617686256508e-16, -3.436542802765761e-19, -6.593847177302833e-21, -2.305441335401288e-23,
 -2.866170133955693e-27,  3.330113178183585e-28,  1.716329534243040e+00, -1.521598914382639e-03, -5.059097682017471e-06, -9.941341091967375e-09,  3.470093131636410e-12,
  1.159982248029811e-13,  4.607160720458461e-16,  6.041653394356103e-19, -3.320235955397233e-21, -2.362407675099563e-23, -6.327056747206498e-26,  4.650485969279093e-29,
  1.768922649418375e+00, -1.280421040067439e-03, -4.590233477212740e-06, -1.106081749285296e-08, -9.209144497611628e-12,  6.894621299442681e-14,  4.229909597369758e-16,
  1.185341844862620e-18,  3.634033358749862e-22, -1.406679356969587e-23, -7.585564720286837e-26, -1.857580794957726e-28,  1.816863251082457e+00, -1.044477293575471e-03,
 -3.993475643495023e-06, -1.118774533919185e-08, -1.863249551891315e-11,  1.952346368460448e-14,  2.983618165611028e-16,  1.284504155730162e-18,  2.951988988151815e-21,
 -1.105444684434156e-24, -4.559463182113312e-26, -2.315159601871460e-28,  1.859812972112785e+00, -8.199729012403566e-04, -3.311229449681825e-06, -1.040993698312709e-08,
 -2.389938698260618e-11, -2.228301196464386e-14,  1.346940343607012e-16,  9.702537634385569e-19,  3.669694581710812e-21,  8.182128965810434e-24, -1.603047023877166e-27,
 -1.182530767889005e-28,  1.897465127262743e+00, -6.128990714908383e-04, -2.590981147753621e-06, -8.908566361125403e-09, -2.484379058695777e-11, -4.928126096751549e-14,
 -1.589210271741455e-17,  4.476122674297913e-19,  2.717068985526062e-21,  1.026961176525480e-23,  2.618358851344814e-26,  2.334589447881233e-29,  1.929548076985873e+00,
 -4.288520441395375e-04, -1.882360275872468e-06, -6.937792228677976e-09, -2.204001229833924e-11, -5.860367525714672e-14, -1.136846570078281e-16, -4.046081918837552e-20,
  1.011902715045694e-21,  6.458080819892169e-24,  2.679420555550394e-26,  8.408645372036765e-29,  1.955828303638145e+00, -2.728592291302427e-04, -1.233967879718328e-06,
 -4.795480237723197e-09, -1.667673630661439e-11, -5.211364484815325e-14, -1.429615606423321e-16, -3.181762161582234e-19, -4.011330634898823e-22,  1.031807730221910e-24,
  1.080591915947244e-26,  5.490741418764477e-29,  1.976113156528755e+00, -1.492191210215931e-04, -6.901906233209432e-07, -2.788273638338569e-09, -1.031962090749490e-11,
 -3.558121311558962e-14, -1.146148607120924e-16, -3.422160205602557e-19, -9.254029210202188e-22, -2.134853301152740e-24, -3.398422061614955e-27,  1.927474129446616e-30,
  1.990253361378821e+00, -6.136055105105022e-05, -2.882281899071143e-07, -1.195111620346559e-09, -4.604738163293012e-12, -1.684660760910427e-14, -5.912436553572004e-17,
 -1.999661062468578e-19, -6.524352020205670e-22, -2.049676473027796e-24, -6.167487596720365e-27, -1.759003853713388e-29,  1.998147297035088e+00, -1.171416416623481e-05,
 -5.549586632859616e-08, -2.333992684581751e-10, -9.187792681756330e-13, -3.465394389001826e-15, -1.267859323996910e-17, -4.532030528882570e-20, -1.589907782718806e-22,
 -5.490100980601336e-25, -1.869654141841580e-27, -6.287308970707087e-30,  6.519275190884432e-04, -3.745622776020841e-06,  1.613518327867630e-08, -6.175881923325968e-11,
  2.214982685937173e-13, -7.621646113739975e-16,  2.547868766563751e-18, -8.336692174839507e-21,  2.682636356733659e-23, -8.516918816321982e-26,  2.673813569124625e-28,
 -8.314159333065085e-31,  5.863299642365922e-03, -3.360859402503088e-05,  1.440870017944803e-07, -5.470744247144489e-10,  1.938215788882475e-12, -6.554566164335741e-15,
  2.140259828040391e-17, -6.790513221346767e-20,  2.100502548895037e-22, -6.344745450459398e-25,  1.871757480096504e-27, -5.387212278585364e-30,  1.626444988031659e-02,
 -9.279191170901041e-05,  3.940106747170878e-07, -1.471703247468350e-09,  5.084309824025690e-12, -1.657674579211093e-14,  5.142597130328775e-17, -1.520525470399586e-19,
  4.268876141484930e-22, -1.126284821711415e-24,  2.730543467564763e-27, -5.771259119799384e-30,  3.181216885021712e-02, -1.802172132663387e-04,  7.541603844849460e-07,
 -2.746915723539893e-09,  9.119966297415619e-12, -2.799830146828344e-14,  7.936453924753237e-17, -2.042627402998634e-19,  4.557116213638357e-22, -7.597035299048912e-25,
  1.940532000842189e-28,  5.876144241374974e-30,  5.244159054180495e-02, -2.942841974173967e-04,  1.207447897500021e-06, -4.247623908371234e-09,  1.331916371784682e-11,
 -3.726459784120680e-14,  9.015175263768317e-17, -1.691674180009971e-19,  1.253891590039739e-22,  8.601110620106875e-25, -6.004181618298937e-27,  2.560537137634622e-29,
  7.806613414824451e-02, -4.328913814179863e-04,  1.732065693887743e-06, -5.821486162572579e-09,  1.686065861834884e-11, -4.080270484168089e-14,  7.142566090004203e-17,
 -1.709370550778384e-20, -5.706852599306215e-22,  3.278086802632813e-24, -1.241867785508356e-26,  3.576206181483526e-29,  1.085774334816540e-01, -5.934638770474845e-04,
  2.302295181198130e-06, -7.300225344719308e-09,  1.893432093570777e-11, -3.577465762217904e-14,  1.772245405470329e-17,  2.378912715860240e-19, -1.423067122172342e-21,
  5.195366216676019e-24, -1.323093732823872e-26,  1.650518303182714e-29,  1.438452600486343e-01, -7.729882493090219e-04,  2.889480249097204e-06, -8.512491046464914e-09,
  1.885150742735669e-11, -2.074989498832792e-14, -6.673323276204360e-17,  5.334068470277496e-19, -2.050394523654375e-21,  5.012062143175136e-24, -3.947922025415049e-27,
 -3.548705595464428e-29,  1.837174474950548e-01, -9.680545107208225e-04,  3.463141119961376e-06, -9.297473740354300e-09,  1.614717155932158e-11,  3.825972061425892e-15,
 -1.674758431753041e-16,  7.709981972873837e-19, -2.035956518380851e-21,  1.713925856830622e-24,  1.454193550815115e-26, -9.517585551993512e-29,  2.280198268286330e-01,
 -1.174905274528896e-03,  3.992198014259475e-06, -9.518387853978681e-09,  1.066152751902336e-11,  3.546463947354014e-14, -2.618702148706739e-16,  8.435238176743166e-19,
 -1.113826201644672e-21, -4.313854572479399e-24,  3.429025664664218e-26, -1.168017813003624e-28,  2.765561835939078e-01, -1.389492038223510e-03,  4.446268664913674e-06,
 -9.074889584292548e-09,  2.590407358333698e-12,  6.982792784188107e-14, -3.236143607489875e-16,  6.709383481853875e-19,  6.664753063812850e-22, -1.101255947412668e-23,
  4.286439783302852e-26, -6.191560073171812e-29,  3.291082500011834e-01, -1.607538490479137e-03,  4.796998328709697e-06, -7.913491709675709e-09, -7.504015264000366e-12,
  1.012825836336490e-13, -3.288822268273029e-16,  2.340282158142013e-19,  2.871942535666982e-21, -1.520346660288532e-23,  2.980019093498072e-26,  6.703776038395568e-29,
  3.854357468841560e-01, -1.824610626331596e-03,  5.019375873859785e-06, -6.035089324854022e-09, -1.872680430281902e-11,  1.237589309334504e-13, -2.628222787448446e-16,
 -4.053438380451658e-19,  4.764408685254344e-21, -1.389368797560326e-23, -6.027933931983363e-27,  2.115498614885747e-28,  4.452764922546462e-01, -2.036193313746810e-03,
  5.092985067862891e-06, -3.498823693717072e-09, -2.992824275245160e-11,  1.317966760262093e-13, -1.248654653490765e-16, -1.106525840213207e-18,  5.524711394758674e-21,
 -5.853555367739000e-24, -5.248940939718982e-26,  2.781698393735058e-28,  5.083465950987691e-01, -2.237772777146511e-03,  5.003136726788222e-06, -4.216904138374330e-10,
 -3.982117037510501e-11,  1.216144524419871e-13,  6.864164272804880e-17, -1.678290935835022e-18,  4.562273786666940e-21,  7.270318915196795e-24, -8.718431230871529e-26,
  1.925754302802272e-28,  5.743407548637828e-01, -2.424924248502589e-03,  4.741825371525495e-06,  3.026456589671890e-09, -4.712737967702521e-11,  9.201434304591206e-14,
  2.855374871996968e-16, -1.928657956219366e-18,  1.802084689436938e-21,  2.098519814127571e-23, -8.749737208034334e-26, -4.197864902284251e-29,  6.429326887488679e-01,
 -2.593403784501265e-03,  4.308453989023524e-06,  6.632546438221207e-09, -5.073799370066003e-11,  4.493647211567473e-14,  4.829884407949812e-16, -1.724247565528472e-18,
 -2.172418178606701e-21,  2.939066460876699e-23, -4.360877086561876e-26, -3.223907344789873e-28,  7.137757103481431e-01, -2.739242961447715e-03,  3.710272978665805e-06,
  1.015426076001770e-08, -4.986910060189310e-11, -1.448373432257928e-14,  6.160295957830639e-16, -1.041795820431244e-18, -6.208545096999372e-21,  2.764348037503282e-23,
  3.254634604821631e-26, -4.862097768626440e-28,  7.865034842931322e-01, -2.858844843344499e-03,  2.962484939666369e-06,  1.333762269871929e-08, -4.419206952401548e-11,
 -7.843248886959917e-14,  6.479018205202640e-16,  6.192510069843124e-21, -8.916552823995556e-21,  1.446038840685709e-23,  1.087430959994771e-25, -4.041245078302771e-28,
  8.607309821785823e-01, -2.949079281791789e-03,  2.087976135965937e-06,  1.593709972466023e-08, -3.391851207870602e-11, -1.374890041226796e-13,  5.598648200421458e-16,
  1.184456083257010e-18, -9.157660079291871e-21, -6.573372235933951e-24,  1.460119788591522e-25, -7.350606651527088e-29,  9.360556650864070e-01, -3.007375262052545e-03,
  1.116648646880005e-06,  1.773674649594317e-08, -1.982318968560134e-11, -1.821222916052539e-13,  3.579211980359533e-16,  2.188921701626459e-18, -6.518502127256054e-21,
 -2.778718413736428e-23,  1.189853082563638e-25,  3.520745781600997e-28,  1.012058917289988e+00, -3.031807675489609e-03,  8.434454824567815e-08,  1.857061738544740e-08,
 -3.194398622861739e-12, -2.043819327949768e-13,  7.427789499731222e-17,  2.730486805736699e-18, -1.575483672287550e-21, -4.031979864772912e-23,  3.241281869043977e-26,
  6.327952530512416e-28,  1.088307754059140e+00, -3.021175597199696e-03, -9.686251677297583e-07,  1.834049934544210e-08,  1.428982612196071e-11, -1.994780680035571e-13,
 -2.375775284858084e-16,  2.625464616786551e-18,  4.195311899703817e-21, -3.806480254314204e-23, -7.674865534259551e-26,  5.843359389481715e-28,  1.164356823728874e+00,
 -2.975068906369197e-03, -1.999309384586045e-06,  1.702900027896151e-08,  3.075077133402598e-11, -1.669233032860514e-13, -5.137572029294199e-16,  1.863339371837573e-18,
  8.881104157850991e-21, -2.085908407625116e-23, -1.555363347013495e-25,  2.060634671007619e-28,  1.239750720188496e+00, -2.893919937027266e-03, -2.964238546382313e-06,
  1.470621473974369e-08,  4.434342386129237e-11, -1.109527809112863e-13, -6.946754277587334e-16,  6.257194631566887e-19,  1.082832034873892e-20,  4.820173462181539e-24,
 -1.627156323692626e-25, -2.968270271797060e-28,  1.314026616563635e+00, -2.779036822487555e-03, -3.821746322562247e-06,  1.152860137489307e-08,  5.350646204218442e-11,
 -4.005195836637419e-14, -7.400522939357229e-16, -7.562344706219887e-19,  9.306963065238861e-21,  2.835301281968678e-23, -9.290371829194405e-26, -6.289046930025739e-28,
  1.386717224018357e+00, -2.632615332307008e-03, -4.534371590421295e-06,  7.729345497829172e-09,  5.719160072534143e-11,  3.440755818160419e-14, -6.401156060558478e-16,
 -1.898184039922947e-18,  4.854056488633728e-21,  3.976695959869239e-23,  1.812693577065031e-26, -5.932570187553784e-28,  1.457354071276798e+00, -2.457726327884740e-03,
 -5.071198321969945e-06,  3.600315092979094e-09,  5.503449373799733e-11,  1.002249241090374e-13, -4.194601915401633e-16, -2.484209178007737e-18, -8.871049292133352e-22,
  3.455135262577945e-23,  1.122195311532250e-25, -2.256058901756366e-28,  1.525471090716644e+00, -2.258276507236095e-03, -5.409975188274183e-06, -5.333167213598283e-10,
  4.743416993001754e-11,  1.467370773364206e-13, -1.317673340516309e-16, -2.372057367840581e-18, -5.805693853059931e-21,  1.594268505126495e-23,  1.419633947941552e-25,
  2.278333089352369e-28,  1.590608485886027e+00, -2.038940885449858e-03, -5.538850923787107e-06, -4.343717035862567e-09,  3.551940339661420e-11,  1.669945040544601e-13,
  1.538416047835072e-16, -1.642086149050716e-18, -8.187594296943983e-21, -6.719753171303743e-24,  9.810007844909445e-26,  4.812398177402603e-28,  1.652316843325562e+00,
 -1.805066463758885e-03, -5.457568425843456e-06, -7.533350751556898e-09,  2.099755621540162e-11,  1.592329199496773e-13,  3.713606492944609e-16, -5.679289170719520e-19,
 -7.422143262409343e-21, -2.285453571920076e-23,  1.339594548750818e-26,  4.065434031587709e-28,  1.710161439050601e+00, -1.562547756097730e-03, -5.177982126114119e-06,
 -9.866653586716403e-09,  5.901934285501635e-12,  1.272456009363942e-13,  4.760139281414811e-16,  4.838269030990178e-19, -4.215606832930746e-21, -2.609649377377276e-23,
 -5.989506663647256e-26,  1.090151266252893e-28,  1.763726677506780e+00, -1.317676223574179e-03, -4.723800042907831e-06, -1.119656952862934e-08, -7.726009323930231e-12,
  7.949709570679781e-14,  4.562629396639286e-16,  1.188266842789280e-18, -1.995624035520234e-22, -1.726164009565254e-23, -8.379860650869921e-26, -1.736275785214095e-28,
  1.812620588916719e+00, -1.076967146273619e-03, -4.129503127495253e-06, -1.148234002957042e-08, -1.816745119054054e-11,  2.712636521153448e-14,  3.356418138097770e-16,
  1.377958626940892e-18,  2.876830071531037e-21, -3.141722113979904e-24, -5.643534822243285e-26, -2.611648219357119e-28,  1.856479300460893e+00, -8.469689471284711e-04,
 -3.438457146649437e-06, -1.079570733671167e-08, -2.431045038636187e-11, -1.871080879448474e-14,  1.635492946095450e-16,  1.092373770885580e-18,  3.961755508206417e-21,
  8.004248965339236e-24, -7.540865157531707e-27, -1.525723612073839e-28,  1.894971388588454e+00, -6.340613643895062e-04, -2.700301528665457e-06, -9.313968293096868e-09,
 -2.583216247366492e-11, -4.950209990778490e-14, -2.084681301431188e-18,  5.406777335320791e-19,  3.105846364403821e-21,  1.133432313320586e-23,  2.696579223538483e-26,
  1.149648926324107e-29,  1.927802015190670e+00, -4.442500252991969e-04, -1.967768783314746e-06, -7.299957574816753e-09, -2.323944203674807e-11, -6.134182042131875e-14,
 -1.143277589708088e-16, -4.145835743244317e-21,  1.264600525588520e-21,  7.606417723511064e-24,  3.068631825609130e-26,  9.282408095797870e-29,  1.954716752269203e+00,
 -2.829657717307286e-04, -1.293149616469873e-06, -5.070835678343718e-09, -1.775404894126962e-11, -5.565304258433514e-14, -1.520439951178245e-16, -3.303298182016273e-19,
 -3.555968127406603e-22,  1.515537716293514e-24,  1.346243578580167e-26,  6.615028714908934e-29,  1.975505021050616e+00, -1.548773451505709e-04, -7.246645673706054e-07,
 -2.959233343753497e-09, -1.105954648098988e-11, -3.845037255938611e-14, -1.246232294945004e-16, -3.730846151606158e-19, -1.004677259251100e-21, -2.268335348569828e-24,
 -3.255457255219764e-27,  4.707325007053385e-30,  1.990003214892473e+00, -6.372502053423606e-05, -3.030229580229260e-07, -1.271561933361695e-09, -4.956326174688300e-12,
 -1.833521012028939e-14, -6.502714875422839e-17, -2.220738134814846e-19, -7.308568171393763e-22, -2.312534226158753e-24, -6.992713618503697e-27, -1.996763512268495e-29,
  1.998099534346323e+00, -1.216958954670788e-05, -5.838720227880557e-08, -2.486711747684739e-10, -9.912358554249037e-13, -3.785501952036154e-15, -1.402186702837657e-17,
 -5.073923306142166e-20, -1.801707487672574e-22, -6.296375782270151e-25, -2.169684783451949e-27, -7.381436893862580e-30,  6.371985808012329e-04, -3.619446622877297e-06,
  1.541484880248578e-08, -5.833354850837334e-11,  2.068480468244786e-13, -7.037226464176264e-16,  2.326012973529944e-18, -7.525311254710868e-21,  2.394429035654931e-23,
 -7.517077162266044e-26,  2.333679492225317e-28, -7.176174623377328e-31,  5.731129812002305e-03, -3.248164017313940e-05,  1.377039400705138e-07, -5.170844267475981e-10,
  1.812110918047650e-12, -6.062980988098447e-15,  1.959202371389673e-17, -6.153498261971237e-20,  1.885015968475894e-22, -5.641392148122366e-25,  1.649927944220210e-27,
 -4.711626068810242e-30,  1.589947647452458e-02, -8.970910990292830e-05,  3.768276021722848e-07, -1.392940930385240e-09,  4.764780107518975e-12, -1.539210523426970e-14,
  4.735379763340911e-17, -1.390202927625538e-19,  3.882473068903009e-22, -1.022015163224606e-24,  2.486065191174504e-27, -5.342248085322254e-30,  3.110316124450235e-02,
 -1.743133434089330e-04,  7.220547636812446e-07, -2.605374414914515e-09,  8.578592898910260e-12, -2.616056215909496e-14,  7.384524327691528e-17, -1.901155827762291e-19,
  4.285599497192694e-22, -7.472457892432569e-25,  4.176887395338485e-28,  4.344861510497320e-30,  5.128345513991134e-02, -2.848249332588513e-04,  1.157730832102930e-06,
 -4.040363668620780e-09,  1.259512696877067e-11, -3.515731561637832e-14,  8.547557613976520e-17, -1.647037608669853e-19,  1.522908603783321e-22,  6.412978851424666e-25,
 -4.964624003221863e-27,  2.173976443713957e-29,  7.636184563421179e-02, -4.193097625194907e-04,  1.663799854549995e-06, -5.558151116887021e-09,  1.606169769712165e-11,
 -3.909619037330741e-14,  7.070844516194553e-17, -3.356031033211370e-20, -4.612455038605220e-22,  2.811807522250877e-24, -1.091993743984723e-26,  3.237863688676966e-29,
  1.062398670785263e-01, -5.753908304956111e-04,  2.216486641426864e-06, -7.002974870563937e-09,  1.822359483553593e-11, -3.527436386553655e-14,  2.377327311858614e-17,
  1.952449749055471e-19, -1.245378803445705e-21,  4.681338984889638e-24, -1.245545267250788e-26,  1.856512507572240e-29,  1.407988989827783e-01, -7.502759113569822e-04,
  2.789126137999291e-06, -8.214268984194279e-09,  1.842166570396452e-11, -2.217951654105487e-14, -5.268952653785504e-17,  4.706478318346828e-19, -1.873149774738102e-21,
  4.826107336619509e-24, -5.274575365576760e-27, -2.515193995271940e-29,  1.798999393085242e-01, -9.407912640374771e-04,  3.353123401008446e-06, -9.038718020155212e-09,
  1.618520763005354e-11,  5.830602858820665e-17, -1.467899721430612e-16,  7.069391498778283e-19, -1.964753678469844e-21,  2.216284051886416e-24,  1.068329813914616e-26,
 -8.044228381352211e-29,  2.233833616636199e-01, -1.143421621369071e-03,  3.879023188939303e-06, -9.342462593979803e-09,  1.130986317850708e-11,  2.945901644574724e-14,
 -2.387720589176610e-16,  8.056514031527144e-19, -1.245653757920230e-21, -3.042725180331160e-24,  2.932588715320101e-26, -1.086197376476572e-28,  2.710686671792808e-01,
 -1.354356675584784e-03,  4.337663406040697e-06, -9.022686165115899e-09,  3.910831100017873e-12,  6.228867381694796e-14, -3.045867786601978e-16,  6.862477027270669e-19,
  3.001981316993904e-22, -9.355788506175414e-24,  3.990062883822599e-26, -7.202415980861646e-29,  3.227542439050893e-01, -1.569544241368641e-03,  4.701381506558258e-06,
 -8.017777194551270e-09, -5.556712994586528e-12,  9.347793124371913e-14, -3.211234168939658e-16,  3.174084347876562e-19,  2.346698123585886e-21, -1.396190110522711e-23,
  3.205446860975218e-26,  3.633276155582645e-29,  3.782171487801160e-01, -1.784750211450057e-03,  4.945237589670973e-06, -6.315263039852779e-09, -1.631553527942421e-11,
  1.173317654308798e-13, -2.721128733659232e-16, -2.609145206647622e-19,  4.262037647442082e-21, -1.395976308976803e-23,  2.451439349424064e-27,  1.741217937078922e-28,
  4.372129296204247e-01, -1.995625318000994e-03,  5.048212502685046e-06, -3.956761111500481e-09, -2.732468417554239e-11,  1.284478809193412e-13, -1.534075493610797e-16,
 -9.334882871879733e-19,  5.279096717121493e-21, -7.713266095358799e-24, -4.062903581762505e-26,  2.599544602917987e-28,  4.994755070823634e-01, -2.197778570473018e-03,
  4.994334122012146e-06, -1.039296996408488e-09, -3.737612749612087e-11,  1.227146614906299e-13,  2.372804186949763e-17, -1.528766485831780e-18,  4.763345775149464e-21,
  3.960057659448612e-24, -7.816083067825818e-26,  2.156515811682757e-28,  5.647171391768373e-01, -2.386857052071128e-03,  4.773680507862320e-06,  2.287494915724850e-09,
 -4.522290146405532e-11,  9.822640383768289e-14,  2.324511392771126e-16, -1.859581688259820e-18,  2.494286717150334e-21,  1.746778939452031e-23, -8.790993149572518e-26,
  2.159206999452096e-29,  6.326284935599341e-01, -2.558631518781039e-03,  4.383205351937416e-06,  5.828541647707255e-09, -4.972729412149701e-11,  5.594195699981124e-14,
  4.338927732275882e-16, -1.777199054942472e-18, -1.148977046030120e-21,  2.738395225317416e-23, -5.619667172825840e-26, -2.496524344101979e-28,  7.028788554215809e-01,
 -2.709086954344383e-03,  3.827329688926957e-06,  9.354830745545545e-09, -5.001340307212074e-11, -7.059002957597352e-17,  5.842290426003877e-16, -1.224336693829247e-18,
 -5.195022996191794e-21,  2.852638033703726e-23,  1.184567230243206e-26, -4.523480474845871e-28,  7.751165012180925e-01, -2.834516891910939e-03,  3.118244943450033e-06,
  1.261884473741518e-08, -4.560537330474815e-11, -6.291249660059537e-14,  6.441646345700763e-16, -2.700040790441030e-19, -8.322088925775839e-21,  1.844161804574046e-23,
  9.003687780441357e-26, -4.427792287633620e-28,  8.489692705949733e-01, -2.931619921939120e-03,  2.275876806999176e-06,  1.537314603232176e-08, -3.653141017800885e-11,
 -1.236875638437496e-13,  5.888993742857047e-16,  8.887437289615486e-19, -9.290233674509976e-21, -8.283199293210069e-25,  1.405006276464056e-25, -1.750455609224829e-28,
  9.240453704361464e-01, -2.997596374645174e-03,  1.327467945660396e-06,  1.739092302651668e-08, -2.337489557393259e-11, -1.728211668203381e-13,  4.161470478029600e-16,
  1.965271220495664e-18, -7.429722010571030e-21, -2.274926659997597e-23,  1.321207264002148e-25,  2.437186628035096e-28,  9.999344458324418e-01, -3.030242708248245e-03,
  3.067507870188375e-07,  1.848692863127143e-08, -7.258052937014140e-12, -2.016888476118025e-13,  1.498095944799184e-16,  2.657151176429723e-18, -2.997047826139497e-21,
 -3.847763048108915e-23,  5.937358949557408e-26,  5.886255630587560e-28,  1.076208952630764e+00, -3.028040672834527e-03, -7.472999424142922e-07,  1.853693552235556e-08,
  1.024927366464378e-11, -2.042838884324046e-13, -1.623949535118928e-16,  2.737248203093250e-18,  2.776087845115542e-21, -4.060203530195603e-23, -4.969946177588945e-26,
  6.410623395728632e-28,  1.152425864825674e+00, -2.990237883208281e-03, -1.792121596841235e-06,  1.749365325984378e-08,  2.729339246418001e-11, -1.785960163591023e-13,
 -4.577263019378716e-16,  2.134339160540966e-18,  8.020724628338773e-21, -2.686099357758797e-23, -1.436237128677929e-25,  3.343915793751319e-28,  1.228128747094116e+00,
 -2.916916060180603e-03, -2.783583145983514e-06,  1.539705788272496e-08,  4.195926814670028e-11, -1.273754794002068e-13, -6.722872026116054e-16,  9.737224069818936e-19,
  1.088184711662864e-20, -1.916080195393238e-24, -1.732328792761878e-25, -1.782495924040250e-28,  1.302850217964507e+00, -2.809042933626325e-03, -3.678296064168687e-06,
  1.237732484397579e-08,  5.252627301757107e-11, -5.803273806565790e-14, -7.569093182723283e-16, -4.428512836443637e-19,  1.025417156020387e-20,  2.409037945999648e-23,
 -1.200044088067196e-25, -5.981895250248506e-28,  1.376114822197528e+00, -2.668503693543030e-03, -4.436109094215959e-06,  8.649063870046485e-09,  5.772191540214183e-11,
  1.842587258797126e-14, -6.908742280610449e-16, -1.719860992238239e-18,  6.292214291927057e-21,  3.994678328898083e-23, -9.679420898408513e-27, -6.678068664419514e-28,
  1.447442321745531e+00, -2.498107981283118e-03, -5.022646917530734e-06,  4.496332312190755e-09,  5.693267599784675e-11,  8.932115722659918e-14, -4.892224259413045e-16,
 -2.491850164064944e-18,  4.348255100648121e-22,  3.880591516704946e-23,  9.961306516534568e-26, -3.484819588907417e-28,  1.516351403059854e+00, -2.301568784040290e-03,
 -5.411725081326965e-06,  2.489131527892762e-10,  5.033180138825652e-11,  1.427572266160177e-13, -2.006916887341050e-16, -2.547542366767791e-18, -5.127334522191434e-21,
  2.179867102551380e-23,  1.502252613493824e-25,  1.439891750933639e-28,  1.582363784582605e+00, -2.083450274924945e-03, -5.587454843293652e-06, -3.748503019316292e-09,
  3.889233735509571e-11,  1.701051598622859e-13,  1.041644234223889e-16, -1.907160788000534e-18, -8.353740378871815e-21, -2.369228419636529e-24,  1.194683563260922e-25,
  4.869640767721173e-28,  1.645008692227148e+00, -1.849082655515048e-03, -5.545846223067406e-06, -7.171434229862792e-09,  2.426991119270102e-11,  1.679271573012410e-13,
  3.520107770972508e-16, -8.184619973635002e-19, -8.230751038635518e-21, -2.193904299000510e-23,  3.291917884527487e-26,  4.806915871542450e-28,  1.703827652972969e+00,
 -1.604443409684862e-03, -5.295729378783335e-06, -9.751238299332075e-09,  8.562104442071271e-12,  1.388163730669334e-13,  4.875280191951433e-16,  3.334441496264898e-19,
 -5.196857333222691e-21, -2.837512359412315e-23, -5.348760454790246e-26,  1.843672517289484e-28,  1.758379538069974e+00, -1.356006035972224e-03, -4.858846147947224e-06,
 -1.130685988389163e-08, -6.023875566490304e-12,  9.084534461614018e-14,  4.893468901413643e-16,  1.171276614447017e-18, -8.831046235357132e-22, -2.076038791916672e-23,
 -9.096849972039947e-26, -1.502063164280050e-28,  1.808245768705464e+00, -1.110559221020209e-03, -4.269015925721572e-06, -1.176822804943460e-08, -1.754119138065155e-11,
  3.565504481030348e-14,  3.754932333339824e-16,  1.467748888190508e-18,  2.720247594424789e-21, -5.637461687694288e-24, -6.855844450567956e-26, -2.895296485880933e-28,
  1.853035579513375e+00, -8.750014376984850e-04, -3.570351067185987e-06, -1.118744434349942e-08, -2.464286206936166e-11, -1.440399859440129e-14,  1.959534512602699e-16,
  1.223688375592584e-18,  4.242758377311282e-21,  7.556978045457747e-24, -1.511470561743751e-26, -1.926709597883141e-28,  1.892391220426104e+00, -6.561179486795523e-04,
 -2.814581701410530e-06, -9.735200592877548e-09, -2.682141886909774e-11, -4.935884931270748e-14,  1.450854440720703e-17,  6.468022890317539e-19,  3.533378740384821e-21,
  1.241854614745248e-23,  2.712387776081326e-26, -5.201314411272961e-30,  1.925992966944069e+00, -4.603489888655422e-04, -2.057640229072560e-06, -7.681752375943261e-09,
 -2.449370177204541e-11, -6.408224515175292e-14, -1.138343994083885e-16,  4.094771725752839e-20,  1.561533172947020e-21,  8.918093467131033e-24,  3.495957236384932e-26,
  1.013431017530449e-28,  1.953563806474180e+00, -2.935592837728059e-04, -1.355741415197045e-06, -5.364006380777491e-09, -1.890435595727989e-11, -5.941432085054279e-14,
 -1.614435602798974e-16, -3.407261222362327e-19, -2.906092379736419e-22,  2.115989592454338e-24,  1.665653471081422e-26,  7.938718701183483e-29,  1.974873687809930e+00,
 -1.608197726049554e-04, -7.612629974763770e-07, -3.142504273850963e-09, -1.185932876199814e-11, -4.157039575223804e-14, -1.355321469051616e-16, -4.065655160801976e-19,
 -1.088622203981082e-21, -2.393392985907000e-24, -2.970378719741272e-27,  8.424763425546596e-30,  1.989743367863620e+00, -6.621161572306241e-05, -3.187698903426230e-07,
 -1.353883743871686e-09, -5.339154548052949e-12, -1.997320016754053e-14, -7.158554987591409e-17, -2.468489989862707e-19, -8.193614719703153e-22, -2.610580008516809e-24,
 -7.929085218276578e-27, -2.264675979590296e-29,  1.998049902505517e+00, -1.264889887268281e-05, -6.146897402644531e-08, -2.651554083151225e-10, -1.070429677273893e-12,
 -4.139748199694853e-15, -1.552681285295132e-17, -5.688477514114680e-20, -2.044814562209589e-22, -7.232871276938744e-25, -2.522259961614576e-27, -8.681955328432308e-30,
  6.229630765846637e-04, -3.498872630418976e-06,  1.473424880894545e-08, -5.513361237633668e-11,  1.933152066936925e-13, -6.503426946454981e-16,  2.125636971999225e-18,
 -6.800650687192028e-21,  2.139883055707310e-23, -6.643783149380654e-26,  2.039868598679616e-28, -6.203957996392248e-31,  5.603367899840419e-03, -3.140434486349635e-05,
  1.316689692152885e-07, -4.890357548038138e-10,  1.695417267349388e-12, -5.612784871324245e-15,  1.795052831123166e-17, -5.581553294707205e-20,  1.693322099350932e-22,
 -5.021095355606367e-25,  1.455830651174445e-27, -4.124529828125620e-30,  1.554656521236416e-02, -8.676007723130741e-05,  3.605597675746404e-07, -1.319106734794407e-09,
  4.467994730006430e-12, -1.430095432855930e-14,  4.362976729023898e-17, -1.271663195624843e-19,  3.531892134742041e-22, -9.271492831949663e-25,  2.260285872426544e-27,
 -4.922617500106259e-30,  3.041726598116114e-02, -1.686596690414415e-04,  6.915968566929855e-07, -2.472208106617249e-09,  8.072681235871629e-12, -2.445063021575462e-14,
  6.870998276337071e-17, -1.768285026492593e-19,  4.020024074591230e-22, -7.270954023517373e-25,  5.809185763999188e-28,  3.120358444865968e-30,  5.016237679952701e-02,
 -2.757536509063002e-04,  1.110432753229154e-06, -3.844356905280053e-09,  1.191212417827711e-11, -3.316067156188410e-14,  8.093530512494098e-17, -1.594975833026590e-19,
  1.720242452490739e-22,  4.608255008779599e-25, -4.083294033446316e-27,  1.840254904920438e-29,  7.471081105241742e-02, -4.062618449837991e-04,  1.598618458370451e-06,
 -5.307327488712475e-09,  1.529665956810050e-11, -3.741204123153615e-14,  6.957675080950967e-17, -4.678213881059832e-20, -3.675482871322303e-22,  2.402534262333050e-24,
 -9.567425360687307e-27,  2.912543814864645e-29,  1.039732422441517e-01, -5.579901767469081e-04,  2.134177232310423e-06, -6.717008471392088e-09,  1.752423333414534e-11,
 -3.464255396659839e-14,  2.870686194582447e-17,  1.579947704486993e-19, -1.085618037645170e-21,  4.199843828998754e-24, -1.161130324778312e-26,  1.966736965906215e-29,
  1.378418041000516e-01, -7.283522106086516e-04,  2.692308541008662e-06, -7.923135401971070e-09,  1.796646298640189e-11, -2.329254178688928e-14, -4.032474151932428e-17,
  4.134441512226118e-19, -1.703450318202662e-21,  4.595600506037369e-24, -6.189418903738163e-27, -1.672487149462828e-29,  1.761897434979311e-01, -9.143957340399840e-04,
  3.246212001223526e-06, -8.779930180020006e-09,  1.615271110102765e-11, -3.234149793559920e-15, -1.278633419582751e-16,  6.454194066116139e-19, -1.878091648220310e-21,
  2.576852356147058e-24,  7.442138546521920e-27, -6.712189140578640e-29,  2.188710339215307e-01, -1.112834754986710e-03,  3.768017839813213e-06, -9.157095111711641e-09,
  1.184354175112893e-11,  2.399458827160916e-14, -2.167867790117816e-16,  7.642550793006205e-19, -1.335204842463256e-21, -1.962606501450681e-24,  2.474756796415210e-26,
 -9.935797513316806e-29,  2.657199589906645e-01, -1.320087301395500e-03,  4.229806453684280e-06, -8.950537312135130e-09,  5.085064488351897e-12,  5.520995551976554e-14,
 -2.852858281423535e-16,  6.907668178042897e-19, -8.664245359618612e-24, -7.825141932343608e-24,  3.658934194682421e-26, -7.785300941968033e-29,  3.165506777427968e-01,
 -1.532319414665948e-03,  4.604695083396606e-06, -8.092143709866549e-09, -3.763462190703451e-12,  8.588564861994299e-14, -3.112584417323690e-16,  3.847108305653654e-19,
  1.867462113930776e-21, -1.265558907349986e-23,  3.307656900082887e-26,  1.098669892057966e-29,  3.711567857428091e-01, -1.745495705156481e-03,  4.867964425233924e-06,
 -6.557895569613964e-09, -1.403472113246686e-11,  1.107283373975969e-13, -2.775844187325787e-16, -1.325368665960354e-19,  3.763000761824328e-21, -1.371908029072977e-23,
  9.324693422980300e-27,  1.387107269977620e-28,  4.293108887976607e-01, -1.955436780928589e-03,  4.998192303811573e-06, -4.373612987569614e-09, -2.479456399252800e-11,
  1.244712696428014e-13, -1.772240387929394e-16, -7.692917016848343e-19,  4.974863895667197e-21, -9.116196314833281e-24, -2.968652824041555e-26,  2.367729575546270e-28,
  4.907642090535057e-01, -2.157883763403110e-03,  4.978355502702415e-06, -1.617663991635185e-09, -3.491951727932932e-11,  1.227878038336302e-13, -1.692620211233040e-17,
 -1.374642997440665e-18,  4.851959341310831e-21,  1.027699247077225e-24, -6.836935831849132e-26,  2.277218263367289e-28,  5.552462465399181e-01, -2.348569957695220e-03,
  4.796854811645561e-06,  1.579930299453804e-09, -4.320675365439531e-11,  1.031899879231299e-13,  1.815900052608370e-16, -1.770378874031256e-18,  3.060212034239013e-21,
  1.398683681894706e-23, -8.574985964670677e-26,  7.483544056768727e-29,  6.224645227609606e-01, -2.523299543166997e-03,  4.448412739545636e-06,  5.042404468885930e-09,
 -4.850836906819063e-11,  6.575498485450349e-14,  3.837614487035820e-16, -1.798647208693879e-18, -2.060691663281289e-22,  2.493772759844853e-23, -6.559030153406259e-26,
 -1.777173177731849e-28,  6.921044366472374e-01, -2.678032883819723e-03,  3.934788759738179e-06,  8.555354855182479e-09, -4.987746974718794e-11,  1.352169588143205e-14,
  5.477750598370252e-16, -1.374092960761957e-18, -4.164225115315854e-21,  2.861504366079400e-23, -7.072984476338827e-27, -4.057889791816866e-28,  7.638292669700604e-01,
 -2.808977722662046e-03,  3.265254154856390e-06,  1.187992965201852e-08, -4.670978892632664e-11, -4.757272207405753e-14,  6.329807632745669e-16, -5.250320145123248e-19,
 -7.598124501710110e-21,  2.164657425372019e-23,  7.007649780379902e-26, -4.612571225866438e-28,  8.372803590256289e-01, -2.912685115993535e-03,  2.456768419391837e-06,
  1.476962924052225e-08, -3.886198352714630e-11, -1.092889436302340e-13,  6.096253289826351e-16,  5.920471045689894e-19, -9.220996304119520e-21,  4.610707002737916e-24,
  1.308107578535496e-25, -2.628653351142321e-28,  9.120775368171048e-01, -2.986148483817899e-03,  1.533802777775188e-06,  1.698983418309757e-08, -2.672712830720435e-11,
 -1.622008922001641e-13,  4.677303911681848e-16,  1.715455504997708e-18, -8.151285923600982e-21, -1.728313408372082e-23,  1.403604239993183e-25,  1.304699795794040e-28,
  9.878197848290913e-01, -3.026903608741314e-03,  5.277647442814700e-07,  1.833875000525500e-08, -1.124991054421762e-11, -1.972127141712232e-13,  2.226624652206452e-16,
  2.539590493049828e-18, -4.333415066716162e-21, -3.560294422094821e-23,  8.386998966613728e-26,  5.213087769565120e-28,  1.064086245472209e+00, -3.033126823423605e-03,
 -5.240082275988098e-07,  1.866805293760513e-08,  6.130875288867973e-12, -2.072529765111248e-13, -8.473046713219077e-17,  2.802368427802217e-18,  1.285532031568663e-21,
 -4.201492236430973e-23, -2.072255574639108e-26,  6.715628477126715e-28,  1.140437578982936e+00, -3.003728012064634e-03, -1.579697342104452e-06,  1.790119613043449e-08,
  2.361660446350248e-11, -1.888362391001254e-13, -3.945246202142650e-16,  2.374452584164878e-18,  6.954193888981817e-21, -3.227579725246533e-23, -1.262504553182960e-25,
  4.531939122482311e-28,  1.216417731549441e+00, -2.938434452906617e-03, -2.594877242176362e-06,  1.604715941033428e-08,  3.925282094674598e-11, -1.431439646629189e-13,
 -6.401678899122156e-16,  1.319487440562612e-18,  1.068659943657500e-20, -8.963727283572862e-24, -1.781720851936880e-25, -4.414796766266607e-29,  1.291556154215355e+00,
 -2.837860998041387e-03, -3.524767152515215e-06,  1.320746942549388e-08,  5.118315053893211e-11, -7.630951368964054e-14, -7.645918071400446e-16, -1.018187642517189e-19,
  1.102881631673720e-20,  1.877931124056357e-23, -1.451121178651961e-25, -5.382085742105625e-28,  1.365370509201373e+00, -2.703561688795333e-03, -4.326769824788176e-06,
  9.574645809350773e-09,  5.792084560769109e-11,  1.291095142775967e-15, -7.359961028711338e-16, -1.495634073523470e-18,  7.716084430649160e-21,  3.895430050127119e-23,
 -4.034039409849107e-26, -7.220430405206960e-28,  1.437369891226757e+00, -2.538057715478642e-03, -4.963168572113708e-06,  5.420884889938672e-09,  5.859604794530673e-11,
  7.674544722825566e-14, -5.585841130227283e-16, -2.454846742712478e-18,  1.899526177658241e-21,  4.244658478241219e-23,  8.149760845908126e-26, -4.750842004351951e-28,
  1.507058578850998e+00, -2.344836731440598e-03, -5.403812965560910e-06,  1.076776852826162e-09,  5.313290949848068e-11,  1.370668782587977e-13, -2.741936148211120e-16,
 -2.697890650194985e-18, -4.233160560424828e-21,  2.790472730578036e-23,  1.543036891210007e-25,  3.775703003255838e-29,  1.573940314595730e+00, -2.128319003750486e-03,
 -5.628590556662187e-06, -3.098891665957635e-09,  4.231495824759108e-11,  1.719340480741227e-13,  4.701544105401495e-17, -2.174881086065212e-18, -8.347874174554198e-21,
  2.835241711988627e-24,  1.406455134657000e-25,  4.718446385981476e-28,  1.637523092696396e+00, -1.893786794536153e-03, -5.629461226132955e-06, -6.755796620024549e-09,
  2.771092377677569e-11,  1.760699306783582e-13,  3.252897883840734e-16, -1.094186133990024e-18, -8.991563314513883e-21, -2.017800372318637e-23,  5.565006920204896e-26,
  5.516390000690607e-28,  1.697324410141315e+00, -1.647274760115520e-03, -5.411828590391290e-06, -9.591395447959091e-09,  1.145609370273841e-11,  1.506093327127278e-13,
  4.943798523281729e-16,  1.504050673413930e-19, -6.254691551245862e-21, -3.032735508328287e-23, -4.348202116309450e-26,  2.724926575775865e-28,  1.752876910940543e+00,
 -1.395421030638617e-03, -4.995044703370453e-06, -1.138805744546293e-08, -4.086888491527249e-12,  1.029793096243666e-13,  5.216295702530891e-16,  1.130344649672832e-18,
 -1.697480643329187e-21, -2.452143032630552e-23, -9.681234294830993e-26, -1.129175537441016e-28,  1.803734326520968e+00, -1.145280937129482e-03, -4.411893459674866e-06,
 -1.204267851383355e-08, -1.673459328466939e-11,  4.516967537919108e-14,  4.177744431003522e-16,  1.550994976985040e-18,  2.464795996457086e-21, -8.642296903118585e-24,
 -8.186672962940400e-26, -3.146724565271484e-28,  1.849477588410174e+00, -9.041079665979355e-04, -3.706974760496365e-06, -1.158376732437868e-08, -2.488105754888764e-11,
 -9.274367876991403e-15,  2.321574481298869e-16,  1.363675417978938e-18,  4.501765138059678e-21,  6.769709143915370e-24, -2.458449037239888e-26, -2.387688835130091e-28,
  1.889720965050772e+00, -6.791092622162390e-04, -2.934011462903279e-06, -1.017221539874229e-08, -2.780357904515844e-11, -4.878012142106969e-14,  3.427065988328731e-17,
  7.672320775242287e-19,  3.999864766292152e-21,  1.349271883648088e-23,  2.641949661198266e-26, -2.791271891802878e-29,  1.924118055396547e+00, -4.771855954661061e-04,
 -2.152215426754132e-06, -8.084052708272157e-09, -2.580254358489654e-11, -6.679455928140462e-14, -1.119380563450107e-16,  9.633235362136771e-20,  1.908851768399080e-21,
  1.040802829960107e-23,  3.959411274072382e-26,  1.091506574646876e-28,  1.952367462431879e+00, -3.046679210791750e-04, -1.421964214234052e-06, -5.676196151503299e-09,
 -2.013216671052194e-11, -6.340442595978431e-14, -1.711016752863373e-16, -3.486711275611752e-19, -2.015594195768066e-22,  2.856501534598144e-24,  2.048197097699779e-26,
  9.489407896768874e-29,  1.974217985042466e+00, -1.670640068820715e-04, -8.001395640210356e-07, -3.339085473635458e-09, -1.272420716782793e-11, -4.496379016353120e-14,
 -1.474167960500737e-16, -4.428021482769778e-19, -1.176821572068688e-21, -2.503445486183905e-24, -2.496518019366068e-27,  1.333529367879145e-29,  1.989473316096278e+00,
 -6.882824449317084e-05, -3.355425453469955e-07, -1.442601680665210e-09, -5.756374625758426e-12, -2.177724651532768e-14, -7.887897220193688e-17, -2.746354728262083e-19,
 -9.192992329978391e-22, -2.948533237275903e-24, -8.990484660666625e-27, -2.565519820146772e-29,  1.997998302835121e+00, -1.315367570806986e-05, -6.475639950671108e-08,
 -2.829654449883260e-10, -1.157084017064645e-12, -4.532269172119311e-15, -1.721525195820996e-17, -6.386503992161384e-20, -2.324318217485315e-22, -8.322539041537617e-25,
 -2.937353754274348e-27, -1.023080420736273e-29,  6.091992168414423e-04, -3.383593442433624e-06,  1.409078329917614e-08, -5.214191544760165e-11,  1.808034725224225e-13,
 -6.015372027566098e-16,  1.944456793083379e-18, -6.152633375010266e-21,  1.914759372265214e-23, -5.879887678777718e-26,  1.785666139914395e-28, -5.371940995575935e-31,
  5.479820697157127e-03, -3.037401405445809e-05,  1.259596701745110e-07, -4.627842371745371e-10,  1.587346202129034e-12, -5.200130214619328e-15,  1.646091492126447e-17,
 -5.067522387583898e-20,  1.522621531142474e-22, -4.473504320358584e-25,  1.285842118041793e-27, -3.613941319279716e-30,  1.520519529511754e-02, -8.393772229315147e-05,
  3.451501566600805e-07, -1.249851266625534e-09,  4.192164846138103e-12, -1.329532089196412e-14,  4.022244336602822e-17, -1.163812697558972e-19,  3.213881419084271e-22,
 -8.409496077203920e-25,  2.052638470994353e-27, -4.518944965541823e-30,  2.975350801852010e-02, -1.632434009988185e-04,  6.626894850898681e-07, -2.346869367423095e-09,
  7.599765390967207e-12, -2.285957538507602e-14,  6.393498016540646e-17, -1.643784977862738e-19,  3.762755331392954e-22, -7.014157988211681e-25,  6.959768356897709e-28,
  2.146889945824039e-30,  4.907684145748498e-02, -2.670515276401732e-04,  1.065422485992902e-06, -3.658964593279871e-09,  1.126797675560681e-11, -3.127117914709656e-14,
  7.654871780884117e-17, -1.537573643060576e-19,  1.858610906167083e-22,  3.128111060591815e-25, -3.338330576540261e-27,  1.553140237424952e-29,  7.311094401061027e-02,
 -3.937235446240444e-04,  1.536374608497145e-06, -5.068476602416002e-09,  1.456500452274277e-11, -3.575916972709684e-14,  6.811467946087448e-17, -5.723123340270843e-20,
 -2.876451453448104e-22,  2.044548754951519e-24, -8.354237469931103e-27,  2.605211243739940e-29,  1.017749245404342e-01, -5.412344611098755e-04,  2.055232718169548e-06,
 -6.442124677690191e-09,  1.683861052708694e-11, -3.390429209095124e-14,  3.266645896142932e-17,  1.255861669109666e-19, -9.425737449186730e-22,  3.752854421469853e-24,
 -1.073548735095928e-26,  2.003823304838538e-29,  1.349708768880191e-01, -7.071892016291418e-04,  2.598940163714390e-06, -7.639447557228140e-09,  1.749184071232202e-11,
 -2.412742689842144e-14, -2.948692800713103e-17,  3.615317134404367e-19, -1.542623056059541e-21,  4.335411730279074e-24, -6.770693559263942e-27, -9.948554160983886e-30,
  1.725834388739289e-01, -8.888430871105704e-04,  3.142400841192325e-06, -8.522164976840026e-09,  1.605876998729388e-11, -6.092712627837166e-15, -1.106186604789029e-16,
  5.868566347369701e-19, -1.780645436616182e-21,  2.819068518519393e-24,  4.755083302522847e-27, -5.525696121257509e-29,  2.144792918415276e-01, -1.083126896719287e-03,
  3.659284618870693e-06, -8.964034811455349e-09,  1.227311281497964e-11,  1.904360851905633e-14, -1.959951167711891e-16,  7.205807336105382e-19, -1.389068046090200e-21,
 -1.057281279730778e-24,  2.058998365814286e-26, -8.957662962693370e-29,  2.605066085078065e-01, -1.286677010884641e-03,  4.122923423612638e-06, -8.860708127857473e-09,
  6.122360428894427e-12,  4.859491160160434e-14, -2.659886137236490e-16,  6.862579899002770e-19, -2.648593921242516e-22, -6.431001412539062e-24,  3.310049639257393e-26,
 -8.022473826077566e-29,  3.104944589261918e-01, -1.495871172630702e-03,  4.507283446568305e-06, -8.139019503511424e-09, -2.119545574133956e-12,  7.855104977055408e-14,
 -2.997165833919100e-16,  4.374359097439196e-19,  1.435734253357419e-21, -1.132919036822146e-23,  3.309538912087185e-26, -9.337837403422309e-30,  3.642521867825215e-01,
 -1.706870420236012e-03,  4.787994250485005e-06, -6.765097566593828e-09, -1.188700684190289e-11,  1.040349324784336e-13, -2.796832948561780e-16, -1.993969935655146e-20,
  3.277208808199734e-21, -1.323383826240245e-23,  1.470023545956896e-26,  1.061553323139735e-28,  4.215687710826140e-01, -1.915667732383077e-03,  4.943410053020737e-06,
 -4.750648712426055e-09, -2.234932546735043e-11,  1.199770888692727e-13, -1.965863223952766e-16, -6.155562381395935e-19,  4.627748645407940e-21, -1.010286959915443e-23,
 -1.983887688945796e-26,  2.104722327176450e-28,  4.822121915821869e-01, -2.118143878931414e-03,  4.955672194601461e-06, -2.156765061954505e-09, -3.247085043015568e-11,
  1.219372554228290e-13, -5.324061539393140e-17, -1.219296460415094e-18,  4.842159213773179e-21, -1.505282004918764e-24, -5.826093184985624e-26,  2.303258193327318e-28,
  5.459288200780625e-01, -2.310130876480310e-03,  4.811734953757091e-06,  9.053527832237053e-10, -4.110332843602590e-11,  1.069648082394881e-13,  1.334613901742684e-16,
 -1.665050408821889e-18,  3.502914195912506e-21,  1.063598546063553e-23, -8.148328155995451e-26,  1.173221280491843e-28,  6.124428639234162e-01, -2.487483296998738e-03,
  4.504309762244221e-06,  4.277274660216133e-09, -4.710524635327687e-11,  7.436098008432817e-14,  3.334382782303965e-16, -1.791397713128737e-18,  6.427662382070729e-22,
  2.217816935002840e-23, -7.189010018832605e-26, -1.094447398062305e-28,  6.814558928189979e-01, -2.646157458252815e-03,  4.032675982657269e-06,  7.760179769137818e-09,
 -4.947876004973291e-11,  2.619249329577307e-14,  5.075891617200518e-16, -1.490954488982105e-18, -3.143335776233242e-21,  2.799088001008326e-23, -2.372919969211188e-26,
 -3.501020375480709e-28,  7.526464849953713e-01, -2.782298224837201e-03,  3.403300431831294e-06,  1.112578131737592e-08, -4.751065762816950e-11, -3.258433092215918e-14,
  6.149966849294095e-16, -7.552023750295542e-19, -6.773297011698608e-21,  2.404254976893219e-23,  4.972587603623867e-26, -4.607963520308777e-28,  8.256700342127078e-01,
 -2.892332757823269e-03,  2.630203678175333e-06,  1.413115126325739e-08, -4.090028109949930e-11, -9.449216214016629e-14,  6.221036568134265e-16,  3.006168708928340e-19,
 -8.963819210714952e-21,  9.589583454644259e-24,  1.176144965445969e-25, -3.340360581870089e-28,  9.001587643704956e-01, -2.973070061837651e-03,  1.735009950089763e-06,
  1.653687370172639e-08, -2.985515483321300e-11, -1.504289807368493e-13,  5.120256135299487e-16,  1.445752080765773e-18, -8.671339907892457e-21, -1.158727338654748e-23,
  1.436119760358284e-25,  1.787998357661184e-29,  9.757220036623762e-01, -3.021804588520573e-03,  7.466205984157405e-07,  1.812751163419066e-08, -1.513505196537163e-11,
 -1.910323422919053e-13,  2.916418150275756e-16,  2.381104830495087e-18, -5.549425266214771e-21, -3.181364900437291e-23,  1.049629810889236e-25,  4.346404917987791e-28,
  1.051946774757075e+00, -3.036421470714945e-03, -2.995401001284284e-07,  1.873290272169195e-08,  1.971854295284948e-12, -2.083416653154171e-13, -5.916422299995943e-18,
  2.819202884952649e-18, -2.347748385882551e-22, -4.225002681030850e-23,  8.986602957560070e-27,  6.742080969780443e-28,  1.128398760954387e+00, -3.015500199930276e-03,
 -1.362742030077883e-06,  1.824835658660668e-08,  1.975070431147082e-11, -1.974829750187378e-13, -3.251058590630533e-16,  2.577462199036791e-18,  5.706461058470807e-21,
 -3.689535031700781e-23, -1.039767284288783e-25,  5.561433823859181e-28,  1.204623710065525e+00, -2.958412753362190e-03, -2.398640201540502e-06,  1.665147998465375e-08,
  3.623949222404230e-11, -1.580263508917071e-13, -5.984929730797435e-16,  1.654918720955187e-18,  1.023553316484991e-20, -1.608762603096620e-23, -1.769749823633705e-25,
  9.961477184845120e-29,  1.280149337209669e+00, -2.865411377382093e-03, -3.361417531777040e-06,  1.401319303998382e-08,  4.947343591431267e-11, -9.465346446441547e-14,
 -7.624084376004015e-16,  2.607550600984351e-19,  1.159489974716761e-20,  1.252534339440046e-23, -1.669376149331656e-25, -4.491799832880257e-28,  1.354487784038331e+00,
 -2.737700514266272e-03, -4.206315968282434e-06,  1.050061245539268e-08,  5.776678599905381e-11, -1.684615992314915e-14, -7.742088139833732e-16, -1.226655924879370e-18,
  9.081639437726884e-21,  3.669489568576936e-23, -7.283663255580347e-26, -7.503580422243169e-28,  1.427138684303518e+00, -2.577486811650498e-03, -4.892444503813917e-06,
  6.369949306666095e-09,  5.999137067880952e-11,  6.252290208060120e-14, -6.262348752718750e-16, -2.369026616178336e-18,  3.480906688627852e-21,  4.525146794579870e-23,
  5.784163394803609e-26, -5.992146814618158e-28,  1.497592873427464e+00, -2.388000891834669e-03, -5.385701648883011e-06,  1.948450609843976e-09,  5.580224676497182e-11,
  1.295654039893554e-13, -3.514714872985214e-16, -2.816086319355016e-18, -3.117416810169610e-21,  3.407406701722332e-23,  1.532351405105597e-25, -8.963337156379239e-29,
  1.565336762209929e+00, -2.173484703702032e-03, -5.661601403473889e-06, -2.394302824519587e-09,  4.575983482434980e-11,  1.723016068278473e-13, -1.759775899753214e-17,
 -2.439254121653824e-18, -8.139623632515176e-21,  8.866427988012718e-24,  1.606222015569976e-25,  4.317507892483614e-28,  1.629857371695334e+00, -1.939138954883681e-03,
 -5.707752986600923e-06, -6.283837482846257e-09,  3.130773950261158e-11,  1.834760709215882e-13,  2.905184966299367e-16, -1.393060426887835e-18, -9.671876845923154e-21,
 -1.744725971485155e-23,  8.134660528879761e-26,  6.146349514663350e-28,  1.690647997603596e+00, -1.691026426642682e-03, -5.525724057446872e-06, -9.383354772235249e-09,
  1.458715142993403e-11,  1.625013481079372e-13,  4.956227116534338e-16, -6.752415105618200e-20, -7.374634737883898e-21, -3.179822100654745e-23, -2.933277002790731e-26,
  3.724851783105530e-28,  1.747214439253005e+00, -1.435928965655898e-03, -5.132023535190182e-06, -1.143628012708837e-08, -1.899582862425233e-12,  1.158712343956838e-13,
  5.523806584257437e-16,  1.061144662385070e-18, -2.651024170263307e-21, -2.847874283844190e-23, -1.006617100924242e-25, -5.911379583907260e-29,  1.799081690902513e+00,
 -1.181158612913682e-03, -4.557980505409203e-06, -1.230264515854066e-08, -1.572737149641179e-11,  5.572599827725591e-14,  4.622550942609111e-16,  1.624231010766604e-18,
  2.091334914477554e-21, -1.220010514796014e-23, -9.616542557609622e-26, -3.340838078744031e-28,  1.845800955010944e+00, -9.343265652256792e-04, -3.848373654180251e-06,
 -1.198303213283889e-08, -2.500764924485519e-11, -3.227897921663221e-15,  2.723923117993672e-16,  1.511420029790652e-18,  4.725107049574191e-21,  5.561316598868904e-24,
 -3.621425822405461e-26, -2.908153605386078e-28,  1.886956799956212e+00, -7.030772566502092e-04, -3.058779220801052e-06, -1.062482522386817e-08, -2.876913975246548e-11,
 -4.768491604936017e-14,  5.761955791513372e-17,  9.032006284799216e-19,  4.504254442874710e-21,  1.451667003022553e-23,  2.455930724598978e-26, -5.797161999714349e-29,
  1.922174253136627e+00, -4.947984741729875e-04, -2.251745657858389e-06, -8.507725456531762e-09, -2.716504423993588e-11, -6.944144517903791e-14, -1.083270223258344e-16,
  1.637258180003881e-19,  2.313224557863201e-21,  1.208986203587953e-23,  4.454439147104035e-26,  1.155640915417156e-28,  1.951125600069567e+00, -3.163216659984941e-04,
 -1.492053834809340e-06, -6.008681974797563e-09, -2.144211376017762e-11, -6.762864762474322e-14, -1.809381299781161e-16, -3.533090934872034e-19, -8.292579912722288e-23,
  3.764408427539773e-24,  2.504489807827562e-26,  1.129568814714386e-28,  1.973536668033615e+00, -1.736289300964434e-04, -8.414604240876368e-07, -3.550063519357670e-09,
 -1.365988962565321e-11, -4.865491411071726e-14, -1.603561511680297e-16, -4.819204450386077e-19, -1.268585804145820e-21, -2.589802853945758e-24, -1.774619409929184e-27,
  1.975772068909602e-29,  1.989192522544905e+00, -7.158342925342201e-05, -3.534210909371083e-07, -1.538293567916059e-09, -6.211490987929466e-12, -2.376604417024804e-14,
 -8.699707686436404e-17, -3.058230751167551e-19, -1.032200351825389e-21, -3.331692630898338e-24, -1.019198035157470e-26, -2.901874687989651e-29,  1.997944630070932e+00,
 -1.368563101031358e-05, -6.826613062553532e-08, -3.022270244963939e-10, -1.252010371075565e-12, -4.967762863189498e-15, -1.911227361235713e-17, -7.180582404246424e-20,
 -2.646210411943605e-22, -9.592714856780350e-25, -3.426979530326157e-27, -1.207905053601156e-29,  5.958864010623761e-04, -3.273321707586108e-06,  1.348204848890141e-08,
 -4.934282762000300e-11,  1.692257936314316e-13, -5.568701945579978e-16,  1.780452528085306e-18, -5.572444907876178e-21,  1.715390555689193e-23, -5.210715356982730e-26,
  1.565388074083147e-28, -4.658712789353218e-31,  5.360305423352740e-03, -2.938812634537599e-05,  1.205552807140564e-07, -4.381977264514660e-10,  1.487182069607080e-12,
 -4.821559085097129e-15,  1.510787004843053e-17, -4.605088496882917e-20,  1.370462615724863e-22, -3.989617295103772e-25,  1.136828739633295e-27, -3.169534936196969e-30,
  1.487487340332536e-02, -8.123539350537087e-05,  3.305457812958671e-07, -1.184852517758108e-09,  3.935653751416032e-12, -1.236795163460206e-14,  3.710330923964416e-17,
 -1.065657718593360e-19,  2.925449815429946e-22, -7.627063067760265e-25,  1.862319582916538e-27, -4.135505682527906e-30,  2.911096195738662e-02, -1.580525019241178e-04,
  6.352418086823919e-07, -2.228848822716296e-09,  7.157552401614060e-12, -2.137902955953162e-14,  5.949719690849483e-17, -1.527361531283187e-19,  3.515462262535691e-22,
 -6.719271629371486e-25,  7.728612552249728e-28,  1.378270800179150e-30,  4.802540829043484e-02, -2.587007600539191e-04,  1.022576317035473e-06, -3.483581985879935e-09,
  1.066057965751245e-11, -2.948499080419367e-14,  7.232829408610054e-17, -1.476541110172873e-19,  1.948764845914587e-22,  1.921929211184578e-25, -2.710507433284831e-27,
  1.306895866778246e-29,  7.156025214365216e-02, -3.816719267314015e-04,  1.476927814834832e-06, -4.841069738372047e-09,  1.386603375570033e-11, -3.414462148071113e-14,
  6.639395791297489e-17, -6.532052223641207e-20, -2.197880315953073e-22,  1.732446376816857e-24, -7.271739105715917e-27,  2.318859471805533e-29,  9.964238721644775e-02,
 -5.250972924990664e-04,  1.979521492920773e-06, -6.178087863098672e-09,  1.616863236911125e-11, -3.308138655588654e-14,  3.578032815183060e-17,  9.750429746432370e-20,
 -8.149881479788232e-22,  3.341051023608910e-24, -9.855978998976724e-27,  1.986259586899592e-29,  1.321831291943288e-01, -6.867596529283157e-04,  2.508929970248067e-06,
 -7.363473601835447e-09,  1.700300704211901e-11, -2.471907431477749e-14, -2.003204902567848e-17,  3.146119488885136e-19, -1.391513214679682e-21,  4.057503168678526e-24,
 -7.085680502810238e-27, -4.582962081506583e-30,  1.690777034076181e-01, -8.641085864852972e-04,  3.041672029934565e-06, -8.266338265550650e-09,  1.591166537270713e-11,
 -8.556720492216034e-15, -9.496891194203436e-17,  5.315319096878761e-19, -1.676292188369659e-21,  2.963817888639018e-24,  2.558336672200199e-27, -4.482781463414068e-29,
  2.102046562908949e-01, -1.054279527833082e-03,  3.552906179387050e-06, -8.764866837519620e-09,  1.260855434638570e-11,  1.457678829891101e-14, -1.764457912436224e-16,
  6.756729817388058e-19, -1.413228745678011e-21, -3.095985669470698e-25,  1.686607256215516e-26, -7.970702232120288e-29,  2.554251962707994e-01, -1.254117200560675e-03,
  4.017213639588938e-06, -8.755315510997098e-09,  7.031972002008482e-12,  4.244060486931803e-14, -2.469250697757108e-16,  6.743268560716803e-19, -4.733947724912509e-22,
 -5.177652428766309e-24,  2.956950794786003e-26, -7.988436242439167e-29,  3.045824715456696e-01, -1.460204037631286e-03,  4.409462325434129e-06, -8.160750642102781e-09,
 -6.194391890881937e-13,  7.150965410474885e-14, -2.868846671314425e-16,  4.771081824005262e-19,  1.051567404437241e-21, -1.001854429412251e-23,  3.232221119214564e-26,
 -2.509493268884542e-29,  3.575007945030606e-01, -1.668894268417665e-03,  4.705739408684600e-06, -6.939008776104113e-09, -9.873418014418711e-12,  9.732724811325219e-14,
 -2.788441790399209e-16,  7.743037941024917e-20,  2.812419493983743e-21, -1.256125581948925e-23,  1.871640186539488e-26,  7.698544579530403e-29,  4.139848253207890e-01,
 -1.876354381441825e-03,  4.884335072428186e-06, -5.089303497635640e-09, -1.999827545012501e-11,  1.150685830769056e-13, -2.118043317987152e-16, -4.734230615153449e-19,
  4.251919309564027e-21, -1.071933842607718e-23, -1.118743816537295e-26,  1.826385197438536e-28,  4.738187306823489e-01, -2.078610673331672e-03,  4.926754034957201e-06,
 -2.656869427217852e-09, -3.004755821295908e-11,  1.202672406281787e-13, -8.522286765122314e-17, -1.065644410714367e-18,  4.748455187026624e-21, -3.634055030618306e-24,
 -4.821582470076058e-26,  2.251206190945609e-28,  5.367653375702217e-01, -2.271604556382556e-03,  4.818724385387007e-06,  2.649723121362752e-10, -3.893571098919551e-11,
  1.096214227710314e-13,  8.846242295579596e-17, -1.547449159325242e-18,  3.828479437517033e-21,  7.490034033187475e-24, -7.558222185352673e-26,  1.491947115925831e-28,
  6.025653068285516e-01, -2.451256206574989e-03,  4.551165394730091e-06,  3.535906275852964e-09, -4.554204938518512e-11,  8.176463105319214e-14,  2.836831240048463e-16,
 -1.758617841445711e-18,  1.388431389867882e-21,  1.922510408822581e-23, -7.530866065240905e-26, -4.706694149654104e-29,  6.709363566333476e-01, -2.613536975943744e-03,
  4.121067570775245e-06,  6.973357917010740e-09, -4.883652508756359e-11,  3.786322997914384e-14,  4.645842328521905e-16, -1.575630751520084e-18, -2.156300573544863e-21,
  2.675136971024740e-23, -3.779960068222229e-26, -2.888210316957110e-28,  7.415725721594381e-01, -2.754550751133570e-03,  3.532229855912622e-06,  1.036119163825370e-08,
 -4.801658098000890e-11, -1.810183822593196e-14,  5.909492078881124e-16, -9.577549302709886e-19, -5.876814867928467e-21,  2.563004566231605e-23,  2.977547744141761e-26,
 -4.434627350979597e-28,  8.141438445193449e-01, -2.870624096359458e-03,  2.795791335713091e-06,  1.346244152601195e-08, -4.264030371195424e-11, -7.949272955905384e-14,
  6.265633388770320e-16,  2.017645416790814e-20, -8.537610146200016e-21,  1.398331700002243e-23,  1.016880905261831e-25, -3.867611125533034e-28,  8.882954893244535e-01,
 -2.958404557149510e-03,  1.930489255554311e-06,  1.603580346376730e-08, -3.273773287621937e-11, -1.376862946766499e-13,  5.485671050255177e-16,  1.162703231401235e-18,
 -8.985183930857086e-21, -5.859067149181194e-24,  1.420203364485955e-25, -8.886688243074692e-29,  9.636481027373117e-01, -3.014965907696284e-03,  9.625729846256917e-07,
  1.785518822273833e-08, -1.888041251979310e-11, -1.832539826138050e-13,  3.556604177194112e-16,  2.186044568212383e-18, -6.614796045194648e-21, -2.726156785526559e-23,
  1.219029584045560e-25,  3.333833995328350e-28,  1.039797720272994e+00, -3.037918392437295e-03, -7.469342668872498e-08,  1.873113681452652e-08, -2.190015337901406e-12,
 -2.075386577198336e-13,  7.268825154603762e-17,  2.787481189368951e-18, -1.742202103250087e-21, -4.130269726955970e-23,  3.819586790612307e-26,  6.489692277911200e-28,
  1.116316350342480e+00, -3.025521145668315e-03, -1.141997327531591e-06,  1.853237153423707e-08,  1.572896642291881e-11, -2.044001085451056e-13, -2.505855384625635e-16,
  2.738063965930567e-18,  4.309499654607715e-21, -4.053930067887924e-23, -7.762672122371174e-26,  6.376371003210478e-28,  1.192752959914322e+00, -2.976792991982954e-03,
 -2.195450231262264e-06,  1.720526362263703e-08,  3.293926908203455e-11, -1.717977015927814e-13, -5.476664746159848e-16,  1.971834220195235e-18,  9.530406133467987e-21,
 -2.303577799255380e-23, -1.693641499044828e-25,  2.461961892348845e-28,  1.268634992822299e+00, -2.891616777912807e-03, -3.188575448539914e-06,  1.478863252127793e-08,
  4.739819827520175e-11, -1.128213564647330e-13, -7.498543965489787e-16,  6.376809303058081e-19,  1.192114470431783e-20,  5.484863642955381e-24, -1.842407209816886e-25,
 -3.331342406354474e-28,  1.343470501112676e+00, -2.770831332269664e-03, -4.074777426537216e-06,  1.142116500596909e-08,  5.724144544860359e-11, -3.580528972784661e-14,
 -8.042923963685719e-16, -9.155342249790832e-19,  1.034223720622151e-20,  3.311944932079281e-23, -1.059188008441648e-25, -7.479840124468465e-28,  1.416750965216166e+00,
 -2.616304202843099e-03, -4.810207381685113e-06,  7.338975984326557e-09,  6.108623089060677e-11,  4.671137898353160e-14, -6.907603987741350e-16, -2.231179881357510e-18,
  5.144934275212386e-21,  4.700316361883992e-23,  2.890820272737652e-26, -7.137288258947866e-28,  1.487954868399787e+00, -2.430977607357464e-03, -5.356879271032111e-06,
  2.861531706882931e-09,  5.830276150879311e-11,  1.201737862091634e-13, -4.315257208520740e-16, -2.895044204854567e-18, -1.781748946801408e-21,  4.008290845710222e-23,
  1.461452883804234e-25, -2.353228969676163e-28,  1.556552073722389e+00, -2.218879733158399e-03, -5.685826513212887e-06, -1.634623904726341e-09,  4.919596057302959e-11,
  1.710305785151014e-13, -8.948638986547390e-17, -2.693338891507794e-18, -7.700366277713372e-21,  1.565323049278541e-23,  1.782183638017148e-25,  3.631196699107837e-28,
  1.622009026649240e+00, -1.985093805994042e-03, -5.780031209812626e-06, -5.753192541687896e-09,  3.504364277440830e-11,  1.899449164450246e-13,  2.470901677421833e-16,
 -1.711928250210560e-18, -1.023474573937769e-20, -1.363677851585881e-23,  1.095381306554275e-25,  6.640543297716333e-28,  1.683794773109546e+00, -1.735678401230358e-03,
 -5.636814606717412e-06, -9.123314977856202e-09,  1.795583236560431e-11,  1.743458733900239e-13,  4.902546875392061e-16, -3.220207436503586e-19, -8.536252822968505e-21,
 -3.261202777972284e-23, -1.055687850037570e-26,  4.823679879965849e-28,  1.741387741365250e+00, -1.477534431216602e-03, -5.269362421239139e-06, -1.144740383377870e-08,
  5.527661957907531e-13,  1.294743534960903e-13,  5.807453590064606e-16,  9.591271054515934e-19, -3.749182799387912e-21, -3.253724887954604e-23, -1.017331357182815e-25,
  1.375348891558537e-29,  1.794283187839132e+00, -1.218217173072569e-03, -4.707083300685828e-06, -1.254474856884637e-08, -1.449818929053554e-11,  6.737299134288280e-14,
  5.085989929336643e-16,  1.683355072493735e-18,  1.579312905544385e-21, -1.634458173214578e-23, -1.111355892012125e-25, -3.446207181585685e-28,  1.842001154454722e+00,
 -9.656955446080970e-04, -3.994571713869317e-06, -1.238330108646825e-08, -2.500331609846713e-11,  3.834615036997446e-15,  3.168568754131776e-16,  1.665521186824903e-18,
  4.896006224045427e-21,  3.840263671875108e-24, -5.025766775451340e-26, -3.483669830284394e-28,  1.884094731833119e+00, -7.280653791823948e-04, -3.189070165350201e-06,
 -1.109267701282364e-08, -2.970687467165004e-11, -4.598179433815733e-14,  8.500696548557872e-17,  1.055882350519798e-18,  5.043825821007825e-21,  1.543727327812043e-23,
  2.118773544319712e-26, -9.686975025268912e-29,  1.920158374150591e+00, -5.132283056101768e-04, -2.356492491878372e-06, -8.953616339604621e-09, -2.857945531704823e-11,
 -7.197750252030362e-14, -1.026384347193519e-16,  2.450666811414144e-19,  2.781770185494569e-21,  1.397474499045788e-23,  4.972972939575361e-26,  1.196600444030889e-28,
  1.949835975513135e+00, -3.285524500118691e-04, -1.566261869817604e-06, -6.362815689125791e-09, -2.283891416127037e-11, -7.209004208028257e-14, -1.908461258769265e-16,
 -3.535910004146858e-19,  7.187670411999354e-23,  4.871543136715313e-24,  3.046403921165428e-26,  1.338583309220052e-28,  1.972828413796975e+00, -1.805348073651751e-04,
 -8.854053380484893e-07, -3.776620315566429e-09, -1.467259045425599e-11, -5.267006080699504e-14, -1.744323532504113e-16, -5.240187821441973e-19, -1.362866260371962e-21,
 -2.641102585756781e-24, -7.297477914052753e-28,  2.808852951368039e-29,  1.988900414746339e+00, -7.448636247388612e-05, -3.724929780716221e-07, -1.641596415012319e-09,
 -6.708404547012432e-12, -2.596057670620643e-14, -9.604115558980237e-17, -3.408537845727067e-19, -1.159796947050622e-21, -3.765981243545172e-24, -1.154968826071201e-26,
 -3.275873473840076e-29,  1.997888771828612e+00, -1.424661521569855e-05, -7.201640927901457e-08, -3.230796561212796e-10, -1.356120513789876e-12, -5.451573937943121e-15,
 -2.124677331094563e-17, -8.085377027431959e-20, -3.017559386463886e-22, -1.107602063433059e-24, -4.005636395018138e-27, -1.428900330609237e-29,  5.830051408383770e-04,
 -3.167788577602410e-06,  1.290582007764146e-08, -4.672204439842498e-11,  1.585033734131264e-13, -5.159513379086458e-16,  1.631835405694020e-18, -5.052364132975483e-21,
  1.538598738292185e-23, -4.623686608161116e-26,  1.374214258894419e-28, -4.046310221043074e-31,  5.244649061009581e-03, -2.844432027992713e-05,  1.154365578851902e-07,
 -4.151549917844981e-10,  1.394274839235712e-12, -4.473960705913668e-15,  1.387774383985939e-17, -4.188669589136018e-20,  1.234696260906698e-22, -3.561599464604742e-25,
  1.006079072481229e-27, -2.782411900485303e-30,  1.455513199990884e-02, -7.864684816794373e-05,  3.166973649923321e-07, -1.123813543076017e-09,  3.696963183034934e-12,
 -1.151224533488228e-14,  3.424650048533384e-17, -9.762962360500447e-20,  2.663855568392688e-22, -6.917449053596090e-25,  1.688377365078732e-27, -3.774855942408721e-30,
  2.848874913240135e-02, -1.530756373430875e-04,  6.091688850784634e-07, -2.117672476137339e-09,  6.743911207721216e-12, -2.000116712497062e-14,  5.537448402908491e-17,
 -1.418676303017456e-19,  3.279261908877293e-22, -6.399879507861982e-25,  8.197188149518191e-28,  7.763251223715386e-31,  4.700670575439891e-02, -2.506845059866384e-04,
  9.817775904627232e-07, -3.317637386707426e-09,  1.008790741882939e-11, -2.779801318195164e-14,  6.828218092661886e-17, -1.413271997609804e-19,  1.999765397652191e-22,
  9.462927166119297e-26, -2.183007149955576e-27,  1.096311917993682e-29,  7.005683261729967e-02, -3.700851553394610e-04,  1.420143860480850e-06, -4.624590395427836e-09,
  1.319892385903432e-11, -3.257385327022529e-14,  6.447550533911816e-17, -7.141004005091320e-20, -1.624169740044795e-22,  1.461189579561973e-24, -6.310318200608603e-27,
  2.055010993394953e-29,  9.757320699850756e-02, -5.095533208813032e-04,  1.906914947103704e-06, -5.924635232875966e-09,  1.551579828783621e-11, -3.219273577486410e-14,
  3.816288294729202e-17,  7.327473527768563e-20, -7.015972607063867e-22,  2.964146756584742e-24, -8.993419967255354e-27,  1.928980021138722e-29,  1.294756803175673e-01,
 -6.670370728095003e-04,  2.422184184467160e-06, -7.095403756555139e-09,  1.650450596494969e-11, -2.509903258354919e-14, -1.182474505562087e-17,  2.723656318178732e-19,
 -1.250581334351915e-21,  3.771350934037353e-24, -7.191555133643179e-27, -4.092139281588572e-31,  1.656693136643961e-01, -8.401676802956938e-04,  2.943997455605983e-06,
 -8.013239581927565e-09,  1.571891303245308e-11, -1.066334192758848e-14, -8.082083789917423e-17,  4.796137782797006e-19, -1.568202770452092e-21,  3.029465272361806e-24,
  7.899822542566591e-28, -3.577145634732261e-29,  2.060437234176053e-01, -1.026273541785974e-03,  3.448947091281407e-06, -8.561021426781139e-09,  1.285924911108334e-11,
  1.056399938578663e-14, -1.581608603591108e-16,  6.303948510424500e-19, -1.413049831486544e-21,  2.977644091473860e-25,  1.357229226029358e-26, -7.006998198926077e-29,
  2.504723402655430e-01, -1.222397771442597e-03,  3.912851908018683e-06, -8.636329065809256e-09,  7.823041907476487e-12,  3.673910098516671e-14, -2.282824322800740e-16,
  6.564173289022258e-19, -6.393422967628216e-22, -4.064593879997200e-24,  2.610093640020063e-26, -7.748826373981481e-29,  2.988115864777096e-01, -1.425320117259093e-03,
  4.311519848703702e-06, -8.159589615777472e-09,  7.430019240724914e-13,  6.478820851721057e-14, -2.731069908120421e-16,  5.052347973623341e-19,  7.138713090631783e-22,
 -8.751461281211051e-24,  3.094671476493989e-26, -3.680501197072504e-29,  3.508999782959427e-01, -1.631583965559707e-03,  4.621586515830902e-06, -7.081773802643321e-09,
 -7.993569238307083e-12,  9.067076161625024e-14, -2.754830797940891e-16,  1.603431653721955e-19,  2.374435136988202e-21, -1.175263182684587e-23,  2.152897228020968e-26,
  5.147258677345133e-29,  4.065571629180881e-01, -1.837529253872637e-03,  4.821418634957863e-06, -5.391145359362414e-09, -1.774873261497137e-11,  1.098412246294433e-13,
 -2.232138578828845e-16, -3.436071268271219e-19,  3.859829446645797e-21, -1.101439498166225e-23, -3.769869451960659e-27,  1.545798670205243e-28,  4.655829028332888e-01,
 -2.039332161685275e-03,  4.892066025660034e-06, -3.118508568438377e-09, -2.766499559092325e-11,  1.178808719820318e-13, -1.129558131338337e-16, -9.161400805562048e-19,
  4.585274849848071e-21, -5.367531780107819e-24, -3.854085156097285e-26,  2.137722748796916e-28,  5.277560243419779e-01, -2.233052465839967e-03,  4.818238909035861e-06,
 -3.403587607098756e-10, -3.672548863799870e-11,  1.112386503994608e-13,  4.688545785427237e-17, -1.421193771705209e-18,  4.045349715572709e-21,  4.605168273280540e-24,
 -6.850199349005537e-26,  1.710503670670587e-28,  5.928333520560802e-01, -2.414689420750462e-03,  4.589279350723092e-06,  2.820669105721310e-09, -4.384263277484848e-11,
  8.798776963905313e-14,  2.351637245130650e-16, -1.703698797623810e-18,  2.025967253698876e-21,  1.618807955816974e-23, -7.614265688374175e-26,  7.825020883259328e-30,
  6.605486571134256e-01, -2.580246936319283e-03,  4.200086470208208e-06,  6.198622321249894e-09, -4.797137036338859e-11,  4.847692128186055e-14,  4.196431085799740e-16,
 -1.629539136421837e-18, -1.223359976592239e-21,  2.500387324508664e-23, -4.911187420426017e-26, -2.252501216945877e-28,  7.306116538147693e-01, -2.725808658152714e-03,
  3.651945086944310e-06,  9.590791157067147e-09, -4.823906830398675e-11, -4.261253615936489e-15,  5.616393867145581e-16, -1.130857917865269e-18, -4.937323018115231e-21,
  2.643916892763339e-23,  1.091072824705099e-26, -4.119267392184700e-28,  8.027070874143396e-01, -2.847623282165100e-03,  2.953197345472237e-06,  1.276829451136803e-08,
 -4.407989481911311e-11, -6.447880976528623e-14,  6.233845085962617e-16, -2.442216359648717e-19, -7.965201703156529e-21,  1.769921020223224e-23,  8.386179287388733e-26,
 -4.203753098494341e-28,  8.764939648037133e-01, -2.942200033785292e-03,  2.119687547788778e-06,  1.549069574438628e-08, -3.535733425372403e-11, -1.241626622147840e-13,
  5.770734876258802e-16,  8.728895042179504e-19, -9.095065962443746e-21, -2.857139109551166e-25,  1.359449015851885e-25, -1.852516068648894e-28,  9.516049896551856e-01,
 -3.006413685688156e-03,  1.174903334180524e-06,  1.752426513592256e-08, -2.245530306345473e-11, -1.740084132233949e-13,  4.137655637598903e-16,  1.959636307750156e-18,
 -7.505197905557371e-21, -2.212410667532014e-23,  1.341649360206345e-25,  2.229248224229558e-28,  1.027646273918878e+00, -3.037617755679599e-03,  1.497333773311824e-07,
  1.866301157536458e-08, -6.317059650175932e-12, -2.048652077872937e-13,  1.497361102003098e-16,  2.708290330040704e-18, -3.194834779036429e-21, -3.921711946894386e-23,
  6.570716532892055e-26,  5.974128799307442e-28,  1.104197407890593e+00, -3.033763604856693e-03, -9.182347790297713e-07,  1.875103054535298e-08,  1.158710839183405e-11,
 -2.094799573696820e-13, -1.722124393579056e-16,  2.852074053758268e-18,  2.801125767747143e-21, -4.306488949690143e-23, -4.824768266161430e-26,  6.932001751222429e-28,
  1.180811980641394e+00, -2.993522047374633e-03, -1.985940545023429e-06,  1.770410952021600e-08,  2.937652190045667e-11, -1.842455111732425e-13, -4.883193506855564e-16,
  2.262254852275478e-18,  8.582173428186131e-21, -2.955130901658997e-23, -1.553773627550537e-25,  3.881866844108209e-28,  1.257018650406395e+00, -2.916402812638106e-03,
 -3.006639242272013e-06,  1.552798131461010e-08,  4.496347572029742e-11, -1.305603634006118e-13, -7.266392688417985e-16,  1.020868164483759e-18,  1.198277040115311e-20,
 -2.138468577141717e-24, -1.959115864811752e-25, -1.939608626770268e-28,  1.332322869253641e+00, -2.802865827367010e-03, -3.932255318689835e-06,  1.233024246025348e-08,
  5.633043088645120e-11, -5.537745834584778e-14, -8.251209904586190e-16, -5.663874579845532e-19,  1.145041425902073e-20,  2.823265878347937e-23, -1.381549377264163e-25,
 -7.114634507909664e-28,  1.406209366392085e+00, -2.654416910549381e-03, -4.716247537157371e-06,  8.322907861619405e-09,  6.184971846597011e-11,  2.940362699229296e-14,
 -7.506728974784994e-16, -2.039308248203029e-18,  6.850016809801289e-21,  4.750128486163827e-23, -4.710709566892345e-27, -8.108892372870231e-28,  1.478145488002747e+00,
 -2.473679250781633e-03, -5.316866409057289e-06,  3.813013328009841e-09,  6.059607760547667e-11,  1.088393643548553e-13, -5.131603403400878e-16, -2.927867170072961e-18,
 -2.364532823484612e-22,  4.567553102957302e-23,  1.323245475425451e-25, -3.946649579912847e-28,  1.547585476567008e+00, -2.264431166831211e-03, -5.700606756912815e-06,
 -8.202664676319566e-10,  5.258884540381521e-11,  1.679506693901996e-13, -1.682549451694043e-16, -2.929328828446304e-18, -7.004924343302586e-21,  2.307447170212507e-23,
  1.921174092202459e-25,  2.633820360475997e-28,  1.613975747523217e+00, -2.031600386317724e-03, -5.845578969398394e-06, -5.161797833977129e-09,  3.889776701315666e-11,
  1.952624417851425e-13,  1.945035716305948e-16, -2.046391462233169e-18, -1.063966354069951e-20, -8.660530419978169e-24,  1.394899223111793e-25,  6.935541200572707e-28,
  1.676761184348618e+00, -1.781205684074989e-03, -5.744453497175962e-06, -8.807490663036458e-09,  2.155951647929997e-11,  1.859718331758571e-13,  4.772370384960879e-16,
 -6.140033219829552e-19, -9.712463297392241e-21, -3.257586900174684e-23,  1.321385404804450e-26,  5.988648188163820e-28,  1.735392424316933e+00, -1.520238453852747e-03,
 -5.406590271217127e-06, -1.141707751329144e-08,  3.283732692506895e-12,  1.437198414337994e-13,  6.057396074259203e-16,  8.196291361458377e-19, -4.993390932233369e-21,
 -3.656836918113438e-23, -9.913736513858682e-26,  1.079002068692000e-28,  1.789334046986375e+00, -1.256479824121096e-03, -4.858965451168493e-06, -1.276526058477900e-08,
 -1.302482076308811e-11,  8.015011017724814e-14,  5.563457213326755e-16,  1.723590934869354e-18,  9.072302416168741e-22, -2.109370270166486e-23, -1.263053170887529e-25,
 -3.424703864247217e-28,  1.838073508407875e+00, -9.982533090801364e-04, -4.145567731909448e-06, -1.278231124850223e-08, -2.484670875990383e-11,  1.201661223310996e-14,
  3.657027178492989e-16,  1.823986335849966e-18,  4.994212844081624e-21,  1.505405283642472e-24, -6.693753045988013e-26, -4.104379726481849e-28,  1.881130590651673e+00,
 -7.541185383926099e-04, -3.325064110117425e-06, -1.157522285881808e-08, -3.060361768685495e-11, -4.356809309028778e-14,  1.169159657386063e-16,  1.226331073154605e-18,
  5.613672192512592e-21,  1.618582577064237e-23,  1.588060103050833e-26, -1.462269927091946e-28,  1.918067065453605e+00, -5.325179030043687e-04, -2.466727447536885e-06,
 -9.422535345503844e-09, -3.004302877140197e-11, -7.434794483033027e-14, -9.445190634003345e-17,  3.425270257431984e-19,  3.321940071095419e-21,  1.606970390172065e-23,
  5.502243730869466e-26,  1.202143839408588e-28,  1.948496213032509e+00, -3.413942835185378e-04, -1.644856588590056e-06, -6.740024945137280e-09, -2.432731795503297e-11,
 -7.678872502329390e-14, -2.006863628858876e-16, -3.482378298301623e-19,  2.706675888600570e-22,  6.214731097298384e-24,  3.687012891438771e-26,  1.578575616120866e-28,
  1.972091815317244e+00, -1.878034003507283e-04, -9.321688634079586e-07, -4.020041510800308e-09, -1.576906975235751e-11, -5.703752371221798e-14, -1.897297621961729e-16,
 -5.691548199087415e-19, -1.458146853575038e-21, -2.642609295010545e-24,  7.324964598052459e-28,  3.881906970912214e-29,  1.988596382018369e+00, -7.754696790257596e-05,
 -3.928536905982380e-07, -1.753213139720347e-09, -7.251461232576143e-12, -2.838441366825118e-14, -1.061256844506549e-16, -3.802285455158689e-19, -1.304046178569653e-21,
 -4.257983468111653e-24, -1.308050068539047e-26, -3.688841068362507e-29,  1.997830608019240e+00, -1.483863164850217e-05, -7.602724265844105e-08, -3.456783318062529e-10,
 -1.470440394180914e-12, -5.989792493810344e-15, -2.365208768948074e-17, -9.118013630425447e-20, -3.446719120536774e-22, -1.281146497480165e-24, -4.690859673320626e-27,
 -1.693684710809423e-29,  5.705369886222928e-04, -3.066742332850755e-06,  1.236003810464298e-08, -4.426646184139829e-11,  1.485648095325984e-13, -4.784307477281922e-16,
  1.497019265175691e-18, -4.585617928701911e-21,  1.381626035926784e-23, -4.108000654311682e-26,  1.208049995516035e-28, -3.519634736861583e-31,  5.132687739618108e-03,
 -2.754038269849065e-05,  1.105856531033208e-07, -3.935447223696548e-10,  1.308033542731526e-12, -4.154533892841253e-15,  1.275835722800955e-17, -3.813328230758750e-20,
  1.113436814698316e-22, -3.182626030923509e-25,  8.912455320918232e-28, -2.444901527306211e-30,  1.424552775217093e-02, -7.616622393710848e-05,  3.035590550178306e-07,
 -1.066460346358615e-09,  3.474720894708343e-12, -1.072219217872080e-14,  3.162855910691825e-17, -8.949101538832776e-20,  2.426592646396274e-22, -6.274308495352229e-25,
  1.529776835216157e-27, -3.438283396009900e-30,  2.788603489224452e-02, -1.483021301367268e-04,  5.843912603327793e-07, -2.012899204743297e-09,  6.356862024378601e-12,
 -1.871868231176996e-14,  5.154568315955016e-17, -1.317362391388549e-19,  3.054837066123020e-22, -6.066622764335360e-25,  8.431683389462930e-28,  3.095671475815499e-31,
  4.601942785022823e-02, -2.429868296278008e-04,  9.429163190248650e-07, -3.160590842542030e-09,  9.548018096921853e-12, -2.620600109570002e-14,  6.441500610462831e-17,
 -1.348893866227581e-19,  2.019226387988920e-22,  1.640689715322373e-26, -1.741187948376332e-27,  9.167073533319747e-30,  6.859886783263214e-02, -3.589424436567415e-04,
  1.365894644145930e-06, -4.418536043931632e-09,  1.256275612174323e-11, -3.105097530902776e-14,  6.241083207970324e-17, -7.581272880751924e-20, -1.141463019200015e-22,
  1.226135274101911e-24, -5.459942104369547e-27,  1.814112614282311e-29,  9.556505997582189e-02, -4.945782121048776e-04,  1.837287756738084e-06, -5.681482880424154e-09,
  1.488125614939490e-11, -3.125464709079099e-14,  3.991581647555765e-17,  5.246318877193046e-20, -6.011607878419817e-22,  2.621151256449137e-24, -8.162561859746350e-27,
  1.843909381726346e-29,  1.268457540099163e-01, -6.479957277266157e-04,  2.338607163544296e-06, -6.835360412646760e-09,  1.600028225397473e-11, -2.529571024913771e-14,
 -4.738752975690688e-18,  2.344638344770651e-19, -1.119985721213626e-21,  3.484330062330683e-24, -7.136363043638519e-27,  2.768645496516883e-30,  1.623551439101527e-01,
 -8.169960774771688e-04,  2.849340229314017e-06, -7.763544033295075e-09,  1.548730807846478e-11, -1.244746151226502e-14, -6.807778512268311e-17,  4.311794257176041e-19,
 -1.458930741900014e-21,  3.031963587451869e-24, -6.084511955405941e-28, -2.799645069717045e-29,  2.019931667237634e-01, -9.990893816216875e-04,  3.347455642419703e-06,
 -8.353783533269913e-09,  1.303397387596172e-11,  6.974855323552130e-15, -1.411405264520422e-16,  5.854476810783284e-19, -1.393276264795891e-21,  7.817348952912423e-25,
  1.069308244454796e-26, -6.089384014856830e-29,  2.456447015245666e-01, -1.191507318165933e-03,  3.809990271764708e-06, -8.505573613585871e-09,  8.504512401871799e-12,
  3.147843880661320e-14, -2.102097717340473e-16,  6.338120608110110e-19, -7.676872662221917e-22, -3.087692784937538e-24,  2.277248871127691e-26, -7.360054265214439e-29,
  2.931786706097047e-01, -1.391219320486127e-03,  4.213717721358773e-06, -8.137686750513600e-09,  1.974378425494006e-12,  5.840569833973443e-14, -2.586862808961176e-16,
  5.232734152564461e-19,  4.206854856110251e-22, -7.548632878319781e-24,  2.913497323973583e-26, -4.501489321384199e-29,  3.444470467123918e-01, -1.594953237332566e-03,
  4.535896531146337e-06, -7.195521142542962e-09, -6.245863550371903e-12,  8.412124406700041e-14, -2.699921208513485e-16,  2.297258022665910e-19,  1.967325741084226e-21,
 -1.085285969563089e-23,  2.330093000014806e-26,  2.968094264615657e-29,  3.992837722759173e-01, -1.799221342373138e-03,  4.755092556323712e-06, -5.657844580866504e-09,
 -1.560618817424772e-11,  1.043822300859797e-13, -2.311653965817506e-16, -2.264531625746496e-19,  3.462162106014762e-21, -1.103726867068059e-23,  2.427611915601608e-27,
  1.273280578964123e-28,  4.575035998479252e-01, -2.000352668590214e-03,  4.852065384394458e-06, -3.542443278497704e-09, -2.533648045746765e-11,  1.148785010212897e-13,
 -1.365845973260890e-16, -7.727823787284759e-19,  4.366521576870132e-21, -6.725447577469970e-24, -2.947091915488890e-26,  1.978713255402882e-28,  5.189008665546511e-01,
 -2.194532711707237e-03,  4.810702536220886e-06, -9.101205210282364e-10, -3.449261020572478e-11,  1.119011429141413e-13,  8.925588369480900e-18, -1.289603843577515e-18,
  4.163669170640260e-21,  2.019993997815086e-24, -6.066384347144439e-26,  1.838208323720468e-28,  5.832482205567107e-01, -2.377851583369966e-03,  4.618977508520201e-06,
  2.133555597241550e-09, -4.203026200717450e-11,  9.306709962605453e-14,  1.884512186868714e-16, -1.630129791460737e-18,  2.554129715146381e-21,  1.316356017419710e-23,
 -7.474511092216516e-26,  5.425338994673692e-29,  6.502953235274940e-01, -2.546361681736105e-03,  4.269898411292668e-06,  5.439368335169777e-09, -4.690483277001157e-11,
  5.799722478250120e-14,  3.736004585552729e-16, -1.654681835298669e-18, -3.607995364338962e-22,  2.285983806237252e-23, -5.763122781143134e-26, -1.623156430289229e-28,
  7.197675606772629e-01, -2.696145862281810e-03,  3.762403160044843e-06,  8.819005565701000e-09, -4.819215323772057e-11,  8.821151663648751e-15,  5.279069316770300e-16,
 -1.273573818361931e-18, -3.981918548536416e-21,  2.652496733983574e-23, -6.309465568738654e-27, -3.692306295714727e-28,  7.913647987843306e-01, -2.823396907736264e-03,
  3.102145279284531e-06,  1.205350964268482e-08, -4.522055890097460e-11, -4.962783120778972e-14,  6.130780849181785e-16, -4.883024789189186e-19, -7.272161654048215e-21,
  2.067804318864216e-23,  6.497155346499399e-26, -4.352662765901274e-28,  8.647602431423810e-01, -2.924508781001594e-03,  2.302102104116119e-06,  1.490587259266302e-08,
 -3.770028002122033e-11, -1.100524678023412e-13,  5.974456403800527e-16,  5.827148339660485e-19, -9.009668677881845e-21,  4.963691198523045e-24,  1.259249266513172e-25,
 -2.676489027044480e-28,  9.395994562429072e-01, -2.996179663027382e-03,  1.382925758689374e-06,  1.713769664950839e-08, -2.583186638127765e-11, -1.634474391569555e-13,
  4.651608017739039e-16,  1.707779426164541e-18, -8.203007851255696e-21, -1.659482844288322e-23,  1.414678785533561e-25,  1.089037676774046e-28,  1.015499614184529e+00,
 -3.035526092345005e-03,  3.729485698689598e-07,  1.852938100216578e-08, -1.037234990772214e-11, -2.003743932454058e-13,  2.239286188997892e-16,  2.584024037051588e-18,
 -4.553190489947609e-21, -3.608357777125475e-23,  9.042435606390112e-26,  5.225756571331626e-28,  1.092049090821003e+00, -3.040206601662314e-03, -6.922489596905773e-07,
  1.890271023693269e-08,  7.362692987815542e-12, -2.126460744992817e-13, -9.133483549916293e-17,  2.916592529522025e-18,  1.223497010808355e-21, -4.437477797857285e-23,
 -1.705275675741399e-26,  7.198126655561769e-28,  1.168807473821776e+00, -3.008552068144966e-03, -1.770794689215205e-06,  1.814403990238731e-08,  2.557970188575285e-11,
 -1.951750498290908e-13, -4.212996795749315e-16,  2.518699119764092e-18,  7.410931213775971e-21, -3.538543748669833e-23, -1.353820752433208e-25,  5.180944761686592e-28,
  1.245306130051186e+00, -2.939698557964214e-03, -2.816076183563304e-06,  1.622557022715541e-08,  4.218041379079702e-11, -1.476134900230798e-13, -6.927091190253457e-16,
  1.401558604753623e-18,  1.176308079189065e-20, -1.010055263787070e-23, -2.010508234753303e-25, -3.730735320583502e-29,  1.321049448468576e+00, -2.833716787589101e-03,
 -3.778924735149440e-06,  1.322158836788020e-08,  5.502378594191829e-11, -7.532836410232567e-14, -8.357052120575449e-16, -1.848389097053965e-19,  1.235993954872508e-20,
  2.209905881350612e-23, -1.679978330131390e-25, -6.390807290292012e-28,  1.395516895131381e+00, -2.691730529906553e-03, -4.610418886223318e-06,  9.316210111564463e-09,
  6.225313906713921e-11,  1.072861656998509e-14, -8.044483145147543e-16, -1.792854556578234e-18,  8.547857236382805e-21,  4.657600578028264e-23, -4.207814860037643e-26,
 -8.828395999396325e-28,  1.468166014407451e+00, -2.516014514331275e-03, -5.265223435433385e-06,  4.799267838041605e-09,  6.264306816683352e-11,  9.554045278126242e-14,
 -5.949922840837225e-16, -2.908139901220201e-18,  1.498511216221831e-21,  5.057245948886355e-23,  1.113080996458909e-25, -5.611853314273085e-28,  1.538436500380044e+00,
 -2.310060835791715e-03, -5.705291365904941e-06,  4.777942891472683e-11,  5.590070643088066e-11,  1.629037875106678e-13, -2.532787844550826e-16, -3.138691837269736e-18,
 -6.033454115086364e-21,  3.095444358704427e-23,  2.009199943062807e-25,  1.314227457922082e-28,  1.605755439747804e+00, -2.078601905829113e-03, -5.903656717882449e-06,
 -4.507958115543919e-09,  4.284485557868633e-11,  1.992042188484127e-13,  1.323991950081853e-16, -2.390712389269303e-18, -1.084362444050110e-20, -2.467611542011715e-24,
  1.701771564676801e-25,  6.963463769099543e-28,  1.669543789643669e+00, -1.827577920727037e-03, -5.847948931813938e-06, -8.432167079958105e-09,  2.539191138523477e-11,
  1.971830180744518e-13,  4.555184973932757e-16, -9.434102080549733e-19, -1.086901253491720e-20, -3.148542168200634e-23,  4.217113257806133e-26,  7.172005289151853e-28,
  1.729224098914770e+00, -1.564038078944480e-03, -5.543182528795043e-06, -1.134074526895922e-08,  6.305267368701947e-12,  1.585136877924653e-13,  6.262488827816863e-16,
  6.380231190212643e-19, -6.379791795407090e-21, -4.040616701939651e-23, -9.190040288600984e-26,  2.249064584387638e-28,  1.784229409247994e+00, -1.295967696366561e-03,
 -5.013343666946239e-06, -1.296009176626690e-08, -1.128437263466874e-11,  9.408407733991566e-14,  6.048914260756447e-16,  1.739468008195766e-18,  5.332206084835934e-23,
 -2.644301507958245e-23, -1.410202207776780e-25, -3.231563778346237e-28,  1.834013185119144e+00, -1.032038138729109e-03, -4.301331227011385e-06, -1.317744136465305e-08,
 -2.451437758776572e-11,  2.142442664896467e-14,  4.190159954643772e-16,  1.984115046247887e-18,  4.995687678627045e-21, -1.552250452841086e-24, -8.641813222337656e-26,
 -4.753222756884276e-28,  1.878060023917624e+00, -7.812830513283043e-04, -3.466932960015980e-06, -1.207168713147240e-08, -3.144403119007164e-11, -4.032922117495454e-14,
  1.538565548569749e-16,  1.415400622664319e-18,  6.206090713088060e-21,  1.667520570378316e-23,  8.140608440771348e-27, -2.077348706457075e-28,  1.915896798403237e+00,
 -5.527122897770553e-04, -2.582731461608126e-06, -9.915239158338759e-09, -3.155181486935300e-11, -7.648713938189910e-14, -8.328286309006103e-17,  4.585203301262847e-19,
  3.941332746355409e-21,  1.837547713149811e-23,  6.023309212435408e-26,  1.156330359873756e-28,  1.947103796453386e+00, -3.548833928905636e-04, -1.728123847723088e-06,
 -7.141813218304219e-09, -2.591204101233674e-11, -8.172100966123199e-14, -2.102800186338834e-16, -3.356980969863074e-19,  5.226888296086487e-22,  7.836241876263650e-24,
  4.440424727636862e-26,  1.851596777953754e-28,  1.971325375319188e+00, -1.954580907691993e-04, -9.819616534536183e-07, -4.281725552580058e-09, -1.695667383451439e-11,
 -6.178763429821418e-14, -2.063335879881213e-16, -6.173284433179751e-19, -1.552307553173226e-21, -2.575346906144425e-24,  2.730586733278902e-27,  5.255588001023538e-29,
  1.988279772400912e+00, -8.077596811725138e-05, -4.146075806398820e-07, -1.873920119982769e-09, -7.845507013011373e-12, -3.106404764526087e-14, -1.173800793380904e-16,
 -4.245148553445894e-19, -1.467154516585055e-21, -4.814967585748866e-24, -1.480162341425471e-26, -4.140776403652564e-29,  1.997770010208300e+00, -1.546385141875123e-05,
 -8.032060051439514e-08, -3.701954782511499e-10, -1.596126168556282e-12, -6.589369405620897e-15, -2.636674497293993e-17, -1.029853016602097e-19, -3.943582667591767e-22,
 -1.484578890717957e-24, -5.503901081618813e-27, -2.011592820397589e-29,  5.584644717552920e-04, -2.969947123298939e-06,  1.184279322622231e-08, -4.196406446882205e-11,
  1.393453315388608e-13, -4.439944272672302e-16,  1.374595800612018e-18, -4.166256519512184e-21,  1.242075444295249e-23, -3.654369066147579e-26,  1.063410879969571e-28,
 -3.065972534852848e-31,  5.024266163968087e-03, -2.667423804379030e-05,  1.059859985791421e-07, -3.732646301294580e-10,  1.227920421070581e-12, -3.860753829278061e-15,
  1.173883271763100e-17, -3.474692834239014e-20,  1.005028199045127e-22, -2.846746953721331e-25,  7.902942222625478e-28, -2.150389714650841e-30,  1.394564006345446e-02,
 -7.378801250344916e-05,  2.910881587292020e-07, -1.012539955582025e-09,  3.267669387461826e-12, -9.992318741276056e-15,  2.922820888361954e-17, -8.207579948557636e-20,
  2.211375896006763e-22, -5.691718241691247e-25,  1.385447745439145e-27, -3.126153133833130e-30,  2.730202605558875e-02, -1.437219181712703e-04,  5.608345886493987e-07,
 -1.914118420463880e-09,  5.994566188405919e-12, -1.752476460996937e-14,  4.799068843634082e-17, -1.223036689637314e-19,  2.842531923221816e-22, -5.727754933045741e-25,
  8.485696070922662e-28, -4.791558255531214e-32,  4.506233060251924e-02, -2.355926496688413e-04,  9.058888113028137e-07, -3.011932787006891e-09,  9.039055521501466e-12,
 -2.470463354664659e-14,  6.072856201022947e-17, -1.284310931838170e-19,  2.013525465792560e-22, -4.564146128400545e-26, -1.372354234341372e-27,  7.639129316062666e-30,
  6.718462132610600e-02, -3.482240058363671e-04,  1.314058004197282e-06, -4.222419446963393e-09,  1.195654130653719e-11, -2.957896185192325e-14,  6.024328230594403e-17,
 -7.879978574026284e-20, -7.375024772466690e-23,  1.023043154434198e-24, -4.710560065156033e-27,  1.595844554991357e-29,  9.361571759100815e-02, -4.801486206941328e-04,
  1.770518104573584e-06, -5.448331013908436e-09,  1.426585111746443e-11, -3.028112868534102e-14,  4.112921123777523e-17,  3.467438127662618e-20, -5.124835150657665e-22,
  2.310581281614505e-24, -7.373480379981006e-27,  1.740453092289441e-29,  1.242906754196135e-01, -6.296106541201307e-04,  2.258102156430334e-06, -6.583407228857954e-09,
  1.549374206664338e-11, -2.533459640072103e-14,  1.342946802117097e-18,  2.005764568813796e-19, -9.996517574349433e-22,  3.202059354001560e-24, -6.960039626419372e-27,
  5.123355073184310e-30,  1.591321649360460e-01, -7.945698126853557e-04,  2.757655990595020e-06, -7.517823460107956e-09,  1.522297125741254e-11, -1.394162693181251e-14,
 -5.664200002734422e-17,  3.862330690254587e-19, -1.350496433164821e-21,  2.985013065303887e-24, -1.691004319403003e-27, -2.139450771548961e-29,  1.980497386175575e-01,
 -9.727071634176912e-04,  3.248465523750736e-06, -8.144302538467322e-09,  1.314089913456367e-11,  3.779183850675378e-15, -1.253673894448263e-16,  5.413905843854239e-19,
 -1.358057035140899e-21,  1.158440231726692e-24,  8.204558874356101e-27, -5.233128046327690e-29,  2.409389889992649e-01, -1.161433304201815e-03,  3.708759725799539e-06,
 -8.364732995795931e-09,  9.085053558545770e-12,  2.664349260130330e-14, -1.928224514107371e-16,  6.076371081381221e-19, -8.632159819847915e-22, -2.240177370701645e-24,
  1.963905737640859e-26, -6.869475651111063e-29,  2.876805952195848e-01, -1.357899564038446e-03,  4.116292489421922e-06, -8.097084105088140e-09,  3.081601294186445e-12,
  5.237432551027371e-14, -2.438854307593013e-16,  5.326082779087556e-19,  1.694183208494804e-22, -6.424589638265926e-24,  2.702899255617772e-26, -5.026747431869975e-29,
  3.381392590152529e-01, -1.559013023384844e-03,  4.449005060383117e-06, -7.282345319607519e-09, -4.627680502872089e-12,  7.772538036465095e-14, -2.627358765336972e-16,
  2.866110760368354e-19,  1.593662713139020e-21, -9.900307184707133e-24,  2.419441697421583e-26,  1.151571835607238e-29,  3.921625326050645e-01, -1.761456266652861e-03,
  4.685768137759266e-06, -5.891145809810748e-09, -1.357447371728229e-11,  9.877032527267337e-14, -2.360145754009271e-16, -1.219922053162158e-19,  3.067848229284834e-21,
 -1.083580772042300e-23,  7.458387180712215e-27,  1.016548493054802e-28,  4.495795434935327e-01, -1.961712900892315e-03,  4.807198986381714e-06, -3.929631587730109e-09,
 -2.307336278689992e-11,  1.113563737145192e-13, -1.563042254008068e-16, -6.371383522799566e-19,  4.105235678687237e-21, -7.735570852715801e-24, -2.117377250227901e-26,
  1.788718433797162e-28,  5.101996247583519e-01, -2.156099989086950e-03,  4.796543658953247e-06, -1.444098467944014e-09, -3.225529199167686e-11,  1.116971568148325e-13,
 -2.531030992098521e-17, -1.155655290434653e-18,  4.194679012166666e-21, -2.428401263852801e-25, -5.244277898651373e-26,  1.886581733385236e-28,  5.738108640623963e-01,
 -2.340808641882205e-03,  4.640607448847003e-06,  1.476192534188080e-09, -4.012733934156657e-11,  9.705185836895323e-14,  1.440189924181715e-16, -1.541387080237584e-18,
  2.974884374445776e-21,  1.023319718987801e-23, -7.149962386326727e-26,  9.179406213908017e-29,  6.401785906757860e-01, -2.511954071637533e-03,  4.330707780548323e-06,
  4.698641975349015e-09, -4.565898055751635e-11,  6.640710221705544e-14,  3.272281987867851e-16, -1.653517958959806e-18,  4.191025417966261e-22,  2.042966308830608e-23,
 -6.344139647724531e-26, -1.024663899053848e-28,  7.090438274405693e-01, -2.665636415180607e-03,  3.863612798234223e-06,  8.050018516608525e-09, -4.789199168503226e-11,
  2.104947841737051e-14,  4.906059912387251e-16, -1.385796462471629e-18, -3.035347239835894e-21,  2.596210860011709e-23, -2.146408735588896e-26, -3.185644752770320e-28,
  7.801217440869506e-01, -2.798013547296436e-03,  3.242416042794451e-06,  1.132283458833891e-08, -4.606721717578173e-11, -3.510361810081193e-14,  5.962629554398607e-16,
 -7.086370303042242e-19, -6.485594486812027e-21,  2.289341257356752e-23,  4.581559916989944e-26, -4.327336569754280e-28,  8.531001598073115e-01, -2.905386898953406e-03,
  2.477283251079560e-06,  1.428584375035347e-08, -3.975678837369226e-11, -9.555035993625368e-14,  6.097589789297082e-16,  2.982123683575692e-19, -8.743338172389104e-21,
  9.744515151906532e-24,  1.126366787236959e-25, -3.334732231052237e-28,  9.276381566259567e-01, -2.984300918207086e-03,  1.585992391963706e-06,  1.669885748454915e-08,
 -2.898545882567925e-11, -1.517399408725519e-13,  5.092216978265856e-16,  1.436824059807833e-18, -8.697713737123676e-21, -1.087358414510796e-23,  1.437775478901053e-25,
 -3.160107468059092e-30,  1.003364880843228e+00, -3.031656217328203e-03,  5.941741615482832e-07,  1.833167979222054e-08, -1.432032442661627e-11, -1.941495128933684e-13,
  2.940514081067382e-16,  2.418279295234860e-18, -5.781790584962435e-21, -3.203314574956776e-23,  1.114131348517042e-25,  4.287307025237061e-28,  1.079878627437301e+00,
 -3.044835584453688e-03, -4.648502745113806e-07,  1.898639867881137e-08,  3.094482557920707e-12, -2.138551905491510e-13, -9.362853489116986e-18,  2.930114974143201e-18,
 -3.786259366619743e-22, -4.442232957468176e-23,  1.464829883570568e-26,  7.161290713195907e-28,  1.156746321208328e+00, -3.021840854178838e-03, -1.550741087464867e-06,
  1.852156219451365e-08,  2.158093474387594e-11, -2.044143745924404e-13, -3.476546959478159e-16,  2.734468423884253e-18,  6.045388540483767e-21, -4.031058217398540e-23,
 -1.100676739961491e-25,  6.288639931610555e-28,  1.233503527637883e+00, -2.961437097161067e-03, -2.617420333731212e-06,  1.687594949996224e-08,  3.906529073718842e-11,
 -1.637254413907891e-13, -6.482613522751553e-16,  1.770606850647009e-18,  1.125475084423849e-20, -1.812674815890330e-23, -1.990417934149213e-25,  1.296761665255595e-28,
  1.309655144332423e+00, -2.863298704343509e-03, -3.615036640876334e-06,  1.408882569846818e-08,  5.331646412312668e-11, -9.540201412051113e-14, -8.352334053773798e-16,
  2.220579695921669e-19,  1.302803210181603e-20,  1.484598922921459e-23, -1.938696565034155e-25, -5.312069178046287e-28,  1.384676938259563e+00, -2.728149760647357e-03,
 -4.492644425890870e-06,  1.031291142251412e-08,  6.227074387735193e-11, -9.148097265571549e-15, -8.505694932425701e-16, -1.492897066922611e-18,  1.018480194758611e-20,
  4.410180304444765e-23, -8.191923208735125e-26, -9.221765112146036e-28,  1.458018101759399e+00, -2.557888758000239e-03, -5.201558018745691e-06,  5.816039965048437e-09,
  6.440451866364204e-11,  8.029063328693530e-14, -6.754693379575371e-16, -2.830249749100057e-18,  3.392863203344038e-21,  5.448184211844167e-23,  8.295445894088609e-26,
 -7.266937207749745e-28,  1.529104997795705e+00, -2.355685422996132e-03, -5.699245180849087e-06,  9.678948031498508e-10,  5.909076853867588e-11,  1.557497646110028e-13,
 -3.436865069741223e-16, -3.312372899518115e-18, -4.773451945813075e-21,  3.906101378474833e-23,  2.032181844266546e-25, -3.196035163800015e-29,  1.597346247865086e+00,
 -2.126035583964765e-03, -5.953507138981533e-06, -3.790418568322011e-09,  4.685509080861245e-11,  2.015392759856576e-13,  6.059766173823700e-17, -2.737756350318709e-18,
 -1.080260042044173e-20,  4.945869450056094e-24,  2.002737057507712e-25,  6.656008718281355e-28,  1.662139280083606e+00, -1.874759046071657e-03, -5.946565274649568e-06,
 -7.993762920427646e-09,  2.944254901470868e-11,  2.077581397074200e-13,  4.240659835370588e-16, -1.308964877037333e-18, -1.196420819627920e-20, -2.913337129547460e-23,
  7.626089892973456e-26,  8.309636024766989e-28,  1.722878396527493e+00, -1.608925933640231e-03, -5.678558886486864e-06, -1.121367653099166e-08,  9.627162873021409e-12,
  1.737335985063022e-13,  6.410317705839182e-16,  4.099080547030042e-19, -7.897839246651153e-21, -4.384462292829785e-23, -7.899944653050689e-26,  3.653436722537913e-28,
  1.778964335858784e+00, -1.336699451241643e-03, -5.169883372131915e-06, -1.312478294607550e-08, -9.253574912218648e-12,  1.091852064278798e-13,  6.534693890135852e-16,
  1.724827240307831e-18, -1.003495888959624e-21, -3.235776849950589e-23, -1.544154803217570e-25, -2.816079075856309e-28,  1.829815200413053e+00, -1.067087937431281e-03,
 -4.461797941199260e-06, -1.356567788806429e-08, -2.398073219284106e-11,  3.216546108192497e-14,  4.767958849998581e-16,  2.142373746272057e-18,  4.872369900749111e-21,
 -5.446509191655504e-24, -1.087691509612962e-25, -5.403902611945418e-28,  1.874878491183126e+00, -8.096065686956079e-04, -3.614837762178919e-06, -1.258102979147460e-08,
 -3.221036157187378e-11, -3.613809155971732e-14,  1.963586855660246e-16,  1.623644167189849e-18,  6.809866132807823e-21,  1.679690903044475e-23, -2.603906810068841e-27,
 -2.830632513391969e-28,  1.913643859712529e+00, -5.738587719864487e-04, -2.704794126472763e-06, -1.043241010988899e-08, -3.310042930925675e-11, -7.831698529569181e-14,
 -6.857575659719193e-17,  5.957020439658791e-19,  4.647418900848075e-21,  2.088369756019166e-23,  6.509258698376371e-26,  1.038748074103461e-28,  1.945656060006199e+00,
 -3.690583647951257e-04, -1.816367995011886e-06, -7.569758599571785e-09, -2.759767885324183e-11, -8.687836130138458e-14, -2.194004521490682e-16, -3.140991213249100e-19,
  8.388076356102647e-22,  9.784143629241416e-24,  5.321453200195148e-26,  2.158717910799471e-28,  1.970527499521090e+00, -2.035240147334888e-04, -1.035011868467834e-06,
 -4.563193393461216e-09, -1.824337605243376e-11, -6.695276070646914e-14, -2.243279780820514e-16, -6.684597970413187e-19, -1.642453104961958e-21, -2.415027607442165e-24,
  5.412647795239404e-27,  7.004441315608425e-29,  1.987949889313019e+00, -8.418495913829277e-05, -4.378688001146327e-07, -2.004575682358272e-09, -8.495950097662206e-12,
 -3.402927611173957e-14, -1.299506748504910e-16, -4.743551375470534e-19, -1.651602428982578e-21, -5.444884658410692e-24, -1.672984003931046e-26, -4.629618942054268e-29,
  1.997706840911755e+00, -1.612462999633480e-05, -8.492063746455311e-08, -3.968231850115302e-10, -1.734482731124882e-12, -7.258251292003796e-15, -2.943535373605319e-17,
 -1.165041683701918e-19, -4.519889203184495e-22, -1.723511489709209e-24, -6.470570883362918e-27, -2.394086280650937e-29,  5.467710313180921e-04, -2.877181814073125e-06,
  1.135231426793396e-08, -3.980382466964104e-11,  1.307861239814029e-13, -4.123602636733133e-16,  1.263313045347730e-18, -3.789046254138017e-21,  1.117860546849533e-23,
 -3.254791410904118e-26,  9.373268546037453e-29, -2.674598867614838e-31,  4.919237083566099e-03, -2.584393853355941e-05,  1.016222039769555e-07, -3.542206409387614e-10,
  1.153445697096824e-12, -3.590342649567428e-15,  1.080944577711052e-17, -3.168888999734484e-20,  9.080145692059325e-23, -2.548770321801105e-25,  7.014617767371295e-28,
 -1.893171166031868e-30,  1.365506970601141e-02, -7.150703528993482e-05,  2.792449019521536e-07, -9.618186700109047e-10,  3.074655688503867e-12, -9.317638120274619e-15,
  2.702615050263559e-17, -7.531680777129383e-20,  2.016125672211758e-22, -5.164184348618128e-25,  1.254319090603678e-27, -2.838172447691610e-30,  2.673596853062109e-02,
 -1.393255148610255e-04,  5.384292791885699e-07, -1.820947890009516e-09,  5.655316508835374e-12, -1.641307307951677e-14,  4.469047793019777e-17, -1.135309438654241e-19,
  2.642429515546539e-22, -5.389599404068746e-25,  8.402472779864850e-28, -3.174037175725779e-31,  4.413422874006290e-02, -2.284876903716609e-04,  8.705973153388344e-07,
 -2.871182659573322e-09,  8.559250178837123e-12, -2.328957469606898e-14,  5.722237848512430e-17, -1.220240623813979e-19,  1.987987185913338e-22, -9.421048334140105e-26,
 -1.065537479997558e-27,  6.342420862911615e-30,  6.581243385962371e-02, -3.379110102103911e-04,  1.264517529091587e-06, -4.035769617263518e-09,  1.137924050087471e-11,
 -2.815983372178648e-14,  5.800913341293654e-17, -8.060554872421814e-20, -4.014850799415369e-23,  8.480704251067936e-25, -4.052385668644855e-27,  1.399359441345288e-29,
  9.172304274259195e-02, -4.662421611120699e-04,  1.706487843122615e-06, -5.224868446402605e-09,  1.367016893751851e-11, -2.928415530315310e-14,  4.188260890741989e-17,
  1.955035855165655e-20, -4.344299410482413e-22,  2.030626893561257e-24, -6.632586597146816e-27,  1.625929724102334e-29,  1.218078679975385e-01, -6.118576646058196e-04,
  2.180571958825199e-06, -6.339557294213313e-09,  1.498780911680427e-11, -2.523848212489984e-14,  6.528192790054595e-18,  1.703787294087773e-19, -8.893295312490760e-22,
  2.928705505821762e-24, -6.695418528598856e-27,  6.805166489762222e-30,  1.559974426436704e-01, -7.728653012917402e-04,  2.668894083422814e-06, -7.276556851118875e-09,
  1.493139579680437e-11, -1.517604523330432e-14, -4.641644483314894e-17,  3.447217582983334e-19, -1.244464699658696e-21,  2.900250533157153e-24, -2.506748222427618e-27,
 -1.584927402918934e-29,  1.942102714976454e-01, -9.471067867174891e-04,  3.151997398186624e-06, -7.933601895770563e-09,  1.318759730400236e-11,  9.474036961169283e-16,
 -1.108101669599591e-16,  4.986589988060993e-19, -1.310979190190268e-21,  1.442936856935776e-24,  6.077500627481058e-27, -4.447455488826702e-29,  2.363519637583939e-01,
 -1.132162223551644e-03,  3.609271880883383e-06, -8.215354892873985e-09,  9.573007714474399e-12,  2.221672920541999e-14, -1.762064098269974e-16,  5.788696506807054e-19,
 -9.304362269426532e-22, -1.513471351877325e-24,  1.673659580171884e-26, -6.315933500611574e-29,  2.823142435505908e-01, -1.325356968396577e-03,  4.019456864642795e-06,
 -8.039711540113227e-09,  4.071765542625169e-12,  4.670043781444632e-14, -2.289298071411234e-16,  5.345333758325845e-19, -4.294835650484225e-23, -5.388653375034369e-24,
  2.474739188424431e-26, -5.307993259293536e-29,  3.319738359203808e-01, -1.523771678275584e-03,  4.361222855870085e-06, -7.344291926315173e-09, -3.135551062761536e-12,
  7.152146070714933e-14, -2.540490499469387e-16,  3.320931991260918e-19,  1.254751616139881e-21, -8.926976715113040e-24,  2.436471900646820e-26, -3.233188505396401e-30,
  3.851912270843887e-01, -1.724256440680101e-03,  4.613835427350949e-06, -6.092842866627999e-09, -1.165593157766632e-11,  9.307572124622442e-14, -2.381141454607590e-16,
 -2.999658782504007e-20,  2.684142189616136e-21, -1.045511699972121e-23,  1.140453690334478e-26,  7.809783587347879e-29,  4.418092997830282e-01, -1.923450039363712e-03,
  4.757901183541381e-06, -4.281197995072762e-09, -2.088511774984167e-11,  1.074055755651514e-13, -1.723478965939280e-16, -5.103749257056563e-19,  3.813351997807262e-21,
 -8.431149822382055e-24, -1.375693853870749e-26,  1.580520942120828e-28,  5.016518475865374e-01, -2.117805560469471e-03,  4.776191553114975e-06, -1.942355328556308e-09,
 -3.002996605149673e-11,  1.107165550081494e-13, -5.579354848991751e-17, -1.021954056709036e-18,  4.150178404812760e-21, -2.174630241772505e-24, -4.416017570262754e-26,
  1.868324584941209e-28,  5.645219761917244e-01, -2.303623691019187e-03,  4.654534157623673e-06,  8.498567265244460e-10, -3.815517651399969e-11,  1.000014861785065e-13,
  1.022443975992373e-16, -1.440839979975945e-18,  3.292856923150297e-21,  7.463070127394122e-24, -6.679773689710814e-26,  1.204956528952117e-28,  6.302004054139431e-01,
 -2.477095190187980e-03,  4.382753390091333e-06,  3.979134422658381e-09, -4.425604327266032e-11,  7.370717429064842e-14,  2.812244812391058e-16, -1.628836779032201e-18,
  1.107957553675121e-21,  1.781839671211988e-23, -6.672230347701827e-26, -4.762066654708745e-29,  6.984436930428393e-01, -2.634354102442315e-03,  3.955631317708537e-06,
  7.287740937153923e-09, -4.735645274873774e-11,  3.234827579817795e-14,  4.505830261763060e-16, -1.468165561740944e-18, -2.119397537730921e-21,  2.483929575158484e-23,
 -3.427200155166527e-26, -2.630660248807569e-28,  7.689824113360397e-01, -2.771543301518044e-03,  3.373846935805179e-06,  1.058091290324227e-08, -4.662791154542954e-11,
 -2.105408786817867e-14,  5.736417785132074e-16, -9.026727611918083e-19, -5.632996376135741e-21,  2.434947175140713e-23,  2.711824023181508e-26, -4.148046639396906e-28,
  8.415193190160724e-01, -2.884893866350059e-03,  2.644836243181784e-06,  1.363524447911890e-08, -4.152093898094857e-11, -8.084720649516539e-14,  6.142506756639309e-16,
  2.487829549665474e-20, -8.315115930755003e-21,  1.394112865564111e-23,  9.684605754677300e-26, -3.812388371765140e-28,  9.157275865155801e-01, -2.970819544221905e-03,
  1.783498116325718e-06,  1.621148888637640e-08, -3.189494965202941e-11, -1.390676202305969e-13,  5.455052504852746e-16,  1.153341823986955e-18, -8.985965152106726e-21,
 -5.156848929678858e-24,  1.412936299726189e-25, -1.082053718000510e-28,  9.912491500833593e-01, -3.026027091037367e-03,  8.126527332742605e-07,  1.807189675490944e-08,
 -1.812737014603162e-11, -1.863016781300407e-13,  3.590059597200503e-16,  2.215706080975217e-18, -6.850499713366667e-21, -2.723021322073483e-23,  1.279486866008577e-25,
  3.210690622552279e-28,  1.067693291221178e+00, -3.047642522814829e-03, -2.368575278968810e-07,  1.900170921127978e-08, -1.178236163758633e-12, -2.130982216156785e-13,
  7.227148890879488e-17,  2.892585976734180e-18, -1.959756064281415e-21, -4.321396434708212e-23,  4.552528911392675e-26,  6.825698372786733e-28,  1.144635561446822e+00,
 -3.033352191403371e-03, -1.326546881338268e-06,  1.883372391672581e-08,  1.741551907929365e-11, -2.118188156793990e-13, -2.686051433035173e-16,  2.903908026758954e-18,
  4.521878347848783e-21, -4.413270411753301e-23, -8.041501251744196e-26,  7.143824304922970e-28,  1.221617197762214e+00, -2.981556042763948e-03, -2.411269421066492e-06,
  1.747397032843885e-08,  3.563942249222255e-11, -1.786487503382928e-13, -5.937512099741247e-16,  2.118795416559781e-18,  1.046070742295243e-20, -2.592439924289480e-23,
 -1.896083984579219e-25,  2.987376972115893e-28,  1.298145199952988e+00, -2.891528383831953e-03, -3.440918837464928e-06,  1.492553862515219e-08,  5.120871681596283e-11,
 -1.153254557702091e-13, -8.231098014865121e-16,  6.459661954633406e-19,  1.341762123159495e-20,  6.662909845578375e-24, -2.142590047104603e-25, -3.905123468471442e-28,
  1.373693264571901e+00, -2.763578979842806e-03, -4.362921165155902e-06,  1.130665695512224e-08,  6.188045583323613e-11, -3.002510785217100e-14, -8.875741106768828e-16,
 -1.142292792699082e-18,  1.170367251958711e-20,  4.001039118624099e-23, -1.226548502797336e-25, -9.225815370586554e-28,  1.447703788703003e+00, -2.599204418016411e-03,
 -5.125532639775940e-06,  6.858451253145856e-09,  6.584187085635121e-11,  6.314250743297358e-14, -7.528972827729821e-16, -2.689721534277404e-18,  5.405803771055725e-21,
  5.711382265587172e-23,  4.751530149730871e-26, -8.815725282540897e-28,  1.519591164739949e+00, -2.401216619133159e-03, -5.681856473190318e-06,  1.937787067759378e-09,
  6.211568311879576e-11,  1.463724256352126e-13, -4.383489030328420e-16, -3.441061350082165e-18, -3.221770275926612e-21,  4.710709134160847e-23,  1.976889128221206e-25,
 -2.236468536279017e-28,  1.588746579739917e+00, -2.173832529862356e-03, -5.994360874097674e-06, -3.008438575429264e-09,  5.089400956071554e-11,  2.020348927275045e-13,
 -2.086096400564663e-17, -3.078988346633812e-18, -1.047344976060833e-20,  1.352485007225147e-23,  2.281615826599204e-25,  5.949803016199174e-28,  1.654544503055676e+00,
 -1.922706941195713e-03, -6.039525069311494e-06, -7.488901103675647e-09,  3.369629129555587e-11,  2.174517022985471e-13,  3.819019527664652e-16, -1.707938234779997e-18,
 -1.294900602770768e-20, -2.532070179408084e-23,  1.151100878145934e-25,  9.320698231316122e-28,  1.716350987663186e+00, -1.654889773094199e-03, -5.812081415945259e-06,
 -1.103100527419600e-08,  1.325645827904896e-11,  1.892260520969641e-13,  6.487295244780230e-16,  1.313470099949071e-19, -9.528831471832690e-21, -4.663669395089654e-23,
 -5.941662980899485e-26,  5.283401306100746e-28,  1.773533819108866e+00, -1.378690853193571e-03, -5.328194243507338e-06, -1.325450204669484e-08, -6.909149700037889e-12,
  1.254432655259810e-13,  7.011312310321407e-16,  1.672862020867542e-18, -2.282379072802154e-21, -3.876401379459883e-23, -1.653927742496677e-25, -2.123164509442275e-28,
  1.825474419765820e+00, -1.103439943225207e-03, -4.626864926471610e-06, -1.394358067779185e-08, -2.321804288220973e-11,  4.434580602417845e-14,  5.389294335896850e-16,
  2.294265072931820e-18,  4.592082286099309e-21, -1.029132908248325e-23, -1.339201955018209e-25, -6.018674074563493e-28,  1.871581258906877e+00, -8.391379746291619e-04,
 -3.768925292792551e-06, -1.310190571228957e-08, -3.288218526443940e-11, -3.085475680716336e-14,  2.449621553555616e-16,  1.851188933507061e-18,  7.409448056966353e-21,
  1.641813158656364e-23, -1.699510102525209e-26, -3.737183018917566e-28,  1.911304342187183e+00, -5.960070035936544e-04, -2.833212651636412e-06, -1.097463113677051e-08,
 -3.468178627956687e-11, -7.974512964346358e-14, -4.969740018466595e-17,  7.569595975149293e-19,  5.447151252884543e-21,  2.357328774450186e-23,  6.923065541333311e-26,
  8.236891102207374e-29,  1.944150178583473e+00, -3.839602976651271e-04, -1.909912749872215e-06, -8.025511028559681e-09, -2.938859745286037e-11, -9.224613571120809e-14,
 -2.277634505541979e-16, -2.811916339033184e-19,  1.231729092303444e-21,  1.211248240848446e-23,  6.345057771782823e-26,  2.499410280111321e-28,  1.969696489327500e+00,
 -2.120282088631383e-04, -1.091566707321259e-06, -4.866098847298216e-09, -1.963781707724091e-11, -7.256725246634457e-14, -2.437934069270809e-16, -7.223611773921767e-19,
 -1.724698916364223e-21, -2.130735791033235e-24,  8.963154335249544e-27,  9.219625966079629e-29,  1.987605987895858e+00, -8.778649291869592e-05, -4.627623403489269e-07,
 -2.146129649451956e-09, -9.208831270176913e-12, -3.731363366528035e-14, -1.440029486358451e-16, -5.304758977151118e-19, -1.860168414166758e-21, -6.156330736285683e-24,
 -1.888039191873703e-26, -5.150219950028007e-29,  1.997640952822100e+00, -1.682352567578141e-05, -8.985394391059639e-08, -4.257757518939582e-10, -1.886985170041056e-12,
 -8.005538743410653e-15, -3.290965757872592e-17, -1.320126460304807e-19, -5.189596962571049e-22, -2.004697175058008e-24, -7.622282763766848e-27, -2.855268329037411e-29,
  5.354409654081805e-04, -2.788238925949065e-06,  1.088695692142099e-08, -3.777561232601603e-11,  1.228337246857790e-13, -3.832745056502025e-16,  1.162056644972465e-18,
 -3.449377255797368e-21,  1.007162648547739e-23, -2.902366009875066e-26,  8.272621075698453e-29, -2.336451097456229e-31,  4.817460799768442e-03, -2.504765512249654e-05,
  9.747996229525753e-08, -3.363261649696111e-10,  1.084162902302009e-12, -3.341243368465836e-15,  9.961494200525757e-18, -2.892479605973470e-20,  8.211148761102268e-23,
 -2.284161750349342e-25,  6.232182389974289e-28, -1.668322221387188e-30,  1.337343754734337e-02, -6.931842100148250e-05,  2.679922074473795e-07, -9.140804631103767e-10,
  2.894622079780693e-12, -8.693604762479568e-15,  2.500487510514562e-17, -6.915321876679725e-20,  1.838952445413351e-22, -4.686637227335458e-25,  1.135343418067989e-27,
 -2.573592263638281e-30,  2.618714508682458e-02, -1.351039724546972e-04,  5.171101681253693e-07, -1.733031705028974e-09,  5.337528136704675e-12, -1.537771020061511e-14,
  4.162712156291037e-17, -1.053791548203288e-19,  2.454414226065894e-22, -5.056925141098174e-25,  8.216767850953055e-28, -5.163369431515950e-31,  4.323399256642302e-02,
 -2.216584354216416e-04,  8.369496788861005e-07, -2.737887519460695e-09,  8.106919006002129e-12, -2.195652225599738e-14,  5.389420111095198e-17, -1.157244691276333e-19,
  1.947041205375520e-22, -1.315872071832385e-25, -8.112916058752868e-28,  5.244548497331713e-30,  6.448071969456716e-02, -3.279855340811838e-04,  1.217162358210600e-06,
 -3.858132468361235e-09,  1.082978257050937e-11, -2.679481604030371e-14,  5.573856504807278e-17, -8.143192462326077e-20, -1.239217409218267e-23,  6.977571589462067e-25,
 -3.476086995281621e-27,  1.223464837752106e-29,  8.988498600473910e-02, -4.528373779228398e-04,  1.645082607795786e-06, -5.010776434624312e-09,  1.309457415925828e-11,
 -2.827390891717992e-14,  4.224602703048044e-17,  6.768416358414827e-21, -3.659336107870873e-22,  1.779280823766950e-24, -5.943460520969050e-27,  1.505946524993442e-29,
  1.193948503889221e-01, -5.947133493006244e-04,  2.105919475442039e-06, -6.103780427342145e-09,  1.448497644646600e-11, -2.502767847304103e-14,  1.091586272744943e-17,
  1.435560387057131e-19, -7.886412345773342e-22,  2.667247762615175e-24, -6.369192432844496e-27,  7.943230075316884e-30,  1.529481364282848e-01, -7.518593854584152e-04,
  2.582998611727655e-06, -7.040140010631696e-09,  1.461749392453369e-11, -1.617861763298633e-14, -3.730620507671065e-17,  3.065488023155524e-19, -1.142015559749383e-21,
  2.787453233437500e-24, -3.099579674437578e-27, -1.124280593823237e-29,  1.904716784201841e-01, -9.222680328720320e-04,  3.058060354770037e-06, -7.722588588195832e-09,
  1.318105760637446e-11, -1.549181805159538e-15, -9.742691152211257e-17,  4.575820165420840e-19, -1.255109627085568e-21,  1.649045952806329e-24,  4.279708526085137e-27,
 -3.736882773978927e-29,  2.318804425660194e-01, -1.103679749377617e-03,  3.511620564565411e-06, -8.058856416219766e-09,  9.976348051359774e-12,  1.817886525741410e-14,
 -1.604221957450331e-16,  5.483478046663469e-19, -9.735250560377655e-22, -8.978787250268319e-25,  1.408570047802935e-26, -5.730529026010015e-29,  2.770765176234950e-01,
 -1.293586043042715e-03,  3.923401084835660e-06, -7.967384662115141e-09,  4.952041928147200e-12,  4.138539782479517e-14, -2.140099413630013e-16,  5.302416205673442e-19,
 -2.196882826129622e-22, -4.445845229683377e-24,  2.238687993227623e-26, -5.392914089057245e-29,  3.259479695433717e-01, -1.489235167734644e-03,  4.272836479739903e-06,
 -7.383345350147918e-09, -1.765318220071169e-12,  6.554011377205490e-14, -2.442352861189177e-16,  3.672909077564308e-19,  9.508552684935567e-22, -7.958869500019128e-24,
  2.395604725765253e-26, -1.485333977953613e-29,  3.783675553405520e-01, -1.687641244675211e-03,  4.539662767332261e-06, -6.264756272686612e-09, -9.851583882487735e-12,
  8.736026428780869e-14, -2.378074725804649e-16,  4.996819283142321e-20,  2.316738814217090e-21, -9.936607135913707e-24,  1.436721591537148e-26,  5.699189929668149e-29,
  4.341912928669505e-01, -1.885597846377957e-03,  4.704591983292301e-06, -4.598404342951154e-09, -1.877945720300161e-11,  1.031112452317295e-13, -1.849763224548582e-16,
 -3.932969829923927e-19,  3.501544060184224e-21, -8.848665796614813e-24, -7.275977603058055e-27,  1.364938920706435e-28,  4.932568854802203e-01, -2.079697261481816e-03,
  4.750073223750337e-06, -2.405202351417710e-09, -2.783126598631224e-11,  1.090490561973587e-13, -8.256308917348542e-17, -8.907258708475414e-19,  4.042062075890170e-21,
 -3.778394915560096e-24, -3.608055263146628e-26,  1.796451437738832e-28,  5.553820041131052e-01, -2.266356850042082e-03,  4.661135937300971e-06,  2.554939672073166e-10,
 -3.613381343600875e-11,  1.019833665374426e-13,  6.341285371551588e-17, -1.331674734031429e-18,  3.514771615803823e-21,  4.903758488287886e-24, -6.102013971216865e-26,
  1.407870741980836e-28,  6.203624342779450e-01, -2.441854087917960e-03,  4.426304215456712e-06,  3.283182167868145e-09, -4.271807695982832e-11,  7.991385326749192e-14,
  2.362061578414150e-16, -1.583637042344124e-18,  1.701010106553420e-21,  1.512236218735592e-23, -6.772633301697869e-26,  8.449102197618684e-31,  6.879701024871360e-01,
 -2.602372068374008e-03,  4.038561204116295e-06,  6.535786873236638e-09, -4.660471324327362e-11,  4.266211730914119e-14,  4.086573181043172e-16, -1.521965061720946e-18,
 -1.252494966308098e-21,  2.325376950497496e-23, -4.458586786485177e-26, -2.056550313928425e-28,  7.579510058890788e-01, -2.744057352190624e-03,  3.496330114160881e-06,
  9.832236743870182e-09, -4.691346834569811e-11, -7.609535576157814e-15,  5.459764262961855e-16, -1.068729221055586e-18, -4.741215527958759e-21,  2.507739423804844e-23,
  9.502390751673206e-27, -3.840256637015195e-28,  8.300230811096392e-01, -2.863092096049832e-03,  2.804422401586006e-06,  1.295877458735359e-08, -4.299055985503287e-11,
 -6.612640898727753e-14,  6.113026826685468e-16, -2.324611051938012e-19, -7.747641823477021e-21,  1.746952433708996e-23,  7.936039797725633e-26, -4.105382551128415e-28,
  9.038740638612421e-01, -2.955782289960190e-03,  1.974884615969894e-06,  1.567964060496090e-08, -3.454293353371286e-11, -1.256205974179167e-13,  5.737529146638018e-16,
  8.639003430704614e-19, -9.071289130060669e-21,  3.711438709492877e-25,  1.344231326633521e-25, -2.019103839802380e-28,  9.791594102967937e-01, -3.018663628805796e-03,
  1.027653880670260e-06,  1.775253934445120e-08, -2.176234879204394e-11, -1.769666990842480e-13,  4.178365286894058e-16,  1.981818876353936e-18, -7.735565613135961e-21,
 -2.186340603556183e-23,  1.395479897309239e-25,  2.053258398323539e-28,  1.055500374660818e+00, -3.048625944636978e-03, -9.090392689614198e-09,  1.894888335087291e-08,
 -5.416337727171086e-12, -2.104003069378376e-13,  1.521548930093084e-16,  2.805391810781725e-18, -3.475586069550623e-21, -4.080842567000163e-23,  7.430479638172177e-26,
  6.212768200320092e-28,  1.132482365554501e+00, -3.043056134786729e-03, -1.099011163309248e-06,  1.907815887075244e-08,  1.312134179411924e-11, -2.172747635909085e-13,
 -1.855128274313501e-16,  3.022629534880905e-18,  2.882951347507635e-21, -4.670199793872458e-23, -4.764477209889037e-26,  7.699281860678597e-28,  1.209653734623481e+00,
 -2.999998030107291e-03, -2.198280752019098e-06,  1.801486387659443e-08,  3.192894426499754e-11, -1.921499521916831e-13, -5.298891169971531e-16,  2.437170454162046e-18,
  9.394522288225267e-21, -3.319727996897449e-23, -1.728524757602855e-25,  4.610443182622928e-28,  1.286525185481489e+00, -2.918325562140685e-03, -3.256975909856189e-06,
  1.572535971084972e-08,  4.870637787064501e-11, -1.348143665283480e-13, -7.989875676762047e-16,  1.077483047082299e-18,  1.349951039048785e-20, -2.203305826727832e-24,
 -2.278236747416718e-25, -2.220090836825127e-28,  1.362570024912206e+00, -2.797922851354751e-03, -4.221324351462605e-06,  1.229077273802062e-08,  6.106456940591363e-11,
 -5.166708131229314e-14, -9.141057357711040e-16, -7.457550816326743e-19,  1.304603208341754e-20,  3.430174703251869e-23, -1.624635707088505e-25, -8.794615957066746e-28,
  1.437225509152624e+00, -2.639861475013143e-03, -5.036871980384310e-06,  7.921016979955027e-09,  6.691803449589933e-11,  4.419068462099656e-14, -8.254764221848212e-16,
 -2.483549808971016e-18,  7.486385366621817e-21,  5.819739596650373e-23,  5.688446577851453e-27, -1.015254362285069e-27,  1.509895559972538e+00, -2.446561343064643e-03,
 -5.652545258551222e-06,  2.954453030891745e-09,  6.493007020562121e-11,  1.346858264175100e-13, -5.358762789901679e-16, -3.515521066983755e-18, -1.386509491041865e-21,
  5.475616437264679e-23,  1.832033461670352e-25, -4.378902078205610e-28,  1.579955131152925e+00, -2.221917671968126e-03, -6.025443138889539e-06, -2.161866029258591e-09,
  5.492252405295849e-11,  2.004623316133958e-13, -1.116787007271929e-16, -3.404537580487336e-18, -9.816242618836241e-21,  2.314425845212708e-23,  2.519666615976623e-25,
  4.792961521303324e-28,  1.646756487112422e+00, -1.971373109934070e-03, -6.126011953791551e-06, -6.914487282873870e-09,  3.813286276327244e-11,  2.259958498307547e-13,
  3.281482997531093e-16, -2.135920742195906e-18, -1.376755586798188e-20, -1.987090797298527e-23,  1.579548075084374e-25,  1.010870728663897e-27,  1.709637602388370e+00,
 -1.701912013795015e-03, -5.943053227932286e-06, -1.078777921959884e-08,  1.719678758809837e-11,  2.048036704859520e-13,  6.478829348263869e-16, -2.008484416224181e-19,
 -1.124445425020032e-20, -4.849591922287052e-23, -3.221290473095971e-26,  7.111043522277708e-28,  1.767932794851893e+00, -1.421954305836438e-03, -5.487825749185214e-06,
 -1.334404748408708e-08, -4.228267135506242e-12,  1.428229081079020e-13,  7.467298697137915e-16,  1.576204317324514e-18, -3.798970874191950e-21, -4.553894815340706e-23,
 -1.726065072845031e-25, -1.096062227602380e-28,  1.820985561620990e+00, -1.141130397736110e-03, -4.796385221664641e-06, -1.430724913557323e-08, -2.219649607913090e-11,
  5.806720986950692e-14,  6.051627359338473e-16,  2.434197243298647e-18,  4.118639320709586e-21, -1.619414381271131e-23, -1.616054513460871e-25, -6.546088643820811e-28,
  1.868163395772972e+00, -8.699272571345186e-04, -3.929324131216097e-06, -1.363261989466993e-08, -3.343615022125783e-11, -2.432633242011050e-14,  3.002026026819208e-16,
  2.097582958626764e-18,  7.984027617278532e-21,  1.537914864139985e-23, -3.573417338553837e-26, -4.808379786857276e-28,  1.908874135220316e+00, -6.192090421435605e-04,
 -2.968290497902481e-06, -1.154235617253998e-08, -3.628679427011107e-11, -8.066302850811754e-14, -2.593078009347890e-17,  9.453876773739325e-19,  6.346428303313517e-21,
  2.640592293894985e-23,  7.215073871484604e-26,  4.793232000314086e-29,  1.942583157377447e+00, -3.996329600486674e-04, -2.009102039202633e-06, -8.510787564535595e-09,
 -3.128879634400975e-11, -9.780206401425538e-14, -2.350158288771386e-16, -2.342875259667049e-19,  1.716210509482390e-21,  1.488117637706208e-23,  7.525460984025387e-26,
  2.870688832356404e-28,  1.968830533912228e+00, -2.209997691548657e-04, -1.151894067160320e-06, -5.192239577493533e-09, -2.114934338165315e-11, -7.866731229755944e-14,
 -2.648031750323935e-16, -7.787012604496168e-19, -1.793904442738039e-21, -1.683319093930035e-24,  1.361090148577619e-26,  1.201196752766085e-28,  1.987247271008349e+00,
 -9.159416862905586e-05, -4.894251933068462e-07, -2.299634084826556e-09, -9.990903421658725e-12, -4.095488080998034e-14, -1.597240125976184e-16, -5.936976172443055e-19,
 -2.095950748021550e-21, -6.958454114666133e-24, -2.126532139007273e-26, -5.692910951013479e-29,  1.997572187956333e+00, -1.756332017673245e-05, -9.514982969270466e-08,
 -4.572926064040249e-10, -2.055303656566056e-12, -8.841672183221678e-15, -3.684978924703255e-17, -1.498354554392480e-19, -5.969337176387759e-22, -2.336278639508840e-24,
 -8.997352891569896e-27, -3.412529685456741e-29,  5.244593764808642e-04, -2.702923662088948e-06,  1.044519347025773e-08, -3.587011352507808e-11,  1.154394891832258e-13,
 -3.565086610252541e-16,  1.069833533872665e-18, -3.143183758696485e-21,  9.083941786869150e-24, -2.591130032888937e-26,  7.310480789725183e-29, -2.043858036915835e-31,
  4.718804707614013e-03, -2.428366918338548e-05,  9.354596407123003e-08, -3.195014378011538e-10,  1.019664694975723e-12, -3.111596753500616e-15,  9.187183157105321e-18,
 -2.642412489324822e-20,  7.432007961356024e-23, -2.048957561569617e-25,  5.542351356342003e-28, -1.471591525789652e-30,  1.310038336291722e-02, -6.721758487258555e-05,
  2.572954916807195e-07, -8.691255268105160e-10,  2.726597686659622e-12, -8.116073557926649e-15,  2.314849486921942e-17, -6.352997349554207e-20,  1.678141738186820e-22,
 -4.254418686877702e-25,  1.027513402012647e-27, -2.331359377225879e-30,  2.565487326851834e-02, -1.310488478502536e-04,  4.968162142072242e-07, -1.650038394162604e-09,
  5.039729958194364e-12, -1.441319575865989e-14,  3.878377113121099e-17, -9.781001208272380e-20,  2.278222018878165e-22, -4.733254606580174e-25,  7.956383403124790e-28,
 -6.589762163690062e-31,  4.236054500977173e-02, -2.150920844322578e-04,  8.048590262417057e-07, -2.611620669975815e-09,  7.680464325328670e-12, -2.070124539104563e-14,
  5.074038914712254e-17, -1.095755605568338e-19,  1.894358535873557e-22, -1.597081118383123e-25, -6.015050757855648e-28,  4.317184587271017e-30,  6.318796304343603e-02,
 -3.184305201328755e-04,  1.171886976458628e-06, -3.689071210460790e-09,  1.030707868120573e-11, -2.548447413961799e-14,  5.345651035996830e-17, -8.145237717027709e-20,
  1.034969126543245e-23,  5.690055146572730e-25, -2.972906747116285e-27,  1.066760746664353e-29,  8.809958196787013e-02, -4.399137152233715e-04,  1.586191887487290e-06,
 -4.805731943312414e-09,  1.253924378488702e-11, -2.725899571923661e-14,  4.228091417238227e-17, -3.961202242149860e-21, -3.060023535625320e-22,  1.554437640808453e-24,
 -5.307531446072814e-27,  1.384721040315507e-29,  1.170492333282142e-01, -5.781550729870186e-04,  2.034048199506723e-06, -5.876009682002611e-09,  1.398735390117922e-11,
 -2.472022768269752e-14,  1.459620915490512e-17,  1.198073820185157e-19, -6.971197090430597e-22,  2.419705487450792e-24, -6.002803558040073e-27,  8.647365313162438e-30,
  1.499814973939129e-01, -7.315293722201226e-04,  2.499909383345455e-06, -6.808894488723346e-09,  1.428564238362914e-11, -1.697500384181454e-14, -2.921955174004340e-17,
  2.715850521973181e-19, -1.044007411077575e-21,  2.654745722175454e-24, -3.508258269013079e-27, -7.460162689779242e-30,  1.868309533950474e-01, -8.981706521972953e-04,
  2.966653250958252e-06, -7.512062305033432e-09,  1.312770608885519e-11, -3.738162642925577e-15, -8.516776203534199e-17,  4.183982983118848e-19, -1.193041238806871e-21,
  1.789272253219014e-24,  2.777818968602683e-27, -3.102358755287587e-29,  2.275213008901217e-01, -1.075970870103965e-03,  3.415883351521821e-06, -7.896530262907903e-09,
  1.030264937614416e-11,  1.450943105583859e-14, -1.455087085337145e-16,  5.167817389599733e-19, -9.962987457430620e-22, -3.831324880319404e-25,  1.169482372382470e-26,
 -5.137514511787350e-29,  2.719643443297142e-01, -1.262579860754698e-03,  3.828294289054181e-06, -7.881804364802346e-09,  5.729585375752284e-12,  3.642638420126452e-14,
 -1.992844519422804e-16,  5.208189782937879e-19, -3.641912549396856e-22, -3.597723678400461e-24,  2.002423865650844e-26, -5.324297154698769e-29,  3.200588325727375e-01,
 -1.455407259070677e-03,  4.184109099509857e-06, -7.401418951136179e-09, -5.122827274093983e-13,  5.980505677624869e-14, -2.335669206499817e-16,  3.933174592276981e-19,
  6.814010819815368e-22, -7.016486944547220e-24,  2.309884742743756e-26, -2.367819215596761e-29,  3.716891452341792e-01, -1.651627199692602e-03,  4.463596594936403e-06,
 -6.408713451242798e-09, -8.161297154871540e-12,  8.167772513551242e-14, -2.354234236100374e-16,  1.184958280996452e-19,  1.969918050579008e-21, -9.317400068792584e-24,
  1.645847319285979e-26,  3.850295977978388e-29,  4.267238184677690e-01, -1.848186786788142e-03,  4.647675565676932e-06, -4.882622588264402e-09, -1.676245443189766e-11,
  9.855203122345164e-14, -1.944681695181206e-16, -2.863892079092095e-19,  3.179142991418203e-21, -9.025929962283755e-24, -1.743294522288444e-27,  1.150772240884170e-28,
  4.850139043408914e-01, -2.041819530494976e-03,  4.718610595088994e-06, -2.833170638929666e-09, -2.567204520037308e-11,  1.067827389975845e-13, -1.057149156148207e-16,
 -7.638194991086706e-19,  3.881939378364290e-21, -5.066594892714965e-24, -2.841177661319482e-26,  1.683599401670163e-28,  5.463911606350667e-01, -2.229065171740557e-03,
  4.660800561610558e-06, -3.062594657220137e-10, -3.408188094277442e-11,  1.030706883116987e-13,  2.772383092895237e-17, -1.216836172269084e-18,  3.648904858909692e-21,
  2.591082349943043e-24, -5.452203951678897e-26,  1.533821036218931e-28,  6.106660720744012e-01, -2.406297557371364e-03,  4.461655166047467e-06,  2.612772206558497e-09,
 -4.106666825035056e-11,  8.505733421533975e-14,  1.927044919657665e-16, -1.521016243638019e-18,  2.196777548741544e-21,  1.242673124389949e-23, -6.675489863331458e-26,
  4.207208620184993e-29,  6.776257101062664e-01, -2.569762469216832e-03,  4.112546437525579e-06,  5.797455728448769e-09, -4.565686512789787e-11,  5.195474444883818e-14,
  3.656044764744832e-16, -1.549011622469640e-18, -4.494884242165588e-22,  2.130618817138277e-23, -5.237964176020825e-26, -1.489080149029269e-28,  7.470314469878777e-01,
 -2.715627531369731e-03,  3.609810517518138e-06,  9.081105205862329e-09, -4.693713364984384e-11,  5.118497392372560e-15,  5.140639972593765e-16, -1.205962562864513e-18,
 -3.835557390928970e-21,  2.513092405094758e-23, -6.528562714720826e-27, -3.432486197815679e-28,  8.186165517163496e-01, -2.840046484435424e-03,  2.955759534357307e-06,
  1.226113983352309e-08, -4.416704485778920e-11, -5.156066487767363e-14,  6.014215350932446e-16, -4.697461687515633e-19, -7.065997121438822e-21,  2.027804781849233e-23,
  6.098282772636004e-26, -4.219499035992958e-28,  8.920837109978828e-01, -2.939240172005351e-03,  2.159643716600417e-06,  1.510761018134360e-08, -3.691585479478038e-11,
 -1.115930097424506e-13,  5.938874860555370e-16,  5.748517562936442e-19, -8.963508634332085e-21,  5.545977971731277e-24,  1.237429995840256e-25, -2.808996298658314e-28,
  9.671025387298391e-01, -3.009596460588649e-03,  1.238480184559804e-06,  1.737659030549673e-08, -2.519705474846150e-11, -1.663013914073161e-13,  4.697513719311258e-16,
  1.722780356899176e-18, -8.420312802150113e-21, -1.613555151484552e-23,  1.459850749928344e-25,  8.738499558644091e-29,  1.043307163051390e+00, -3.047790913009309e-03,
  2.176380899907749e-07,  1.882878277215820e-08, -9.581534696201830e-12, -2.058198812203701e-13,  2.289323386566121e-16,  2.671293129369487e-18, -4.884813234703612e-21,
 -3.731303684528054e-23,  9.984251631227263e-26,  5.359380310357943e-28,  1.120294011378187e+00, -3.050929235148190e-03, -8.689577139656585e-07,  1.925312341153220e-08,
  8.738226009256914e-12, -2.207026081670227e-13, -9.984262507153239e-17,  3.087682664341205e-18,  1.175626716132280e-21, -4.792114966022503e-23, -1.314815717475912e-26,
  7.925190726965593e-28,  1.197619951010809e+00, -3.016711174424053e-03, -1.979166199235460e-06,  1.849431581550561e-08,  2.796447004407159e-11, -2.040155820849422e-13,
 -4.576285326742109e-16,  2.717381487980325e-18,  8.080263907987631e-21, -3.966105024111538e-23, -1.492663346891953e-25,  6.077834531530192e-28,  1.274800985170327e+00,
 -2.943613515651005e-03, -3.063688103317485e-06,  1.648206071265069e-08,  4.582102899286742e-11, -1.535793562047215e-13, -7.627948202149888e-16,  1.506423603739970e-18,
  1.325429765549352e-20, -1.145716920340078e-23, -2.334910886449120e-25, -3.289903864552684e-29,  1.351311749751351e+00, -2.831086965822167e-03, -4.068010858724178e-06,
  1.325834088491771e-08,  5.981039950742422e-11, -7.380792390479383e-14, -9.289659887001790e-16, -3.098528554367075e-19,  1.415479730685444e-20,  2.705210555158842e-23,
 -1.993707693552592e-25, -7.905352553872851e-28,  1.426586101074309e+00, -2.679757980274710e-03, -4.935370029649367e-06,  8.997676488604464e-09,  6.759824927514821e-11,
  2.357378376960151e-14, -8.913471547706660e-16, -2.210509240083250e-18,  9.574520098326164e-21,  5.749890815075527e-23, -4.135422537485651e-26, -1.116880732160267e-27,
  1.500019123611708e+00, -2.491622030392404e-03, -5.610771997947727e-06,  4.014151569594054e-09,  6.748718522424254e-11,  1.206404379933240e-13, -6.346258389935176e-16,
 -3.526977143061354e-18,  7.113711399627370e-22,  6.163243483146730e-23,  1.589461589902139e-25, -6.661809711057394e-28,  1.570970910563597e+00, -2.270209744128971e-03,
 -6.045981225596748e-06, -1.251210339632093e-09,  5.889706638325763e-11,  1.966034630248339e-13, -2.112640785108554e-16, -3.703342426455760e-18, -8.796951663436858e-21,
  3.359999319849091e-23,  2.696253862143691e-25,  3.152544556458817e-28,  1.638772468079681e+00, -2.020702382626163e-03, -6.205174560734714e-06, -6.267795474953073e-09,
  4.272643115637585e-11,  2.331033409578096e-13,  2.620763154059841e-16, -2.586620740225445e-18, -1.435830938846969e-20, -1.264693271519561e-23,  2.035772902041443e-25,
  1.056450760169179e-27,  1.702734052631215e+00, -1.749969258716882e-03, -6.070717786909658e-06, -1.047901985589501e-08,  2.144768036874356e-11,  2.202430954177204e-13,
  6.369578012458111e-16, -5.887887005663977e-19, -1.300544032426448e-20, -4.910140568764754e-23,  3.376772310150508e-27,  9.084402844513091e-28,  1.762156156939573e+00,
 -1.466498352707276e-03, -5.648262774970954e-06, -1.338785961875746e-08, -1.189096570625558e-12,  1.612587299122729e-13,  7.889056509866284e-16,  1.427067118201607e-18,
 -5.563465034553971e-21, -5.250098686478365e-23, -1.744649347009406e-25,  3.195499621172137e-29,  1.816343202115077e+00, -1.180194171409657e-03, -4.970162130401815e-06,
 -1.465228975290036e-08, -2.088431754951965e-11,  7.342331410975623e-14,  6.750685415947741e-16,  2.555361177755928e-18,  3.412237896827920e-21, -2.324677653931877e-23,
 -1.912987122593554e-25, -6.918924312335950e-28,  1.864619768594318e+00, -9.020253449034883e-04, -4.096140171870203e-06, -1.417107855235839e-08, -3.384571958983172e-11,
 -1.638731119172764e-14,  3.625927851199826e-16,  2.361610892755925e-18,  8.506530413977299e-21,  1.349135402686036e-23, -5.955927323898496e-26, -6.049102611017813e-28,
  1.906348915088708e+00, -6.435193920121932e-04, -3.110335625743051e-06, -1.213587535475122e-08, -3.790401168602397e-11, -8.094386991755070e-14,  3.530174800396330e-18,
  1.164243528034977e-18,  7.349375800565770e-21,  2.932041779893160e-23,  7.320136352394382e-26, -3.304443790966298e-30,  1.940951820871356e+00, -4.161229553787804e-04,
 -2.114300762306454e-06, -9.027365209142107e-09, -3.330173853657140e-11, -1.035144422961395e-13, -2.407221918968394e-16, -1.701908753158820e-19,  2.309264622209964e-21,
  1.815547316426135e-23,  8.874824550556482e-26,  3.265950350040312e-28,  1.967927701638457e+00, -2.304700236682758e-04, -1.216284338547613e-06, -5.543568675526195e-09,
 -2.278804223163081e-11, -8.529077085106035e-14, -2.874187778165988e-16, -8.369598075702039e-19, -1.843342580897248e-21, -1.023432912746115e-24,  1.963837973603852e-26,
  1.551527208435742e-28,  1.986872884838229e+00, -9.562273377053847e-05, -5.180076497269004e-07, -2.466255391993507e-09, -1.084972148020475e-11, -4.499555592814252e-14,
 -1.773253902661865e-16, -6.649452754070454e-19, -2.362384534049311e-21, -7.860782229598150e-24, -2.389107065440736e-26, -6.241524366654379e-29,  1.997500376716756e+00,
 -1.834704166075228e-05, -1.008406452709608e-07, -4.916416508714567e-10, -2.241332371024145e-12, -9.778650622581030e-15, -4.132576501567397e-17, -1.703555389626129e-19,
 -6.878967790047904e-22, -2.728095673043305e-24, -1.064261830236970e-26, -4.087360637578248e-29,  5.138121224249640e-04, -2.621053013210764e-06,  1.002560344181738e-08,
 -3.407875736397031e-11,  1.085591134453611e-13, -3.318567605845837e-16,  9.857576867045285e-19, -2.866875284046130e-21,  8.201673953697495e-24, -2.315924151062867e-26,
  6.468273272605264e-29, -1.790315461626739e-31,  4.623142869608487e-03, -2.355036484405588e-05,  8.980781910524547e-08, -3.036729248837755e-10,  9.595791144667254e-13,
 -2.899720788042663e-15,  8.479523947086009e-18, -2.415974708994369e-20,  6.732775676732454e-23, -1.839689820843158e-25,  4.933580132046481e-28, -1.299306099288410e-30,
  1.283556472874606e-02, -6.520020947313265e-05,  2.471224782809561e-07, -8.267689440224424e-10,  2.569690845364489e-12, -7.581262809297561e-15,  2.144258928179559e-17,
 -5.839723867893459e-20,  1.532139632796205e-22, -3.863263567356645e-25,  9.298725933798694e-28, -2.110230575470650e-30,  2.513850344040728e-02, -1.271521707570118e-04,
  4.774902161577172e-07, -1.571659168644930e-09,  4.760556506508977e-12, -1.351444113702507e-14,  3.614463695570393e-17, -9.078625343054553e-20,  2.113480629112883e-22,
 -4.421115578488317e-25,  7.643442671866146e-28, -7.569568090827248e-31,  4.151285884163990e-02, -2.087765119693361e-04,  7.742434514619092e-07, -2.491980305470668e-09,
  7.278372110589416e-12, -1.951961390943635e-14,  4.775624534705281e-17, -1.036098917277846e-19,  1.832968557369623e-22, -1.802090339295534e-25, -4.292305763251442e-28,
  3.535671578196563e-30,  6.193271469252901e-02, -3.092297345012707e-04,  1.128591005417257e-06, -3.528166534653132e-09,  9.810034297725410e-12, -2.422883033611043e-14,
  5.118340148200885e-17, -8.081549808389370e-20,  2.880265634750736e-23,  4.590552483544450e-25, -2.534730014635158e-27,  9.277415167247360e-30,  8.636494570244224e-02,
 -4.274514856581781e-04,  1.529709059078752e-06, -4.609410404727114e-09,  1.200419680150198e-11, -2.624664097655390e-14,  4.204103874345662e-17, -1.289772507025436e-20,
 -2.537204079837184e-22,  1.353968384895477e-24, -4.724627837198504e-27,  1.265353300794316e-29,  1.147687165524894e-01, -5.621609687410449e-04,  1.964862618610794e-06,
 -5.656147126327104e-09,  1.349671146867349e-11, -2.433210531664626e-14,  1.765127562466641e-17,  9.884771241472456e-20, -6.142394212116670e-22,  2.187331736855065e-24,
 -5.613251561188863e-27,  9.010017209747828e-30,  1.470948664305571e-01, -7.118530644310791e-04,  2.419562751127100e-06, -6.583075794803392e-09,  1.393972643002184e-11,
 -1.758870831250224e-14, -2.206871464232596e-17,  2.396782806588590e-19, -9.510328697068823e-22,  2.508801704468184e-24, -3.766611550937015e-27, -4.392507621346696e-30,
  1.832851713542010e-01, -8.747944408283006e-04,  2.877765946844625e-06, -7.302724266089756e-09,  1.303342946004545e-11, -5.645860919811510e-15, -7.397727068255578e-17,
  3.812704771124128e-19, -1.126940793386790e-21,  1.874785921680639e-24,  1.538657183842025e-27, -2.542218824529513e-29,  2.232714753908011e-01, -1.049020013578033e-03,
  3.322123017588953e-06, -7.729551252462024e-09,  1.055906930669289e-11,  1.118724847483436e-14, -1.314866166108121e-16,  4.847654608477030e-19, -1.002200280596467e-21,
  4.117712166653491e-26,  9.563082011539777e-27, -4.555227509379229e-29,  2.669746808492509e-01, -1.232330220900272e-03,  3.734285889995943e-06, -7.784557711218857e-09,
  6.411458714671959e-12,  3.181712135496791e-14, -1.848830733896643e-16,  5.072426008452065e-19, -4.798522898360915e-22, -2.843136988441149e-24,  1.771858350346036e-26,
 -5.139622301064087e-29,  3.143035866948696e-01, -1.422289704781487e-03,  4.095281388036479e-06, -7.400347451170462e-09,  6.286661578108393e-13,  5.433384221950245e-14,
 -2.222854783981624e-16,  4.112569570570866e-19,  4.451687297690932e-22, -6.115413751852219e-24,  2.190835988148428e-26, -3.006175735410210e-29,  3.651535639459445e-01,
 -1.616228142889854e-03,  4.385961465246917e-06, -6.526531509532174e-09, -6.583940009875505e-12,  7.607419547604597e-14, -2.312725192892621e-16,  1.762964622316515e-19,
  1.646705502130477e-21, -8.630032013580128e-24,  1.779455991109583e-26,  2.266151639330304e-29,  4.194050568089754e-01, -1.811244159395725e-03,  4.587539114939283e-06,
 -5.135309644122869e-09, -1.483867756205865e-11,  9.379976368092662e-14, -2.011117000149940e-16, -1.898594909838193e-19,  2.854118581996913e-21, -9.000533631899196e-24,
  2.863084631868252e-27,  9.448661045922510e-29,  4.769218990222206e-01, -2.004213459342164e-03,  4.682218041885146e-06, -3.226982997396712e-09, -2.356342253970633e-11,
  1.040027987412753e-13, -1.253916541771768e-16, -6.427208831367902e-19,  3.680834610027693e-21, -6.058916643790181e-24, -2.130791918440091e-26,  1.541512897401085e-28,
  5.375494366007091e-01, -2.191802581127866e-03,  4.653921700132356e-06, -8.350534447395416e-10, -3.201650473882014e-11,  1.033404692108232e-13, -4.701773321767644e-18,
 -1.098986324038197e-18,  3.704574989123128e-21,  5.473449016448639e-25, -4.762266736499558e-26,  1.591877234808901e-28,  6.011124513010840e-01, -2.370489942262384e-03,
  4.489122944989040e-06,  1.969551642637471e-09, -3.932267941210468e-11,  8.917951915166335e-14,  1.511637968776023e-16, -1.444072655774675e-18,  2.596618595238453e-21,
  9.804006113772107e-24, -6.413664465967702e-26,  7.567148465183421e-29,  6.674128841547282e-01, -2.536596156513664e-03,  4.177768641315564e-06,  5.075720626851077e-09,
 -4.453354376909234e-11,  6.020785260141817e-14,  3.221431368971920e-16, -1.551539103159204e-18,  2.783894113800912e-22,  1.909610536858333e-23, -5.773149274479249e-26,
 -9.497518046962089e-29,  7.362273659864883e-01, -2.686325909002766e-03,  3.714283332825845e-06,  8.331588646892799e-09, -4.671419160613835e-11,  1.703779396647412e-14,
  4.787141978818467e-16, -1.314304119629151e-18, -2.939060862532014e-21,  2.458138653692575e-23, -2.059968952652597e-26, -2.954287600172853e-28,  8.073045727207012e-01,
 -2.815823960185764e-03,  3.098621673112525e-06,  1.154699674022733e-08, -4.505511149981480e-11, -3.730924293237942e-14,  5.852159665820283e-16, -6.837434491685683e-19,
 -6.296552914055875e-21,  2.234640182064910e-23,  4.247196283745535e-26, -4.168906846943596e-28,  8.803624383947484e-01, -2.921248062661497e-03,  2.337319987465663e-06,
  1.449988094450186e-08, -3.900404483400108e-11, -9.717875391959560e-14,  6.060043630916195e-16,  2.921438904713841e-19, -8.677917217337777e-21,  1.022897689311584e-23,
  1.099554909067761e-25, -3.428652991435266e-28,  9.550852791874734e-01, -2.998861645095602e-03,  1.444472619761452e-06,  1.694745760928537e-08, -2.840659447069678e-11,
 -1.544794484237690e-13,  5.141376646773757e-16,  1.445168744944089e-18, -8.895468221758825e-21, -1.025337999131969e-23,  1.472890535459198e-25, -2.710325144344013e-29,
  1.031120908507107e+00, -3.045148943675551e-03,  4.425288505009799e-07,  1.864287066110154e-08, -1.363702651691484e-11, -1.994468265992260e-13,  3.013439657397905e-16,
  2.494301961763419e-18, -6.150779638669423e-21, -3.287725339022725e-23,  1.211853155937426e-25,  4.314995954531057e-28,  1.108077857263853e+00, -3.056954706306343e-03,
 -6.372273683307067e-07,  1.935752186637439e-08,  4.307229678161951e-12, -2.220587147162800e-13, -1.312050755314868e-17,  3.097666834542033e-18, -5.506012364572079e-22,
 -4.775055313080879e-23,  2.159489782123578e-26,  7.811272953701652e-28,  1.185522855546711e+00, -3.031649484373145e-03, -1.754686331719968e-06,  1.890853447332243e-08,
  2.378063583557858e-11, -2.140577676003853e-13, -3.781444395784136e-16,  2.952007462192781e-18,  6.551790330169012e-21, -4.505867143683459e-23, -1.197179966201807e-25,
  7.307932830710997e-28,  1.262978782014136e+00, -2.967319658071788e-03, -2.861609099153887e-06,  1.718964499300895e-08,  4.257003352497745e-11, -1.713327915811035e-13,
 -7.147518907559927e-16,  1.922159910212860e-18,  1.267390930789007e-20, -2.076719931707122e-23, -2.305476105976768e-25,  1.677783054648241e-28,  1.339923344157585e+00,
 -2.862978503969929e-03, -3.903221612753669e-06,  1.420228461958862e-08,  5.811085458345987e-11, -9.615519125885502e-14, -9.311654706041384e-16,  1.570776026854914e-19,
  1.497706810680229e-20,  1.841790528826046e-23, -2.313611376123361e-25, -6.562979192427502e-28,  1.415788813051482e+00, -2.718790637137854e-03, -4.820896742155918e-06,
  1.008183756891561e-08,  6.785097519407661e-11,  1.475241239884798e-15, -9.486436837977840e-16, -1.871421914436940e-18,  1.160266672455965e-20,  5.484104630119500e-23,
 -9.197130961573451e-26, -1.176111572084356e-27,  1.489963194363558e+00, -2.536296992755767e-03, -5.556046558875716e-06,  5.112387947297757e-09,  6.973970674746119e-11,
  1.042290183720793e-13, -7.327205537575757e-16, -3.467547341130091e-18,  3.036894146164079e-21,  6.733578229464398e-23,  1.245360689390471e-25, -8.973352051857695e-28,
  1.561793263803481e+00, -2.318621335157864e-03, -6.055212863069706e-06, -2.777120248396314e-10,  6.276987370270357e-11,  1.902581850052409e-13, -3.187018772931342e-16,
 -3.963386118364793e-18, -7.390411343563539e-21,  4.460324342903154e-23,  2.789853454586782e-25,  1.022390155066085e-28,  1.630589916280481e+00, -2.070632655294240e-03,
 -6.276131483370166e-06, -5.546559857924199e-09,  4.744525993402148e-11,  2.384717860708730e-13,  1.831616999418333e-16, -3.051708435701719e-18, -1.465577923728184e-20,
 -3.570300374435066e-24,  2.502607888348669e-25,  1.057151303266942e-27,  1.695636256390284e+00, -1.799031820061708e-03, -6.194259014310199e-06, -1.009979395399808e-08,
  2.600382680982071e-11,  2.352835915967842e-13,  6.143801998296921e-16, -1.033137369480628e-18, -1.476048186235606e-20, -4.810703961683813e-23,  4.782764543859409e-26,
  1.112305219442574e-27,  1.756198773722062e+00, -1.512327143740233e-03, -5.808921444367787e-06, -1.338004183322771e-08,  2.228540416223523e-12,  1.806500481745272e-13,
  8.260773906638037e-16,  1.217454550199875e-18, -7.578316262615508e-21, -5.940028811709584e-23, -1.691528784751360e-25,  2.169820954139286e-28,  1.811541781396246e+00,
 -1.220664341451124e-03, -5.147943124062783e-06, -1.497378627546516e-08, -1.924797896877690e-11,  9.049507155318739e-14,  7.480106496259821e-16,  2.649625877772707e-18,
  2.430223971486608e-21, -3.151358532135847e-23, -2.221402996641250e-25, -7.052633578180895e-28,  1.860945038944396e+00, -9.354839058076322e-04, -4.269451524837979e-06,
 -1.471473617308262e-08, -3.408092660145622e-11, -6.860392470233064e-15,  4.325982395878954e-16,  2.641076643287002e-18,  8.942557996145658e-21,  1.053645693579097e-23,
 -8.920904073045933e-26, -7.453996209815500e-28,  1.903724135106875e+00, -6.689950318741062e-04, -3.259658291701678e-06, -1.275527438315843e-08, -3.951925978071467e-11,
 -8.044038906339043e-14,  3.958421781824388e-17,  1.416875799989867e-18,  8.457404777872456e-21,  3.222590814403546e-23,  7.154467573879609e-26, -7.594966076651949e-29,
  1.939252801160000e+00, -4.334798924689096e-04, -2.225895452106105e-06, -9.577070700238155e-09, -3.543014089167306e-11, -1.093399796068497e-13, -2.443496774200711e-16,
 -8.512289564620837e-20,  3.030332395501698e-21,  2.200476465469745e-23,  1.040133223961925e-25,  3.673424323856948e-28,  1.966985930758501e+00, -2.404727201375990e-04,
 -1.285052342734363e-06, -5.922206756812653e-09, -2.456477095217761e-11, -9.247673382014936e-14, -3.116838469839657e-16, -8.963705898756182e-19, -1.864291559259435e-21,
 -8.918028479234428e-26,  2.739264002988778e-26,  1.988975265976178e-28,  1.986481914086946e+00, -9.988819627902171e-05, -5.486747514562488e-07, -2.647287944315002e-09,
 -1.179374407060380e-11, -4.948359749949649e-14, -1.970460953473379e-16, -7.452592969638002e-19, -2.663250564900585e-21, -8.872933066064605e-24, -2.675505450445690e-26,
 -6.770671496609681e-29,  1.997425336854304e+00, -1.917799048646512e-05, -1.069621460000932e-07, -5.291231094332949e-10, -2.447223184929756e-12, -1.083028965320524e-14,
 -4.641926912363201e-17, -1.940254330261222e-19, -7.942250371855796e-22, -3.192064914024594e-24, -1.261545715808400e-26, -4.906373944198355e-29,  5.034857710736464e-04,
 -2.542454934155142e-06,  9.626865093409082e-09, -3.239364997129274e-11,  1.021522080729631e-13, -3.091329418361474e-16,  9.090376637613892e-19, -2.617277092522597e-21,
  7.412675810386096e-24, -2.072277784622206e-26,  5.730064112657352e-29, -1.570299575242978e-31,  4.530355618952118e-03, -2.284622192295064e-05,  8.625398498535035e-08,
 -2.887727827769410e-10,  9.035662228867189e-13, -2.704092417257164e-15,  7.832244743897535e-18, -2.210752533146361e-20,  6.104673382459181e-23, -1.653321572070057e-25,
  4.395828088449579e-28, -1.148290678000029e-30,  1.257865598786023e-02, -6.326222694486616e-05,  2.374430267184961e-07, -7.868394775459897e-10,  2.423082175319526e-12,
 -7.085720715576189e-15,  1.987406580239144e-17, -5.370991517643879e-20,  1.399539006061063e-22, -3.509277985281596e-25,  8.415218236993019e-28, -1.908857327687374e-30,
  2.463741695609226e-02, -1.234064140364441e-04,  4.590785503735588e-07, -1.497606293238075e-09,  4.498740381444016e-12, -1.267672429371632e-14,  3.369495476987824e-17,
 -8.427193737099163e-20,  1.959741548181183e-22, -4.122246617525546e-25,  7.295440873807074e-28, -8.197490735828496e-31,  4.068995405476405e-02, -2.027002289651604e-04,
  7.450257276295133e-07, -2.378588190302298e-09,  6.899209743655744e-12, -1.840762024893451e-14,  4.493628815597238e-17, -9.785121435420932e-20,  1.765359245479553e-22,
 -1.944686237041756e-25, -2.885322373189686e-28,  2.878628865537846e-30,  6.071358878899414e-02, -3.003677265202747e-04,  1.087178993367418e-06, -3.375016622888683e-09,
  9.337559018386238e-12, -2.302746396773269e-14,  4.893582053469595e-17, -7.964818945655699e-20,  4.359860237125316e-23,  3.654573241125805e-25, -2.154113586992904e-27,
  8.048698826938010e-30,  8.467926934702517e-02, -4.154318392828423e-04,  1.475531391539277e-06, -4.421488035672988e-09,  1.148932002415922e-11, -2.524286337437643e-14,
  4.157330953830208e-17, -2.027229803895830e-20, -2.082482284749016e-22,  1.175775468078866e-24, -4.193417384889280e-27,  1.150053738885744e-29,  1.125510857464109e-01,
 -5.467099285794484e-04,  1.898268555242375e-06, -5.444068960428570e-09,  1.301451867937053e-11, -2.387741173066934e-14,  2.015536570441933e-17,  8.040939822891553e-20,
 -5.394410298529292e-22,  1.970776263326495e-24, -5.213813948085390e-27,  9.108257627720503e-30,  1.442856721804756e-01, -6.928087853653461e-04,  2.341892359648889e-06,
 -6.362880921931624e-09,  1.358318194001449e-11, -1.804118209180342e-14, -1.577041714888168e-17,  2.106608888407165e-19, -8.634675204240051e-22,  2.355035299246748e-24,
 -3.903849989743230e-27, -1.939050495224194e-30,  1.798314878317478e-01, -8.521193081162215e-04,  2.791380435874384e-06, -7.095185641654076e-09,  1.290360162387223e-11,
 -7.297220818733614e-15, -6.379634799774375e-17,  3.462980290646999e-19, -1.058596587590141e-21,  1.915450684650786e-24,  5.302093829090022e-28, -2.052965804165096e-29,
  2.191279659346015e-01, -1.022811159917278e-03,  3.230388913850232e-06, -7.558983092536281e-09,  1.075233822226720e-11,  8.190830828784946e-15, -1.183614424449641e-16,
  4.527887764626946e-19, -9.943003333304977e-22,  3.852785133439669e-25,  7.682655052056288e-27, -3.997009061684086e-29,  2.621045194373214e-01, -1.202827801814134e-03,
  3.641506928968616e-06, -7.677119923326746e-09,  7.004570279031230e-12,  2.754853616924525e-14, -1.709096916271209e-16,  4.903820879934901e-19, -5.699862081466265e-22,
 -2.178882782326142e-24,  1.551372241595353e-26, -4.871002797647364e-29,  3.086793902994904e-01, -1.389882418633873e-03,  4.006572502737354e-06, -7.381881296573389e-09,
  1.662934696060952e-12,  4.913858536371608e-14, -2.106027542080879e-16,  4.221463365854788e-19,  2.404560385912622e-22, -5.266938075017296e-24,  2.048416486771410e-26,
 -3.435907574028876e-29,  3.587583283631966e-01, -1.581455401829828e-03,  4.307060265801262e-06, -6.620002475936597e-09, -5.117532091126830e-12,  7.058856299724479e-14,
 -2.256442105307677e-16,  2.241592160090211e-19,  1.349039190492224e-21, -7.902395068861517e-24,  1.849067446696317e-26,  9.394182631062268e-30,  4.122330850014648e-01,
 -1.774794236595836e-03,  4.524551940012063e-06, -5.357984398193410e-09, -1.301132762697264e-11,  8.891931217578290e-14, -2.051976285550905e-16, -1.036821167778001e-19,
  2.533109916746341e-21, -8.808641267124294e-24,  6.591211543596100e-27,  7.522584207842850e-29,  4.689797065815076e-01, -1.966916862449367e-03,  4.641300253397644e-06,
 -3.587526702829156e-09, -2.151485034103666e-11,  1.007905476207197e-13, -1.417727131521897e-16, -5.285756168362073e-19,  3.448964567096389e-21, -6.780210557545879e-24,
 -1.487401164869679e-26,  1.380693459286151e-28,  5.288566134719820e-01, -2.154619841594727e-03,  4.640895631183532e-06, -1.330799397837504e-09, -2.995324701960090e-11,
  1.028717683918975e-13, -3.381332020652486e-17, -9.804785692920060e-19,  3.691683386314398e-21, -1.217083665522943e-24, -4.059864045516458e-26,  1.592211753014186e-28,
  5.917024522654168e-01, -2.334492979226449e-03,  4.509042047327845e-06,  1.354841038057176e-09, -3.750603502902485e-11,  9.233193982605223e-14,  1.119426170429486e-16,
 -1.355821874599939e-18,  2.904262422754378e-21,  7.313324158149044e-24, -6.020824288335069e-26,  1.016555121271403e-28,  6.573337126048266e-01, -2.502942391745054e-03,
  4.234443126253669e-06,  4.373222513047987e-09, -4.325558341545857e-11,  6.741959649718067e-14,  2.789248881363596e-16, -1.532084246157693e-18,  9.234119475990617e-22,
  1.671819201254144e-23, -6.080396547556193e-26, -4.553761118786485e-29,  7.255421061854660e-01, -2.656224402454971e-03,  3.809791066601931e-06,  7.587499178575467e-09,
 -4.626157663910662e-11,  2.807551226391873e-14,  4.407287410696615e-16, -1.394378745180809e-18, -2.071958444018185e-21,  2.351251383734151e-23, -3.246503029654576e-26,
 -2.434462844929950e-28,  7.960917150287538e-01, -2.790493037733707e-03,  3.232838172392547e-06,  1.082090168974300e-08, -4.566250973243321e-11, -2.351581169900488e-14,
  5.633733641556247e-16, -8.720693446052520e-19, -5.465881721780371e-21,  2.368318005553169e-23,  2.450897028812931e-26, -3.974316591871729e-28,  8.687159300890356e-01,
 -2.901864260142736e-03,  2.507512598530779e-06,  1.386106007752903e-08, -4.080167690381753e-11, -8.256749834862269e-14,  6.103579210326785e-16,  2.116090171546380e-20,
 -8.234273643854034e-21,  1.431126042125602e-23,  9.384011358988365e-26, -3.866030459667705e-28,  9.431142209636438e-01, -2.986500343153008e-03,  1.645015329475125e-06,
  1.646891899685451e-08, -3.136968029500748e-11, -1.416870342952268e-13,  5.505698122699667e-16,  1.155740626749277e-18, -9.159121519348525e-21, -4.417631253454424e-24,
  1.437261586847756e-25, -1.330618883497289e-28,  1.018948804419231e+00, -3.040717864840995e-03,  6.648038457485618e-07,  1.839318302904563e-08, -1.754810288219380e-11,
 -1.913997864798267e-13,  3.682578149565165e-16,  2.279510389719856e-18, -7.242838876018830e-21, -2.768401370008563e-23,  1.376186395278690e-25,  3.137932428367881e-28,
  1.095841315181405e+00, -3.061122530131141e-03, -4.046701456118169e-07,  1.939092047142678e-08, -1.300850324693723e-13, -2.213363625753221e-13,  7.311064354406831e-17,
  3.052776617951657e-18, -2.245883419896086e-21, -4.621010969957024e-23,  5.510365488432480e-26,  7.367411801470063e-28,  1.173369628375460e+00, -3.044773225469497e-03,
 -1.525643774637453e-06,  1.925431081336389e-08,  1.941553693532806e-11, -2.221191986526382e-13, -2.928031021005744e-16,  3.134851447968324e-18,  4.851504374742754e-21,
 -4.917468090429559e-23, -8.540910161949251e-26,  8.231651486444797e-28,  1.251065040045311e+00, -2.989376115243292e-03, -2.651362682810314e-06,  1.784243936029797e-08,
  3.897643038645049e-11, -1.877959163828707e-13, -6.553784821078896e-16,  2.314001290205756e-18,  1.176261893919939e-20, -2.978175184559113e-23, -2.187081953835461e-25,
  3.696833377609676e-28,  1.328410080081482e+00, -2.893506915091089e-03, -3.727282944500503e-06,  1.511546169948416e-08,  5.596490955167004e-11, -1.183956799508908e-13,
 -9.199709407279193e-16,  6.451127782295081e-19,  1.546701390784955e-20,  8.634874267570356e-24, -2.565078026651734e-25, -4.803019484985372e-28,  1.404837308422214e+00,
 -2.756855433286388e-03, -4.693404077933913e-06,  1.116643514123514e-08,  6.764878562108853e-11, -2.187725335918855e-14, -9.955543536563772e-16, -1.469359829025414e-18,
  1.349818911389049e-20,  5.012090129511937e-23, -1.440943925238183e-25, -1.184031074009394e-27,  1.479729525169980e+00, -2.580480849347555e-03, -5.487937285178865e-06,
  6.243911646118934e-09,  7.164063616176702e-11,  8.549188282900696e-14, -8.280805419105285e-16, -3.330701109844810e-18,  5.540528381888370e-21,  7.146139409864808e-23,
  8.013663458959027e-26, -1.117855018088227e-27,  1.552421898432204e+00, -2.367059008530778e-03, -6.052395379496951e-06,  7.565934842882059e-10,  6.648942845745784e-11,
  1.812524793102582e-13, -4.327308149360842e-16, -4.172029560869706e-18, -5.583400951682689e-21,  5.577951627561002e-23,  2.779398029953472e-25, -1.569425395752960e-28,
  1.622206564715672e+00, -2.121094673042930e-03, -6.337977373335932e-06, -4.749071376887483e-09,  5.225145905630978e-11,  2.417892500907162e-13,  9.114305050486373e-17,
 -3.520727499416787e-18, -1.459301324132608e-20,  7.358479754385790e-24,  2.957730101595018e-25,  1.001346213878999e-27,  1.688340263844938e+00, -1.849063246461802e-03,
 -6.312802321302021e-06, -9.645297014675324e-09,  3.085432415558428e-11,  2.496266237386879e-13,  5.785825067546790e-16, -1.532713916658896e-18, -1.644556235769907e-20,
 -4.515569170874169e-23,  1.011920867860248e-25,  1.311479372310631e-27,  1.750055506747478e+00, -1.559439869498126e-03, -5.969145257678408e-06, -1.331439290254918e-08,
  6.042410963771726e-12,  2.008555450411219e-13,  8.564403746373766e-16,  9.394504857092930e-19, -9.835632642745108e-21, -6.591074270077431e-23, -1.546835411693761e-25,
  4.485227199107829e-28,  1.806575611730963e+00, -1.262571719619648e-03, -5.329413409733034e-06, -1.526627395312960e-08, -1.725250489074957e-11,  1.093452780478905e-13,
  8.231057854911392e-16,  2.707465741093803e-18,  1.128340031847020e-21, -4.101657378896028e-23, -2.528591174426132e-25, -6.844771774863796e-28,  1.857133660680767e+00,
 -9.703551019902984e-04, -4.449302758323332e-06, -1.526053882434616e-08, -3.410815240065739e-11,  4.442027546747692e-15,  5.106063802413549e-16,  2.932551998896790e-18,
  9.249330908494460e-21,  6.267495609318911e-24, -1.253674657615591e-25, -9.002697939361526e-28,  1.900995015709767e+00, -6.956954224815552e-04, -3.416568318480954e-06,
 -1.340038733129679e-08, -4.111519120321956e-11, -7.898262407251798e-14,  8.322395640317731e-17,  1.706619080904030e-18,  9.668001016787282e-21,  3.499373859729069e-23,
  6.612350348495522e-26, -1.753610169548762e-28,  1.937482525578614e+00, -4.517565607477809e-04, -2.344294792272745e-06, -1.016176658678786e-08, -3.767571762104712e-11,
 -1.152212540048865e-13, -2.452505282737902e-16,  2.535779905682272e-20,  3.901397594302497e-21,  2.650048516117835e-23,  1.210648887536457e-25,  4.074142660658625e-28,
  1.966003019331179e+00, -2.510442296695794e-04, -1.358539416632696e-06, -6.330454459886849e-09, -2.649117754387553e-11, -1.002650629099655e-13, -3.376162975650729e-16,
 -9.558498069777243e-19, -1.845533679087724e-21,  1.196712767774790e-24,  3.729764407881511e-26,  2.532529569809389e-28,  1.986073376681813e+00, -1.044079489307697e-04,
 -5.816079175270322e-07, -2.844169445135376e-09, -1.283244838222065e-11, -5.447304390541748e-14, -2.191560190090096e-16, -8.358065881532036e-19, -3.002671013754650e-21,
 -1.000416278312934e-23, -2.984082543809290e-26, -7.242016738231509e-29,  1.997346872322721e+00, -2.005976807311439e-05, -1.135539059796197e-07, -5.700739576497010e-10,
 -2.675424958348906e-12, -1.201252634578669e-14, -5.222578913678905e-17, -2.213810419691596e-19, -9.187679428846170e-22, -3.742650154153978e-24, -1.498631565959525e-26,
 -5.902595467969692e-29,  4.934675578776207e-04, -2.466967585508375e-06,  9.247747650823368e-09, -3.080751497061970e-11,  9.618191795057776e-14, -2.881693126083735e-16,
  8.389657095482343e-19, -2.391578588013524e-21,  6.706300487331224e-24, -1.856311652800450e-26,  5.082162702494730e-29, -1.379111731324214e-31,  4.440329189921349e-03,
 -2.216980941152320e-05,  8.287370176617872e-08, -2.747383713118129e-10,  8.513150913505118e-13, -2.523331307607857e-15,  7.239711827973409e-18, -2.024596398471547e-20,
  5.539946812554097e-23, -1.487190849832536e-25,  3.920355124093354e-28, -1.015798473993668e-30,  1.232934728518079e-02, -6.139980255211319e-05,  2.282289748736505e-07,
 -7.491784646343614e-10,  2.286018289468858e-12, -6.626295039515194e-15,  1.843103368589785e-17, -4.942718917845732e-20,  1.279066585173237e-22, -3.188915691615548e-25,
  7.616224023096263e-28, -1.725847835806095e-30,  2.415102444114113e-02, -1.198044660652364e-04,  4.415309274590059e-07, -1.427611574494139e-09,  4.253105160865192e-12,
 -1.189566562029449e-14,  3.142094572666544e-17, -7.823264505517547e-20,  1.816505322159097e-22, -3.837764315998990e-25,  6.926110913426439e-28, -8.550415327874499e-31,
  3.989089539072467e-02, -1.968523463956696e-04,  7.171330317449524e-07, -2.271088376866297e-09,  6.541623392662450e-12, -1.736139552980902e-14,  4.227447528749393e-17,
 -9.231606869235307e-20,  1.693562813471777e-22, -2.036460306732204e-25, -1.743497484750802e-28,  2.327579282877478e-30,  5.952925978553687e-02, -2.918297901460945e-04,
  1.047560206072553e-06, -3.229237015783796e-09,  8.888574558112266e-12, -2.187959683520807e-14,  4.672706661056154e-17, -7.805848768678167e-20,  5.528644156979032e-23,
  2.860469359579160e-25, -1.824287642394274e-27,  6.966293937296612e-30,  8.304081882082234e-02, -4.038367324991485e-04,  1.423560024590487e-06, -4.241643767881069e-09,
  1.099439064347647e-11, -2.425263048547028e-14,  4.091852811391352e-17, -2.629039775911805e-20, -1.688206091111727e-22,  1.017831859471327e-24, -3.711755533599053e-27,
  1.040332186313459e-29,  1.103942095296804e-01, -5.317815916177779e-04,  1.834173449563907e-06, -5.239630033609499e-09,  1.254198029297589e-11, -2.336855187847776e-14,
  2.217554268295468e-17,  6.424298485580979e-20, -4.721505826606900e-22,  1.770221453257758e-24, -4.814679267720536e-27,  9.005735608313588e-30,  1.415514289174494e-01,
 -6.743753976933917e-04,  2.266829805604181e-06, -6.148455214339486e-09,  1.321903536896946e-11, -1.835193508632639e-14, -1.024621591214043e-17,  1.843561607161339e-19,
 -7.815120263262337e-22,  2.197778273137350e-24, -3.944947154329859e-27, -8.110709111310188e-33,  1.764671383918464e-01, -8.301253353765519e-04,  2.707471877132815e-06,
 -6.889975532734648e-09,  1.274311197562860e-11, -8.715741098578304e-15, -5.456386870136162e-17,  3.135286424080344e-19, -9.894644663416426e-22,  1.919884449585381e-24,
 -2.777138607735204e-28, -1.629895772800651e-29,  2.150878371789139e-01, -9.973279436904781e-04,  3.140718258821373e-06, -7.385785245320116e-09,  1.088875649795416e-11,
  5.498712701944134e-15, -1.061263147314154e-16,  4.212490508958010e-19, -9.753082819110085e-22,  6.589826500667403e-25,  6.040791729123652e-27, -3.472067533516816e-29,
  2.573508916229806e-01, -1.174062302446737e-03,  3.550071401411428e-06, -7.560857268843575e-09,  7.515623918799456e-12,  2.360934258238844e-14, -1.574453092358002e-16,
  4.710031213000368e-19, -6.377642677753138e-22, -1.600273521457491e-24,  1.344048269836494e-26, -4.545375724077427e-29,  3.031834054968377e-01, -1.358183643669541e-03,
  3.918181121803343e-06, -7.347682761482269e-09,  2.596122940751052e-12,  4.422666030097648e-14, -1.987023270952487e-16,  4.269623000005181e-19,  6.522242063994448e-23,
 -4.478674253768935e-24,  1.891047028296337e-26, -3.691187489348249e-29,  3.525009147738743e-01, -1.547317966397094e-03,  4.227174594374561e-06, -6.690880840922950e-09,
 -3.759382934593277e-12,  6.525303982131880e-14, -2.188051292870564e-16,  2.629200425879606e-19,  1.077934962891652e-21, -7.157862139772971e-24,  1.865702855310146e-26,
 -1.447946957940562e-30,  4.052058888589569e-01, -1.738858409993291e-03,  4.459064857464381e-06, -5.552206953977625e-09, -1.128237786286084e-11,  8.396860058764313e-14,
 -2.070131682464769e-16, -2.763933850527686e-20,  2.221493651636644e-21, -8.484100785437475e-24,  9.507691683220862e-27,  5.763810639316646e-29,  4.611860192224744e-01,
 -1.929964361766761e-03,  4.596250417028890e-06, -3.915827502874792e-09, -1.953420016611473e-11,  9.722264320016996e-14, -1.550651400959471e-16, -4.222173933828433e-19,
  3.195586568670747e-21, -7.258645703281052e-24, -9.172012270400041e-27,  1.210195307461861e-28,  5.203122759986398e-01, -2.117564546166291e-03,  4.622118254307864e-06,
 -1.793645054393599e-09, -2.790608179534675e-11,  1.017441056824454e-13, -5.962158830481207e-17, -8.633455174689723e-19,  3.620316536205354e-21, -2.701986427235410e-24,
 -3.368072098853125e-26,  1.545389019768532e-28,  5.824367137730204e-01, -2.298365670889905e-03,  4.521760937541310e-06,  7.696508456071079e-10, -3.563554976105255e-11,
  9.457373517414180e-14,  7.531703247300005e-17, -1.259128691043117e-18,  3.125325814495017e-21,  5.000468207049422e-24, -5.529838012830895e-26,  1.203616533967336e-28,
  6.473900100206310e-01, -2.468868592804393e-03,  4.282814895822025e-06,  3.692269513482307e-09, -4.184370472422612e-11,  7.360289181280660e-14,  2.365273312719753e-16,
 -1.493377905454058e-18,  1.481127168251598e-21,  1.425927862764906e-23, -6.182306275723878e-26, -1.800136843825324e-30,  7.149787241790897e-01, -2.625394410768214e-03,
  3.896420300290388e-06,  6.852367345235720e-09, -4.559748938304732e-11,  3.817777124768331e-14,  4.008832449364760e-16, -1.447408849612011e-18, -1.251321241441824e-21,
  2.201539748117310e-23, -4.200096435861424e-26, -1.899608495839093e-28,  7.849822731015367e-01, -2.764123380289868e-03,  3.358292227470390e-06,  1.008726499547932e-08,
 -4.599969299373042e-11, -1.030683716339424e-14,  5.366360341200413e-16, -1.033180552671330e-18, -4.599779585770180e-21,  2.432225249231879e-23,  7.673205834146200e-27,
 -3.660956159464459e-28,  8.571496308638102e-01, -2.881150046859685e-03,  2.669876441356000e-06,  1.319581802616836e-08, -4.230664474715921e-11, -6.794107219821605e-14,
  6.073438937345284e-16, -2.334019469979832e-19, -7.655685251225339e-21,  1.771587083759694e-23,  7.620575739648549e-26, -4.119685171610539e-28,  9.311957791501885e-01,
 -2.972558455606063e-03,  1.839539708918719e-06,  1.594506253498241e-08, -3.406883465199720e-11, -1.281182569276402e-13,  5.788111910184837e-16,  8.612005724845444e-19,
 -9.216345528428315e-21,  1.185840279787021e-24,  1.357682591393286e-25, -2.262592128054125e-28,  1.006797960585332e+00, -3.034521622075606e-03,  8.837127140177145e-07,
  1.808229084361780e-08, -2.128268592820243e-11, -1.818227558038337e-13,  4.286972084517462e-16,  2.032880803652186e-18, -8.137381377687743e-21, -2.193953840770492e-23,
  1.486963109507917e-25,  1.891146051001234e-28,  1.083591823555952e+00, -3.063429498164788e-03, -1.721372822832888e-07,  1.935354952597572e-08, -4.532390465671562e-12,
 -2.185656156759887e-13,  1.573355385197977e-16,  2.954778983273398e-18, -3.862137567744451e-21, -4.337750319864444e-23,  8.598372846538310e-26,  6.622689714020472e-28,
  1.161167595508306e+00, -3.056049227673945e-03, -1.292875906545327e-06,  1.952906865553903e-08,  1.491007370433265e-11, -2.280772775199112e-13, -2.031242055343967e-16,
  3.261187670467583e-18,  3.028631454958158e-21, -5.184727360382085e-23, -4.780797745058631e-26,  8.797611487034556e-28,  1.239066484390553e+00, -3.009720268917144e-03,
 -2.433638324788110e-06,  1.843518306756746e-08,  3.506868477684280e-11, -2.027060120632846e-13, -5.854898078880109e-16,  2.671597665110013e-18,  1.053745269831434e-20,
 -3.814711408196741e-23, -1.981589539380167e-25,  5.618621594466176e-28,  1.316777585912579e+00, -2.922584601750960e-03, -3.540606780686212e-06,  1.599076445208343e-08,
  5.337795604812845e-11, -1.402020804389244e-13, -8.949461690463841e-16,  1.143012872337833e-18,  1.558863165696004e-20, -1.988228790221562e-24, -2.731087107403915e-25,
 -2.691994677811549e-28,  1.393735666795479e+00, -2.793848318306961e-03, -4.552931253089565e-06,  1.224400405853164e-08,  6.696923417701270e-11, -4.621382836118683e-14,
 -1.030386504469750e-15, -1.009761913383693e-18,  1.518632462926092e-20,  4.332552085862226e-23, -1.953111665807839e-25, -1.134073016609653e-27,  1.469320296985615e+00,
 -2.624065030840624e-03, -5.406080003227118e-06,  7.402729391743629e-09,  7.314429415945335e-11,  6.452126556174077e-14, -9.184674315447202e-16, -3.111723608571910e-18,
  8.158435402044373e-21,  7.362342330859951e-23,  2.654467328489130e-26, -1.312587379766202e-27,  1.542856907463424e+00, -2.415423498315871e-03, -6.036815583116059e-06,
  1.848820398871314e-09,  7.000106429408806e-11,  1.694468799775788e-13, -5.517319327321438e-16, -4.316442258148475e-18, -3.377658195318560e-21,  6.667367083012647e-23,
  2.645925351138694e-25, -4.554439908984052e-28,  1.613620438005974e+00, -2.172011866937266e-03, -6.389790217753927e-06, -3.874277364170117e-09,  5.710086200883308e-11,
  2.427412790376081e-13, -1.391839532852899e-17, -3.981097647682609e-18, -1.410480615044605e-20,  2.003960513281340e-23,  3.373892881249439e-25,  8.784705615805065e-28,
  1.680842285333770e+00, -1.900019862655387e-03, -6.425416715340859e-06, -9.110948777057525e-09,  3.598192663905184e-11,  2.629366735985790e-13,  5.280607622679836e-16,
 -2.084084195185577e-18, -1.798389877106123e-20, -3.989898449799142e-23,  1.629559888873843e-25,  1.491432741559410e-27,  1.743721231783493e+00, -1.607830166285198e-03,
 -6.128201695958067e-06, -1.318445236646102e-08,  1.026700496404803e-11,  2.216879696400836e-13,  8.779736483942713e-16,  5.855947395239444e-19, -1.231432540395520e-20,
 -7.162474802362683e-23, -1.289871689399375e-25,  7.271345864686734e-28,  1.801438887604215e+00, -1.305944327422217e-03, -5.514189222393983e-06, -1.552371962664022e-08,
 -1.486189837111805e-11,  1.300121698568653e-13,  8.991840865608775e-16,  2.717936976326301e-18, -5.374350682072472e-22, -5.171737540459534e-23, -2.816954268606754e-25,
 -6.176006668894194e-28,  1.853179878544714e+00, -1.006691296119111e-03, -4.635698440571244e-06, -1.580486418569518e-08, -3.388994168669413e-11,  1.771553563303208e-14,
  5.968880930959513e-16,  3.231092483704700e-18,  9.374713284974073e-21,  4.125087398712079e-25, -1.685853443858034e-25, -1.065397042903182e-27,  1.898156534551783e+00,
 -7.236824902185591e-04, -3.581371755866370e-06, -1.407074219530234e-08, -4.267081364272785e-11, -7.637568374617154e-14,  1.355334828800935e-16,  2.036644762764108e-18,
  1.097319880050708e-20,  3.744804163505267e-23,  5.562937312137251e-26, -3.075862344893702e-28,  1.935637203623692e+00, -4.710091088891206e-04, -2.469929940875785e-06,
 -1.078333276921446e-08, -4.003886854189371e-11, -1.210837232015851e-13, -2.426423933408900e-16,  1.664371587504788e-19,  4.947003939492883e-21,  3.171273412260442e-23,
  1.398140149110331e-25,  4.439326265214763e-28,  1.964976614290094e+00, -2.622237677258512e-04, -1.437115649379577e-06, -6.770805181444398e-09, -2.857970886197382e-11,
 -1.086956423746452e-13, -3.651982301351259e-16, -1.013906740342880e-18, -1.772743141661956e-21,  2.930243242148657e-24,  4.986793668699729e-26,  3.204410839377474e-28,
  1.985646217963320e+00, -1.092009075263410e-04, -6.170067660580613e-07, -3.058498242288913e-09, -1.397645987079369e-11, -6.002481820407400e-14, -2.439596215114938e-16,
 -9.378911334908195e-19, -3.385084930873653e-21, -1.126268346400340e-23, -3.311131641731763e-26, -7.599199318774874e-29,  1.997264772010306e+00, -2.099630929871592e-05,
 -1.206597890425527e-07, -6.148730325825305e-10, -2.928729480573651e-12, -1.334378034136583e-14, -5.885717682289649e-17, -2.530583572795802e-19, -1.064950067961314e-21,
 -4.397446020454138e-24, -1.784187475319359e-26, -7.117095186227416e-29,  4.837453464920455e-04, -2.394438634559624e-06,  8.887104226167556e-09, -2.931363970145807e-11,
  9.061458212566814e-14, -2.688140597467633e-16,  7.749081981028132e-19, -2.187288547347235e-21,  6.073203870228109e-24, -1.664654884790159e-26,  4.512788508531065e-29,
 -1.212748948785405e-31,  4.352955373311647e-03, -2.151977945658312e-05,  7.965693222298819e-08, -2.615118114750164e-10,  8.025410928906359e-13, -2.356185384070362e-15,
  6.696860012247885e-18, -1.855590197029191e-20,  5.031739889268592e-23, -1.338962247362167e-25,  3.499546538564925e-28, -8.994517493681667e-31,  1.208734366575281e-02,
 -5.960931944057524e-05,  2.194539942858262e-07, -7.136388075008139e-10,  2.157806081958186e-12, -6.200105657157551e-15,  1.710268980501591e-17, -4.551212343914822e-20,
  1.169570871565742e-22, -2.898953642542233e-25,  6.893969817214774e-28, -1.559811747369690e-30,  2.367876418292421e-02, -1.163396049754000e-04,  4.248001662363919e-07,
 -1.361424958625266e-09,  4.022558784997839e-12, -1.116720481987048e-14,  2.930977179881922e-17, -7.263561023491898e-20,  1.683241413735479e-22, -3.568299089412749e-25,
  6.546135284061104e-28, -8.690588113509884e-31,  3.911479000857030e-02, -1.912225410977274e-04,  6.904966847395932e-07, -2.169145967871212e-09,  6.204335119316058e-12,
 -1.637722074707966e-14,  3.976438636743298e-17, -8.701512206379281e-20,  1.619228726847804e-22, -2.087134752991626e-25, -8.237835546611257e-29,  1.866601582093239e-30,
  5.837845953609656e-02, -2.836019270467816e-04,  1.009648419860402e-06, -3.090460365655833e-09,  8.462021152527936e-12, -2.078416594657614e-14,  4.456764834482159e-17,
 -7.613805994368284e-20,  6.434186791343847e-23,  2.189168715168745e-25, -1.539138181811387e-27,  6.015602534612893e-30,  8.144793065997169e-02, -3.926488972476501e-04,
  1.373699926272052e-06, -4.069560841546128e-09,  1.051909583898518e-11, -2.327999698519528e-14,  4.011207464919266e-17, -3.113416407060429e-20, -1.347436286285609e-22,
  8.782078896394543e-25, -3.276958449051733e-27,  9.371531723743723e-30,  1.082960364960499e-01, -5.173563301736537e-04,  1.772486591292737e-06, -5.042667818696576e-09,
  1.208006851028911e-11, -2.281640293280094e-14,  2.377214270771701e-17,  5.011741582648297e-20, -4.117942546898808e-22,  1.585494623666681e-24, -4.423496802441430e-27,
  8.754514820467040e-30,  1.388897343602025e-01, -6.565323174944634e-04,  2.194305219545458e-06, -5.939898613961166e-09,  1.284994139656540e-11, -1.853865452712922e-14,
 -5.422683416491447e-18,  1.605832690645390e-19, -7.052281410847476e-22,  2.040441337937320e-24, -3.911051632603552e-27,  1.482468949148203e-30,  1.731894378375579e-01,
 -8.087928267542348e-04,  2.626009534625085e-06, -6.687548489746223e-09,  1.255639468763353e-11, -9.923442474173139e-15, -4.621797945900266e-17,  2.829681533960455e-19,
 -9.207112448529454e-22,  1.895541363189196e-24, -9.130591443029518e-28, -1.267588833807229e-29,  2.111482197678078e-01, -9.725537460913207e-04,  3.053137348179599e-06,
 -7.210819788897118e-09,  1.097419770160170e-11,  3.089717630087656e-15, -9.476439739186376e-17,  3.904624945265186e-19, -9.475903713021110e-22,  8.715198079479255e-25,
  4.621452460178419e-27, -2.986264550503013e-29,  2.527108718621232e-01, -1.146022573560229e-03,  3.460077543349067e-06, -7.437030658199579e-09,  7.951080000084528e-12,
  1.998655643635483e-14, -1.445508835009597e-16,  4.497728177717103e-19, -6.861695035875751e-22, -1.101611137637284e-24,  1.151891456965666e-26, -4.184859936119896e-29,
  2.978128044796640e-01, -1.327190111760917e-03,  3.830286517857333e-06, -7.299323569549721e-09,  3.433936544202837e-12,  3.960135578940534e-14, -1.867413793398032e-16,
  4.266124858568420e-19, -8.278976632233414e-23, -3.755162784349153e-24,  1.725692985863159e-26, -3.803867486158833e-29,  3.463787678796965e-01, -1.513822657131016e-03,
  4.146565273296517e-06, -6.740873233267417e-09, -2.506219913730619e-12,  6.009372270978835e-14, -2.109981662301346e-16,  2.934347764327249e-19,  8.336448608463545e-22,
 -6.415545346356394e-24,  1.839607901070640e-26, -1.006474262434693e-29,  3.983213741226044e-01, -1.703455339996420e-03,  4.391409810215695e-06, -5.719560091053306e-09,
 -9.652711369877956e-12,  7.899875117959473e-14, -2.068372059058604e-16,  3.863968838039021e-20,  1.923479125209246e-21, -8.057836104104451e-24,  1.169111727121224e-26,
  4.192898550608212e-29,  4.535393968712127e-01, -1.893387485007530e-03,  4.547448705238746e-06, -4.213025102295821e-09, -1.762786183866738e-11,  9.337052630385441e-14,
 -1.654953341174943e-16, -3.242003001932848e-19,  2.928908431242733e-21, -7.524117500888275e-24, -4.227395683309582e-27,  1.037542794722170e-28,  5.119158248762943e-01,
 -2.080681131442613e-03,  4.597982407177885e-06, -2.223949037526839e-09, -2.588739968825244e-11,  1.000360956858185e-13, -8.218976151537870e-17, -7.492985761063632e-19,
  3.500413778841300e-21, -3.915448978647515e-24, -2.705340815965166e-26,  1.461789739192406e-28,  5.733156442641326e-01, -2.262164188687036e-03,  4.527638439457240e-06,
  2.147002788669478e-10, -3.372879561645851e-11,  9.596972922538029e-14,  4.148565522943564e-17, -1.156654291696125e-18,  3.266841380526306e-21,  2.898448646352195e-24,
 -4.971520269720670e-26,  1.323730817961104e-28,  6.375833253821859e-01, -2.434440112378771e-03,  4.323154672729459e-06,  3.034841017530246e-09, -4.031823767958626e-11,
  7.878358580900177e-14,  1.954500658964117e-16, -1.438245225418106e-18,  1.950034701291816e-21,  1.179623148418256e-23, -6.105768471582073e-26,  3.548649305233143e-29,
  7.045399926120065e-01, -2.593906475892646e-03,  3.974298202286561e-06,  6.129424858781440e-09, -4.474102502313878e-11,  4.730883531517915e-14,  3.599119507492018e-16,
 -1.475109918971886e-18, -4.908794528431045e-22,  2.018382352806990e-23, -4.919398758479572e-26, -1.373034449552576e-28,  7.739802612092854e-01, -2.736785376836839e-03,
  3.474918873554012e-06,  9.350310462275833e-09, -4.607946286451678e-11,  2.209456592147811e-15,  5.057781525287178e-16, -1.166335485210425e-18, -3.722433667412025e-21,
  2.431835565873572e-23, -7.573167657877066e-27, -3.256539919865825e-28,  8.456687352061634e-01, -2.859169241608992e-03,  2.824122536833930e-06,  1.250883040281121e-08,
 -4.352037350722728e-11, -5.347031530897077e-14,  5.974787583409771e-16, -4.676269155902628e-19, -6.967448576245216e-21,  2.039804352442546e-23,  5.784626302355993e-26,
 -4.197673070082595e-28,  9.193361764549018e-01, -2.957086231453850e-03,  2.027527759020848e-06,  1.538022462915507e-08, -3.649050383464224e-11, -1.139706748466418e-13,
  5.988096547198046e-16,  5.679877591704588e-19, -9.078521876893927e-21,  6.393485143315886e-24,  1.240511919666253e-25, -3.034975725113518e-28,  9.946753792223230e-01,
 -3.026590031938308e-03,  1.098538925675537e-06,  1.771325406369715e-08, -2.481179815822018e-11, -1.708810880154436e-13,  4.818618549190768e-16,  1.761009417443040e-18,
 -8.818475584998372e-21, -1.586231491349644e-23,  1.542513924824920e-25,  6.379046528801546e-29,  1.071336820059944e+00, -3.063879189604233e-03,  5.952669003771624e-08,
  1.924629380556492e-08, -8.859319018943100e-12, -2.138121402981259e-13,  2.381094080847848e-16,  2.806924302757950e-18, -5.355046416815965e-21, -3.938311788707181e-23,
  1.130067101289584e-25,  5.622957751028823e-28,  1.148924202058746e+00, -3.065451132334264e-03, -1.057247019347164e-06,  1.973090381777686e-08,  1.030722395676787e-11,
 -2.318472838219883e-13, -1.107369113959702e-16,  3.327947026239710e-18,  1.137115813215960e-21, -5.297728739279293e-23, -8.562734511777848e-27,  8.975971505978391e-28,
  1.226990079229662e+00, -3.028295260990358e-03, -2.209185722208317e-06,  1.896311168571386e-08,  3.088029750924988e-11, -2.158233295711332e-13, -5.061813576205249e-16,
  2.985345150379175e-18,  9.027920043089257e-21, -4.552666713823532e-23, -1.695672737582588e-25,  7.335249806117851e-28,  1.305031833301873e+00, -2.950127601129713e-03,
 -3.343689604936293e-06,  1.682122430020428e-08,  5.036201047551101e-11, -1.612405096946519e-13, -8.559840081619522e-16,  1.638576348219218e-18,  1.531818057760901e-20,
 -1.308128842412691e-23, -2.798190361264630e-25, -3.251564203164110e-29,  1.382488382779034e+00, -2.829665919523276e-03, -4.399609035233957e-06,  1.330676536176080e-08,
  6.579566442235940e-11, -7.122608583663988e-14, -1.051633194354020e-15, -5.004478256478399e-19,  1.659364288788467e-20,  3.454333834605848e-23, -2.429879913412814e-25,
 -1.022872064010081e-27,  1.458738130396366e+00, -2.666938354461366e-03, -5.310186773453975e-06,  8.582134757813420e-09,  7.420739277271111e-11,  4.146446245809454e-14,
 -1.001541471538573e-15, -2.808157600669051e-18,  1.081362339491092e-20,  7.348151554270455e-23, -3.475686174545587e-26, -1.465677234517452e-27,  1.533098792145023e+00,
 -2.463609986631985e-03, -6.007800244477117e-06,  2.995188186777222e-09,  7.324774309099488e-11,  1.547450651697388e-13, -6.737303603869892e-16, -4.384125455444408e-18,
 -7.925868958188978e-22,  7.676202450016591e-23,  2.374448795017755e-25, -7.820038465923633e-28,  1.604829881862463e+00, -2.223300253901341e-03, -6.430639818662991e-06,
 -2.921881925156554e-09,  6.194305762834917e-11,  2.410193472973752e-13, -1.315806352897177e-16, -4.418231425660803e-18, -1.313161425292800e-20,  3.425557291286721e-23,
  3.719660976393488e-25,  6.802718744070246e-28,  1.673138721133090e+00, -1.951850330801203e-03, -6.531118124038741e-06, -8.492500518794840e-09,  4.136232645012583e-11,
  2.748435708328779e-13,  4.614434111296021e-16, -2.681161612162841e-18, -1.928669939900484e-20, -3.202284178964123e-23,  2.318954175679154e-25,  1.634486734081830e-27,
  1.737190862269029e+00, -1.657485496512879e-03, -6.285279456021700e-06, -1.298356059136389e-08,  1.491256579658262e-11,  2.429091519558158e-13,  8.884591398731007e-16,
  1.493527164485507e-19, -1.497714459468702e-20, -7.605238615758418e-23, -9.004364377396304e-26,  1.049818682767958e-27,  1.796125698027604e+00, -1.350806816815179e-03,
 -5.701810923406438e-06, -1.573950970036065e-08, -1.203970414325193e-11,  1.525020720334844e-13,  9.747498531484527e-16,  2.668723853223190e-18, -2.608343731737292e-21,
 -6.349629998262083e-23, -3.063328697439744e-25, -4.913443478660999e-28,  1.849077728043834e+00, -1.044544703049093e-03, -4.828595946177926e-06, -1.634345905532527e-08,
 -3.338487463800359e-11,  3.316036077068452e-14,  6.915509620783940e-16,  3.529924771909880e-18,  9.256432674537509e-21, -7.318103514002110e-24, -2.191735817365144e-25,
 -1.233879347740354e-27,  1.895203416729326e+00, -7.530205811957598e-04, -3.754366841046737e-06, -1.476549846849505e-08, -4.416096976462393e-11, -7.239762811040667e-14,
  1.976810930283525e-16,  2.409757402519875e-18,  1.235769337041486e-20,  3.935511827453005e-23,  3.847536403087733e-26, -4.791951909140399e-28,  1.933712813155636e+00,
 -4.912972250549965e-04, -2.603254600530797e-06, -1.144364254706784e-08, -4.251830263117928e-11, -1.268322349514642e-13, -2.355863463722575e-16,  3.441259544969155e-19,
  6.194120958296134e-21,  3.770516183891616e-23,  1.600176347661704e-25,  4.727086944263520e-28,  1.963904199591216e+00, -2.740536336101284e-04, -1.521182271977311e-06,
 -7.245957810838773e-09, -3.084360148818905e-11, -1.178073708585077e-13, -3.943630381996604e-16, -1.068532782186563e-18, -1.627743323792707e-21,  5.230044012061495e-24,
  6.572321787140747e-26,  4.030201137607020e-28,  1.985199304289182e+00, -1.142876645173097e-04, -6.550911569157904e-07, -3.292052848313308e-09, -1.523769856519880e-11,
 -6.620760495194754e-14, -2.717999054794811e-16, -1.052963358655154e-18, -3.815193730902019e-21, -1.265466092379991e-23, -3.649946886698111e-26, -7.760938551453206e-29,
  1.997178808334120e+00, -2.199191892447174e-05, -1.283284857249402e-07, -6.639469392047489e-10, -3.210325287141830e-12, -1.484538240989862e-14, -6.644472612539248e-17,
 -2.898137974233168e-19, -1.236896409040210e-21, -5.177903878032690e-24, -2.128902597864364e-26, -8.601051313276275e-29,  4.743075920502502e-04, -2.324724610423763e-06,
  8.543865349607049e-09, -2.790582659157632e-11,  8.541942931867023e-14, -2.509297727676396e-16,  7.162972476901481e-19, -2.002196218892216e-21,  5.505174617863598e-24,
 -1.494374406166285e-26,  4.011789475460569e-29, -1.067795754464383e-31,  4.268131195027609e-03, -2.089486180010267e-05,  7.659430716047008e-08, -2.490395843796061e-10,
  7.569834686034954e-13, -2.201517938339683e-15,  6.199131127817411e-18, -1.702024331402292e-20,  4.573984887808514e-23, -1.206584992350068e-25,  3.126762152791314e-28,
 -7.971908193771884e-31,  1.185236423170217e-02, -5.788736450718160e-05,  2.110934569859017e-07, -6.800840509754305e-10,  2.037807538328275e-12, -5.804519714559153e-15,
  1.587921539041158e-17, -4.193128574265093e-20,  1.070010946106196e-22, -2.636467576044652e-25,  6.241287592459222e-28, -1.409391666598950e-30,  2.322010061997769e-02,
 -1.130054746367614e-04,  4.088419839621787e-07, -1.298813231584819e-09,  3.806087392193053e-12, -1.048757889240701e-14,  2.734948836059469e-17, -6.744979295966576e-20,
  1.559403656056473e-22, -3.314105122264257e-25,  6.163730423709145e-28, -8.668250743484625e-31,  3.836078528610580e-02, -1.858010236076779e-04,  6.650519060573946e-07,
 -2.072445926460877e-09,  5.886139803288913e-12, -1.545153400370493e-14,  3.739937120019844e-17, -8.195429159585858e-20,  1.543685820059226e-22, -2.104843178889391e-25,
 -8.963510912006275e-30,  1.482012152514572e-30,  5.725997453587533e-02, -2.756708113336328e-04,  9.733617182371651e-07, -2.958336098112715e-09,  8.056862619894804e-12,
 -1.973988524447556e-14,  4.246571081032349e-17, -7.396440378693268e-20,  7.117616500482555e-23,  1.623918540611343e-25, -1.293176591406385e-27,  5.182825706887533e-30,
  7.989900897628342e-02, -3.818518106110715e-04,  1.325859833179269e-06, -3.904928106292385e-09,  1.006304978755776e-11, -2.232822717781325e-14,  3.918452999300900e-17,
 -3.496462135351129e-20, -1.053908113539785e-22,  7.550884147171586e-25, -2.886014162760470e-27,  8.410624103070992e-30,  1.062545923113404e-01, -5.034152341972471e-04,
  1.713119306873575e-06, -4.853005897135415e-09,  1.162955195598638e-11, -2.223046956660002e-14,  2.499928808806649e-17,  3.781984284956221e-20, -3.578094207827530e-22,
  1.416159906248073e-24, -4.045848601957110e-27,  8.396761613886746e-30,  1.362982674386199e-01, -6.392595239047994e-04,  2.124247776203115e-06, -5.737271323787579e-09,
  1.247821816965411e-11, -1.861732625835399e-14, -1.231465639263749e-18,  1.391612187534609e-19, -6.345692140919511e-22,  1.885658755958080e-24, -3.819906339242523e-27,
  2.605373135026658e-30,  1.699957792307015e-01, -7.881023529274444e-04,  2.546957629159498e-06, -6.488291559021320e-09,  1.234745835516537e-11, -1.094086319818426e-14,
 -3.869714742330096e-17,  2.545891427798519e-19, -8.532549241610192e-22,  1.848806642195910e-24, -1.401301708612987e-27, -9.602849825572497e-30,  2.073063111780040e-01,
 -9.484717777622435e-04,  2.967662682630153e-06, -7.034858187685071e-09,  1.101411658666320e-11,  9.431712077095458e-16, -8.425101149041569e-17,  3.606747861688025e-19,
 -9.131926503887464e-22,  1.031435372943481e-24,  3.406625279139650e-27, -2.542810910152428e-29,  2.481815806859966e-01, -1.118696738815265e-03,  3.371609071266065e-06,
 -7.306799786761484e-09,  8.317126034182439e-12,  1.666594415753379e-14, -1.322699969961120e-16,  4.272662559342167e-19, -7.179676086393766e-22, -6.765770145965283e-25,
  9.760312714959428e-27, -3.807215800288693e-29,  2.925647752643392e-01, -1.296897194486533e-03,  3.743049652110896e-06, -7.238283824263516e-09,  4.182111225913565e-12,
  3.526248488284075e-14, -1.748527116618993e-16,  4.219301836360843e-19, -2.059547742094388e-22, -3.098429992845387e-24,  1.557981301002758e-26, -3.802857243285106e-29,
  3.403893091449842e-01, -1.480974288982695e-03,  4.065472975743842e-06, -6.771630052812991e-09, -1.354304817378998e-12,  5.513116691190305e-14, -2.024422336508113e-16,
  3.165570818760071e-19,  6.158044426682508e-22, -5.690644736238628e-24,  1.780075123783259e-26, -1.668653397451190e-29,  3.915773770824831e-01, -1.668601107608458e-03,
  4.321899695625870e-06, -5.861632898915709e-09, -8.122254820298188e-12,  7.405433174929716e-14, -2.049365218615857e-16,  9.564331736756124e-20,  1.642220857754117e-21,
 -7.557481743770367e-24,  1.322653759534906e-26,  2.819032207816210e-29,  4.460382793367903e-01, -1.857214774842387e-03,  4.495261046788331e-06, -4.480350312480377e-09,
 -1.580085180924615e-11,  8.930004668355778e-14, -1.733016945060900e-16, -2.348331289238653e-19,  2.656050963006646e-21, -7.606923210785205e-24, -3.588432377590698e-29,
  8.687441827680756e-29,  5.036664893077035e-01, -2.044010911787649e-03,  4.568875486064745e-06, -2.622255740016533e-09, -2.390803788962695e-11,  9.782429718183356e-14,
 -1.016245437245396e-16, -6.397370870336314e-19,  3.341501404313380e-21, -4.872038959089678e-24, -2.085675927077116e-26,  1.351172973074507e-28,  5.643394332824799e-01,
 -2.225941803618746e-03,  4.527040364108309e-06, -3.095619947448585e-10, -3.180200635582146e-11,  9.658864498423242e-14,  1.057589675807975e-17, -1.050818130940193e-18,
  3.336814935253288e-21,  1.028518356131736e-24, -4.373720827461511e-26,  1.384421413269356e-28,  6.279149507330344e-01, -2.399720047849284e-03,  4.355754999774684e-06,
  2.402595894899558e-09, -3.869888184150523e-11,  8.299856394403600e-14,  1.561133162558112e-16, -1.369517220356847e-18,  2.331200930902408e-21,  9.394624624170185e-24,
 -5.880055592838015e-26,  6.598136996378013e-29,  6.942284042339709e-01, -2.561829972551154e-03,  4.043588867860161e-06,  5.421593130727137e-09, -4.371182137278299e-11,
  5.544996772109741e-14,  3.184954222210153e-16, -1.479582874525768e-18,  1.989990531708077e-22,  1.811018043307081e-23, -5.412457752176362e-26, -8.740653281167525e-29,
  7.630894113427533e-01, -2.708549736972864e-03,  3.582702534415471e-06,  8.614040768862437e-09, -4.591659836691181e-11,  1.394358936581399e-14,  4.715841443346341e-16,
 -1.271531687696796e-18, -2.855757545707683e-21,  2.374224318661028e-23, -2.089188967385954e-26, -2.789379237403072e-28,  8.342781780587967e-01, -2.835987751233531e-03,
  2.970017765917340e-06,  1.180472339230368e-08, -4.444757276235462e-11, -3.931244845357943e-14,  5.813771568211577e-16, -6.784254933953267e-19, -6.195910916488562e-21,
  2.234381311396276e-23,  3.950199440789836e-26, -4.115950671019364e-28,  9.075414266359724e-01, -2.940137852154380e-03,  2.208514688288507e-06,  1.477892692730075e-08,
 -3.862508345259262e-11, -9.944098093758685e-14,  6.106874065225571e-16,  2.820881114962886e-19, -8.762431252169962e-21,  1.106967202565190e-23,  1.093267693879067e-25,
 -3.627117704636910e-28,  9.825879320597543e-01, -3.016958488722986e-03,  1.308605340095529e-06,  1.728956885171834e-08, -2.810994598734731e-11, -1.587570769142613e-13,
  5.271421058699226e-16,  1.470875657462580e-18, -9.278109293541371e-21, -9.672023206902265e-24,  1.543884479635287e-25, -5.622822774404037e-29,  1.059083714619141e+00,
 -3.062481886562034e-03,  2.894916829793126e-07,  1.907067161056200e-08, -1.307215497956998e-11, -2.071750294741290e-13,  3.140975766669274e-16,  2.613796936507685e-18,
 -6.685818530258438e-21, -3.440202333364864e-23,  1.351763104833250e-25,  4.427189683825681e-28,  1.136646984618152e+00, -3.072959574729392e-03, -8.196400802986600e-07,
  1.985861116819668e-08,  5.651262975355452e-12, -2.333844303733863e-13, -1.733170441060649e-17,  3.333830805665652e-18, -7.667405161603090e-22, -5.253342338178026e-23,
  3.059882511064596e-26,  8.760543973407447e-28,  1.214843003830931e+00, -3.045050450162601e-03, -1.978808375901021e-06,  1.942203364060521e-08,  2.644928027693975e-11,
 -2.269375208124790e-13, -4.188025296300428e-16,  3.246771988216467e-18,  7.275055739909543e-21, -5.161975584314424e-23, -1.340569151138864e-25,  8.748474925114451e-28,
  1.293179121283572e+00, -2.976056252991944e-03, -3.137110149733136e-06,  1.760011837257016e-08,  4.693576454921006e-11, -1.811786860536751e-13, -8.033275174628351e-16,
  2.119064667704118e-18,  1.464610447432590e-20, -2.422952168491380e-23, -2.757675308581202e-25,  2.178530029680018e-28,  1.371100361782096e+00, -2.864206287839367e-03,
 -4.233662928811744e-06,  1.434672481839205e-08,  6.411793045017868e-11, -9.657235050573049e-14, -1.058038703748508e-15,  4.848449774459302e-20,  1.765181907525682e-20,
  2.396999411200095e-23, -2.844264273736791e-25, -8.509400145191342e-28,  1.447986094800274e+00, -2.708987667358624e-03, -5.200054181904204e-06,  9.774755347105863e-09,
  7.479015557950283e-11,  1.652545978345512e-14, -1.074930352953680e-15, -2.420192820076388e-18,  1.341808332040250e-20,  7.076853330105063e-23, -1.015937312109286e-25,
 -1.561773679067652e-27,  1.523148483458686e+00, -2.511508466871365e-03, -5.964727031084444e-06,  4.190990987163602e-09,  7.617100216791171e-11,  1.371022215457580e-13,
 -7.964128660389183e-16, -4.363513482769859e-18,  2.132608966018660e-21,  8.547217847402183e-23,  1.955921180081438e-25, -1.120914979248700e-27,  1.595833592814207e+00,
 -2.274868409248960e-03, -6.459597468209584e-06, -1.892444388925492e-09,  6.672160448306197e-11,  2.363306458859779e-13, -2.609678967721212e-16, -4.815786182464074e-18,
 -1.162406597037464e-20,  4.965686567051344e-23,  3.960732860272483e-25,  4.022123979544318e-28,  1.665226192928545e+00, -2.004495243725909e-03, -6.628874073822626e-06,
 -7.786153394411017e-09,  4.696349870529089e-11,  2.849466040092694e-13,  3.775707247396373e-16, -3.314848352532185e-18, -2.025494203693419e-20, -2.127852062239642e-23,
  3.059487095675907e-25,  1.720370619030811e-27,  1.730459375283777e+00, -1.708386510099616e-03, -6.439486502441638e-06, -1.270493510872634e-08,  1.998402705012507e-11,
  2.642256441615023e-13,  8.855152570810244e-16, -3.743207265544029e-19, -1.776779222675161e-20, -7.862687410606063e-23, -3.606409589669876e-26,  1.408871657762336e-27,
  1.790630041275755e+00, -1.397179835280996e-03, -5.891736013747961e-06, -1.590644835264360e-08, -8.749728090876783e-12,  1.767811302700984e-13,  1.047944850489200e-15,
  2.546278869325240e-18, -5.119508275620246e-21, -7.612904017434399e-23, -3.238517374179917e-25, -2.917099863843307e-28,  1.844821036847859e+00, -1.083966980907234e-03,
 -5.027897502595713e-06, -1.687137540601778e-08, -3.254751760003045e-11,  5.097680323806607e-14,  7.944834392322573e-16,  3.820114261562517e-18,  8.821649253100065e-21,
 -1.721931653199549e-23, -2.770642008723172e-25, -1.395265125586136e-27,  1.892130125256558e+00, -7.837763798868194e-04, -3.935839158540991e-06, -1.548337606738780e-08,
 -4.555577700373506e-11, -6.679759932932392e-14,  2.709053982629500e-16,  2.828124371980049e-18,  1.379655370499004e-20,  4.041192341399246e-23,  1.277964396234366e-26,
 -6.969529027124111e-28,  1.931705085881281e+00, -5.126843164427438e-04, -2.744744762582601e-06, -1.214453205580674e-08, -4.511058633351556e-11, -1.323469835974344e-13,
 -2.229627483072859e-16,  5.653323800982069e-19,  7.671785909021255e-21,  4.452753648408261e-23,  1.812122068176905e-25,  4.878359169895897e-28,  1.962783083363330e+00,
 -2.865794696796442e-04, -1.611174198148840e-06, -7.758829139302423e-09, -3.329684907897171e-11, -1.276368037083141e-13, -4.249790536656019e-16, -1.117064330130898e-18,
 -1.387612617528018e-21,  8.241884605992924e-24,  8.560298601379099e-26,  5.038724031253832e-28,  1.984731415989667e+00, -1.196906599524074e-04, -6.961034832590182e-07,
 -3.546813947129065e-09, -1.662954388429399e-11, -7.309882529661539e-14, -3.030626209372560e-16, -1.182627093030085e-18, -4.297863062602771e-21, -1.418277031380422e-23,
 -3.989531766751223e-26, -7.611708078125887e-29,  1.997088735679441e+00, -2.305131261376460e-05, -1.366141265751540e-07, -7.177768906673185e-10, -3.523860835320911e-12,
 -1.654208419276563e-14, -7.514288094660943e-17, -3.325490080691155e-19, -1.439586918850271e-21, -6.110236458193315e-24, -2.545987201259321e-26, -1.041836583877693e-28,
  4.651433069170561e-04, -2.257690308656511e-06,  8.217033056479623e-09, -2.657834914353189e-11,  8.056830503264876e-14, -2.343919562802785e-16,  6.626233522560746e-19,
 -1.834337474694413e-21,  4.994987682999812e-24, -1.342914691764757e-26,  3.570404012846743e-29, -9.413336951725020e-32,  4.185758616068354e-03, -2.029385863794643e-05,
  7.367707530851349e-08, -2.372721671927250e-10,  7.144031374590848e-13, -2.058296126683409e-15,  5.742419583980272e-18, -1.562372054320803e-20,  4.161306659479358e-23,
 -1.088256631278155e-25,  2.796206235794726e-28, -7.072302925164715e-31,  1.162414135365026e-02, -5.623071529238598e-05,  2.031243129144691e-07, -6.483875393550613e-10,
  1.925435018613693e-12, -5.437129141879441e-15,  1.475168268544803e-17, -3.865441179458745e-20,  9.794461447338540e-23, -2.398808153679988e-25,  5.651595220016927e-28,
 -1.273284683753099e-30,  2.277452292417692e-02, -1.097960622569716e-04,  3.936148015645940e-07, -1.239558814316390e-09,  3.602749583467630e-12, -9.853301277584319e-15,
  2.552899534183280e-17, -6.264590972467096e-20,  1.444442142606525e-22, -3.075149118050053e-25,  5.785125456960544e-28, -8.523820221673129e-31,  3.762806674598886e-02,
 -1.805785079069796e-04,  6.407375822156659e-07, -1.980691936520722e-09,  5.585901955099298e-12, -1.458093454106116e-14,  3.517266923501383e-17, -7.713568356980856e-20,
  1.467995033995518e-22, -2.096371847125868e-25,  4.899113621927804e-29,  1.162077045976819e-30,  5.617264329921461e-02, -2.680237559021452e-04,  9.386222930095523e-07,
 -2.832530001991544e-09,  7.672090286129694e-12, -1.874529779601581e-14,  4.042740463199303e-17, -7.160277945989133e-20,  7.614411439308582e-23,  1.150042768588848e-25,
 -1.081501151066572e-27,  4.455101767624337e-30,  7.839252253651541e-02, -3.714296649538105e-04,  1.279952176643565e-06, -3.747441068818312e-09,  9.625808365636218e-12,
 -2.139990332560592e-14,  3.816223731732926e-17, -3.792376862830724e-20, -8.019880952495412e-23,  6.467825730355393e-25, -2.535743575868036e-27,  7.522889162938487e-30,
  1.042679768764802e-01, -4.899400943640137e-04,  1.655985107511832e-06, -4.670457004538905e-09,  1.119102167834648e-11, -2.161902701593732e-14,  2.590539079137039e-17,
  2.715513095829102e-20, -3.096527425735889e-22,  1.261592687049134e-24, -3.685650890042982e-27,  7.966265510043995e-30,  1.337747860291207e-01, -6.225375649457307e-04,
  2.056586140147125e-06, -5.540598926780389e-09,  1.210588011389930e-11, -1.860235619039384e-14,  2.390757793463421e-18,  1.199118939220912e-19, -5.694057902223540e-22,
  1.735416320967190e-24, -3.686258111160807e-27,  3.424183402669778e-30,  1.668836327499998e-01, -7.680347883264730e-04,  2.470276108517334e-06, -6.292530855567698e-09,
  1.211991549786614e-11, -1.178707706181069e-14, -3.194098556685066e-17,  2.283383014751778e-19, -7.878013653646066e-22,  1.785097532742560e-24, -1.765360565880429e-27,
 -7.021642550974046e-30,  2.035593762510871e-01, -9.250651529178468e-04,  2.884302015426813e-06, -6.858587903560705e-09,  1.101356086157747e-11, -9.609332474448180e-16,
 -7.455547047209955e-17,  3.320709117920287e-19, -8.738667839206128e-22,  1.146532432675064e-24,  2.377356347102322e-27, -2.142868641672360e-29,  2.437601873848798e-01,
 -1.092072306144972e-03,  3.284736369739918e-06, -7.171227678621194e-09,  8.619655654594231e-12,  1.363240962912345e-14, -1.206313343935710e-16,  4.039737242759691e-19,
 -7.356904496897145e-22, -3.185453349709082e-25,  8.169022775924223e-27, -3.426355740860338e-29,  2.874365268460111e-01, -1.267299045221449e-03,  3.656614274499787e-06,
 -7.165952052905250e-09,  4.846348939583518e-12,  3.120694476532951e-14, -1.631468643518074e-16,  4.136719496774380e-19, -3.066822683364296e-22, -2.508496361510278e-24,
  1.392338094466075e-26, -3.713796367546172e-29,  3.345299445010690e-01, -1.448775829690790e-03,  3.984118941627313e-06, -6.784738876548911e-09, -2.995389410971028e-13,
  5.038095881486437e-14, -1.933325817729678e-16,  3.331209031192826e-19,  4.235664797903078e-22, -4.994851201799441e-24,  1.695347651156022e-26, -2.155758916743039e-29,
  3.849716745903569e-01, -1.634309366844605e-03,  4.250828377321324e-06, -5.980006506007595e-09, -6.690106394998721e-12,  6.917368196445026e-14, -2.015629541588829e-16,
  1.439455918703438e-19,  1.379940475772248e-21, -7.007217711859883e-24,  1.420097001094371e-26,  1.642344825371814e-29,  4.386809980171136e-01, -1.821471906857321e-03,
  4.440038161569742e-06, -4.719103985427133e-09, -1.405692732073050e-11,  8.507125349757366e-14, -1.787282400418562e-16, -1.542141744424362e-19,  2.383053329551668e-21,
 -7.536703192344017e-24,  3.430046547583274e-27,  7.083768088725175e-29,  4.955633393911267e-01, -2.007592131358350e-03,  4.535177364199035e-06, -2.989270852148592e-09,
 -2.197733102198610e-11,  9.518227180406360e-14, -1.180676386815012e-16, -5.357649405001878e-19,  3.152490545938182e-21, -5.591093027299022e-24, -1.518984570449821e-26,
  1.222369154289395e-28,  5.555080631687656e-01, -2.189748842971800e-03,  4.520336393928902e-06, -8.029359086579527e-10, -2.987001603586838e-11,  9.650147997394717e-14,
 -1.734888953536159e-17, -9.437733185569620e-19,  3.343825175043075e-21, -5.985135628032817e-25, -3.760736381416375e-26,  1.394207805831597e-28,  6.183859305264681e-01,
 -2.364769081927683e-03,  4.380926461081164e-06,  1.796884245129531e-09, -3.700450459881675e-11,  8.629385179318024e-14,  1.188588545733394e-16, -1.289955292263036e-18,
  2.627839520684008e-21,  7.108131011845469e-24, -5.535144936935242e-26,  8.969444539199828e-29,  6.840461771358262e-01, -2.529232827841019e-03,  4.104489554441253e-06,
  4.731477236512575e-09, -4.252973259069368e-11,  6.259802489650477e-14,  2.772512471149229e-16, -1.463207973679888e-18,  8.111951006121346e-22,  1.588206292572003e-23,
 -5.694879028149695e-26, -4.177022587427788e-29,  7.523131727034388e-01, -2.679487106926691e-03,  3.681674191438637e-06,  7.882208834301738e-09, -4.552748025872868e-11,
  2.482483118078181e-14,  4.348290860638246e-16, -1.349424817361391e-18, -2.018903982668347e-21,  2.267572747507148e-23, -3.206752179013366e-26, -2.286746469352127e-28,
  8.229826273566083e-01, -2.811673126986317e-03,  3.107383970564371e-06,  1.108802350009264e-08, -4.509594248113017e-11, -2.560899879353596e-14,  5.597283701693467e-16,
 -8.635547607384365e-19, -5.367407944173905e-21,  2.356723379037941e-23,  2.182920127448684e-26, -3.896464182633776e-28,  8.958173196360329e-01, -2.921770998143774e-03,
  2.382090757877140e-06,  1.414581349192316e-08, -4.046686040034648e-11, -8.472098891864080e-14,  6.147260459915607e-16,  8.878409970597214e-21, -8.289176948124021e-21,
  1.511032111442490e-23,  9.241242501120090e-26, -4.029789273485919e-28,  9.705423386908757e-01, -3.005667629380402e-03,  1.513279095278097e-06,  1.681510937235702e-08,
 -3.115541207410610e-11, -1.456452810703175e-13,  5.641261459819076e-16,  1.169590113389076e-18, -9.516042082555921e-21, -3.579114517509202e-24,  1.494590592569000e-25,
 -1.657158455370940e-28,  1.046839862879477e+00, -3.059254428610334e-03,  5.169494735685315e-07,  1.882880314352546e-08, -1.713447372103245e-11, -1.987837339208878e-13,
  3.841101100570918e-16,  2.381114564656731e-18, -7.822617080371379e-21, -2.864366246245652e-23,  1.517764378634266e-25,  3.102984169749145e-28,  1.124343543034787e+00,
 -3.078562299626057e-03, -5.809482454169475e-07,  1.991169893230665e-08,  9.869541795709954e-13, -2.326847338366017e-13,  7.538986432979654e-17,  3.279346642900973e-18,
 -2.626752870456797e-21, -5.055333184747177e-23,  6.797444672453243e-26,  8.169002921582078e-28,  1.202632626868283e+00, -3.059941813688651e-03, -1.743356303547124e-06,
  1.980839736342471e-08,  2.181750947361589e-11, -2.358733117117140e-13, -3.249199873601659e-16,  3.448883215921655e-18,  5.329808894147537e-21, -5.617886728794254e-23,
 -9.314873198380890e-26,  9.777194570359580e-28,  1.281226057770010e+00, -3.000295844073375e-03, -2.921525809663018e-06,  1.832107559175394e-08,  4.312446827340336e-11,
 -1.996944619691073e-13, -7.375784299185488e-16,  2.571678078115726e-18,  1.357827547253761e-20, -3.499430348722182e-23, -2.606451572399799e-25,  4.683900328802985e-28,
  1.359576912791435e+00, -2.897369664148183e-03, -4.055415112528343e-06,  1.535578206640002e-08,  6.193299708315833e-11, -1.218844425382371e-13, -1.048659458119751e-15,
  6.248841291298148e-19,  1.830149760898689e-20,  1.190737376151919e-23, -3.170438792894691e-25, -6.230706081765147e-28,  1.437067714886265e+00, -2.750098553733729e-03,
 -5.075570957293144e-06,  1.097261806329980e-08,  7.485745312679611e-11, -1.003521102724757e-14, -1.136307825998029e-15, -1.950971079906564e-18,  1.587591350405288e-20,
  6.531736713675477e-23, -1.711524701603129e-25, -1.587407467216491e-27,  1.513007361989686e+00, -2.559004195597446e-03, -5.907035712701320e-06,  5.430583489932354e-09,
  7.871206317009956e-11,  1.165327783777314e-13, -9.171630818705471e-16, -4.244630457196561e-18,  5.337645523405723e-21,  9.221060150673853e-23,  1.389117959686645e-25,
 -1.452435036708756e-27,  1.586630647883583e+00, -2.326617521267832e-03, -6.475746777988736e-06, -7.874726962586400e-10,  7.137445308189719e-11,  2.284090414390017e-13,
 -4.007267767195847e-16, -5.156067487416529e-18, -9.547877490389743e-21,  6.575418042334235e-23,  4.061892573410600e-25,  4.490516509065188e-29,  1.657101576829651e+00,
 -2.057886761452210e-03, -6.717609848478439e-06, -6.988686489528094e-09,  5.274514847479099e-11,  2.928206508004926e-13,  2.755832977136770e-16, -3.972752309980419e-18,
 -2.078235424892764e-20, -7.518133083354064e-24,  3.821234047621457e-25,  1.727261122994346e-27,  1.723521840097069e+00, -1.760506394246450e-03, -6.589849140400609e-06,
 -1.234176461396625e-08,  2.547987146626769e-11,  2.852853679569915e-13,  8.666475270958230e-16, -9.883296792679164e-19, -2.060837459082165e-20, -7.871829021707535e-23,
  3.427708381473769e-26,  1.790764056641394e-27,  1.784945842274039e+00, -1.445079335133561e-03, -6.083332200451888e-06, -1.601676862696220e-08, -4.956930507622723e-12,
  2.027662219586694e-13,  1.116517160589311e-15,  2.336083555102968e-18, -8.095725249058633e-21, -8.926219047436703e-23, -3.307192511851549e-25, -5.039322755254048e-30,
  1.840403427952270e+00, -1.125008755473814e-03, -5.233441467836561e-06, -1.738290645941654e-08, -3.132847935056324e-11,  7.135921097781942e-14,  9.052895884026713e-16,
  4.090227066892642e-18,  7.987074887287166e-21, -2.957296626988626e-23, -3.416365134067193e-25, -1.534752034455062e-27,  1.888930851949671e+00, -8.160187854775937e-04,
 -4.126055892289719e-06, -1.622257501617050e-08, -4.682003396645716e-11, -5.929438542098155e-14,  3.564927802943950e-16,  3.292925588754442e-18,  1.525251292644657e-20,
  4.023424089045781e-23, -2.363195851906981e-26, -9.672696145004121e-28,  1.929609492124840e+00, -5.352376851891071e-04, -2.894898038394830e-06, -1.288776179741439e-08,
 -4.780960505004943e-11, -1.374788644788038e-13, -2.034452812547256e-16,  8.379183653495036e-19,  9.410425823497089e-21,  5.220527571681310e-23,  2.026276898814608e-25,
  4.812018779742441e-28,  1.961610383980052e+00, -2.998505414679857e-04, -1.707562710000262e-06, -8.312565506818467e-09, -3.595413830661636e-11, -1.382163533224340e-13,
 -4.568289276237636e-16, -1.156014364895419e-18, -1.023617922454368e-21,  1.214373628290514e-23,  1.103798046726804e-25,  6.261504846511103e-28,  1.984241239600727e+00,
 -1.254343718586919e-04, -7.403112436476477e-07, -3.824989199345880e-09, -1.816701997856768e-11, -8.078571492313402e-14, -3.381806127557892e-16, -1.328642451858072e-18,
 -4.837962312979344e-21, -1.584414418521514e-23, -4.312829341116253e-26, -6.989169670352029e-29,  1.996994288664783e+00, -2.417966320395076e-05, -1.455769839639879e-07,
 -7.769066460141291e-10, -3.873518823577661e-12, -1.846266585526849e-14, -8.513371175198708e-17, -3.823411693512855e-19, -1.679047499416026e-21, -7.226547469668505e-24,
 -3.051802637481220e-26, -1.264898222771101e-28,  4.562420287322739e-04, -2.193208241132021e-06,  7.905675477325445e-09, -2.532591205872748e-11,  7.603542672017163e-14,
 -2.190877083915396e-16,  6.134288981322417e-19, -1.681965320546106e-21,  4.536277900330623e-24, -1.208046287961382e-26,  3.181059470694030e-29, -8.308655194312979e-32,
  4.105744252303173e-03, -1.971563986253812e-05,  7.089705738394663e-08, -2.261637023347652e-10,  6.745807236072709e-13, -1.925580698201077e-15,  5.323024143060776e-18,
 -1.435268673642480e-20,  3.788939036607254e-23, -9.823915505722153e-26,  2.502815284432812e-28, -6.280215245860437e-31,  1.140241993266063e-02, -5.463632781389568e-05,
  1.955249770195097e-07, -6.184316452445155e-10,  1.820146968502478e-12, -5.095730298144511e-15,  1.371197059021888e-17, -3.565409979409203e-20,  8.970265768518085e-23,
 -2.183578050193569e-25,  5.118869171048901e-28, -1.150256427664039e-30,  2.234154366948288e-02, -1.067056774833148e-04,  3.790795628012363e-07, -1.183458646496942e-09,
  3.411671092416317e-12, -9.261142176080727e-15,  2.383798802506037e-17, -5.819643033203836e-20,  1.337812244735970e-22, -2.851181701589198e-25,  5.414953588508568e-28,
 -8.289690907472945e-31,  3.691585609922634e-02, -1.755461829655204e-04,  6.174960487340065e-07, -1.893605314475693e-09,  5.302552475018669e-12, -1.376218419956124e-14,
  3.307750496738186e-17, -7.255837721961810e-20,  1.392994100817026e-22, -2.067366582486876e-25,  9.410374150385650e-29,  8.967538949440690e-31,  5.511535386895846e-02,
 -2.606486803433221e-04,  9.053562506714285e-07, -2.712723764383886e-09,  7.306725950374825e-12, -1.779881974535250e-14,  3.845720441085348e-17, -6.910790278600483e-20,
  7.955105929975169e-23,  7.547157669214194e-26, -8.997540741738208e-28,  3.820574784413820e-30,  7.692700195983529e-02, -3.613673386984451e-04,  1.235892997683497e-06,
 -3.596802721925676e-09,  9.206881815016819e-12, -2.049702118469655e-14,  3.706780722629480e-17, -4.013652702926997e-20, -5.866284004129685e-23,  5.517279374617618e-25,
 -2.222921156141142e-27,  6.708267138064219e-30,  1.023343615603177e-01, -4.769133841224875e-04,  1.600999803064045e-06, -4.494825682478658e-09,  1.076491440729504e-11,
 -2.098925225208410e-14,  2.653363884175134e-17,  1.794514477965612e-20, -2.668058490172646e-22,  1.121039277077304e-24, -3.345492370980357e-27,  7.489786864404816e-30,
  1.313171246734728e-01, -6.063475600234554e-04,  1.991248853091738e-06, -5.349876999152977e-09,  1.173466833236500e-11, -1.850668986136944e-14,  5.502387973790672e-18,
  1.026623565634361e-19, -5.095468926407801e-22,  1.591163348146982e-24, -3.522246167019751e-27,  3.993953245556533e-30,  1.638505444121834e-01, -7.485713424987606e-04,
  2.395921341566543e-06, -6.100537667691930e-09,  1.187701151908637e-11, -1.247972885784255e-14, -2.589088765676413e-17,  2.041426812353440e-19, -7.248772956949416e-22,
  1.708965441527021e-24, -2.025619091283709e-27, -4.875486981954020e-30,  1.999047474454867e-01, -9.023169554020355e-04,  2.803055321790598e-06, -6.682618794469237e-09,
  1.097718585380682e-11, -2.641809864733469e-15, -6.564265173783641e-17,  3.047841516464365e-19, -8.310972505314180e-22,  1.223850563927159e-24,  1.514535921030573e-27,
 -1.786061194133942e-29,  2.394439122649150e-01, -1.066136269851116e-03,  3.199517622775601e-06, -7.031285508012434e-09,  8.864254753761035e-12,  1.087032410520389e-14,
 -1.096509505324903e-16,  3.803083302102513e-19, -7.416296172724766e-22, -2.082872190995205e-26,  6.744019203076597e-27, -3.052867670573228e-29,  2.824252938029806e-01,
 -1.238388732445236e-03,  3.571108017524463e-06, -7.083626185046651e-09,  5.432264723802077e-12,  2.742922515453184e-14, -1.517142714519693e-16,  4.025175394551690e-19,
 -3.873534119058268e-22, -1.983827638502031e-24,  1.232135492715447e-26, -3.558952719955102e-29,  3.287980714291139e-01, -1.417228552141445e-03,  3.902705762893296e-06,
 -6.781719455098418e-09,  6.624431612300518e-13,  4.585427557551744e-14, -1.838415487975345e-16,  3.439269543579106e-19,  2.557196199098845e-22, -4.336774484389993e-24,
  1.592587324188825e-26, -2.492330902481070e-29,  3.785019934640020e-01, -1.600591496403749e-03,  4.178470856217477e-06, -6.076241800116382e-09, -5.354656582511131e-12,
  6.438929751132861e-14, -1.969513984174068e-16,  1.841783902219364e-19,  1.138051591034886e-21, -6.427763939093994e-24,  1.469989895102955e-26,  6.560727383762134e-30,
  4.314657871190737e-01, -1.786181814252845e-03,  4.382114837155849e-06, -4.930637799911425e-09, -1.239870331156728e-11,  8.073832728659146e-14, -1.820191948972043e-16,
 -8.226530165060339e-20,  2.114911955673785e-21, -7.341633281899245e-24,  6.215153264304293e-27,  5.597208736224932e-29,  4.876052982690959e-01, -1.971460031627413e-03,
  4.497258598328937e-06, -3.325837843027301e-09, -2.010317882398899e-11,  9.217984094292299e-14, -1.316877765466876e-16, -4.382126991256508e-19,  2.941533961180843e-21,
 -6.095165523131145e-24, -1.011529583851268e-26,  1.083090341252500e-28,  5.468213208791165e-01, -2.153632670896800e-03,  4.507897235154117e-06, -1.265447318928596e-09,
 -2.794622827969075e-11,  9.578006006951793e-14, -4.228174850736876e-17, -8.373940213690620e-19,  3.296674171565342e-21, -1.980791316207205e-24, -3.153008026003090e-26,
  1.362005886793642e-28,  6.089970715497353e-01, -2.329645352907155e-03,  4.398994062446748e-06,  1.218762073243710e-09, -3.525297699904302e-11,  8.872276295735882e-14,
  8.395284754784606e-17, -1.202189398260881e-18,  2.844881445224201e-21,  4.978530020340234e-24, -5.100320336102623e-26,  1.069196112688377e-28,  6.739952610465070e-01,
 -2.496181271156450e-03,  4.157226874836923e-06,  4.061364864315179e-09, -4.121453300516930e-11,  6.876386273697526e-14,  2.367276413592141e-16, -1.428544159052650e-18,
  1.341615829142736e-21,  1.357963210899517e-23, -5.787908248729912e-26, -1.459997888815222e-30,  7.416547126824251e-01, -2.649667709492430e-03,  3.771908245055543e-06,
  7.158295171982366e-09, -4.492971971216178e-11,  3.480076711475784e-14,  3.962615686862991e-16, -1.401234863935768e-18, -1.227953759336846e-21,  2.120689932112569e-23,
 -4.099986770968604e-26, -1.773565316652532e-28,  8.117864783197378e-01, -2.786294130416010e-03,  3.236096481159379e-06,  1.036311230625116e-08, -4.547584315052536e-11,
 -1.248429171145253e-14,  5.332727937964514e-16, -1.021601575013323e-18, -4.507321373680295e-21,  2.410654728104506e-23,  5.378133030770850e-27, -3.565112040755896e-28,
  8.841694084749122e-01, -2.902046403588865e-03,  2.547902380879250e-06,  1.348558952199692e-08, -4.201387847657437e-11, -6.999402706455997e-14,  6.113477503459654e-16,
 -2.469934497372661e-19, -7.683013748913637e-21,  1.844453882075780e-23,  7.414221400308441e-26, -4.244491513066216e-28,  9.585451463377241e-01, -2.992762962189178e-03,
  1.711975774101176e-06,  1.629406566899396e-08, -3.393045298210450e-11, -1.317477594864572e-13,  5.926002470668857e-16,  8.641529962161075e-19, -9.539303707293110e-21,
  2.224345669886076e-24,  1.400236844037510e-25, -2.604402817790101e-28,  1.034612540371885e+00, -3.054220009634411e-03,  7.411206877170120e-07,  1.852336919366162e-08,
 -2.101271168293055e-11, -1.887942336637890e-13,  4.471302624866144e-16,  2.115488069643948e-18, -8.741587702351661e-21, -2.234002793577462e-23,  1.623983947844894e-25,
  1.721644301693499e-28,  1.112021511867158e+00, -3.082254208476971e-03, -3.420662792611817e-07,  1.989038997730512e-08, -3.641265522340006e-12, -2.297846760892386e-13,
  1.657653318435226e-16,  3.166765445925507e-18, -4.389292740480547e-21, -4.714052708812989e-23,  1.019893462600067e-25,  7.241185711341926e-28,  1.190366479252838e+00,
 -3.072932287796830e-03, -1.503718012629983e-06,  2.011934724540150e-08,  1.702997609618448e-11, -2.424951863944660e-13, -2.262721760358939e-16,  3.586444408613111e-18,
  3.250863889445584e-21, -5.902381147536687e-23, -4.867097444940639e-26,  1.036367417360548e-27,  1.269179538534396e+00, -3.022777218726169e-03, -2.697667798496898e-06,
  1.897817951805889e-08,  3.895964132932433e-11, -2.164843963220441e-13, -6.596918568393064e-16,  2.984058587652768e-18,  1.213643277289507e-20, -4.493681385418091e-23,
 -2.347561336528735e-25,  7.049045905202556e-28,  1.347923738059344e+00, -2.929059255848227e-03, -3.865285014151221e-06,  1.632584820071364e-08,  5.924539057610947e-11,
 -1.467758229135147e-13, -1.022916927027129e-15,  1.214894096339823e-18,  1.849598770860729e-20, -1.244837421787929e-24, -3.385645938663997e-25, -3.483947283842817e-28,
  1.425986974167904e+00, -2.790156099466026e-03, -4.936724696239534e-06,  1.216723242107247e-08,  7.437991595169402e-11, -3.790259572813275e-14, -1.183479318670129e-15,
 -1.406776472930789e-18,  1.808735709819087e-20,  5.708442722986178e-23, -2.400946847816767e-25, -1.532419841995624e-27,  1.502677275809171e+00, -2.605978234449810e-03,
 -5.834239424709900e-06,  6.707385742532467e-09,  8.081308567149048e-11,  9.311707194177046e-14, -1.033115531300408e-15, -4.019770638247200e-18,  8.741002236215833e-21,
  9.639724020163782e-23,  6.822305433820590e-26, -1.753700400480165e-27,  1.577220533863084e+00, -2.378441536789257e-03, -6.478195581102082e-06,  3.904917741677736e-10,
  7.583459678229234e-11,  2.170269343194541e-13, -5.489959099769677e-16, -5.420592693455999e-18, -6.888892595076408e-21,  8.191970416526591e-23,  3.989571838037670e-25,
 -3.845782268134830e-28,  1.648762037729748e+00, -2.111948303282286e-03, -6.796216233004579e-06, -6.097592623940161e-09,  5.865830223406582e-11,  2.980245152256010e-13,
  1.550169384292476e-16, -4.639020466755944e-18, -2.075972698908930e-20,  9.267180436960761e-24,  4.564606845768354e-25,  1.633362496078307e-27,  1.716373449324894e+00,
 -1.813810220622363e-03, -6.735312328054243e-06, -1.188732168626451e-08,  3.139093650645117e-11,  3.056757048701413e-13,  8.293185336552619e-16, -1.692713843132050e-18,
 -2.339752732094107e-20, -7.565752780150494e-23,  1.215642133703643e-25,  2.175200230892621e-27,  1.779066972858811e+00, -1.494515828144439e-03, -6.275870688015632e-06,
 -1.606215930727463e-08, -6.285079373568523e-13,  2.303152233486838e-13,  1.177799353227919e-15,  2.023057938710394e-18, -1.154638378578884e-20, -1.023894360596539e-22,
 -3.228362558912565e-25,  3.804595090925881e-28,  1.835818324888766e+00, -1.167719071741944e-03, -5.444992850728333e-06, -1.787152471262703e-08, -2.967460426080905e-11,
  9.448827733880441e-14,  1.023214528214876e-15,  4.326007895806258e-18,  6.659892319487322e-21, -4.462158524178734e-23, -4.115089119717642e-25, -1.632443642115796e-27,
  1.885599508904062e+00, -8.498187382134592e-04, -4.325259056131928e-06, -1.698068543673783e-08, -4.791260436479019e-11, -4.957565294113953e-14,  4.557437607997319e-16,
  3.803909801034366e-18,  1.667284143060554e-20,  3.834552751565789e-23, -7.319289905705895e-26, -1.295351624213857e-27,  1.927421224909057e+00, -5.590286969244089e-04,
 -3.054232474132692e-06, -1.367496877719444e-08, -5.060592537018717e-11, -1.420441890580955e-13, -1.754737710674091e-16,  1.170727457328114e-18,  1.144073535970443e-20,
  6.072508435505656e-23,  2.230783070051438e-25,  4.419230218746708e-28,  1.960383014967525e+00, -3.139200398319356e-04, -1.810858276016740e-06, -8.910553107543572e-09,
 -3.883074345610217e-11, -1.495719340203918e-13, -4.895837894006789e-16, -1.180866885497222e-18, -4.999569720696286e-22,  1.715130268990286e-23,  1.410688276161850e-25,
  7.731560194408198e-28,  1.983727359292497e+00, -1.315455284423278e-04, -7.880099303377777e-07, -4.129041191191948e-09, -1.986700367733101e-11, -8.936650665378251e-14,
 -3.776381647527968e-16, -1.492922252478843e-18, -5.440116060943913e-21, -1.762749027221515e-23, -4.594309334570388e-26, -5.667307770537658e-29,  1.996895180209957e+00,
 -2.538265299482184e-05, -1.552842767027842e-07, -8.419517403717833e-10, -4.264103810954951e-12, -2.064066209088668e-14, -9.663233282003248e-17, -4.404801172050296e-19,
 -1.962586571127688e-21, -8.566244869747926e-24, -3.666656175983449e-26, -1.539309697327591e-28,  4.475937905710696e-04, -2.131158127350831e-06,  7.608921883770055e-09,
 -2.414361507552343e-11,  7.179716389069235e-14, -2.049145452414825e-16,  5.683024525053101e-19, -1.543524169656470e-21,  4.123430732390506e-24, -1.087821766281497e-26,
  2.837201208806816e-29, -7.342515656845482e-32,  4.027999112565912e-03, -1.915913865767629e-05,  6.824660393909061e-08, -2.156716966591062e-10,  6.373147780012874e-13,
 -1.802516813537613e-15,  4.937605159769773e-18, -1.319493259408251e-20,  3.452651800177630e-23, -8.875936724638214e-26,  2.242161119524232e-28, -5.582204115361146e-31,
  1.118695670910123e-02, -5.310132526773992e-05,  1.882752252093322e-07, -5.901070638695158e-10,  1.721444018030420e-12, -4.778305541282744e-15,  1.275268844503104e-17,
 -3.290553404952379e-20,  8.219844475101952e-23, -1.988610241193505e-25,  4.637612313959037e-28, -1.039149589246764e-30,  2.192069758147077e-02, -1.037289328990960e-04,
  3.651995663128537e-07, -1.130323152476822e-09,  3.232039836912753e-12, -8.708110047634396e-15,  2.226690829789073e-17, -5.407554972120957e-20,  1.238981322286980e-22,
 -2.641794654800008e-25,  5.056571318681178e-28, -7.991723078821853e-31,  3.622340939908970e-02, -1.706956859781502e-04,  5.952728848099445e-07, -1.810923973062136e-09,
  5.035085403965865e-12, -1.299220683750320e-14,  3.110716328836485e-17, -6.821907686097735e-20,  1.319335329716583e-22, -2.022509859896896e-25,  1.285835438944122e-28,
  6.774623408568063e-31,  5.408704145111021e-02, -2.535340803808244e-04,  8.734934246271462e-07, -2.598614464844778e-09,  6.959824044227569e-12, -1.689877716809759e-14,
  3.655818279143402e-17, -6.652542472226527e-20,  8.165918530054295e-23,  4.267536999596041e-26, -7.440767041834907e-28,  3.268412586768714e-30,  7.550103703075742e-02,
 -3.516503678191213e-04,  1.193601853162349e-06, -3.452724185541318e-09,  8.805745614813297e-12, -1.962107405599746e-14,  3.592057039659901e-17, -4.171253972686560e-20,
 -4.033205045056569e-23,  4.684905065933334e-25, -1.944363533056859e-27,  5.964995757732879e-30,  1.004519865058737e-01, -4.643182409521064e-04,  1.548081586255035e-06,
 -4.325910578508141e-09,  1.035153330402551e-11, -2.034734373851855e-14,  2.692246049446825e-17,  1.002788489810960e-20, -2.287790985249824e-22,  9.936641862625563e-25,
 -3.026916989730702e-27,  6.988235141359541e-30,  1.289231922934662e-01, -5.906711995437269e-04,  1.928164668680702e-06, -5.165075256234126e-09,  1.136607864515320e-11,
 -1.834192855481497e-14,  8.157076489538867e-18,  8.724652561594811e-20, -4.547575471848851e-22,  1.453909672381546e-24, -3.337762361213927e-27,  4.361902950426611e-30,
  1.608941346782890e-01, -7.296935862062202e-04,  2.323846741874132e-06, -5.912534104718147e-09,  1.162165281714894e-11, -1.303508309884496e-14, -2.049050244645365e-17,
  1.819149476366236e-19, -6.648596723140325e-22,  1.624195660859143e-24, -2.200020177937461e-27, -3.110417159894731e-30,  1.963398248392608e-01, -8.802102972927810e-04,
  2.723915693028895e-06, -6.507489260402121e-09,  1.090927131316235e-11, -4.117790187945059e-15, -5.747432883862032e-17,  2.789041904777118e-19, -7.861287902484234e-22,
  1.269671827761092e-24,  7.994790383589156e-28, -1.470897539502789e-29,  2.352300285142857e-01, -1.040875203884294e-03,  3.115999886160559e-06, -6.887857592638177e-09,
  9.056193691088798e-12,  8.363804263364946e-15, -9.933432379156460e-17,  3.566136856772240e-19, -7.378377381187191e-22,  2.231346523326836e-25,  5.480255087880658e-27,
 -2.694524374270902e-29,  2.775283403852518e-01, -1.210158364359899e-03,  3.486643473572753e-06, -6.992515302896073e-09,  5.945343204776848e-12,  2.392186519852163e-14,
 -1.406273905613726e-16,  3.890716367033237e-19, -4.502721274161319e-22, -1.521726852902682e-24,  1.079839062177766e-26, -3.357287415859011e-29,  3.231910854464039e-01,
 -1.386332180230294e-03,  3.821418220233101e-06, -6.764020120790321e-09,  1.536190909923170e-12,  4.155842262645638e-14, -1.741196383896951e-16,  3.497327591768469e-19,
  1.107915390395544e-22, -3.722373667635682e-24,  1.477891708638302e-26, -2.702073967958625e-29,  3.721660192884668e-01, -1.567456749414849e-03,  4.105083577560992e-06,
 -6.151869017741227e-09, -4.113700875911907e-12,  5.972825333827935e-14, -1.913185318351797e-16,  2.170075447903281e-19,  9.172825817515699e-22, -5.836496453631108e-24,
  1.480467290251408e-26, -1.515251478900987e-30,  4.243907943697350e-01, -1.751364817440445e-03,  4.321809424670469e-06, -5.116336922248531e-09, -1.082776945653742e-11,
  7.634963060740007e-14, -1.834145069345442e-16, -1.876434748512532e-20,  1.855644321421773e-21, -7.047845037250113e-24,  8.376067066910199e-27,  4.249221956309190e-29,
  4.797911539801615e-01, -1.935646932144131e-03,  4.455478910547520e-06, -3.632915633563489e-09, -1.829212683632369e-11,  8.888252611037796e-14, -1.426734159355587e-16,
 -3.476634478078944e-19,  2.715935216812924e-21, -6.408672477041520e-24, -5.664447014557132e-27,  9.398399949603415e-29,  5.382788098373887e-01, -2.117637690672198e-03,
  4.490092044385646e-06, -1.697325055642196e-09, -2.604261260970039e-11,  9.449578018483553e-14, -6.426425911961362e-17, -7.332731721987575e-19,  3.204093093230901e-21,
 -3.123850530876211e-24, -2.567058711736676e-26,  1.296638075236828e-28,  5.997489533105081e-01, -2.294404353124023e-03,  4.410293802352678e-06,  6.690083000634176e-10,
 -3.346104580466748e-11,  9.034413451270649e-14,  5.159024231463465e-17, -1.108669870606889e-18,  2.988554639568642e-21,  3.036214352544127e-24, -4.603074789730772e-26,
  1.181657042543142e-28,  6.640773445694749e-01, -2.462739614537762e-03,  4.202053005190298e-06,  3.413229740282621e-09, -3.978565412384853e-11,  7.397062232156539e-14,
  1.973997585311873e-16, -1.378236896427658e-18,  1.788891039532064e-21,  1.127373669977279e-23, -5.716561871919539e-26,  3.287001380710810e-29,  7.311169192276855e-01,
 -2.619161010059719e-03,  3.853519139720383e-06,  6.445491093690195e-09, -4.414179959095455e-11,  4.383648331676872e-14,  3.565893003156534e-16, -1.428645097477696e-18,
 -4.957698540358431e-22,  1.942575550586714e-23, -4.769141859304994e-26, -1.271461931209372e-28,  8.006938494561961e-01, -2.759920313113048e-03,  3.356082133546341e-06,
  9.634186708294764e-09, -4.559994133365815e-11, -4.449864610245565e-17,  5.027792560345242e-16, -1.151938960764786e-18, -3.639288177499262e-21,  2.401965462389011e-23,
 -9.419916415764118e-27, -3.149748273132006e-28,  8.726029979363649e-01, -2.881027405244979e-03,  2.705652501474022e-06,  1.280296277635516e-08, -4.326773664392603e-11,
 -5.543181953783795e-14,  6.010936338097894e-16, -4.816901512219294e-19, -6.970152322100902e-21,  2.103437364256838e-23,  5.532233748209564e-26, -4.282120590557582e-28,
  9.466027111633986e-01, -2.978294465125225e-03,  1.904162809252245e-06,  1.573087913795464e-08, -3.642140203118584e-11, -1.172693802162625e-13,  6.125425309159341e-16,
  5.612336062150729e-19, -9.361392897904185e-21,  7.572100314176589e-24,  1.268037813630831e-25, -3.373357286983316e-28,  1.022408917598075e+00, -3.047407920950459e-03,
  9.612612358425974e-07,  1.815756134889032e-08, -2.467665351819378e-11, -1.773846109273803e-13,  5.023358051698791e-16,  1.824155504966404e-18, -9.427446362627150e-21,
 -1.573318619465252e-23,  1.669463154426645e-25,  3.532797407973661e-29,  1.099688531785636e+00, -3.084037338136270e-03, -1.038820370738638e-07,  1.979561018102983e-08,
 -8.190081714336239e-12, -2.247596850434975e-13,  2.522192014092720e-16,  3.000002831675656e-18, -6.005544383653986e-21, -4.245742717740192e-23,  1.312867944196535e-25,
  6.035684348509056e-28,  1.178052225735182e+00, -3.083992041415973e-03, -1.260811876832027e-06,  2.035276690338029e-08,  1.213395348076327e-11, -2.467108927580054e-13,
 -1.247169422619123e-16,  3.656188267022141e-18,  1.102021549601723e-21, -6.005181734317764e-23, -2.646122467037314e-27,  1.047789968157879e-27,  1.257046723836162e+00,
 -3.043437345975852e-03, -2.466335105473596e-06,  1.956606521575391e-08,  3.447861543374563e-11, -2.312720298586242e-13, -5.709568430674532e-16,  3.344793049896170e-18,
  1.035774375060028e-20, -5.364285528574845e-23, -1.990245763012252e-25,  9.135889917053379e-28,  1.336146919685438e+00, -2.959182012204666e-03, -3.663788436596147e-06,
  1.724896920220617e-08,  5.606747457003060e-11, -1.708508787544143e-13, -9.806392092790950e-16,  1.803410250562508e-18,  1.820451785977195e-20, -1.500517395835438e-23,
 -3.472044651265131e-25, -4.003915901475088e-29,  1.414748315357789e+00, -2.829045706242603e-03, -4.783607483693860e-06,  1.334969121177232e-08,  7.333498425418778e-11,
 -6.671154302947827e-14, -1.214470952097146e-15, -7.970838466852877e-19,  1.995358793220693e-20,  4.616732304028301e-23, -3.047326382618947e-25, -1.391293183622581e-27,
  1.492160556009470e+00, -2.652308081574688e-03, -5.745935749290997e-06,  8.013909003792242e-09,  8.241853955818631e-11,  6.700648528312755e-14, -1.141228580786432e-15,
 -3.684162722747330e-18,  1.224111470624616e-20,  9.750554517781858e-23, -1.460567736516219e-26, -2.000156610855324e-27,  1.567603175813238e+00, -2.430227405850636e-03,
 -6.466088781704025e-06,  1.637801725274098e-09,  8.003096576783870e-11,  2.020076372196750e-13, -7.033936536241616e-16, -5.590812954381983e-18, -3.657878939294629e-21,
  9.739970790305484e-23,  3.714923438661601e-25, -8.717263055803878e-28,  1.640205064763261e+00, -2.166594308448224e-03, -6.863558920415970e-06, -5.111219232478983e-09,
  6.464508912561246e-11,  3.001115813746011e-13,  1.590008471955489e-17, -5.294332425980289e-18, -2.008060983026218e-20,  2.890920816908254e-23,  5.240814136825776e-25,
  1.419030576590137e-27,  1.709009552684146e+00, -1.868254300786247e-03, -6.874741457142812e-06, -1.133509482666266e-08,  3.769920018191445e-11,  3.249235140052299e-13,
  7.710388027183800e-16, -2.483881217284602e-18, -2.600961208157705e-20, -6.877209985375011e-23,  2.253286069809205e-25,  2.534564991130855e-27,  1.772987275124005e+00,
 -1.545493588099604e-03, -6.468519902674451e-06, -1.603381068431523e-08,  4.264826116618062e-12,  2.592169095402571e-13,  1.228700524041017e-15,  1.592145837764952e-18,
 -1.545957794554939e-20, -1.148311052734486e-22, -2.956625418050646e-25,  8.726601187996933e-28,  1.831058959285786e+00, -1.212144766729326e-03, -5.662233111440362e-06,
 -1.832982438797145e-08, -2.752933810480344e-11,  1.205214454694573e-13,  1.147061420835511e-15,  4.510104080614816e-18,  4.739773656514628e-21, -6.253330137651126e-23,
 -4.843016253851047e-25, -1.662799774377413e-27,  1.882129720781516e+00, -8.852489871015472e-04, -4.533657584667489e-06, -1.775458760717710e-08, -4.878579474164372e-11,
 -3.729814755001926e-14,  5.699254881268364e-16,  4.358844721236530e-18,  1.798585216820475e-20,  3.416793346967933e-23, -1.385173515672720e-25, -1.683967220920488e-27,
  1.925135183385013e+00, -5.841329373658097e-04, -3.223284726358187e-06, -1.450760755506963e-08, -5.348604504315005e-11, -1.458187429883563e-13, -1.372268159917911e-16,
  1.573567627132651e-18,  1.379195278870183e-20,  7.001570599159821e-23,  2.408270521163530e-25,  3.557211965057437e-28,  1.959097668657704e+00, -3.288454061044632e-04,
 -1.921613480935692e-06, -9.556426196221665e-09, -4.194236722698320e-11, -1.617199129258219e-13, -5.227710559700972e-16, -1.185827851698727e-18,  2.277037746068878e-22,
  2.352379770296414e-23,  1.788298833571670e-25,  9.481155978546022e-28,  1.983188247400574e+00, -1.380533447956735e-04, -8.395262737256049e-07, -4.461718905427445e-09,
 -2.174845711728400e-11, -9.895171510041000e-14, -4.219751150835800e-16, -1.677518615225418e-18, -6.108332469921011e-21, -1.950908011902045e-23, -4.796693994277401e-26,
 -3.333891689691216e-29,  1.996791099381381e+00, -2.666653294204445e-05, -1.658110943383463e-07, -9.136102406435957e-10, -4.701145745493641e-12, -2.311523151703369e-14,
 -1.098934729806096e-16, -5.085139141268383e-19, -2.299088717307654e-21, -1.017781228029612e-23, -4.415805167706139e-26, -1.877650800243906e-28,  4.391890930625003e-04,
 -2.071426423703048e-06,  7.325958147992631e-09, -2.302692014476757e-11,  6.783184041281890e-14, -1.917793543525462e-16,  5.268737255703283e-19, -1.417627371413219e-21,
  3.751487706042331e-24, -9.805379857587117e-27,  2.533147348767126e-29, -6.496563330079518e-32,  3.952438353717862e-03, -1.862334741659241e-05,  6.571855665531596e-08,
 -2.057567476709376e-10,  6.024201737860184e-13, -1.688325830940439e-15,  4.583146629663966e-18, -1.213952537873586e-20,  3.148686812122598e-23, -8.026327576033302e-26,
  2.010367117789066e-28, -4.966597751406416e-31,  1.097751961508977e-02, -5.162298752887556e-05,  1.813560984110794e-07, -5.633121669585596e-10,  1.628865431193595e-12,
 -4.483006537558315e-15,  1.186710717545088e-17, -3.038623513807864e-20,  7.536261372615146e-23, -1.811947641155284e-25,  4.202818892486980e-28, -9.388884325645243e-31,
  2.151154036226260e-02, -1.008607258152819e-04,  3.519403096228120e-07, -1.079975283495519e-09,  3.063101329225400e-12, -8.191434267337897e-15,  2.080689696551582e-17,
 -5.025914138812223e-20,  1.147433588516038e-22, -2.446466613897502e-25,  4.712318042962220e-28, -7.650472400412866e-31,  3.555001529887660e-02, -1.660190771949520e-04,
  5.740167201180845e-07, -1.732401436900098e-09,  4.782554702697332e-12, -1.226808614755850e-14,  2.925504817491639e-17, -6.411265279056890e-20,  1.247517492703049e-22,
 -1.965672121518308e-25,  1.542906348590538e-28,  4.968809835134997e-31,  5.308668616877524e-02, -2.466689987855228e-04,  8.429671936684527e-07, -2.489914040607078e-09,
  6.630473116417045e-12, -1.604343682321250e-14,  3.473224580498300e-17, -6.389322160171153e-20,  8.269308225126388e-23,  1.564238549218031e-26, -6.110647541892436e-28,
  2.788788899686902e-30,  7.411327412456005e-02, -3.422649181136162e-04,  1.153001715243570e-06, -3.314925186662280e-09,  8.421849777039133e-12, -1.877312656082935e-14,
  3.473698189146250e-17, -4.274782419759239e-20, -2.480494257054790e-23,  3.957616786981766e-25, -1.696992784035443e-27,  5.290117740822953e-30,  9.861915801274189e-02,
 -4.521384470522363e-04,  1.497151091209654e-06, -4.163506432756184e-09,  9.951066424859471e-12, -1.969863035002731e-14,  2.710596278390121e-17,  3.256528976360855e-21,
 -1.951138307686498e-22,  8.785870758957891e-25, -2.730658416577268e-27,  6.477686787529068e-30,  1.265909699121797e-01, -5.754907420398081e-04,  1.867262840138043e-06,
 -4.986141268040091e-09,  1.100138735092859e-11, -1.811844083876788e-14,  1.040393487091108e-17,  7.350634842587741e-20, -4.047730666300436e-22,  1.324308868350836e-24,
 -3.140779432525492e-27,  4.568170611385572e-30,  1.580120969651261e-01, -7.113834727971844e-04,  2.254003326210580e-06, -5.728698303291683e-09,  1.135643381982219e-11,
 -1.346808245383297e-14, -1.568607340497858e-17,  1.615577500185397e-19, -6.080015378825309e-22,  1.533902215024578e-24, -2.304211438013042e-27, -1.676182537823571e-30,
  1.928620759123049e-01, -8.587283706442393e-04,  2.646870158569970e-06, -6.333672107778097e-09,  1.081373971393855e-11, -5.406262489153559e-15, -5.001028881781180e-17,
  2.544843570065816e-19, -7.399932608967297e-22,  1.289546495925578e-24,  2.143370814062642e-28, -1.195118249377578e-29,  2.311158637130498e-01, -1.016275346786690e-03,
  3.034220099326796e-06, -6.741746469785869e-09,  9.200424586597423e-12,  6.096943548143587e-15, -8.967819579369283e-17,  3.331714529609793e-19, -7.261356048806120e-22,
  4.196435523261326e-25,  4.369794395504672e-27, -2.356760891033888e-29,  2.727429641216991e-01, -1.182599204984396e-03,  3.403319247355250e-06, -6.893742017255650e-09,
  6.390903730624366e-12,  2.067586000187150e-14, -1.299427644304212e-16,  3.738669276775269e-19, -4.976294194618447e-22, -1.118668304116791e-24,  9.371496558520380e-27,
 -3.124636297671720e-29,  3.177063860228196e-01, -1.356085027880085e-03,  3.740424155299769e-06, -6.733015435502398e-09,  2.326365402842412e-12,  3.749734233441782e-14,
 -1.642968321668922e-16,  3.512457449245664e-19, -1.286318914963842e-23, -3.155373393052989e-24,  1.356346390097378e-26, -2.807194340428309e-29,  3.659614046240083e-01,
 -1.534912400257266e-03,  4.030904852364843e-06, -6.208379067446914e-09, -2.964543750490185e-12,  5.521264993858216e-14, -1.848621516139931e-16,  2.431128046855818e-19,
  7.177935137958248e-22, -5.247651561058217e-24,  1.459068752042144e-26, -7.955168616542819e-30,  4.174540912023451e-01, -1.717038756871497e-03,  4.259423531544988e-06,
 -5.277604526067774e-09, -9.344805191458876e-12,  7.194785558890215e-14, -1.831462418283319e-16,  3.662481257143127e-20,  1.608369949701768e-21, -6.679045444104058e-24,
  9.976687020886627e-27,  3.051678311092977e-29,  4.721195709649676e-01, -1.900182322391675e-03,  4.410185929959125e-06, -3.911557640713417e-09, -1.654945658892776e-11,
  8.535115548531731e-14, -1.512262033935928e-16, -2.644808090528141e-19,  2.482102907656812e-21, -6.556747137798259e-24, -1.842711148448246e-27,  7.979028487745793e-29,
  5.298799617389851e-01, -2.081805366455090e-03,  4.467286130094945e-06, -2.098978106874990e-09, -2.416972407952711e-11,  9.271853345731429e-14, -8.337872950569319e-17,
 -6.327286952828465e-19,  3.074504115691295e-21, -4.039071129202943e-24, -2.015621353667771e-26,  1.206456376937052e-28,  5.906419387759763e-01, -2.259098854002706e-03,
  4.415169458234039e-06,  1.481435434436973e-10, -3.164423968628685e-11,  9.122068241142041e-14,  2.190031644232646e-17, -1.011632317120291e-18,  3.065989070995961e-21,
  1.301075663392583e-24, -4.068312409373392e-26,  1.240901198115855e-28,  6.542938632374409e-01, -2.428970063123563e-03,  4.239241958144739e-06,  2.788738983368786e-09,
 -3.826195661170791e-11,  7.825195687043915e-14,  1.596684346884848e-16, -1.314936669889775e-18,  2.154015059092016e-21,  9.024755385378723e-24, -5.507904671329592e-26,
  6.093469596117658e-29,  7.207024044921256e-01, -2.588035410354095e-03,  3.926657821174365e-06,  5.746687505203180e-09, -4.318273523127584e-11,  5.191344182777633e-14,
  3.164675807693501e-16, -1.433698763965946e-18,  1.680009202379773e-22,  1.742040134173707e-23, -5.223142297548568e-26, -7.981770968005669e-29,  7.897085802109021e-01,
 -2.732621614130185e-03,  3.467316843536409e-06,  8.905224958307915e-09, -4.548284151478229e-11,  1.162278807527093e-14,  4.690238868687242e-16, -1.254659886017599e-18,
 -2.784580067189673e-21,  2.337924106661715e-23, -2.225712698030723e-26, -2.678363885934596e-28,  8.611231350610683e-01, -2.858779491032766e-03,  2.855100292489620e-06,
  1.210258869498765e-08, -4.423333027223364e-11, -4.119191024154640e-14,  5.846003514523132e-16, -6.922288639177289e-19, -6.177602870065253e-21,  2.287292530928580e-23,
  3.669361465044106e-26, -4.161176701349348e-28,  9.347211812404004e-01, -2.962316160109871e-03,  2.089362107041877e-06,  1.513017709757403e-08, -3.861868030204958e-11,
 -1.024133496419589e-13,  6.241109536444222e-16,  2.669793320871086e-19, -9.001244977301538e-21,  1.232908574476248e-23,  1.106285213598054e-25, -3.945759663394527e-28,
  1.010236036242859e+00, -3.038853245453845e-03,  1.176668107274570e-06,  1.773502514713960e-08, -2.809982619183552e-11, -1.647502022377755e-13,  5.491127101846055e-16,
  1.514704438667650e-18, -9.873619285233311e-21, -9.063004997290527e-24,  1.656218710424891e-25, -9.376561206025242e-29,  1.087352221194325e+00, -3.083920772204175e-03,
  1.327318382925174e-07,  1.962896436944119e-08, -1.261805688919403e-11, -2.177215141320145e-13,  3.333065324091823e-16,  2.784433026014394e-18, -7.433449657133169e-21,
 -3.671511310416636e-23,  1.548005799435334e-25,  4.625088680113934e-28,  1.165697635553683e+00, -3.093098679068071e-03, -1.015577075229352e-06,  2.050730863837233e-08,
  7.178107916870464e-12, -2.484736312719746e-13, -2.217459061506923e-17,  3.656932494399898e-18, -1.050697651694541e-21, -5.924278445607694e-23,  4.283648740846781e-26,
  1.011963155828291e-27,  1.244835012881949e+00, -3.062219833715774e-03, -2.228387338488390e-06,  2.008000750308097e-08,  2.972391698476658e-11, -2.438155273274441e-13,
 -4.729631665759708e-16,  3.643887949256117e-18,  8.293478178182303e-21, -6.074699384088804e-23, -1.549539518939193e-25,  1.082088749379210e-27,  1.324252903120463e+00,
 -2.987649386733935e-03, -3.451535182665517e-06,  1.811745224664271e-08,  5.241953145814322e-11, -1.937150413402291e-13, -9.220884084531649e-16,  2.374633659667255e-18,
  1.741478522443757e-20, -2.883338216817155e-23, -3.418319244193962e-25,  2.856162515167019e-28,  1.403356637403556e+00, -2.866653945541150e-03, -4.616420207775533e-06,
  1.451078717151391e-08,  7.170785167269277e-11, -9.605306517808366e-14, -1.227617683742639e-15, -1.344454142653720e-19,  2.138199287004440e-20,  3.281441368750150e-23,
 -3.612582199997701e-25, -1.164219703288554e-27,  1.481460029538880e+00, -2.697868390083455e-03, -5.641817351542020e-06,  9.341804276891589e-09,  8.347666122024586e-11,
  3.842661960613290e-14, -1.238375235710714e-15, -3.236572214891958e-18,  1.571906949433845e-20,  9.510540329271914e-23, -1.066224615619621e-25, -2.167453091308429e-27,
  1.557778964371143e+00, -2.481855432371372e-03, -6.438621980289777e-06,  2.949647754167157e-09,  8.388956982864636e-11,  1.832377899037907e-13, -8.610280510021654e-16,
 -5.648979020045582e-18,  1.053594635517471e-22,  1.113401538830334e-22,  3.217214924575558e-25, -1.394148762572388e-27,  1.631428507559076e+00, -2.221730078821649e-03,
 -6.918489622675165e-06, -4.028910914388820e-09,  7.063875857803378e-11,  2.986427854408727e-13, -1.411513530520892e-16, -5.916097556912649e-18, -1.864831871968299e-20,
  5.102848155013214e-23,  5.793364167337958e-25,  1.069366967643362e-27,  1.701425693286197e+00, -1.923785562521008e-03, -7.006925834204808e-06, -1.067893979418577e-08,
  4.437659080105723e-11,  3.424975904890594e-13,  6.894793215411564e-16, -3.353838146501069e-18, -2.829543103605557e-20, -5.743473202975213e-23,  3.437254749065652e-25,
  2.834002160653233e-27,  1.766700588053915e+00, -1.598009805710896e-03, -6.660339895502270e-06, -1.592248243365277e-08,  9.747358011583203e-12,  2.891808819800948e-13,
  1.265717461141637e-15,  1.029099180537144e-18, -1.979559635579942e-20, -1.257206962786695e-22, -2.444440199118811e-25,  1.472947168493923e-27,  1.826118381105194e+00,
 -1.258329758046613e-03, -5.884749313214354e-06, -1.874947138171843e-08, -2.483330628663049e-11,  1.495812362487579e-13,  1.275101841149657e-15,  4.621876291940960e-18,
  2.122338281572815e-21, -8.335686115314393e-23, -5.563829881338426e-25, -1.594473775033801e-27,  1.878514818160945e+00, -9.223837893741588e-04, -4.751418165430984e-06,
 -1.854034216337471e-08, -4.938474892425458e-11, -2.208923256439811e-14,  7.002072184868674e-16,  4.952850876960262e-18,  1.909715351175298e-20,  2.701768407685013e-23,
 -2.222572672904794e-25, -2.131740816614709e-27,  1.922745955669522e+00, -6.106303512725222e-04, -3.402607454201616e-06, -1.538687831030810e-08, -5.643151761582205e-11,
 -1.485311999580355e-13, -8.659578103023510e-17,  2.057126720877916e-18,  1.648933878779749e-20,  7.992269758391642e-23,  2.534222170864102e-25,  2.042849837456142e-28,
  1.957750798493598e+00, -3.446886810323877e-04, -2.040426036658829e-06, -1.025407221512400e-08, -4.530491223419406e-11, -1.746631991127301e-13, -5.557345814673984e-16,
 -1.163526016532163e-18,  1.213898000655721e-21,  3.156956830387718e-23,  2.249565228703221e-25,  1.153802517781301e-27,  1.982622253956066e+00, -1.449897871357843e-04,
 -8.952218876394747e-07, -4.826093125072362e-09, -2.383268701388783e-11, -1.096655140973587e-13, -4.717904063470035e-16, -1.884595088974075e-18, -6.845461123505771e-21,
 -2.144720926400073e-23, -4.866535933590431e-26,  4.394954136932298e-30,  1.996681708984960e+00, -2.803818979077162e-05, -1.772414610576975e-07, -9.926753057836256e-10,
 -5.191022566649421e-12, -2.593220020394073e-14, -1.252194640546905e-16, -5.883049192560828e-19, -2.699379932891330e-21, -1.212103313707714e-23, -5.330727052046548e-26,
 -2.295740657473313e-28,  4.310188783207681e-04, -2.013905887532433e-06,  7.056022577779005e-09, -2.197162160738605e-11,  6.411955658976509e-14, -1.795974616664890e-16,
  4.888091214793326e-19, -1.303037559577029e-21,  3.416064442983459e-24, -8.847037212108824e-27,  2.263965105917893e-29, -5.755035715803458e-32,  3.878981051439318e-03,
 -1.810731395694322e-05,  6.330621277319534e-08, -1.963822941536342e-10,  5.697266572104447e-13, -1.582297951270405e-15,  4.256922473526460e-18, -1.117666699046276e-20,
  2.873702103712285e-23, -7.264238274690452e-26,  1.804035701772413e-28, -4.423257089980100e-31,  1.077388716744945e-02, -5.019874138925198e-05,  1.747498140525467e-07,
 -5.379524108479486e-10,  1.541985873399151e-12, -4.208139142374384e-15,  1.104909708888411e-17, -2.807583426438270e-20,  6.913249894377889e-23, -1.651824172914969e-25,
  3.809938178742758e-28, -8.484804796593742e-31,  2.111364758586836e-02, -9.809622126539520e-05,  3.392693442005918e-07, -1.032249630622281e-09,  2.904154421676708e-12,
 -7.708548909167710e-15,  1.944974756204862e-17, -4.672469767854544e-20,  1.062673504396742e-22, -2.264599398701534e-25,  4.383726399466926e-28, -7.282206117950160e-31,
  3.489499340733379e-02, -1.615088162507391e-04,  5.536790531148652e-07, -1.657805909177646e-09,  4.544071087584015e-12, -1.158706223539194e-14,  2.751472758481416e-17,
 -6.023258842232089e-20,  1.177912672442886e-22, -1.900040900096587e-25,  1.727873341246029e-28,  3.487685076775541e-31,  5.211331092958239e-02, -2.400429977162070e-04,
  8.137143069920180e-07, -2.386348732666324e-09,  6.317796756100225e-12, -1.523103167069555e-14,  3.298033447689365e-17, -6.124251803358420e-20,  8.284465175243955e-23,
 -6.472836482901037e-27, -4.977249130944506e-28,  2.372840658342964e-30,  7.276241374197251e-02, -3.331977583003752e-04,  1.114018865932217e-06, -3.183134401863913e-09,
  8.054626760050488e-12, -1.795387925173669e-14,  3.353098124165170e-17, -4.332628023980244e-20, -1.172494556038030e-23,  3.323531053465749e-25, -1.477879998838475e-27,
  4.679873549088827e-30,  9.683424599752626e-02, -4.403584096534366e-04,  1.448131429847876e-06, -4.007405785963150e-09,  9.563603109764479e-12, -1.904767009581466e-14,
  2.711434240168514e-17, -2.501579622272457e-21, -1.653834466404679e-22,  7.749111828302028e-25, -2.456833054042849e-27,  5.970254884016986e-30,  1.243185083910648e-01,
 -5.607890091707290e-04,  1.808473365732389e-06, -4.813003780225123e-09,  1.064167481032992e-11, -1.784546873350003e-14,  1.228777087144651e-17,  6.129256057888183e-20,
 -3.593105673480598e-22,  1.202729007372226e-24, -2.937645846144524e-27,  4.646573239788596e-30,  1.552021960798080e-01, -6.936233553529591e-04,  2.186340213134025e-06,
 -5.549169210884056e-09,  1.108366277796562e-11, -1.379241296053143e-14, -1.142666716645540e-17,  1.429673174861850e-19, -5.544545746715722e-22,  1.440616223709864e-24,
 -2.351721401268164e-27, -5.267723129262071e-31,  1.894690351343075e-01, -8.378544929290224e-04,  2.571900439417426e-06, -6.161580112670155e-09,  1.069417551852985e-11,
 -6.523635562473401e-15, -4.320925871945064e-17,  2.315480217139834e-19, -6.935353068049718e-22,  1.288332403837150e-24, -2.576274448869981e-28, -9.559727390869165e-30,
  2.270988010190038e-01, -9.923226787839810e-04,  2.954206036184872e-06, -6.593677981056949e-09,  9.301582816871919e-12,  4.054001866890979e-15, -8.067220370613279e-17,
  3.102085914843854e-19, -7.081234906916821e-22,  5.746373740597676e-25,  3.402743293462560e-27, -2.043109036578825e-29,  2.680664989795020e-01, -1.155701781952598e-03,
  3.321220976741791e-06, -6.788345338942486e-09,  6.774073148993170e-12,  1.768101882469926e-14, -1.197029822235489e-16,  3.573681354882378e-19, -5.314787214142015e-22,
 -7.705766584246804e-25,  8.051354823144117e-27, -2.873966870088891e-29,  3.123413819553468e-01, -1.326484130986570e-03,  3.659875364540265e-06, -6.690004915637805e-09,
  3.037676962813838e-12,  3.367208914272001e-14, -1.544840583995887e-16,  3.491189137288179e-19, -1.169897676826584e-22, -2.637654059192932e-24,  1.232101027350469e-26,
 -2.827975040673362e-29,  3.598857766341107e-01, -1.502963887620737e-03,  3.956155373278127e-06, -6.247216444775721e-09, -1.904093600270452e-12,  5.086006919409725e-14,
 -1.777610232453350e-16,  2.631714096837453e-19,  5.392845708485609e-22, -4.672588995482268e-24,  1.412623364253906e-26, -1.292925525981891e-29,  4.106536824072462e-01,
 -1.683219127612129e-03,  4.195241889107172e-06, -5.415848124451651e-09, -7.949690987986790e-12,  6.757024823111907e-14, -1.814357809536024e-16,  8.432497458418934e-20,
  1.375401954538055e-21, -6.256305361786416e-24,  1.108435035997037e-26,  2.008620557193788e-29,  4.645891011863236e-01, -1.865092962730234e-03,  4.361714176924103e-06,
 -4.162892319406301e-09, -1.487928215181354e-11,  8.164161788941651e-14, -1.575552319118647e-16, -1.888378054800391e-19,  2.245542220125777e-21, -6.564309090897544e-24,
  1.365155573865331e-27,  6.613955271411227e-29,  5.216240482326187e-01, -2.046174262331723e-03,  4.439838925360229e-06, -2.470973277993017e-09, -2.233674246739171e-11,
  9.051582484927865e-14, -9.974066472887604e-17, -5.368164723466460e-19,  2.915836736332893e-21, -4.742211380939876e-24, -1.507908736535997e-26,  1.099073441958897e-28,
  5.816761853618011e-01, -2.223778855885969e-03,  4.413969606069378e-06, -3.435498551709813e-10, -2.981680690338908e-11,  9.141750047945413e-14, -5.046961010590724e-18,
 -9.130745932119840e-19,  3.084858749155877e-21, -2.163474440940840e-25, -3.517830191178424e-26,  1.254384670606395e-28,  6.446460082662941e-01, -2.394932555005283e-03,
  4.269085964982738e-06,  2.189263823950444e-09, -3.666153785313366e-11,  8.165025463521626e-14,  1.238610495528572e-16, -1.241229474992157e-18,  2.439958846696286e-21,
  6.882086808077301e-24, -5.189543142578004e-26,  8.276319052966258e-29,  7.104135096492574e-01, -2.556357970966581e-03,  3.991508091034115e-06,  5.064468935316072e-09,
 -4.207176025854550e-11,  5.902811337329136e-14,  2.764906482700690e-16, -1.418697893194873e-18,  7.568015706465136e-22,  1.527393204661711e-23, -5.477811900649832e-26,
 -3.673124220470878e-29,  7.788342301837879e-01, -2.704467978336580e-03,  3.569822809397018e-06,  8.179958631690991e-09, -4.514071435132691e-11,  2.244849758612985e-14,
  4.327710923803634e-16, -1.330494009725868e-18, -1.961659870686832e-21,  2.226787268144324e-23, -3.294625119626974e-26, -2.177546191068736e-28,  8.497346014364074e-01,
 -2.835369853594609e-03,  2.996060220862195e-06,  1.138902004177896e-08, -4.491854655212374e-11, -2.741565882412254e-14,  5.625759794817912e-16, -8.764895093836844e-19,
 -5.332111888097773e-21,  2.398111947317680e-23,  1.890247640878297e-26, -3.905714180955950e-28,  9.229064812589964e-01, -2.944885669404458e-03,  2.267151887884726e-06,
  1.449670787908553e-08, -4.051672152337797e-11, -8.737709040693864e-14,  6.276264307027523e-16, -1.313962790812379e-20, -8.482044505559669e-21,  1.639464902680415e-23,
  9.238038449737735e-26, -4.315534445644413e-28,  9.981007866981226e-01, -3.028596508240564e-03,  1.386684447891120e-06,  1.725979771292047e-08, -3.125979346825033e-11,
 -1.510985155074152e-13,  5.870610626428732e-16,  1.194796732827785e-18, -1.008195663022318e-20, -2.555864841444358e-24,  1.588909349188922e-25, -2.096055392208579e-28,
  1.075020148338280e+00, -3.081920487302917e-03,  3.669258601831758e-07,  1.939270065766946e-08, -1.688632245018016e-11, -2.088146448399904e-13,  4.077505072515119e-16,
  2.526646944430466e-18, -8.639237323737973e-21, -3.016063726051189e-23,  1.718044473726275e-25,  3.090363415810476e-28,  1.153310552418090e+00, -3.100237370105216e-03,
 -7.689642645662058e-07,  2.058240838891135e-08,  2.211579364614336e-12, -2.477828481446670e-13,  7.943104122410128e-17,  3.589602947830832e-18, -3.142046214747717e-21,
 -5.665933157964350e-23,  8.575163538067563e-26,  9.317978913402305e-28,  1.232552016350783e+00, -3.079075381590334e-03, -1.984736572438982e-06,  2.051599814956988e-08,
  2.474250588162627e-11, -2.539143688630112e-13, -3.675555659140205e-16,  3.873188260357874e-18,  6.006853742461945e-21, -6.595415659542508e-23, -1.045411256315329e-25,
  1.200479082944833e-27,  1.312248477668172e+00, -3.014378074516869e-03, -3.229225163046945e-06,  1.892399166631887e-08,  4.832963611861339e-11, -2.149853671168008e-13,
 -8.479715321518142e-16,  2.912690167821339e-18,  1.613457038907464e-20, -4.215908357035997e-23, -3.220879965368330e-25,  6.100409515706594e-28,  1.391817289048114e+00,
 -2.902869441285162e-03, -4.435475388557008e-06,  1.564114361847643e-08,  6.949226105060158e-11, -1.254827565225130e-13, -1.221645870637071e-15,  5.657953182551336e-19,
  2.229162279791973e-20,  1.742437183053544e-23, -4.060102428843335e-25, -8.577506771793574e-28,  1.470579028996694e+00, -2.742531768870382e-03, -5.521681891710451e-06,
  1.068193452488658e-08,  8.394095007052488e-11,  7.678095344388882e-15, -1.321449362093960e-15, -2.679792738967850e-18,  1.904284801102286e-20,  8.890565999237047e-23,
 -2.038490392102946e-25, -2.233676311225476e-27,  1.547748781434492e+00, -2.533199736198484e-03, -6.395055655396889e-06,  4.320022414083610e-09,  8.733488500867261e-11,
  1.606792299817908e-13, -1.018532722973008e-15, -5.579121235675862e-18,  4.329038764370296e-21,  1.228260576426226e-22,  2.487257793694069e-25, -1.921885406319550e-27,
  1.622430612934508e+00, -2.277251717327874e-03, -6.959858881568629e-06, -2.851149503942752e-09,  7.656397954533067e-11,  2.932017713165060e-13, -3.148479838745154e-16,
 -6.478894689282286e-18, -1.638403772813537e-20,  7.500848774683589e-23,  6.160782876051775e-25,  5.771120319094155e-28,  1.693617646357473e+00, -1.980340961600538e-03,
 -7.130584089970514e-06, -9.913249438669411e-09,  5.138387461601933e-11,  3.578140787901026e-13,  5.826050156681305e-16, -4.289472694990168e-18, -3.008492026956132e-20,
 -4.112456604684641e-23,  4.732330257531792e-25,  3.032388499276201e-27,  1.760200777620143e+00, -1.652053702429030e-03, -6.850277709013719e-06, -1.571859681377252e-08,
  1.583669391749281e-11,  3.198280514095554e-13,  1.284970748465424e-15,  3.214764359112711e-19, -2.448011889193082e-20, -1.340028887649408e-22, -1.645629190083179e-25,
  2.173219257811413e-27,  1.820989471901816e+00, -1.306314243452937e-03, -6.112022737076359e-06, -1.912116445041504e-08, -2.152514737849603e-11,  1.817413755474416e-13,
  1.404982652485897e-15,  4.637347775589903e-18, -1.295587152950514e-21, -1.069665287290342e-22, -6.226216418480534e-25, -1.390792081073545e-27,  1.874747832246551e+00,
 -9.612985311774584e-04, -4.978654696658253e-06, -1.933307094876519e-08, -4.964689031450861e-11, -3.550213447159663e-15,  8.475754500271659e-16,  5.577614153151751e-18,
  1.988585828509528e-20,  1.610783641491541e-23, -3.268725991691671e-25, -2.630901907398734e-27,  1.920247801174254e+00, -6.386053568371794e-04, -3.592765759820945e-06,
 -1.631363981373939e-08, -5.941793934874513e-11, -1.498559498112790e-13, -2.116243500931812e-17,  2.632791385823436e-18,  1.955062273977766e-20,  9.017611473514691e-23,
  2.575068630829846e-25, -3.530443535534354e-29,  1.956338599890284e+00, -3.615168779789814e-04, -2.167941829994001e-06, -1.100763258434151e-08, -4.893416401718481e-11,
 -1.883862696020572e-13, -5.875856527393626e-16, -1.104657236878736e-18,  2.525218388416069e-21,  4.165088637684820e-23,  2.808437870850968e-25,  1.391934266206125e-27,
  1.982027595097576e+00, -1.523898679772755e-04, -9.554973652900036e-07, -5.225596210191791e-09, -2.614363225924128e-11, -1.216471878134996e-13, -5.277445797447820e-16,
 -2.116377867755437e-18, -7.652416170609960e-21, -2.337459817576495e-23, -4.728273763786305e-26,  6.237086081758584e-29,  1.996566642872404e+00, -2.950522235838984e-05,
 -1.896695628099501e-07, -1.080049886649458e-09, -5.741105729832779e-12, -2.914531716402057e-14, -1.429699756592199e-16, -6.820989317121484e-19, -3.176682852394380e-21,
 -1.446978768227014e-23, -6.450726868489267e-26, -2.813499711269733e-28,  4.230745055557796e-04, -1.958495173135611e-06,  6.798402092960286e-09, -2.097381907511257e-11,
  6.064202886937389e-14, -1.682917990415212e-16,  4.538078045042319e-19, -1.198649446212617e-21,  3.113279499268807e-24, -7.990118649945953e-27,  2.025365262535485e-29,
 -5.104385293138699e-32,  3.807549985610466e-03, -1.761013800877527e-05,  6.100329238074304e-08, -1.875143888463832e-10,  5.390775378598420e-13, -1.483785626456171e-15,
  3.956466555901698e-18, -1.029756880269284e-20,  2.624722873931546e-23, -6.580092894691413e-26,  1.620185465689511e-28, -3.943373528753381e-31,  1.057584789833984e-02,
 -4.882615147646724e-05,  1.684396843461364e-07, -5.139397939675460e-10,  1.460412466869765e-12, -3.952149700689017e-15,  1.029307167602945e-17, -2.595586963756809e-20,
  6.345147526347723e-23, -1.506647299698421e-25,  3.454837830698761e-28, -7.670163070348037e-31,  2.072661365929434e-02, -9.543083611845437e-05,  3.271561407720904e-07,
 -9.869916032311888e-10,  2.754547365687665e-12, -7.257077616867944e-15,  1.818786196716426e-17, -4.345126115824352e-20,  9.842280062380395e-23, -2.095546768332923e-25,
  4.071691872347377e-28, -6.899744752543638e-31,  3.425769273592461e-02, -1.571577399041707e-04,  5.342140802417768e-07, -1.586919388360875e-09,  4.318798944624931e-12,
 -1.094652726174838e-14,  2.587996696741989e-17, -5.657134856644918e-20,  1.110788813199416e-22, -1.828230900510018e-25,  1.853821805603402e-28,  2.278064535548942e-31,
  5.116597940098518e-02, -2.336461324333526e-04,  7.856747159365630e-07, -2.287658520923171e-09,  6.020954051732658e-12, -1.445978191080396e-14,  3.130259710020383e-17,
 -5.859886239880655e-20,  8.227742253050328e-23, -2.440355186720438e-26, -4.014337212043845e-28,  2.012608680198135e-30,  7.144720814976382e-02, -3.244362339736005e-04,
  1.076582788224835e-06, -3.057089683075155e-09,  7.703498172854040e-12, -1.716372507222666e-14,  3.231431225525591e-17, -4.352105959638399e-20, -7.762017288486353e-25,
  2.771901191203083e-25, -1.284273693184253e-27,  4.130000460226046e-30,  9.509568153349159e-02, -4.289631411152406e-04,  1.400948209293311e-06, -3.857400440570426e-09,
  9.189148492710425e-12, -1.839833932437059e-14,  2.697426791607725e-17, -7.365962815498618e-21, -1.391935950561077e-22,  6.817447480803057e-25, -2.205097790189069e-27,
  5.474824234462535e-30,  1.221039261907217e-01, -5.465493789089790e-04,  1.751727196584833e-06, -4.645575674369639e-09,  1.028784696425198e-11, -1.753122799257293e-14,
  1.384934123188258e-17,  5.046511574358633e-20, -3.180781429732831e-22,  1.089312285736652e-24, -2.733347540379858e-27,  4.625345595412548e-30,  1.524622665933189e-01,
 -6.763960000683954e-04,  2.120805066604665e-06, -5.374050967298687e-09,  1.080538620784900e-11, -1.402057359082998e-14, -7.664310927354472e-18,  1.260363826783925e-19,
 -5.042886091886759e-22,  1.346366845489141e-24, -2.354152258565356e-27,  3.793426446790837e-31,  1.861583033825756e-01, -8.175721467145825e-04,  2.498983636715393e-06,
 -5.991571271170534e-09,  1.055384495684646e-11, -7.485322695797185e-15, -3.702966423138989e-17,  2.100941977886391e-19, -6.474364406981291e-22,  1.270243036389658e-24,
 -6.318747296390139e-28, -7.504371999606259e-30,  2.231762800600090e-01, -9.690029915139631e-04,  2.875977195203252e-06, -6.444306304870141e-09,  9.363991929390460e-12,
  2.219558501489928e-15, -7.230031517139341e-17,  2.879041938902887e-19, -6.851953049744297e-22,  6.936334086063980e-25,  2.568000797551421e-27, -1.755583641984789e-29,
  2.634963181084935e-01, -1.129455986289263e-03,  3.240422316755764e-06, -6.677283930973621e-09,  7.099765287537270e-12,  1.492627764716895e-14, -1.099385182149217e-16,
  3.399766925459600e-19, -5.537203673078626e-22, -4.730556265042428e-25,  6.843518189832317e-27, -2.615678318070129e-29,  3.070934962291779e-01, -1.297525372168812e-03,
  3.579908502639787e-06, -6.636212682271659e-09,  3.674831826914346e-12,  3.008126826272929e-14, -1.447747511416581e-16,  3.439486413788692e-19, -2.033733106709390e-22,
 -2.169608458576928e-24,  1.108459711905881e-26, -2.782543090991442e-29,  3.539367441500203e-01, -1.471614953123432e-03,  3.881038806664102e-06, -6.269773593160258e-09,
 -9.289485565171339e-13,  4.668402872393003e-14, -1.701751416307211e-16,  2.778449745791751e-19,  3.810943197778991e-22, -4.120089884819017e-24,  1.347188884683374e-26,
 -1.661628059911013e-29,  4.039875152433644e-01, -1.649919214351201e-03,  4.129532373661104e-06, -5.532467643183748e-09, -6.641614530083307e-12,  6.324889112251831e-14,
 -1.784917414353974e-16,  1.248213395977026e-19,  1.158343632806147e-21, -5.797985871325866e-24,  1.176676060411846e-26,  1.117935793025154e-29,  4.571981948306910e-01,
 -1.830402992558809e-03,  4.310384271392688e-06, -4.388105281436946e-09, -1.328465029391162e-11,  7.780474485984244e-14, -1.618721066214871e-16, -1.207454962687929e-19,
  2.010876279809724e-21, -6.455338327617780e-24,  3.990105986084792e-27,  5.333599350453512e-29,  5.135101924151185e-01, -2.010780096525694e-03,  4.408102224375762e-06,
 -2.814013610181560e-09, -2.055152742234884e-11,  8.795206055032050e-14, -1.134916721083962e-16, -4.463483652005513e-19,  2.735394661494239e-21, -5.252070625907957e-24,
 -1.049979866895671e-26,  9.811910157449987e-29,  5.728516560756066e-01, -2.188491560732438e-03,  4.407044885308381e-06, -8.060070387525826e-10, -2.799168143281951e-11,
  9.100071856196669e-14, -2.923407756671288e-17, -8.147445333940540e-19,  3.053068176197318e-21, -1.513564925919508e-24, -2.970047728450654e-26,  1.229924866372459e-28,
  6.351347358926110e-01, -2.360684629460441e-03,  4.291892003694748e-06,  1.615893118872497e-09, -3.500157469916715e-11,  8.421490439647195e-14,  9.023415814929533e-17,
 -1.159579906882313e-18,  2.651273982201582e-21,  4.884191683672178e-24, -4.788376110343962e-26,  9.863768028341671e-29,  7.002523107600923e-01, -2.524194163249873e-03,
  4.048282918953662e-06,  4.401112362712678e-09, -4.082804159847902e-11,  6.519043592171280e-14,  2.371857870333125e-16, -1.386107807228163e-18,  1.266939289506936e-21,
  1.306203831582682e-23, -5.554050178808374e-26,  1.163604364202503e-30,  7.680740798277417e-01, -2.675528998396604e-03,  3.663665413537577e-06,  7.461850510660556e-09,
 -4.459093044866738e-11,  3.238159563145983e-14,  3.947570327008998e-16, -1.380713022560474e-18, -1.185910796191585e-21,  2.077333495183603e-23, -4.141166379713621e-26,
 -1.671276635008284e-28,  8.384419072533749e-01, -2.810866953658825e-03,  3.128400539268742e-06,  1.066666170980501e-08, -4.533392561681562e-11, -1.422681460474776e-14,
  5.357761214670047e-16, -1.033191067685973e-18, -4.459233711593486e-21,  2.440350589023252e-23,  2.481196525526373e-27, -3.543222153155917e-28,  9.111642990345535e-01,
 -2.926063760370203e-03,  2.437167757727473e-06,  1.383527775544198e-08, -4.211381889719400e-11, -7.234857213616977e-14,  6.235521604499086e-16, -2.744461129219037e-19,
 -7.829960818257063e-21,  1.970363263163967e-23,  7.294352186986343e-26, -4.487771056400736e-28,  9.860098870607216e-01, -3.016683289673396e-03,  1.590703864497531e-06,
  1.673624150048408e-08, -3.413834793857715e-11, -1.366440963009270e-13,  6.159934540432470e-16,  8.719087001401252e-19, -1.006206744052414e-20,  3.584999952909557e-24,
  1.474361709655432e-25, -3.078835505114550e-28,  1.062699804149763e+00, -3.078059137696295e-03,  5.978811501356154e-07,  1.908966434122033e-08, -2.095919032272117e-11,
 -1.982118740114307e-13,  4.744726105466065e-16,  2.234168977636927e-18, -9.598465961313118e-21, -2.306286278730421e-23,  1.819358803699599e-25,  1.514901010644993e-28,
  1.140898864126217e+00, -3.105400902857735e-03, -5.219261606148196e-07,  2.057828592584189e-08, -2.716939552769042e-12, -2.446836173005870e-13,  1.782308217844541e-16,
  3.457162000715904e-18, -5.110450795523806e-21, -5.244171585763714e-23,  1.242619653970589e-25,  8.128575591400417e-28,  1.220205527243702e+00, -3.093962165176287e-03,
 -1.736338348489424e-06,  2.087080988737468e-08,  1.958489240901515e-11, -2.614148105744134e-13, -2.567773164798458e-16,  4.026715668564948e-18,  3.570175850092709e-21,
 -6.905698171631326e-23, -5.015135001423737e-26,  1.262048698494098e-27,  1.300140754109735e+00, -3.039290712380147e-03, -2.997643011907017e-06,  1.966179119023949e-08,
  4.383331684242867e-11, -2.343011672619533e-13, -7.594334813399462e-16,  3.402284290361585e-18,  1.439224629105775e-20, -5.441418278477841e-23, -2.884514897732139e-25,
  9.139271286978718e-28,  1.380136058824235e+00, -2.937583768655845e-03, -4.241198368703429e-06,  1.673135637091123e-08,  6.669111276670355e-11, -1.545310778542131e-13,
 -1.195745397885421e-15,  1.285961694412744e-18,  2.261842995461951e-20,  5.346376589719075e-25, -4.357586472431793e-25, -4.848982476335928e-28,  1.459521399072430e+00,
 -2.786169658854562e-03, -5.385440927107256e-06,  1.202447081581026e-08,  8.377165456265038e-11, -2.486534443149973e-14, -1.387483537951860e-15, -2.020977692151494e-18,
  2.207303580097134e-20,  7.879233108062214e-23, -3.014402013751626e-25, -2.181723295730417e-27,  1.537514023768322e+00, -2.584128829936004e-03, -6.334729635788138e-06,
  5.741708305708814e-09,  9.029146678288115e-11,  1.343796637730301e-13, -1.172131286165568e-15, -5.368098454434389e-18,  8.908110129818362e-21,  1.309340370395798e-22,
  1.530505609791751e-25, -2.418622511079227e-27,  1.613210061620135e+00, -2.333046175465307e-03, -6.986530521350164e-06, -1.579686820903636e-09,  8.233746234807005e-11,
  2.834119325726817e-13, -5.031569921437706e-16, -6.955183567614386e-18, -1.323562245714479e-20,  9.998333008426797e-23,  6.280621299528856e-25, -5.444257019915252e-29,
  1.685581460213102e+00, -2.037846945276976e-03, -7.244371729380672e-06, -9.033140284436124e-09,  5.866968533616051e-11,  3.702453184159353e-13,  4.488267375874610e-16,
 -5.271961683196893e-18, -3.119224997435115e-20, -1.949922247856693e-23,  6.084187071424031e-25,  3.084447853089578e-27,  1.753481770489674e+00, -1.707605612134019e-03,
 -7.037164029529486e-06, -1.541236021062689e-08,  2.254190048431483e-11,  3.506823473292716e-13,  1.282271863007494e-15, -5.401430719652780e-19, -2.939762649303035e-20,
 -1.384482841967654e-22, -5.202559317891453e-26,  2.952677631580707e-27,  1.815664961469527e+00, -1.356133807714678e-03, -6.343417120354193e-06, -1.943461207501718e-08,
 -1.754264647221181e-11,  2.170106903703104e-13,  1.533634128983554e-15,  4.529355504112455e-18, -5.608554067435318e-21, -1.329977519486199e-22, -6.761796308010041e-25,
 -1.011189066097346e-27,  1.870821491271155e+00, -1.002069258057200e-03, -5.215416264283517e-06, -2.012682959105029e-08, -4.950145289303993e-11,  1.873802278702396e-14,
  1.012725338467624e-15,  6.220480588787591e-18,  2.020108288746080e-20,  5.623781313454117e-25, -4.542897303381470e-25, -3.164453490208373e-27,  1.917634632541254e+00,
 -6.681469271369035e-04, -3.794332482449102e-06, -1.728830501593351e-08, -6.241378780926050e-11, -1.494054647775467e-13,  6.181656457767565e-17,  3.312332147065962e-18,
  2.298114283561801e-20,  1.003501169408373e-22,  2.486067806868643e-25, -3.909494567425159e-28,  1.954856989554434e+00, -3.794023804522292e-04, -2.304857945950054e-06,
 -1.182149755697189e-08, -5.284536196583746e-11, -2.028488928690407e-13, -6.171431689878002e-16, -9.975668462441362e-19,  4.242317614065553e-21,  5.418683486820278e-23,
  3.479228359800370e-25,  1.662250770930383e-27,  1.981402340233818e+00, -1.602919760625223e-04, -1.020796881117892e-06, -5.664066711159179e-09, -2.870818101450235e-11,
 -1.350526222537021e-13, -5.905605106695934e-16, -2.375077275922261e-18, -8.527078593548822e-21, -2.518803235045743e-23, -4.276281908632354e-26,  1.485097358708361e-28,
  1.996445502921617e+00, -3.107602838141090e-05, -2.032011656683789e-07, -1.176763968509205e-09, -6.359933342825379e-12, -3.281776845248048e-14, -1.635739060344547e-16,
 -7.926106441889041e-19, -3.747185215397290e-21, -1.731557522060005e-23, -7.824972842067539e-26, -3.456042250962021e-28,  4.153477282405321e-04, -1.905098457090399e-06,
  6.552428712428169e-09, -2.002989274762712e-11,  5.738244529780877e-14, -1.577921606286426e-16,  4.215982165379158e-19, -1.103474740470162e-21,  2.839692490743427e-24,
 -7.223155361205242e-27,  1.813611886735908e-29, -4.532962413677305e-32,  3.738071439233811e-03, -1.713096795361849e-05,  5.880390830801212e-08, -1.791214910613838e-10,
  5.103285037983010e-13, -1.392197647162719e-15,  3.679545998037579e-18, -9.494341195814430e-21,  2.399098490741042e-23, -5.965434081066983e-26,  1.456196528973482e-28,
 -3.519296539886520e-31,  1.038319982094582e-02, -4.750291180089248e-05,  1.624100408091123e-07, -4.911923593195140e-10,  1.383782107001919e-12, -3.713612630093014e-15,
  9.593936829249672e-18, -2.400960285449097e-20,  5.826836257178529e-23, -1.374982017231477e-25,  3.133767612827094e-28, -6.936682119490222e-31,  2.035005084510566e-02,
 -9.286022423104767e-05,  3.155719641196909e-07, -9.440566681680708e-10,  2.613674162912102e-12, -6.834819516260707e-15,  1.701420802950404e-17, -4.041935038713295e-20,
  9.116478116899095e-23, -1.938637089605662e-25,  3.776608583106150e-28, -6.513162371540355e-31,  3.363749023247319e-02, -1.529590411016759e-04,  5.155785354348110e-07,
 -1.519536833542097e-09,  4.105953337866963e-12, -1.034402039622307e-14,  2.434475341567671e-17, -5.312068155976329e-20,  1.046328609428636e-22, -1.752377810685472e-25,
  1.931674329780032e-28,  1.294610044364814e-31,  5.024379408805883e-02, -2.274689263317832e-04,  7.587914125291472e-07, -2.193596555134539e-09,  5.739139668366457e-12,
 -1.372791220138173e-14,  2.969853604627599e-17, -5.598297293125552e-20,  8.113033288264269e-23, -3.878483152448952e-26, -3.198993111342968e-28,  1.700967549215175e-30,
  7.016645912375465e-02, -3.159682424382385e-04,  1.040626055157694e-06, -2.936538184714178e-09,  7.367880423945910e-12, -1.640279858625401e-14,  3.109680632899583e-17,
 -4.339580470399824e-20,  8.320393551356122e-24,  2.293042643513462e-25, -1.113616799313356e-27,  3.635955295719306e-30,  9.340195446999598e-02, -4.179382389509852e-04,
  1.355529533084339e-06, -3.713282703428401e-09,  8.827636317322226e-12, -1.775391310148849e-14,  2.670923314779552e-17, -1.144403357531030e-20, -1.161816944500724e-22,
  5.982167456522221e-25, -1.974778112595971e-27,  4.997665776888742e-30,  1.199454071620311e-01, -5.327557772021279e-04,  1.696956410953991e-06, -4.483756599687724e-09,
  9.940654907981440e-12, -1.718300220439191e-14,  1.512561267850126e-17,  4.089335434597554e-20, -2.807820721760212e-22,  9.840248216216861e-25, -2.531738074389586e-27,
  4.527834750428384e-30,  1.497902111673338e-01, -6.596845962873180e-04,  2.057344489321137e-06, -5.203416906382541e-09,  1.052341191546492e-11, -1.416394819927688e-14,
 -4.354056289003577e-18,  1.106565265065323e-19, -4.575083435752490e-22,  1.252754363938291e-24, -2.321378500862598e-27,  1.079172139779062e-30,  1.829275472117807e-01,
 -7.978650140776924e-04,  2.428092859215677e-06, -5.823953731658050e-09,  1.039571595648087e-11, -8.305742053489406e-15, -3.143024202223888e-17,  1.901024002561928e-19,
 -6.022372965467085e-22,  1.238900497074740e-24, -9.225060324198526e-28, -5.753825266292616e-30,  2.193457975612629e-01, -9.463019508745379e-04,  2.799545629664427e-06,
 -6.294218887676624e-09,  9.391671285934916e-12,  5.786328255790343e-16, -6.454207846975067e-17,  2.663958384720716e-19, -6.585545069156700e-22,  7.816908790519550e-25,
  1.853850411047782e-27, -1.495019110398258e-29,  2.590298362018941e-01, -1.103851164475280e-03,  3.160985882770984e-06, -6.561439641405362e-09,  7.372666255248878e-12,
  1.239996922410358e-14, -1.006694338723090e-16,  3.220357871669971e-19, -5.660934666604394e-22, -2.215714655597971e-25,  5.749470422263862e-27, -2.357919973839232e-29,
  3.019601703942740e-01, -1.269203598288991e-03,  3.500645985329400e-06, -6.572787896128754e-09,  4.242487231471853e-12,  2.672143641148625e-14, -1.352464460516468e-16,
  3.362741936317940e-19, -2.737911456899175e-22, -1.750460692191159e-24,  9.879781302080172e-27, -2.686786526127861e-29,  3.481119041906787e-01, -1.440867774945372e-03,
  3.805742444407142e-06, -6.277386565695700e-09, -3.547330988726523e-14,  4.269442590462078e-14, -1.622463170580831e-16,  2.877693426061570e-19,  2.422869210696357e-22,
 -3.596670117082595e-24,  1.268033759505171e-26, -1.919504325652664e-29,  3.974534880108708e-01, -1.617150225695607e-03,  4.062546160689969e-06, -5.628845145097838e-09,
 -5.419170790176774e-12,  5.901102827350076e-14, -1.745085321512581e-16,  1.586403581274177e-19,  9.581856693858363e-22, -5.319773187593658e-24,  1.208962034182429e-26,
  3.728783860559415e-30,  4.499452105656779e-01, -1.796134043979410e-03,  4.256502346139168e-06, -4.588423029604836e-09, -1.176764188067778e-11,  7.388630162344170e-14,
 -1.643867990834122e-16, -6.008054967368151e-20,  1.781890178360859e-21, -6.252338064254685e-24,  6.074330753758103e-27,  4.158836150626125e-29,  5.055373800828048e-01,
 -1.975655808694186e-03,  4.372418672205212e-06, -3.128917785938325e-09, -1.882068616293886e-11,  8.508800115833575e-14, -1.247929237850578e-16, -3.619137572772752e-19,
  2.539768039544118e-21, -5.589311071378704e-24, -6.451629229433502e-27,  8.585117260414801e-29,  5.641681307275086e-01, -2.153281365689463e-03,  4.394745515698742e-06,
 -1.239359506415675e-09, -2.618047426772336e-11,  9.003632814751611e-14, -5.068891516976649e-17, -7.181369484518871e-19,  2.978487177087197e-21, -2.594765802235308e-24,
 -2.439945625466684e-26,  1.175273781907688e-28,  6.257607771837644e-01, -2.326281322272476e-03,  4.307978503192584e-06,  1.069449108964654e-09, -3.329820015151342e-11,
  8.600064181570934e-14,  5.897753944973483e-17, -1.072286805371727e-18,  2.793706511425875e-21,  3.059080082775850e-24, -4.329619257776422e-26,  1.090308530303682e-28,
  6.902206255734612e-01, -2.491607650698407e-03,  4.097220767028050e-06,  3.758590349240475e-09, -3.947042651910583e-11,  7.042216301940212e-14,  1.990099955748613e-16,
 -1.338470088335417e-18,  1.697286645468289e-21,  1.085133104892392e-23, -5.476076531628267e-26,  3.330149432166121e-29,  7.574311325275191e-01, -2.645873582498008e-03,
  3.748949893567506e-06,  6.754078229149475e-09, -4.385170757807230e-11,  4.138823582161809e-14,  3.556758470355399e-16, -1.407029930304088e-18, -4.695258842048271e-22,
  1.898442456913996e-23, -4.767591555182866e-26, -1.180090466225698e-28,  8.272492870825767e-01, -2.785340097546011e-03,  3.252041268796859e-06,  9.939731145979447e-09,
 -4.549229880645740e-11, -1.730652775843665e-15,  5.049810702039151e-16, -1.161840727995455e-18, -3.582565328661553e-21,  2.420345062379775e-23, -1.216270853117546e-26,
 -3.102600907883900e-28,  8.995000738482490e-01, -2.905913884636968e-03,  2.599103039658938e-06,  1.315069088003321e-08, -4.341190373997872e-11, -5.750317272106030e-14,
  6.124702735757554e-16, -5.131311475699090e-19, -7.072880427984278e-21,  2.222550349013348e-23,  5.315807122818239e-26, -4.477072820821140e-28,  9.739698637418746e-01,
 -3.003163807237804e-03,  1.788173919062445e-06,  1.616897578141709e-08, -3.672160133455762e-11, -1.216035172554214e-13,  6.359264474913653e-16,  5.530977185930186e-19,
 -9.830343548576546e-21,  9.187060625373968e-24,  1.321002915610064e-25, -3.856490745088382e-28,  1.050398576071514e+00, -3.072365782665888e-03,  8.248162808863020e-07,
  1.872324274402043e-08, -2.480466972899669e-11, -1.861092753100224e-13,  5.326144887065640e-16,  1.915148693109722e-18, -1.029654625447995e-20, -1.569787238857802e-23,
  1.851940019695252e-25, -2.121088080932652e-30,  1.128470472114395e+00, -3.108589663672926e-03, -2.754082049628994e-07,  2.049593048494784e-08, -7.560098434345834e-12,
 -2.392646589728845e-13,  2.724652936859483e-16,  3.264447921130641e-18, -6.900644962589608e-21, -4.679811464010333e-23,  1.568245971473176e-25,  6.628688379698700e-28,
  1.207803490345189e+00, -3.106846145333643e-03, -1.484181993334416e-06,  2.114204549566804e-08,  1.430415916262229e-11, -2.662138882059440e-13, -1.428057046349677e-16,
  4.100906298769428e-18,  1.061450472902362e-21, -6.994755370111068e-23,  5.635476381153212e-27,  1.263810910982508e-27,  1.287937139622704e+00, -3.062316530243259e-03,
 -2.757651275122664e-06,  2.032467907379915e-08,  3.897300684043913e-11, -2.513342485390894e-13, -6.580316809052399e-16,  3.829350345640400e-18,  1.223608858510162e-20,
 -6.506662173798543e-23, -2.422400691319009e-25,  1.178707186861807e-27,  1.368319161445823e+00, -2.970692355467837e-03, -4.034126749776072e-06,  1.777214366358251e-08,
  6.331685120296698e-11, -1.827151994212474e-13, -1.149626710986167e-15,  2.006660801900211e-18,  2.231988553241320e-20, -1.720140470532768e-23, -4.479796276441551e-25,
 -6.461380851798093e-29,  1.448291499345528e+00, -2.828653275421878e-03, -5.233127519378631e-06,  1.335901178415806e-08,  8.293719135254792e-11, -5.876164860728046e-14,
 -1.433773436321465e-15, -1.271768624386104e-18,  2.466976762773900e-20,  6.485836498727479e-23, -3.939460511229287e-25, -2.001559064538060e-27,  1.527076624072641e+00,
 -2.634506311669047e-03, -6.257077553930346e-06,  7.206293592620965e-09,  9.268575879606172e-11,  1.044814358807091e-13, -1.317731415762527e-15, -5.006655536554274e-18,
  1.370507391486345e-20,  1.347958961448097e-22,  3.694016832881062e-26, -2.843890746353942e-27,  1.603766004553502e+00, -2.388991422622435e-03, -6.997397623169884e-06,
 -2.176646609524942e-10,  8.786893636129165e-11,  2.689548619192367e-13, -7.032561016576451e-16, -7.316301781763115e-18, -9.186528890480569e-21,  1.248439052618171e-22,
  6.094680254532576e-25, -8.089037668195881e-28,  1.677313499241270e+00, -2.096218985373358e-03, -7.346891007281266e-06, -8.034653022969450e-09,  6.616976827190304e-11,
  3.791325156750558e-13,  2.871671717663155e-16, -6.276384038954687e-18, -3.142366136146349e-20,  7.526024374143136e-24,  7.418269474425971e-25,  2.944179339496882e-27,
  1.746537591449791e+00, -1.764636042396360e-03, -7.219711481727935e-06, -1.499391565851817e-08,  2.986149867663077e-11,  3.811644690054793e-13,  1.253227117047991e-15,
 -1.560746495642509e-18, -3.438572684682804e-20, -1.376904724942575e-22,  9.591002641703356e-26,  3.774763471524192e-27,  1.810137448249364e+00, -1.407818434595364e-03,
 -6.578166737377652e-06, -1.967853015312015e-08, -1.282421216781027e-11,  2.553148797273616e-13,  1.657185990716567e-15,  4.267977106672492e-18, -1.089263073342969e-20,
 -1.607761731243368e-22, -7.083960537215007e-25, -4.139473844422170e-28,  1.866728218979815e+00, -1.044772103026083e-03, -5.461673549038256e-06, -2.091447362772086e-08,
 -4.886915318776306e-11,  4.520644590327994e-14,  1.195925295215448e-15,  6.863450157087006e-18,  1.985923144994615e-20, -2.055335344715630e-23, -6.054230750577056e-25,
 -3.702799309033523e-27,  1.914899997336361e+00, -6.993486285973649e-04, -4.007882122909521e-06, -1.831071681456734e-08, -6.537910487658965e-11, -1.467224181279848e-13,
  1.654139611948653e-16,  4.107408036559108e-18,  2.676737620122151e-20,  1.098138616155927e-22,  2.209099155053630e-25, -8.955060687845950e-28,  1.953301583165905e+00,
 -3.984233634457179e-04, -2.451925583696469e-06, -1.270029312276977e-08, -5.705262937473609e-11, -2.179782690278111e-13, -6.428612198771997e-16, -8.277669242989695e-19,
  6.461955322525825e-21,  6.965264742076137e-23,  4.275457620382125e-25,  1.961148459934381e-27,  1.980744397809371e+00, -1.687382453365978e-04, -1.091613359427044e-06,
 -6.145799294174252e-09, -3.155651760874825e-11, -1.500557836963244e-13, -6.610213933784293e-16, -2.662767497477745e-18, -9.462762365881574e-21, -2.673432061909062e-23,
 -3.364297283981730e-26,  2.734889396776125e-28,  1.996317855645605e+00, -3.275990358640016e-05, -2.179552587755232e-07, -1.283994842344962e-09, -7.057416642957931e-12,
 -3.702400753879437e-14, -1.875439404840945e-16, -9.231294832870049e-19, -4.430751020432757e-21, -2.077195479716132e-23, -9.515073948022736e-26, -4.255058035626103e-28,
  4.078306727228006e-04, -1.853625090541457e-06,  6.317476323944602e-09, -1.913648092785757e-11,  5.432533504299940e-14, -1.480345379766974e-16,  3.919349903944932e-19,
 -1.016628916447713e-21,  2.592250201353068e-24, -6.536075372838824e-27,  1.625444843470857e-29, -4.030749623283537e-32,  3.670475009933854e-03, -1.666899779478211e-05,
  5.670253840033102e-08, -1.711742773465702e-10,  4.833465487956992e-13, -1.306993835337212e-15,  3.424137399364010e-18, -8.759895996668632e-21,  2.194464706814351e-23,
 -5.412788182732630e-26,  1.309762884879563e-28, -3.144387577826790e-31,  1.019574992780716e-02, -4.622683788346477e-05,  1.566461645044650e-07, -4.696337379731220e-10,
  1.311759015280578e-12, -3.491219163052680e-15,  8.947044943893414e-18, -2.222185344475682e-20,  5.353688531501887e-23, -1.255536283406505e-25,  2.843323833377841e-28,
 -6.276883870757374e-31,  1.998358834143378e-02, -9.038026256545776e-05,  3.044897566711584e-07, -9.033096450997815e-10,  2.480971188124886e-12, -6.439736119254408e-15,
  1.592227931535765e-17, -3.761088272090217e-20,  8.445080003545491e-23, -1.793191154856963e-25,  3.498476848412622e-28, -6.130374082495423e-31,  3.303378939604754e-02,
 -1.489062492860451e-04,  4.977315393659672e-07, -1.455465376817187e-09,  3.904797123894507e-12, -9.777222286371570e-15,  2.290331215589317e-17, -4.987186607805999e-20,
  9.846452729909359e-23, -1.674218278417911e-25,  1.970508587971902e-28,  4.986110979544685e-32,  4.934589450862661e-02, -2.215023472376518e-04,  7.330102748566980e-07,
 -2.103928587199141e-09,  5.471583613986115e-12, -1.303366562279325e-14,  2.816713250593809e-17, -5.341147054635399e-20,  7.952103523238803e-23, -5.016611347521138e-26,
 -2.511263954682795e-28,  1.431548663828782e-30,  6.891901579070642e-02, -3.077822084372182e-04,  1.006084217840365e-06, -2.821236407961434e-09,  7.047189450819026e-12,
 -1.567101881038726e-14,  2.988663280741850e-17, -4.300576513503631e-20,  1.581087298750306e-23,  1.878253249735743e-25, -9.635552737046844e-28,  3.193074775103677e-30,
  9.175161113175377e-02, -4.072698658992347e-04,  1.311805988651483e-06, -3.574846435863402e-09,  8.478940227466981e-12, -1.711713744970319e-14,  2.633988211694547e-17,
 -1.483209826741575e-20, -9.601597405805150e-23,  5.234879949464894e-25, -1.764971598291735e-27,  4.542943532004175e-30,  1.178411983732367e-01, -5.193926683613052e-04,
  1.644094358758684e-06, -4.327435306263206e-09,  9.600712646195795e-12, -1.680723059759447e-14,  1.615002467245106e-17,  3.245596856012930e-20, -2.471323922362884e-22,
  8.866978408853272e-25, -2.335739464186450e-27,  4.373136003501616e-30,  1.471839988468942e-01, -6.434727635771921e-04,  1.995904370198986e-06, -5.037313200922515e-09,
  1.023933057156453e-11, -1.423287827408519e-14, -1.453984558467092e-18,  9.672002805226886e-20, -4.140675989005677e-22,  1.161015340651536e-24, -2.261743911230562e-27,
  1.605309769934332e-30,  1.797744979957193e-01, -7.787170062305236e-04,  2.359197793468280e-06, -5.658990408997632e-09,  1.022247792887185e-11, -8.998330201184666e-15,
 -2.637052570160416e-17,  1.715368240207479e-19, -5.583579333935004e-22,  1.197390391806790e-24, -1.142246568648366e-27, -4.277010019077064e-30,  2.156049077340916e-01,
 -9.242051534641018e-04,  2.724916719554772e-06, -6.143941235136659e-09,  9.388345834412301e-12, -8.832229062899808e-16, -5.737370210664840e-17,  2.457854159447050e-19,
 -6.292309220090242e-22,  8.433958250208902e-25,  1.248414378327290e-27, -1.261357771027054e-29,  2.546645115036019e-01, -1.078876203140526e-03,  3.082964150074588e-06,
 -6.441621230313579e-09,  7.597224747955939e-12,  1.009005400880688e-14, -9.190693593226147e-17,  3.038355723982248e-19, -5.701736558562944e-22, -1.159688441821085e-26,
  4.767545792160478e-27, -2.106910313425039e-29,  2.969388684862440e-01, -1.241512730782248e-03,  3.422196882919832e-06, -6.500805849165826e-09,  4.745214128571219e-12,
  2.358746424923636e-14, -1.259623700611059e-16,  3.265785926984296e-19, -3.299758920038326e-22, -1.378545845531929e-24,  8.725617734988012e-27, -2.554384105423257e-29,
  3.424088479588518e-01, -1.410723096059372e-03,  3.730437900693823e-06, -6.271331845878389e-09,  7.801327857592850e-13,  3.889796472254771e-14, -1.540990079138765e-16,
  2.935470483981009e-19,  1.217280125852683e-22, -3.106894091775379e-24,  1.179651557192673e-26, -2.083809504654043e-29,  3.910494580898720e-01, -1.584921426765437e-03,
  3.994517992979292e-06, -5.706336101984309e-09, -4.280455308263092e-12,  5.487941784728825e-14, -1.696654588518472e-16,  1.863316481112238e-19,  7.754005378020294e-22,
 -4.834795386331517e-24,  1.211489414045392e-26, -2.365930052008766e-30,  4.428284253346846e-01, -1.762305359402193e-03,  4.200359645463062e-06, -4.765098310512477e-09,
 -1.032947251888600e-11,  6.992706847947040e-14, -1.653042512173486e-16, -6.611130714608841e-21,  1.561591251891962e-21, -5.975965325933673e-24,  7.667351318455933e-27,
  3.102338572962033e-29,  4.977044706910526e-01, -1.940831638336833e-03,  4.333120494836183e-06, -3.416600696921554e-09, -1.714965059356919e-11,  8.198036424167238e-14,
 -1.338192556295852e-16, -2.839032583484143e-19,  2.334784989872876e-21, -5.775454424132675e-24, -2.945015478318324e-27,  7.357185605534126e-29,  5.556252171282288e-01,
 -2.118189875516559e-03,  4.377419067742387e-06, -1.643914024605834e-09, -2.439348650703736e-11,  8.858917757982548e-14, -6.947771531632053e-17, -6.244983179644167e-19,
  2.868735048639420e-21, -3.469458727448511e-24, -1.939170360987170e-26,  1.097787933161788e-28,  6.165246482152628e-01, -2.291775086629451e-03,  4.317672247378143e-06,
  5.505048907070802e-10, -3.156641205437702e-11,  8.706600648046937e-14,  3.021931710038406e-17, -9.814509063402775e-19,  2.873834698026285e-21,  1.425134416556536e-24,
 -3.836100073474172e-26,  1.145460954518926e-28,  6.803200211423360e-01, -2.458660099516529e-03,  4.138581974978231e-06,  3.138577952710455e-09, -3.801722331410685e-11,
  7.475516027647460e-14,  1.623489499347346e-16, -1.278325940812295e-18,  2.048934778274077e-21,  8.698339904099176e-24, -5.269829056883562e-26,  5.945840225593755e-29,
  7.469081179533704e-01, -2.615569649402124e-03,  3.825817850344416e-06,  6.059523409422181e-09, -4.294177794565679e-11,  4.945061439116613e-14,  3.161687262813185e-16,
 -1.411497113233960e-18,  1.784615211144155e-22,  1.698734247164036e-23, -5.184337485505523e-26, -7.205896196277277e-29,  8.161606973050707e-01, -2.758859032614121e-03,
  3.366951741911967e-06,  9.212224672429014e-09, -4.540841500872595e-11,  9.986360969121484e-15,  4.709747096655665e-16, -1.262661387229651e-18, -2.723159811327250e-21,
  2.345807648230777e-23, -2.474863272611293e-26, -2.612364180927447e-28,  8.879189866319397e-01, -2.884501717437334e-03,  2.752708408006441e-06,  1.244769323825766e-08,
 -4.441626710053898e-11, -4.300112072550909e-14,  5.950569391204997e-16, -7.262893661126747e-19, -6.239201792854964e-21,  2.396181382854605e-23,  3.378273443199451e-26,
 -4.305488624597679e-28,  9.619870337998148e-01, -2.988092472749578e-03,  1.978598795400177e-06,  1.556280747562328e-08, -3.899997718921497e-11, -1.061906469879045e-13,
  6.470659831423197e-16,  2.448039859594896e-19, -9.408753537992290e-21,  1.411368078066446e-23,  1.138249957251477e-25, -4.413512853013432e-28,  1.038123723075628e+00,
 -3.064875561923265e-03,  1.046993411353203e-06,  1.829730262977779e-08, -2.839487865237429e-11, -1.727207410429332e-13,  5.815510217721195e-16,  1.578044163233765e-18,
 -1.072874544339911e-20, -8.334948392896577e-24,  1.819136168748197e-25, -1.446230477248578e-28,  1.116033261239670e+00, -3.109811542217682e-03, -3.033948858325093e-08,
  2.033707246842127e-08, -1.227273157848700e-11, -2.316551022039584e-13,  3.605340228439996e-16,  3.017936377520278e-18, -8.465880985861937e-21, -3.999112292625633e-23,
  1.822726132019162e-25,  4.910789402652733e-28,  1.195353970605436e+00, -3.117701298026192e-03, -1.229280445710253e-06,  2.132817068143877e-08,  8.954918862053815e-12,
 -2.682618048944838e-13, -2.788241767884524e-17,  4.094734521119581e-18, -1.439310199899206e-21, -6.862263178230793e-23,  6.019405189958123e-26,  1.206691653800262e-27,
  1.275645310212102e+00, -3.083391942609615e-03, -2.510182276246696e-06,  2.090721285325989e-08,  3.379729848111608e-11, -2.657983301174975e-13, -5.456929694589661e-16,
  4.181662199262669e-18,  9.732386281365028e-21, -7.365283216553420e-23, -1.855441520072151e-25,  1.388063702559316e-27,  1.356373220614237e+00, -3.002095371752696e-03,
 -3.814908000478152e-06,  1.875450028460289e-08,  5.939160214620668e-11, -2.095519895776944e-13, -1.083558644766734e-15,  2.707532916111654e-18,  2.137858477831403e-20,
 -3.504760933216996e-23, -4.410938360347777e-25,  3.793634166021874e-28,  1.436894203203183e+00, -2.869854605613351e-03, -5.064902275705646e-06,  1.467472486566871e-08,
  8.141543815872186e-11, -9.350827492034080e-14, -1.458002545986735e-15, -4.481864459891398e-19,  2.670053208531217e-20,  4.742102568665981e-23, -4.756657658508499e-25,
 -1.692070048301059e-27,  1.516439069049781e+00, -2.684191672066503e-03, -6.161640934285662e-06,  8.704217727043639e-09,  9.444805204407285e-11,  7.122769105865683e-14,
 -1.451047797655950e-15, -4.490416564465050e-18,  1.855322599105550e-20,  1.336693824858672e-22, -9.554501651532063e-26, -3.156197560220797e-27,  1.594098098231255e+00,
 -2.444956748655460e-03, -6.991399833186491e-06,  1.230283858766517e-09,  9.306250531376065e-11,  2.495895386278838e-13, -9.115193903882986e-16, -7.533739621385707e-18,
 -4.264118466402617e-21,  1.482670168778308e-22,  5.555194105180039e-25, -1.655047129474538e-27,  1.668810488581696e+00, -2.155361200190370e-03, -7.436703273519669e-06,
 -6.914962852327369e-09,  7.380651845021857e-11,  3.838024960783859e-13,  9.743362207147281e-17, -7.271631082090070e-18, -3.058819468526107e-20,  3.969799933647119e-23,
  8.640476718177345e-25,  2.569637623245281e-27,  1.739362404602850e+00, -1.823104729969875e-03, -7.396514949686891e-06, -1.445352831012577e-08,  3.778136087858544e-11,
  4.105886248520020e-13,  1.193383460550128e-15, -2.739319667666646e-18, -3.923129737509367e-20, -1.302907362172219e-22,  2.799849399646703e-25,  4.584774951730548e-27,
  1.804399423879974e+00, -1.461391423810548e-03, -6.815364606649570e-06, -1.984066634442141e-08, -7.310737133626369e-12,  2.964764518416603e-13,  1.770900199779369e-15,
  3.821314882965632e-18, -1.719293489283693e-20, -1.892448594956006e-22, -7.088264204805457e-25,  4.394119105993922e-28,  1.862460135628933e+00, -1.089482599386904e-03,
 -5.717303601814548e-06, -2.168752093924789e-08, -4.766206830028771e-11,  7.628572437377831e-14,  1.396852387308071e-15,  7.482105151623342e-18,  1.864275648713373e-20,
 -4.818002003030407e-23, -7.795391086407212e-25, -4.199995119688549e-27,  1.912037059695930e+00, -7.323086045195857e-04, -4.233983145702720e-06, -1.938000148842204e-08,
 -6.826402234209610e-11, -1.412718914146168e-13,  2.930191421613171e-16,  5.028834211417768e-18,  3.086854434270570e-20,  1.176737853339572e-22,  1.670614850578558e-25,
 -1.586040434936476e-27,  1.951667671328561e+00, -4.186642373109711e-04, -2.609952755145753e-06, -1.364885743592848e-08, -6.156822778700709e-11, -2.336592623481204e-13,
 -6.627422407864175e-16, -5.773894600200834e-19,  9.298922431511536e-21,  8.857307366837557e-23,  5.207976684695819e-25,  2.279710817671770e-27,  1.980051499507902e+00,
 -1.777749677642818e-04, -1.168494276390062e-06, -6.675600449833679e-09, -3.472249821937542e-11, -1.668501023077763e-13, -7.399645887590374e-16, -2.981208256625959e-18,
 -1.044609130101541e-20, -2.779137295928040e-23, -1.791447602182396e-26,  4.516158390234177e-28,  1.996183228377211e+00, -3.456715493656057e-05, -2.340659616381481e-07,
 -1.403090992690582e-09, -7.845086829732750e-12, -4.185197336975634e-14, -2.154944174650542e-16, -1.077650976069727e-18, -5.251811657171640e-21, -2.498014851298217e-23,
 -1.159834170560197e-25, -5.250553419382684e-28,  4.005158181776598e-04, -1.803989276282705e-06,  6.092957711668200e-09, -1.829045952242522e-11,  5.145645050420976e-14,
 -1.389605249604731e-16,  3.645962105363268e-19, -9.373195930218115e-22,  2.368239555938363e-24, -5.920026911524528e-27,  1.458012998282214e-29, -3.589140272192901e-32,
  3.604693433145956e-03, -1.622346434066047e-05,  5.469399996400629e-08, -1.636454684936120e-10,  4.580090002113026e-13, -1.227680275981720e-15,  3.188405628435937e-18,
 -8.087860267745678e-21,  2.008710402241333e-23, -4.915548231365705e-26,  1.178850650861775e-28, -2.812897521310326e-31,  1.001331371955456e-02, -4.499585942028970e-05,
  1.511342215321590e-07, -4.491927299699894e-10,  1.244032506698670e-12, -3.283767137034828e-15,  8.348153417917512e-18, -2.057884989874017e-20,  4.921518194434329e-23,
 -1.147147854234071e-25,  2.580414586714983e-28, -5.684071792531429e-31,  1.962687141570114e-02, -8.798703820615106e-05,  2.938840302286167e-07, -8.646240538536613e-10,
  2.355914064545548e-12, -6.069939167791537e-15,  1.490605703583177e-17, -3.500909620283633e-20,  7.824080244207561e-23, -1.658536186995136e-25,  3.236986897065714e-28,
 -5.757636220014476e-31,  3.244601896825471e-02, -1.449932118740593e-04,  4.806344578629352e-07, -1.394523580926886e-09,  3.714638180363068e-12, -9.243949208550002e-15,
  2.155011679155809e-17, -4.681591186492969e-20,  9.257956375379987e-23, -1.595158203227885e-25,  1.977824691392079e-28, -1.430980804784359e-32,  4.847145546076728e-02,
 -2.157377849152841e-04,  7.082799192189742e-07, -2.018432409260129e-09,  5.217550754881498e-12, -1.237531488375854e-14,  2.670695212582044e-17, -5.089751289038580e-20,
  7.754877318440099e-23, -5.902242379467655e-26, -1.933847450689312e-28,  1.198658785519163e-30,  6.770377256550850e-02, -2.998670607753239e-04,  9.728956933848077e-07,
 -2.710950175897647e-09,  6.740844650448966e-12, -1.496812639943493e-14,  2.869051968732582e-17, -4.239880088854278e-20,  2.191158687067430e-23,  1.519731333361190e-25,
 -8.319408158402150e-28,  2.796684397471081e-30,  9.014325209753665e-02, -3.969447301428255e-04,  1.269710623231532e-06, -3.441887934239294e-09,  8.142883688785686e-12,
 -1.649029412197993e-14,  2.588430640863679e-17, -1.761632266802176e-20, -7.839418455483582e-23,  4.567585507347049e-25, -1.574631241284462e-27,  4.113125938886510e-30,
  1.157896079776145e-01, -5.064450444007941e-04,  1.593075779749423e-06, -4.176491707912662e-09,  9.268513154736527e-12, -1.640958957105603e-14,  1.695274889400327e-17,
  2.504081117073929e-20, -2.168471279635228e-22,  7.970613696021033e-25, -2.147516503540151e-27,  4.176661015392412e-30,  1.446416633300755e-01, -6.277445561931584e-04,
  1.936430190133596e-06, -4.875762173971623e-09,  9.954535834339333e-12, -1.423673524318496e-14,  1.074833708542531e-18,  8.412129469798681e-20, -3.738813534115757e-22,
  1.072080009000856e-24, -2.182251885729809e-27,  1.986125435759801e-30,  1.766969509593488e-01, -7.601122888013239e-04,  2.292265220530126e-06, -5.496903284920432e-09,
  1.003656117744613e-11, -9.575565961400566e-15, -2.181122359390904e-17,  1.543499038264176e-19, -5.161161635233932e-22,  1.148316385780839e-24, -1.302476556120818e-27,
 -3.043997921276029e-30,  2.119512224509707e-01, -9.026981770740002e-04,  2.652089886955218e-06, -5.993941533454242e-09,  9.357457490257544e-12, -2.179854782989532e-15,
 -5.076897884252080e-17,  2.261444126467161e-19, -5.980978050370820e-22,  8.828617545550141e-25,  7.399910591230835e-28, -1.053893491212561e-29,  2.503978474908188e-01,
 -1.054519606741397e-03,  3.006400307921469e-06, -6.318568216920270e-09,  7.777646610194287e-12,  7.984315436837134e-15, -8.365478835060075e-17,  2.856183707338781e-19,
 -5.673754016514561e-22,  1.612790522814671e-25,  3.893710465477691e-27, -1.867244227806894e-29,  2.920270805201031e-01, -1.214445868900268e-03,  3.344657797389589e-06,
 -6.421269596762121e-09,  5.187466772407073e-12,  2.067286108053593e-14, -1.169729917001408e-16,  3.152905116729889e-19, -3.735879055742928e-22, -1.051550902313126e-24,
  7.635609480095234e-27, -2.396916350135742e-29,  3.368251663357000e-01, -1.381180346753024e-03,  3.655281840685207e-06, -6.252824190861840e-09,  1.521775931026753e-12,
  3.529856037280513e-14, -1.458413321235334e-16,  2.957420301249095e-19,  1.814946333649340e-23, -2.653677764492331e-24,  1.085798664704551e-26, -2.170739213850099e-29,
  3.847732494536379e-01, -1.553240269250028e-03,  3.925666544758632e-06, -5.766262101524393e-09, -3.223150240882355e-12,  5.087270062936627e-14, -1.641262940082825e-16,
  2.084528541519207e-19,  6.100315844037425e-22, -4.353797439437052e-24,  1.189961542976366e-26, -7.226812870350396e-30,  4.358460436757840e-01, -1.728933911685141e-03,
  4.142232290062215e-06, -4.919397060473091e-09, -8.970590816248331e-12,  6.596299521897164e-14, -1.648216752902948e-16,  3.997932382857500e-20,  1.352279989089830e-21,
 -5.644805848581192e-24,  8.822713367133211e-27,  2.169950377466960e-29,  4.900102079813487e-01, -1.906335212452930e-03,  4.290528454779376e-06, -3.678055301783690e-09,
 -1.554276100792162e-11,  7.868156041956411e-14, -1.407539464139888e-16, -2.125334169034550e-19,  2.125496033194603e-21, -5.832057205265824e-24,  2.801809971315512e-29,
  6.165062600420824e-29,  5.472223622034379e-01, -2.083255931837960e-03,  4.355408484327263e-06, -2.020131899370694e-09, -2.263974086686349e-11,  8.672213379404733e-14,
 -8.569826499541615e-17, -5.348376177934301e-19,  2.731012568286081e-21, -4.151180783311017e-24, -1.476263807126310e-26,  1.004190645943547e-28,  6.074266605163197e-01,
 -2.257215737929029e-03,  4.321305496641763e-06,  5.940310891608068e-11, -2.982001134970145e-11,  8.747193143533129e-14,  4.031828435233019e-18, -8.889535616722169e-19,
  2.898740858301068e-21, -7.836695643877222e-27, -3.327804363064279e-26,  1.158633431155897e-28,  6.705518221406491e-01, -2.425411017716316e-03,  4.172645248217215e-06,
  2.542462875555984e-09, -3.648601613805365e-11,  7.822970143735818e-14,  1.275179528404045e-16, -1.208151107706432e-18,  2.324821581518366e-21,  6.649110984531692e-24,
 -4.961577781262074e-26,  7.969807304806646e-29,  7.365074965778958e-01, -2.584683851862443e-03,  3.894443656804491e-06,  5.380765925865804e-09, -4.188008075859117e-11,
  5.656559672702508e-14,  2.768158077321731e-16, -1.396407308306045e-18,  7.520296555309480e-22,  1.486277436255713e-23, -5.408244532408840e-26, -3.052754259329225e-29,
  8.051798151196938e-01, -2.731493563874428e-03,  3.473147777286540e-06,  8.487889813293346e-09, -4.509856518083499e-11,  2.085642576759110e-14,  4.345256823590722e-16,
 -1.336503294466257e-18, -1.899121613908109e-21,  2.225326675015827e-23, -3.511779306679103e-26, -2.099157115847620e-28,  8.764259519856905e-01, -2.861894702478819e-03,
  2.897790878157813e-06,  1.173092142970135e-08, -4.513523625876479e-11, -2.898554288623916e-14,  5.720570028645965e-16, -9.119176024117647e-19, -5.356746175224290e-21,
  2.494235457534590e-23,  1.546697490071135e-26, -4.000243351329689e-28,  9.500674890810303e-01, -2.971527431540076e-03,  2.161541139585278e-06,  1.492266283587120e-08,
 -4.096811280478680e-11, -9.061233136590610e-14,  6.497877977724452e-16, -4.730661800733084e-20, -8.823494103356389e-21,  1.826685508450043e-23,  9.359037735643619e-26,
 -4.747780571284325e-28,  1.025882352074044e+00, -3.055629325050090e-03,  1.263723634703455e-06,  1.781612191725602e-08, -3.170634371742720e-11, -1.582723162204425e-13,
  6.208946006387193e-16,  1.231312984482662e-18, -1.089971083023406e-20, -1.224005764641082e-24,  1.727192955924950e-25, -2.700742552848998e-28,  1.103595070083543e+00,
 -3.109081765751819e-03,  2.123759064750959e-07,  2.010414224664220e-08, -1.681262444632951e-11, -2.220201506268350e-13,  4.410373561827756e-16,  2.725439516451724e-18,
 -9.769603967484133e-21, -3.232158771800658e-23,  1.998660904852619e-25,  3.075256253073681e-28,  1.182865120768201e+00, -3.126509761462345e-03, -9.726597896653975e-07,
  2.142852999496279e-08,  3.592241326194146e-12, -2.675626201732272e-13,  8.575785875246897e-17,  4.009716842833516e-18, -3.853847390508479e-21, -6.518204280976589e-23,
  1.110237398105039e-25,  1.095379629588686e-27,  1.263273180913343e+00, -3.102461070173914e-03, -2.256228803030248e-06,  2.140477072322595e-08,  2.836002088143958e-11,
 -2.774572287638193e-13, -4.246544339838102e-16,  4.449364494361058e-18,  6.962447380136632e-21, -7.980625253415880e-23, -1.210974368079351e-25,  1.529274399320974e-27,
  1.344305248316273e+00, -3.031698592792447e-03, -3.584295210780296e-06,  1.966985179053737e-08,  5.494704310001426e-11, -2.345716476452896e-13, -9.983838448812746e-16,
  3.368095464627817e-18,  1.980449982180260e-20, -5.222659341500824e-23, -4.146412485834028e-25,  8.202154300853646e-28,  1.425334892683968e+00, -2.909647446525103e-03,
 -4.881057576753861e-06,  1.596050680608054e-08,  7.919484074633546e-11, -1.285529348998642e-13, -1.458360275818437e-15,  4.297342448563496e-19,  2.804832925901612e-20,
  2.702367663950262e-23, -5.410687823066645e-25, -1.262231593565948e-27,  1.505604414022167e+00, -2.733041211454057e-03, -6.048082541290190e-06,  1.022484933885349e-08,
  9.551453560204156e-11,  3.496526562385761e-14, -1.567751048522563e-15, -3.820732799545795e-18,  2.326250022129055e-20,  1.270106334139045e-22, -2.385665980678833e-25,
 -3.316900926402180e-27,  1.584206538566892e+00, -2.500803209397557e-03, -6.967541744028187e-06,  2.757957714711636e-09,  9.781838669830602e-11,  2.251713991610722e-13,
 -1.123542329490779e-15, -7.580659020794583e-18,  1.453545397928820e-21,  1.687703975353323e-22,  4.631506410035651e-25, -2.546388786247032e-27,  1.660069560102836e+00,
 -2.215166085368871e-03, -7.512343874667657e-06, -5.672594300886663e-09,  8.148889523889061e-11,  3.835885923508759e-13, -1.196119229668581e-16, -8.220705365372059e-18,
 -2.851120274903791e-20,  7.635269582421922e-23,  9.640222822429950e-25,  1.928898719545544e-27,  1.731950558319052e+00, -1.882959708331070e-03, -7.566054326938485e-06,
 -1.378180486928011e-08,  4.627258139699268e-11,  4.381633094325368e-13,  1.098419517285667e-15, -4.067199120338630e-18, -4.366951939218110e-20, -1.148344826260560e-22,
  4.981121551570901e-25,  5.308856232794085e-27,  1.798443302266313e+00, -1.516868215345722e-03, -7.053951182279103e-06, -1.990785747451959e-08, -9.478740298268814e-13,
  3.401933593737909e-13,  1.869131683463762e-15,  3.156719974367468e-18, -2.450862653377131e-20, -2.168975203068808e-22, -6.655165936317638e-25,  1.577824462671807e-27,
  1.858009061988152e+00, -1.136274865142165e-03, -5.982072965264848e-06, -2.243601440088439e-08, -4.578379904328625e-11,  1.123897542948284e-13,  1.614397498775663e-15,
  8.044534475718188e-18,  1.630131306183067e-20, -8.318285372626915e-23, -9.734532953690226e-25, -4.589980232756055e-27,  1.909038582174340e+00, -7.671294895755310e-04,
 -4.473188375689546e-06, -2.049439731832165e-08, -7.100713654230182e-11, -1.324341662895606e-13,  4.483007909048894e-16,  6.085546200098771e-18,  3.520600376204636e-20,
  1.227086448383380e-22,  7.801516769347352e-26, -2.501941206213459e-27,  1.949950193704514e+00, -4.402161118685480e-04, -2.779806622258323e-06, -1.467220363099266e-08,
 -6.640159387070664e-11, -2.497223590796407e-13, -6.742340418349025e-16, -2.245833918080614e-19,  1.288756842494145e-20,  1.115062748815617e-22,  6.282052986020735e-25,
  2.600940751267769e-27,  1.979321182706909e+00, -1.874530553413507e-04, -1.252048167504123e-06, -7.258850424099758e-09, -3.824405230133104e-11, -1.856496398409019e-13,
 -8.282694174283053e-16, -3.331586500559427e-18, -1.145408423964809e-20, -2.804285408880220e-23,  7.160708272999521e-27,  7.019386225951825e-28,  1.996041104968415e+00,
 -3.650923035396055e-05, -2.516847433151413e-07, -1.535600314289941e-09, -8.736390861986746e-12, -4.740578477596149e-14, -2.481633043788095e-16, -1.261040127882133e-18,
 -6.240484200683222e-21, -3.011611514552332e-23, -1.417191207371207e-25, -6.493034257672476e-28,  3.933959778056298e-04, -1.756109768666722e-06,  5.878321818739324e-09,
 -1.748892333659036e-11,  4.876266069111894e-14, -1.305167847113273e-16,  3.393809790178864e-19, -8.648363217789714e-22,  2.165246493430211e-24, -5.367226654553010e-27,
  1.308816290726100e-29, -3.200755977886012e-32,  3.540662416175885e-03, -1.579364458442693e-05,  5.277342619766577e-08, -1.565096713637173e-10,  4.342026373412102e-13,
 -1.153805030141287e-15,  2.970684884895492e-18, -7.472500095889389e-21,  1.839948251799401e-23, -4.467872606329218e-26,  1.061661230660330e-28, -2.519865727757845e-31,
  9.835714761986174e-03, -4.380801344378946e-05,  1.458612033417570e-07, -4.298029193697662e-10,  1.180314951742877e-12, -3.090151732317282e-15,  7.793387109890151e-18,
 -1.906809566180406e-20,  4.526535926603760e-23, -1.048772496282491e-25,  2.342225638859911e-28, -5.152320045400238e-31,  1.927956058859603e-02, -8.567683621193921e-05,
  2.837307652373474e-07, -8.278815098557528e-10,  2.238014773322475e-12, -5.723679365340566e-15,  1.395997415438118e-17, -3.259847216785264e-20,  7.249712702777924e-23,
 -1.534016915607552e-25,  2.991582063825352e-28, -5.399982847627682e-31,  3.187363169641562e-02, -1.412140768318739e-04,  4.642507689749191e-07, -1.336540740294192e-09,
  3.534826753542864e-12, -8.742147035830022e-15,  2.027989447828426e-17, -4.394372226285542e-20,  8.697909857121496e-23, -1.516331253527562e-25,  1.959767350780663e-28,
 -6.591145768467327e-32,  4.761968537797201e-02, -2.101670297299740e-04,  6.845515589708065e-07, -1.936897301222812e-09,  4.976340130871031e-12, -1.175117119491847e-14,
  2.531623412119872e-17, -4.845134255102262e-20,  7.529687644894092e-23, -6.576440940197521e-26, -1.451813315098729e-28,  9.971949669474222e-31,  6.651966718007996e-02,
 -2.922122098374276e-04,  9.410016534865014e-07, -2.605454551425272e-09,  6.448272116823049e-12, -1.429371586028780e-14,  2.751394770412515e-17, -4.161628194756213e-20,
  2.681229677217182e-23,  1.210493528052436e-25, -7.168297762050077e-28,  2.442163864636293e-30,  8.857553005755003e-02, -3.869500657602613e-04,  1.229178910125877e-06,
 -3.314206661759706e-09,  7.819248683953066e-12, -1.587525855832415e-14,  2.535831610336981e-17, -1.987365307385168e-20, -6.304209852379406e-23,  3.972720961439002e-25,
 -1.402632598539817e-27,  3.709311490030928e-30,  1.137890031255240e-01, -4.938984135270255e-04,  1.543836898414752e-06, -4.030798700768574e-09,  8.944442873550357e-12,
 -1.599506807471369e-14,  1.756094165342916e-17,  1.854458721896446e-20, -1.896554273651091e-22,  7.147714323912610e-25, -1.968627690355834e-27,  3.950632251768065e-30,
  1.421613012244473e-01, -6.124844652495463e-04,  1.878867289911465e-06, -4.718765299715621e-09,  9.670243038718174e-12, -1.418399137045478e-14,  3.268414115510331e-18,
  7.275793864037869e-20, -3.368358494392942e-22,  9.866222412383551e-25, -2.088746099579363e-27,  2.246005441136057e-30,  1.736927641176484e-01, -7.420353031826032e-04,
  2.227259482915155e-06, -5.337877402150450e-09,  9.840155745721235e-12, -1.004900220404552e-14, -1.771450475119837e-17,  1.384853188270056e-19, -4.757439481052814e-22,
  1.093852776946838e-24, -1.413297453419496e-27, -2.026685610220646e-30,  2.083824112296757e-01, -8.817666256764891e-04,  2.581059257110135e-06, -5.844635078760923e-09,
  9.302177683246183e-12, -3.324458924303302e-15, -4.470006941625721e-17,  2.075186505044159e-19, -5.658886613968000e-22,  9.037417686068529e-25,  3.172940964405932e-28,
 -8.714753280242202e-30,  2.462273942593358e-01, -1.030769568591773e-03,  2.931329067024187e-06, -6.192954784276615e-09,  7.917892975633659e-12,  6.070523059977914e-15,
 -7.591058010612112e-17,  2.675837475862862e-19, -5.589577307423625e-22,  3.012696240597451e-25,  3.122212733773265e-27, -1.642181002756582e-29,  2.872223255849563e-01,
 -1.187995386024278e-03,  3.268113717174884e-06, -6.335112026578035e-09,  5.573558432359085e-12,  1.797006307595809e-14, -1.083175072864354e-16,  3.027869191841738e-19,
 -4.061957263399096e-22, -7.667188120308907e-25,  6.618595896844632e-27, -2.224032387744989e-29,  3.313584548970613e-01, -1.352237761233428e-03,  3.580416729593579e-06,
 -6.223015367859405e-09,  2.193415937057148e-12,  3.189771803097097e-14, -1.375661992596888e-16,  2.948762424515959e-19, -6.979646939730517e-23, -2.238573284635636e-24,
  9.895474466881402e-27, -2.195156536363609e-29,  3.786226596679541e-01, -1.522112518223663e-03,  3.856194865343993e-06, -5.809904871630416e-09, -2.244602970170236e-12,
  4.700577404929631e-14, -1.580392316984567e-16,  2.255572483620140e-19,  4.617750669718659e-22, -3.885354600588508e-24,  1.149514714968152e-26, -1.098821912739833e-29,
  4.289962065572346e-01, -1.696034525554626e-03,  4.082381189234787e-06, -5.052586895565948e-09, -7.690772957212425e-12,  6.202541261903787e-14, -1.631264867950245e-16,
  8.007070478872179e-20,  1.155626807064031e-21, -5.275269246069532e-24,  9.595276630798891e-27,  1.362012243160591e-29,  4.824532302423544e-01, -1.872191640706162e-03,
  4.244951016185450e-06, -3.914335858914653e-09, -1.400335387397876e-11,  7.523954640900854e-14, -1.457841916836568e-16, -1.478714896226656e-19,  1.916185062810236e-21,
 -5.780059444763578e-24,  2.489650351848290e-27,  5.036497665945348e-29,  5.389588629609970e-01, -2.048515657236983e-03,  4.329050347541994e-06, -2.368608878163117e-09,
 -2.092702834925933e-11,  8.449540338725367e-14, -9.947345420737923e-17, -4.499417991688951e-19,  2.571978604853610e-21, -4.656316469272628e-24, -1.056978630489983e-26,
  9.004175894556000e-29,  5.984669316915882e-01, -2.222650420699510e-03,  4.319213338694696e-06, -4.037245804941925e-10, -2.807156709094184e-11,  8.728047956888803e-14,
 -1.956205175990714e-17, -7.964453229776177e-19,  2.875723845157336e-21, -1.237408704992203e-24, -2.821644987624005e-26,  1.136924414261307e-28,  6.609171197683680e-01,
 -2.391917621775941e-03,  4.199704284356987e-06,  1.971358305332109e-09, -3.489351355182029e-11,  8.089280774508689e-14,  9.476453718623174e-17, -1.130302815096339e-18,
  2.529354801407644e-21,  4.739310246722832e-24, -4.576786521182699e-26,  9.431338528644355e-29,  7.262314652414457e-01, -2.553281328966421e-03,  3.955030826533815e-06,
  4.720082858328975e-09, -4.068548398460715e-11,  6.274318201177076e-14,  2.381307611110521e-16, -1.364200874473041e-18,  1.247928021039629e-21,  1.268368890491448e-23,
 -5.460766083729712e-26,  5.734905578401417e-30,  7.943100390367654e-01, -2.703313194435395e-03,  3.570688558424137e-06,  7.770203582333273e-09, -4.458021407748412e-11,
  3.082983992283705e-14,  3.963711852563665e-16, -1.384745571350183e-18, -1.125376597860717e-21,  2.067899232176414e-23, -4.322241289465948e-26, -1.586638931682926e-28,
  8.650256119958875e-01, -2.838161607265231e-03,  3.034212214007414e-06,  1.100485690574768e-08, -4.557981823819728e-11, -1.558111601480461e-14,  5.442591309008760e-16,
 -1.068881037994618e-18, -4.451824573682853e-21,  2.522039779494503e-23, -1.266727567680017e-27, -3.591466529168989e-28,  9.382170822290656e-01, -2.953530090164236e-03,
  2.336623092756538e-06,  1.425352136491135e-08, -4.262467987623208e-11, -7.506459255546650e-14,  6.446140602086682e-16, -3.184553962989014e-19, -8.103585551045347e-21,
  2.158760459554002e-23,  7.235896986691605e-26, -4.869097269349830e-28,  1.013681395891545e+00, -3.044673221504310e-03,  1.474371481965470e-06,  1.728431750669098e-08,
 -3.472018641474904e-11, -1.429965316521553e-13,  6.504910315863174e-16,  8.831253964272665e-19, -1.082257782135040e-20,  5.414824802924312e-24,  1.584647292027406e-25,
 -3.740346758693028e-28,  1.091163662053734e+00, -3.106422666314002e-03,  4.518670004655207e-07,  1.980021744150333e-08, -2.114118413046364e-11, -2.105558526747114e-13,
  5.128090934447555e-16,  2.395761110036489e-18, -1.078651510666829e-20, -2.411105337948496e-23,  2.093104019885083e-25,  1.222911562834665e-28,  1.170345148578367e+00,
 -3.133261899030510e-03, -7.153487000093952e-07,  2.144334555954194e-08, -1.729416255919693e-12, -2.641732375001711e-13,  1.959572858998795e-16,  3.849797711843567e-18,
 -6.109237521061124e-21, -5.982049899137018e-23,  1.559049551281941e-25,  9.378608984097758e-28,  1.250828874064324e+00, -3.119476182798407e-03, -1.996833791105797e-06,
  2.181362692794423e-08,  2.271916913862679e-11, -2.861314573093872e-13, -2.973908580693878e-16,  4.625392747037057e-18,  4.018684657057927e-21, -8.327956370489779e-23,
 -5.209455834596853e-26,  1.594249153895328e-27,  1.332122620749595e+00, -3.059414220839891e-03, -3.343141016955406e-06,  2.051020445329364e-08,  5.002399918848342e-11,
 -2.573314165984743e-13, -8.955097825009181e-16,  3.968633969178551e-18,  1.763563106225235e-20, -6.796661932567258e-23, -3.693711672582460e-25,  1.230163726700036e-27,
  1.413619449112826e+00, -2.947908469543691e-03, -4.682019779827119e-06,  1.720516001244604e-08,  7.627527764906313e-11, -1.633070210062011e-13, -1.433646179687545e-15,
  1.338569570311061e-18,  2.861957927895207e-20,  4.419945916187636e-24, -5.852478547199663e-25, -7.313573482242236e-28,  1.494576293674949e+00, -2.780909059371463e-03,
 -5.916198594536406e-06,  1.175659719701160e-08,  9.582936763617469e-11, -3.856256608983695e-15, -1.663637373250802e-15, -3.005302586950392e-18,  2.762784915226030e-20,
  1.145415452826791e-22, -3.847268985407452e-25, -3.294480426136120e-27,  1.574092092667261e+00, -2.556384222394073e-03, -6.924912015849076e-06,  4.357542226346926e-09,
  1.020350230218329e-10,  1.956702739378439e-13, -1.334212063012880e-15, -7.433593137715165e-18,  7.833362425035846e-21,  1.847943281030864e-22,  3.316566543266388e-25,
 -3.422489283096666e-27,  1.651088299200887e+00, -2.275514374267797e-03, -7.572339627330928e-06, -4.307633857006336e-09,  8.911279460641575e-11,  3.778554624055620e-13,
 -3.620975212914513e-16, -9.081491063533265e-18, -2.505020387732515e-20,  1.163600977381142e-22,  1.029630832353122e-24,  1.006780744394744e-27,  1.724296633857551e+00,
 -1.944136408328059e-03, -7.726700102786313e-06, -1.296994670654705e-08,  5.528941209437734e-11,  4.629972191062994e-13,  9.643826293594738e-16, -5.526455180697811e-18,
 -4.738698474620725e-20, -9.006106199435273e-23,  7.445501592384828e-25,  5.855164467172457e-27,  1.792261453526730e+00, -1.574255126712881e-03, -7.292703966981664e-06,
 -1.986612681041308e-08,  6.311254912093153e-12,  3.860171597219499e-13,  1.945330400499438e-15,  2.242532540452298e-18, -3.277576594869864e-20, -2.417288198006383e-22,
 -5.655981936725836e-25,  3.012385025860306e-27,  1.853366526884992e+00, -1.185220645854872e-03, -6.255619174606206e-06, -2.314839004423685e-08, -4.313001166660810e-11,
  1.538941578495915e-13,  1.846441375914295e-15,  8.510348285772194e-18,  1.255646153954137e-20, -1.262349108765300e-22, -1.180571634288979e-24, -4.783411759291218e-27,
  1.905896908100839e+00, -8.039182387982831e-04, -4.726023177619482e-06, -2.165105610817115e-08, -7.353375034840956e-11, -1.194988012443328e-13,  6.351354264268746e-16,
  7.283186272140482e-18,  3.965021501957373e-20,  1.233007255851356e-22, -5.699722042895133e-26, -3.681314766892808e-27,  1.948143711257748e+00, -4.631772771515707e-04,
 -2.962415287279788e-06, -1.577546516193892e-08, -7.155810934519126e-11, -2.659289464779968e-13, -6.741093744596632e-16,  2.571254454330373e-19,  1.738250719978877e-20,
  1.390133453921763e-22,  7.493022529713871e-25,  2.895970922039982e-27,  1.978550770975439e+00, -1.978285572490494e-04, -1.342951917467600e-06, -7.901571740390653e-09,
 -4.216360379655064e-11, -2.066898661370312e-13, -9.268362662768100e-16, -3.714148693974665e-18, -1.245018335480233e-20, -2.704445183998474e-23,  4.528798680340223e-26,
  1.049633849650116e-27,  1.995890920932984e+00, -3.859886763441092e-05, -2.709830104774020e-07, -1.683303522902518e-09, -9.747046809854975e-12, -5.380902148313337e-14,
 -2.864392896017810e-16, -1.479234997874982e-18, -7.433976483958320e-21, -3.639947964047831e-23, -1.735794177244020e-25, -8.046222426423776e-28,  3.864642811887679e-04,
 -1.709909594543844e-06,  5.673051224431986e-09, -1.672916899292064e-11,  4.623185470252898e-14, -1.226545716777306e-16,  3.161072497329729e-19, -7.985416079186052e-22,
  1.981119904334200e-24, -4.870829650427585e-27,  1.175655057109411e-29, -2.859299165027391e-32,  3.478320482375181e-03, -1.537885326491809e-05,  5.093624443980486e-08,
 -1.497432341579445e-10,  4.118228911284147e-13, -1.084954277825857e-15,  2.769461769226150e-18, -6.908653211391546e-21,  1.686488785201904e-23, -4.064597607514381e-26,
  9.565984625196341e-29, -2.261039714319181e-31,  9.662784269572976e-03, -4.266143794341277e-05,  1.408148714748043e-07, -4.114023204697987e-10,  1.120339914908875e-12,
 -2.909357067354561e-15,  7.279204355696877e-18, -1.767824873660939e-20,  4.165308677931471e-23, -9.594735574562155e-26,  2.126186530885228e-28, -4.676475579836873e-31,
  1.894133086507187e-02, -8.344612824574070e-05,  2.740073170391282e-07, -7.929711640603798e-10,  2.126818979947619e-12, -5.399335943995782e-15,  1.307888163611898e-17,
 -3.036465984224154e-20,  6.718442623871065e-23, -1.419004495836942e-25,  2.761503751357402e-28, -5.061621892200748e-31,  3.131610316436360e-02, -1.375632762810382e-04,
  4.485459381753771e-07, -1.281356223530629e-09,  3.364752927396929e-12, -8.269885132599258e-15,  1.908762700244540e-17, -4.124622530460191e-20,  8.166059195626506e-23,
 -1.438649331645881e-25,  1.921306868629011e-28, -1.074367706740962e-31,  4.678982476743342e-02, -2.047822524137219e-04,  6.617788699228946e-07, -1.859123490537428e-09,
  4.747284113242565e-12, -1.115959117919484e-14,  2.399296610386163e-17, -4.608076100148246e-20,  7.283491373103116e-23, -7.074733254975648e-26, -1.052363000085282e-28,
  8.225552914003016e-31,  6.536567880042325e-02, -2.848075259932979e-04,  9.103459142808454e-07, -2.504533708298982e-09,  6.168907278789767e-12, -1.364726339902620e-14,
  2.636132057216667e-17, -4.069389355805771e-20,  3.067897478789187e-23,  9.442935007035511e-26, -6.164800416945425e-28,  2.124974202787080e-30,  8.704714774841166e-02,
 -3.772736134798894e-04,  1.190148706974834e-06, -3.191605850074535e-09,  7.507783311767995e-12, -1.527355164400452e-14,  2.477568560836559e-17, -2.167268738858406e-20,
 -4.971189788566183e-23,  3.443179128741049e-25, -1.247828352334618e-27,  3.331476055688253e-30,  1.118378079238897e-01, -4.817387879517825e-04,  1.496315498407212e-06,
 -3.890223761710335e-09,  8.628794751838398e-12, -1.556803704661048e-14,  1.799898640231166e-17,  1.287245984917969e-20, -1.652998218052362e-22,  6.394316260881345e-25,
 -1.800156103089824e-27,  3.704499163414847e-30,  1.397410702989126e-01, -5.976774188871600e-04,  1.823161103858806e-06, -4.566305916546335e-09,  9.387506488096929e-12,
 -1.408228851539028e-14,  5.159959708050625e-18,  6.253155739041014e-20, -3.027970289634096e-22,  9.051025063375833e-25, -1.986080211784211e-27,  2.405605326557085e-30,
  1.707598571362624e-01, -7.244707843303617e-04,  2.164142905402200e-06, -5.182064562393396e-09,  9.635229567470404e-12, -1.042930354925599e-14, -1.404420790267642e-17,
  1.238805022116737e-19, -4.374019544842544e-22,  1.035793886206684e-24, -1.483623484282580e-27, -1.199278386441807e-30,  2.048962010477263e-01, -8.613961693332753e-04,
  2.511814267576807e-06, -5.696388498998580e-09,  9.225420692901528e-12, -4.329550445509361e-15, -3.913816100782417e-17,  1.899324973749122e-19, -5.332134803710573e-22,
  9.092485654166264e-25, -3.039025827575587e-29, -7.126768799564641e-30,  2.421507496373189e-01, -1.007614035621755e-03,  2.857777420110605e-06, -6.065393689203088e-09,
  8.021681377298957e-12,  4.336566934357081e-15, -6.866685391958012e-17,  2.498933593574573e-19, -5.460324479071186e-22,  4.123326957751929e-25,  2.446111522256330e-27,
 -1.433909295643703e-29,  2.825221545669397e-01, -1.162153019245229e-03,  3.192638844985736e-06, -6.243198271800694e-09,  5.907642520151533e-12,  1.547068677802091e-14,
 -1.000252453608241e-16,  2.893962388959883e-19, -4.292632512558645e-22, -5.210186183040314e-25,  5.679558840544539e-27, -2.043652789765732e-29,  3.260063184753767e-01,
 -1.323892488192216e-03,  3.505971592180860e-06, -6.182993662551408e-09,  2.799021578623954e-12,  2.869488350274690e-14, -1.293525147351402e-16,  2.914278428871483e-19,
 -1.434928219982885e-22, -1.862030378589960e-24,  8.933483913489928e-27, -2.170451961175979e-29,  3.725954663907333e-01, -1.491542375146112e-03,  3.786290887188412e-06,
 -5.838501502741348e-09, -1.341897248264807e-12,  4.329016340850901e-14, -1.515371541074846e-16,  2.381838285902021e-19,  3.300540722489450e-22, -3.436107778401505e-24,
  1.094680735478878e-26, -1.378951083819332e-29,  4.222769997267460e-01, -1.663619999201277e-03,  4.021052082269079e-06, -5.165927078568565e-09, -6.489212599854397e-12,
  5.814128663776732e-14, -1.603948017258363e-16,  1.140873273978249e-19,  9.727507880338954e-22, -4.881581188323199e-24,  1.003906693311056e-26,  6.745837203341684e-30,
  4.750320801781919e-01, -1.838423616487625e-03,  4.196683702663074e-06, -4.126542581590804e-09, -1.253385152772659e-11,  7.169777843636314e-14, -1.490972629626842e-16,
 -8.985951647001186e-20,  1.710400812600845e-21, -5.639294907350259e-24,  4.472412801159792e-27,  3.990964457460111e-29,  5.308338772555982e-01, -2.014002512264829e-03,
  4.298673381767395e-06, -2.690055898727615e-09, -1.926196698067215e-11,  8.196600269971053e-14, -1.109453159644119e-16, -3.703945615134976e-19,  2.397666831091886e-21,
 -5.003054258110631e-24, -6.846455354247942e-27,  7.915334355636514e-29,  5.896453961343157e-01, -2.188123595772352e-03,  4.311731275506369e-06, -8.389376818118048e-10,
 -2.633240519070585e-11,  8.655373460738647e-14, -4.058239009122542e-17, -7.053430265626972e-19,  2.812055554714396e-21, -2.267297508851805e-24, -2.331417470538844e-26,
  1.087349239230447e-28,  6.514167811369921e-01, -2.358234729630950e-03,  4.220064567257354e-06,  1.426117916662137e-09, -3.325542954256154e-11,  8.279666625940386e-14,
  6.427238737801657e-17, -1.046978634861660e-18,  2.668046426414413e-21,  2.994730116103068e-24, -4.139235343433926e-26,  1.037672066003537e-28,  7.160819636500764e-01,
 -2.521425487505643e-03,  4.007808395457040e-06,  4.079451645457956e-09, -3.937653791245201e-11,  6.800486815324978e-14,  2.005578525747961e-16, -1.317381879340594e-18,
  1.665370529019557e-21,  1.051383647177589e-23, -5.366271597741893e-26,  3.624663257937041e-29,  7.835544907585617e-01, -2.674386791860582e-03,  3.659673286649673e-06,
  7.062356552205973e-09, -4.387164695408458e-11,  3.987408010972099e-14,  3.572036015406581e-16, -1.409192972410332e-18, -4.136014081388022e-22,  1.882515871594925e-23,
 -4.911081926090796e-26, -1.094742241631145e-28,  8.537223318032461e-01, -2.813372093256248e-03,  3.161886821262023e-06,  1.027378609464996e-08, -4.576332222865402e-11,
 -2.893300868315370e-15,  5.124722924629178e-16, -1.196852349951167e-18, -3.548486327937828e-21,  2.486742540423261e-23, -1.603093847343131e-26, -3.110086435538820e-28,
  9.264414145940684e-01, -2.934164638963764e-03,  2.503526550553762e-06,  1.356035317931922e-08, -4.397213493292427e-11, -5.972942166465758e-14,  6.321874748999634e-16,
 -5.648189458444901e-19, -7.279491619221169e-21,  2.405428266100981e-23,  5.102768311175797e-26, -4.797106407835112e-28,  1.001527592945243e+00, -3.032058258103849e-03,
  1.678358545396017e-06,  1.670677102530560e-08, -3.742219760317514e-11, -1.271269281719537e-13,  6.704078606547416e-16,  5.411114546283239e-19, -1.051774910854692e-20,
  1.139899183295421e-23,  1.401632814477304e-25, -4.536968391650734e-28,  1.078746697542450e+00, -3.101863385865197e-03,  6.873033159378968e-07,  1.942896035826160e-08,
 -2.522399818608149e-11, -1.974832067948917e-13,  5.749391224291737e-16,  2.038327867973744e-18, -1.150299764361731e-20, -1.568412089744808e-23,  2.107425967178518e-25,
 -5.519219714136850e-29,  1.157802283906120e+00, -3.137956278147864e-03, -4.583680047391853e-07,  2.137369893733405e-08, -6.957242366567440e-12, -2.582007665089469e-13,
  3.006999675889502e-16,  3.621126578468830e-18, -8.141072528401321e-21, -5.281365125463898e-23,  1.930291006760199e-25,  7.446935439727496e-28,  1.238320685975967e+00,
 -3.134398056640464e-03, -1.733079209806551e-06,  2.213100906290104e-08,  1.693571988161577e-11, -2.917029555641809e-13, -1.665322708632715e-16,  4.705756869302760e-18,
  1.000042201290618e-21, -8.395883466177151e-23,  1.802801762267773e-26,  1.580149471348636e-27,  1.319833051069703e+00, -3.085161651172379e-03, -3.092389775033244e-06,
  2.126828656766313e-08,  4.467176898884461e-11, -2.774287799698153e-13, -7.768747884068161e-16,  4.491086320266783e-18,  1.493692917974971e-20, -8.155013719848514e-23,
 -3.072337911530654e-25,  1.582786538895524e-27,  1.401754239457561e+00, -2.984518293527882e-03, -4.468349232076970e-06,  1.839758046219530e-08,  7.266863289543748e-11,
 -1.971612974216513e-13, -1.383353265586969e-15,  2.252371232958281e-18,  2.835113473708572e-20, -1.946014529124189e-23, -6.043601065902654e-25, -1.282906353716861e-28,
  1.483358928534168e+00, -2.827648285964723e-03, -5.765929454955729e-06,  1.328705392957181e-08,  9.534668557641367e-11, -4.468973598310416e-14, -1.734811474727735e-15,
 -2.058486331452827e-18,  3.143984701400249e-20,  9.630461939995305e-23, -5.254758406127016e-25, -3.068731840460807e-27,  1.563756127917548e+00, -2.611546317201362e-03,
 -6.862702832216124e-06,  6.019599847358203e-09,  1.056115310000303e-10,  1.611860535441440e-13, -1.537826741174878e-15, -7.074232766790354e-18,  1.468624756542064e-20,
  1.948075158692076e-22,  1.632415226710474e-25, -4.212275965547810e-27,  1.641864791861745e+00, -2.336275048194501e-03, -7.615228790264500e-06, -2.821932477573415e-09,
  9.656195295525842e-11,  3.660273159363415e-13, -6.269149444062508e-16, -9.808058323177499e-18, -2.011222651193008e-20,  1.580984738674482e-22,  1.048578721513290e-24,
 -1.884064524870894e-28,  1.716395497475584e+00, -2.006556816220002e-03, -7.876722179241784e-06, -1.201003473394104e-08,  6.476737681555488e-11,  4.841113842456919e-13,
  7.879690360479790e-16, -7.088455485451399e-18, -5.003005123287003e-20, -5.502479470922983e-23,  1.009190859798274e-24,  6.118034889639971e-27,  1.785846243148749e+00,
 -1.633548012550408e-03, -7.530228566861948e-06, -1.970082816322705e-08,  1.450291628513890e-11,  4.333318730665371e-13,  1.992100043662100e-15,  1.050393753537656e-18,
 -4.184890475644127e-20, -2.612163538039877e-22, -3.962891238787500e-25,  4.726307025915676e-27,  1.848523778883814e+00, -1.236388203369493e-03, -6.537430743530838e-06,
 -2.381135762775962e-08, -3.958946549271447e-11,  2.011090969370226e-13,  2.089605875466176e-15,  8.829918019140892e-18,  7.111293560487223e-21, -1.776595797821380e-22,
 -1.389823158814583e-24, -4.666063615012904e-27,  1.902603944825314e+00, -8.427858519949455e-04, -4.992971081573783e-06, -2.284581573762448e-08, -7.575401730048934e-11,
 -1.016609477899054e-13,  8.574901512753589e-16,  8.622233308594724e-18,  4.400525760469640e-20,  1.173696692099534e-22, -2.502867512397944e-25, -5.154947750030334e-27,
  1.946242376550784e+00, -4.876536954894194e-04, -3.158768798718847e-06, -1.696381894155252e-08, -7.703754612392314e-11, -2.819534849608230e-13, -6.583274511624256e-16,
  8.994757011790065e-19,  2.295786927151811e-20,  1.716067549109454e-22,  8.820006727278336e-25,  3.119019079941749e-27,  1.977737352381171e+00, -2.089632387321898e-04,
 -1.441958913171891e-06, -8.610504554242884e-09, -4.652850194581773e-11, -2.302277950836010e-13, -1.036553423564884e-15, -4.127684627472750e-18, -1.337888120397823e-20,
 -2.417931403921756e-23,  1.014458719970800e-25,  1.527697899058976e-27,  1.995732057949367e+00, -4.085026577242222e-05, -2.921551327966136e-07, -1.848253814063610e-09,
 -1.089547181832993e-11, -6.120872912627002e-14, -3.313952554299146e-16, -1.739500805825486e-18, -8.878354087277142e-21, -4.410479800348818e-23, -2.131013472455500e-25,
 -9.990400497672034e-28,  3.797141577239005e-04, -1.665315793589684e-06,  5.476659817322227e-09, -1.600867932057092e-11,  4.385285426378982e-14, -1.153293027731113e-16,
  2.946098985974578e-19, -7.378630140219814e-22,  1.813939900938476e-24, -4.424818310857244e-27,  1.056585110192624e-29, -2.559438671497718e-32,  3.417608824735655e-03,
 -1.497844059480260e-05,  4.917815607873702e-08, -1.433241138964711e-10,  3.907731170992569e-13, -1.020748845527911e-15,  2.583360127516713e-18, -6.391669428932863e-21,
  1.546817366157317e-23, -3.701162522691001e-26,  8.622388472548269e-29, -2.032815618900663e-31,  9.494360713623419e-03, -4.155436591191803e-05,  1.359837063792812e-07,
 -3.939330525070036e-10,  1.063860453418913e-12, -2.740448570722107e-15,  6.802366180102772e-18, -1.639901369210880e-20,  3.834722611166402e-23, -8.784129009832466e-26,
  1.929936163126182e-28, -4.252181140461417e-31,  1.861187100936913e-02, -8.129156192814398e-05,  2.646923285964973e-07, -7.597891840311251e-10,  2.021903561398449e-12,
 -5.095407016575574e-15,  1.225801676806883e-17, -2.829440397340212e-20,  6.226955743085481e-23, -1.312903970930332e-25,  2.545819397214702e-28, -4.746315891950617e-31,
  3.077293068687089e-02, -1.340355110720115e-04,  4.334873012157478e-07, -1.228818855460204e-09,  3.203844214744642e-12, -7.825350264276652e-15,  1.796854856028878e-17,
 -3.871447919399546e-20,  7.661855351160033e-23, -1.362846577827362e-25,  1.866381476850371e-28, -1.410981828208159e-31,  4.598114472715872e-02, -1.995759848820748e-04,
  6.399178621401147e-07, -1.784921626467325e-09,  4.529747441409812e-12, -1.059898213803498e-14,  2.273494655663559e-17, -4.379153865534925e-20,  7.022053815624121e-23,
 -7.427918443678247e-26, -7.246299883901782e-29,  6.705432361677822e-31,  6.424082622830699e-02, -2.776433188766920e-04,  8.808748279827557e-07, -2.407980764191587e-09,
  5.902197020048546e-12, -1.302815094298019e-14,  2.523611388752744e-17, -3.966235658782524e-20,  3.365631261830856e-23,  7.155420520569331e-26, -5.293475256634602e-28,
  1.840648685098872e-30,  8.555685596440282e-02, -3.679036017947694e-04,  1.152560207509059e-06, -3.073892987269943e-09,  7.208208408133719e-12, -1.468638585462684e-14,
  2.414837582868411e-17, -2.307449387342383e-20, -3.818052726247219e-23,  2.972308645654219e-25, -1.109093630132607e-27,  2.978646039378513e-30,  1.099345014455028e-01,
 -4.699526711832777e-04,  1.450450978995668e-06, -3.754630348870456e-09,  8.321779961733896e-12, -1.513231316959394e-14,  1.828872430576866e-17,  7.937595281092697e-21,
 -1.435377995482217e-22,  5.706098004890662e-25, -1.642823777573813e-27,  3.445270995066005e-30,  1.373791877384161e-01, -5.833087806970056e-04,  1.769257362548338e-06,
 -4.418351674329891e-09,  9.107235396801196e-12, -1.393850422885460e-14,  6.779980554977560e-18,  5.334826779042869e-20, -2.716175422256499e-22,  8.278042589993138e-25,
 -1.878276733450757e-27,  2.482084709001136e-30,  1.678962101274056e-01, -7.074037753694796e-04,  2.102876173183713e-06, -5.029586740204887e-09,  9.423545818109563e-12,
 -1.072628829281086e-14, -1.076598639435873e-17,  1.104687127004665e-19, -4.011924060548181e-22,  9.755994039024160e-25, -1.521291344364668e-27, -5.386428399673824e-31,
  2.014903760066268e-01, -8.415725794298421e-04,  2.444340228010319e-06, -5.549523758289612e-09,  9.129857455827774e-12, -5.206946868385133e-15, -3.405401496768402e-17,
  1.733925705210614e-19, -5.005741521245070e-22,  9.021793347681491e-25, -3.131139370021263e-28, -5.759376479598057e-30,  2.381655600519308e-01, -9.850407672391138e-04,
  2.785765355752884e-06, -5.936440134390179e-09,  8.092489285495524e-12,  2.770566516764260e-15, -6.191210319321414e-17,  2.326755091172765e-19, -5.295740804004338e-22,
  4.981318371327346e-25,  1.857693513175468e-27, -1.243788610346758e-29,  2.779241525268970e-01, -1.136909952442030e-03,  3.118297395012794e-06, -6.146328387594598e-09,
  6.193698457449136e-12,  1.316575000319528e-14, -9.211697778775866e-17,  2.754018275221428e-19, -4.441424736736728e-22, -3.112851964940392e-25,  4.820334431708949e-27,
 -1.862194019584812e-29,  3.207663752915295e-01, -1.296140695282620e-03,  3.432062774096347e-06, -6.133784047323587e-09,  3.342532667890907e-12,  2.568776451531430e-14,
 -1.212664163033463e-16,  2.858306506528831e-19, -2.043225569943555e-22, -1.523631974975573e-24,  7.990959733544150e-27, -2.108510604124535e-29,  3.666894333880912e-01,
 -1.461532596588223e-03,  3.716127984678785e-06, -5.853240749469490e-09, -5.119170022269941e-13,  3.973438364445865e-14, -1.447381434537185e-16,  2.468496441401825e-19,
  2.140837630362487e-22, -3.011007996275868e-24,  1.029377592973244e-26, -1.576957145467206e-29,  4.156864615757518e-01, -1.631701225087190e-03,  3.958475691773706e-06,
 -5.260659881783259e-09, -5.364605369620704e-12,  5.433350260752763e-14, -1.567904279401611e-16,  1.424815365990939e-19,  8.042972770925752e-22, -4.475851139999823e-24,
  1.020563576564728e-26,  1.005233483653688e-30,  4.677452143633354e-01, -1.805051522404185e-03,  4.146008630609471e-06, -4.315807730895845e-09, -1.113585193078334e-11,
  6.809524986781981e-14, -1.508773245206888e-16, -3.833713560585973e-20,  1.511003286361920e-21, -5.428146788195817e-24,  6.015775821176824e-27,  3.040707130279823e-29,
  5.228464343028588e-01, -1.979747363517333e-03,  4.264597181817390e-06, -2.985280855000587e-09, -1.765006976233736e-11,  7.918736436098153e-14, -1.202696238016822e-16,
 -2.965972184014029e-19,  2.213437284190998e-21, -5.210495588566167e-24, -3.605640156548299e-27,  6.817060441404555e-29,  5.809618157537078e-01, -2.153677045805975e-03,
  4.299193048561920e-06, -1.246467019714345e-09, -2.461261778120764e-11,  8.535284875650582e-14, -5.908569412832258e-17, -6.168339535721736e-19,  2.714782140737877e-21,
 -3.106129176923354e-24, -1.867904917091401e-26,  1.016543289255056e-28,  6.420514590329721e-01, -2.324414678563054e-03,  4.234040351493899e-06,  9.073525292769785e-10,
 -3.158639514965991e-11,  8.399715480634433e-14,  3.616625192203754e-17, -9.601866924822634e-19,  2.747171011928417e-21,  1.432095744464177e-24, -3.670397670794561e-26,
  1.086362861530928e-28,  7.060606816904623e-01, -2.489177812076601e-03,  4.053027363934846e-06,  3.460556916404005e-09, -3.797126193400338e-11,  7.238197329027599e-14,
  1.644712136129593e-16, -1.258444741946133e-18,  2.005686440155985e-21,  8.406894334925828e-24, -5.150522211983388e-26,  6.084827682773840e-29,  7.729160183397297e-01,
 -2.644782281972705e-03,  3.740237676185967e-06,  6.367242412714924e-09, -4.299163765935400e-11,  4.797259455239340e-14,  3.176600330814194e-16, -1.411972656764579e-18,
  2.277090599371649e-22,  1.677810361454030e-23, -5.291008036180462e-26, -6.392903949061332e-29,  8.425201968535896e-01, -2.787596304690876e-03,  3.280779198903039e-06,
  9.541766660382182e-09, -4.570097217908608e-11,  8.991882553941971e-15,  4.775042543682080e-16, -1.296229895009773e-18, -2.667961130893906e-21,  2.396771293198103e-23,
 -2.857266736172859e-26, -2.586015331892880e-28,  9.147458260515782e-01, -2.913497575488840e-03,  2.661992696884157e-06,  1.284806084511972e-08, -4.501641197732693e-11,
 -4.477221086517737e-14,  6.132440849900444e-16, -7.835544310555360e-19, -6.381832561062166e-21,  2.567915449396097e-23,  3.038982102436695e-26, -4.558835522620665e-28,
  9.894274687464477e-01, -3.017839831099635e-03,  1.875166207199566e-06,  1.608855423936393e-08, -3.980280584822030e-11, -1.108929413734790e-13,  6.809162040971423e-16,
  2.121512145944916e-19, -1.001144426109430e-20,  1.658846454064968e-23,  1.189157289995423e-25, -5.078844921815712e-28,  1.066351707377509e+00, -3.095439525378315e-03,
  9.179014772436324e-07,  1.899454744524339e-08, -2.903127097561968e-11, -1.830418482547758e-13,  6.267856345284903e-16,  1.662817117153870e-18, -1.191692465717400e-20,
 -7.351934850593424e-24,  2.046894249949365e-25, -2.167283550546684e-28,  1.145244746120971e+00, -3.140599566755423e-03, -2.027205622378347e-07,  2.122149697112127e-08,
 -1.204103638582550e-11, -2.497984088717944e-13,  3.981694611345730e-16,  3.331742157294749e-18, -9.896052787664778e-21, -4.449964265639974e-23,  2.210923234247278e-25,
  5.281033665270861e-28,  1.225757052355975e+00, -3.147196239944890e-03, -1.466074376841233e-06,  2.235513577820849e-08,  1.107237254831050e-11, -2.941177640884375e-13,
 -3.477567051919711e-17,  4.689671929890908e-18, -1.992924222324554e-21, -8.186849729043800e-23,  8.582793962078082e-26,  1.489528744414646e-27,  1.307444559208357e+00,
 -3.108868168953571e-03, -2.833068111828309e-06,  2.193767691329851e-08,  3.894719655637086e-11, -2.945135519628343e-13, -6.448900714228083e-16,  4.919864860730268e-18,
  1.179750032663289e-20, -9.235994676681583e-23, -2.312699559839231e-25,  1.855288203157420e-27,  1.389746098406870e+00, -3.019362548945193e-03, -4.240737984505860e-06,
  1.952695216533355e-08,  6.839903701252439e-11, -2.295032755566390e-13, -1.307724154198958e-15,  3.143732947078378e-18,  2.721576765947061e-20, -4.356066536444181e-23,
 -5.960087144234586e-25,  5.104762131352878e-28,  1.471957126840075e+00, -2.873112091431841e-03, -5.597368397590000e-06,  1.480317083498568e-08,  9.403246804871497e-11,
 -8.690012427837696e-14, -1.777873260427855e-15, -1.001254080350308e-18,  3.449693097680992e-20,  7.269798547359076e-23, -6.516905993262550e-25, -2.634331345494741e-27,
  1.553200637754046e+00, -2.666130041085839e-03, -6.780229221589730e-06,  7.733102477945547e-09,  1.084504313824689e-10,  1.219608909474056e-13, -1.728264696524195e-15,
 -6.491178188405344e-18,  2.177034882317877e-20,  1.974313763176671e-22, -3.662501366703986e-26, -4.839432777794951e-27,  1.632397671347502e+00, -2.397305515842679e-03,
 -7.639583360696125e-06, -1.219288967777924e-09,  1.037094425217674e-10,  3.476186714248646e-13, -9.096377236426961e-16, -1.035253003082304e-17, -1.367137095232025e-20,
  1.994698736910097e-22,  1.009562989194448e-24, -1.619087156701004e-27,  1.708242355742013e+00, -2.070128716418014e-03, -8.014302278245425e-06, -1.089534212924354e-08,
  7.462169877987388e-11,  5.004584726489661e-13,  5.668396227010050e-16, -8.712793697912248e-18, -5.121945409806556e-20, -9.279774395192494e-24,  1.277109631459123e-24,
  5.985818315713628e-27,  1.779190076637361e+00, -1.694730860464192e-03, -7.764951790666385e-06, -1.939684353955925e-08,  2.364922074126072e-11,  4.813350929759123e-13,
  2.001329762803343e-15, -4.418513495417239e-19, -5.148285840957246e-20, -2.723518521143385e-22, -1.463617285128832e-25,  6.663877317434543e-27,  1.843471802738739e+00,
 -1.289841039010576e-03, -6.826825834627463e-06, -2.440980233014678e-08, -3.504564550038499e-11,  2.542459017501230e-13,  2.338989157710516e-15,  8.944023504926746e-18,
 -3.334932968114800e-22, -2.372297262487962e-22, -1.584580523093721e-24, -4.100141827989732e-27,  1.899151148314424e+00, -8.838469717363116e-04, -5.274456498992580e-06,
 -2.407294260322369e-08, -7.756104474570897e-11, -7.802116718110390e-14,  1.119245753543614e-15,  1.009560098670686e-17,  4.799116353168179e-20,  1.023196694351990e-22,
 -5.151942232693060e-25, -6.937013382456832e-27,  1.944239902063388e+00, -5.137594974987173e-04, -3.369919073363588e-06, -1.824238056402200e-08, -8.283212023240401e-11,
 -2.973621458374379e-13, -6.218781578521692e-16,  1.740052954105956e-18,  2.980418825742072e-20,  2.096688030088075e-22,  1.021709569722674e-24,  3.200890537290824e-27,
  1.976877755345660e+00, -2.209252289352878e-04, -1.549908142242466e-06, -9.393188874186265e-09, -5.139144558245714e-11, -2.565411301746877e-13, -1.158246794700145e-15,
 -4.568811111998928e-18, -1.415850462007635e-20, -1.859967736840820e-23,  1.822728350885064e-25,  2.178937829975120e-27,  1.995563837626699e+00, -4.327928251568241e-05,
 -3.154219881152376e-07, -2.032824056251507e-09, -1.220329881560428e-11, -6.978031977724911e-14, -3.843297223558872e-16, -2.050747605032932e-18, -1.063076358554141e-20,
 -5.357574749958629e-23, -2.622189392302681e-25, -1.242646658278412e-27,  };
  constexpr double w[15744] = {  7.566092113354021e-02, -2.410400796940228e-04,  8.061864712324449e-07, -2.797224196115299e-09,  9.946297309732901e-12,
 -3.588269407168250e-14,  1.303875012222437e-16, -4.749411261715028e-19,  1.729033405388969e-21, -6.280365258804009e-24,  2.273925380700034e-26, -8.203209935889128e-29,
  7.534128443252569e-02, -3.446207934806731e-04,  1.835538428123680e-06, -9.831821416834911e-09,  5.118242744323734e-11, -2.585076314240787e-13,  1.271962848614270e-15,
 -6.122156004504836e-18,  2.891745945785553e-20, -1.343707654243983e-22,  6.154037970431983e-25, -2.782087806528937e-27,  7.470774323364461e-02, -5.486011452105309e-04,
  4.282292093845440e-06, -3.078827234216617e-08,  2.067796835665929e-10, -1.318956867159829e-12,  8.075745427492556e-15, -4.780174128478945e-17,  2.749237854347163e-19,
 -1.542202718301201e-21,  8.462891697451319e-24, -4.553668449152903e-26,  7.377153895958996e-02, -8.467643066179685e-04,  8.886462554017686e-06, -8.151785277980873e-08,
  6.820862917314650e-10, -5.330092275727110e-12,  3.945622762148475e-14, -2.793402711907939e-16,  1.904438934137564e-18, -1.256744973303542e-20,  8.059359481736216e-23,
 -5.038284533786853e-25,  7.254899018468962e-02, -1.230138455550176e-03,  1.667124544886724e-05, -1.905321157632566e-07,  1.944322696698348e-09, -1.824120598665964e-11,
  1.601589295729276e-13, -1.331820165243962e-15,  1.057869724230842e-17, -8.077253603510149e-20,  5.957466669149208e-22, -4.260739155858016e-24,  7.106087805036228e-02,
 -1.687394118325036e-03,  2.884791815860029e-05, -4.034820710762325e-07,  4.939623250006207e-09, -5.480040686317532e-11,  5.626842854047977e-13, -5.423206754119977e-15,
  4.955660817041092e-17, -4.325411131189937e-19,  3.626725717938735e-21, -2.934260016694604e-23,  6.933168608217558e-02, -2.205332019808452e-03,  4.670310455425554e-05,
 -7.873465142879813e-07,  1.140934984103639e-08, -1.478645818698300e-10,  1.755638421423542e-12, -1.940583741549837e-14,  2.019698215056640e-16, -1.995973571838538e-18,
  1.885155287644027e-20, -1.710213848912723e-22,  6.738873853940822e-02, -2.769430483409482e-03,  7.147842844652805e-05, -1.433199876796325e-06,  2.430102484792199e-08,
 -3.641307221854808e-10,  4.952202486791904e-12, -6.222366273420544e-14,  7.314555144275021e-16, -8.119776862819832e-18,  8.573023146613158e-20, -8.657130917386645e-22,
  6.526128503366595e-02, -3.364419217198527e-03,  1.042528764779370e-04, -2.456563529652621e-06,  4.824346187603674e-08, -8.282463663613653e-10,  1.279590911827111e-11,
 -1.813608565496547e-13,  2.390611289964397e-15, -2.960528883905583e-17,  3.471421397135208e-19, -3.877462516531557e-21,  6.297957906846163e-02, -3.974846827177691e-03,
  1.458374597186924e-04, -3.994644015001470e-06,  9.002608390789030e-08, -1.756411253220731e-09,  3.059705020809369e-11, -4.858240667271891e-13,  7.134720473632634e-15,
 -9.796982102604905e-17,  1.268395637650149e-18, -1.558391298332335e-20,  6.057399466273004e-02, -4.585612367708870e-03,  1.966901508648346e-04, -6.200177593707469e-06,
  1.589962371395606e-07, -3.498855919032346e-09,  6.826063938417844e-11, -1.206629486736937e-12,  1.962724468133031e-14, -2.971858142980598e-16,  4.226023652680191e-18,
 -5.682654074261829e-20,  5.807421892123248e-02, -5.182436195126021e-03,  2.568568199352622e-04, -9.232066711849319e-06,  2.672728260657366e-07, -6.588045156416266e-09,
  1.430404625769621e-10, -2.798653467965706e-12,  5.015028350765051e-14, -8.330736625978562e-16,  1.294880179853640e-17, -1.896887039439581e-19,  5.550855010936808e-02,
 -5.752251702551913e-03,  3.259412886742318e-04, -1.324343989060735e-05,  4.296753949069726e-07, -1.178644940973151e-08,  2.831314105984838e-10, -6.098350607964399e-12,
  1.197796519139724e-13, -2.172560077896109e-15,  3.674562775508313e-17, -5.839093846241621e-19,  5.290332138603317e-02, -6.283506485044030e-03,  4.031049761382968e-04,
 -1.836812875529207e-05,  6.632873758088744e-07, -2.012484918023014e-08,  5.319056813483591e-10, -1.254807840051415e-11,  2.688620958034512e-13, -5.300976076863615e-15,
  9.714919221644548e-17, -1.667841098835011e-18,  5.028246074392860e-02, -6.766368437827533e-03,  4.870941898490932e-04, -2.470678777291177e-05,  9.866094140785736e-07,
 -3.292012074024232e-08,  9.523221995238281e-10, -2.448754309323456e-11,  5.697992814437388e-13, -1.216032822723644e-14,  2.405115171441736e-16, -4.443928189211633e-18,
  4.766718869670068e-02, -7.192838642469178e-03,  5.762911434042907e-04, -3.231395953388151e-05,  1.418308737796476e-06, -5.176100302911628e-08,  1.630734951628950e-09,
 -4.549514433311839e-11,  1.144724199671844e-12, -2.633702253250050e-14,  5.600193547234438e-16, -1.109601149577646e-17,  4.507584745918066e-02, -7.556778205264581e-03,
  6.687833895110213e-04, -4.118731070122466e-05,  1.975626143821726e-06, -7.845196235629950e-08,  2.679061661234226e-09, -8.073762997791382e-11,  2.187693157187014e-12,
 -5.405228371566660e-14,  1.231130267036923e-15, -2.606652556013063e-17,  4.252384920413373e-02, -7.853860205756832e-03,  7.624456008750008e-04, -5.126005189900999e-05,
  2.672554838099602e-06, -1.149090913053199e-07,  4.234129131132509e-09, -1.372589484682117e-10,  3.989447772466347e-12, -1.054597817805968e-13,  2.563885293871085e-15,
 -5.781389394988054e-17,  4.002372664374710e-02, -8.081460486826770e-03,  8.550274877228177e-04, -6.239724527721029e-05,  3.517947020921799e-06, -1.630077062051723e-07,
  6.453060258435112e-09, -2.241145698669098e-10,  6.960740137980345e-12, -1.961637048864190e-13,  5.073101994247885e-15, -1.214368692704226e-16,  3.758526667733858e-02,
 -8.238502216179833e-03,  9.442420266536250e-04, -7.439634112310199e-05,  4.513728480888668e-06, -2.243882382608343e-07,  9.503859035813908e-09, -3.522436398828040e-10,
  1.164800664804528e-11, -3.487377714053377e-13,  9.562384193232740e-15, -2.422252161628739e-16,  3.521570701038121e-02, -8.325269133501241e-03,  1.027848967479522e-03,
 -8.699191554774648e-05,  5.653405051034360e-06, -3.002341442030178e-07,  1.355088948637712e-08, -5.339759859798504e-10,  1.873339561892842e-11, -5.938687364462936e-13,
  1.721003933900487e-14, -4.599212646535855e-16,  3.291997621480558e-02, -8.343201405694787e-03,  1.103729640630481e-03, -9.986424549413321e-05,  6.921027226118677e-06,
 -3.910417713247338e-07,  1.873568585270360e-08, -7.820999283297022e-10,  2.901051439958395e-11, -9.706031687829763e-13,  2.963522074736859e-14, -8.330404726875527e-16,
  3.070095933621653e-02, -8.294686318569063e-03,  1.169950266487507e-03, -1.126510858326502e-04,  8.290743129418961e-06, -4.964063605229669e-07,  2.515437786911939e-08,
 -1.108471517679664e-09,  4.332844809387760e-11, -1.525095873845068e-12,  4.891308360302344e-14, -1.442047114442151e-15,  2.855977351351234e-02, -8.182853912560338e-03,
  1.224812144863782e-03, -1.249618248058758e-04,  9.727020230875354e-06, -6.148498875584682e-07,  3.283383392161300e-08, -1.522221991365068e-09,  6.250005289336496e-11,
 -2.307299734755149e-12,  7.750187975406556e-14, -2.389641624248166e-15,  2.649604083386123e-02, -8.011385372338956e-03,  1.266888179165031e-03, -1.363930949947998e-04,
  1.118555899256484e-05, -7.437148503949674e-07,  4.170927054709724e-08, -2.027707758331641e-09,  8.717622613624236e-11, -3.365245477514990e-12,  1.180467464283474e-13,
 -3.796097497291803e-15,  2.450814851987669e-02, -7.784339711734492e-03,  1.295046097624090e-03, -1.465449030074791e-04,  1.261486353035012e-05, -8.791434804970346e-07,
  5.160641717201927e-08, -2.622431254124567e-09,  1.176952003389734e-10, -4.736950092210608e-12,  1.730379171227014e-13, -5.787737935727151e-15,  2.259348931452219e-02,
 -7.506002210508081e-03,  1.308459436096200e-03, -1.550363998158054e-04,  1.395838143933152e-05, -1.016154682078995e-06,  6.223126768199178e-08, -3.295224543768434e-09,
  1.539237148485896e-10, -6.440531291207283e-12,  2.443265687356883e-13, -8.477478829326330e-15,  2.074867743518480e-02, -7.180756259179599e-03,  1.306607832895019e-03,
 -1.615205276169453e-04,  1.515708188759115e-05, -1.148822109809635e-06,  7.316996060834534e-08, -4.025014767504204e-09,  1.951135832454874e-10, -8.463706506949466e-12,
  3.325374668259391e-13, -1.193795995830249e-14,  1.896973761481261e-02, -6.812978805114413e-03,  1.289268467037258e-03, -1.656969287782858e-04,  1.615231104217219e-05,
 -1.270547202588539e-06,  8.390043859119253e-08, -4.780470203473157e-09,  2.398009824421772e-10, -1.075438879517104e-11,  4.364578915409034e-13, -1.616998503734430e-14,
  1.725226649106070e-02, -6.406958480091656e-03,  1.256500572842486e-03, -1.673226688871124e-04,  1.688874821018792e-05, -1.374411764865594e-06,  9.381633895013452e-08,
 -5.520754007292038e-09,  2.857753030847081e-10, -1.321440963317846e-11,  5.525174581102827e-13, -2.107136778190501e-14,  1.559156694191478e-02, -5.966834709234912e-03,
  1.208624920366849e-03, -1.662204926541000e-04,  1.731728451253326e-05, -1.453586800258039e-06,  1.022622028501983e-07, -6.197494534863496e-09,  3.301388406334434e-10,
 -1.569836752144645e-11,  6.744922487680635e-13, -2.641318709270138e-14,  1.398275692646364e-02, -5.496555616066292e-03,  1.146199999910460e-03, -1.622844854857735e-04,
  1.739765693303364e-05, -1.501768524835387e-06,  1.085777302040151e-07, -6.757930120704695e-09,  3.694681260232515e-10, -1.801914411340003e-11,  7.935593608923688e-13,
 -3.183116352973693e-14,  1.242085502036531e-02, -4.999852300207714e-03,  1.069996425937443e-03, -1.554831460719889e-04,  1.710069180664622e-05, -1.513609318353010e-06,
  1.121476233674424e-07, -7.149022589367209e-09,  4.000734746140543e-10, -1.996075472712678e-11,  8.987893490933376e-13, -3.683879538119530e-14,  1.090084519692385e-02,
 -4.480227021513523e-03,  9.809708134033293e-04, -1.458599814356517e-04,  1.641004038724516e-05, -1.485111014390382e-06,  1.124527061494853e-07, -7.322181562783713e-09,
  4.183374538519707e-10, -2.129801492765062e-11,  9.780960422179175e-13, -4.086582000699390e-14,  9.417723565666466e-03, -3.940952930208193e-03,  8.802401049125139e-04,
 -1.335318142401762e-04,  1.532332217428094e-05, -1.413950307547587e-06,  1.091175866142587e-07, -7.238124506971394e-09,  4.210980845515577e-10, -2.182120545649673e-11,
  1.019575887375284e-12, -4.332081235167803e-14,  7.966529832651868e-03, -3.385083206108406e-03,  7.690570639315034e-04, -1.186850445986590e-04,  1.385262656417414e-05,
 -1.299710856359811e-06,  1.019502107540636e-07, -6.871335083741691e-09,  4.060314422378982e-10, -2.136275499266092e-11,  1.013079211676995e-12, -4.367117284650467e-14,
  6.542366386728578e-03, -2.815467836141020e-03,  6.487874266126260e-04, -1.015701408625457e-04,  1.202435816713921e-05, -1.144003417122990e-06,  9.096923105638554e-08,
 -6.213587199030441e-09,  3.719832301768543e-10, -1.982218887798191e-11,  9.517839983031437e-13, -4.152867431581250e-14,  5.140408922210406e-03, -2.234777061459451e-03,
  5.208891084423135e-04, -8.249466278011059e-05,  9.878445580823609e-06, -9.504635974568628e-07,  7.641614488513442e-08, -5.276077959825689e-09,  3.192013087926046e-10,
 -1.718541549234480e-11,  8.335081168777285e-13, -3.672552075807467e-14,  3.755919336431537e-03, -1.645533914611067e-03,  3.868944130238704e-04, -6.181523442463541e-05,
  7.466976530678292e-06, -7.246269125904629e-07,  5.875062041600463e-08, -4.089858297957182e-09,  2.494316230376294e-10, -1.353495703426488e-11,  6.615120110345857e-13,
 -2.936566045770922e-14,  2.384335197589088e-03, -1.050186721709297e-03,  2.484027340810187e-04, -3.992995123272599e-05,  4.852478684105365e-06, -4.737024399207657e-07,
  3.863003033628541e-08, -2.704508676694903e-09,  1.658609982829187e-10, -9.049142715645622e-12,  4.446228464784800e-13, -1.983979545125419e-14,  1.022838386805074e-03,
 -4.518400159629676e-04,  1.072306360650533e-04, -1.729520985448644e-05,  2.108834233681100e-06, -2.065439202243302e-07,  1.689786275612335e-08, -1.186766481615044e-09,
  7.300640907807863e-11, -3.995154891117834e-12,  1.968780793243713e-13, -8.810262618885639e-15,  7.470945095809885e-02, -2.347222027517605e-04,  7.735514815104083e-07,
 -2.643659056480144e-09,  9.258890710090881e-12, -3.290692488012630e-14,  1.178309791869941e-16, -4.230608191168706e-19,  1.518479173003299e-21, -5.439007049814122e-24,
  1.942268190302933e-26, -6.911491888948743e-29,  7.399144180425858e-02, -3.303948743008685e-04,  1.722304687048082e-06, -9.052661616507347e-09,  4.630418289090034e-11,
 -2.299373075347873e-13,  1.112802822663931e-15, -5.269673277995966e-18,  2.449522797536952e-20, -1.120369763830458e-22,  5.051668218917018e-25, -2.248734204460433e-27,
  7.257959226132840e-02, -5.157663400438591e-04,  3.931846074025653e-06, -2.768073755373448e-08,  1.822352390661467e-10, -1.140255294985322e-12,  6.852560185467706e-15,
 -3.983088010053064e-17,  2.250442264173864e-19, -1.240578515951782e-21,  6.692018762103723e-24, -3.540535235965502e-26,  7.052072142235898e-02, -7.794077158325057e-04,
  7.970370427662172e-06, -7.140837652314730e-08,  5.843542909832018e-10, -4.470511519502855e-12,  3.242407056805481e-14, -2.250557866639869e-16,  1.505067593559260e-18,
 -9.746795768564179e-21,  6.136330892121071e-23, -3.767323569433804e-25,  6.788140754906896e-02, -1.105411607775854e-03,  1.456011929539387e-05, -1.621447219137804e-07,
  1.615103015976426e-09, -1.480916170843000e-11,  1.272008632256795e-13, -1.035570759569706e-15,  8.058196287106590e-18, -6.030811158813532e-20,  4.361981716237445e-22,
 -3.060538765626361e-24,  6.474399633281336e-02, -1.474713108341035e-03,  2.444641195688832e-05, -3.325310037472422e-07,  3.967228020529242e-09, -4.295243095615177e-11,
  4.308808334186828e-13, -4.060884182819908e-15,  3.631255682759938e-17, -3.103452689610084e-19,  2.549359261539588e-21, -2.021729031663120e-23,  6.120187188850928e-02,
 -1.866607219937541e-03,  3.825959424788025e-05, -6.263383035940370e-07,  8.832909493776291e-09, -1.115808315652666e-10,  1.292913409351626e-12, -1.396049399689251e-14,
  1.420507746447738e-16, -1.373421579492765e-18,  1.269849748314326e-20, -1.128357338149864e-22,  5.735439962662107e-02, -2.260301053821874e-03,  5.639200902059189e-05,
 -1.096734746945596e-06,  1.807841961155268e-08, -2.637882260519594e-10,  3.498007301683530e-12, -4.290020319361507e-14,  4.926706568362031e-16, -5.346961979480153e-18,
  5.523049503058569e-20, -5.459558725353485e-22,  5.330194785387544e-02, -2.636347542003651e-03,  7.890852486849023e-05, -1.802084457117094e-06,  3.437904718604003e-08,
 -5.743339814187646e-10,  8.645908277073751e-12, -1.195356622765978e-13,  1.538446950239943e-15, -1.861709682648007e-17,  2.134644953763659e-19, -2.333007617858109e-21,
  4.914134895778544e-02, -2.977834706236044e-03,  1.055026415931435e-04, -2.799553351774813e-06,  6.125998226977477e-08, -1.162459137183766e-09,  1.972285930833802e-11,
 -3.053527396416779e-13,  4.376752001891091e-15, -5.870613116767410e-17,  7.429895916734785e-19, -8.929556026218426e-21,  4.496208159244543e-02, -3.271244917145552e-03,
  1.355021786041052e-04, -4.137369154563250e-06,  1.029937693493407e-07, -2.203885807818682e-09,  4.186667441474319e-11, -7.214497845692941e-13,  1.145125475774435e-14,
 -1.693387496947949e-16,  2.353557794949519e-18, -3.095332971013308e-20,  4.084335619960807e-02, -3.506944777615373e-03,  1.679206498632390e-04, -5.846967312521371e-06,
  1.643257270111149e-07, -3.938582262703505e-09,  8.326494435508503e-11, -1.588068380470878e-12,  2.776766533448743e-14, -4.504763769669011e-16,  6.843464219016712e-18,
 -9.805064371622706e-20,  3.685218215868680e-02, -3.679311034391214e-03,  2.015440304827990e-04, -7.936360993848351e-06,  2.500319505872430e-07, -6.670464238329881e-09,
  1.560451097437408e-10, -3.276814186918605e-12,  6.280945184009557e-14, -1.112735733519632e-15,  1.839671299108737e-17, -2.859576518937866e-19,  3.304239901746273e-02,
 -3.786535300641317e-03,  2.350386478821395e-04, -1.038588878847282e-05,  3.643522621872713e-07, -1.075575425713606e-08,  2.769364380481521e-10, -6.371390822966624e-12,
  1.332645609103283e-13, -2.567080744613024e-15,  4.599965971781994e-17, -7.726957114475980e-19,  2.945457646099233e-02, -3.830176499911034e-03,  2.670647156219588e-04,
 -1.314707721252264e-05,  5.103729036415475e-07, -1.657831856968205e-08,  4.674354704694697e-10, -1.172729046066057e-11,  2.664973364619075e-13, -5.558996240692605e-15,
  1.075459280219125e-16, -1.945069155434834e-18,  2.611663357743813e-02, -3.814543340769100e-03,  2.963813406278764e-04, -1.614481457178220e-05,  6.894522083168872e-07,
 -2.451270228567216e-08,  7.532151494369414e-10, -2.051550565751009e-11,  5.044142272522110e-13, -1.134937590834141e-14,  2.361809825037752e-16, -4.582915175073028e-18,
  2.304499900684299e-02, -3.745990495550552e-03,  3.219320287332281e-04, -1.928249201869152e-05,  9.007820307641897e-07, -3.487826135735468e-08,  1.162598584923550e-09,
 -3.423176859389883e-11,  9.070164461942550e-13, -2.193073348403069e-14,  4.891697329227798e-16, -1.014945692243971e-17,  2.024612760892218e-02, -3.632203790796598e-03,
  3.429039330747253e-04, -2.244933459229199e-05,  1.141158463906407e-06, -4.789008572422212e-08,  1.724066395126246e-09, -5.465294119574603e-11,  1.554594788059855e-12,
 -4.024770572104699e-14,  9.589481233215857e-16, -2.120546474292870e-17,  1.771820182456524e-02, -3.481534811713791e-03,  3.587584743522741e-04, -2.552888906244886e-05,
  1.405002082926114e-06, -6.361372615655283e-08,  2.462955413854333e-09, -8.372717432220819e-11,  2.547322141708790e-12, -7.036865963012820e-14,  1.785021729167627e-15,
 -4.193667884827159e-17,  1.545287119365192e-02, -3.302427243740135e-03,  3.692348077883453e-04, -2.840757854163986e-05,  1.684628356087616e-06, -8.193072389751990e-08,
  3.397694405040137e-09, -1.233942887832936e-10,  4.001057593584590e-12, -1.175368927233301e-13,  3.164127634783278e-15, -7.873541666158824e-17,  1.343691568738819e-02,
 -3.102958997327171e-03,  3.743304641274541e-04, -3.098235483610533e-05,  1.970731392707208e-06, -1.025205786404343e-07,  4.536063494363788e-09, -1.753460016475812e-10,
  6.038566596872177e-12, -1.880233127816875e-13,  5.354884420824145e-15, -1.407129827189856e-16,  1.165375249573809e-02, -2.890507923219312e-03,  3.742651656974746e-04,
 -3.316672707397416e-05,  2.253015865608348e-06, -1.248623833057797e-07,  5.872021954653058e-09, -2.407494216180660e-10,  8.776075313068921e-12, -2.887146003872406e-13,
  8.672462719846298e-15, -2.399536273956282e-16,  1.008473776249179e-02, -2.671536088495277e-03,  3.694343604391640e-04, -3.489475487396638e-05,  2.520896911280642e-06,
 -1.482564327102145e-07,  7.383607140346770e-09, -3.199684527474495e-10,  1.230600678713267e-11, -4.264049702341456e-13,  1.346908366658071e-14, -3.912765344815988e-16,
  8.710241931877808e-03, -2.451478687754910e-03,  3.603586361650821e-04, -3.612290450514725e-05,  2.764186933842697e-06, -1.718632772417238e-07,  9.032272988758619e-09,
 -4.123235508733393e-10,  1.667770432499138e-11, -6.068131703812833e-13,  2.009771934083477e-14, -6.112765917683042e-16,  7.510498593230987e-03, -2.234718589398269e-03,
  3.476341655230375e-04, -3.682992938878998e-05,  2.973699496203075e-06, -1.947554617054770e-07,  1.076383773384902e-08, -5.159290306440834e-10,  2.187871090150724e-11,
 -8.334103660701773e-13,  2.885924494978264e-14, -9.164891696372403e-16,  6.466241757438752e-03, -2.024625702775283e-03,  3.318879914971662e-04, -3.701512353277778e-05,
  3.141719967678320e-06, -2.159758958347164e-07,  1.251098793237850e-08, -6.276388033341156e-10,  2.781954585451489e-11, -1.106205394328777e-12,  3.993709382705512e-14,
 -1.320674972570113e-15,  5.559155878482899e-03, -1.823641011351535e-03,  3.137405555830085e-04, -3.669539911529095e-05,  3.262315713434892e-06, -2.345965482060529e-07,
  1.419708188356147e-08, -7.431176006248400e-10,  3.432478504360880e-11, -1.420676520958870e-12,  5.332743951111486e-14, -1.831431539301922e-15,  4.772167583479149e-03,
 -1.633387416557537e-03,  2.937765891153004e-04, -3.590166417085212e-05,  3.331481119213574e-06, -2.497718296106522e-07,  1.574084420482349e-08, -8.570380897400007e-10,
  4.113260361061623e-11, -1.767050945957545e-12,  6.877610965339164e-14, -2.446567706036815e-15,  4.089609107132118e-03, -1.454792721999653e-03,  2.725244494651212e-04,
 -3.467493996726704e-05,  3.347131475754894e-06, -2.607823770734952e-07,  1.706146441358594e-08, -9.633878997586604e-10,  4.790388893749810e-11, -2.130108712843713e-12,
  8.573489840100812e-14, -3.150869455974828e-15,  3.497281938855464e-03, -1.288213552881521e-03,  2.504432350553373e-04, -3.306258130354344e-05,  3.308972904399339e-06,
 -2.670666405776919e-07,  1.808360923272859e-08, -1.055857221770017e-09,  5.424076505117886e-11, -2.489628167483125e-12,  1.033490624267218e-13, -3.913981009348199e-15,
  2.982446147485166e-03, -1.133552319379112e-03,  2.279165516443040e-04, -3.111486732072080e-05,  3.218282613660934e-06, -2.682393954992987e-07,  1.874192020692737e-08,
 -1.128269203851841e-09,  5.971311234645043e-11, -2.821505061902100e-12,  1.204844295428510e-13, -4.690079577771540e-15,  2.533757023233033e-03, -9.903622294976250e-04,
  2.052515881725350e-04, -2.888213270422944e-05,  3.077635396433069e-06, -2.640978038757268e-07,  1.898467496986838e-08, -1.175012583688302e-09,  6.389062457723271e-11,
 -3.099481479368044e-12,  1.357971421774118e-13, -5.419821085183090e-15,  2.141166639328819e-03, -8.579377088620605e-04,  1.826821377371726e-04, -2.641252157444956e-05,
  2.890609613031548e-06, -2.546167686622177e-07,  1.877641839357336e-08, -1.191438534835947e-09,  6.637726710880107e-11, -3.297330488587855e-12,  1.478424972217803e-13,
 -6.034699044177821e-15,  1.795804069590535e-03, -7.353893669832670e-04,  1.603743085439959e-04, -2.375037596017749e-05,  2.661500419920334e-06, -2.399360040720925e-07,
  1.809949661999268e-08, -1.174190363753388e-09,  6.684475545376921e-11, -3.391272629521816e-12,  1.552127966730159e-13, -6.463545349265027e-15,  1.489844531174808e-03,
 -6.217039048071245e-04,  1.384338571612746e-04, -2.093522014484879e-05,  2.395061114590744e-06, -2.203414985999858e-07,  1.695453541101216e-08, -1.121443855943004e-09,
  6.506185017499873e-11, -3.362361338263227e-12,  1.566887731294146e-13, -6.640488054866331e-15,  1.216374767095123e-03, -5.157901689384882e-04,  1.169142989410600e-04,
 -1.800127074520471e-05,  2.096286350701921e-06, -1.962439470293423e-07,  1.535998392719950e-08, -1.033046052232942e-09,  6.091678896069292e-11, -3.198570705782242e-12,
  1.513859567428372e-13, -6.513350333486700e-15,  9.692595859649319e-04, -4.165130275057008e-04,  9.582517846607468e-05, -1.497738769152740e-05,  1.770244503763487e-06,
 -1.681563758952194e-07,  1.335089252825078e-08, -9.105496346855977e-10,  5.443093807901584e-11, -2.896349188677660e-12,  1.388768647909122e-13, -6.051296627292546e-15,
  7.430127108521278e-04, -3.227170102782574e-04,  7.514010654150311e-05, -1.188738128157673e-05,  1.421961328852829e-06, -1.366727071563734e-07,  1.097711200541232e-08,
 -7.571480474067127e-10,  4.576262824889546e-11, -2.461461296657270e-12,  1.192722233518135e-13, -5.250548937216703e-15,  5.326745799376837e-04, -2.332421069958146e-04,
  5.480445006045872e-05, -8.750612778433707e-06,  1.056354843311955e-06, -1.024486274204249e-07,  8.301108833533532e-09, -5.775232802936690e-10,  3.520108333440612e-11,
 -1.909019459517876e-12,  9.324933948709599e-14, -4.137219451558077e-15,  3.337074724703574e-04, -1.469379408545736e-04,  3.474363347098503e-05, -5.582986552558956e-06,
  6.782366430518982e-07, -6.618735747194718e-08,  5.395711433446130e-09, -3.776321051680729e-10,  2.315177818929810e-11, -1.262727829891595e-12,  6.202388879920219e-14,
 -2.766765377062666e-15,  1.421017228866693e-04, -6.276382234891032e-05,  1.489246046994836e-05, -2.401565934658013e-06,  2.927738060158517e-07, -2.866974847977660e-08,
  2.345123840162507e-09, -1.646731405753693e-10,  1.012844993883152e-11, -5.541676260421062e-13,  2.730432592325877e-14, -1.221661152921189e-15,  7.378274154340982e-02,
 -2.286582171559791e-04,  7.426951947166458e-07, -2.500632192520995e-09,  8.628099774205846e-12, -3.021581470004068e-14,  1.066371545778290e-16, -3.774581580799086e-19,
  1.335956726988161e-21, -4.719613913571791e-24,  1.662522044013226e-26, -5.836572156700059e-29,  7.269674851135655e-02, -3.170387101441273e-04,  1.617970757723610e-06,
 -8.347182184701636e-09,  4.196100024357086e-11, -2.049156672780803e-13,  9.756462120808621e-16, -4.546644879821628e-18,  2.080298740284976e-20, -9.367703826700588e-23,
  4.159247638892480e-25, -1.823471442261911e-27,  7.057740046644730e-02, -4.855923558272531e-04,  3.616447181095728e-06, -2.493884389782511e-08,  1.609884481781265e-10,
 -9.884027585554603e-13,  5.831752760158801e-15, -3.329527408815921e-17,  1.848486607747354e-19, -1.001619585419475e-21,  5.312404546782862e-24, -2.764198452685247e-26,
  6.752540521591548e-02, -7.189199408512553e-04,  7.166748715806852e-06, -6.273375733191596e-08,  5.022422210847392e-10, -3.762818295370334e-12,  2.674722778543301e-14,
 -1.820646614079829e-16,  1.194643245040703e-18, -7.594162169929574e-21,  4.694901217607684e-23, -2.831361334892173e-25,  6.368099185006725e-02, -9.962957712261527e-04,
  1.276017004261527e-05, -1.385160285643232e-07,  1.347241811584182e-09, -1.207704623400823e-11,  1.015111315957550e-13, -8.093252434272021e-16,  6.171221302511635e-18,
 -4.528233199602398e-20,  3.212595506573782e-22, -2.211901199370294e-24,  5.921245584860498e-02, -1.294086034895032e-03,  2.081026501801430e-05, -2.754022986575597e-07,
  3.203017948611313e-09, -3.385410229712963e-11,  3.318953613319016e-13, -3.059577174805489e-15,  2.677977744538500e-17, -2.241665487723816e-19,  1.804527646753048e-21,
 -1.403031132045501e-23,  5.430317607076598e-02, -1.588351426674779e-03,  3.152296972861976e-05, -5.013029407832335e-07,  6.882402490073882e-09, -8.477038693149102e-11,
  9.588718171660254e-13, -1.011687815791112e-14,  1.006682419904602e-16, -9.524751201157432e-19,  8.623076868212355e-21, -7.506666264890152e-23,  4.913856420104125e-02,
 -1.857264147303421e-03,  4.480635224411694e-05, -8.455032434129215e-07,  1.355338344740495e-08, -1.926327267286571e-10,  2.491368137977981e-12, -2.983115161540795e-14,
  3.347639530265462e-16, -3.552911988983689e-18,  3.591159007174265e-20, -3.475712457090302e-22,  4.389427208775475e-02, -2.083033304811047e-03,  6.023847516200142e-05,
 -1.333684158526831e-06,  2.472260084230392e-08, -4.019981184429021e-10,  5.898058318457924e-12, -7.956273539649190e-14,  1.000020283789094e-15, -1.182761552409791e-17,
  1.326392703806122e-19, -1.418712282828165e-21,  3.872667477527066e-02, -2.253142621906647e-03,  7.709773781240661e-05, -1.982313849287311e-06,  4.212594165507383e-08,
 -7.776479756383959e-10,  1.285288423210844e-11, -1.940653205453609e-13,  2.715372298868922e-15, -3.558381368705461e-17,  4.403118774214491e-19, -5.177273461899268e-21,
  3.376623829969835e-02, -2.360833419842297e-03,  9.444631232732176e-05, -2.793685905887276e-06,  6.752007441738197e-08, -1.405128689567839e-09,  2.599536082465133e-11,
 -4.367479887877903e-13,  6.765507150611360e-15, -9.772290870921845e-17,  1.327654356494640e-18, -1.707981994606575e-20,  2.911395122909743e-02, -2.404886972304676e-03,
  1.112472142544808e-04, -3.752838199163454e-06,  1.023975256972398e-07, -2.386692408033751e-09,  4.913377215439044e-11, -9.135770658893206e-13,  1.558839999834318e-14,
 -2.469992384516308e-16,  3.667704877885232e-18, -5.140037597928269e-20,  2.484061819314881e-02, -2.388852305622044e-03,  1.264910516085177e-04, -4.827178980921943e-06,
  1.476750954143605e-07, -3.831758337435935e-09,  8.729654778414728e-11, -1.787283601715225e-12,  3.343390370779461e-14, -5.785621821124134e-16,  9.350384805622011e-18,
 -1.421766976443707e-19,  2.098853152487661e-02, -2.319916882301346e-03,  1.393097613082026e-04, -5.969014955293445e-06,  2.034211373290315e-07, -5.842351648442630e-09,
  1.465390463945762e-10, -3.287846677473449e-12,  6.712966403460678e-14, -1.263378096912429e-15,  2.213481921430998e-17, -3.638009710526211e-19,  1.757487604320017e-02,
 -2.207627265314515e-03,  1.490603937095931e-04, -7.120518859045665e-06,  2.686852782678180e-07, -8.495495349986129e-09,  2.334484522375261e-10, -5.714114869134906e-12,
  1.268040675848460e-13, -2.585172588721545e-15,  4.891796273036466e-17, -8.659530119732091e-19,  1.459617898760069e-02, -2.062642184125453e-03,  1.553701286955841e-04,
 -8.220175899068624e-06,  3.414744446440768e-07, -1.182573134840060e-08,  3.543555350511504e-10, -9.421634687870007e-12,  2.263328091899954e-13, -4.979677674119045e-15,
  1.014059639391323e-16, -1.926849794493843e-18,  1.203317032297517e-02, -1.895653697915990e-03,  1.581419674188610e-04, -9.209522349025956e-06,  4.188875110361320e-07,
 -1.581139599045646e-08,  5.143425825387868e-10, -1.479369926049542e-11,  3.832323034823595e-13, -9.066484517659975e-15,  1.980130154223048e-16, -4.025460566519669e-18,
  9.855536073701893e-03, -1.716556784616813e-03,  1.575271811626614e-04, -1.003905513305450e-05,  4.973868761795959e-07, -2.036777683192276e-08,  7.162074226208282e-10,
 -2.219614926921207e-11,  6.177540825293705e-13, -1.566020358013425e-14,  3.655998305108992e-16, -7.926718916086357e-18,  8.026195380578711e-03, -1.533895138645421e-03,
  1.538746414523215e-04, -1.067248592799332e-05,  5.731581802507274e-07, -2.534894864807576e-08,  9.595801745317814e-10, -3.192073666125441e-11,  9.510555256145094e-13,
 -2.574677604926884e-14,  6.404582240816349e-16, -1.476431979138040e-17,  6.504881732779769e-03, -1.354568974950000e-03,  1.476684493874688e-04, -1.108892763864464e-05,
  6.424955303774817e-07, -3.055830734353334e-08,  1.240378039859025e-09, -4.412565823072440e-11,  1.402518969893371e-12, -4.041412800584519e-14,  1.067835220667414e-15,
 -2.609556613131889e-17,  5.250939790149331e-03, -1.183762789380732e-03,  1.394643011574192e-04, -1.128301901376636e-05,  7.021507746198753e-07, -3.576608634345732e-08,
  1.550725104911950e-09, -5.878394706768623e-11,  1.986517220364531e-12, -6.073420684820712e-14,  1.699355015527776e-15, -4.389561898665701e-17,  4.225350079099599e-03,
 -1.025037322327460e-03,  1.298325823493600e-04, -1.126332453774276e-05,  7.495990440245142e-07, -4.073089165512374e-08,  1.879374436735143e-09, -7.565000915843686e-11,
  2.709114133514821e-12, -8.760448017188894e-14,  2.587986782047463e-15, -7.045863709887153e-17,  3.392061402341618e-03, -8.805280018978577e-04,  1.193131414901739e-04,
 -1.104954374695160e-05,  7.831937200894872e-07, -4.522178438142875e-08,  2.212573055830484e-09, -9.425169776316346e-11,  3.565283547495346e-12, -1.215684911313847e-13,
  3.780697558338446e-15, -1.081837518520656e-16,  2.718747693772333e-03, -7.511983356514896e-04,  1.083837676703667e-04, -1.066912155859924e-05,  8.022062309259564e-07,
 -4.903769562606103e-08,  2.535231209238157e-09, -1.139106678410476e-10,  4.537193482520506e-12, -1.626437341948380e-13,  5.309521370125746e-15, -1.592448493947325e-16,
  2.177118298416904e-03, -6.371074035066331e-04,  9.744204995224740e-05, -1.015379536755851e-05,  8.067647167841841e-07, -5.202180315272342e-08,  2.832213009695292e-09,
 -1.337885628203113e-10,  5.593938796001697e-12, -2.101881582378280e-13,  7.182313573390541e-15, -2.251712292299234e-16,  1.742905501472120e-03, -5.376626948212724e-04,
  8.679872793441902e-05, -9.536487727019058e-06,  7.977177369362974e-07, -5.406964630714945e-08,  3.089561919837277e-09, -1.529521370125400e-10,  6.692854724829816e-12,
 -2.628327567434933e-13,  9.374782974546304e-15, -3.063946634063941e-16,  1.395637469042311e-03, -4.518408537285576e-04,  7.667984420607790e-05, -8.848798913193874e-06,
  7.764540971308989e-07, -5.513090936967792e-08,  3.295506643043769e-09, -1.704476683301893e-10,  7.782268851682166e-12, -3.184976639078306e-13,  1.182539257545900e-14,
 -4.018391504679260e-16,  1.118284261621651e-03, -3.783682055377071e-04,  6.723483971699464e-05, -8.119206574261358e-06,  7.447085628456492e-07, -5.520573433000361e-08,
  3.441148049114121e-09, -1.853743781882188e-10,  8.805314824126522e-12, -3.744953410151757e-13,  1.443436945848939e-14, -5.086359812637664e-16,  8.968433350009132e-04,
 -3.158597662895262e-04,  5.854799575758243e-05, -7.371961990425501e-06,  7.043776618443483e-07, -5.433700805484089e-08,  3.520790434470770e-09, -1.969478882642735e-10,
  9.704285719291148e-12, -4.277101050672638e-13,  1.706743760318891e-14, -6.220354340716375e-16,  7.199115274315887e-04, -2.629198626513645e-04,  5.065112657490071e-05,
 -6.626593358491590e-06,  6.573621721871430e-07, -5.260028718361833e-08,  3.531937063186443e-09, -2.045474246335661e-10,  1.042496878055227e-11, -4.748315935417282e-13,
  1.956412777556238e-14, -7.355590146929917e-16,  5.782742678465741e-04, -2.182098952511616e-04,  4.353600601584421e-05, -5.897885099476066e-06,  6.054451263388491e-07,
 -5.009293672280367e-08,  3.475011484453603e-09, -2.077437579740052e-10,  1.092046838219665e-11, -5.126129696099728e-13,  2.174979541436707e-14, -8.413983996185174e-16,
  4.645300384355502e-04, -1.804896720913541e-04,  3.716556072681388e-05, -5.196191515978710e-06,  5.502075317847659e-07, -4.692376651512724e-08,  3.352888909785288e-09,
 -2.063080135378164e-10,  1.115416135395462e-11, -5.381235290887207e-13,  2.344993731907080e-14, -9.310273098076654e-16,  3.727588164525275e-04, -1.486386206648400e-04,
  3.148331991510145e-05, -4.527953769618062e-06,  4.929791667367763e-07, -4.320406165877321e-08,  3.170326963099286e-09, -2.002039647276997e-10,  1.110159931310435e-11,
 -5.489692734126472e-13,  2.450512933749127e-14, -9.959586772485367e-16,  2.982368249005521e-04, -1.216624815145237e-04,  2.642095423551122e-05, -3.896311868586820e-06,
  4.348188771323893e-07, -3.904050928889483e-08,  2.933376438813668e-09, -1.895679715840009e-10,  1.075133896341602e-11, -5.434623870930734e-13,  2.478492681061453e-14,
 -1.028557834054688e-15,  2.371958433548593e-04, -9.869011149936941e-05,  2.190396664332218e-05, -3.301730635692518e-06,  3.765175439433694e-07, -3.453018652349980e-08,
  2.648835619898893e-09, -1.746813189078349e-10,  1.010481540990719e-11, -5.207294234170848e-13,  2.419933056516014e-14, -1.022815908004283e-15,  1.866229791539351e-04,
 -7.896399813506860e-05,  1.785573321331923e-05, -2.742585252435129e-06,  3.186168971769792e-07, -2.975752407925107e-08,  2.323791315663077e-09, -1.559395043932696e-10,
  9.175460347281910e-12, -4.807565099942397e-13,  2.270683704985659e-14, -9.749955486218469e-16,  1.440956608234910e-04, -6.182713726453480e-05,  1.420015503437485e-05,
 -2.215674968143781e-06,  2.614381819196506e-07, -2.479300371198650e-08,  1.965270087607161e-09, -1.338222744498408e-10,  7.987304032767733e-12, -4.243766937780900e-13,
  2.031856363188764e-14, -8.840802758432890e-16,  1.076462856972915e-04, -4.670812507056790e-05,  1.086319752357641e-05, -1.716651904469357e-06,  2.051159657592517e-07,
 -1.969327731852082e-08,  1.580006868098990e-09, -1.088671808260445e-10,  6.573294935589035e-12, -3.532090084109294e-13,  1.709838570764177e-14, -7.519845888633895e-16,
  7.565120919380345e-05, -3.310572379080739e-05,  7.773590263485872e-06, -1.240367131530172e-06,  1.496340108315917e-07, -1.450241092996410e-08,  1.174328004553555e-09,
 -8.164846596225940e-11,  4.973542608932638e-12, -2.695612578494887e-13,  1.315940125321241e-14, -5.835105753088092e-16,  4.674035338164094e-05, -2.057420434073314e-05,
  4.863056490787441e-06, -7.811655739267025e-07,  9.486394126147439e-08, -9.254234334147476e-09,  7.541579177072356e-10, -5.276347595369598e-11,  3.233721349163287e-12,
 -1.763131046141237e-13,  8.657515018690739e-15, -3.860727969329308e-16,  1.974970935079327e-05, -8.721695998880591e-06,  2.069085529785397e-06, -3.335992921902063e-07,
  4.066131843326865e-08, -3.981001924565959e-09,  3.255775450122340e-10, -2.285770350217503e-11,  1.405643004770747e-12, -7.689471706629412e-14,  3.788010704373523e-15,
 -1.694557038633301e-16,  7.287980500360924e-02, -2.228343841424507e-04,  7.134964043688378e-07, -2.367281580092272e-09,  8.048544638678717e-12, -2.777867063757444e-14,
  9.664217899858075e-17, -3.373025495675152e-19,  1.177427192942089e-21, -4.103209849653789e-24,  1.426025546883546e-26, -4.939883401212381e-29,  7.145386252958714e-02,
 -3.044844988508087e-04,  1.521701589225483e-06, -7.707362414417889e-09,  3.808690614739188e-11, -1.829556123058848e-13,  8.571749289731345e-16, -3.931846820667638e-18,
  1.771171571695847e-20, -7.853906123605881e-23,  3.434499671806887e-25, -1.483251094925469e-27,  6.869105874507871e-02, -4.578155085195285e-04,  3.332007394819037e-06,
 -2.251387392098654e-08,  1.425478182114573e-10, -8.589914000309387e-13,  4.977155701248152e-15, -2.791830273059673e-17,  1.523394244409964e-19, -8.115763986679132e-22,
  4.233218992239639e-24, -2.166756334978986e-26,  6.475981126204843e-02, -6.644660627742097e-04,  6.459783845675643e-06, -5.526671298615777e-08,  4.330135660475949e-10,
 -3.177978957022222e-12,  2.214596740505665e-14, -1.478708949433931e-16,  9.522565647673198e-19, -5.943456028629352e-21,  3.609019777550860e-23, -2.138471010365504e-25,
  5.988993844468031e-02, -9.005142642773730e-04,  1.121975072014514e-05, -1.187674382177615e-07,  1.128337253136286e-09, -9.891819315089501e-12,  8.138630204251924e-14,
 -6.356271949499752e-16,  4.750690903794310e-18, -3.418578535078437e-20,  2.379572673370555e-22, -1.608078948902645e-24,  5.434931086360417e-02, -1.140000788471970e-03,
  1.779190978491759e-05, -2.291653521171353e-07,  2.599122208555881e-09, -2.682678282323059e-11,  2.571040939537179e-13, -2.318936961629845e-15,  1.987287156701969e-17,
 -1.629714337147315e-19,  1.285931388860136e-21, -9.804735884379539e-24,  4.841852149906996e-02, -1.358479376859267e-03,  2.611589866202011e-05, -4.035875412014232e-07,
  5.395933928200794e-09, -6.482217177478964e-11,  7.159834629066461e-13, -7.383513833210433e-15,  7.186635680702220e-17, -6.655730233656902e-19,  5.901571445075761e-21,
 -5.034331459200351e-23,  4.236699443268901e-02, -1.535983986074534e-03,  3.584409741499414e-05, -6.564852364178982e-07,  1.023678861894885e-08, -1.417616173160793e-10,
  1.788657647811754e-12, -2.091532961560613e-14,  2.294092455630289e-16, -2.381513816792592e-18,  2.356014767162614e-20, -2.233108421980583e-22,  3.643334100371522e-02,
 -1.658982377180732e-03,  4.636530629245016e-05, -9.954482575509461e-07,  1.793486723580491e-08, -2.839213601369154e-10,  4.060949054597918e-12, -5.346163558005547e-14,
  6.563730781113443e-16, -7.589074863328813e-18,  8.325521068355671e-20, -8.716610828824188e-22,  3.081175697361077e-02, -1.721135167419415e-03,  5.689045133117638e-05,
 -1.417647195789233e-06,  2.926366574478199e-08, -5.256382362755149e-10,  8.464838952892163e-12, -1.246712885543839e-13,  1.703179198829845e-15, -2.180983236178026e-17,
  2.639018748154870e-19, -3.036314235400181e-21,  2.564509154278694e-02, -1.722928936619728e-03,  6.657604281162158e-05, -1.908043359543497e-06,  4.477970853329530e-08,
 -9.064408769168878e-10,  1.633384312613528e-11, -2.676008253059029e-13,  4.046162305893229e-15, -5.709435545531778e-17,  7.583333132753474e-19, -9.543976498578843e-21,
  2.102415699722131e-02, -1.670444273904345e-03,  7.465410859494323e-05, -2.440057354364558e-06,  6.464360323398195e-08, -1.465379736019497e-09,  2.937928604332442e-11,
 -5.326107847039309e-13,  8.869451974390267e-15, -1.372760765607527e-16,  1.992640909700326e-18, -2.731724044668139e-20,  1.699206681097785e-02, -1.573621979357329e-03,
  8.053974736068240e-05, -2.978687289144312e-06,  8.848919439935076e-08, -2.233209897562873e-09,  4.955125476879735e-11, -9.891642006353369e-13,  1.805947821531404e-14,
 -3.052715558535054e-16,  4.823012246201569e-18, -7.174220843595011e-20,  1.355197419045626e-02, -1.444399217705966e-03,  8.389696526951643e-05, -3.485383043979725e-06,
  1.153828110872119e-07, -3.224001370677676e-09,  7.877396364973257e-11, -1.723626984050737e-12,  3.435331451845202e-14, -6.316583215881282e-16,  1.082064752305940e-17,
 -1.740105357763686e-19,  1.067652191182035e-02, -1.295022027938080e-03,  8.465607527811963e-05, -3.923547876018847e-06,  1.438920103892330e-07, -4.428286047121844e-09,
  1.185845410776332e-10, -2.831662644695314e-12,  6.136083481270581e-14, -1.222584603617605e-15,  2.262656655849628e-17, -3.920213632341239e-19,  8.317528517120084e-03,
 -1.136733673482364e-03,  8.298761882295064e-05, -4.263467703610590e-06,  1.722537858244011e-07, -5.809730898619981e-09,  1.697436408905788e-10, -4.405074050155539e-12,
  1.033816977189738e-13, -2.223937541154443e-15,  4.431314639060929e-17, -8.244499810474266e-19,  6.414813117029997e-03, -9.789233373970940e-04,  7.924570351768033e-05,
 -4.485733835133561e-06,  1.986062797604733e-07, -7.306541622577906e-09,  2.319098760751204e-10, -6.514680874427642e-12,  1.649712118194438e-13, -3.818195273515431e-15,
  8.163923433355435e-17, -1.625920595175394e-18,  4.903489678867423e-03, -8.287223953268191e-04,  7.389677964325211e-05, -4.582693174127891e-06,  2.212338782081258e-07,
 -8.837605030017757e-09,  3.034665875472082e-10, -9.192448740134059e-12,  2.502718860430760e-13, -6.211053971336099e-15,  1.420516227918874e-16, -3.019182656468345e-18,
  3.719454624252275e-03, -6.909699660746220e-04,  6.744872334412918e-05, -4.557960521659631e-06,  2.387763924333650e-07, -1.031217949694806e-08,  3.815577507765358e-10,
 -1.241695898183700e-11,  3.622032735952606e-13, -9.606946574041816e-15,  2.342914116418563e-16, -5.298517655694431e-18,  2.803096437641390e-03, -5.684382818398026e-04,
  6.039114220339536e-05, -4.424418489036304e-06,  2.503665865569749e-07, -1.164112590155183e-08,  4.623396562571371e-10, -1.610600952879358e-11,  5.016654796111623e-13,
 -1.417558856799280e-14,  3.675244265543289e-16, -8.818251173832510e-18,  2.101454124411741e-03, -4.622060692964251e-04,  5.315280808101646e-05, -4.201336492175183e-06,
  2.556806567672340e-07, -1.274745318462856e-08,  5.414028275675929e-10, -2.011867805199505e-11,  6.669364406590191e-13, -2.001480509534100e-14,  5.500259026521758e-16,
 -1.396197884924850e-17,  1.569149608010714e-03, -3.720849762576190e-04,  4.607749119950653e-05, -3.911257737324404e-06,  2.549065817112843e-07, -1.357432419272435e-08,
  6.142807285345072e-10, -2.426700021211273e-11,  8.534170157904416e-13, -2.711700661150471e-14,  7.875835956578484e-16, -2.109205016917780e-17,  1.168439153298085e-03,
 -2.970301065865744e-04,  3.941608133701796e-05, -3.577180066800286e-06,  2.486502719887348e-07, -1.408943557854668e-08,  6.769481554395051e-10, -2.833520608559114e-11,
  1.053806437281610e-12, -3.534692301718736e-14,  1.081897507516935e-15, -3.048420188161828e-17,  8.686972790630737e-04, -2.354928882597659e-04,  3.333100915875325e-05,
 -3.220362742807293e-06,  2.378066837658119e-07, -1.428557409300009e-08,  7.262237897394347e-10, -3.210287351360438e-11,  1.258695249818664e-12, -4.443633532124770e-14,
  1.429306563462076e-15, -4.225744436222434e-17,  6.455880631633440e-04, -1.856976693690225e-04,  2.790845678122893e-05, -2.858891642065400e-06,  2.234228295233737e-07,
 -1.417790933564958e-08,  7.600213133584198e-10, -3.536779041799743e-11,  1.457472368484695e-12, -5.399805161722055e-14,  1.820139229975143e-15, -5.631260465896136e-17,
  4.801122878571990e-04, -1.458403037344006e-04,  2.317427504448804e-05, -2.506974326416899e-06,  2.065740716614073e-07, -1.379905528453358e-08,  7.774307967478342e-10,
 -3.796479757484769e-11,  1.639382513188134e-12, -6.355729131356721e-14,  2.238871136953836e-15, -7.229301877570264e-17,  3.576568954632170e-04, -1.142173567852474e-04,
  1.911046302269718e-05, -2.174833855551828e-06,  1.882670366984658e-07, -1.319308152098040e-08,  7.786460681698175e-10, -3.977812572510391e-11,  1.794553302559230e-12,
 -7.259513639671597e-14,  2.665110011447415e-15, -8.957745630625857e-17,  2.671221536218037e-04, -8.929948794209112e-05,  1.567014371444361e-05, -1.869025502836516e-06,
  1.693744352261820e-07, -1.240953517577446e-08,  7.647772019470763e-10, -4.074630248394312e-11,  1.914836422556773e-12, -8.059667224053090e-14,  3.075262876145182e-15,
 -1.073093079761237e-16,  2.001637727240720e-04, -6.976359870166274e-05,  1.278994335265057e-05, -1.593000900144618e-06,  1.506006578110962e-07, -1.149825050003216e-08,
  7.375974758078324e-10, -4.086015148692838e-11,  1.994361654938827e-12, -8.709622973972995e-14,  3.444616357857156e-15, -1.244590411317128e-16,  1.505612138231851e-04,
 -5.449700598813171e-05,  1.039942839185034e-05, -1.347772364941782e-06,  1.324729304772799e-07, -1.050538415762197e-08,  6.992725050525933e-10, -4.015543838089365e-11,
  2.029767977651329e-12, -9.171355018135097e-14,  3.749505514615013e-15, -1.399108013277570e-16,  1.137074296238697e-04, -4.258444304671217e-05,  8.427746537017587e-06,
 -1.132570352686088e-06,  1.153509901426840e-07, -9.470805946692112e-09,  6.521095311692908e-10, -3.870221661015267e-11,  2.020135438633496e-12, -9.417712441876337e-14,
  3.969264620238694e-15, -1.525602592537758e-16,  8.620674507276264e-05, -3.328595889593578e-05,  6.807886505847072e-06, -9.454274569749925e-07,  9.944817193112215e-08,
 -8.426745294261229e-09,  5.983514415766098e-10, -3.659293172408487e-11,  1.966683675901035e-12, -9.433367131414445e-14,  4.087729466847064e-15, -1.614100050402782e-16,
  6.556413328026334e-05, -2.601128389700317e-05,  5.479071419829727e-06, -7.836563411858603e-07,  8.485782863633489e-08, -7.397457861334614e-09,  5.400267769859497e-10,
 -3.393099733616070e-11,  1.872323536219248e-12, -9.214507868784166e-14,  4.094167810147641e-15, -1.656507362030570e-16,  4.994884656184327e-05, -2.029418526843727e-05,
  4.387791770945953e-06, -6.442137309539395e-07,  7.158052515490551e-08, -6.399624054723039e-09,  4.788561763385864e-10, -3.082103236007214e-11,  1.741149062802935e-12,
 -8.767573681647770e-14,  3.983623715608493e-15, -1.647202864798092e-16,  3.801679976585383e-05, -1.576880614870721e-05,  3.487915591130046e-06, -5.239582263411767e-07,
  5.954902287168129e-08, -5.443199927488497e-09,  4.162084653010713e-10, -2.736140111650785e-11,  1.577943749360860e-12, -8.107392800845590e-14,  3.756750143817760e-15,
 -1.583370463115532e-16,  2.877831326094748e-05, -1.214891894708911e-05,  2.740221847410412e-06, -4.198178084309208e-07,  4.864942568580567e-08, -4.532486084939100e-09,
  3.530958808252758e-10, -2.363923075604519e-11,  1.387754149443283e-12, -7.255089579777179e-14,  3.419259770358246e-15, -1.465084701203015e-16,  2.150021166263361e-05,
 -9.210338699249775e-06,  2.111610960586537e-06, -3.288856361374764e-07,  3.873788803382581e-08, -3.667240679457082e-09,  2.901970684285546e-10, -1.972774644380685e-11,
  1.175561691066740e-12, -6.236063211718963e-14,  2.981144721508108e-15, -1.295184244147691e-16,  1.563351256656615e-05, -6.776337845508232e-06,  1.574165948410614e-06,
 -2.484620963924058e-07,  2.965298176753561e-08, -2.843723822965505e-09,  2.278975996366969e-10, -1.568557387226614e-11,  9.460641762295051e-13, -5.078255801827010e-14,
  2.455807495111134e-15, -1.078988077676321e-16,  1.075988414305348e-05, -4.705698387370228e-06,  1.104175040347831e-06, -1.760589155586113e-07,  2.122426102509012e-08,
 -2.055616850133814e-09,  1.663401669314017e-10, -1.155760534568637e-11,  7.035650049567391e-13, -3.810840910244821e-14,  1.859219818678929e-15, -8.239133867977399e-17,
  6.551787028711966e-06, -2.883020644734115e-06,  6.811961006884225e-07, -1.093808957119267e-07,  1.327810669644160e-08, -1.294834845785906e-09,  1.054818742341311e-10,
 -7.377233844349724e-12,  4.519707919550004e-13, -2.463445792863847e-14,  1.209219937917502e-15, -5.390614077169814e-17,  2.745974693650131e-06, -1.212452350684710e-06,
  2.875808954117520e-07, -4.635778949678466e-08,  5.649306044951764e-09, -5.529969794651016e-10,  4.521707672508553e-11, -3.173944717410222e-12,  1.951468907955566e-13,
 -1.067343165946729e-14,  5.257035065205734e-16, -2.351306990057733e-17,  7.199970653209423e-02, -2.172378946396667e-04,  6.858437513937291e-07, -2.242826568005721e-09,
  7.515421785274006e-12, -2.556846707743263e-14,  8.770374937153313e-17, -3.018823507264962e-19,  1.039476353371938e-21, -3.573966494474152e-24,  1.225649238297182e-26,
 -4.190096001275579e-29,  7.025970026772356e-02, -2.926707509062379e-04,  1.432752353672807e-06, -7.126163369400902e-09,  3.462491870125495e-11, -1.636429897714890e-13,
  7.546112028217291e-16, -3.407781480057094e-18,  1.511664451704134e-20, -6.602159567251232e-23,  2.844106119156696e-25, -1.210174787676834e-27,  6.691145084339699e-02,
 -4.322026070835413e-04,  3.074978884411797e-06, -2.036431344883745e-08,  1.265019253401057e-10, -7.483952259647677e-13,  4.259521666993836e-15, -2.348000527630696e-17,
  1.259541463716123e-19, -6.598698868587365e-22,  3.385695936677530e-24, -1.705066624964891e-26,  6.220126341894466e-02, -6.153274641954245e-04,  5.836144968015405e-06,
 -4.881944243954262e-08,  3.744506395748668e-10, -2.692905179319524e-12,  1.840191203847863e-14, -1.205609071204835e-16,  7.621597314751157e-19, -4.671753236813894e-21,
  2.786990382361967e-23, -1.622905955006202e-25,  5.645878536544915e-02, -8.161645627141660e-04,  9.896661192355859e-06, -1.021963615745094e-07,  9.486761608454761e-10,
 -8.136015052031316e-12,  6.554437405235509e-14, -5.015890119149923e-16,  3.675553110310353e-18, -2.594489442035094e-20,  1.772297132287544e-22, -1.175831022582759e-24,
  5.005750861772610e-02, -1.007997188959922e-03,  1.527476426984271e-05, -1.915572678233798e-07,  2.119381793890199e-09, -2.136867305615303e-11,  2.002610792468880e-13,
 -1.767735529831679e-15,  1.483645645160276e-17, -1.192279105072062e-19,  9.223655571273058e-22, -6.898212908893258e-24,  4.337373508906452e-02, -1.167549490325711e-03,
  2.175091811232625e-05, -3.267563874637524e-07,  4.255835407823927e-09, -4.988017246473781e-11,  5.381404703407834e-13, -5.425606125901603e-15,  5.167015123703544e-17,
 -4.685174705289155e-19,  4.069709263133167e-21, -3.402708539891551e-23,  3.675033595707432e-02, -1.278159347015824e-03,  2.886248869361625e-05, -5.132312114551240e-07,
  7.787371412593934e-09, -1.051050025473707e-10,  1.294108351601000e-12, -1.478172612509446e-14,  1.585093443729950e-16, -1.609883130036742e-18,  1.559158207217758e-20,
 -1.447559673104974e-22,  3.046996079025024e-02, -1.331362679386374e-03,  3.597014533021736e-05, -7.490915968016567e-07,  1.312108995108798e-08, -2.022794409903185e-10,
  2.821187950447333e-12, -3.625449232126526e-14,  4.348863993369501e-16, -4.916488382607138e-18,  5.277307338732204e-20, -5.409357452655843e-22,  2.473998985927890e-02,
 -1.326831633762783e-03,  4.237383599432527e-05, -1.023577204217696e-06,  2.052870415717884e-08, -3.588715875724906e-10,  5.632171931223502e-12, -8.093026137714358e-14,
  1.079692647360766e-15, -1.351263193724027e-17,  1.599143859838960e-19, -1.800639808899492e-21,  1.968912016008413e-02, -1.270977661916321e-03,  4.744274130096179e-05,
 -1.317605981965915e-06,  3.003235173260220e-08, -5.914201649235194e-10,  1.038212290664725e-11, -1.658894565439681e-13,  2.448655848202223e-15, -3.375943699958117e-17,
  4.384309434857391e-19, -5.398822341608910e-21,  1.537357321400365e-02, -1.174752591628168e-03,  5.072357094694999e-05, -1.606456822021872e-06,  4.132728128252855e-08,
 -9.112316388800622e-10,  1.779416300581783e-11, -3.145570871555051e-13,  5.112870939987685e-15, -7.730597167500813e-17,  1.097050634291338e-18, -1.471336508081658e-20,
  1.178981611509279e-02, -1.051229005386560e-03,  5.200268708620204e-05, -1.863918983027268e-06,  5.377267556102280e-08, -1.319997737598874e-09,  2.852666393811224e-11,
 -5.552768108819505e-13,  9.895025641649007e-15, -1.633965595077420e-16,  2.523789035227864e-18, -3.672745927352572e-20,  8.890436902691574e-03, -9.134441073979070e-04,
  5.131403075548066e-05, -2.066793528732294e-06,  6.646197328710163e-08, -1.806701657492869e-09,  4.300283407569145e-11, -9.176224285019746e-13,  1.785324278213618e-14,
 -3.207237799385026e-16,  5.372003388019046e-18, -8.452750979717563e-20,  6.600241337978135e-03, -7.728107049968417e-04,  4.890029412262268e-05, -2.198598296298541e-06,
  7.835882130037296e-08, -2.346983385130423e-09,  6.124462869042093e-11, -1.426647077838026e-12,  3.018659746759451e-14, -5.877831788029476e-16,  1.063904921034516e-17,
 -1.804032441547961e-19,  4.830461620455213e-03, -6.382027106474616e-04,  4.514470100772481e-05, -2.251668957003983e-06,  8.846448290793740e-08, -2.905462252515290e-09,
  8.276154932265863e-11, -2.096120026853059e-12,  4.805459570478463e-14, -1.010650605981486e-15,  1.970256597260991e-17, -3.588947831311399e-19,  3.489903233392567e-03,
 -5.156625917312404e-04,  4.049359595414684e-05, -2.227386880924306e-06,  9.597467954800390e-08, -3.440621057885342e-09,  1.065353526158921e-10, -2.922459112096065e-12,
  7.233183110123337e-14, -1.637543300988103e-15,  3.427384077278011e-17, -6.686319663736443e-19,  2.492685148951780e-03, -4.085804922880366e-04,  3.538693396888893e-05,
 -2.134784310616562e-06,  1.003901291898345e-07, -3.911091723286754e-09,  1.311160710065420e-10, -3.881200607949913e-12,  1.033485069738449e-13, -2.510430219954392e-15,
  5.623730881235688e-17, -1.171519730083046e-18,  1.762829530134606e-03, -3.181607308038716e-04,  3.020732515342164e-05, -1.988118439552618e-06,  1.015614051823981e-07,
 -4.281826974508343e-09,  1.548124772017105e-10, -4.927326489368585e-12,  1.406846164341669e-13, -3.655066517379162e-15,  8.737227991052695e-17, -1.938006316869003e-18,
  1.236299970089879e-03, -2.440060708108481e-04,  2.525128911889349e-05, -1.804108918673895e-06,  9.966807645025712e-08, -4.528786177021104e-09,  1.759333903473317e-10,
 -5.999744820540348e-12,  1.830810187329363e-13, -5.071710897291180e-15,  1.289914473424479e-16, -3.037964041779393e-18,  8.612068059685835e-04, -1.846922867319460e-04,
  2.072080822978714e-05, -1.599432392425196e-06,  9.514771172649971e-08, -4.641294500156381e-09,  1.930243168674968e-10, -7.029064143885402e-12,  2.285038241786714e-13,
 -6.729032723361881e-15,  1.815673248734372e-16, -4.527991070866858e-18,  5.968602675589909e-04, -1.382555418476160e-04,  1.673002458370314e-05, -1.388850518424501e-06,
  8.859838016999886e-08, -4.621919193660498e-09,  2.050495250718505e-10, -7.946933514838492e-12,  2.743582288805752e-13, -8.563146116066233e-15,  2.444371472281171e-16,
 -6.437311083748536e-18,  4.122274314755758e-04, -1.025594372280420e-04,  1.332093670334958e-05, -1.184108940962300e-06,  8.067837455569961e-08, -4.484304672944755e-09,
  2.114886569667730e-10, -8.694913846459265e-12,  3.178085002151604e-13, -1.048246962997663e-14,  3.156688733460705e-16, -8.755377707632923e-18,  2.841946281358890e-04,
 -7.554066474629762e-05,  1.048258995779842e-05, -9.935524303434360e-07,  7.202122699534396e-08, -4.249763234884300e-09,  2.123412781840706e-10, -9.231143578563100e-12,
  3.561355178853475e-13, -1.237762244147284e-14,  3.921360999779010e-16, -1.142435701891117e-17,  1.958912183163475e-04, -5.535093126502335e-05,  8.169733652117225e-06,
 -8.222868522802965e-07,  6.317592162765965e-08, -3.943491947232550e-09,  2.080541309879940e-10, -9.533784877071863e-12,  3.870590906842122e-13, -1.413433498784386e-14,
  4.697989361195659e-16, -1.433874871204686e-17,  1.352131043088171e-04, -4.042047666968996e-05,  6.318572823470477e-06, -6.726803422002984e-07,  5.457442108354544e-08,
 -3.591136593031286e-09,  1.993989197579334e-10, -9.601097601319697e-12,  4.089679107334258e-13, -1.564674967114025e-14,  5.441380787590998e-16, -1.735277467348674e-17,
  9.360059610750126e-05, -2.946863429887255e-05,  4.858652459960373e-06, -5.450134902904117e-07,  4.652298334808882e-08, -3.216155935783437e-09,  1.873318006528454e-10,
 -9.448716222812510e-12,  4.210277942749627e-13, -1.682863216827897e-14,  6.106560573190945e-16, -2.029433900888073e-17,  6.507245030498932e-05, -2.148290961012135e-05,
  3.720896254711278e-06, -4.381354657333921e-07,  3.921079984518030e-08, -2.838157852895443e-09,  1.728612063406488e-10, -9.105134915541426e-12,  4.231687421950471e-13,
 -1.762075917937861e-14,  6.653513235086476e-16, -2.298291701244644e-17,  4.548930725167871e-05, -1.568259636977572e-05,  2.842376529443136e-06, -3.500376229466865e-07,
  3.272888262446174e-08, -2.472154566682408e-09,  1.569417033790775e-10, -8.606504755573146e-12,  4.159749044237905e-13, -1.799378463944066e-14,  7.050867469461086e-16,
 -2.524805746021440e-17,  3.200791752199194e-05, -1.147764628057576e-05,  2.168606151729045e-06, -2.783039193242068e-07,  2.709308233062130e-08, -2.128547787357993e-09,
  1.404017806466242e-10, -7.991683737394943e-12,  4.005142857832479e-13, -1.794688167874247e-14,  7.278059576975825e-16, -2.694538220557040e-17,  2.268600476883554e-05,
 -8.429162105706329e-06,  1.654134976255975e-06, -2.204320006130153e-07,  2.226680086024051e-08, -1.813603082774622e-09,  1.239053238860684e-10, -7.298173292374305e-12,
  3.781467661497931e-13, -1.750317098511168e-14,  7.325875568601534e-16, -2.796785648053385e-17,  1.620151713189124e-05, -6.214725510459036e-06,  1.262108465489903e-06,
 -1.740394235311708e-07,  1.818073292059981e-08, -1.530184134070346e-09,  1.079412309559864e-10, -6.559240097412018e-12,  3.503425126072654e-13, -1.670327793609407e-14,
  7.195584274250525e-16, -2.825133283994021e-17,  1.165615310926281e-05, -4.599703238709270e-06,  9.632815700166040e-07, -1.369787241593149e-07,  1.474845031462378e-08,
 -1.278564298631759e-09,  9.283321953288952e-11, -5.802241302969906e-12,  3.185321394682340e-13, -1.559834048147672e-14,  6.897071507645042e-16, -2.777457245371668e-17,
  8.439506064224119e-06, -3.414465124119647e-06,  7.348229840654749e-07, -1.073865212593761e-07,  1.187768437449407e-08, -1.057191447068063e-09,  7.876174204619260e-11,
 -5.047983939099274e-12,  2.839987116763892e-13, -1.424352675719618e-14,  6.446454448524130e-16, -2.655484752681275e-17,  6.135984614267970e-06, -2.536839087893786e-06,
  5.591154567177561e-07, -8.368894320995086e-08,  9.477774877231468e-09, -8.633365038524032e-10,  6.579117913922979e-11, -4.310858041669602e-12,  2.478123951216727e-13,
 -1.269274833893150e-14,  5.863617854210495e-16, -2.464070482394613e-17,  4.461457029060149e-06, -1.878901901968628e-06,  4.226627429307797e-07, -6.458093298168319e-08,
  7.464027014496130e-09, -6.935985313873597e-10,  5.389733337419208e-11, -3.599468719296579e-12,  2.108023707193652e-13, -1.099488447711600e-14,  5.170009906097036e-16,
 -2.210353785169822e-17,  3.220293811056091e-06, -1.377195602040287e-06,  3.151500213893620e-07, -4.899203723432849e-08,  5.759762617690206e-09, -5.442675893341239e-10,
  4.299211571149209e-11, -2.917527523904868e-12,  1.735575812574289e-13, -9.191536303251239e-15,  4.386907457662124e-16, -1.902937982899512e-17,  2.276262584500943e-06,
 -9.855571172973189e-07,  2.286655897824083e-07, -3.604697488792056e-08,  4.296767694448681e-09, -4.115626388862939e-10,  3.294388982803779e-11, -2.264822571556874e-12,
  1.364473595546971e-13, -7.316137798840714e-15,  3.534241107992667e-16, -1.551193120995995e-17,  1.532740411923819e-06, -6.698855251513924e-07,  1.570704121758111e-07,
 -2.502595111129835e-08,  3.014702958355423e-09, -2.917689582993897e-10,  2.359312537145615e-11, -1.638152800750816e-12,  9.965425249349009e-14, -5.394165788137168e-15,
  2.629982019750201e-16, -1.164741459425825e-17,  9.191458154172595e-07, -4.043177650692214e-07,  9.549444249213498e-08, -1.532765266980004e-08,  1.859943455723324e-09,
 -1.813050188258560e-10,  1.476413772557012e-11, -1.032194971934328e-12,  6.321493549283145e-14, -3.444265950792297e-15,  1.690076920912837e-16, -7.531655937694014e-18,
  3.819552596057856e-07, -1.686188640194875e-07,  3.998680099302557e-08, -6.444550359055803e-09,  7.851964758537531e-10, -7.684578611352582e-11,  6.282244493957656e-12,
 -4.408875954323238e-13,  2.710238412648062e-14, -1.482069128519218e-15,  7.298354931560710e-17, -3.263732698323127e-18,  7.114156083434035e-02, -2.118567942440981e-04,
  6.596348006483827e-07, -2.126559216270341e-09,  7.024435607689258e-12, -2.356136640451325e-14,  7.969804093922312e-17, -2.705865810543170e-19,  9.192116361023319e-22,
 -3.118649596762121e-24,  1.055509729783147e-26, -3.561691054761326e-29,  6.911141268923099e-02, -2.815416124421450e-04,  1.350457482204101e-06, -6.597395021561472e-09,
  3.152571020442049e-11, -1.466247938389509e-13,  6.656233404475802e-16, -2.959981648236087e-18,  1.293243705785301e-20, -5.564195247648424e-23,  2.361717679022748e-25,
 -9.902925630358485e-28,  6.523033951048959e-02, -4.085469570816030e-04,  2.842274767596817e-06, -1.845468707108310e-08,  1.125053173453764e-10, -6.536215880307336e-13,
  3.655115948141672e-15, -1.980481915356074e-17,  1.044660478496705e-19, -5.383263340106902e-22,  2.717544918761323e-24, -1.346836605966399e-26,  5.982976018615872e-02,
 -5.708837299328111e-04,  5.284556311532240e-06, -4.323620101580299e-08,  3.247491734766031e-10, -2.289159826445956e-12,  1.534382741095250e-14, -9.866079316442467e-17,
  6.124342355023177e-19, -3.687612721966906e-21,  2.161751993095764e-23, -1.237382632769922e-25,  5.334505542895838e-02, -7.416504928390149e-04,  8.756272359504249e-06,
 -8.823838214751919e-08,  8.006141025677934e-10, -6.719009689097030e-12,  5.301531441097390e-14, -3.976424780493386e-16,  2.857589216569868e-18, -1.979140790975911e-20,
  1.327075679905551e-22, -8.645766941774445e-25,  4.625613079741905e-02, -8.944482153792202e-04,  1.316623652191489e-05, -1.608209184077014e-07,  1.736323083544645e-09,
 -1.710644303921429e-11,  1.568134807571427e-13, -1.355077461171890e-15,  1.114118969299052e-17, -8.775754101096977e-20,  6.657821760198751e-22, -4.885182197173681e-24,
  3.902825805888178e-02, -1.008140366975239e-03,  1.820762040016153e-05, -2.659905927843540e-07,  3.375983743596960e-09, -3.861549550963740e-11,  4.070442204332653e-13,
 -4.013320713049379e-15,  3.740550319792505e-17, -3.321570989356281e-19,  2.827145147591974e-21, -2.317361408847319e-23,  3.206328554230829e-02, -1.069925825532357e-03,
  2.338703772949096e-05, -4.038936078968895e-07,  5.965082123641217e-09, -7.848942950573429e-11,  9.433105526272588e-13, -1.052779677001458e-14,  1.103967660287394e-16,
 -1.097219892645843e-18,  1.040534278684290e-20, -9.464743661902371e-23,  2.566776271431119e-02, -1.076274146059821e-03,  2.811820382697465e-05, -5.681588498863098e-07,
  9.677843777348450e-09, -1.453299416431911e-10,  1.976938776872678e-12, -2.480503118244675e-14,  2.907741988844208e-16, -3.214904934602958e-18,  3.377131307956157e-20,
 -3.389704896610337e-22,  2.004007243654660e-02, -1.031890171696046e-03,  3.184665237746427e-05, -7.458986066841358e-07,  1.453786295240309e-08, -2.473967624163052e-10,
  3.784675093498689e-12, -5.306882279771755e-14,  6.915257368983893e-16, -8.460117123296502e-18,  9.793952917641744e-20, -1.079456925213184e-21,  1.527460448915271e-02,
 -9.473302604582151e-04,  3.416413127454735e-05, -9.196105387240886e-07,  2.036082210517258e-08, -3.901462860609234e-10,  6.673191586614488e-12, -1.040092627781357e-13,
  1.499005896338840e-15, -2.019549413046731e-17,  2.564853449196311e-19, -3.090643322044141e-21,  1.137826608746206e-02, -8.360808732049178e-04,  3.487980989654797e-05,
 -1.070505945651288e-06,  2.674547891625980e-08, -5.736721399615260e-10,  1.091250852007355e-11, -1.881278035586846e-13,  2.985028065839036e-15, -4.409569966756442e-17,
  6.118381014866560e-19, -8.028680176665681e-21,  8.293563963828221e-03, -7.118380234268467e-04,  3.403410085066553e-05, -1.182262886396977e-06,  3.312391213269441e-08,
 -7.909600777559654e-10,  1.665008902900703e-11, -3.160472866381502e-13,  5.497456518266157e-15, -8.868771075718352e-17,  1.339310305876501e-18, -1.906901886442238e-20,
  5.922920575517524e-03, -5.864812476012763e-04,  3.186073420428631e-05, -1.244096209588586e-06,  3.886069384943715e-08, -1.027745605295466e-09,  2.383013534824736e-11,
 -4.959172127046691e-13,  9.418904849109240e-15, -1.653200669460184e-16,  2.707541514441213e-18, -4.168559219092334e-20,  4.150276140717258e-03, -4.689362636650359e-04,
  2.871637365340465e-05, -1.252353701457306e-06,  4.337296191267594e-08, -1.264270383388251e-09,  3.214735826859069e-11, -7.304904735843310e-13,  1.509204320559219e-14,
 -2.871810545428488e-16,  5.083672509199463e-18, -8.436452029048669e-20,  2.857762935468055e-03, -3.648657416326084e-04,  2.500140275697535e-05, -1.210401582373439e-06,
  4.623698786096826e-08, -1.478575052271743e-09,  4.105715024794305e-11, -1.014765353243619e-12,  2.272363931949135e-14, -4.671957748297271e-16,  8.910496740579443e-18,
 -1.589020326340331e-19,  1.936817005025659e-03, -2.769716412435365e-04,  2.109167248838676e-05, -1.127100332763942e-06,  4.725355488492696e-08, -1.650433285642961e-09,
  4.984658443620553e-11, -1.335083512653503e-12,  3.229221522010044e-14, -7.150239402936257e-16,  1.464767152040746e-17, -2.798773039825064e-19,  1.294226734576848e-03,
 -2.056420289566182e-04,  1.729265578357693e-05, -1.014501861754527e-06,  4.646001625721956e-08, -1.764847756655049e-09,  5.775022323800469e-11, -1.670198568418165e-12,
  4.348944017412358e-14, -1.033816443123409e-15,  2.268004701001270e-17, -4.630014806990775e-19,  8.542324658024796e-04, -1.497043973812555e-04,  1.381860803776367e-05,
 -8.854578837094353e-07,  4.409400185521494e-08, -1.814240483987620e-09,  6.408008224327286e-11, -1.994213304292575e-12,  5.571915515911226e-14, -1.417665744087524e-15,
  3.321001842895965e-17, -7.223492558703993e-19,  5.579625754490938e-04, -1.071182769910025e-04,  1.079277197499721e-05, -7.516715761144552e-07,  4.052593499405459e-08,
 -1.798948009817701e-09,  6.833596016982039e-11, -2.280680748074523e-12,  6.816159213205349e-14, -1.850639317581771e-15,  4.616165310499436e-17, -1.066902276398233e-18,
  3.613659080268978e-04, -7.551834970567209e-05,  8.261435220896753e-06, -6.224649885167845e-07,  3.618177752155876e-08, -1.726158117029625e-09,  7.027088530808379e-11,
 -2.506819593464348e-12,  7.989020809567609e-14, -2.307890811768604e-15,  6.112652046832436e-17, -1.497209422244278e-18,  2.325291144975251e-04, -5.258357061305385e-05,
  6.214372044950695e-06, -5.042850268735993e-07,  3.147443503440600e-08, -1.607806458680542e-09,  6.990195076527209e-11, -2.656823812764776e-12,  9.001267619864237e-14,
 -2.758737594166702e-15,  7.737236205677213e-17, -2.003117158465138e-18,  1.489666792603495e-04, -3.624930281125060e-05,  4.605777144594169e-06, -4.008003946245964e-07,
  2.675506997490964e-08, -1.458095425231508e-09,  6.747268059975505e-11, -2.723597984641283e-12,  9.780183434269405e-14, -3.171011653816137e-15,  9.391858734023307e-17,
 -2.563343207848119e-18,  9.521097019229898e-05, -2.479910316112222e-05,  3.372059233581803e-06, -3.133691847007909e-07,  2.228767171432245e-08, -1.291220777316090e-09,
  6.338392068813874e-11, -2.708752719680108e-12,  1.027879467664315e-13, -3.515651789321238e-15,  1.096634720738413e-16, -3.147198340601972e-18,  6.083825193389872e-05,
 -1.687638696499107e-05,  2.444954820564810e-06, -2.416636073101198e-07,  1.824413121975599e-08, -1.119681677515960e-09,  5.811383374670771e-11, -2.621153161350819e-12,
  1.047970645563632e-13, -3.770511424198788e-15,  1.235339782577397e-16, -3.718170916701862e-18,  3.894522493382868e-05, -1.145059257180068e-05,  1.759923870611171e-06,
 -1.842907020605070e-07,  1.471379348926148e-08, -9.533099149991110e-10,  5.214476911580720e-11, -2.474592332372202e-12,  1.039358103273581e-13, -3.922664903714471e-15,
  1.346248821477011e-16, -4.238592292352840e-18,  2.502600720043740e-05, -7.763278566989295e-06,  1.260623984926745e-06, -1.393136282658139e-07,  1.172080003772591e-08,
 -7.989612334578948e-10,  4.590829073613195e-11, -2.285221076815597e-12,  1.005352516691623e-13, -3.968957962912479e-15,  1.422997516556284e-16, -4.674364200978626e-18,
  1.617410104886081e-05, -5.270425272887892e-06,  9.005554077328018e-07, -1.046356999101497e-07,  9.243609597606184e-09, -6.607001875575895e-10,  3.975246891789672e-11,
 -2.069251484817232e-12,  9.507273327701973e-14, -3.914992315322857e-15,  1.462389040165144e-16, -4.998803507767979e-18,  1.053196562985685e-05, -3.589839596531199e-06,
  6.429210087500011e-07, -7.824915064424422e-08,  7.232913174178298e-09, -5.402773662925059e-10,  3.392982241431226e-11, -1.841246167642417e-12,  8.809046737748459e-14,
 -3.773033169921020e-15,  1.464337442720082e-16, -5.194978803516404e-18,  6.920537305197334e-06, -2.457445502556662e-06,  4.595318278504880e-07, -5.837205154113618e-08,
  5.625987597011415e-09, -4.377206972518745e-10,  2.860096479400190e-11, -1.613095130302591e-12,  8.012518901905730e-14, -3.559434803086505e-15,  1.431383421567338e-16,
 -5.256339496720525e-18,  4.594802250196604e-06, -1.693139132058150e-06,  3.293350077727055e-07, -4.350397811684621e-08,  4.356948379167090e-09, -3.519125298530288e-10,
  2.384796474264194e-11, -1.393620702375371e-12,  7.165683759469462e-14, -3.292118590751549e-15,  1.367952728914133e-16, -5.185828400830060e-18,  3.085118897502984e-06,
 -1.175283992331749e-06,  2.369162989369226e-07, -3.242934793140656e-08,  3.363249355717196e-09, -2.810783823505208e-10,  1.969200478905015e-11, -1.188659921598213e-12,
  6.307823885160139e-14, -2.988476694883227e-15,  1.279534354809125e-16, -4.993926277035716e-18,  2.095518425226099e-06, -8.222925098335957e-07,  1.711606246065748e-07,
 -2.419151054756927e-08,  2.589196515920810e-09, -2.231580204636901e-10,  1.611131682290177e-11, -1.001446948270342e-12,  5.468343664051501e-14, -2.663885370117568e-15,
  1.171922186069783e-16, -4.696170003699976e-18,  1.439159189240976e-06, -5.796654487732964e-07,  1.241426081270543e-07, -1.805386201871813e-08,  1.987335292099735e-09,
 -1.760598459614631e-10,  1.305693453021940e-11, -8.331356858006086e-13,  4.667002910789496e-14, -2.330848850657712e-15,  1.050610978317027e-16, -4.310639395828550e-18,
  9.976494935119578e-07, -4.110516717746273e-07,  9.025376981946188e-08, -1.345821711071303e-08,  1.518475892702332e-09, -1.378160482807033e-10,  1.046513533074623e-11,
 -6.833425909907634e-13,  3.915031176461111e-14, -1.998685203527188e-15,  9.203839678102317e-17, -3.855775667968237e-18,  6.955268303743377e-07, -2.921728320584174e-07,
  6.554056469701117e-08, -9.986074901215441e-09,  1.150949402231007e-09, -1.066619730686263e-10,  8.266386097764236e-12, -5.506340442932249e-13,  3.216663318997473e-14,
 -1.673612816790869e-15,  7.850873878485229e-17, -3.348735241056077e-18,  4.842769331576984e-07, -2.067385179067146e-07,  4.721532541975834e-08, -7.325291080729778e-09,
  8.595072447315196e-10, -8.106260164258489e-11,  6.391158091109177e-12, -4.329209323876378e-13,  2.570752803192446e-14, -1.359088994172479e-15,  6.475612677383670e-17,
 -2.804340169647052e-18,  3.323175581453053e-07, -1.437169388876698e-07,  3.330137349272436e-08, -5.242761974438283e-09,  6.241230046441985e-10, -5.970520531069564e-11,
  4.773219806925857e-12, -3.277509015575789e-13,  1.972245214538523e-14, -1.056273755088696e-15,  5.096853598920262e-17, -2.234584777958527e-18,  2.186917311078694e-07,
 -9.551358676685111e-08,  2.237806748572363e-08, -3.562694110867218e-09,  4.288404920424603e-10, -4.147244598228127e-11,  3.351060338241178e-12, -2.325062409952247e-13,
  1.413405487936204e-14, -7.645276582708376e-16,  3.725004406435329e-17, -1.648604429092794e-18,  1.290571245194740e-07, -5.674974610924462e-08,  1.339807352924280e-08,
 -2.149613505228168e-09,  2.607391521235334e-10, -2.540625977972909e-11,  2.068076180297229e-12, -1.445276886445164e-13,  8.847962845952609e-15, -4.819011219058322e-16,
  2.363789253628496e-17, -1.053022226263219e-18,  5.315138355760410e-08, -2.346017416844781e-08,  5.562295329593138e-09, -8.962731815436798e-10,  1.091783711455207e-10,
 -1.068291046268793e-11,  8.731657224251162e-13, -6.126651999652788e-14,  3.765455741269787e-15, -2.058706707568741e-16,  1.013603769503706e-17, -4.531860425227653e-19,
  7.030452884667542e-02, -2.066799151854325e-04,  6.347752151167897e-07, -2.017836656411201e-09,  6.571738867440315e-12, -2.173630754347264e-14,  7.251710903432228e-17,
 -2.428896325471383e-19,  8.141771142105800e-22, -2.726168199814075e-24,  9.107398902323077e-27, -3.033827921413329e-29,  6.800636397612959e-02, -2.710462699194612e-04,
  1.274221174333855e-06, -6.115603013241501e-09,  2.874648474894185e-11, -1.315994115462672e-13,  5.882489736361279e-16, -2.576452061591900e-18,  1.108937540178857e-20,
 -4.701151593233305e-23,  1.966425896583107e-25, -8.126931150374701e-28,  6.364026745230955e-02, -3.866649459218217e-04,  2.631202582881865e-06, -1.675459714436460e-08,
  1.002670749980889e-10, -5.721926598153705e-13,  3.144611501957704e-15, -1.675210809174555e-17,  8.690814506244506e-20, -4.406048150972333e-22,  2.188834109847480e-24,
 -1.067786677165268e-26,  5.762761249059118e-02, -5.305976393507262e-04,  4.795449313071453e-06, -3.838737238405808e-08,  2.824356784005765e-10, -1.951960384307515e-12,
  1.283686928763226e-14, -8.103016640816873e-17,  4.940168782410112e-19, -2.922674976699735e-21,  1.684005922252148e-23, -9.477123306788238e-26,  5.051214221296060e-02,
 -6.756277710865164e-04,  7.770050204218009e-06, -7.643807382534628e-08,  6.781064677572578e-10, -5.570540446680465e-12,  4.306130888417443e-14, -3.166449872186933e-16,
  2.232141938616813e-18, -1.517230802945374e-20,  9.988638504949164e-23, -6.391624795534235e-25,  4.287740939598600e-02, -7.963901819055862e-04,  1.139241106320699e-05,
 -1.355845063741636e-07,  1.428952598727359e-09, -1.376068428475658e-11,  1.234219675130849e-13, -1.044360664857018e-15,  8.413643248489190e-18, -6.497536217506083e-20,
  4.835275394790122e-22, -3.481634221589953e-24,  3.526802634854349e-02, -8.743841119953564e-04,  1.531596202333441e-05, -2.176584540767677e-07,  2.692917073702228e-09,
 -3.006996690472992e-11,  3.097760453125823e-13, -2.987690831864265e-15,  2.725947570490464e-17, -2.371113920653359e-19,  1.977990862934322e-21, -1.589828881229297e-23,
  2.812922172158722e-02, -9.007056967022495e-04,  1.906488631280580e-05, -3.198740090681040e-07,  4.599729084034866e-09, -5.902193670723217e-11,  6.925805988634110e-13,
 -7.554264422643141e-15,  7.748280700113673e-17, -7.537731145444071e-19,  7.001092750106377e-21, -6.240449126318930e-23,  2.177282212410544e-02, -8.761730196667952e-04,
  2.214120095349798e-05, -4.342067226773563e-07,  7.194464384969772e-09, -1.052647559693146e-10,  1.396968119954481e-12, -1.711795452291147e-14,  1.961404005166657e-16,
 -2.121312975949532e-18,  2.181197822622274e-20, -2.144241296365444e-22,  1.637049418541230e-02, -8.093121036720681e-04,  2.414292905505623e-05, -5.484046481373470e-07,
  1.038971019602945e-08, -1.721516474961365e-10,  2.567661705413774e-12, -3.514102466796754e-14,  4.473513256521391e-16, -5.350897742024857e-18,  6.060663543983981e-20,
 -6.539576168150761e-22,  1.196912151038895e-02, -7.131614073086328e-04,  2.485164654609566e-05, -6.484595548387086e-07,  1.394897016968427e-08, -2.601234581836527e-10,
  4.335900884399018e-12, -6.593231133274160e-14,  9.279477619251431e-16, -1.221874727528822e-17,  1.517755955298614e-19, -1.789940885773398e-21,  8.519888210552254e-03,
 -6.019396035469700e-04,  2.426431135812419e-05, -7.217499497010086e-07,  1.751448825689064e-08, -3.655026117303716e-10,  6.773630276873991e-12, -1.138972198843895e-13,
  1.764385375144729e-15, -2.546791722678553e-17,  3.455496998605362e-19, -4.436985954492936e-21,  5.912201066013194e-03, -4.883789369346158e-04,  2.256770233332186e-05,
 -7.598077652709340e-07,  2.067538050879448e-08, -4.802884315893437e-10,  9.848827987100190e-12, -1.823196821296638e-13,  3.095861748719808e-15, -4.879705424877048e-17,
  7.205303129971254e-19, -1.003783713527777e-20,  4.005307360301204e-03, -3.821233421048551e-04,  2.007298784883234e-05, -7.598620194155797e-07,  2.305541927567779e-08,
 -5.932238989548056e-10,  1.339992537351485e-11, -2.719664623945656e-13,  5.042663964473942e-15, -8.647918800393930e-17,  1.384906299439720e-18, -2.086383419347489e-20,
  2.653241075229512e-03, -2.892010698068047e-04,  1.713642592222434e-05, -7.248317211056561e-07,  2.439225619314854e-08, -6.919165663245224e-10,  1.714329373598000e-11,
 -3.799930534418750e-13,  7.665465223958548e-15, -1.425429325637085e-16,  2.467736467284727e-18, -4.007900359441464e-20,  1.721509928331113e-03, -2.123195149003247e-04,
  1.408967284944200e-05, -6.620028297026011e-07,  2.458440254618653e-08, -7.653786207322914e-10,  2.071650368424970e-11, -4.996319672224867e-13,  1.092765516227099e-14,
 -2.196222085834554e-16,  4.097655316277833e-18, -7.153554154760941e-20,  1.096039538287300e-03, -1.516279864724322e-04,  1.119381204317819e-05, -5.809911903590386e-07,
  2.369565463788908e-08, -8.062029154612565e-10,  2.374651593804346e-11, -6.209192248003763e-13,  1.467510925736402e-14, -3.177717963285989e-16,  6.370826579943061e-18,
 -1.192135792914101e-19,  6.860750008586417e-04, -1.056218672638456e-04,  8.620447594406555e-06, -4.916679338884881e-07,  2.192188453502130e-08, -8.117646155781189e-10,
  2.592258400120597e-11, -7.323482365178248e-13,  1.864392015567307e-14, -4.336538670170196e-16,  9.315411837658006e-18, -1.863333614101429e-19,  4.230984538183824e-04,
 -7.196008738247495e-05,  6.455108722358585e-06, -4.025567205222726e-07,  1.953571985119390e-08, -7.842225343611022e-10,  2.705260975803036e-11, -8.229992599696479e-13,
  2.249754482158615e-14, -5.604482489616878e-16,  1.286359697390867e-17, -2.743186176429924e-19,  2.576201169187564e-04, -4.808092610500960e-05,  4.714399432451567e-06,
 -3.199351485718420e-07,  1.682759548802300e-08, -7.295002385795878e-10,  2.708878669322086e-11, -8.845321006529451e-13,  2.588445263402197e-14, -6.886260517465789e-16,
  1.684196435579126e-17, -3.819076211123442e-19,  1.552298232379357e-04, -3.159251352018937e-05,  3.368316328654526e-06, -2.476158780531762e-07,  1.405790171520571e-08,
 -6.556922035127020e-10,  2.611964725591954e-11, -9.125088244246497e-13,  2.850032818541854e-14, -8.074368525344767e-16,  2.098613664002882e-17, -5.047255596907359e-19,
  9.278032289201594e-05, -2.047019799798942e-05,  2.361400669084610e-06, -1.872230571472806e-07,  1.142777161173586e-08, -5.713991529985454e-10,  2.433597902092138e-11,
 -9.067744147278047e-13,  3.013805885077960e-14, -9.067196898832552e-16,  2.497790375733780e-17, -6.355223793712573e-19,  5.514215283400449e-05, -1.311570751122754e-05,
  1.629285234156278e-06, -1.387299968300580e-07,  9.068957876740194e-09, -4.843836615622310e-10,  2.198383447355465e-11, -8.709375933271650e-13,  3.071390233923198e-14,
 -9.785570857147715e-16,  2.849571511445801e-17, -7.650796672924745e-19,  3.266977996287233e-05, -8.333059241796515e-06,  1.109654980209137e-06, -1.010556177482801e-07,
  7.048485735764628e-09, -4.007417967091307e-10,  1.931811749887952e-11, -8.112349419364470e-13,  3.026658750534547e-14, -1.018374026697411e-15,  3.126548687250289e-17,
 -8.835795967339491e-19,  1.934402877491245e-05, -5.264675514957186e-06,  7.482096269514078e-07, -7.258687342951545e-08,  5.381925051368845e-09, -3.245991488265911e-10,
  1.656643347794628e-11, -7.351608391846508e-13,  2.893402857085566e-14, -1.025287465468956e-15,  3.309944317898376e-17, -9.820934238913884e-19,  1.147607799500699e-05,
 -3.316619517224750e-06,  5.009162399841205e-07, -5.156617589048040e-08,  4.049586013205404e-09, -2.582152627513308e-10,  1.390751899944403e-11, -6.502073146055467e-13,
  2.691715813458478e-14, -1.001743009057648e-15,  3.391535150785022e-17, -1.053833589455071e-18,  6.838844075951907e-06, -2.089093890522805e-06,  3.339223024053247e-07,
 -3.633671431896474e-08,  3.011618763712440e-09, -2.023323072621527e-10,  1.146381101966604e-11, -5.629344832551860e-13,  2.444127857937353e-14, -9.526491451692627e-16,
  3.373477384153242e-17, -1.094913579705301e-18,  4.103761652936807e-06, -1.319174662700352e-06,  2.222547291115760e-07, -2.546909820569756e-08,  2.219905823264813e-09,
 -1.566151335064349e-10,  9.304758813576829e-12, -4.784489462139627e-13,  2.172311558368655e-14, -8.842925745286823e-16,  3.266441230932558e-17, -1.104521441153685e-18,
  2.485461068758100e-06, -8.371692781987843e-07,  1.480822247886310e-07, -1.780372285949475e-08,  1.626175867908357e-09, -1.200727423631775e-10,  7.456473055811608e-12,
 -4.002533111899640e-13,  1.894806446329673e-14, -8.032953585593634e-16,  3.086771701358760e-17, -1.084571246533533e-18,  1.522616347901370e-06, -5.351653214056137e-07,
  9.899861684430956e-08, -1.244175808784913e-08,  1.186725756259554e-09, -9.140067659848762e-11,  5.913733255201289e-12, -3.303660984600076e-13,  1.625851315088243e-14,
 -7.157912446097383e-16,  2.853432377382307e-17, -1.039002977567711e-18,  9.452470968021642e-07, -3.453011122242209e-07,  6.654682938842294e-08, -8.710367405442257e-09,
  8.645638490456393e-10, -6.922459554295845e-11,  4.651521539358196e-12, -2.695952369742387e-13,  1.375157106520785e-14, -6.268980757006148e-16,  2.585326827014539e-17,
 -9.729369209081230e-19,  5.955401322570328e-07, -2.252358478771395e-07,  4.505198768569749e-08, -6.119278908811662e-09,  6.298453588342444e-10, -5.225156823624413e-11,
  3.634516767299768e-12, -2.178646755383653e-13,  1.148330680800819e-14, -5.404788761364838e-16,  2.299337410327676e-17, -8.918637542896800e-19,  3.811352978633562e-07,
 -1.486787631121552e-07,  3.075034284193049e-08, -4.318573350100559e-09,  4.593323099615648e-10, -3.934829703387947e-11,  2.824012083847272e-12, -1.745245204544643e-13,
  9.476480232843682e-15, -4.591319353782017e-16,  2.009172997508858e-17, -8.009916690809948e-19,  2.477886244896873e-07, -9.933691757796158e-08,  2.116555229021113e-08,
 -3.062349477140147e-09,  3.354065124083264e-10, -2.956841339318817e-11,  2.182386153924918e-12, -1.386068549760715e-13,  7.729313318377269e-15, -3.843304852884888e-16,
  1.724936230078753e-17, -7.048043755363445e-19,  1.634589703481886e-07, -6.710528439132496e-08,  1.467574595214158e-08, -2.179681540164343e-09,  2.449699322580222e-10,
 -2.214841749026874e-11,  1.675589841924752e-12, -1.090144348137191e-13,  6.223658357743490e-15, -3.166368383134794e-16,  1.453225706085824e-17, -6.068281770050139e-19,
  1.090681126141925e-07, -4.569431444770033e-08,  1.021993087442947e-08, -1.552538176321815e-09,  1.784157419490605e-10, -1.648708110274800e-11,  1.274199837459465e-12,
 -8.464549179740014e-14,  4.931697043119178e-15, -2.559330406455766e-16,  1.197566944648506e-17, -5.095712953329853e-19,  7.313532379960549e-08, -3.116304732318353e-08,
  7.102235756000972e-09, -1.099574307046649e-09,  1.287507259910692e-10, -1.211825096936193e-11,  9.535404887595025e-13, -6.446587607140783e-14,  3.820893185842823e-15,
 -2.016308550724691e-16,  9.589926254361197e-18, -4.145842137930409e-19,  4.865301312369318e-08, -2.101513656633601e-08,  4.862855308649283e-09, -7.645204625850908e-10,
  9.088800396446579e-11, -8.682958186478181e-12,  6.932650546083657e-13, -4.754204346026668e-14,  2.857292486739248e-15, -1.528423548166583e-16,  7.366414886718745e-18,
 -3.225908831806731e-19,  3.125607431371340e-08, -1.364119352778701e-08,  3.193420070073873e-09, -5.079890310041464e-10,  6.109670718039869e-11, -5.903836482216075e-12,
  4.766690398724081e-13, -3.304738118562863e-14,  2.007449932089258e-15, -1.085061554551020e-16,  5.282977646470694e-18, -2.336509487397252e-19,  1.813717074629734e-08,
 -7.972374109652149e-09,  1.881399689561925e-09, -3.017250192960080e-10,  3.658228760641356e-11, -3.563049283318169e-12,  2.899128447697268e-13, -2.025234719917391e-14,
  1.239351774832186e-15, -6.747452581817679e-17,  3.308451861146573e-18, -1.473301883831924e-19,  7.399613693395675e-09, -3.265472612313515e-09,  7.740663346737683e-10,
 -1.247015670894457e-10,  1.518712674401261e-11, -1.485719823244794e-12,  1.214097161131063e-13, -8.517078558855888e-15,  5.233556985884453e-16, -2.860797862925011e-17,
  1.408236211018847e-18, -6.295061404005432e-20,  6.948781471453799e-02, -2.016968145471252e-04,  6.111780163273952e-07, -1.916074341908297e-09,  6.153880788530348e-12,
 -2.007465201139872e-14,  6.606668320410722e-17, -2.183384569899342e-19,  7.222831941813913e-22, -2.387206504925655e-24,  7.873035732769441e-27, -2.589442860096253e-29,
  6.694211243046973e-02, -2.611384255919458e-04,  1.203509164538257e-06, -5.675971912344864e-09,  2.625003367293622e-11, -1.183085360878329e-13,  5.208323612434062e-16,
 -2.247219834980303e-18,  9.530335300128260e-21, -3.981643702932562e-23,  1.641585111304596e-25, -6.688122915830207e-28,  6.213447094906860e-02, -3.663931171384341e-04,
  2.439408269489495e-06, -1.523792820468134e-08,  8.954149885566805e-11, -5.020505063584051e-13,  2.712218127114771e-15, -1.420881545755436e-17,  7.251537774521665e-20,
 -3.617668055938245e-22,  1.768942918903090e-24, -8.495827010092195e-27,  5.557913635794400e-02, -4.940026781453621e-04,  4.360678565653695e-06, -3.416471638298356e-08,
  2.463023788602602e-10, -1.669408058266210e-12,  1.077440838875308e-14, -6.678281736820748e-17,  3.999839524564150e-19, -2.325589161571171e-21,  1.317328616545163e-23,
 -7.290450720407913e-26,  4.792839230977094e-02, -6.169600688410147e-04,  6.914388972915191e-06, -6.642638031509299e-08,  5.763518909229885e-10, -4.635868748560262e-12,
  3.511833123939729e-14, -2.532363865096311e-16,  1.751560684161278e-18, -1.168722154001334e-20,  7.556157018161478e-23, -4.750059199532911e-25,  3.986434522378908e-02,
 -7.113901924381552e-04,  9.893989812821675e-06, -1.147714534156199e-07,  1.181140100948188e-09, -1.112107345396883e-11,  9.762250819565973e-14, -8.090973202868402e-16,
  6.388668053045935e-18, -4.838287196113626e-20,  3.532560532908144e-22, -2.496673041384490e-24,  3.199998021230133e-02, -7.616147644303027e-04,  1.294396927247344e-05,
 -1.790057929692023e-07,  2.159565743542390e-09, -2.354800905379733e-11,  2.371511284437837e-13, -2.237964162816819e-15,  1.999373763979861e-17, -1.703960610207660e-19,
  1.393471093138325e-21, -1.098498993351766e-23,  2.480878168610319e-02, -7.623736157577189e-04,  1.563175814678460e-05, -2.548859075083795e-07,  3.569724853174864e-09,
 -4.468132358896051e-11,  5.120503947203760e-13, -5.459888865119450e-15,  5.478931566206460e-17, -5.218296762721861e-19,  4.748009304195483e-21, -4.148108541285439e-23,
  1.859195525368562e-02, -7.180773679367455e-04,  1.755739850225112e-05, -3.342670578572998e-07,  5.389004669373598e-09, -7.684488047093627e-11,  9.951572364529333e-13,
 -1.191182296732180e-14,  1.334411488887435e-16, -1.412035065133304e-18,  1.421459857188360e-20, -1.368869832218397e-22,  1.348152404807050e-02, -6.399075605950426e-04,
  1.845586247938069e-05, -4.066728830379449e-07,  7.490877722013388e-09, -1.208800879632705e-10,  1.758203168046960e-12, -2.349106055606456e-14,  2.922060547341243e-16,
 -3.417903452124103e-18,  3.788297677514684e-20, -4.002495242770249e-22,  9.469697162007167e-03, -5.420417155365773e-04,  1.825428609657267e-05, -4.618138998889899e-07,
  9.653340605541872e-09, -1.752277100951615e-10,  2.846927471364695e-12, -4.224281483630018e-14,  5.806916978469941e-16, -7.474309412038636e-18,  9.081980121608076e-20,
 -1.048410733956248e-21,  6.451565116420181e-03, -4.382082993097607e-04,  1.706937462709706e-05, -4.921452419160721e-07,  1.160148545145229e-08, -2.355853982548594e-10,
  4.254133789393932e-12, -6.977920607396167e-14,  1.055477744716346e-15, -1.488869527516542e-17,  1.975620105021588e-19, -2.482567693055962e-21,  4.269095508815228e-03,
 -3.393388524989370e-04,  1.515515737648709e-05, -4.945582252891312e-07,  1.307145795392130e-08, -2.954251414858487e-10,  5.901888621437841e-12, -1.065599991313866e-13,
  1.766527093018733e-15, -2.720703448772690e-17,  3.928416616617077e-19, -5.355265764214894e-21,  2.748025523419829e-03, -2.525415576203617e-04,  1.282667926591880e-05,
 -4.707121085363136e-07,  1.387339497665632e-08, -3.473067770604740e-10,  7.642892838441920e-12, -1.512936066606039e-13,  2.738663678033903e-15, -4.589194243835421e-17,
  7.186600659939331e-19, -1.059444065384981e-20,  1.723675665575124e-03, -1.811894934002753e-04,  1.038704609356477e-05, -4.260809215905964e-07,  1.393185343379370e-08,
 -3.845740190736533e-10,  9.284307295503521e-12, -2.007428269785853e-13,  3.953949322071117e-15, -7.185176297375325e-17,  1.216527305548384e-18, -1.933639965200519e-20,
  1.055456396247428e-03, -1.257001971403358e-04,  8.076629230464923e-06, -3.682277864018944e-07,  1.329251705422503e-08, -4.028549341243363e-10,  1.062802439273442e-11,
 -2.501018526551791e-13,  5.342382466341296e-15, -1.049521531288246e-16,  1.915520695549113e-18, -3.273504815306895e-20,  6.321785151638085e-04, -8.456998935191362e-05,
  6.050794803626420e-06, -3.049640963671128e-07,  1.209757974331416e-08, -4.008869831022452e-10,  1.151435731470977e-11, -2.938916148038539e-13,  6.786481900229765e-15,
 -1.436969498371835e-16,  2.819163800325208e-18, -5.165858689417043e-20,  3.711787914271655e-04, -5.534012085052052e-05,  4.382178003311402e-06, -2.429184406548847e-07,
  1.054247810833531e-08, -3.804778237638580e-10,  1.185492947850381e-11, -3.271071851091493e-13,  8.140401661800538e-15, -1.852399456948046e-16,  3.895753897945592e-18,
 -7.634354048457465e-20,  2.141231589528298e-04, -3.532474114422510e-05,  3.078197416632429e-06, -1.867635757278896e-07,  8.829925113368790e-09, -3.457381546303707e-10,
  1.164542030624424e-11, -3.462514879683246e-13,  9.258506788733457e-15, -2.257815023668104e-16,  5.076530330127185e-18, -1.061201558759100e-19,  1.216568179928685e-04,
 -2.206071868645136e-05,  2.104065981870546e-06, -1.390801077127431e-07,  7.133938026715867e-09, -3.019353675479539e-10,  1.095686192159814e-11, -3.499472718891371e-13,
  1.002464165466390e-14, -2.612596358320183e-16,  6.263727235640985e-18, -1.393240759931114e-19,  6.825215448491336e-05, -1.351980255419730e-05,  1.404133920774844e-06,
 -1.006677362968264e-07,  5.579924027347604e-09, -2.543549282775697e-10,  9.911399558750236e-12, -3.389935099842751e-13,  1.037334468452094e-14, -2.881332538639618e-16,
  7.347020614740353e-18, -1.734574865498361e-19,  3.791174396614047e-05, -8.155753403934543e-06,  9.178704128632758e-07, -7.106822978247625e-08,  4.240431116172549e-09,
 -2.074515414943439e-10,  8.652024933630457e-12, -3.159316307583639e-13,  1.029770417558700e-14, -3.040272207892323e-16,  8.223794035650764e-18, -2.055776891265479e-19,
  2.090880381629537e-05, -4.858016971678273e-06,  5.896916710316066e-07, -4.910517996617449e-08,  3.142113036976022e-09, -1.644063852896753e-10,  7.315244364000458e-12,
 -2.843250770603028e-13,  9.843505832739052e-15, -3.080714227090739e-16,  8.817411314507794e-18, -2.328103858312329e-19,  1.148275355287838e-05, -2.866394235748514e-06,
  3.735901991087322e-07, -3.332358481190738e-08,  2.278256983183578e-09, -1.270593906717888e-10,  6.012321866870548e-12, -2.479929169546470e-13,  9.093526226151510e-15,
 -3.008820196933408e-16,  9.088714800083929e-18, -2.528447328275961e-19,  6.298267167026817e-06, -1.680708832271449e-06,  2.341821839068559e-07, -2.228695936063028e-08,
  1.622112261954790e-09, -9.610029607598344e-11,  4.820697589615730e-12, -2.103876481597374e-13,  8.147825460863081e-15, -2.842476109021418e-16,  9.038583430136987e-18,
 -2.642819454709022e-19,  3.460765529623064e-06, -9.825041414160634e-07,  1.457332436529577e-07, -1.474063373253186e-08,  1.138066286197574e-09, -7.138284854232239e-11,
  3.784046661409911e-12, -1.742131949807524e-13,  7.105517080889763e-15, -2.606531273220993e-16,  8.702312888830919e-18, -2.667669042324625e-19,  1.910833528374976e-06,
 -5.744634756427867e-07,  9.033463391723472e-08, -9.674265055924753e-09,  7.894900586871994e-10, -5.225205376280302e-11,  2.917897569047874e-12, -1.412875881794126e-13,
  6.051561265389854e-15, -2.327856363995862e-16,  8.138673532471517e-18, -2.609041338856851e-19,  1.063365704946129e-06, -3.370194606779975e-07,  5.595708109245117e-08,
 -6.321059409626623e-09,  5.433256531743683e-10, -3.781775802606689e-11,  2.217624535670242e-12, -1.125945094517612e-13,  5.049780558426385e-15, -2.031314838924484e-16,
  7.417222978353568e-18, -2.480168567650458e-19,  5.981667214122329e-07, -1.989962566680533e-07,  3.474744358147002e-08, -4.124843122096272e-09,  3.721238217496313e-10,
 -2.714856898592325e-11,  1.666393428212124e-12, -8.844538708599498e-14,  4.141426260592216e-15, -1.737190703770449e-16,  6.606933929414388e-18, -2.298342606430624e-19,
  3.410684617179467e-07, -1.186011486945097e-07,  2.169390779390053e-08, -2.696246041704590e-09,  2.543998394687638e-10, -1.938823423592022e-11,  1.241675890437962e-12,
 -6.868030410523821e-14,  3.347618553411929e-15, -1.460101978984171e-16,  5.767987493622954e-18, -2.081873460875233e-19,  1.976186940712400e-07, -7.153634169963671e-08,
  1.365394795951879e-08, -1.770146150950080e-09,  1.740633420409640e-10, -1.381079880578535e-11,  9.198454652420421e-13, -5.285735388773013e-14,  2.673792453603904e-15,
 -1.209092549866848e-16,  4.947279214592103e-18, -1.847686134623887e-19,  1.166004936192676e-07, -4.376487902111033e-08,  8.682928163319992e-09, -1.169874850401609e-09,
  1.194635024705407e-10, -9.834505920163075e-12,  6.789613604054323e-13, -4.040388657054991e-14,  2.114617898690023e-15, -9.884624241479213e-17,  4.177202421781660e-18,
 -1.609795833606128e-19,  7.016650187422183e-08, -2.720208916156857e-08,  5.588425410121921e-09, -7.796084975697484e-10,  8.237923640433414e-11, -7.012010374041318e-12,
  5.001313892819526e-13, -3.072205311020002e-14,  1.658406472241874e-15, -7.989203486811107e-17,  3.476762497959543e-18, -1.378637915682816e-19,  4.309460845039703e-08,
 -1.719114614709426e-08,  3.643219483423725e-09, -5.242933020665711e-10,  5.712128500474266e-11, -5.009757068103131e-12,  3.679097889336513e-13, -2.325278763630398e-14,
  1.290537039584755e-15, -6.387500118710985e-17,  2.853982359571399e-18, -1.161067698019692e-19,  2.699828418141281e-08, -1.104151054679223e-08,  2.404670748061083e-09,
 -3.556553596436837e-10,  3.980714748238858e-11, -3.584630178723602e-12,  2.701266926305139e-13, -1.750763054852224e-14,  9.958128735420669e-16, -5.048079303512810e-17,
  2.308731787085825e-18, -9.607874856417752e-20,  1.720901617277173e-08, -7.189436880338880e-09,  1.602976122391366e-09, -2.427518491454129e-10,  2.781096514647167e-11,
 -2.562235578724996e-12,  1.974411993988143e-13, -1.307863158225000e-14,  7.598821054824727e-16, -3.932783717816382e-17,  1.835393230045153e-18, -7.789754048098568e-20,
  1.109406301341369e-08, -4.717841217669989e-09,  1.072859368352222e-09, -1.657337047004703e-10,  1.936370448443222e-11, -1.818659501375976e-12,  1.428057354439818e-13,
 -9.635060876192840e-15,  5.699417970463921e-16, -3.001831180835357e-17,  1.425050743366618e-18, -6.149465338461609e-20,  7.144237605720334e-09, -3.081888394334015e-09,
  7.121127642899509e-10, -1.117928767845520e-10,  1.327111721682570e-11, -1.266068293786862e-12,  1.009465274634884e-13, -6.913328848391878e-15,  4.149502673001437e-16,
 -2.216825699571373e-17,  1.067098944836916e-18, -4.667417509071555e-20,  4.475202269990872e-09, -1.951637028146195e-09,  4.564891474928099e-10, -7.255252132877391e-11,
  8.718544670061044e-12, -8.417738653784932e-13,  6.790799026456343e-14, -4.704267729135019e-15,  2.855347982388530e-16, -1.542184217344370e-17,  7.503023065052162e-19,
 -3.315961658520162e-20,  2.551321648569563e-09, -1.121015768534594e-09,  2.644303897821923e-10, -4.238821125833595e-11,  5.137001363480018e-12, -5.001136717484280e-13,
  4.067485413684141e-14, -2.840202752616351e-15,  1.737352128700595e-16, -9.454884076545516e-18,  4.634128569410314e-19, -2.062842674004469e-20,  1.030629388552676e-09,
 -4.547336216763960e-10,  1.077693781477711e-10, -1.735774488343900e-11,  2.113495646238854e-12, -2.067130483655765e-13,  1.688849030969977e-14, -1.184501891437336e-15,
  7.276979419397286e-17, -3.976965540353167e-18,  1.957275727136212e-19, -8.747620872156974e-21,  6.869066300651407e-02, -1.968977180932295e-04,  5.887629210070552e-07,
 -1.820740075248036e-09,  5.767761729450696e-12, -1.855987884892110e-14,  6.026429048580346e-17, -1.965418047408564e-19,  6.417483133756271e-22, -2.093922478817518e-24,
  6.818458465633433e-27, -2.214529538002058e-29,  6.591639334922360e-02, -2.517758344385085e-04,  1.137841564186500e-06, -5.274242364008200e-09,  2.400393866640921e-11,
 -1.065304441193304e-13,  4.619730222765863e-16, -1.963971430309197e-18,  8.208378151014842e-21, -3.380248212477904e-23,  1.373900917904529e-25, -5.519054872765251e-28,
  6.070680433625764e-02, -3.475856570404383e-04,  2.264828859428491e-06, -1.388218627139158e-08,  8.012050130895868e-11, -4.414807807622599e-13,  2.344993590114827e-15,
 -1.208374342410835e-17,  6.068024073423757e-20, -2.979512521939207e-22,  1.434296103558347e-24, -6.783216247196786e-27,  5.367039132984541e-02, -4.606926110330013e-04,
  3.973289022604779e-06, -3.047754448926390e-08,  2.153557716663066e-10, -1.431888813483867e-12,  9.071786516400606e-15, -5.522712822934200e-17,  3.250225107025756e-19,
 -1.857600320335503e-21,  1.034677417145212e-23, -5.632266971150097e-26,  4.556634624263518e-02, -5.646834161193397e-04,  6.169684533776274e-06, -5.790299639875649e-08,
  4.915197315899678e-10, -3.872151458048856e-12,  2.875309403914242e-14, -2.033734949677836e-16,  1.380539968384274e-18, -9.044668701516083e-21,  5.744007330799084e-23,
 -3.548136313515269e-25,  3.716879792887835e-02, -6.374421471877814e-04,  8.623174181670867e-06, -9.753259048200344e-08,  9.804259017077190e-10, -9.028405504714260e-12,
  7.758632470933101e-14, -6.300025535024969e-16,  4.876810945992878e-18, -3.622740848275936e-20,  2.595731897667922e-22, -1.801098173607742e-24,  2.914780471362051e-02,
 -6.661017709937023e-04,  1.098862287473671e-05, -1.479312511457711e-07,  1.740797050046642e-09, -1.854134618704158e-11,  1.825946925555787e-13, -1.686434127483958e-15,
  1.475627668154655e-17, -1.232467735793951e-19,  9.882769775416726e-22, -7.642758177034688e-24,  2.199131042374613e-02, -6.486469308192206e-04,  1.288836016726007e-05,
 -2.043002317846874e-07,  2.787562194511703e-09, -3.404464950614828e-11,  3.811369942469954e-13, -3.973845011399299e-15,  3.902346833001888e-17, -3.639614565178132e-19,
  3.244818244934404e-21, -2.779124282510914e-23,  1.597708521573177e-02, -5.923060923926217e-04,  1.401673398770691e-05, -2.591457635890525e-07,  4.066236616293134e-09,
 -5.652427583410118e-11,  7.144849450856044e-13, -8.356092194839269e-15,  9.153948918429719e-17, -9.479270743410360e-19,  9.344397647283538e-21, -8.816826271983765e-23,
  1.118893221569501e-02, -5.099133204787863e-04,  1.422198966616883e-05, -3.040729415028576e-07,  5.446980792023325e-09, -8.562362215275848e-11,  1.214765275428401e-12,
 -1.584802377858759e-14,  1.926645497236123e-16, -2.204188509569650e-18,  2.391132375144749e-20, -2.474136833014725e-22,  7.561884865965847e-03, -4.157928657529357e-04,
  1.353460076619285e-05, -3.320518190439148e-07,  6.746123800953259e-09, -1.192208803150749e-10,  1.888347978129999e-12, -2.734607142783097e-14,  3.672237514511503e-16,
 -4.621155569599527e-18,  5.493675490212915e-20, -6.208597456680747e-22,  4.938463418825479e-03, -3.224457583181078e-04,  1.213819478948253e-05, -3.392692271136557e-07,
  7.770316296766830e-09, -1.535609838094840e-10,  2.702341841241562e-12, -4.324554736506272e-14,  6.388042844199349e-16, -8.807264244628868e-18,  1.143070329143924e-19,
 -1.405864346115944e-21,  3.121120955515861e-03, -2.386846040946772e-04,  1.030274912911980e-05, -3.258969953437718e-07,  8.367263769274870e-09, -1.840032179234802e-10,
  3.581583030074995e-12, -6.307787208364021e-14,  1.020997594955681e-15, -1.536655141620782e-17,  2.169854158243306e-19, -2.894727443104540e-21,  1.912017056020202e-03,
 -1.692183865336255e-04,  8.309495386329686e-06, -2.956204569010604e-07,  8.463777883337829e-09, -2.061576559317864e-10,  4.420055564308420e-12, -8.534235878357057e-14,
  1.508275535947622e-15, -2.469724897628064e-17,  3.782135056686315e-19, -5.456248375706145e-21,  1.137396068030640e-03, -1.152699808941887e-04,  6.392267807170217e-06,
 -2.542778277750344e-07,  8.078173330922890e-09, -2.169941545118787e-10,  5.104417550334547e-12, -1.076584924321387e-13,  2.070482271465878e-15, -3.676898297402299e-17,
  6.088384723307710e-19, -9.470996637596222e-21,  6.582938930771431e-04, -7.567938137840311e-05,  4.707228904714650e-06, -2.082187966276049e-07,  7.305659550626182e-09,
 -2.155232895204988e-10,  5.541623595978054e-12, -1.272364654866767e-13,  2.654320655873328e-15, -5.096840946432829e-17,  9.099514069133953e-19, -1.522193044895022e-20,
  3.714839507825069e-04, -4.803545329716146e-05,  3.329942969434202e-06, -1.629407267821337e-07,  6.285797427288744e-09, -2.028495462453836e-10,  5.680735644557854e-12,
 -1.415209226347863e-13,  3.192638613994592e-15, -6.609745130749669e-17,  1.268864144781243e-18, -2.276649779734733e-20,  2.048671263953456e-04, -2.956667387125386e-05,
  2.270807495590025e-06, -1.223104065529915e-07,  5.165654818160546e-09, -1.816616148447214e-10,  5.521796621402833e-12, -1.487840398490634e-13,  3.618982686146907e-15,
 -8.055645224898836e-17,  1.658442658414336e-18, -3.183617378569946e-20,  1.106860432238403e-04, -1.770315126917983e-05,  1.497968463426257e-06, -8.839526884324812e-08,
  4.070375583379948e-09, -1.554165672362517e-10,  5.110292145855482e-12, -1.484700636410138e-13,  3.882562654880649e-15, -9.266899395486998e-17,  2.040752172694028e-18,
 -4.181072315733107e-20,  5.874278250800480e-05, -1.034395180834202e-05,  9.592216828085043e-07, -6.173475349384650e-08,  3.087115575672617e-09, -1.275228488159349e-10,
  4.521146784639247e-12, -1.412038298610986e-13,  3.958673350971050e-15, -1.010447928611419e-16,  2.374281608771115e-18, -5.179211490477342e-20,  3.071036663090929e-05,
 -5.917347344525870e-06,  5.983593293030805e-07, -4.181905960543680e-08,  2.262256456820570e-09, -1.007475339712743e-10,  3.838988165467658e-12, -1.285077035728237e-13,
  3.851663030796306e-15, -1.048629850735854e-16,  2.622545044374332e-18, -6.076550861642632e-20,  1.586297282972438e-05, -3.325295804240818e-06,  3.649124030162841e-07,
 -2.757934561494765e-08,  1.607926729356975e-09, -7.693637220411883e-11,  3.140991191432760e-12, -1.123618351592197e-13,  3.590521015926548e-15, -1.039946192680051e-16,
  2.761343918120607e-18, -6.780025015105442e-20,  8.121228665013137e-06, -1.842030274976438e-06,  2.183647469137875e-07, -1.777446856334470e-08,  1.112754282452305e-09,
 -5.701327658513060e-11,  2.486047000076393e-12, -9.476225695369209e-14,  3.219602548260344e-15, -9.894805628177671e-17,  2.782611995703691e-18, -7.222923941297131e-20,
  4.134537027497308e-06, -1.009411337080172e-06,  1.286929807019418e-07, -1.123744098189496e-08,  7.527028253821402e-10, -4.115913758166078e-11,  1.910962514764743e-12,
 -7.739085477598386e-14,  2.788000605244822e-15, -9.068144194962418e-17,  2.694147502098769e-18, -7.375612096184535e-20,  2.100310619112964e-06, -5.491897028704349e-07,
  7.497916413768221e-08, -6.996265139351236e-09,  4.996077175094812e-10, -2.906046517623480e-11,  1.432181792323643e-12, -6.144440269487592e-14,  2.340584320805131e-15,
 -8.035835927609128e-17,  2.515957798780880e-18, -7.246894343168206e-20,  1.068356938419591e-06, -2.977589445442400e-07,  4.335023137531285e-08, -4.305973717043600e-09,
  3.266687760581371e-10, -2.014561641729576e-11,  1.050607474078024e-12, -4.761014440866923e-14,  1.912370688485439e-15, -6.912065111228084e-17,  2.274817923538845e-18,
 -6.877127626238018e-20,  5.461043857371827e-07, -1.614788108028439e-07,  2.496687382309587e-08, -2.630016889674048e-09,  2.112232880169132e-10, -1.376517335077068e-11,
  7.572742872254300e-13, -3.614127259940571e-14,  1.526453637818346e-15, -5.792672275785197e-17,  1.998769895127084e-18, -6.326383530344261e-20,  2.815248949352765e-07,
 -8.792071122864754e-08,  1.437818224664345e-08, -1.600239535773639e-09,  1.355782975057346e-10, -9.305893496530460e-12,  5.383646870411905e-13, -2.697854205800582e-14,
  1.194715227853396e-15, -4.747107225802836e-17,  1.712829016734194e-18, -5.661562231321488e-20,  1.468838573033262e-07, -4.823702343690843e-08,  8.310383540812656e-09,
 -9.735695745861496e-10,  8.670918695256148e-11, -6.247571315749488e-12,  3.788751285013506e-13, -1.987515466674018e-14,  9.201486781161319e-16, -3.817485520216461e-17,
  1.436461560295293e-18, -4.945576358685404e-20,  7.782632147384296e-08, -2.676157648048959e-08,  4.837925112322243e-09, -5.943592874200288e-10,  5.545015159554002e-11,
 -4.179866708688497e-12,  2.648583498185544e-13, -1.449968554404214e-14,  6.997101061628693e-16, -3.022391033985210e-17,  1.182772191713295e-18, -4.230258726933759e-20,
  4.201005168730479e-08, -1.506291046069274e-08,  2.846117858226649e-09, -3.653105535883900e-10,  3.557311259354627e-11, -2.795840562735598e-12,  1.845047686501046e-13,
 -1.050788973781255e-14,  5.269506072884627e-16, -2.362895642089678e-17,  9.589601982591238e-19, -3.553209623409256e-20,  2.316718836420544e-08, -8.626465355485090e-09,
  1.696952168386436e-09, -2.267078521135664e-10,  2.295975562143499e-11, -1.874930279863012e-12,  1.284331729760032e-13, -7.584957182387350e-15,  3.940538735169096e-16,
 -1.828817526911801e-17,  7.674882994326719e-19, -2.937823801160558e-20,  1.308164600907857e-08, -5.038462104639548e-09,  1.027843564419480e-09, -1.423868127926641e-10,
  1.494269646732204e-11, -1.263420684407993e-12,  8.952898820622963e-14, -5.464920156257402e-15,  2.931952478329737e-16, -1.404034894846917e-17,  6.074794110773968e-19,
 -2.395331768900846e-20,  7.574080592318832e-09, -3.005729672527279e-09,  6.333908797479771e-10, -9.063720410343432e-11,  9.820249472666450e-12, -8.566288597821713e-13,
  6.257944028552914e-14, -3.934983350046403e-15,  2.173092423774602e-16, -1.070383120431223e-17,  4.760133893431077e-19, -1.927733004241905e-20,  4.497049443841013e-09,
 -1.831782667619714e-09,  3.971810486548949e-10, -5.848549126444279e-11,  6.517776047107269e-12, -5.844491191313147e-13,  4.386130986012620e-14, -2.831402684537122e-15,
  1.604205830843331e-16, -8.101463647234273e-18,  3.691572175405734e-19, -1.530784255919592e-20,  2.732896848648003e-09, -1.138330747894254e-09,  2.529727186226591e-10,
 -3.818366738677938e-11,  4.360365736363901e-12, -4.004512120938890e-13,  3.076286907280099e-14, -2.031633546358137e-15,  1.176951543825962e-16, -6.074021782871342e-18,
  2.826852052891331e-19, -1.196551204228138e-20,  1.690770569356666e-09, -7.175120265609820e-10,  1.627873036854706e-10, -2.508851346779691e-11,  2.924516509872004e-12,
 -2.740565896159929e-13,  2.147245272057336e-14, -1.445646764383248e-15,  8.533642797702693e-17, -4.485496862390261e-18,  2.125193724314392e-19, -9.153236607613856e-21,
  1.052349382007054e-09, -4.533444139229726e-10,  1.045920118698230e-10, -1.639446273238913e-11,  1.943268883948224e-12, -1.851136490729225e-13,  1.473817596219644e-14,
 -1.007920466917065e-15,  6.041398239102999e-17, -3.223226272221027e-18,  1.549519019801495e-19, -6.768901243646666e-21,  6.419591455391815e-10, -2.797334300888032e-10,
  6.537079116503247e-11, -1.038029687930397e-11,  1.246263522957939e-12, -1.202201791207551e-13,  9.690078667434666e-15, -6.707053097388750e-16,  4.067624899282292e-17,
 -2.195174294602719e-18,  1.067157542182502e-19, -4.712709037499325e-21,  3.592429743370396e-10, -1.577810521607990e-10,  3.720072945541328e-11, -5.960453828202270e-12,
  7.220043480783191e-13, -7.025835853120417e-14,  5.711605902652739e-15, -3.986470602156424e-16,  2.437463709801868e-17, -1.325933300325969e-18,  6.496100415469251e-20,
 -2.890509519452180e-21,  1.436157122049238e-10, -6.335357092059837e-11,  1.501109153477602e-11, -2.417191397823434e-12,  2.942524819271263e-13, -2.877323226797867e-14,
  2.350254110527046e-15, -1.648027158243018e-16,  1.012245381620321e-17, -5.530876897787115e-19,  2.721467395325574e-20, -1.216050884566740e-21,  6.791235614289007e-02,
 -1.922734691271742e-04,  5.674557452525761e-07, -1.731348713760163e-09,  5.410593529503543e-12, -1.717732117813951e-14,  5.503765542858788e-17, -1.771611665648107e-19,
  5.710504814602267e-22, -1.839700485039725e-24,  5.915715979375326e-27, -1.897563102472567e-29,  6.492710364292184e-02, -2.429198945903164e-04,  1.076786625379285e-06,
 -4.906639980624120e-09,  2.197989778332542e-11, -9.607439211769342e-14,  4.104835322845135e-16, -1.719758615976189e-18,  7.084828010634209e-21, -2.876310236860828e-23,
  1.152722338185297e-25, -4.566435826468739e-28,  5.935167382958311e-02, -3.301122300692045e-04,  2.105652415146379e-06, -1.266794851650430e-08,  7.182737155656499e-11,
 -3.890511817906925e-13,  2.032296698877098e-15, -1.030308103847172e-17,  5.091863036321435e-20, -2.461282244534193e-22,  1.166671520757103e-24, -5.434172191646061e-27,
  5.188895713753557e-02, -4.303127463596188e-04,  3.627324528083816e-06, -2.724963012496035e-08,  1.887757908700867e-10, -1.231606021706615e-12,  7.661526286905547e-15,
 -4.582111351143748e-17,  2.650379083747162e-19, -1.489326516268784e-21,  8.158790125696819e-24, -4.369289860995802e-26,  4.340210818230925e-02, -5.179772416436839e-04,
  5.519595222277335e-06, -5.062258089839748e-08,  4.205407721298414e-10, -3.245704394923977e-12,  2.363116146023791e-14, -1.639913286811211e-16,  1.092784934798374e-18,
 -7.031296331249192e-21,  4.387186629983855e-23, -2.663490556300689e-25,  3.474994683394731e-02, -5.728847366367417e-04,  7.541257303257938e-06, -8.319484348520047e-08,
  8.171359369659587e-10, -7.361517102665709e-12,  6.194843883307455e-14, -4.929530070382312e-16,  3.741876966061904e-18, -2.727172177508021e-20,  1.918038471043781e-22,
 -1.306875669151590e-24,  2.664860598566355e-02, -5.848467031404268e-04,  9.369056703304312e-06, -1.228221550728998e-07,  1.410227331622278e-09, -1.467619908231696e-11,
  1.413691471697179e-13, -1.278206307344205e-15,  1.095673417592654e-17, -8.970454409221895e-20,  7.054711941183765e-22, -5.353201040104797e-24,  1.958841569409242e-02,
 -5.546369405865485e-04,  1.068340623276003e-05, -1.646848169481526e-07,  2.189810378562608e-09, -2.610273175832686e-11,  2.855477268297956e-13, -2.911896682059399e-15,
  2.798962007297722e-17, -2.556945803028182e-19,  2.234100369329062e-21, -1.876243837297565e-23,  1.381388884280583e-02, -4.915854366515588e-04,  1.126285164644354e-05,
 -2.022721482038822e-07,  3.089861575764194e-09, -4.188240619437980e-11,  5.168673461414259e-13, -5.907657554297031e-15,  6.330115737307094e-17, -6.416253954250191e-19,
  6.194891104034035e-21, -5.728126441919099e-23,  9.355653383429021e-03, -4.093718831904553e-04,  1.104426011014066e-05, -2.291761917846265e-07,  3.993420519805603e-09,
 -6.116472832660477e-11,  8.466074836035395e-13, -1.078716017877138e-14,  1.281924870504591e-16, -1.434730361741123e-18,  1.523618709742448e-20, -1.544210774841417e-22,
  6.092401354362254e-03, -3.217860207856907e-04,  1.012623959305141e-05, -2.409650473835391e-07,  4.759150438264505e-09, -8.190070853948228e-11,  1.264904492211022e-12,
 -1.788083953579754e-14,  2.346086214678720e-16, -2.886900552554248e-18,  3.358284066146247e-20, -3.716160180227147e-22,  3.819809640029016e-03, -2.397240026476564e-04,
  8.721946404849483e-06, -2.363636738634580e-07,  5.260378484163109e-09, -1.011895403491559e-10,  1.735639420336096e-12, -2.710270250185838e-14,  3.910259629684298e-16,
 -5.269931205513543e-18,  6.690826237729514e-20, -8.055229926296527e-22,  2.309337524339913e-03, -1.698818454270726e-04,  7.087434918704066e-06, -2.173309884650880e-07,
  5.420829830999420e-09, -1.160043679302806e-10,  2.200284713962563e-12, -3.780315049120997e-14,  5.975086771685023e-16, -8.788846808205409e-18,  1.213799779206331e-19,
 -1.584816084212807e-21,  1.348507919646584e-03, -1.149096394736576e-04,  5.455174070462715e-06, -1.881454012764628e-07,  5.232927961759542e-09, -1.240251325493591e-10,
  2.590893252359144e-12, -4.879657362736357e-14,  8.420386162888194e-16, -1.347404754847837e-17,  2.017970652212574e-19, -2.849049560386322e-21,  7.619833396328695e-04,
 -7.443108859985624e-05,  3.992276139388297e-06, -1.539943306838902e-07,  4.753236779502113e-09, -1.242477694648103e-10,  2.847872012411121e-12, -5.859246837710338e-14,
  1.100287224309059e-15, -1.909542145364466e-17,  3.092394758846342e-19, -4.708004732664252e-21,  4.174934282154308e-04, -4.631494066624991e-05,  2.788172267305925e-06,
 -1.196437856807601e-07,  4.079840678104582e-09, -1.171510655744882e-10,  2.935684250099276e-12, -6.576267630143732e-14,  1.339778135865189e-15, -2.514556100343688e-17,
  4.391272182472084e-19, -7.190478255327087e-21,  2.222983352863842e-04, -2.777346520327966e-05,  1.864969104195743e-06, -8.858086232638185e-08,  3.322682543917396e-09,
 -1.044099239275115e-10,  2.850638065416410e-12, -6.930891872666325e-14,  1.527411357501442e-15, -3.091661081392600e-17,  5.806983587235863e-19, -1.020146003665596e-20,
  1.153086887877220e-04, -1.610158304401522e-05,  1.199042729250157e-06, -6.273665942101858e-08,  2.577943966894040e-09, -8.832544406889317e-11,  2.618685193138668e-12,
 -6.889430833945540e-14,  1.637691599479237e-15, -3.565487122093707e-17,  7.184771734182199e-19, -1.350907701713573e-20,  5.842152145560157e-05, -9.054286518312138e-06,
  7.436620741624529e-07, -4.266751859234171e-08,  1.913057687078102e-09, -7.121344579467647e-11,  2.285387221760564e-12, -6.486735672606632e-14,  1.658664595683469e-15,
 -3.874095379405706e-17,  8.354764793253981e-19, -1.677381576862039e-20,  2.899377998333867e-05, -4.955042569366410e-06,  4.465645094484495e-07, -2.797309778000165e-08,
  1.363273802608325e-09, -5.494696917334948e-11,  1.902737502171755e-12, -5.809689840855481e-14,  1.593656421288572e-15, -3.983152509870129e-17,  9.170957948011494e-19,
 -1.961550566171623e-20,  1.413790224952215e-05, -2.648258230880788e-06,  2.606053326766358e-07, -1.774781105098194e-08,  9.366569437803887e-10, -4.073871633154496e-11,
  1.517547576602593e-12, -4.970328681428185e-14,  1.458740154102404e-15, -3.891701564470472e-17,  9.543698768492352e-19, -2.169707596339344e-20,  6.795638855006321e-06,
 -1.387277696946089e-06,  1.483668165986692e-07, -1.094040692787846e-08,  6.229926574620732e-10, -2.914348375209287e-11,  1.164277885691955e-12, -4.078885947152517e-14,
  1.277426072798846e-15, -3.628621206055803e-17,  9.455362282546666e-19, -2.279701619976691e-20,  3.231061426866000e-06, -7.149705002067949e-07,  8.272829702813807e-08,
 -6.579074153355826e-09,  4.027901663993231e-10, -2.020009570166258e-11,  8.628593231662844e-13, -3.224377938553947e-14,  1.074716107984116e-15, -3.242337717143807e-17,
  8.956159744829098e-19, -2.284806141134520e-20,  1.525164800227870e-06, -3.639377261011631e-07,  4.536194186815797e-08, -3.875553458555071e-09,  2.542059364524225e-10,
 -1.362297845925095e-11,  6.203337173633627e-13, -2.465644425358915e-14,  8.723279833341502e-16, -2.788114759713263e-17,  8.144430527481787e-19, -2.193405981334928e-20,
  7.174754256366791e-07, -1.837089523845283e-07,  2.456126116499639e-08, -2.245797858663805e-09,  1.572708865464284e-10, -8.977326954555549e-12,  4.344706163998707e-13,
 -1.831622166851701e-14,  6.860008891682508e-16, -2.316953333507115e-17,  7.140020929146517e-19, -2.025241899393049e-20,  3.377085759909690e-07, -9.234166807766962e-08,
  1.318775598331579e-08, -1.285688097812872e-09,  9.579307883697199e-11, -5.805558364259410e-12,  2.977164042274961e-13, -1.327417756471790e-14,  5.248779116981800e-16,
 -1.868488920813997e-17,  6.059425904790029e-19, -1.805911944275353e-20,  1.596970315563280e-07, -4.641587222308820e-08,  7.052116961598270e-09, -7.303112151277195e-10,
  5.769297041702683e-11, -3.700283902360258e-12,  2.004523255826608e-13, -9.425116616885233e-15,  3.923749881871680e-16, -1.468346659413356e-17,  4.998402021661301e-19,
 -1.561449964768446e-20,  7.618586785629610e-08, -2.343112874585326e-08,  3.772021221160463e-09, -4.133997508404550e-10,  3.450573737901183e-11, -2.334444663010059e-12,
  1.331773039578581e-13, -6.584088630325295e-15,  2.877737382836231e-16, -1.129021099550668e-17,  4.023843287334184e-19, -1.314271950653933e-20,  3.681958749488292e-08,
 -1.192966570342598e-08,  2.026743892524253e-09, -2.341988405556192e-10,  2.058212572468206e-11, -1.463936033893624e-12,  8.767371184025951e-14, -4.543776931000666e-15,
  2.079032323996873e-16, -8.527730573690929e-18,  3.173596517772647e-19, -1.081001567778250e-20,  1.810003838176533e-08, -6.151512223531539e-09,  1.098528130353905e-09,
 -1.333403375621407e-10,  1.229456176231994e-11, -9.162651161344643e-13,  5.742114680692604e-14, -3.110022056182263e-15,  1.485290992658490e-16, -6.351386261056781e-18,
  2.461350937995302e-19, -8.720194771676986e-21,  9.085792238781454e-09, -3.225356370832598e-09,  6.030268949408578e-10, -7.659738706332206e-11,  7.383329186676413e-12,
 -5.745747074116397e-13,  3.755541976234824e-14, -2.119026474490857e-15,  1.053095262356571e-16, -4.680968131141833e-18,  1.883636101088476e-19, -6.922089002508862e-21,
  4.673788151592728e-09, -1.725797512044237e-09,  3.364707007631437e-10, -4.455511655869944e-11,  4.473413515269224e-12, -3.622427599340603e-13,  2.461159406734032e-14,
 -1.442008025223912e-15,  7.434016452611247e-17, -3.424440730546468e-18,  1.426713632829532e-19, -5.422930498102308e-21,  2.471173584606084e-09, -9.452678994732267e-10,
  1.914141596511010e-10, -2.632233230210170e-11,  2.742574942248044e-12, -2.302681522625679e-13,  1.620656460224222e-14, -9.827370126746554e-16,  5.238653136772144e-17,
 -2.493046691279483e-18,  1.072140581865253e-19, -4.202759140784574e-21,  1.345881774822691e-09, -5.311826079602406e-10,  1.112705639246835e-10, -1.582837191165349e-11,
  1.704998573943777e-12, -1.478867424181836e-13,  1.074410452848248e-14, -6.719713206168480e-16,  3.691658371634118e-17, -1.809182931028662e-18,  8.006169793468336e-20,
 -3.226861712643437e-21,  7.557165080357696e-10, -3.065230583628690e-10,  6.615509008167520e-11, -9.696350273401753e-12,  1.075676170909627e-12, -9.602810726279875e-14,
  7.175527268620866e-15, -4.612602511819337e-16,  2.602721179616185e-17, -1.309194097554999e-18,  5.942556765913113e-20, -2.454982853393874e-21,  4.369597190812428e-10,
 -1.814347851969248e-10,  4.018101491489280e-11, -6.043884348494095e-12,  6.878251273557973e-13, -6.295868124284873e-14,  4.820820492568029e-15, -3.173697395140909e-16,
  1.832915106705500e-17, -9.431062143867187e-19,  4.376467931952899e-20, -1.847253491940388e-21,  2.589500158820847e-10, -1.096480448318618e-10,  2.481579808130629e-11,
 -3.815166317991750e-12,  4.436494682072199e-13, -4.147599160299707e-14,  3.242160019995629e-15, -2.177897803360202e-16,  1.282798496926747e-17, -6.728355428981810e-19,
  3.181239631322259e-20, -1.367410356250882e-21,  1.555229469747762e-10, -6.690163312028283e-11,  1.541021527561911e-11, -2.411593660247504e-12,  2.853950595884782e-13,
 -2.714395762062310e-14,  2.157823232227266e-15, -1.473508106066047e-16,  8.819309996738520e-18, -4.698674045832523e-19,  2.255718829425899e-20, -9.840725958288919e-22,
  9.227021886476593e-11, -4.017261164006337e-11,  9.378994863731819e-12, -1.487870732697362e-12,  1.784650791498905e-13, -1.719953320439863e-14,  1.385069501003597e-15,
 -9.578343073219984e-17,  5.803946144833791e-18, -3.129569978060194e-19,  1.520150372279843e-20, -6.707813176384430e-22,  5.063598625715116e-11, -2.222987501312929e-11,
  5.238665927124849e-12, -8.389436603965656e-13,  1.015732679350724e-13, -9.879324358045783e-15,  8.027516290140800e-16, -5.600277525087275e-17,  3.422642398566115e-18,
 -1.861023119828536e-19,  9.113680912498441e-21, -4.053509807966571e-22,  2.002233312764561e-11, -8.830703756151834e-12,  2.091875622792599e-12, -3.367688684802876e-13,
  4.098628740769359e-14, -4.006873744241866e-15,  3.272138762014491e-16, -2.293942891416052e-17,  1.408662341494309e-18, -7.695192528547223e-20,  3.785598590025839e-21,
 -1.691184131755778e-22,  6.715221201962505e-02, -1.878154818734483e-04,  5.471878685928016e-07, -1.647457469765972e-09,  5.079864759643384e-12, -1.591393828380120e-14,
  5.032333330951961e-17, -1.599031325544604e-19,  5.088869108868281e-22, -1.618947758532913e-24,  5.141468864402439e-27, -1.629037907020809e-29,  6.397228799795954e-02,
 -2.345352844090669e-04,  1.019955296931693e-06, -4.569814171443345e-09,  2.015315403017613e-11, -8.677593340544813e-14,  3.653547522499151e-16, -1.508759603403407e-18,
  6.127731154869850e-21, -2.453000827771460e-23,  9.694902736159934e-26, -3.788023755922174e-28,  5.806397940702401e-02, -3.138561098458069e-04,  1.960284011006938e-06,
 -1.157840352033794e-08,  6.451164970210519e-11, -3.435616508812883e-13,  1.765351534991600e-15, -8.806895469627068e-18,  4.284345060684880e-20, -2.039113740788505e-22,
  9.519308546942819e-25, -4.367765434414990e-27,  5.022374247362621e-02, -4.025525945963309e-04,  3.317669793087418e-06, -2.441670339198758e-08,  1.658832651717516e-10,
 -1.062214286608390e-12,  6.489640051580866e-15, -3.813834185146669e-17,  2.168611094055734e-19, -1.198393336770273e-21,  6.458149073590750e-24, -3.403196385366700e-26,
  4.141482064948062e-02, -4.761407173982533e-04,  4.950449717837509e-06, -4.438391919898430e-08,  3.609457024440547e-10, -2.729928419991043e-12,  1.949320673846260e-14,
 -1.327552023616700e-16,  8.686127086337911e-19, -5.490115154421153e-21,  3.366313267856090e-23, -2.009047067802549e-25,  3.257304485770392e-02, -5.163364567510151e-04,
  6.616755039270570e-06, -7.122219106622274e-08,  6.837214656485596e-10, -6.027713036922750e-12,  4.968446060247440e-14, -3.875462928025969e-16,  2.885376696716237e-18,
 -2.063703591581611e-20,  1.424985087882939e-22, -9.536283490158502e-25,  2.445030315108850e-02, -5.154272989117823e-04,  8.021451905653967e-06, -1.024338563638980e-07,
  1.147925744600814e-09, -1.167599735855530e-11,  1.100388218454706e-13, -9.742438778780978e-16,  8.183243747845918e-18, -6.568911970756463e-20,  5.067757835094420e-22,
 -3.774026566546693e-24,  1.752907785062935e-02, -4.765163211001410e-04,  8.901316989429538e-06, -1.334779372741276e-07,  1.730172116834446e-09, -2.013469966400094e-11,
  2.152843574341845e-13, -2.147756425792883e-15,  2.021224738121111e-17, -1.808971554950368e-19,  1.549360140473044e-21, -1.276137092294322e-23,  1.201348780819137e-02,
 -4.104107899973206e-04,  9.106609117949797e-06, -1.589139332058959e-07,  2.363961306135850e-09, -3.125341360325147e-11,  3.766537714508275e-13, -4.208302495818183e-15,
  4.411553964143648e-17, -4.377816499019266e-19,  4.140700681936237e-21, -3.752798042795731e-23,  7.878875972528314e-03, -3.310183250392865e-04,  8.640459753082413e-06,
 -1.740587702846728e-07,  2.951053929959289e-09, -4.405091718797986e-11,  5.949999000140233e-13, -7.405902727771813e-15,  8.605012054383847e-17, -9.423344385795055e-19,
  9.798133366299117e-21, -9.728844139855157e-23,  4.950639683545706e-03, -2.511624973448776e-04,  7.642395069165495e-06, -1.764294258827640e-07,  3.388167837786275e-09,
 -5.679011348084585e-11,  8.554000120028200e-13, -1.180589916082865e-14,  1.513749648920028e-16, -1.821734195196656e-18,  2.074031831643481e-20, -2.247538505861495e-22,
  2.984335409488256e-03, -1.800033535161572e-04,  6.330476581859024e-06, -1.663593263000325e-07,  3.598297937351007e-09, -6.738516701380824e-11,  1.126738930120505e-12,
 -1.717104211593338e-14,  2.420035822336292e-16, -3.188673285194753e-18,  3.960842677647888e-20, -4.668426131737235e-22,  1.728562548757370e-03, -1.222991145616096e-04,
  4.931696525347351e-06, -1.466136932363111e-07,  3.553110862204946e-09, -7.400074661754990e-11,  1.367880585971407e-12, -2.292958193199250e-14,  3.539411534562065e-16,
 -5.088654496104248e-18,  6.874249451661062e-20, -8.785280254540988e-22,  9.636390755290947e-04, -7.904454014950871e-05,  3.627728750873439e-06, -1.212990515759104e-07,
  3.277588022926561e-09, -7.559256068835784e-11,  1.538731503279211e-12, -2.827083402001895e-14,  4.763659199602722e-16, -7.449665265286000e-18,  1.091220263760540e-19,
 -1.507837756925841e-21,  5.180354162657505e-04, -4.875896088853601e-05,  2.529312791339134e-06, -9.460214993694123e-08,  2.837031040469338e-09, -7.216617885424824e-11,
  1.611794785225816e-12, -3.234915734455062e-14,  5.931737661050778e-16, -1.006078792600667e-17,  1.593515717288976e-19, -2.374429747499993e-21,  2.691113036221923e-04,
 -2.879873417276465e-05,  1.677670185258971e-06, -6.983090606879509e-08,  2.314118812846489e-09, -6.467525861067100e-11,  1.579460613492368e-12, -3.451957651490616e-14,
  6.867895685721939e-16, -1.259874749078892e-17,  2.152104835717819e-19, -3.449386505100012e-21,  1.354053668795284e-04, -1.633929020902343e-05,  1.062517302243493e-06,
 -4.897850428678056e-08,  1.786145402017069e-09, -5.464679291950671e-11,  1.454447358248980e-12, -3.450995650454166e-14,  7.428839443271447e-16, -1.470049712234479e-17,
  2.701437534849380e-19, -4.646372795203873e-21,  6.615641625530179e-05, -8.934340171290090e-06,  6.448867563953867e-07, -3.276964143347295e-08,  1.309878757190432e-09,
 -4.371677559624882e-11,  1.264051782271798e-12, -3.246642621420358e-14,  7.541400553235069e-16, -1.605703169600341e-17,  3.166718756818110e-19, -5.831394081344248e-21,
  3.147325269485818e-05, -4.724240517247112e-06,  3.764984892975230e-07, -2.099672661263387e-08,  9.164286477087811e-10, -3.325131040687951e-11,  1.041288534739316e-12,
 -2.886911082105553e-14,  7.216838549471530e-16, -1.649253241720612e-17,  3.482536899184302e-19, -6.850662220732765e-21,  1.462346783038193e-05, -2.424201096466203e-06,
  2.122395700780825e-07, -1.293524578943089e-08,  6.141905046285704e-10, -2.414740230134970e-11,  8.165300809669920e-13, -2.436817634188225e-14,  6.538988667608071e-16,
 -1.600012571941507e-17,  3.609089051823916e-19, -7.567565037264684e-21,  6.657487269033380e-06, -1.211620329826257e-06,  1.159772243369640e-07, -7.693204455338810e-09,
  3.959634111980137e-10, -1.681414823608361e-11,  6.121148655053709e-13, -1.961037065749088e-14,  5.634293758985964e-16, -1.472590633420298e-17,  3.540251421109936e-19,
 -7.895351718726936e-21,  2.980173270482762e-06, -5.921001540759723e-07,  6.168228588882869e-08, -4.435702919442420e-09,  2.466054355446141e-10, -1.127438819393022e-11,
  4.405945081999544e-13, -1.511183939325907e-14,  4.636985522516139e-16, -1.291425927058284e-17,  3.301521905561038e-19, -7.814282777712353e-21,  1.316652574818029e-06,
 -2.840562645806163e-07,  3.206361425526543e-08, -2.490044188708634e-09,  1.490180328999474e-10, -7.311938085611865e-12,  3.058481050505286e-13, -1.120044447446647e-14,
  3.661139081389874e-16, -1.083926250584675e-17,  2.940000370572707e-19, -7.369080993811267e-21,  5.764096425143767e-07, -1.343464819441506e-07,  1.636136545117133e-08,
 -1.366990210875180e-09,  8.776179835861029e-11, -4.607257952606055e-12,  2.056754328335494e-13, -8.020187873654589e-15,  2.785597591778183e-16, -8.745820227486074e-18,
  2.511022140487684e-19, -6.650420641699681e-21,  2.511032588440739e-07, -6.291781330326391e-08,  8.232654691226576e-09, -7.372578072354451e-10,  5.060506422311112e-11,
 -2.833441208672720e-12,  1.346026312606238e-13, -5.573638947494357e-15,  2.051643637128371e-16, -6.814214040054655e-18,  2.066095066390270e-19, -5.769062091017297e-21,
  1.093338460940121e-07, -2.931118902702703e-08,  4.103877555851783e-09, -3.924679378542600e-10,  2.870390522904113e-11, -1.708744706630730e-12,  8.612629236254085e-14,
 -3.776569862559317e-15,  1.469421196174727e-16, -5.149949823594897e-18,  1.645058013421261e-19, -4.831617464851743e-21,  4.780060725766081e-08, -1.364759186623293e-08,
  2.036369103767367e-09, -2.072043928238597e-10,  1.609236263906514e-11, -1.015291967775355e-12,  5.413389114498276e-14, -2.506557970935047e-15,  1.028117967623995e-16,
 -3.792505841627714e-18,  1.273147760317355e-19, -3.923897280195040e-21,  2.108333130680597e-08, -6.381713229371448e-09,  1.010731832177442e-09, -1.090212424160444e-10,
  8.960351561308890e-12, -5.972141043744443e-13,  3.358176159289029e-14, -1.637194771810577e-15,  7.059625678432305e-17, -2.733648887096427e-18,  9.619813438492032e-20,
 -3.103631212234518e-21,  9.426493993163292e-09, -3.011572277035905e-09,  5.042599680495614e-10, -5.744509093392573e-11,  4.979087094557101e-12, -3.494311943881652e-13,
  2.065737492210688e-14, -1.057227112830224e-15,  4.778917531094141e-17, -1.937234130648489e-18,  7.127482930179135e-20, -2.401060019000462e-21,  4.292741676576657e-09,
 -1.441202099576439e-09,  2.541041234385631e-10, -3.045846361465150e-11,  2.774294406735727e-12, -2.043212176045157e-13,  1.265833490749106e-14, -6.780093499399703e-16,
  3.203320268263572e-17, -1.355553462755278e-18,  5.200167637456845e-20, -1.824332193058208e-21,  2.000330062317807e-09, -7.026986605684425e-10,  1.299384296716161e-10,
 -1.632619476121319e-11,  1.557084834239407e-12, -1.199302280589166e-13,  7.760891185074935e-15, -4.336747570438881e-16,  2.135068477136153e-17, -9.404135763135342e-19,
  3.750912296061838e-20, -1.366639575910340e-21,  9.579264693691263e-10, -3.506167583572614e-10,  6.772160058810456e-11, -8.884910420576788e-12,  8.840242777914926e-13,
 -7.095832456699056e-14,  4.780061699615285e-15, -2.777549321452534e-16,  1.420447288111596e-17, -6.492354242518680e-19,  2.684478103475052e-20, -1.012908243634389e-21,
  4.732451557888780e-10, -1.797209762165605e-10,  3.611176193435462e-11, -4.927778961419148e-12,  5.095776513044046e-13, -4.247151869683887e-14,  2.967955714468536e-15,
 -1.787295409217468e-16,  9.463662377524447e-18, -4.474410816576076e-19,  1.912076923190608e-20, -7.449407392048451e-22,  2.419172928232436e-10, -9.492760840791218e-11,
  1.976103670283903e-11, -2.793545924596793e-12,  2.990807034879336e-13, -2.578731873918968e-14,  1.862649583420015e-15, -1.158423201234907e-16,  6.329419679592369e-18,
 -3.085454461529397e-19,  1.358382094023663e-20, -5.447624929326868e-22,  1.281781725647496e-10, -5.175762309132702e-11,  1.111608998290018e-11, -1.621347843260286e-12,
  1.790062610053505e-13, -1.590577569090659e-14,  1.183135863422107e-15, -7.571922589684203e-17,  4.254234261129583e-18, -2.131004675481921e-19,  9.633669898634908e-21,
 -3.964232130449805e-22,  7.036559050698824e-11, -2.912032564742215e-11,  6.425529190348637e-12, -9.629716975764467e-13,  1.091974023398021e-13, -9.960097831980540e-15,
  7.600505596573588e-16, -4.987019375724757e-17,  2.870860025206216e-18, -1.472528388281844e-19,  6.812373509214453e-21, -2.866905115720141e-22,  3.986551888268225e-11,
 -1.684100410666483e-11,  3.801647330588072e-12, -5.829465880488328e-13,  6.761529319731831e-14, -6.305455749012284e-15,  4.916956125956505e-16, -3.295107906100717e-17,
  1.936371925315532e-18, -1.013362626106953e-19,  4.780845713078640e-21, -2.050633881154243e-22,  2.306410853294795e-11, -9.906429559797836e-12,  2.277989691415102e-12,
 -3.558811133788611e-13,  4.204513552396765e-14, -3.992331950868020e-15,  3.168625477118549e-16, -2.160364616533313e-17,  1.291060246836255e-18, -6.868188659613192e-20,
  3.292487170742575e-21, -1.434356133698483e-22,  1.328987685128254e-11, -5.780968681974319e-12,  1.348314372343918e-12, -2.136782876534848e-13,  2.560438270612401e-14,
 -2.465200146644670e-15,  1.983312994920283e-16, -1.370264204270262e-17,  8.295482183955965e-19, -4.469070934342520e-20,  2.168918526503784e-21, -9.562520129385697e-23,
  7.144964069023232e-12, -3.135302934307504e-12,  7.384816709719406e-13, -1.182021708592659e-13,  1.430368175324442e-14, -1.390513370337911e-15,  1.129309554283359e-16,
 -7.874624186687255e-18,  4.810330831181179e-19, -2.614345279111513e-20,  1.279697447041327e-21, -5.689211097321025e-23,  2.792855318645494e-12, -1.231508115379411e-12,
  2.916577373071020e-13, -4.694217066828284e-14,  5.711677543800215e-15, -5.582461172027506e-16,  4.557725078092909e-17, -3.194456063652230e-18,  1.961194783373468e-19,
 -1.071110903969667e-20,  5.268078653098609e-22, -2.352952750086415e-23,  6.640958181056558e-02, -1.835156989303125e-04,  5.278957512578463e-07, -1.568661731958134e-09,
  4.773310220270069e-12, -1.475811806936217e-14,  4.606554026354039e-17, -1.445129328802145e-19,  4.541403104493314e-22, -1.426926552485753e-24,  4.476185732069215e-27,
 -1.401095470989796e-29,  6.305012640792333e-02, -2.265896403298062e-04,  9.669964624952050e-07, -4.260785408647531e-09,  1.850200978322608e-11, -7.849299469480099e-14,
  3.257271036650085e-16, -1.326084448984409e-18,  5.310618332292391e-21, -2.096569952008661e-23,  8.173062820856017e-26, -3.150230274632451e-28,  5.683906365547072e-02,
 -2.987125616208828e-04,  1.827316770729743e-06, -1.059896610962345e-08,  5.804489981680905e-11, -3.040039381785699e-13,  1.536899055592241e-15, -7.546368967687747e-18,
  3.614413792284741e-20, -1.694145911411037e-22,  7.790636113611117e-25, -3.521886238253461e-27,  4.866482078009466e-02, -3.771396790987983e-04,  3.039919537478224e-06,
 -2.192441240694004e-08,  1.461138850984660e-10, -9.185313891910489e-13,  5.512773746462964e-15, -3.184199085887838e-17,  1.780293832543167e-19, -9.676893002083059e-22,
  5.131038893862348e-24, -2.661113235217872e-26,  3.958622513053204e-02, -4.385733609436821e-04,  4.450770739309494e-06, -3.902136693739340e-08,  3.107399050442724e-10,
 -2.303730045182183e-12,  1.613724438724283e-14, -1.078783724950789e-16,  6.932174783446696e-19, -4.305018769293954e-21,  2.594554033689559e-23, -1.522502314770515e-25,
  3.060840520308480e-02, -4.666438681504543e-04,  5.823947936317947e-06, -6.118580331548902e-08,  5.742636663040853e-10, -4.955717093886914e-12,  4.002151782789939e-14,
 -3.060781952201634e-16,  2.235677281761594e-18, -1.569546072927821e-20,  1.064265124060117e-22, -6.996833885089267e-25,  2.250957073828965e-02, -4.558771322142410e-04,
  6.895181027609867e-06, -8.580048250791149e-08,  9.387496702872296e-10, -9.334873814333173e-12,  8.609669578976196e-14, -7.466078666227279e-16,  6.146551148676334e-18,
 -4.838746836782578e-20,  3.662752184080077e-22, -2.677579397283519e-24,  1.575591553078091e-02, -4.112709966390206e-04,  7.453245862566276e-06, -1.087552093313270e-07,
  1.374628923720139e-09, -1.562204917867522e-11,  1.633025618046113e-13, -1.594218317586354e-15,  1.469222208438116e-17, -1.288528576393336e-19,  1.082048557676627e-21,
 -8.742562350901682e-24,  1.050632185474890e-02, -3.445872904105089e-04,  7.407442994399702e-06, -1.256373109014955e-07,  1.820512063540694e-09, -2.348168559201969e-11,
  2.764262610282524e-13, -3.019774001602314e-15,  3.097735989565007e-17, -3.010224104888406e-19,  2.789764206149929e-21, -2.478766662967382e-23,  6.680872437113018e-03,
 -2.695090264884616e-04,  6.808315369520328e-06, -1.331794568386382e-07,  2.197523284193961e-09, -3.197698086676406e-11,  4.215795456990783e-13, -5.127091751098056e-15,
  5.825757376310267e-17, -6.243633363927378e-19,  6.357547037698811e-21, -6.185474472792352e-23,  4.056055121072562e-03, -1.976499621374904e-04,  5.816352830216618e-06,
 -1.302929847544469e-07,  2.433476942905331e-09, -3.973524212044292e-11,  5.838300760625373e-13, -7.868641115505085e-15,  9.861287965343392e-17, -1.160871114834960e-18,
  1.293695351425604e-20, -1.373118021054380e-22,  2.354224124415400e-03, -1.364596832476859e-04,  4.639474887898708e-06, -1.182479014132955e-07,  2.486177311442859e-09,
 -4.533387247141625e-11,  7.390776776855021e-13, -1.099396372563685e-14,  1.513837689406029e-16, -1.950388771271016e-18,  2.370627689730796e-20, -2.735834532634104e-22,
  1.308360071027612e-03, -8.901844315531258e-05,  3.469822888629682e-06, -1.000175815317883e-07,  2.355342656253716e-09, -4.774811466845722e-11,  8.602644067865618e-13,
 -1.407128275381791e-14,  2.121487564187646e-16, -2.981588446377676e-18,  3.940270392769205e-20, -4.929482324906888e-22,  6.974078833329797e-04, -5.505664574854372e-05,
  2.442729941787056e-06, -7.918699633787101e-08,  2.078865047386170e-09, -4.666008285451901e-11,  9.255716374952645e-13, -1.659047852081876e-14,  2.729963960277923e-16,
 -4.172712273530875e-18,  5.978428067603775e-20, -8.085716481848154e-22,  3.572391202249566e-04, -3.239111267189060e-05,  1.624863392389326e-06, -5.892772695017550e-08,
  1.716980690724933e-09, -4.250276749292923e-11,  9.250240244447000e-13, -1.811155015027265e-14,  3.243003698872527e-16, -5.375792449475945e-18,  8.328045651938883e-20,
 -1.214573112263158e-21,  1.762260161681860e-04, -1.818620814747858e-05,  1.025039685484501e-06, -4.138221355985517e-08,  1.332644938212975e-09, -3.624964759220599e-11,
  8.627300805214259e-13, -1.839562345128415e-14,  3.574175868726385e-16, -6.408468020038047e-18,  1.070772197537510e-19, -1.679910513261942e-21,  8.391622782568521e-05,
 -9.776484003895775e-06,  6.155282548829493e-07, -2.753287281211164e-08,  9.760590360098146e-10, -2.907241209908329e-11,  7.542526944705371e-13, -1.746372582625982e-14,
  3.671982612973970e-16, -7.103403159114297e-18,  1.277069546807766e-19, -2.150417148141684e-21,  3.867396700450062e-05, -5.048998959767558e-06,  3.531459246721627e-07,
 -1.742403209104215e-08,  6.773910648780580e-10, -2.201901602437044e-11,  6.208395558816464e-13, -1.556575353256508e-14,  3.532745934670144e-16, -7.355485714584032e-18,
  1.419604092270643e-19, -2.560020218166253e-21,  1.729943853856415e-05, -2.513742680133656e-06,  1.943159098869089e-07, -1.053030772450263e-08,  4.473035365476042e-10,
 -1.581613044878494e-11,  4.832241197868863e-13, -1.308385302834240e-14,  3.197162940078065e-16, -7.147798348547786e-18,  1.477634254384950e-19, -2.847653670350189e-21,
  7.534366365013518e-06, -1.210902894218477e-06,  1.029460687512378e-07, -6.102423904058094e-09,  2.822210488113990e-10, -1.082058442653364e-11,  3.572048212955376e-13,
 -1.041720985455054e-14,  2.733995229532311e-16, -6.548008990330069e-18,  1.446745678579698e-19, -2.973377255899408e-21,  3.205869462982426e-06, -5.665431520852957e-07,
  5.272564668750639e-08, -3.405324109860977e-09,  1.708706915056387e-10, -7.081819325287722e-12,  2.518848123320010e-13, -7.891327511448722e-15,  2.218998791741956e-16,
 -5.680401261366280e-18,  1.338472243627292e-19, -2.927568226135605e-21,  1.337635818385074e-06, -2.584917082225449e-07,  2.621705527519249e-08, -1.837804118121175e-09,
  9.971448928577791e-11, -4.453729585278936e-12,  1.701987497800385e-13, -5.713381420374810e-15,  1.717153474018813e-16, -4.687602340374909e-18,  1.175409611336866e-19,
 -2.730421049990221e-21,  5.494891640984229e-07, -1.155061175562785e-07,  1.271215207681270e-08, -9.635797566485134e-10,  5.634388095970998e-11, -2.703861563513570e-12,
  1.107086894021785e-13, -3.971752049309310e-15,  1.272776761058423e-16, -3.696732439408787e-18,  9.842813442895983e-20, -2.423251214061171e-21,  2.231892172978952e-07,
 -5.077702724797642e-08,  6.038658292001785e-09, -4.931349048472736e-10,  3.097336114201662e-11, -1.592154899693686e-12,  6.965198690404267e-14, -2.663574508586023e-15,
  9.078711750928540e-17, -2.799023105232260e-18,  7.896086249769564e-20, -2.055947567800797e-21,  9.004672508464169e-08, -2.206467977820079e-08,  2.823920953668145e-09,
 -2.475463612290074e-10,  1.664603305105006e-11, -9.137969120803194e-13,  4.259164655349927e-14, -1.731567468883938e-15,  6.261895525520525e-17, -2.044456453892951e-18,
  6.096895439294407e-20, -1.675295378648912e-21,  3.626168963595553e-08, -9.524920484449619e-09,  1.306617839133569e-09, -1.225073315777267e-10,  8.790472672313697e-12,
 -5.137639574575594e-13,  2.544033149737928e-14, -1.096610909439900e-15,  4.196813406083098e-17, -1.447535191737149e-18,  4.552816659522630e-20, -1.317285005749733e-21,
  1.464950625824788e-08, -4.105967883356658e-09,  6.013155024876236e-10, -6.008354663279210e-11,  4.585155639776210e-12, -2.844257708502355e-13,  1.491920114117509e-14,
 -6.799752153687249e-16,  2.746780644205499e-17, -9.983583271480518e-19,  3.303842756014229e-20, -1.004239147486521e-21,  5.968814536416746e-09, -1.777022212940964e-09,
  2.767281046968133e-10, -2.936073737675015e-11,  2.374907338844743e-12, -1.558652752531631e-13,  8.634659420034947e-15, -4.149337214723799e-16,  1.764410993563698e-17,
 -6.740508868295991e-19,  2.341156213519026e-20, -7.458107332984479e-22,  2.466024448896715e-09, -7.763841653300442e-10,  1.280507930576080e-10, -1.437341718475499e-11,
  1.228080740968688e-12, -8.499798041415186e-14,  4.957785824694125e-15, -2.504580377227398e-16,  1.117969385723281e-17, -4.476999326488558e-19,  1.627826223244963e-20,
 -5.421315348814245e-22,  1.038785290077635e-09, -3.443223551773680e-10,  5.990700876799865e-11, -7.087588198560627e-12,  6.374191985999754e-13, -4.637005884928052e-14,
  2.838709010378994e-15, -1.503015374219830e-16,  7.022120138373851e-18, -2.939506598959445e-19,  1.115855393439475e-20, -3.875000221601816e-22,  4.485564577267863e-10,
 -1.558551981602218e-10,  2.848955502255411e-11, -3.539140738095174e-12,  3.338241156374899e-13, -2.543713652820949e-14,  1.629025707569262e-15, -9.011490905163136e-17,
  4.393341665574397e-18, -1.916822207575987e-19,  7.575360043280808e-21, -2.735582363775212e-22,  1.995780100276845e-10, -7.237728804942096e-11,  1.384338008448419e-11,
 -1.798696770839980e-12,  1.772803197178338e-13, -1.409961177979692e-14,  9.413763764684715e-16, -5.422933677988602e-17,  2.750132590233039e-18, -1.246797472251103e-19,
  5.114741864163948e-21, -1.915190132352565e-22,  9.192893840273392e-11, -3.464673037690836e-11,  6.905188881348932e-12, -9.346897686535684e-13,  9.589471241133734e-14,
 -7.931277004783307e-15,  5.501233724866003e-16, -3.288909852806364e-17,  1.729263133716905e-18, -8.120339482890246e-20,  3.447205901748362e-21, -1.334434317953185e-22,
  4.400798462379696e-11, -1.716366617736432e-11,  3.549497130940702e-12, -4.984997291175304e-13,  5.302842373503945e-14, -4.543706935430666e-15,  3.262084922971754e-16,
 -2.016821737970025e-17,  1.095658025396571e-18, -5.311457539458308e-20,  2.325788213034291e-21, -9.278595362371410e-23,  2.195261010789211e-11, -8.822549970575132e-12,
  1.885103309370453e-12, -2.735432311257879e-13,  3.004883949821206e-14, -2.656922052021466e-15,  1.966895602950284e-16, -1.252951507675237e-17,  7.007913201499407e-19,
 -3.495000914753201e-20,  1.573275942074701e-21, -6.447329326476934e-23,  1.141663284099682e-11, -4.708129807403619e-12,  1.034869089637528e-12, -1.544942927130370e-13,
  1.745273674245887e-14, -1.586012907754823e-15,  1.205924502983019e-16, -7.884904909656909e-18,  4.523639471668395e-19, -2.312608214535510e-20,  1.066448697945231e-21,
 -4.474051539883677e-23,  6.170906061540461e-12, -2.600438221888302e-12,  5.854144283202371e-13, -8.952186168324292e-14,  1.035555993965372e-14, -9.631643532996406e-16,
  7.491433773466050e-17, -5.007869270826920e-18,  2.935733970146445e-19, -1.532733559078733e-20,  7.214544569124613e-22, -3.087628886331802e-23,  3.432959857088037e-12,
 -1.472140539569500e-12,  3.379128320259404e-13, -5.269555701788079e-14,  6.214592515671197e-15, -5.890718423343737e-16,  4.667409610638859e-17, -3.176981098431758e-18,
  1.895552390893226e-19, -1.006820475581873e-20,  4.819176736639028e-22, -2.096352967942557e-23,  1.918379325576043e-12, -8.336878323037217e-13,  1.942380092140279e-13,
 -3.074961551349264e-14,  3.680746446631816e-15, -3.540179915104196e-16,  2.845288941463994e-17, -1.963867496923854e-18,  1.187771946327921e-19, -6.392973510255433e-21,
  3.099799296336726e-22, -1.365459052920379e-23,  1.009331728662734e-12, -4.426953697952293e-13,  1.042150549694481e-13, -1.667164853896902e-14,  2.016348588572181e-15,
 -1.959122854088389e-16,  1.590277491837721e-17, -1.108327398532473e-18,  6.767004556070757e-20, -3.675976171812112e-21,  1.798498652967280e-22, -7.991959495388981e-24,
  3.897726758323815e-13, -1.718323648193232e-13,  4.068487402859668e-14, -6.546547084559889e-15,  7.963478202167409e-16, -7.781368341021051e-17,  6.351422892218009e-18,
 -4.450554292572045e-19,  2.731705558270912e-20, -1.491575628502718e-21,  7.334364192767474e-23, -3.275101686216513e-24,  6.568384793243211e-02, -1.793665523917884e-04,
  5.095204987891599e-07, -1.494591344674950e-09,  4.488884123174399e-12, -1.369950553613378e-14,  4.221515003796251e-17, -1.307689663608694e-19,  4.058506802929422e-22,
 -1.259615382214795e-24,  3.903486826755715e-27, -1.207224278498009e-29,  6.215892292118614e-02, -2.190532703938937e-04,  9.175927673439336e-07, -3.976899670675383e-09,
  1.700741320012665e-11, -7.110258088358114e-14,  2.908667760115689e-16, -1.167616074417387e-18,  4.611507280310529e-21, -1.795752578617769e-23,  6.905943191903275e-26,
 -2.626266476931984e-28,  5.567266665189015e-02, -2.845874390282998e-04,  1.705507146270045e-06, -9.716953786451521e-09,  5.231721396915274e-11, -2.695286712618326e-13,
  1.340917613557060e-15, -6.481615346597115e-18,  3.057071841649695e-20, -1.411420139470184e-22,  6.394641260847686e-25, -2.848687327482919e-27,  4.720328884500283e-02,
 -3.538343025405827e-04,  2.790269775538368e-06, -1.972665856331052e-08,  1.289973007774698e-10, -7.963108016333053e-13,  4.695987719722441e-15, -2.666500883657926e-17,
  1.466212502628345e-19, -7.840731456392205e-22,  4.091406973589792e-24, -2.088783179378702e-26,  3.790029326835813e-02, -4.047590692647270e-04,  4.010890367401478e-06,
 -3.439806596749758e-08,  2.683059468871884e-10, -1.950312990969246e-12,  1.340526824534956e-14, -8.798720591098286e-17,  5.554089592976062e-19, -3.389710251122634e-21,
  2.008423752423061e-23, -1.159038182673197e-25,  2.883057377255055e-02, -4.228402110276488e-04,  5.141738260493933e-06, -5.274108615983614e-08,  4.840999705585377e-10,
 -4.090452873977041e-12,  3.237349460275665e-14, -2.428121323883033e-16,  1.740387707674850e-18, -1.199576376463018e-20,  7.989312730912381e-23, -5.160997394941636e-25,
  2.079020691964055e-02, -4.045922605727400e-04,  5.949879360358357e-06, -7.216852500301793e-08,  7.711304815370752e-10, -7.498701319214842e-12,  6.770235727219338e-14,
 -5.751771150329334e-16,  4.642199377947502e-18, -3.584727492306969e-20,  2.663032375813694e-22, -1.911378735922528e-24,  1.422231628833616e-02, -3.565138143838611e-04,
  6.270487682798904e-06, -8.906200112104736e-08,  1.098022278336032e-09, -1.218932310261098e-11,  1.246046781523068e-13, -1.190631484494653e-15,  1.074800409659186e-17,
 -9.238890116927897e-20,  7.608452536421299e-22, -6.031472002026753e-24,  9.237598149964193e-03, -2.908966433413558e-04,  6.060160169299803e-06, -9.993258179408626e-08,
  1.410910863928879e-09, -1.775937816847618e-11,  2.042633322460219e-13, -2.182316981074091e-15,  2.191138278084319e-17, -2.085474071140599e-19,  1.894147607337593e-21,
 -1.650262011115192e-23,  5.702431726348990e-03, -2.208826523243919e-04,  5.401675277481744e-06, -1.026309311503201e-07,  1.648541089379355e-09, -2.339025264217057e-11,
  3.010626414558666e-13, -3.578274426772034e-15,  3.976975688371904e-17, -4.172105330184730e-19,  4.161053951278725e-21, -3.967624936062465e-23,  3.349475282977298e-03,
 -1.567670958599717e-04,  4.462501389940111e-06, -9.702263374899424e-08,  1.762736375369986e-09, -2.804591631508446e-11,  4.020530414548343e-13, -5.292551970517322e-15,
  6.484240102199675e-17, -7.468033395711744e-19,  8.147900442879747e-21, -8.471808087179155e-23,  1.874501290439928e-03, -1.044066715258425e-04,  3.432110642191100e-06,
 -8.485431179940715e-08,  1.734520025073531e-09, -3.080145020449023e-11,  4.896910855846521e-13, -7.111316123059979e-15,  9.568515398427509e-17, -1.205609607343353e-18,
  1.434092156542961e-20, -1.620718877190996e-22,  1.001019324519946e-03, -6.548595285036244e-05,  2.467509437172530e-06, -6.897134079403791e-08,  1.578510389582589e-09,
 -3.115185987675485e-11,  5.471201380863188e-13, -8.733657563933078e-15,  1.286266019980198e-16, -1.767368138609466e-18,  2.285139459869401e-20, -2.798864105070638e-22,
  5.109605458234046e-04, -3.881413034504494e-05,  1.664778615613829e-06, -5.232563294955719e-08,  1.334741111905527e-09, -2.915748364772872e-11,  5.636846766997318e-13,
 -9.858235078771557e-15,  1.584284817593163e-16, -2.367004464760149e-18,  3.317399722666471e-20, -4.391915743924044e-22,  2.497770431255292e-04, -2.181126273753438e-05,
  1.057991382253629e-06, -3.720365495964001e-08,  1.053231887544755e-09, -2.537318492411499e-11,  5.381347981201659e-13, -1.027933829982340e-14,  1.797431477433053e-16,
 -2.912155746505704e-18,  4.412786697480313e-20, -6.299287492961703e-22,  1.171841108565663e-04, -1.165833158934034e-05,  6.356784869769765e-07, -2.488917816023599e-08,
  7.788578941501326e-10, -2.061947721017615e-11,  4.782422083701417e-13, -9.948830407119845e-15,  1.887730235997212e-16, -3.308239642457989e-18,  5.406932329080443e-20,
 -8.303373062561836e-22,  5.288993837019566e-05, -5.946885770225915e-06,  3.624308911861972e-07, -1.572904794687940e-08,  5.419982423610157e-10, -1.571551166776039e-11,
  3.974132244194095e-13, -8.978752380549529e-15,  1.843952818039389e-16, -3.487026689664692e-18,  6.133021638843517e-20, -1.011016251380249e-21,  2.302589973724369e-05,
 -2.904796060278699e-06,  1.968212502471458e-07, -9.427234069861885e-09,  3.563997408349761e-10, -1.128185744024343e-11,  3.101548627340019e-13, -7.590111409773103e-15,
  1.682972079598127e-16, -3.426307037148416e-18,  6.470839800080116e-20, -1.142663099116581e-21,  9.697780423577490e-06, -1.363493647119196e-06,  1.021996626667560e-07,
 -5.380354392952902e-09,  2.223775261805268e-10, -7.661164996101783e-12,  2.283269246200643e-13, -6.036759546356098e-15,  1.441745976819266e-16, -3.152881461456843e-18,
  6.380222678312507e-20, -1.204450285206942e-21,  3.964083741518388e-06, -6.173363531160008e-07,  5.094391218135656e-08, -2.936213397060924e-09,  1.322246211798936e-10,
 -4.942666338204953e-12,  1.592564701825518e-13, -4.537607656917704e-15,  1.164530428646392e-16, -2.729510571342340e-18,  5.906144925649965e-20, -1.189575076959207e-21,
  1.578219383005397e-06, -2.706688696263102e-07,  2.448015383883532e-08, -1.538816911616773e-09,  7.525102909474238e-11, -3.043107994300068e-12,  1.057195554805993e-13,
 -3.238093371113957e-15,  8.909382325561252e-17, -2.233328866602966e-18,  5.156675787553187e-20, -1.105961674516759e-21,  6.143678315904122e-07, -1.154060105674979e-07,
  1.138993760920906e-08, -7.779692027049621e-10,  4.117875874912839e-11, -1.796232277937627e-12,  6.710300764690629e-14, -2.203980192805295e-15,  6.486332891626853e-17,
 -1.735135962242237e-18,  4.266345692534248e-20, -9.724262493264836e-22,  2.348316261677739e-07, -4.806598553720564e-08,  5.154945049256944e-09, -3.812062141933945e-10,
  2.177006476234342e-11, -1.021339930373435e-12,  4.091974092971099e-14, -1.437658699896505e-15,  4.515180366967283e-17, -1.286146433111379e-18,  3.360614193789222e-20,
 -8.124369977639372e-22,  8.853867169683338e-08, -1.964894121681611e-08,  2.280574946397060e-09, -1.819393169593830e-10,  1.117450711769921e-11, -5.622085018985504e-13,
  2.409231691400682e-14, -9.031800035918598e-16,  3.019975051186537e-17, -9.139817118863144e-19,  2.532542813580495e-20, -6.480712518656347e-22,  3.308945368900229e-08,
 -7.923835276943729e-09,  9.913361354716795e-10, -8.501877498073210e-11,  5.597992152853672e-12, -3.011538919044328e-13,  1.376606041288144e-14, -5.492575741997311e-16,
  1.950637786269456e-17, -6.258147213435589e-19,  1.834927730111284e-20, -4.959997793518729e-22,  1.232266425666580e-08, -3.169271214583677e-09,  4.257053009551830e-10,
 -3.910962295778220e-11,  2.751829851177941e-12, -1.578254176458698e-13,  7.674279346406625e-15, -3.250475960698360e-16,  1.223075240681922e-17, -4.149964720484077e-19,
  1.284708316283722e-20, -3.660455960423108e-22,  4.598255143836875e-09, -1.264348127239263e-09,  1.816246882930808e-10, -1.781117560215055e-11,  1.334868144575503e-12,
 -8.137294546788209e-14,  4.197104772983968e-15, -1.882094706525232e-16,  7.484320499231865e-18, -2.679270196360892e-19,  8.736947291980461e-21, -2.618141154477928e-22,
  1.729378598780080e-09, -5.060830122113877e-10,  7.744306711634403e-11, -8.077738348254403e-12,  6.426945212575493e-13, -4.151325989000481e-14,  2.264634097011750e-15,
 -1.072188262967687e-16,  4.494108164301871e-18, -1.693121510765342e-19,  5.801853578719512e-21, -1.824289081247486e-22,  6.595157496870665e-10, -2.044912606243731e-10,
  3.320258461172842e-11, -3.670202696164440e-12,  3.089589661360276e-13, -2.107839003891843e-14,  1.212488992601106e-15, -6.043435864360306e-17,  2.662722353445395e-18,
 -1.052952150078165e-19,  3.782028480362878e-21, -1.244761313627700e-22,  2.566165258823804e-10, -8.393166033793911e-11,  1.440204677553012e-11, -1.680898522143122e-12,
  1.491877709216043e-13, -1.071495907279829e-14,  6.478828087487378e-16, -3.389484586255398e-17,  1.565300736657612e-18, -6.479184081813801e-20,  2.432874992772329e-21,
 -8.359888121201676e-23,  1.025081236904198e-10, -3.521063929171991e-11,  6.359343098207590e-12, -7.806860882877126e-13,  7.279231597721881e-14, -5.484989698593458e-15,
  3.474772213683360e-16, -1.902098618637304e-17,  9.179332133638539e-19, -3.965641953706840e-20,  1.552317105268526e-21, -5.553982232372920e-23,  4.229268690041640e-11,
 -1.518952311292313e-11,  2.875602924859656e-12, -3.698633499394760e-13,  3.609522398349628e-14, -2.843321532565125e-15,  1.880778085455009e-16, -1.073711496603184e-17,
  5.397662440700833e-19, -2.426397921660589e-20,  9.872212320767472e-22, -3.667250885206163e-23,  1.812381865618027e-11, -6.776178272095991e-12,  1.339016238024577e-12,
 -1.797200386784183e-13,  1.828636405848663e-14, -1.500302880735734e-15,  1.032527354885324e-16, -6.126332835378003e-18,  3.197537914533366e-19, -1.490837664150767e-20,
  6.285169258044235e-22, -2.416771108655512e-23,  8.106452216383750e-12, -3.141367195472056e-12,  6.451581405293043e-13, -8.998514572188810e-14,  9.507914993021225e-15,
 -8.093480535606724e-16,  5.773643979673570e-17, -3.547587096986588e-18,  1.915714460158606e-19, -9.232869485419672e-21,  4.020081015881655e-22, -1.595019210661116e-23,
  3.798195506155285e-12, -1.518860709440338e-12,  3.227759658054290e-13, -4.658431715860243e-14,  5.090212471615794e-15, -4.477548091189780e-16,  3.298057921508613e-17,
 -2.090688610629890e-18,  1.163813802414153e-19, -5.777523874951109e-21,  2.589149530659650e-22, -1.056454287527401e-23,  1.866986172506767e-12, -7.670759195580230e-13,
  1.679214101822168e-13, -2.496681429855621e-14,  2.809162040498451e-15, -2.542875405429595e-16,  1.926146285236863e-17, -1.254765636992284e-18,  7.172933887657874e-20,
 -3.654249741805635e-21,  1.679448968287864e-22, -7.022701779745661e-24,  9.607215768715736e-13, -4.037937665291007e-13,  9.064040831456448e-14, -1.382067292723241e-14,
  1.594177365370023e-15, -1.478616146511307e-16,  1.146947511198579e-17, -7.646933176246055e-19,  4.471349689193654e-20, -2.328667636071938e-21,  1.093450504276310e-22,
 -4.668711128308350e-24,  5.129536967116445e-13, -2.195927031315423e-13,  5.030943570409790e-14, -7.830516794799570e-15,  9.217508087542118e-16, -8.721110018944256e-17,
  6.897664933390701e-18, -4.686882249981629e-19,  2.791701137612950e-20, -1.480365744775165e-21,  7.074461020084509e-23, -3.072624162311221e-24,  2.775583695639989e-13,
 -1.205006083289616e-13,  2.804364133788364e-14, -4.434558189447791e-15,  5.302292417431406e-16, -5.094249338308143e-17,  4.089964257097475e-18, -2.820039222746806e-19,
  1.703873820138959e-20, -9.161784726370219e-22,  4.438075997836084e-23, -1.953151231407922e-24,  1.427531779397808e-13, -6.258029611910550e-14,  1.472367891567043e-14,
 -2.354044791177750e-15,  2.845474230258351e-16, -2.763172085506105e-17,  2.241720258586292e-18, -1.561507502685606e-19,  9.528955146874968e-21, -5.173680097132985e-22,
  2.529998385006512e-23, -1.123705030315562e-24,  5.442672138684494e-14, -2.398870556597411e-14,  5.678354300743529e-15, -9.134553097847574e-16,  1.110871154556179e-16,
 -1.085185541395711e-17,  8.855391679791301e-19, -6.203564516083780e-20,  3.806741027007412e-21, -2.078063320745960e-22,  1.021578672763908e-23, -4.560705866715228e-25,
  6.497442215862419e-02, -1.753609282812149e-04,  4.920074688328721e-07, -1.424907290078048e-09,  4.224736475022935e-12, -1.272885359946981e-14,  3.872883202740620e-17,
 -1.184781564902368e-19,  3.631916597380252e-22, -1.113594060973187e-24,  3.409606643800191e-27, -1.042016928164076e-29,  6.129709547090845e-02, -2.118988990886376e-04,
  8.714569542147638e-07, -3.715789005304725e-09,  1.565260516813593e-11, -6.449800087279139e-14,  2.601459691681906e-16, -1.029880031555627e-18,  4.012096541648699e-21,
 -1.541295052654639e-23,  5.848345505968908e-26, -2.194702986489912e-28,  5.456088608525033e-02, -2.713959639794891e-04,  1.593753764546662e-06, -8.921314168388856e-09,
  4.723431247389168e-11, -2.394184519071969e-13,  1.172398031437436e-15, -5.579948494760834e-18,  2.592134907005423e-20, -1.179033110065726e-22,  5.263826181803073e-25,
 -2.311172555514012e-27,  4.583114471297867e-02, -3.324251085121957e-04,  2.565427213020953e-06, -1.778423254670837e-08,  1.141402789126744e-10, -6.920613519716283e-13,
  4.011025585658413e-15, -2.239488235537707e-17,  1.211317115505072e-19, -6.374115817015120e-22,  3.273912550922414e-24, -1.645630148545792e-26,  3.634291624337992e-02,
 -3.742529291974475e-04,  3.622638159184827e-06, -3.040054332306485e-08,  2.323273168899726e-10, -1.656249344564790e-12,  1.117315484314556e-14, -7.202099118912403e-17,
  4.466903233264975e-19, -2.679738934175971e-21,  1.561274169546417e-23, -8.862466517248982e-26,  2.721765044720513e-02, -3.841121561410401e-04,  4.552749816291887e-06,
 -4.560994730470402e-08,  4.095407618659162e-10, -3.389158665294900e-12,  2.629368042200067e-14, -1.934543303433474e-16,  1.360982011628246e-18, -9.211840356249695e-21,
  6.027332511849955e-23, -3.826573080180373e-25,  1.926183291669566e-02, -3.602584178602123e-04,  5.153208152004997e-06, -6.094713389909378e-08,  6.361824677096891e-10,
 -6.051440859450694e-12,  5.349685492122042e-14, -4.453728103347983e-16,  3.524762483137670e-18, -2.670480246381777e-20,  1.947365827688351e-22, -1.372593509868049e-24,
  1.289021859918522e-02, -3.103437526007163e-04,  5.299605815578986e-06, -7.329212484656562e-08,  8.816291296818127e-10, -9.562873616296754e-12,  9.562114534523771e-14,
 -8.945201321457517e-16,  7.911358137852257e-18, -6.666893270759726e-20,  5.385361022177083e-22, -4.189517274129848e-24,  8.163887523749911e-03, -2.468537195432292e-04,
  4.985504730469839e-06, -7.995258325712231e-08,  1.100178844265195e-09, -1.351753258523408e-11,  1.519426660116678e-13, -1.587964444145217e-15,  1.560885306402394e-17,
 -1.455386407179169e-19,  1.295732428795009e-21, -1.107156950157738e-23,  4.898117154986495e-03, -1.821802934050853e-04,  4.314110953970763e-06, -7.963577346015708e-08,
  1.245563795437759e-09, -1.723605083727331e-11,  2.166405225127360e-13, -2.516962476746705e-15,  2.736808616201850e-17, -2.810931314246029e-19,  2.746479992720204e-21,
 -2.567001264760225e-23,  2.787057893241560e-03, -1.252841645217098e-04,  3.450512276939846e-06, -7.282838530211200e-08,  1.287421274879347e-09, -1.996323165465490e-11,
  2.792787694245659e-13, -3.591487231159976e-15,  4.302396744166785e-17, -4.848782901253552e-19,  5.180102974924660e-21, -5.277091653079505e-23,  1.505948620796300e-03,
 -8.059398594915482e-05,  2.561941279218721e-06, -6.145361838670804e-08,  1.221519778919003e-09, -2.112873400081602e-11,  3.276316733895104e-13, -4.645707537019609e-15,
  6.109243915746102e-17, -7.529015011730420e-19,  8.766009128007302e-21, -9.702839205703900e-23,  7.738629350242663e-04, -4.867024375072361e-05,  1.772932590511820e-06,
 -4.806149935485206e-08,  1.069149576077045e-09, -2.054340353355801e-11,  3.517681293507115e-13, -5.480780216250836e-15,  7.886120472883605e-17, -1.059509373612764e-18,
  1.340452813459910e-20, -1.607553906623663e-22,  3.788233367204259e-04, -2.768445338477468e-05,  1.147909578321323e-06, -3.498439673185239e-08,  8.671744427068793e-10,
 -1.843897729540761e-11,  3.474477414048922e-13, -5.929404543835546e-15,  9.307323183049005e-17, -1.359367677863441e-18,  1.863829237839255e-20, -2.415601664128871e-22,
  1.769911721567816e-04, -1.488107852960352e-05,  6.979428415747964e-07, -2.379722332103912e-08,  6.545953626294908e-10, -1.534776716038596e-11,  3.172245670065777e-13,
 -5.912060208565622e-15,  1.009596945476210e-16, -1.598834881666491e-18,  2.369872031922728e-20, -3.311503570824099e-22,  7.909240732201400e-05, -7.583449663013118e-06,
  3.999579169607211e-07, -1.518664807971423e-08,  4.617924970558155e-10, -1.189858795691284e-11,  2.689482665821707e-13, -5.458636045523351e-15,  1.011501773485450e-16,
 -1.732650841536641e-18,  2.770031853925568e-20, -4.164002866611655e-22,  3.388629158864268e-05, -3.675910459647027e-06,  2.168129691980475e-07, -9.128147655985625e-09,
  3.057124959558806e-10, -8.628679204309435e-12,  2.126755320785822e-13, -4.688462813759888e-15,  9.404217204505670e-17, -1.738431663869366e-18,  2.991154137505852e-20,
 -4.827129796713471e-22,  1.395655448734803e-05, -1.700632210111717e-06,  1.115989426074504e-07, -5.188104346886087e-09,  1.907048627505629e-10, -5.878136852061940e-12,
  1.575477631414167e-13, -3.762913110548391e-15,  8.150925465082395e-17, -1.622470711567789e-18,  2.998207954500956e-20, -5.184105732341938e-22,  5.542262744362416e-06,
 -7.536286704649630e-07,  5.475466999519682e-08, -2.799641163645593e-09,  1.125673430380769e-10, -3.777871441709579e-12,  1.098140014145501e-13, -2.834687967621869e-15,
  6.615946635198446e-17, -1.415051041630103e-18,  2.802763782341094e-20, -5.182352944418268e-22,  2.129028347934874e-06, -3.211091300650809e-07,  2.571141093869068e-08,
 -1.440418411008686e-09,  6.314465555527484e-11, -2.300770353183682e-12,  7.234173184828723e-14, -2.013413947983534e-15,  5.051951309728008e-17, -1.158630271988139e-18,
  2.454899204827764e-20, -4.844927083578253e-22,  7.940405101820554e-07, -1.320848676963048e-07,  1.160445537300012e-08, -7.096982674016301e-10,  3.381244280878942e-11,
 -1.333783369027754e-12,  4.524720112547507e-14, -1.354591082420381e-15,  3.646037873957047e-17, -8.947846528999353e-19,  2.024119700546529e-20, -4.255948612048012e-22,
  2.886769916843816e-07, -5.267947078406706e-08,  5.056818513047881e-09, -3.364041207635825e-10,  1.736448876774819e-11, -7.394837069819125e-13,  2.699733423379424e-14,
 -8.673430024796864e-16,  2.498856579642098e-17, -6.548742582006860e-19,  1.578554428290819e-20, -3.529554270015087e-22,  1.027541726394220e-07, -2.046630830166200e-08,
  2.137797187762304e-09, -1.541582156725271e-10,  8.594576617015894e-12, -3.940407728209731e-13,  1.544239906440540e-14, -5.311487266426470e-16,  1.634365012320281e-17,
 -4.564418110475276e-19,  1.170087211708587e-20, -2.776922422872806e-22,  3.598225345948369e-08, -7.784287508822397e-09,  8.812707504403695e-10, -6.864805033718270e-11,
  4.121058621750259e-12, -2.028453664312248e-13,  8.511521248637937e-15, -3.126841795122628e-16,  1.025302761241437e-17, -3.045042354207231e-19,  8.284919681907787e-21,
 -2.082991588594609e-22,  1.246064212144206e-08, -2.914121752555351e-09,  3.561766225273152e-10, -2.986863010422587e-11,  1.924779504835169e-12, -1.014272773036975e-13,
  4.545016610832340e-15, -1.779004760529433e-16,  6.202188858578559e-18, -1.954575217145704e-19,  5.632693301074502e-21, -1.497313956825917e-22,  4.291355058908933e-09,
 -1.079925032297194e-09,  1.419514683579013e-10, -1.277120946153525e-11,  8.807082277422251e-13, -4.954278606702005e-14,  2.364526396007485e-15, -9.836609426937135e-17,
  3.637579654200634e-18, -1.213711683709303e-19,  3.696767586673687e-21, -1.036878265295082e-22,  1.478632913923157e-09, -3.985845417002907e-10,  5.612823815670021e-11,
 -5.399020754026231e-12,  3.971694694037263e-13, -2.378078283809431e-14,  1.205543802174295e-15, -5.316469511170157e-17,  2.080310352255957e-18, -7.331894014009960e-20,
  2.355046035233164e-21, -6.954802673870631e-23,  5.129863151583014e-10, -1.474610868045306e-10,  2.216011757445567e-11, -2.271034877162918e-12,  1.776395638214926e-13,
 -1.128705196543900e-14,  6.060349191502592e-16, -2.825601617107650e-17,  1.166929979546593e-18, -4.333704412478698e-20,  1.464551159786937e-21, -4.543522227148461e-23,
  1.803983760077509e-10, -5.505265339434512e-11,  8.794426774168775e-12, -9.568010686305802e-13,  7.931316136613757e-14, -5.331112300550293e-15,  3.022812134346085e-16,
 -1.485859029729602e-17,  6.459171643467685e-19, -2.521177568828692e-20,  8.942115810066964e-22, -2.907358546509472e-23,  6.475017265464268e-11, -2.088464776999043e-11,
  3.532354665866741e-12, -4.064837502307097e-13,  3.558581655052636e-14, -2.522125926091856e-15,  1.505542534911658e-16, -7.779138729282568e-18,  3.549521492165562e-19,
 -1.452215771037195e-20,  5.391704631145886e-22, -1.832566310601709e-23,  2.388775967219849e-11, -8.107138176853246e-12,  1.445937684036928e-12, -1.753256318291809e-13,
  1.615226617277658e-14, -1.202992068330937e-15,  7.535502173344948e-17, -4.080122139253996e-18,  1.948295469920016e-19, -8.331126262981842e-21,  3.228892720546597e-22,
 -1.144191992959504e-23,  9.121137304973745e-12, -3.242705912581802e-12,  6.073348206532285e-13, -7.729220312635818e-14,  7.465466984151820e-15, -5.822077713864780e-16,
  3.813888202022624e-17, -2.156886349391537e-18,  1.074437510837431e-19, -4.787346394200217e-21,  1.931173470014154e-22, -7.114435859920374e-24,  3.628555736851069e-12,
 -1.345279388930764e-12,  2.634613389033286e-13, -3.504834811875532e-14,  3.535331895125312e-15, -2.876205159107950e-16,  1.963313740853404e-17, -1.155696312284260e-18,
  5.985750601183994e-20, -2.770091884045673e-21,  1.159415206034013e-22, -4.427064737039583e-24,  1.512878009337539e-12, -5.823030530161701e-13,  1.187217444973187e-13,
 -1.643948921305984e-14,  1.724748053907457e-15, -1.458081897071499e-16,  1.033212259533710e-17, -6.307422284740070e-19,  3.384646236278256e-20, -1.621304647023961e-21,
  7.017575218062185e-23, -2.768371482359842e-24,  6.642003572466751e-13, -2.642105606920408e-13,  5.582739580027964e-14, -8.011389129483687e-15,  8.705157732975973e-16,
 -7.615821796284548e-17,  5.580038448405221e-18, -3.519147475144091e-19,  1.949245003082103e-20, -9.629933876396994e-22,  4.295355352697604e-23, -1.744687365391555e-24,
  3.078542674569563e-13, -1.259899287876879e-13,  2.746216513424006e-14, -4.065591593108953e-15,  4.555171375698258e-16, -4.106445807419274e-17,  3.098077757655601e-18,
 -2.010375242140178e-19,  1.144910611678748e-20, -5.811400765249170e-22,  2.661359073883902e-23, -1.109030662656798e-24,  1.504797307671148e-13, -6.307214718570022e-14,
  1.411474411980671e-14, -2.145608504844214e-15,  2.467466692934282e-16, -2.281890197889630e-17,  1.764986382061749e-18, -1.173486440486541e-19,  6.843157273809215e-21,
 -3.554560602637725e-22,  1.664832721015572e-23, -7.090812118153491e-25,  7.695879388433529e-14, -3.288617771983924e-14,  7.519228323859863e-15, -1.167988029223496e-15,
  1.372143668114951e-16, -1.295733036496370e-17,  1.022880989745772e-18, -6.937585530802136e-20,  4.124928904483999e-21, -2.183541024026000e-22,  1.041721172379768e-23,
 -4.517059326627769e-25,  4.025652199360185e-14, -1.745870487457940e-14,  4.058298312539096e-15, -6.409775758370519e-16,  7.655019746700278e-17, -7.346217365644479e-18,
  5.891366566003243e-19, -4.057672918607650e-20,  2.449046715163252e-21, -1.315496475243609e-22,  6.365994425226087e-24, -2.798866352840115e-25,  2.021539384968822e-14,
 -8.857338224272956e-15,  2.082678965799740e-15, -3.327807016519332e-16,  4.020113456421760e-17, -3.901544146917647e-18,  3.163445367019577e-19, -2.202312574804212e-20,
  1.343203461133887e-21, -7.288922776099865e-23,  3.562515814749194e-24, -1.581494580934714e-25,  7.604311877469679e-15, -3.350824904729470e-15,  7.929589592574535e-16,
 -1.275253806400701e-16,  1.550438565132082e-17, -1.514180876611445e-18,  1.235281992040419e-19, -8.651393298120639e-21,  5.307455972101660e-22, -2.896556927916650e-23,
  1.423597548419165e-24, -6.353920707017195e-26,  6.428074386924339e-02, -1.714921339774067e-04,  4.753059155747566e-07, -1.359298725406210e-09,  3.979192247753664e-12,
 -1.183789311358556e-14,  3.556830933759289e-17, -1.074720020622958e-19,  3.254506513402058e-22, -9.859482364964385e-25,  2.982952933919485e-27, -9.009731894557577e-30,
  6.046316666992149e-02, -2.051014396992116e-04,  8.283286402483165e-07, -3.475337322268411e-09,  1.442281727511563e-11, -5.858652657203890e-14,  2.330264454678429e-16,
 -9.099375307565576e-19,  3.497112055781179e-21, -1.325576269457489e-23,  4.963532236976286e-26, -1.838348005122620e-28,  5.350014194006796e-02, -2.590616634507483e-04,
  1.491079283361578e-06, -8.202394797687572e-09,  4.271513192921289e-11, -2.130658116723367e-13,  1.027162005459697e-15, -4.814504729431371e-18,  2.203254727986934e-20,
 -9.874818684966160e-23,  4.345067807758095e-25, -1.880633019207463e-27,  4.454118199719292e-02, -3.127253067936352e-04,  2.362533507175149e-06, -1.606369310492816e-08,
  1.012130833371054e-10, -6.029037391956646e-13,  3.434958532688283e-15, -1.886189264105419e-17,  1.003775289997528e-19, -5.198598326522196e-22,  2.628736079610975e-24,
 -1.301178361165738e-26,  3.490164230563595e-02, -3.466702831031335e-04,  3.279087326704670e-06, -2.693439403469936e-08,  2.017285281475993e-10, -1.410762460229800e-12,
  9.342998713207344e-15, -5.915713149366195e-17,  3.605808532002982e-19, -2.126743892148716e-21,  1.218661111240546e-23, -6.805745897294256e-26,  2.575073020535533e-02,
 -3.497729775521905e-04,  4.042615754321769e-06, -3.956703045434647e-08,  3.476535092283985e-10, -2.818480246011279e-12,  2.143996070746042e-14, -1.547746535551668e-16,
  1.068980501569639e-18, -7.106724914193110e-21,  4.569150430319186e-23, -2.851462710050990e-25,  1.789885130680688e-02, -3.217939385616186e-04,  4.479137025027729e-06,
 -5.167070656743366e-08,  5.270450781205668e-10, -4.905253409362442e-12,  4.247105456298848e-14, -3.465696595530133e-16,  2.690171476439013e-18, -2.000145107537696e-20,
  1.432018152593828e-22, -9.914126586799414e-25,  1.172838743322660e-02, -2.712388906936485e-04,  4.498807032559847e-06, -6.059945673634169e-08,  7.114309112604017e-10,
 -7.541994916978572e-12,  7.378573422570274e-14, -6.759360603429672e-16,  5.858355088940439e-18, -4.840862609628858e-20,  3.836356301274689e-22, -2.929386399687457e-24,
  7.250561239165999e-03, -2.105274875759586e-04,  4.123372144529999e-06, -6.432855436424823e-08,  8.629653140348849e-10, -1.035252885361808e-11,  1.137509270903982e-13,
 -1.163189330567868e-15,  1.119578818665181e-17, -1.022882119160344e-19,  8.928485727031246e-22, -7.483589071002003e-24,  4.232815368381224e-03, -1.511756050907151e-04,
  3.467533660566443e-06, -6.220431536440501e-08,  9.476024044504567e-10, -1.279205823587239e-11,  1.570444662493740e-13, -1.783919119536851e-15,  1.898111774189116e-17,
 -1.909050167483749e-19,  1.827696327075428e-21, -1.674768453841086e-23,  2.336051623983126e-03, -1.008537873335707e-04,  2.688080928405747e-06, -5.509116780648364e-08,
  9.477785086263874e-10, -1.432651039576109e-11,  1.956285022330625e-13, -2.458160242292821e-15,  2.879860469548384e-17, -3.176493398085844e-19,  3.323497100883608e-21,
 -3.317794264801173e-23,  1.220323230827551e-03, -6.274552047701618e-05,  1.929090777567530e-06, -4.490321888844717e-08,  8.680838439351177e-10, -1.462843817590745e-11,
  2.212846319479676e-13, -3.064303596459673e-15,  3.938959101123361e-17, -4.748872648013079e-19,  5.412704409079206e-21, -5.868688209347623e-23,  6.042690532786132e-04,
 -3.653141177563401e-05,  1.286629047505990e-06, -3.383080925923092e-08,  7.316120974814532e-10, -1.368920820914423e-11,  2.285667122881452e-13, -3.476438875085645e-15,
  4.887681910628893e-17, -6.421668816226266e-19,  7.950812150936748e-21, -9.337348805045693e-23,  2.840926988969512e-04, -1.996989754459896e-05,  8.005026295448138e-07,
 -2.365769549651167e-08,  5.698991372133301e-10, -1.179650424388950e-11,  2.166810680698994e-13, -3.608686734504324e-15,  5.533363807827963e-17, -7.901194111067714e-19,
  1.059925925174357e-20, -1.344927172382519e-22,  1.270490361308173e-04, -1.028264859355860e-05,  4.662884067044062e-07, -1.541601626391366e-08,  4.120481451579104e-10,
 -9.403045024817340e-12,  1.894197989714134e-13, -3.444498649669212e-15,  5.744969827624937e-17, -8.893373020109932e-19,  1.289553839935790e-20, -1.763960874767227e-22,
  5.415981832966941e-05, -5.003178823662914e-06,  2.552055683829277e-07, -9.397088962126482e-09,  2.776590884914594e-10, -6.962964729066540e-12,  1.533838954900453e-13,
 -3.037372147927160e-15,  5.496773365776388e-17, -9.203491709302592e-19,  1.439324969576959e-20, -2.117970115172848e-22,  2.206004606887981e-05, -2.307916893232336e-06,
  1.317183147593148e-07, -5.379190628024146e-09,  1.750867340886542e-10, -4.810229517550772e-12,  1.155541702157761e-13, -2.485586690254295e-15,  4.869371297855204e-17,
 -8.798976766731569e-19,  1.481053613661797e-20, -2.339823375350344e-22,  8.608251261049399e-06, -1.012756467353485e-06,  6.434879322270485e-08, -2.903024306028957e-09,
  1.037404525002038e-10, -3.113272581592566e-12,  8.134455215268688e-14, -1.896060935301431e-15,  4.012010402262276e-17, -7.807788963509684e-19,  1.411694111963815e-20,
 -2.389930552123422e-22,  3.227732232611921e-06, -4.242861713392068e-07,  2.987134801383122e-08, -1.483042574270432e-09,  5.799783208811738e-11, -1.895871008013318e-12,
  5.374130407290726e-14, -1.354265234487915e-15,  3.088476256932833e-17, -6.460126589883816e-19,  1.252274787806648e-20, -2.267709102820092e-22,  1.166809499969611e-06,
 -1.703502171409133e-07,  1.322992191463012e-08, -7.202090606927641e-10,  3.072711813756373e-11, -1.091070401062959e-12,  3.347073118032719e-14, -9.098050678119316e-16,
  2.231552567503302e-17, -5.007023298408326e-19,  1.038667143449603e-20, -2.008338454031608e-22,  4.081612376245352e-07, -6.581733764524083e-08,  5.614638801775353e-09,
 -3.339586494278014e-10,  1.549672212889239e-11, -5.961214165608940e-13,  1.974255126042890e-14, -5.775699607475082e-16,  1.520482735661276e-17, -3.652462305197759e-19,
  8.093249855316682e-21, -1.667997928269298e-22,  1.387325201333745e-07, -2.457971798381569e-08,  2.293756996727895e-09, -1.485580993503177e-10,  7.475328787217692e-12,
 -3.106944294263100e-13,  1.108178781380203e-14, -3.481488542066710e-16,  9.816639684442706e-18, -2.519744756882182e-19,  5.953019497072887e-21, -1.305453731090928e-22,
  4.602696978827996e-08, -8.915290167433948e-09,  9.065148190933070e-10, -6.371477112922209e-11,  3.466393038948306e-12, -1.552524182411461e-13,  5.949404018576752e-15,
 -2.002690859357205e-16,  6.035725022875101e-18, -1.652200983666654e-19,  4.154150324719381e-21, -9.675848666309569e-23,  1.497974996189709e-08, -3.156975496618759e-09,
  3.484190166665478e-10, -2.648742116087587e-11,  1.553466049647365e-12, -7.477631407886488e-14,  3.071133675527696e-15, -1.105204643761526e-16,  3.552690060306918e-18,
 -1.035057362304068e-19,  2.764397104131395e-21, -6.826590078395799e-23,  4.808731439680234e-09, -1.097545295850755e-09,  1.309767109268449e-10, -1.073413858080746e-11,
  6.766559579498998e-13, -3.491095977109217e-14,  1.532912969144822e-15, -5.883839139093172e-17,  2.012943994956019e-18, -6.229040233400320e-20,  1.763706032307290e-21,
 -4.609078814096096e-23,  1.531704611268500e-09, -3.768926980969151e-10,  4.844994204800777e-11, -4.266374789289982e-12,  2.882010958379295e-13, -1.589376342686246e-14,
  7.442110947880029e-16, -3.039505021253338e-17,  1.104215669864918e-18, -3.621597310373004e-20,  1.084905947686560e-21, -2.994456715320923e-23,  4.872257326278012e-10,
 -1.286698580700144e-10,  1.775082998504468e-11, -1.673853142172213e-12,  1.207979928850852e-13, -7.100674113308238e-15,  3.536200869702415e-16, -1.532957860949056e-17,
  5.899874364927089e-19, -2.046336524499311e-20,  6.471876549230395e-22, -1.882801117482063e-23,  1.558426736408252e-10, -4.397482636788934e-11,  6.485764884570322e-12,
 -6.526865216343993e-13,  5.016312468368505e-14, -3.133722863080481e-15,  1.655282613292097e-16, -7.596696607448273e-18,  3.089786867534314e-19, -1.130654259883821e-20,
  3.766745495604984e-22, -1.152516465742408e-23,  5.049079770531732e-11, -1.515553956522759e-11,  2.380493872443071e-12, -2.547577477661394e-13,  2.078396104136004e-14,
 -1.375668696694221e-15,  7.685079701713114e-17, -3.723689493512119e-18,  1.596383764300809e-19, -6.147851761570609e-21,  2.152306324540931e-22, -6.910182383733606e-24,
  1.669633669115647e-11, -5.307456448952040e-12,  8.843160104943569e-13, -1.002782035731147e-13,  8.654727262831999e-15, -6.050039626676505e-16,  3.563670985395584e-17,
 -1.817772644037520e-18,  8.191488109703223e-20, -3.311170975875523e-21,  1.215060545736727e-22, -4.083355268655945e-24,  5.679618097238989e-12, -1.903456823735455e-12,
  3.350656252554584e-13, -4.010785108503969e-14,  3.649044930212270e-15, -2.684976203918047e-16,  1.662229634843511e-17, -8.898505857147554e-19,  4.202629636927635e-20,
 -1.778044424882001e-21,  6.820377182427984e-23, -2.392843784978067e-24,  2.003210990739012e-12, -7.046045577145888e-13,  1.304919855516531e-13, -1.642391971621772e-14,
  1.569315825857453e-15, -1.211111961061779e-16,  7.853603713600921e-18, -4.398064253898629e-19,  2.170113439277461e-20, -9.580570610186761e-22,  3.830327308517093e-23,
 -1.398937285512311e-24,  7.381871372873898e-13, -2.712673832091731e-13,  5.262741891426129e-14, -6.936104745384163e-15,  6.933145988150926e-16, -5.590951721755252e-17,
  3.783881205617204e-18, -2.208960039948740e-19,  1.134932782256605e-20, -5.211468457268467e-22,  2.164821962917524e-23, -8.205818124821805e-25,  2.862189995745763e-13,
 -1.093805372523682e-13,  2.213041202974701e-14, -3.041163664256833e-15,  3.166975086746427e-16, -2.658016931626703e-17,  1.870315197768336e-18, -1.134014250175149e-19,
  6.045203449570044e-21, -2.877266516467281e-22,  1.237667650884046e-23, -4.853213282757588e-25,  1.174553545435713e-13, -4.646269973234046e-14,  9.758425393416880e-15,
 -1.391967340022158e-15,  1.503632849683845e-16, -1.307957725110518e-17,  9.530093836563206e-19, -5.977943621762493e-20,  3.293859482673525e-21, -1.619027277154416e-22,
  7.186010952040867e-24, -2.904910493773325e-25,  5.120771242632883e-14, -2.086987108041841e-14,  4.528392657323681e-15, -6.673608634705425e-16,  7.444026544539436e-17,
 -6.681666074082423e-18,  5.019713666992501e-19, -3.244028083616228e-20,  1.840144869153509e-21, -9.304328116112396e-23,  4.245029246676011e-24, -1.762566367745013e-25,
  2.372101393095692e-14, -9.913313042079775e-15,  2.211313307837601e-15, -3.350592604218542e-16,  3.840976496008768e-17, -3.541098543218993e-18,  2.730699655838037e-19,
 -1.810243025069471e-20,  1.052635716221785e-21, -5.452629854277460e-23,  2.546970768350214e-24, -1.081980190791709e-25,  1.159600524908929e-14, -4.945748296912053e-15,
  1.128415526506910e-15, -1.749071198554519e-16,  2.050488036110199e-17, -1.932337201306608e-18,  1.522388102957875e-19, -1.030540770427115e-20,  6.115801316221519e-22,
 -3.231479482368690e-23,  1.538924003743469e-24, -6.661484787887582e-26,  5.853827024866277e-15, -2.535885329853660e-15,  5.887334578281632e-16, -9.286904386070006e-17,
  1.107734738041204e-17, -1.061759590661019e-18,  8.504804859775065e-20, -5.850925192118389e-21,  3.527419191180779e-22, -1.892671636105765e-23,  9.149349291825656e-25,
 -4.018446707012700e-26,  2.866497774880238e-15, -1.255247643952476e-15,  2.949681492092851e-16, -4.710148102804042e-17,  5.686453417570705e-18, -5.515330189085893e-19,
  4.469232393882198e-20, -3.109533228926155e-21,  1.895430062504717e-22, -1.027980890256448e-23,  5.021576955125006e-25, -2.228020081750371e-26,  1.063075972977088e-15,
 -4.683269671735448e-16,  1.107966994813398e-16, -1.781349701169135e-17,  2.165130500330837e-18, -2.113905981596128e-19,  1.724067312839569e-20, -1.207136313360811e-21,
  7.403563769625960e-23, -4.039454059748315e-24,  1.984796691696878e-25, -8.856478769420548e-27,  6.360227842594000e-02, -1.677538683485946e-04,  4.593686678112559e-07,
 -1.297480333637971e-09,  3.750732979009379e-12, -1.101921944466936e-14,  3.269971902053631e-17, -9.760321208142013e-20,  2.920120839502264e-22, -8.741899485900220e-25,
  2.613743965493554e-27, -7.803399013894399e-30,  5.965575546712205e-02, -1.986377908818179e-04,  7.879714769019972e-07, -3.253650664245858e-09,  1.330501288382829e-11,
 -5.328741295539175e-14,  2.090458036337271e-16, -8.052973493004729e-19,  3.053776117373336e-21, -1.142303794541553e-23,  4.221562856297185e-26, -1.543370333049191e-28,
  5.248714515911208e-02, -2.475154409980511e-04,  1.396614791877226e-06, -7.551748239088497e-09,  3.868981350990425e-11, -1.899550961578860e-13,  9.017150390796463e-16,
 -4.163143102897874e-18,  1.877150228061968e-20, -8.291556687234474e-23,  3.596416624595256e-25, -1.534712513989510e-27,  4.332689815866370e-02, -2.945694542250325e-04,
  2.179101763328377e-06, -1.453644243348688e-08,  8.993842485831358e-11, -5.264559590335148e-13,  2.949119642836076e-15, -1.593002577603710e-17,  8.342501946207955e-20,
 -4.253213892245018e-22,  2.117739076225310e-24, -1.032441817283063e-26,  3.356545428950006e-02, -3.216776331523391e-04,  2.974347414355106e-06, -2.392081689967800e-08,
  1.756278803913164e-10, -1.205170946783625e-12,  7.837267622086087e-15, -4.875502584481680e-17,  2.921159326418162e-19, -1.694271457438804e-21,  9.550307316018814e-24,
 -5.248198152358112e-26,  2.441344112382641e-02, -3.192408167185158e-04,  3.599412626233760e-06, -3.442898025668978e-08,  2.960974839617006e-10, -2.352284407716689e-12,
  1.754909167419768e-14, -1.243311634440125e-16,  8.432221111155797e-19, -5.507308633384081e-21,  3.480014486130699e-23, -2.135236568022334e-25,  1.667960776053532e-02,
 -2.883047918837214e-04,  3.906618192692074e-06, -4.397057608786446e-08,  4.383946310705415e-10, -3.993295662225258e-12,  3.387146700201347e-14, -2.709794997137836e-16,
  2.063512040953271e-18, -1.505927681321698e-20,  1.058789675212705e-22, -7.201342213416976e-25,  1.071106604982315e-02, -2.379745683363241e-04,  3.835228165520112e-06,
 -5.033313816542830e-08,  5.768695803802008e-10, -5.978578299211973e-12,  5.724182025421874e-14, -5.136253403988302e-16,  4.363382704193204e-18, -3.536210650648139e-20,
  2.749972335853735e-22, -2.061484855146792e-24,  6.469848055524317e-03, -1.804083787729315e-04,  3.427893383205093e-06, -5.203956923230898e-08,  6.807724830852787e-10,
 -7.976025383799232e-12,  8.568940371952149e-14, -8.575456537614166e-16,  8.084083259486788e-18, -7.238624320602660e-20,  6.195982871999097e-22, -5.095228254425243e-24,
  3.679205781486930e-03, -1.261815881055542e-04,  2.804228705702934e-06, -4.890044494251107e-08,  7.257354833809002e-10, -9.559631472757922e-12,  1.146579159673470e-13,
 -1.273700411733986e-15,  1.326427176562262e-17, -1.306637218258054e-19,  1.225983494522987e-21, -1.101577921462989e-23,  1.971796031993507e-03, -8.175594815517227e-05,
  2.109284779768183e-06, -4.198550877010784e-08,  7.031205106380991e-10, -1.036294745816643e-11,  1.381502881619648e-13, -1.696521249394911e-15,  1.944148049014956e-17,
 -2.099132405944318e-19,  2.151319977903239e-21, -2.104891658116200e-23,  9.971001821017960e-04, -4.925252554447067e-05,  1.464794183401975e-06, -3.309267054087383e-08,
  6.223476949090594e-10, -1.021919915585996e-11,  1.508315814278242e-13, -2.040164899188206e-15,  2.563914370820791e-17, -3.024419705819012e-19,  3.375155598070188e-21,
 -3.585214198749835e-23,  4.764140885551830e-04, -2.768228321357205e-05,  9.427413551574346e-07, -2.404740748109719e-08,  5.056295406654406e-10, -9.214302374358716e-12,
  1.500429023273676e-13, -2.228119278298898e-15,  3.061379825208168e-17, -3.933926375931127e-19,  4.767212043673882e-21, -5.483144562252563e-23,  2.154204875908831e-04,
 -1.456268531929357e-05,  5.643642846946845e-07, -1.617526276311423e-08,  3.787203516848324e-10, -7.632211175358059e-12,  1.366737012435008e-13, -2.221626057297686e-15,
  3.328028288887046e-17, -4.646540330188029e-19,  6.099186477972647e-21, -7.577794581000600e-23,  9.234866143968653e-05, -7.193069727415975e-06,  3.153655702339086e-07,
 -1.011013057891320e-08,  2.625958059142985e-10, -5.832950013898179e-12,  1.145287069055427e-13, -2.032255219706193e-15,  3.310753242265880e-17, -5.010281112829731e-19,
  7.107532366932130e-21, -9.518049544260596e-23,  3.761035836855842e-05, -3.346485799471097e-06,  1.650769272509841e-07, -5.894301465227706e-09,  1.692336303249351e-10,
 -4.130596093216384e-12,  8.867980377231507e-14, -1.713413144398442e-15,  3.028421742138616e-17, -4.956541326421193e-19,  7.582881345263912e-21, -1.092309793770549e-22,
  1.458575052215780e-05, -1.471186310007180e-06,  8.123192984624311e-08, -3.217590256115791e-09,  1.017770455229613e-10, -2.721640346337082e-12,  6.372208789436824e-14,
 -1.337395940261294e-15,  2.558905347953964e-17, -4.519988898509685e-19,  7.442750332426233e-21, -1.151086009273946e-22,  5.400543800668341e-06, -6.132169720799071e-07,
  3.771673158948041e-08, -1.650965862107898e-09,  5.734968719251139e-11, -1.675536567867522e-12,  4.267507483152723e-14, -9.707004073316621e-16,  2.006321515933690e-17,
 -3.817186072861217e-19,  6.752516253547950e-21, -1.119246412636571e-22,  1.914793906850404e-06, -2.432091575996543e-07,  1.658742835161096e-08, -7.994660605332855e-10,
  3.040402685746902e-11, -9.678953504894378e-13,  2.675245577306194e-14, -6.580522911965196e-16,  1.466264988823436e-17, -2.999071588719632e-19,  5.689223150923901e-21,
 -1.008910720289097e-22,  6.522752106397860e-07, -9.213573180099369e-08,  6.937904865703016e-09, -3.668983902040781e-10,  1.523081376876772e-11, -5.269403160566432e-13,
  1.576863005071314e-14, -4.185495576855828e-16,  1.003401470194821e-17, -2.202290727393230e-19,  4.472222037327208e-21, -8.471047532064424e-23,  2.142829908299460e-07,
 -3.347774095087508e-08,  2.771830080948929e-09, -1.602917167809463e-10,  7.242289350942680e-12, -2.716098065959168e-13,  8.779624512940360e-15, -2.509403227238805e-16,
  6.459906852637088e-18, -1.518649688013845e-19,  3.295632211123679e-21, -6.656581869045435e-23,  6.817214216960183e-08, -1.171972213563284e-08,  1.062718400742758e-09,
 -6.698220849551710e-11,  3.284548915731822e-12, -1.331926875352248e-13,  4.639998434035507e-15, -1.425097408629714e-16,  3.931731191748026e-18, -9.882223992527567e-20,
  2.287808420186602e-21, -4.919453052029036e-23,  2.110129065159236e-08, -3.972286894653277e-09,  3.929771955433657e-10, -2.690931562320582e-11,  1.428060832953121e-12,
 -6.245883869558760e-14,  2.339623002634883e-15, -7.705325340298782e-17,  2.273856163846779e-18, -6.099219047488663e-20,  1.503718749483195e-21, -3.436577322337975e-23,
  6.387554706584881e-09, -1.310536189245270e-09,  1.409212911438384e-10, -1.045005916867182e-11,  5.985061937354072e-13, -2.816174199599865e-14,  1.131676744058724e-15,
 -3.988025827654617e-17,  1.256308290474955e-18, -3.589483740864906e-20,  9.407587779632043e-22, -2.281185141720782e-23,  1.901765786196192e-09, -4.233261864496856e-10,
  4.929499359041576e-11, -3.946098815812915e-12,  2.432163136153560e-13, -1.228037922409126e-14,  5.281542616803479e-16, -1.987170201649402e-17,  6.668799875963666e-19,
 -2.025657032467206e-20,  5.633341390418725e-22, -1.446788151678632e-23,  5.603906599401223e-10, -1.347326723250245e-10,  1.692813720132717e-11, -1.458157783636282e-12,
  9.643905311955943e-14, -5.211439168589811e-15,  2.392967061439661e-16, -9.591004169416288e-18,  3.421557857315717e-19, -1.102672636505114e-20,  3.247614553291190e-22,
 -8.817752262740820e-24,  1.645492647395964e-10, -4.254259917927036e-11,  5.746084383343826e-12, -5.308640090676216e-13,  3.756406791404111e-14, -2.166619009772142e-15,
  1.059482351511861e-16, -4.512782730253563e-18,  1.707571518841696e-19, -5.826157677093243e-21,  1.813576242623025e-22, -5.195605571416908e-24,  4.850348961709628e-11,
 -1.342567733626801e-11,  1.942136379073936e-12, -1.918044297602090e-13,  1.447647851622576e-14, -8.886865820884444e-16,  4.615741623307770e-17, -2.084160623743300e-18,
  8.344727664486954e-20, -3.007573701741435e-21,  9.873422097005641e-23, -2.978325450837265e-24,  1.446601919573500e-11, -4.268065235224763e-12,  6.587508298028653e-13,
 -6.930633624034386e-14,  5.561748697053739e-15, -3.623124188389813e-16,  1.993168264300905e-17, -9.515314088987802e-19,  4.021206879646138e-20, -1.527268091207203e-21,
  5.275466007957581e-23, -1.671866170117650e-24,  4.401976819272162e-12, -1.378214077201353e-12,  2.260784993044421e-13, -2.524820891507584e-14,  2.147117828586431e-15,
 -1.479629791944071e-16,  8.595947236208934e-18, -4.326504432797897e-19,  1.924652091895027e-20, -7.683224903510752e-22,  2.785503820444267e-23, -9.252054462540436e-25,
  1.378604142897713e-12, -4.559743065990058e-13,  7.917438350555892e-14, -9.350876267862809e-15,  8.397303021010190e-16, -6.101260956425812e-17,  3.731365236849514e-18,
 -1.974078376708202e-19,  9.217317443460260e-21, -3.856737123229807e-22,  1.463626312538022e-23, -5.081969481191475e-25,  4.482955575627102e-13, -1.559242042872107e-13,
  2.853924404590005e-14, -3.550609470032006e-15,  3.354597451786701e-16, -2.560756511912332e-17,  1.643075132576063e-18, -9.107540414122645e-20,  4.449531481605809e-21,
 -1.945587756072050e-22,  7.706413351612424e-24, -2.789349980542680e-25,  1.526919328113437e-13, -5.559022058079711e-14,  1.067874923194625e-14, -1.393738097985326e-15,
  1.379939968970720e-16, -1.102557993792882e-17,  7.395417965639535e-19, -4.280003531755793e-20,  2.180595580333641e-21, -9.931779538836200e-23,  4.093170147037925e-24,
 -1.539718817981294e-25,  5.492511369688366e-14, -2.083237785617408e-14,  4.181019158175022e-15, -5.699741386197059e-16,  5.889307903003403e-17, -4.905433426778551e-18,
  3.426362557828354e-19, -2.062689152434542e-20,  1.091989065181297e-21, -5.162638171000136e-23,  2.206320423667893e-24, -8.597227089782556e-26,  2.101501580072393e-14,
 -8.264258192265665e-15,  1.724699411212362e-15, -2.444617026564493e-16,  2.624409331069566e-17, -2.269156013308407e-18,  1.643709237372171e-19, -1.025210271734361e-20,
  5.617900768031230e-22, -2.746650173638589e-23,  1.212794205905598e-24, -4.878144521145255e-26,  8.596204025489097e-15, -3.488016395713159e-15,  7.532091419681094e-16,
 -1.104712251338126e-16,  1.226465209386184e-17, -1.095832143943356e-18,  8.196085070601093e-20, -5.273961688768411e-21,  2.979098928526119e-22, -1.500212228630359e-23,
  6.817665383154731e-25, -2.819958886561917e-26,  3.764565708758154e-15, -1.568374592759581e-15,  3.486542802453303e-16, -5.264763478452302e-17,  6.015047317466179e-18,
 -5.527286029329609e-19,  4.248772687855937e-20, -2.807900272837882e-21,  1.627860820589239e-22, -8.407711393757829e-24,  3.916205663000755e-25, -1.659089208358103e-26,
  1.755232391932822e-15, -7.470958500690912e-16,  1.700731436397025e-16, -2.630226231319405e-17,  3.076652487735416e-18, -2.893094229615321e-19,  2.274513035867853e-20,
 -1.536515786560086e-21,  9.100374062600850e-23, -4.799168857179812e-24,  2.281206660815780e-25, -9.856594387580019e-27,  8.535501385950671e-16, -3.693208390220972e-16,
  8.562849475781352e-17, -1.348938974614745e-17,  1.606895117126884e-18, -1.538228855015472e-19,  1.230597543080814e-20, -8.455659194752218e-22,  5.091731573327998e-23,
 -2.728872425983199e-24,  1.317684383147607e-25, -5.781057752223164e-27,  4.070281105257949e-16, -1.781335338585010e-16,  4.183148102486940e-17, -6.675311875953230e-18,
  8.053613551955941e-19, -7.806180680068376e-20,  6.321556553367412e-21, -4.395585958250582e-22,  2.677727223612619e-23, -1.451399734072272e-24,  7.085848413649254e-26,
 -3.142153822872849e-27,  1.487084246174563e-16, -6.549514488446011e-17,  1.549032552691926e-17, -2.489742390951158e-18,  3.025250927510454e-19, -2.952817680648098e-20,
  2.407580098515579e-21, -1.685235039049121e-22,  1.033296027852332e-23, -5.636227651506154e-25,  2.768636371616605e-26, -1.235086720385815e-27,  6.293851566126764e-02,
 -1.641401943394676e-04,  4.441518371184428e-07, -1.239189951202258e-09,  3.537980494895386e-12, -1.026619332565446e-14,  3.009305944484583e-17, -8.874283316400038e-20,
  2.623432906610399e-22, -7.761913792644694e-25,  2.293709477529172e-27, -6.769805151431764e-30,  5.887356957429717e-02, -1.924866545980843e-04,  7.501706430052756e-07,
 -3.049031320968204e-09,  1.228766470114245e-11, -4.853021976757952e-14,  1.878059969449442e-16, -7.138431040507982e-19,  2.671374627389164e-21, -9.862694115782547e-24,
  3.597972473163963e-26, -1.298611728561166e-28,  5.151886978453107e-02, -2.366947642335779e-04,  1.309586368158897e-06, -6.961966648200558e-09,  3.509802063663406e-11,
 -1.696475355623916e-13,  7.931269817936259e-16, -3.607564787457667e-18,  1.603000457660290e-20, -6.979403264384513e-23,  2.984638496390287e-25, -1.255942249116513e-27,
  4.218241471226979e-02, -2.778107020632540e-04,  2.012963137370375e-06, -1.317796133934993e-08,  8.008246616360909e-11, -4.607414960291828e-13,  2.538263102182340e-15,
 -1.348990983868064e-17,  6.953478928793776e-20, -3.490406165403366e-22,  1.711610618178402e-24, -8.220125320777765e-27,  3.232458044029816e-02, -2.989850499573292e-04,
  2.703394355877492e-06, -2.129382420861325e-08,  1.533000584443391e-10, -1.032455751208581e-12,  6.594326051359611e-15, -4.031377731543605e-17,  2.374761847135091e-19,
 -1.354721343479984e-21,  7.513371185393525e-24, -4.063582245461170e-26,  2.319156102430331e-02, -2.920210007031873e-04,  3.213208734284622e-06, -3.004603303430264e-08,
  2.529966090466707e-10, -1.970006413197782e-12,  1.441759107967399e-14, -1.002689606849164e-16,  6.679053505077518e-19, -4.286477036393014e-21,  2.662593267932166e-23,
 -1.606521032632500e-25,  1.558571340775860e-02, -2.590489857888838e-04,  3.418557923160017e-06, -3.755347252474738e-08,  3.660798272997702e-10, -3.264441078548743e-12,
  2.713248100159989e-14, -2.128620517907934e-16,  1.590546672654435e-18, -1.139597000558728e-20,  7.869803751375242e-23, -5.259573934736327e-25,  9.816916228072179e-03,
 -2.095604507777948e-04,  3.282893206505546e-06, -4.198977427502042e-08,  4.699479632312694e-10, -4.762679290147963e-12,  4.463789353738907e-14, -3.924082259096128e-16,
  3.268272902430132e-18, -2.598322360449119e-20,  1.983195202813222e-22, -1.459809023718194e-24,  5.799352127461465e-03, -1.553093970102777e-04,  2.863849381571401e-06,
 -4.231930173800265e-08,  5.400139659428577e-10, -6.180630091003157e-12,  6.493976148462116e-14, -6.361727382916077e-16,  5.875061786924101e-18, -5.156822880824777e-20,
  4.329368345267977e-22, -3.493669742483042e-24,  3.215891333648148e-03, -1.059111959028614e-04,  2.281237761749639e-06, -3.868001954631092e-08,  5.594026007993747e-10,
 -7.191871310487245e-12,  8.429190410656669e-14, -9.159146724922473e-16,  9.337510991777124e-18, -9.010834822585348e-20,  8.287430296485740e-22, -7.303131342751456e-24,
  1.675580510453200e-03, -6.672038217131234e-05,  1.666660975794307e-06, -3.222847424424414e-08,  5.255056387859602e-10, -7.553502020776734e-12,  9.833010794442238e-14,
 -1.180352941016271e-15,  1.323350540196378e-17, -1.398941899318701e-19,  1.404621576242704e-21, -1.347186931113272e-23,  8.212317458088712e-04, -3.896768710095414e-05,
  1.121270639501076e-06, -2.459136955891334e-08,  4.499758122873323e-10, -7.201225410626433e-12,  1.037257863213119e-13, -1.370665384524327e-15,  1.684356442677511e-17,
 -1.944349627485322e-19,  2.124824725514410e-21, -2.211591342614766e-23,  3.791183925392336e-04, -2.116992903864639e-05,  6.972117381536778e-07, -1.725534288445873e-08,
  3.528214372831687e-10, -6.263099438505780e-12,  9.947886521633444e-14, -1.442523780258100e-15,  1.937212845531502e-17, -2.435077308924301e-19,  2.888585597924272e-21,
 -3.254321114981492e-23,  1.651017288302807e-04, -1.073171163015525e-05,  4.021053577587761e-07, -1.117783582371322e-08,  2.544011703584326e-10, -4.992088572348168e-12,
  8.716437163377285e-14, -1.383046995155950e-15,  2.024330605386263e-17, -2.763845639252205e-19,  3.550288951901573e-21, -4.319448274513054e-23,  6.794412402821848e-05,
 -5.091989162521924e-06,  2.158391150159700e-07, -6.709913147440479e-09,  1.693690728657954e-10, -3.662271882934403e-12,  7.009450896512234e-14, -1.213806677743395e-15,
  1.931624553489990e-17, -2.857927442871924e-19,  3.966678357396203e-21, -5.200789631379810e-23,  2.647524347595214e-05, -2.268366171607980e-06,  1.081998791218155e-07,
 -3.746354116145810e-09,  1.045217620460087e-10, -2.483085886744550e-12,  5.195760836907499e-14, -9.795495596016785e-16,  1.691011076658706e-17, -2.705500367812365e-19,
  4.049235100850554e-21, -5.710244313573642e-23,  9.790417817790678e-06, -9.517459487013381e-07,  5.083315880952255e-08, -1.952767834936095e-09,  6.002549280866489e-11,
 -1.562347707786553e-12,  3.565124198512002e-14, -7.300840673587825e-16,  1.364333743623747e-17, -2.355764034736236e-19,  3.794807556153607e-21, -5.745531683330642e-23,
  3.444739912331295e-06, -3.773567300138142e-07,  2.246268756204328e-08, -9.538902938908675e-10,  3.220657640938377e-11, -9.159890985394643e-13,  2.274028808603913e-14,
 -5.047482812719311e-16,  1.019012713229161e-17, -1.895330658471608e-19,  3.280228105185527e-21, -5.323128949194383e-23,  1.156583914104222e-06, -1.418863895221987e-07,
  9.371742027681743e-09, -4.384043376981884e-10,  1.621102398206843e-11, -5.025190832253967e-13,  1.354181472069245e-14, -3.251127868886361e-16,  7.077193190470080e-18,
 -1.415400774147207e-19,  2.627372282027407e-21, -4.562504320810197e-23,  3.717941027844106e-07, -5.078561528968369e-08,  3.706609742902973e-09, -1.903683337121671e-10,
  7.687612816700064e-12, -2.590937184690192e-13,  7.562044263717809e-15, -1.959741660924895e-16,  4.591324741844047e-18, -9.856248410562081e-20,  1.959122607258940e-21,
 -3.634796825530414e-23,  1.148569024970309e-07, -1.737601977358417e-08,  1.395771050257791e-09, -7.844949257437402e-11,  3.450263528513687e-12, -1.261221845703292e-13,
  3.978230947837320e-15, -1.110688045866019e-16,  2.795423599032543e-18, -6.430309900281965e-20,  1.366428035980930e-21, -2.704407256543355e-23,  3.424283908148646e-08,
 -5.708692532139044e-09,  5.027687806298965e-10, -3.082724571283705e-11,  1.472611466217434e-12, -5.824587199475277e-14,  1.981283212178841e-15, -5.947535287408565e-17,
  1.605155895001578e-18, -3.949760214481385e-20,  8.958394799076774e-22, -1.888489097801361e-23,  9.899028252670483e-09, -1.809920355705342e-09,  1.741213191206461e-10,
 -1.161092775597069e-11,  6.008262355792257e-13, -2.565255621320947e-14,  9.389882483282848e-16, -3.024688403966941e-17,  8.737517473028840e-19, -2.295951902647998e-20,
  5.549061474007401e-22, -1.244020698281323e-23,  2.789456217147449e-09, -5.567925210722288e-10,  5.830114042501034e-11, -4.215141948025789e-12,  2.356460468791694e-13,
 -1.083443865778287e-14,  4.258311998815751e-16, -1.468978114010650e-17,  4.533533051526299e-19, -1.269896207909497e-20,  3.265112491408523e-22, -7.772092032146497e-24,
  7.707332519953163e-10, -1.672047113102281e-10,  1.898782565679657e-11, -1.483895032355094e-12,  8.938066603274945e-14, -4.414646763849529e-15,  1.858916003503887e-16,
 -6.853266985294303e-18,  2.255246395889801e-19, -6.721884634465157e-21,  1.835453065858813e-22, -4.631226522967883e-24,  2.101713102524695e-10, -4.933868182244574e-11,
  6.055014322679746e-12, -5.099135316207349e-13,  3.300145279899738e-14, -1.746641808457445e-15,  7.861372864281495e-17, -3.090747851005145e-18,  1.082328450669965e-19,
 -3.426049366506147e-21,  9.916998308721242e-23, -2.647831715540690e-24,  5.696897272567979e-11, -1.440914098155148e-11,  1.904210509702571e-12, -1.722602315175152e-13,
  1.194500270243141e-14, -6.756888144756940e-16,  3.242839135285661e-17, -1.356558531220194e-18,  5.044404110989958e-20, -1.692411167647682e-21,  5.183119971247515e-23,
 -1.461692452005906e-24,  1.547019370429089e-11, -4.197564047031871e-12,  5.951782540225803e-13, -5.765037533292123e-14,  4.270599604835382e-15, -2.574880364437894e-16,
  1.314367481139693e-17, -5.836336505202582e-19,  2.299350488041951e-20, -8.158823332277008e-22,  2.638257988634992e-23, -7.842883668570946e-25,  4.244433311883616e-12,
 -1.230058613652677e-12,  1.864371851187543e-13, -1.927152957017613e-14,  1.520366692880273e-15, -9.742637391508089e-17,  5.275281606838380e-18, -2.480115020565678e-19,
  1.032707054434263e-20, -3.866518364421924e-22,  1.317193805197198e-23, -4.118812819500055e-25,  1.187238180483524e-12, -3.658691483313405e-13,  5.905002836534012e-14,
 -6.490967768202331e-15,  5.435920212279708e-16, -3.690923839439431e-17,  2.113785093006868e-18, -1.049300016179849e-19,  4.605850568408146e-21, -1.815036376069251e-22,
  6.498435846412787e-24, -2.132480218877597e-25,  3.418106390077998e-13, -1.115059884211955e-13,  1.908727886179296e-14, -2.222985224320809e-15,  1.969386255997819e-16,
 -1.412243680894615e-17,  8.527979166024798e-19, -4.456701226458604e-20,  2.056357708398779e-21, -8.505992580500456e-23,  3.192300422115069e-24, -1.096560622195569e-25,
  1.022894362051616e-13, -3.516169274881722e-14,  6.357006495080063e-15, -7.813652606377769e-16,  7.295911011756403e-17, -5.506240611467048e-18,  3.494232736198791e-19,
 -1.916276640817836e-20,  9.265805957353952e-22, -4.011198901798640e-23,  1.573498481009585e-24, -5.642162988171980e-26,  3.213342520996699e-14, -1.158454104307291e-14,
  2.202399660830764e-15, -2.845178767356192e-16,  2.789053977031723e-17, -2.206970113983820e-18,  1.466518949348727e-19, -8.410620349272014e-21,  4.247590849494652e-22,
 -1.918218554095231e-23,  7.840596845994122e-25, -2.925945900323954e-26,  1.069760616655748e-14, -4.025323810782956e-15,  8.010402053284889e-16, -1.082858556115355e-16,
  1.109720587001730e-17, -9.169850781104590e-19,  6.355639132271432e-20, -3.797562975569655e-21,  1.995887798331767e-22, -9.369878522012488e-24,  3.977126142432361e-25,
 -1.539552393399620e-26,  3.806372331730919e-15, -1.487583298717872e-15,  3.083704154463638e-16, -4.341796354739988e-17,  4.630784523051077e-18, -3.978598479838389e-19,
  2.864278115992732e-20, -1.775860711879238e-21,  9.675095571122668e-23, -4.703778007771374e-24,  2.065699614189142e-25, -8.265104442650197e-27,  1.457016842160524e-15,
 -5.884510245049655e-16,  1.264271412720075e-16, -1.844901368464171e-17,  2.038093798106012e-18, -1.812237438278898e-19,  1.349087341692482e-20, -8.641591754096619e-22,
  4.859867281823071e-23, -2.436872483397857e-24,  1.102839849455333e-25, -4.543334688557012e-27,  6.017051368387128e-16, -2.498537852087194e-16,  5.534226504228431e-17,
 -8.326576811174892e-18,  9.479437106750470e-19, -8.680616622945634e-20,  6.650270699971360e-21, -4.380636259468685e-22,  2.531596071151971e-23, -1.303519387205645e-24,
  6.053512841206318e-26, -2.557147367487101e-27,  2.669623434248440e-16, -1.133850297836916e-16,  2.575009146004314e-17, -3.972801248462329e-18,  4.636188613586876e-19,
 -4.349595501247897e-20,  3.411970029155923e-21, -2.299914055490665e-22,  1.359310612481206e-23, -7.153801565571139e-25,  3.393693995564321e-26, -1.463522629292441e-27,
  1.248165081715445e-16, -5.393873804743224e-17,  1.248839289715498e-17, -1.964573702638661e-18,  2.337011556912222e-19, -2.234113312538361e-20,  1.784950618517043e-21,
 -1.224895216394961e-22,  7.366710451101304e-24, -3.943329067622168e-25,  1.901855694890896e-26, -8.334423000917713e-28,  5.788061940420912e-17, -2.531533227234913e-17,
  5.940694344279295e-18, -9.473241089408756e-19,  1.142127649762654e-19, -1.106280387333998e-20,  8.952825085457225e-22, -6.221129827842751e-23,  3.787409087969565e-24,
 -2.051602459744142e-25,  1.001002289808843e-26, -4.436239960642582e-28,  2.081539281085212e-17, -9.165204586000690e-18,  2.167016289841729e-18, -3.481948267721598e-19,
  4.229570249182194e-20, -4.127053253535583e-21,  3.363991086831311e-22, -2.354005285566050e-23,  1.442935243476600e-24, -7.868428579233023e-26,  3.864070595379299e-27,
 -1.723291736911332e-28,  6.228896847319455e-02, -1.606455137832748e-04,  4.296145529890110e-07, -1.184186440955841e-09,  3.339682489270837e-12, -9.572854057851999e-15,
  2.772171211481726e-17, -8.077779288671423e-20,  2.359825695882574e-22, -6.901294908389673e-25,  2.015843587976829e-27, -5.882685491605104e-30,  5.811539858298517e-02,
 -1.866283729205390e-04,  7.147306281533465e-07, -2.859955247996279e-09,  1.136056331466413e-11, -4.425338584484283e-14,  1.689637064315299e-16, -6.337730604064243e-19,
  2.340903519997616e-21, -8.531519327722804e-24,  3.072719392721830e-26, -1.095046082645402e-28,  5.059252814594958e-02, -2.265429523370628e-04,  1.229303469763664e-06,
 -6.426541016233098e-09,  3.188752845258166e-11, -1.517689071191009e-13,  6.989347068468045e-16, -3.132605707706134e-18,  1.371963722882169e-20, -5.889091125246005e-23,
  2.483320272659992e-25, -1.030626842354964e-27,  4.110240764382617e-02, -2.623184361204095e-04,  1.862221809960618e-06, -1.196717466948611e-08,  7.144747613478549e-11,
 -4.041155084851677e-13,  2.189898469274722e-15, -1.145330636201510e-17,  5.811926832379452e-20, -2.872942853348728e-22,  1.387737926239424e-24, -6.566542639882650e-27,
  3.117033308582797e-02, -2.783398163666261e-04,  2.461930691951272e-06, -1.899798608785179e-08,  1.341464040363406e-10, -8.869217143313974e-13,  5.564992002881667e-15,
 -3.344017943543646e-17,  1.937111249526150e-19, -1.087106086229401e-21,  5.933209417822605e-24, -3.158820563433287e-26,  2.207269821382256e-02, -2.676916021695806e-04,
  2.875702200572104e-06, -2.629540064266161e-08,  2.168411950950489e-10, -1.655395016922290e-12,  1.188747252664771e-14, -8.117251550576785e-17,  5.311737128461622e-19,
 -3.350419607562704e-21,  2.046217383072018e-23, -1.214318318323522e-25,  1.460149463794757e-02, -2.334082571125200e-04,  3.001014694715724e-06, -3.218505272739026e-08,
  3.068482212077011e-10, -2.679390191250456e-12,  2.182731633806159e-14, -1.679636248963505e-16,  1.231788217074224e-18, -8.666416552639396e-21,  5.879581169885143e-23,
 -3.861889763862016e-25,  9.028180863775024e-03, -1.851918672653532e-04,  2.821166383204371e-06, -3.517796139718508e-08,  3.845750895978045e-10, -3.812213458690719e-12,
  3.498425705805693e-14, -3.013761659331122e-16,  2.461432393795368e-18, -1.920054807346785e-20,  1.438651292002183e-22, -1.040036624049484e-24,  5.220915500111167e-03,
 -1.342919176191178e-04,  2.404038517412551e-06, -3.458899265614776e-08,  4.306469934793125e-10, -4.816188545659168e-12,  4.950205922738549e-14, -4.748109390452750e-16,
  4.296510357649996e-18, -3.697597941540988e-20,  3.045339879870013e-22, -2.412009304935430e-24,  2.826007920395880e-03, -8.937603571249616e-05,  1.866367148901129e-06,
 -3.077850900445989e-08,  4.338805027539636e-10, -5.445631776451560e-12,  6.238404698967448e-14, -6.631986368454656e-16,  6.620183759971740e-18, -6.259682665150273e-20,
  5.644359493436018e-22, -4.879116263551867e-24,  1.433103835574034e-03, -5.480182435296744e-05,  1.325769107574354e-06, -2.491115393130572e-08,  3.955866694125250e-10,
 -5.546618305140553e-12,  7.052280487924353e-14, -8.276785747053053e-16,  9.080345103646889e-18, -9.399875799458822e-20,  9.248116812959256e-22, -8.696394439153458e-24,
  6.815917759579140e-04, -3.106564200444012e-05,  8.650240259988284e-07, -1.842072458555102e-08,  3.280261440294816e-10, -5.117368906288476e-12,  7.194756707880314e-14,
 -9.289942590457135e-16,  1.116494934557816e-17, -1.261456567768492e-19,  1.350168959927694e-21, -1.377200600832932e-23,  3.044065745203274e-04, -1.633326468594677e-05,
  5.202703339472073e-07, -1.249514433331754e-08,  2.484930810715329e-10, -4.297612078227300e-12,  6.659315870621877e-14, -9.431065285015353e-16,  1.238105515416559e-17,
 -1.522592040975629e-19,  1.768281986160030e-21, -1.951618849026083e-23,  1.278475948490176e-04, -7.989117688515362e-06,  2.894341996893540e-07, -7.804447387972103e-09,
  1.726846844836915e-10, -3.299946208630971e-12,  5.618805066903826e-14, -8.703836843941723e-16,  1.244912210750225e-17, -1.662315991923888e-19,  2.089882275967479e-21,
 -2.490165858502820e-23,  5.057802206346992e-05, -3.646309156211079e-06,  1.494297739854696e-07, -4.504978859615213e-09,  1.105177020026059e-10, -2.326508455695317e-12,
  4.340974934874755e-14, -7.336626039737860e-16,  1.140605139922871e-17, -1.650048899436491e-19,  2.240938143247279e-21, -2.876880016057792e-23,  1.888391712156054e-05,
 -1.557538521384785e-06,  7.183528827291114e-08, -2.411877324307889e-09,  6.538978856942586e-11, -1.512077703503942e-12,  3.083901783939000e-14, -5.673391374960786e-16,
  9.566518782878378e-18, -1.496300554678746e-19,  2.190979401042437e-21, -3.024914632517464e-23,  6.668615365019636e-06, -6.245905529743635e-07,  3.226477921027704e-08,
 -1.202000147080087e-09,  3.590417412641349e-11, -9.095913964428515e-13,  2.022947271615660e-14, -4.042196429767239e-16,  7.377796006308200e-18, -1.245301206556718e-19,
  1.962469402468291e-21, -2.908825407928915e-23,  2.232968515475835e-06, -2.359028421352284e-07,  1.358764405335394e-08, -5.597049399370211e-10,  1.836633947946416e-11,
 -5.084712829012810e-13,  1.230380379681973e-14, -2.664849006540420e-16,  5.254796202850455e-18, -9.554645998864716e-20,  1.617789874819199e-21, -2.570276962333726e-23,
  7.110132695232497e-07, -8.420925157656749e-08,  5.385219266440027e-09, -2.444610171259896e-10,  8.787959965873153e-12, -2.652320592877332e-13,  6.967849960211781e-15,
 -1.632606447028913e-16,  3.471782248248676e-18, -6.788700093248247e-20,  1.233043783719836e-21, -2.096606042280115e-23,  2.159929221869549e-07, -2.851732406521162e-08,
  2.016680173488428e-09, -1.005648317522816e-10,  3.949795391407762e-12, -1.296562104834691e-13,  3.690298496174855e-15, -9.336214354405993e-17,  2.137319524226310e-18,
 -4.487130285504495e-20,  8.729203797863614e-22, -1.586187716137527e-23,  6.283198553408866e-08, -9.199553411211629e-09,  7.166614178211358e-10, -3.913682859672907e-11,
  1.675063634659761e-12, -5.966801560544357e-14,  1.836202162671177e-15, -5.006690172955218e-17,  1.231778659140593e-18, -2.772051947638928e-20,  5.767202337491351e-22,
 -1.118307772385150e-23,  1.757641765987538e-08, -2.839886804702485e-09,  2.428111418609362e-10, -1.447767153310608e-11,  6.735196531968712e-13, -2.597625394213405e-14,
  8.625629116221975e-16, -2.530131269224494e-17,  6.678353491703246e-19, -1.608483162449460e-20,  3.573436758780620e-22, -7.383745906698844e-24,  4.750684505301191e-09,
 -8.431149984884459e-10,  7.883649334604132e-11, -5.117246944941260e-12,  2.581030173052351e-13, -1.075382102853539e-14,  3.845350768896117e-16, -1.211177990405517e-17,
  3.424009746528761e-19, -8.811787234947832e-21,  2.087283244448594e-22, -4.589218363309740e-24,  1.247350712739373e-09, -2.420661123219351e-10,  2.466808665417104e-11,
 -1.738025263502058e-12,  9.480181048918580e-14, -4.257450899180258e-15,  1.636038546096164e-16, -5.522923061897602e-18,  1.669313072567589e-19, -4.582858067336174e-21,
  1.155653622484103e-22, -2.699652730888342e-24,  3.200685310829273e-10, -6.762585710296917e-11,  7.484844503369357e-12, -5.707510285372473e-13,  3.358129445139763e-14,
 -1.621789912097909e-15,  6.683412603675629e-17, -2.413437412278531e-18,  7.785056756415611e-20, -2.276099915076952e-21,  6.100369721490935e-23, -1.511781907050405e-24,
  8.080545176856027e-11, -1.850874162176055e-11,  2.217309027615987e-12, -1.824529303543472e-13,  1.154923820605725e-14, -5.983904143992826e-16,  2.638777544795454e-17,
 -1.017244594570272e-18,  3.495312422660891e-20, -1.086351260689815e-21,  3.089377193227528e-23, -8.108668121745656e-25,  2.022206082783331e-11, -5.000143151587847e-12,
  6.461135347488888e-13, -5.719828562201845e-14,  3.884731071689175e-15, -2.154035611710668e-16,  1.014129665373627e-17, -4.164617056874029e-19,  1.521245595008985e-20,
 -5.016639584521655e-22,  1.510993994592059e-23, -4.193063247422980e-25,  5.057935390263910e-12, -1.344311320528648e-12,  1.867117427474349e-13, -1.772723216459218e-14,
  1.288149531871715e-15, -7.624099111241189e-17,  3.822961190370393e-18, -1.668604548593318e-19,  6.465594008114273e-21, -2.257689810574065e-22,  7.188124244409396e-24,
 -2.105031576340246e-25,  1.275826672160345e-12, -3.629235726493764e-13,  5.398274721882275e-14, -5.479065742507980e-15,  4.247027175679932e-16, -2.675694836538360e-17,
  1.425258606073621e-18, -6.595650230473501e-20,  2.704803191585501e-21, -9.978661814341515e-23,  3.351225555117570e-24, -1.033553121658610e-25,  3.277198026382290e-13,
 -9.933804575316402e-14,  1.576465983272241e-14, -1.704635917461325e-15,  1.405038269881092e-16, -9.394697786311123e-18,  5.301188977660119e-19, -2.594166449477441e-20,
  1.123059939763279e-21, -4.366879055166001e-23,  1.543385665139202e-24, -5.001684178374133e-26,  8.661710656815578e-14, -2.785176146609151e-14,  4.697160892105325e-15,
 -5.391408574948785e-16,  4.709402192038278e-17, -3.331331299752003e-18,  1.985307805607953e-19, -1.024380007301288e-20,  4.668693462146321e-22, -1.908292587663019e-23,
  7.079659409667542e-25, -2.404891836354917e-26,  2.381201044378293e-14, -8.084879758114587e-15,  1.442993262531445e-15, -1.751345081010675e-16,  1.615329913713526e-17,
 -1.204679015713373e-18,  7.557391149952428e-20, -4.098702239241908e-21,  1.960635620810377e-22, -8.399699307861991e-24,  3.261933208940881e-25, -1.158292674731547e-26,
  6.884448465881011e-15, -2.456449696678846e-15,  4.619536361770615e-16, -5.904060410085292e-17,  5.727460207062388e-18, -4.486467051850908e-19,  2.952152099042039e-20,
 -1.677100330489505e-21,  8.392392205829621e-23, -3.756470733093917e-24,  1.522268253080553e-25, -5.633677848249027e-27,  2.116016826441139e-15, -7.895677700969416e-16,
  1.557254795047237e-16, -2.086575756465844e-17,  2.119966035908456e-18, -1.737162742854433e-19,  1.194299185275803e-20, -7.080201107744171e-22,  3.692930874795421e-23,
 -1.720946167083134e-24,  7.252716393503921e-26, -2.788214271390664e-27,  6.983438603667393e-16, -2.711311174201690e-16,  5.580734131358818e-17, -7.802434282039424e-18,
  8.264717263226158e-19, -7.053433634476340e-20,  5.045104563761818e-21, -3.108388447781320e-22,  1.683208145543810e-23, -8.135187746799553e-25,  3.552263692853563e-26,
 -1.413466069203740e-27,  2.494739011514087e-16, -1.002590784430349e-16,  2.142491573207102e-17, -3.109754799793260e-18,  3.417442072120296e-19, -3.023275556588357e-20,
  2.239511078095984e-21, -1.427651955114092e-22,  7.991570706477792e-24, -3.989160785858074e-25,  1.797471432082208e-26, -7.373732515651373e-28,  9.689699996335616e-17,
 -4.009515885967898e-17,  8.846973552589676e-18, -1.325981025833824e-18,  1.503901331334624e-19, -1.372131579840510e-20,  1.047461696359524e-21, -6.875990956455604e-23,
  3.960379112212361e-24, -2.032581285711503e-25,  9.409541770878339e-27, -3.962706617972022e-28,  4.081081141244368e-17, -1.729365738792819e-17,  3.917514076918473e-18,
 -6.028745304321544e-19,  7.017936626058847e-20, -6.568137159535673e-21,  5.140110810405544e-22, -3.456863232036140e-23,  2.038551570163388e-24, -1.070534673174077e-25,
  5.067864996413531e-27, -2.181069600720884e-28,  1.830804913653701e-17, -7.901169157207087e-18,  1.826634887195120e-18, -2.869226547441606e-19,  3.408153457143178e-20,
 -3.253418865482013e-21,  2.595695114749679e-22, -1.778835004646096e-23,  1.068405363781845e-24, -5.711726193292706e-26,  2.751310359639301e-27, -1.204237150158776e-28,
  8.243522734091714e-18, -3.603106690481505e-18,  8.449085754791841e-19, -1.346316560889654e-19,  1.621972484687891e-20, -1.569931496927841e-21,  1.269607457560245e-22,
 -8.816170593100613e-24,  5.363666750691694e-25, -2.903548087033970e-26,  1.415775394018396e-27, -6.270549923685464e-29,  2.915566657587517e-18, -1.283392794420063e-18,
  3.033490580992715e-19, -4.872630657831833e-20,  5.916963436371333e-21, -5.771729495477764e-22,  4.703121267113544e-23, -3.290080867787773e-24,  2.016119119196213e-25,
 -1.099081693420247e-26,  5.395876833802220e-28, -2.405766677701092e-29,  6.165317151628510e-02, -1.572645442345279e-04,  4.157187221644788e-07, -1.132247782605303e-09,
  3.154699729600130e-12, -8.933843404887427e-15,  2.556202721353368e-17, -7.360879512086448e-20,  2.125290705200481e-22, -6.144396700152011e-25,  1.774200179518284e-27,
 -5.120003820501355e-30,  5.738010770029452e-02, -1.810447815370289e-04,  6.814732695967695e-07, -2.685052332806330e-09,  1.051465206269203e-11, -4.040301547063082e-14,
  1.522222511366004e-16, -5.635501965925802e-19,  2.054779140767323e-21, -7.393577046219906e-24,  2.629344479795501e-26, -9.253527947766020e-29,  4.970554872294906e-02,
 -2.170085500518772e-04,  1.155148885731659e-06, -5.939741129566314e-09,  2.901303821260724e-11, -1.359993120022994e-13,  6.170625983258341e-16, -2.725666618786827e-18,
  1.176795457481477e-20, -4.980804507415852e-23,  2.071404769384259e-25, -8.479942886938526e-28,  4.008204659174074e-02, -2.479762485404910e-04,  1.725216916450083e-06,
 -1.088592327828737e-08,  6.386581242967145e-11, -3.552052839486069e-13,  1.893761716810238e-15, -9.748798326915416e-18,  4.870995394690912e-20, -2.371570711665497e-22,
  1.128610671359162e-24, -5.262636004665447e-27,  3.009497065683962e-02, -2.595210888466236e-04,  2.246270211390850e-06, -1.698660054397519e-08,  1.176711978798301e-10,
 -7.639319358462838e-13,  4.709877619178268e-15, -2.782437787024224e-17,  1.585323124473694e-19, -8.753994887480517e-22,  4.702596766322629e-24, -2.464974108648779e-26,
  2.104602466185853e-02, -2.458916021815291e-04,  2.579929768281915e-06, -2.307604303979486e-08,  1.864116623060228e-10, -1.395554966217408e-12,  9.835543944852247e-15,
 -6.595671649999478e-17,  4.240888779211645e-19, -2.629565141922813e-21,  1.579315326388635e-23, -9.219980509814953e-26,  1.371354446445917e-02, -2.108654547471320e-04,
  2.642571108371516e-06, -2.767724321550133e-08,  2.581398847018704e-10, -2.207789068624942e-12,  1.763232668756989e-14, -1.331156191980061e-16,  9.583321623454468e-19,
 -6.622282999391423e-21,  4.414634310419328e-23, -2.850347179968691e-25,  8.330018925663549e-03, -1.642119857213964e-04,  2.433574296645863e-06, -2.959181142238781e-08,
  3.160869477393190e-10, -3.065554228576659e-12,  2.755196136246822e-14, -2.326429182165092e-16,  1.863639742536343e-18, -1.426687029954013e-20,  1.049606140104786e-22,
 -7.453577916264894e-25,  4.719739901488221e-03, -1.166096677287754e-04,  2.027331418471620e-06, -2.840893589435883e-08,  3.452022097327166e-10, -3.773290200041980e-12,
  3.794770717183852e-14, -3.564627452768412e-16,  3.161260077033771e-18, -2.668006818057237e-20,  2.156064496154376e-22, -1.676379297109056e-24,  2.496182811832828e-03,
 -7.581222998382074e-05,  1.535330692746550e-06, -2.463228143082756e-08,  3.385513216973452e-10, -4.149247036351031e-12,  4.647034646528572e-14, -4.834390067264919e-16,
  4.726160765185882e-18, -4.379504529914076e-20,  3.872369925064751e-22, -3.284120598595100e-24,  1.233357093664972e-03, -4.529167754964277e-05,  1.061428510791125e-06,
 -1.938459085761780e-08,  2.998598997658265e-10, -4.102225358969689e-12,  5.095394991825252e-14, -5.847982013017144e-16,  6.279271584710940e-18, -6.366562626156636e-20,
  6.138822732936693e-22, -5.660598190049958e-24,  5.698860417121065e-04, -2.494763146042130e-05,  6.723697570555409e-07, -1.390543365577295e-08,  2.410313357780196e-10,
 -3.666247743222879e-12,  5.032289318783735e-14, -6.350329676314950e-16,  7.465501608160954e-18, -8.257032621422785e-20,  8.657207156061871e-22, -8.655295706238566e-24,
  2.465356790567214e-04, -1.270928853264340e-05,  3.916060776734242e-07, -9.128268782201709e-09,  1.765957691065167e-10, -2.976105452466800e-12,  4.499725083470960e-14,
 -6.224832885166407e-16,  7.989797712010007e-18, -9.614303051429031e-20,  1.093311648116776e-21, -1.182267073424159e-23,  9.998918424058910e-05, -6.005865302812564e-06,
  2.103970999210693e-07, -5.503756318694694e-09,  1.184079886631545e-10, -2.203867560534694e-12,  3.659856410643919e-14, -5.535529329677931e-16,  7.737987793375643e-18,
 -1.010649417378768e-19,  1.243712034323437e-21, -1.451504651600675e-23,  3.807948421353568e-05, -2.640249549108520e-06,  1.046101545015745e-07, -3.058637774724625e-09,
  7.293386070509031e-11, -1.494867279916982e-12,  2.719443633527383e-14, -4.486193919020489e-16,  6.814389780887462e-18, -9.639715625783237e-20,  1.281136989620658e-21,
 -1.610557030361954e-23,  1.364220363446276e-05, -1.082901885882107e-06,  4.828908535110852e-08, -1.572196047650653e-09,  4.142254287288554e-11, -9.324060474477851e-13,
  1.853653418722398e-14, -3.327858348083417e-16,  5.481461456108516e-18, -8.382115721543229e-20,  1.200866723335682e-21, -1.623263671708700e-23,  4.607296707024140e-06,
 -4.156309107875341e-07,  2.076323209010852e-08, -7.501051372724279e-10,  2.177273759201783e-11, -5.368806298563770e-13,  1.163766477175211e-14, -2.269052516820309e-16,
  4.045085417980445e-18, -6.674594609149909e-20,  1.029050224853921e-21, -1.493267639194168e-23,  1.470373024478234e-06, -1.497518568324771e-07,  8.344543984752009e-09,
 -3.333865498511728e-10,  1.063161941439485e-11, -2.864986233385948e-13,  6.756947103186318e-15, -1.428005087995429e-16,  2.750335567592497e-18, -4.888699082067976e-20,
  8.098145186215578e-22, -1.259605731097349e-23,  4.446697231228518e-07, -5.082231244434655e-08,  3.145950245462484e-09, -1.385589926891673e-10,  4.841735028039763e-12,
 -1.422630876498032e-13,  3.643166083137553e-15, -8.330251471420065e-17,  1.730404323383886e-18, -3.308068618331842e-20,  5.878881813540517e-22, -9.787443859006796e-24,
  1.278390763950291e-07, -1.630637127783430e-08,  1.116966053068381e-09, -5.406770415069280e-11,  2.064985543384160e-12, -6.601185782668463e-14,  1.831969983502451e-15,
 -4.524040337504979e-17,  1.011902043716266e-18, -2.077402884284756e-20,  3.954965354234727e-22, -7.037944179806139e-24,  3.506666032422436e-08, -4.966429229989547e-09,
  3.750684363736292e-10, -1.989520357322379e-11,  8.284579185013584e-13, -2.875145174198614e-14,  8.630537068838633e-16, -2.297856088082764e-17,  5.525401289965353e-19,
 -1.216337466679793e-20,  2.477236980241029e-22, -4.705630307133250e-24,  9.216053224527407e-09, -1.442345368994767e-09,  1.196693470028304e-10, -6.936192675857636e-12,
  3.141506371393111e-13, -1.181127218433260e-14,  3.827708380309841e-16, -1.096874578712753e-17,  2.831004195130271e-19, -6.672641483737825e-21,  1.451772215526996e-22,
 -2.939814346657039e-24,  2.331758506351403e-09, -4.014283952014215e-10,  3.646556325259833e-11, -2.303062182596116e-12,  1.131825585205443e-13, -4.600407476955609e-15,
  1.606515486488801e-16, -4.946410792911972e-18,  1.368127143170222e-19, -3.447512342979926e-21,  8.001754530147525e-23, -1.725033174582284e-24,  5.710309331325835e-10,
 -1.076686778216873e-10,  1.067267765667517e-11, -7.324466767751999e-13,  3.896442972343652e-14, -1.708536854267148e-15,  6.416979385349979e-17, -2.119161179756210e-18,
  6.271177922769951e-20, -1.686906987955935e-21,  4.170864570855246e-23, -9.559475847966119e-25,  1.361859108792117e-10, -2.800436430564214e-11,  3.019151065239802e-12,
 -2.245229343318765e-13,  1.289792563317227e-14, -6.088034371948851e-16,  2.454424455251546e-17, -8.678158898063139e-19,  2.743041592960597e-20, -7.864153835902778e-22,
  2.068206090977012e-23, -5.032423185554655e-25,  3.184909671389056e-11, -7.112841946240121e-12,  8.312746800719047e-13, -6.679915201677925e-14,  4.133512852125592e-15,
 -2.095597893155676e-16,  9.050248676624394e-18, -3.419502976504429e-19,  1.152447123157947e-20, -3.515570362842717e-22,  9.818805433057167e-24, -2.532562701980290e-25,
  7.360571395302079e-12, -1.777900468424615e-12,  2.244927546827972e-13, -1.943683290195713e-14,  1.292246499484107e-15, -7.020216412662249e-17,  3.240773534257785e-18,
 -1.305888722506844e-19,  4.683828486154555e-21, -1.517604520046606e-22,  4.493732670414573e-24, -1.226651056694773e-25,  1.695555019989963e-12, -4.411071939844790e-13,
  5.997224151647029e-14, -5.577885407107404e-15,  3.973638597823233e-16, -2.307466389092713e-17,  1.136011269882992e-18, -4.871494806032128e-20,  1.855725599669489e-21,
 -6.374095172885304e-23,  1.997353720474638e-24, -5.759879156865017e-26,  3.930268246408648e-13, -1.096601157643652e-13,  1.599678358097526e-14, -1.593250162924710e-15,
  1.212713616686442e-16, -7.507538116428107e-18,  3.932059602219140e-19, -1.790238036496013e-20,  7.227044848229971e-22, -2.626028324376060e-23,  8.690586154266946e-25,
 -2.642463635942927e-26,  9.262886599620358e-14, -2.759821353073188e-14,  4.303684837344373e-15, -4.574872187310303e-16,  3.709180393176287e-17, -2.441005448487557e-18,
  1.356437436069564e-19, -6.540287927494817e-21,  2.791217386277695e-22, -1.070435159288289e-23,  3.732994632559365e-25, -1.194225231146973e-26,  2.244590642885074e-14,
 -7.109459661966760e-15,  1.180546698072454e-15, -1.334646092073994e-16,  1.148827136294415e-17, -8.012138899790026e-19,  4.709901955242707e-20, -2.398286938331610e-21,
  1.079155736903121e-22, -4.356775657681296e-24,  1.597119290707102e-25, -5.362883350683119e-27,  5.658893324879894e-15, -1.896640178332599e-15,  3.339856503803429e-16,
 -4.000346160416199e-17,  3.642667218559694e-18, -2.683141419022837e-19,  1.663174518065166e-20, -8.916196556500093e-22,  4.217583050904909e-23, -1.787402493751006e-24,
  6.868728346250585e-26, -2.414426990479654e-27,  1.502579133299278e-15, -5.303457150713496e-16,  9.860308741262327e-17, -1.246117236490275e-17,  1.195696918856640e-18,
 -9.267508302887728e-20,  6.035953365099862e-21, -3.395159589990394e-22,  1.682754917739284e-23, -7.462478543770766e-25,  2.997025165968671e-26, -1.099556092112971e-27,
  4.253540638214909e-16, -1.573170773787645e-16,  3.073685063788416e-17, -4.080318929255391e-18,  4.108212614146327e-19, -3.336927030311489e-20,  2.274688215304792e-21,
 -1.337442552452874e-22,  6.920477505672799e-24, -3.200204368306958e-25,  1.338635693159140e-26, -5.109134352008912e-28,  1.298572751343804e-16, -5.006690517115296e-17,
  1.022851315451935e-17, -1.419472954331701e-18,  1.492717815045739e-19, -1.265009201627093e-20,  8.986702329793904e-22, -5.500414235591193e-23,  2.959499609558689e-24,
 -1.421529154980005e-25,  6.170001010036898e-27, -2.440866453859754e-28,  4.317335074330164e-17, -1.725988453248896e-17,  3.667440012000602e-18, -5.293115073789200e-19,
  5.784714801847428e-20, -5.090033123410926e-21,  3.750834155095382e-22, -2.379021445796132e-23,  1.325188526815467e-24, -6.583588470809026e-26,  2.952858174407596e-27,
 -1.205962364703524e-28,  1.572807681266039e-17, -6.483990890591852e-18,  1.424874051421303e-18, -2.126929554384978e-19,  2.402731318893789e-20, -2.183722957243882e-21,
  1.660751189087359e-22, -1.086213980838951e-23,  6.234171789795175e-25, -3.188590958380744e-26,  1.471206855093662e-27, -6.175884524598600e-29,  6.272477742965646e-18,
 -2.651515573749214e-18,  5.990332987273116e-19, -9.193878530241973e-20,  1.067418019781948e-20, -9.964362698636507e-22,  7.778453024565311e-23, -5.218528012684978e-24,
  3.070180182891493e-25, -1.608606385322230e-26,  7.598198656809572e-28, -3.263044211621534e-29,  2.694124496506662e-18, -1.161051467101500e-18,  2.679952188973621e-19,
 -4.202931167311343e-20,  4.984598509270507e-21, -4.751060924155107e-22,  3.784960508672573e-23, -2.590110202439930e-24,  1.553500036098911e-25, -8.293781738161833e-27,
  3.989805701537503e-28, -1.744090922541124e-29,  1.175982632189338e-18, -5.136443067847262e-19,  1.203526955359068e-19, -1.916245495702899e-20,  2.306799621129343e-21,
 -2.231086821791932e-22,  1.802944690375437e-23, -1.251060018870036e-24,  7.605945717461395e-26, -4.114543595031648e-27,  2.004915049961570e-28, -8.874105645414393e-30,
  4.086607779300839e-19, -1.798346508132222e-19,  4.249262723041719e-20, -6.823217444067528e-21,  8.282858620933615e-22, -8.076903692418470e-23,  6.579380900043008e-24,
 -4.601165477671934e-25,  2.818658487605257e-26, -1.536115249716546e-27,  7.539211826254960e-29, -3.360395438555677e-30,  6.103067998184004e-02, -1.539922976387549e-04,
  4.024288097026226e-07, -1.083169356179463e-09,  2.981994690046652e-12, -8.344338761517477e-15,  2.359296378586026e-17, -6.714851380042725e-20,  1.916342118593341e-22,
 -5.477768376293441e-25,  1.563723088841084e-27, -4.463237232792379e-30,  5.666663204073408e-02, -1.757190780559285e-04,  6.502360108536844e-07, -2.523089118865179e-09,
  9.741884343580367e-12, -3.693184310305964e-14,  1.373247750173537e-16, -5.018606785578661e-19,  1.806600416962033e-21, -6.418912631651619e-24,  2.254297837494711e-26,
 -7.835792554118032e-29,  4.885555635948330e-02, -2.080447766108378e-04,  1.086570021669482e-06, -5.496512961897798e-09,  2.643517827564610e-11, -1.220646821001694e-13,
  5.457574076023071e-16, -2.376252570664857e-18,  1.011543619091365e-20, -4.222273627425377e-23,  1.732053938308827e-25, -6.995450417210478e-28,  3.911694157037674e-02,
 -2.346801903415884e-04,  1.600490272694118e-06, -9.918523397308035e-09,  5.719497720301710e-11, -3.128620519271418e-13,  1.641393521048508e-15, -8.318402750469360e-18,
  4.093205053749788e-20, -1.963225895203549e-22,  9.206203742486495e-25, -4.230991976561784e-27,  2.909157934672315e-02, -2.423353999647051e-04,  2.053242439575821e-06,
 -1.522020374239775e-08,  1.034626677498431e-10, -6.596984830672985e-13,  3.997326901390260e-15, -2.322128918293125e-17,  1.301578404644799e-19, -7.073136692889354e-22,
  3.740559139341493e-24, -1.930755686437247e-26,  2.010205223683297e-02, -2.263111510549470e-04,  2.320031598834086e-06, -2.030452108550711e-08,  1.607190731547677e-10,
 -1.180213162322325e-12,  8.165341877394702e-15, -5.378609153979414e-17,  3.398816082458270e-19, -2.072072807518249e-21,  1.224066356087874e-23, -7.031149415773705e-26,
  1.291035519481788e-02, -1.909863920119907e-04,  2.333839638434411e-06, -2.387846637878806e-08,  2.179309725436841e-10, -1.826083426620926e-12,  1.430087718116084e-14,
 -1.059457140019083e-16,  7.489086853543667e-19, -5.083898673311159e-21,  3.330801373651174e-23, -2.114379039476612e-25,  7.709974709063416e-03, -1.460822593924307e-04,
  2.106904247894609e-06, -2.499108050248979e-08,  2.608936142139002e-10, -2.476183370276896e-12,  2.180108367472054e-14, -1.804739291364339e-16,  1.418315626214477e-18,
 -1.065785071738865e-20,  7.700310865802741e-23, -5.372468934372552e-25,  4.283704835501030e-03, -1.016661802613726e-04,  1.717224718549707e-06, -2.344314183540889e-08,
  2.780909152881280e-10, -2.971716956173045e-12,  2.924968308405807e-14, -2.691399518825201e-16,  2.339739816910855e-18, -1.936891359276675e-20,  1.536112729197118e-22,
 -1.172686059207949e-24,  2.215749287694730e-03, -6.462578281201242e-05,  1.269690156399422e-06, -1.982305501208792e-08,  2.657053328766892e-10, -3.180660950147124e-12,
  3.483413686729417e-14, -3.546998199288927e-16,  3.396705515002609e-18, -3.085276863965080e-20,  2.675575756003279e-22, -2.226657937734922e-24,  1.067807448025125e-03,
 -3.765497770260401e-05,  8.550934472332858e-07, -1.518192889140504e-08,  2.288269588584255e-10, -3.055076572758107e-12,  3.707931707108317e-14, -4.162415763806799e-16,
  4.375185573807066e-18, -4.345596721564648e-20,  4.107295382900368e-22, -3.714485044723332e-24,  4.798823305602176e-04, -2.017574821421373e-05,  5.264209801977005e-07,
 -1.057550367476618e-08,  1.784722948584912e-10, -2.647399034047383e-12,  3.548329997420081e-14, -4.376942937644345e-16,  5.034209146104781e-18, -5.451559745272963e-20,
  5.599951268542153e-22, -5.488476344081857e-24,  2.013327690951109e-04, -9.970732670918125e-06,  2.972308603794744e-07, -6.725681372426985e-09,  1.265979733757681e-10,
 -2.079354461512175e-12,  3.068157511947924e-14, -4.146705406295378e-16,  5.204662628547419e-18, -6.129115196407919e-20,  6.825684546771480e-22, -7.232810491374831e-24,
  7.895520421370788e-05, -4.557725907979558e-06,  1.544059559708581e-07, -3.918929116434012e-09,  8.199033376605181e-11, -1.486562383088877e-12,  2.408057410022568e-14,
 -3.556740314944663e-16,  4.859835478667058e-18, -6.209389256978048e-20,  7.480557672509568e-22, -8.552180914160424e-24,  2.898506925978480e-05, -1.932406258971857e-06,
  7.402572333171462e-08, -2.099278609821323e-09,  4.866063669331854e-11, -9.711805840487059e-13,  1.722745745805115e-14, -2.774319595613407e-16,  4.117774682633930e-18,
 -5.696670512534826e-20,  7.409593675021735e-22, -9.122317362620827e-24,  9.977952504789441e-06, -7.620622926577566e-07,  3.285433739567405e-08, -1.037292915656621e-09,
  2.656014197342018e-11, -5.820126851161654e-13,  1.127937780923681e-14, -1.976280419010767e-16,  3.180045196169925e-18, -4.754611220372480e-20,  6.665132285963085e-22,
 -8.821691968575095e-24,  3.227373895788407e-06, -2.803351268488100e-07,  1.354164389725770e-08, -4.743895803898259e-10,  1.338065686214203e-11, -3.211549162385269e-13,
  6.785254177044951e-15, -1.290941235206435e-16,  2.247917112544409e-18, -3.626133831671708e-20,  5.469596090450029e-22, -7.770668802194655e-24,  9.831139898111331e-07,
 -9.649058072914797e-08,  5.200667908761087e-09, -2.015087214262547e-10,  6.244675529594016e-12, -1.637945284476185e-13,  3.765092100197876e-15, -7.764218722822323e-17,
  1.460580159482320e-18, -2.537944530052467e-20,  4.113010707403263e-22, -6.263265216465589e-24,  2.827938961154276e-07, -3.117748969935809e-08,  1.867620294985441e-09,
 -7.979575446964815e-11,  2.710101398438615e-12, -7.751642969651293e-14,  1.934933134442639e-15, -4.317358366255186e-17,  8.760038530302076e-19, -1.637223031867619e-20,
  2.846688618140419e-22, -4.640181751708739e-24,  7.705379861759135e-08, -9.490932802683110e-09,  6.295269533496165e-10, -2.957368794454055e-11,  1.098148077605667e-12,
 -3.418152994217609e-14,  9.248361605896484e-16, -2.229085955297892e-17,  4.870929430318846e-19, -9.777775023959666e-21,  1.821559071165793e-22, -3.174215206012043e-24,
  1.995855396667277e-08, -2.732857585838350e-09,  2.000062584656970e-10, -1.030207887832690e-11,  4.172754721011890e-13, -1.410606230128844e-14,  4.129601413692243e-16,
 -1.073447342170021e-17,  2.522431064714018e-19, -5.430926968197401e-21,  1.082637828403344e-22, -2.014355089682867e-24,  4.934726248034432e-09, -7.476415886926542e-10,
  6.016840299102910e-11, -3.388951523893244e-12,  1.493897928190002e-13, -5.473961621520529e-15,  1.730904660102427e-16, -4.844704214985361e-18,  1.222432571216481e-19,
 -2.819126550832391e-21,  6.005826844582101e-23, -1.191666338284086e-24,  1.170171252987440e-09, -1.952989468860929e-10,  1.722660892402653e-11, -1.058183881493000e-12,
  5.065243507518498e-14, -2.007840588628522e-15,  6.845591884866964e-17, -2.059856797007301e-18,  5.572856029270644e-20, -1.374703577362495e-21,  3.125770473480090e-23,
 -6.605943851874879e-25,  2.675713995722524e-10, -4.898548247727517e-11,  4.720651834102459e-12, -3.154187830848540e-13,  1.635820934159664e-14, -7.000938039343622e-16,
  2.569092621031824e-17, -8.297293493641796e-19,  2.403322198494703e-20, -6.332549589903936e-22,  1.534773692311514e-23, -3.450421065793657e-25,  5.936325281044440e-11,
 -1.187224517443605e-11,  1.246031300504503e-12, -9.032249614691430e-14,  5.063670750028302e-15, -2.335082285728044e-16,  9.206127531596839e-18, -3.185955411158577e-19,
  9.864555070634311e-21, -2.772355948608395e-22,  7.152144428325437e-24, -1.708221083608197e-25,  1.286867505230937e-11, -2.800111676661090e-12,  3.190506468630015e-13,
 -2.502349988288002e-14,  1.512949953936990e-15, -7.501883911033562e-17,  3.171547425794392e-18, -1.174030007070911e-19,  3.879450279097113e-21, -1.161126450803426e-22,
  3.183874389896119e-24, -8.067483213115815e-26,  2.747499186383433e-12, -6.478137389567339e-13,  7.987873886300714e-14, -6.760024917871031e-15,  4.397198818244450e-16,
 -2.339255000451835e-17,  1.058353200374733e-18, -4.182859908732142e-20,  1.472510093964811e-21, -4.685851280585553e-23,  1.363553782978496e-24, -3.659943815999575e-26,
  5.829147310056866e-13, -1.483262356145969e-13,  1.972729986498536e-14, -1.796267188946789e-15,  1.253825176130905e-16, -7.139685835796562e-18,  3.449423954188845e-19,
 -1.452608570596638e-20,  5.437552520319604e-22, -1.836425275911538e-23,  5.661338220983370e-25, -1.607031507265537e-26,  1.241245038067105e-13, -3.394416445829290e-14,
  4.852877072836555e-15, -4.740002047364276e-16,  3.540748782880431e-17, -2.152704208964266e-18,  1.108021281604144e-19, -4.960816043407928e-21,  1.970484720678799e-22,
 -7.048896735122323e-24,  2.297761244482465e-25, -6.885238954041635e-27,  2.682037590295426e-14, -7.848897884255186e-15,  1.201897969173666e-15, -1.255237096842760e-16,
  1.000488507506936e-17, -6.476770257969586e-19,  3.542438987620506e-20, -1.682115394784641e-21,  7.073563810713940e-23, -2.674278872909378e-24,  9.198330580175707e-26,
 -2.903650115037921e-27,  5.951479998057491e-15, -1.855574441536818e-15,  3.031845915614578e-16, -3.373966862046833e-17,  2.860248898956236e-18, -1.965631386038106e-19,
  1.139183102467613e-20, -5.721690022050208e-22,  2.540687791879515e-23, -1.012670246808932e-24,  3.666547754728504e-26, -1.216511345117414e-27,  1.373752014760735e-15,
 -4.542173262052610e-16,  7.886661579211248e-17, -9.316934273845301e-18,  8.371203632159098e-19, -6.086930143320060e-20,  3.726228890753013e-21, -1.973657897307279e-22,
  9.227662403193143e-24, -3.866811526632746e-25,  1.469833464090172e-26, -5.112416151823544e-28,  3.343111057848236e-16, -1.166567425811582e-16,  2.143085454446196e-17,
 -2.676648624292083e-18,  2.539117133086916e-19, -1.946312585347667e-20,  1.254129036184383e-21, -6.981641399651207e-23,  3.425842694155603e-24, -1.504598293384252e-25,
  5.986238973129993e-27, -2.176427325678895e-28,  8.695031686692948e-17, -3.185950214490547e-17,  6.163418103508253e-18, -8.102332398094462e-19,  8.080440272784527e-20,
 -6.503119256783338e-21,  4.393577629538617e-22, -2.561055220205345e-23,  1.314162294634185e-24, -6.028048791610118e-26,  2.501840529269358e-27, -9.476699104213701e-29,
  2.448923585931585e-17, -9.372558678362538e-18,  1.899717409786713e-18, -2.615795880589132e-19,  2.729846883649076e-20, -2.296337248922408e-21,  1.619661103324633e-22,
 -9.844648806979023e-24,  5.261391512131610e-25, -2.510780160726881e-26,  1.082924650406720e-27, -4.258034379307010e-29,  7.555714559153564e-18, -3.003883914301395e-18,
  6.344444080780680e-19, -9.102107488186484e-20,  9.889444134491823e-21, -8.652499545691378e-22,  6.340956512093694e-23, -4.000422109719045e-24,  2.216861766139135e-25,
 -1.095841562306467e-26,  4.891251494837796e-28, -1.988264287843950e-29,  2.574372722144190e-18, -1.057115197597881e-18,  2.313024306481268e-19, -3.437836011283864e-20,
  3.867274334496778e-21, -3.500375389238296e-22,  2.651498973539651e-23, -1.727526812127337e-24,  9.877851064038165e-26, -5.033930033399634e-27,  2.314490941614613e-28,
 -9.682893418508526e-30,  9.695702464631800e-19, -4.087996730910103e-19,  9.209325224900770e-20, -1.409403330015618e-20,  1.631753972202787e-21, -1.519094105103364e-22,
  1.182706768039469e-23, -7.914338899915618e-25,  4.644584868372596e-26, -2.427627610560558e-27,  1.143994707691613e-28, -4.901747196579811e-30,  3.978167258203159e-19,
 -1.711837509426950e-19,  3.944671592515155e-20, -6.175982866044171e-21,  7.312511798198550e-22, -6.958680802167652e-23,  5.534985356870163e-24, -3.781912044301621e-25,
  2.264965561894394e-26, -1.207476790305762e-27,  5.800587541552579e-29, -2.532227416105080e-30,  1.680496676167270e-19, -7.334638404150139e-20,  1.717169369833778e-20,
 -2.731786210560217e-21,  3.285857508047046e-22, -3.175456423789275e-23,  2.564078606025119e-24, -1.777849501436761e-25,  1.080056942805525e-26, -5.838485554207501e-28,
  2.842941737938532e-29, -1.257473929182544e-30,  5.732151322086015e-20, -2.521716384975600e-20,  5.956447613738165e-21, -9.561178771133374e-22,  1.160250936525038e-22,
 -1.131014352605248e-23,  9.210056287080572e-25, -6.438753952458407e-26,  3.943082742029190e-27, -2.148223257122944e-28,  1.054014140392188e-29, -4.696548350975725e-31,
  6.042106845998107e-02, -1.508240606743140e-04,  3.897116395946534e-07, -1.036762397131868e-09,  2.820621438775552e-12, -7.799994380949350e-15,  2.179577685219625e-17,
 -6.132004019894227e-20,  1.729943825737035e-22, -4.889827607986860e-25,  1.380104870164232e-27, -3.896788271072789e-30,  5.597397141822034e-02, -1.706357034505010e-04,
  6.208703545903688e-07, -2.372953655615889e-09,  9.035100085319168e-12, -3.379834848306824e-14,  1.240484966469573e-16, -4.475792496044069e-19,  1.590953081889985e-21,
 -5.582501695986604e-24,  1.936398035800715e-26, -6.648730649000967e-29,  4.804035455058289e-02, -1.996090397155216e-04,  1.023071325565022e-06, -5.092390772347696e-09,
  2.411966031734281e-11, -1.097297059036543e-13,  4.835347373330260e-16, -2.075599694152698e-18,  8.713051465629410e-21, -3.587271323916303e-23,  1.451763767690146e-25,
 -5.785518344021110e-28,  3.820309619854111e-02, -2.223372622763690e-04,  1.486758943884249e-06, -9.051397922743609e-09,  5.131354259534031e-11, -2.761218655548025e-13,
  1.425801943364387e-15, -7.114900370923415e-18,  3.448476323200367e-20, -1.629662952131007e-22,  7.531534951695168e-25, -3.412076069333809e-27,  2.815397133940278e-02,
 -2.266128583226036e-04,  1.880113310194892e-06, -1.366535319203187e-08,  9.117772684086645e-11, -5.711168751804947e-13,  3.401810181084734e-15, -1.943635662903068e-17,
  1.071949238289596e-19, -5.733894539171869e-22,  2.985692281546296e-24, -1.517845063924662e-26,  1.923244442971327e-02, -2.086835268910212e-04,  2.091060578830540e-06,
 -1.791169319812898e-08,  1.389585761641462e-10, -1.001153762954396e-12,  6.801024462489622e-15, -4.401463015695873e-17,  2.734025285706224e-19, -1.639134379156287e-21,
  9.526005494596149e-24, -5.384816524272169e-26,  1.218201647030282e-02, -1.734052233727407e-04,  2.067071963971098e-06, -2.066605778362110e-08,  1.846145397247518e-10,
 -1.515912428950511e-12,  1.164412727066186e-14, -8.466897505672494e-17,  5.877856521834892e-19, -3.920578939550220e-21,  2.524935749847886e-23, -1.576143944095864e-25,
  7.157552260907177e-03, -1.303592214805998e-04,  1.830510393710039e-06, -2.118617358335605e-08,  2.162179669552369e-10, -2.008802332966257e-12,  1.732952356208982e-14,
 -1.406756264296471e-16,  1.084814703606029e-18, -8.003319722509019e-21,  5.679812251354738e-23, -3.894106046649791e-25,  3.902835160109627e-03, -8.898229392844282e-05,
  1.460759310213121e-06, -1.943343816911944e-08,  2.251072284479334e-10, -2.352299346961360e-12,  2.266504752902490e-14, -2.043329509915640e-16,  1.741657184463823e-18,
 -1.414486104500046e-20,  1.101141383695995e-22, -8.255246108159436e-25,  1.976150655897638e-03, -5.535205175128818e-05,  1.055360389588487e-06, -1.603841994390916e-08,
  2.097072245437796e-10, -2.452495237112193e-12,  2.627097711691279e-14, -2.618884249695577e-16,  2.457155865910110e-18, -2.188133803240139e-20,  1.861442541855339e-22,
 -1.520399839817212e-24,  9.297973259807986e-04, -3.148506993743618e-05,  6.930077807294495e-07, -1.196485381837863e-08,  1.757564457572172e-10, -2.290549056545748e-12,
  2.717033310647846e-14, -2.983897634830245e-16,  3.070916598269567e-18, -2.988542736178770e-20,  2.769300539422644e-22, -2.456701918731476e-24,  4.068619180285875e-04,
 -1.642720295016118e-05,  4.150402298099793e-07, -8.101121717271589e-09,  1.331345270486297e-10, -1.926331200864922e-12,  2.521643316857225e-14, -3.041094985778023e-16,
  3.422688364138674e-18, -3.629586096541354e-20,  3.653444680231743e-22, -3.510771667050152e-24,  1.657391320621887e-04, -7.884202838661424e-06,  2.274232895969273e-07,
 -4.996435182700328e-09,  9.152324210167338e-11, -1.465370638562879e-12,  2.110502693158177e-14, -2.787211742164317e-16,  3.421465430131712e-18, -3.943745180047471e-20,
  4.301746347880554e-22, -4.467424307333031e-24,  6.292570039991196e-05, -3.490356663800803e-06,  1.143619191887483e-07, -2.816627104427995e-09,  5.731450806267595e-11,
 -1.012437806459024e-12,  1.600012305455385e-14, -2.308144195104414e-16,  3.083149141013539e-18, -3.854213653850991e-20,  4.546143996979959e-22, -5.091952093719740e-24,
  2.229721912770527e-05, -1.429072498990329e-06,  5.293096986477832e-08, -1.456028381612716e-09,  3.281199760724023e-11, -6.377571954673618e-13,  1.103246469041349e-14,
 -1.734588938263308e-16,  2.515994803901248e-18, -3.404376813773080e-20,  4.334100303673930e-22, -5.226174753179666e-24,  7.385681120071997e-06, -5.425909609071007e-07,
  2.261542825544489e-08, -6.924374897807025e-10,  1.723204989656783e-11, -3.676264129533656e-13,  6.945841255784085e-15, -1.187824120188146e-16,  1.867352689137153e-18,
 -2.730032418513593e-20,  3.744968452806661e-22, -4.853695417738444e-24,  2.291206282066904e-06, -1.915693646915247e-07,  8.947173754423427e-09, -3.039327076692633e-10,
  8.330625475759334e-12, -1.946262695105768e-13,  4.008064645085314e-15, -7.441438710185110e-17,  1.265733509305106e-18, -1.996149019320243e-20,  2.945943408783987e-22,
 -4.097782385649449e-24,  6.671535273941554e-07, -6.307949235414046e-08,  3.288039042027349e-09, -1.235452857809265e-10,  3.720401644010691e-12, -9.498140021454557e-14,
  2.127950873518284e-15, -4.281821904687612e-17,  7.867409009712754e-19, -1.336417864051750e-20,  2.118899931875240e-22, -3.158988401082455e-24,  1.828051318950364e-07,
 -1.943283936162898e-08,  1.126253646910010e-09, -4.667390600179254e-11,  1.540556041208412e-12, -4.289164385151766e-14,  1.043536683994999e-15, -2.272034801920271e-17,
  4.502840135478704e-19, -8.227168887511513e-21,  1.399531765432818e-22, -2.233505796781099e-24,  4.727681054079779e-08, -5.620616585407043e-09,  3.608998776199758e-10,
 -1.645061821235694e-11,  5.938085466218029e-13, -1.799486738350303e-14,  4.746284629750626e-16, -1.116428035642170e-17,  2.383164856898259e-19, -4.677314252930016e-21,
  8.526120430267609e-23, -1.454810008897723e-24,  1.158009034926846e-08, -1.532198924257225e-09,  1.086298624347310e-10, -5.431974436888204e-12,  2.139626258837185e-13,
 -7.044264965394680e-15,  2.010915750852894e-16, -5.102618141034686e-18,  1.171584478763330e-19, -2.466840861474414e-21,  4.812798298843262e-23, -8.770144603896005e-25,
  2.697291991390005e-09, -3.953844190377130e-10,  3.085152123924230e-11, -1.688063911526129e-12,  7.240412068238551e-14, -2.585010507445507e-15,  7.973897251760027e-17,
 -2.179500847933577e-18,  5.375410540440639e-20, -1.212722967762505e-21,  2.529352182876638e-23, -4.916845215565361e-25,  6.002333225053463e-10, -9.705783412775151e-11,
  8.309039617612523e-12, -4.962281194376823e-13,  2.312811000252539e-14, -8.938246284814520e-16,  2.974479758967070e-17, -8.744827209583618e-19,  2.313649418503991e-20,
 -5.585830096892824e-22,  1.243988428604980e-23, -2.576769253114278e-25,  1.282995849635206e-10, -2.279111608467167e-11,  2.134137341908831e-12, -1.387703278810521e-13,
  7.013424484155305e-15, -2.928612749890392e-16,  1.049694776983601e-17, -3.314469021731234e-19,  9.394189436071487e-21, -2.424023615425833e-22,  5.757388105380084e-24,
 -1.269316187117548e-25,  2.650533232042129e-11, -5.151904083716007e-12,  5.260790872576785e-13, -3.715282879237500e-14,  2.031785895277734e-15, -9.149937707344185e-17,
  3.526412688262881e-18, -1.194070301166802e-19,  3.620422730162636e-21, -9.971235447486613e-23,  2.522636152040451e-24, -5.912419350769582e-26,  5.330014336565006e-12,
 -1.129144057009756e-12,  1.253568879871724e-13, -9.590937446097502e-15,  5.663057181957439e-16, -2.745091853084673e-17,  1.135595019005500e-18, -4.116861330222325e-20,
  1.333304626926134e-21, -3.914000495858785e-23,  1.053333043453346e-24, -2.621135698501878e-26,  1.051793423866299e-12, -2.418989790168666e-13,  2.910838234374673e-14,
 -2.406437120206067e-15,  1.530656000262231e-16, -7.970036439503856e-18,  3.532381972216479e-19, -1.368696480817160e-20,  4.727202901127389e-22, -1.476855520961803e-23,
  4.221781165484581e-25, -1.113863041189939e-26,  2.055572209144833e-13, -5.112061195512270e-14,  6.646540883656095e-15, -5.921279713638356e-16,  4.047457093939470e-17,
 -2.258863019872749e-18,  1.070440143329540e-19, -4.424701121080342e-21,  1.626858995832576e-22, -5.400100270375977e-24,  1.637127200457793e-25, -4.572642840235469e-27,
  4.020056131164747e-14, -1.076692312721242e-14,  1.507569380136018e-15, -1.443142858760145e-16,  1.057334383832125e-17, -6.309747722900062e-19,  3.190005108909856e-20,
 -1.403774561724411e-21,  5.483838485684134e-23, -1.930407648859208e-24,  6.195584195327862e-26, -1.828831119576086e-27,  7.958755050738797e-15, -2.286001771464966e-15,
  3.435082809659197e-16, -3.522393988424155e-17,  2.758367602070457e-18, -1.755536759972087e-19,  9.445737517917232e-21, -4.414958434187179e-22,  1.828463955828402e-23,
 -6.811733118512174e-25,  2.309802970892964e-26, -7.191742313286124e-28,  1.615476876739991e-15, -4.954513305536276e-16,  7.960161346875216e-17, -8.714325582288444e-18,
  7.271340441976780e-19, -4.921238988369491e-20,  2.810371699272802e-21, -1.391608655768263e-22,  6.095078649965277e-24, -2.397354211895188e-25,  8.569343395287786e-27,
 -2.808154078880218e-28,  3.408762953023530e-16, -1.111138937036765e-16,  1.901118714961977e-17, -2.213799107577550e-18,  1.961547487196454e-19, -1.407216588546419e-20,
  8.503269121227932e-22, -4.447705941428273e-23,  2.054416556907295e-24, -8.508597500765044e-26,  3.197775006717034e-27, -1.100139025926250e-28,  7.587562213298469e-17,
 -2.616018656053657e-17,  4.745863323204692e-18, -5.854750601303917e-19,  5.487800621500021e-20, -4.158115018641650e-21,  2.649496692371204e-22, -1.459081719239418e-23,
  7.085121891058466e-25, -3.080406904786820e-26,  1.213645785099956e-27, -4.370957147917177e-29,  1.808750723257688e-17, -6.562430349112842e-18,  1.256381291648899e-18,
 -1.634733173801364e-19,  1.614101094558229e-20, -1.286507330989616e-21,  8.610749410004093e-23, -4.974023611451187e-24,  2.530076032387344e-25, -1.150750386380481e-26,
  4.736991112409298e-28, -1.780161812849750e-29,  4.686837919861441e-18, -1.779813269419639e-18,  3.577528950993824e-19, -4.885542693933301e-20,  5.057699160093595e-21,
 -4.221445043123954e-22,  2.955071408301713e-23, -1.783070341779616e-24,  9.462289126607648e-26, -4.484673131790209e-27,  1.921507540790872e-28, -7.507104277713563e-30,
  1.337998408638607e-18, -5.288119006111875e-19,  1.109796213624769e-19, -1.582128056453537e-20,  1.708386756635104e-21, -1.485757715710289e-22,  1.082514671483187e-23,
 -6.791058404080192e-25,  3.742837560755483e-26, -1.840417721082504e-27,  8.172740455262167e-29, -3.305796743022428e-30,  4.251098074731548e-19, -1.738311951613500e-19,
  3.786120131875518e-20, -5.601633996776116e-21,  6.273256281174957e-22, -5.653466478196683e-23,  4.264424318821166e-24, -2.767063895464461e-25,  1.575933619962766e-26,
 -8.000510353179767e-28,  3.664825321031888e-29, -1.527722874945097e-30,  1.507796167633028e-19, -6.339831480490407e-20,  1.423893439181272e-20, -2.172539403272109e-21,
  2.507817803074199e-22, -2.327924843314678e-23,  1.807343649281634e-24, -1.206130827542680e-25,  7.059582394454228e-27, -3.680457523350319e-28,  1.730077690090406e-29,
 -7.395205326971139e-31,  5.895608752046398e-20, -2.532864384008910e-20,  5.826225045955942e-21, -9.105569681699375e-22,  1.076232485445924e-22, -1.022406795913156e-23,
  8.118784530942285e-25, -5.538401964266666e-26,  3.311721033019015e-27, -1.762828922340393e-28,  8.455945375181881e-30, -3.686144924201881e-31,  2.405838204036487e-20,
 -1.049222843535987e-20,  2.454268417242176e-21, -3.900971515186773e-22,  4.688106891658035e-23, -4.526742911621093e-24,  3.652170098344345e-25, -2.530253293366793e-26,
  1.535940287631828e-27, -8.296515671336122e-29,  4.036828416287095e-30, -1.784258342564262e-31,  8.046388472425229e-21, -3.538683831490206e-21,  8.355588297710981e-22,
 -1.340734887374432e-22,  1.626395840392918e-23, -1.584847742035937e-24,  1.290118214603973e-25, -9.016120520794390e-27,  5.519596619196718e-28, -3.006127110570135e-29,
  1.474462423189360e-30, -6.567931868410931e-32,  5.982392987729171e-02, -1.477553766177787e-04,  3.775362129878516e-07, -9.928526042364880e-10,  2.669716629007109e-12,
 -7.296889615055115e-15,  2.015374489836404e-17, -5.605554595750682e-20,  1.563447251562827e-22, -4.370585293192891e-25,  1.219669063253843e-27, -3.407500923960782e-30,
  5.530118558865903e-02, -1.657802351853174e-04,  5.932404860036581e-07, -2.233642190548631e-09,  8.387918607860822e-12, -3.096599879502489e-14,  1.121998457059898e-16,
 -3.997403186390285e-19,  1.403248133108425e-21, -4.863392910207948e-24,  1.666396643938602e-26, -5.652689904829664e-29,  4.725790955832572e-02, -1.916625061089654e-04,
  9.642076918736076e-07, -4.723421638688042e-09,  2.203656498404047e-11, -9.879192170925259e-14,  4.291349611089665e-16, -1.816371903701689e-18,  7.520306626300568e-21,
 -3.054423324258750e-23,  1.219672933295479e-25, -4.796740267035628e-28,  3.733686655216450e-02, -2.108641084952445e-04,  1.382891871236925e-06, -8.272767051822395e-09,
  4.611778333851080e-11, -2.441737486106475e-13,  1.241191747018942e-15, -6.099723497843704e-18,  2.912593097631213e-20, -1.356400636763590e-22,  6.179037253504390e-25,
 -2.759938300604641e-27,  2.727659705517855e-02, -2.122039286212170e-04,  1.724519076467669e-06, -1.229363059899490e-08,  8.052966734559451e-11, -4.956347101754673e-13,
  2.902669406120610e-15, -1.631458702087719e-17,  8.855088048737610e-20, -4.663168949160907e-22,  2.391243340150151e-24, -1.197489769084200e-26,  1.842985742663578e-02,
 -1.927784729470290e-04,  1.888827146243518e-06, -1.584007395181769e-08,  1.204728087865458e-10, -8.517814732449003e-13,  5.682726807991310e-15, -3.614074494460253e-17,
  2.207175112563321e-19, -1.301566727846066e-21,  7.442844204190271e-24, -4.141092367358433e-26,  1.151996608150365e-02, -1.578126126697157e-04,  1.835848835102516e-06,
 -1.794035660866729e-08,  1.569093079207217e-10, -1.262900483820001e-12,  9.516820722295505e-15, -6.793595990783689e-17,  4.632687098789624e-19, -3.036777165878149e-21,
  1.922841620208523e-23, -1.180537183123472e-25,  6.663872571312782e-03, -1.166761763133850e-04,  1.595777129399449e-06, -1.802676870670090e-08,  1.799011514635144e-10,
 -1.636489424901933e-12,  1.383623132905740e-14, -1.101644337189066e-16,  8.337718477812352e-19, -6.040410363712483e-21,  4.211517565213434e-23, -2.837922236722653e-25,
  3.568883149856419e-03, -7.817118800691182e-05,  1.247706510781574e-06, -1.618037287260218e-08,  1.830680825193809e-10, -1.871138037979307e-12,  1.765310805423259e-14,
 -1.559635728979916e-16,  1.303686025275522e-18, -1.038948088726424e-20,  7.940495839945809e-23, -5.847123368619775e-25,  1.770485173992031e-03, -4.762548941142707e-05,
  8.815171187656113e-07, -1.304358840158647e-08,  1.664113992006950e-10, -1.901780767783781e-12,  1.993001964638429e-14, -1.945474388573334e-16,  1.788752605904756e-18,
 -1.562000265610926e-20,  1.303738562884579e-22, -1.045317421007793e-24,  8.140990157298493e-04, -2.647077970287990e-05,  5.648978516820656e-07, -9.486461330124940e-09,
  1.358430297776975e-10, -1.728538188409040e-12,  2.004354977795678e-14, -2.153914877878076e-16,  2.170856116814142e-18, -2.070343113396979e-20,  1.881199003937322e-22,
 -1.637310753351493e-24,  3.472255805461716e-04, -1.346225027248949e-05,  3.294354130918328e-07, -6.248987031926806e-09,  1.000293110015984e-10, -1.412054669348639e-12,
  1.805678249953183e-14, -2.129462643380612e-16,  2.345656088713083e-18, -2.436298810137873e-20,  2.403426061513334e-22, -2.264815773133806e-24,  1.374937827714469e-04,
 -6.281811974842732e-06,  1.753675529447919e-07, -3.741448200614122e-09,  6.670767332306883e-11, -1.041330275123697e-12,  1.464183639680058e-14, -1.889792590424980e-16,
  2.269247197398912e-18, -2.560586312640997e-20,  2.736082740166404e-22, -2.785200565631648e-24,  5.060013899618611e-05, -2.696483365614272e-06,  8.545840767861032e-08,
 -2.042732907638505e-09,  4.043489613841886e-11, -6.960064786839733e-13,  1.073267295785196e-14, -1.512404323333355e-16,  1.975264332628404e-18, -2.416246628044524e-20,
  2.790802901855318e-22, -3.062837892923398e-24,  1.732859671260643e-05, -1.067472743542454e-06,  3.823011501286734e-08, -1.020192295949679e-09,  2.235385620868385e-11,
 -4.231854700163493e-13,  7.140015501892475e-15, -1.096140104568747e-16,  1.553956261952343e-18, -2.056773807422924e-20,  2.563210598915239e-22, -3.027537787943109e-24,
  5.530487087152995e-06, -3.907225220333762e-07,  1.574434016548224e-08, -4.675075578947486e-10,  1.130851415385127e-11, -2.348990027123823e-13,  4.327178279596253e-15,
 -7.223308637041061e-17,  1.109530963277129e-18, -1.586276854342231e-20,  2.129525527292522e-22, -2.702860431950838e-24,  1.647832498461228e-06, -1.325799000690294e-07,
  5.986443523428464e-09, -1.971902375952950e-10,  5.252370375627408e-12, -1.194497070824066e-13,  2.397854725841166e-15, -4.344615026771293e-17,  7.218933436051270e-19,
 -1.113103106055329e-20,  1.607350708336803e-22, -2.189168329528824e-24,  4.593135004983627e-07, -4.182158226319798e-08,  2.107952974021206e-09, -7.680265084574268e-11,
  2.247379473002544e-12, -5.584480598812545e-14,  1.219428683231924e-15, -2.394280550115135e-17,  4.296967054683881e-19, -7.135680871795184e-21,  1.106886711450597e-22,
 -1.615645411601287e-24,  1.200621904681776e-07, -1.230144687946793e-08,  6.896321361800726e-10, -2.771706460268432e-11,  8.890225569170399e-13, -2.409189708380420e-14,
  5.712838859438837e-16, -1.213673586828974e-17,  2.349348281818195e-19, -4.196288673486332e-21,  6.983785666310483e-23, -1.091183498662143e-24,  2.951494546389709e-08,
 -3.385333438307335e-09,  2.103692899638361e-10, -9.302508612312104e-12,  3.263715522027572e-13, -9.628054693919134e-15,  2.475349803015189e-16, -5.681923408034455e-18,
  1.184753330840900e-19, -2.273308019524458e-21,  4.054528764694736e-23, -6.773817660281068e-25,  6.846472315968966e-09, -8.749141021157487e-10,  6.007034015056347e-11,
 -2.915320320580398e-12,  1.116507884106772e-13, -3.579334082570796e-15,  9.962176751674597e-17, -2.467318003173577e-18,  5.534748944228482e-20, -1.139547397740530e-21,
  2.175670416267290e-23, -3.882552017209410e-25,  1.504449013843242e-09, -2.132494783372423e-10,  1.612698216853366e-11, -8.569274058091120e-13,  3.575394501669613e-14,
 -1.243494646785233e-15,  3.741134189313731e-17, -9.983997977783494e-19,  2.406494356619168e-20, -5.310418821633001e-22,  1.084184926111758e-23, -2.064506128977357e-25,
  3.145967088254808e-10, -4.925618930327003e-11,  4.090736147348966e-12, -2.374311246823693e-13,  1.077150770499236e-14, -4.057414835650459e-16,  1.317574029476513e-17,
 -3.783806497493596e-19,  9.787857424911436e-21, -2.312328070980413e-22,  5.042850383534783e-24, -1.023617577513769e-25,  6.293654027110069e-11, -1.084106030528802e-11,
  9.858849347198836e-13, -6.235911000041129e-14,  3.070108202814877e-15, -1.250401539195389e-16,  4.376170277371465e-18, -1.350566335563503e-19,  3.744690888303786e-21,
 -9.460108683001105e-23,  2.201430502782980e-24, -4.758473290192389e-26,  1.211994724363598e-11, -2.287980859369321e-12,  2.271829547605517e-13, -1.562345861879142e-14,
  8.330872902702810e-16, -3.662376681797282e-17,  1.379307695530318e-18, -4.568211623730209e-20,  1.355909268606652e-21, -3.658555187402482e-23,  9.074258178512328e-25,
 -2.086447167857820e-26,  2.262793770610193e-12, -4.663672085376797e-13,  5.041669695851248e-14, -3.760769251601668e-15,  2.167546822027371e-16, -1.026694740164972e-17,
  4.154272597408198e-19, -1.474367563455570e-20,  4.678258713619234e-22, -1.346509542890345e-23,  3.555342259563618e-25, -8.685836636013646e-27,  4.129552465659947e-13,
 -9.256969019846147e-14,  1.086356212287525e-14, -8.768280687549305e-16,  5.450820921301630e-17, -2.776598335025873e-18,  1.204971240753327e-19, -4.575381279692731e-21,
  1.549748763053240e-22, -4.751518051838306e-24,  1.333845736267869e-25, -3.457991587058800e-27,  7.436372542333028e-14, -1.806090326869400e-14,  2.293998862151101e-15,
 -1.998303453945092e-16,  1.336848224638520e-17, -7.308466848366580e-19,  3.395389152684736e-20, -1.376984169096222e-21,  4.970672598325950e-23, -1.620942996797977e-24,
  4.830698865313254e-26, -1.327114993910114e-27,  1.335573553584802e-14, -3.500604144839904e-15,  4.797082998833250e-16, -4.497632650333023e-17,  3.230097655468291e-18,
 -1.890970843162559e-19,  9.385414718486733e-21, -4.057388161312548e-22,  1.558110573300137e-23, -5.394928904962280e-25,  1.704055960438763e-26, -4.953082430644494e-28,
  2.421385766041424e-15, -6.821069687329460e-16,  1.005103525907400e-16, -1.011281424943528e-17,  7.775900084953777e-19, -4.862643073940677e-20,  2.572449483968950e-21,
 -1.182915298084392e-22,  4.822589666302858e-24, -1.769512572062052e-25,  5.912811647812806e-27, -1.815069307311158e-28,  4.491501262923539e-16, -1.354006953397881e-16,
  2.137645074165504e-17, -2.300627592100324e-18,  1.888347917306650e-19, -1.257928027823443e-20,  7.074701864960075e-22, -3.451922082491358e-23,  1.490547647065031e-24,
 -5.782716753502177e-26,  2.039759777577330e-27, -6.599039683886514e-29,  8.650974884442411e-17, -2.778147139962447e-17,  4.680824388047242e-18, -5.369464331669525e-19,
  4.689024182392491e-20, -3.317071002803114e-21,  1.977443323622658e-22, -1.020900612525827e-23,  4.656504081082617e-25, -1.905189695020029e-26,  7.076392811482009e-28,
 -2.406966612243291e-29,  1.757871941690798e-17, -5.984598319886586e-18,  1.071494055941526e-18, -1.304884970030465e-19,  1.207872643237751e-20, -9.041901180368881e-22,
  5.694384642912991e-23, -3.100678952348149e-24,  1.489307424787722e-25, -6.407125240571002e-27,  2.498709601442368e-28, -8.910881490614454e-30,  3.831583715293033e-18,
 -1.375769482353789e-18,  2.605194445335531e-19, -3.353323237135782e-20,  3.276432532842010e-21, -2.585059641453880e-22,  1.713300909499626e-23, -9.803424296417371e-25,
  4.941039578739539e-26, -2.227472747253857e-27,  9.090885744179942e-29, -3.388154249553831e-30,  9.109086798426158e-19, -3.430697426700327e-19,  6.835445421974155e-20,
 -9.253703088470879e-21,  9.498909450152624e-22, -7.863447035321294e-23,  5.460924923309354e-24, -3.269839898094912e-25,  1.722359619078134e-26, -8.104639003061595e-28,
  3.448431206771902e-29, -1.338234339783200e-30,  2.398940517943137e-19, -9.422054925622270e-20,  1.964064123461607e-20, -2.781279467478843e-21,  2.983666781134756e-22,
 -2.578439203360778e-23,  1.867127881768376e-24, -1.164380608682151e-25,  6.380567911229006e-27, -3.120013144911417e-28,  1.378056918166704e-29, -5.545174246993661e-31,
  7.085659621807349e-20, -2.884471205261004e-20,  6.251994638866253e-21, -9.205207979968814e-22,  1.026015106871734e-22, -9.203977075673049e-24,  6.911656616101515e-25,
 -4.465426884989701e-26,  2.532582053649464e-27, -1.280510282211699e-28,  5.842710900133051e-30, -2.426384169552541e-31,  2.359859810309276e-20, -9.893434851187219e-21,
  2.214856200581976e-21, -3.368493510147803e-22,  3.876080983006446e-23, -3.587001629611924e-24,  2.776569048069134e-25, -1.847595610812249e-26,  1.078388617170653e-27,
 -5.606861884456797e-29,  2.628707115729941e-30, -1.120789008346785e-31,  8.771052360893001e-21, -3.761780925120438e-21,  8.636673463142435e-22, -1.347231194881315e-22,
  1.589395917015677e-23, -1.507166273808294e-24,  1.194708693396899e-25, -8.136010601940141e-27,  4.856898384124520e-28, -2.581162701589459e-29,  1.236199044634314e-30,
 -5.380738730632497e-32,  3.450911598596447e-21, -1.503746677926214e-21,  3.514196544615244e-22, -5.580475020021841e-23,  6.700333750666815e-24, -6.463893611528334e-25,
  5.210490970852286e-26, -3.606791459388658e-27,  2.187614580592928e-28, -1.180705370283117e-29,  5.740438230328743e-31, -2.535314052851868e-32,  1.130388936855248e-21,
 -4.969634148160526e-22,  1.172996521451150e-22, -1.881469558255453e-23,  2.281478390031457e-24, -2.222367604848430e-25,  1.808418725824147e-26, -1.263378251692933e-27,
  7.731581526579985e-29, -4.209385987421594e-30,  2.063947218724766e-31, -9.190738421562196e-33,  5.923887450419060e-02, -1.447820285990945e-04,  3.658735422816392e-07,
 -9.512788836880090e-10,  2.528491462783213e-12, -6.831483267202906e-15,  1.865193215819196e-17, -5.129513007325698e-20,  1.414538295605555e-22, -3.911413416483351e-25,
  1.079271828287624e-27, -2.984261518181415e-30,  5.464738989896702e-02, -1.611392907448638e-04,  5.672220460936554e-07, -2.104247460296969e-09,  7.794645537662100e-12,
 -2.840259839397107e-14,  1.016103410417853e-16, -3.575137558854161e-19,  1.239588227737867e-21, -4.244007594158571e-24,  1.436626650488566e-26, -4.815190130044067e-29,
  4.650633614545460e-02, -1.841697214789537e-04,  9.095787063480959e-07, -4.386100529736293e-09,  2.015973575642329e-11, -8.907677352686480e-14,  3.814868212611590e-16,
 -1.592413744682845e-18,  6.503674129245988e-21, -2.606263855498771e-23,  1.027021073767322e-25, -3.986592712667187e-28,  3.651492489063539e-02, -2.001858832162873e-04,
  1.287889907707944e-06, -7.572388034850603e-09,  4.151888597438256e-11, -2.163336814938329e-13,  1.082746504446566e-15, -5.241279843631981e-18,  2.466000191639227e-20,
 -1.131908398646036e-22,  5.083485335635631e-25, -2.238988634824486e-27,  2.645446929019611e-02, -1.989766957304201e-04,  1.584411088383671e-06, -1.108082214065776e-08,
  7.127820365566947e-11, -4.311470218793967e-13,  2.483133936748731e-15, -1.373208002558393e-17,  7.336536644438307e-20, -3.804255492365316e-22,  1.921474292726427e-24,
 -9.480275130200188e-27,  1.768780553678627e-02, -1.783966589382603e-04,  1.709772569833334e-06, -1.404171400706355e-08,  1.047230147980463e-10, -7.267825315313221e-13,
  4.763013223548099e-15, -2.977341091576282e-17,  1.788081933580277e-19, -1.037328163071974e-21,  5.837722204566479e-24, -3.197504864812888e-26,  1.091678356519491e-02,
 -1.439461218494477e-04,  1.634832836769922e-06, -1.562007968053918e-08,  1.337895039157137e-10, -1.055744038527429e-12,  7.806725473752709e-15, -5.472169550072057e-17,
  3.666226961882272e-19, -2.362284798012212e-21,  1.470869839355415e-23, -8.883395724469227e-26,  6.221396209789043e-03, -1.047286863014023e-04,  1.395702036264135e-06,
 -1.539314313286218e-08,  1.502569749036433e-10, -1.338610084891863e-12,  1.109465016314955e-14, -8.666082358485659e-17,  6.438539797730671e-19, -4.581385642611956e-21,
  3.138770060752983e-23, -2.079162385418595e-25,  3.274998721844729e-03, -6.891910091453104e-05,  1.069952325855966e-06, -1.352905016628955e-08,  1.495513150409735e-10,
 -1.495477939886107e-12,  1.381804686696453e-14, -1.196639647195034e-16,  9.811345846058386e-19, -7.673966923340762e-21,  5.759238774478790e-23, -4.166257489924271e-25,
  1.593156470355000e-03, -4.115691140818489e-05,  7.397937670901697e-07, -1.066104423181606e-08,  1.327491025458952e-10, -1.482845813662634e-12,  1.520620348525914e-14,
 -1.453815554692867e-16,  1.310179489797235e-18, -1.122110216208387e-20,  9.190922766540353e-23, -7.235081805065118e-25,  7.165821933576222e-04, -2.237246493409591e-05,
  4.630397942700887e-07, -7.565319810855766e-09,  1.056320350564908e-10, -1.312654761099823e-12,  1.488267617153547e-14, -1.565270988350254e-16,  1.545239133549612e-18,
 -1.444468548944263e-20,  1.287241221450547e-22, -1.099371779210185e-24,  2.982083856769152e-04, -1.110151319781873e-05,  2.631895051179826e-07, -4.852785171636553e-09,
  7.567950684995681e-11, -1.042508541161029e-12,  1.302546761515208e-14, -1.502417804427192e-16,  1.620027451207900e-18, -1.648320809324232e-20,  1.593932662410275e-22,
 -1.473140373512476e-24,  1.149117406154116e-04, -5.041783722236814e-06,  1.362440975718492e-07, -2.823306982253299e-09,  4.900555393822942e-11, -7.459994084237769e-13,
  1.024223694771541e-14, -1.292186307366449e-16,  1.518070751989097e-18, -1.677185003881160e-20,  1.755868161312653e-22, -1.752258693924036e-24,  4.104053096385665e-05,
 -2.100842654549866e-06,  6.440968759705220e-08, -1.494461092145145e-09,  2.878135870927838e-11, -4.828293285566604e-13,  7.266049332183447e-15, -1.000337890771730e-16,
  1.277600222370482e-18, -1.529495676736829e-20,  1.730120556597841e-22, -1.860723747870305e-24,  1.360065911792790e-05, -8.051083551178836e-07,  2.788200894422239e-08,
 -7.218802378937203e-10,  1.538152134284017e-11, -2.836556762247356e-13,  4.668412155296716e-15, -6.998995764831744e-17,  9.698908708880070e-19, -1.255865711391867e-20,
  1.532243842972570e-22, -1.772971032447411e-24,  4.187889939385941e-06, -2.844557769622863e-07,  1.108139265940407e-08, -3.191342316960004e-10,  7.503924917928034e-12,
 -1.517791492164104e-13,  2.726370134449266e-15, -4.442872362078085e-17,  6.668662932321192e-19, -9.324331417636646e-21,  1.225137175347493e-22, -1.522929157763992e-24,
  1.200110364835474e-06, -9.288796541033399e-08,  4.054653358465643e-09, -1.295084465180809e-10,  3.352392760741215e-12, -7.421889179432588e-14,  1.452392211903208e-15,
 -2.568307411381162e-17,  4.169017222133817e-19, -6.285441573955057e-21,  8.881412034990078e-23, -1.184460101872831e-24,  3.206802559878104e-07, -2.810877941163670e-08,
  1.369801305260675e-09, -4.839235939293010e-11,  1.375967988056552e-12, -3.327945186226522e-14,  7.082868345571600e-16, -1.357034537972655e-17,  2.378890829421448e-19,
 -3.862103954757281e-21,  5.861440649931079e-23, -8.376546438524234e-25,  8.008258926296006e-08, -7.905291756647380e-09,  4.286035178897622e-10, -1.670432610732337e-11,
  5.206281412813463e-13, -1.373190921965143e-14,  3.173558947472935e-16, -6.578577366807675e-18,  1.243789111728051e-19, -2.171778411888703e-21,  3.536158521341372e-23,
 -5.409271118279263e-25,  1.874090967586189e-08, -2.072904300785631e-09,  1.246307716852878e-10, -5.345520280212169e-12,  1.822619742665052e-13, -5.233656252310940e-15,
  1.311484851488137e-16, -2.937491162981896e-18,  5.982665038790295e-20, -1.122255482296327e-21,  1.958310181101631e-23, -3.203275080422438e-25,  4.123014518841108e-09,
 -5.086178481154414e-10,  3.380695006699132e-11, -1.592014988058576e-12,  5.927040609924027e-14, -1.849930937507883e-15,  5.019329076732357e-17, -1.213219668882962e-18,
  2.658646442485806e-20, -5.352067996303138e-22,  9.998819287537886e-24, -1.747237280747107e-25,  8.559423431476980e-10, -1.172557611093399e-10,  8.590909054595021e-12,
 -4.431782210728189e-13,  1.798280109412782e-14, -6.091266553920685e-16,  1.787057847777156e-17, -4.655682355631633e-19,  1.096539485716459e-20, -2.366473038487877e-22,
  4.728745776657919e-24, -8.819416432109716e-26,  1.684236443446421e-10, -2.551784854705952e-11,  2.054992413853383e-12, -1.158762854773913e-13,  5.115409406324888e-15,
 -1.877578017083765e-16,  5.948217672454026e-18, -1.668245952011401e-19,  4.218363692935270e-21, -9.749805168704950e-23,  2.081821617603274e-24, -4.140320852557645e-26,
  3.157545865904284e-11, -5.270652433772810e-12,  4.652605272122150e-13, -2.861445093043051e-14,  1.371829844654322e-15, -5.447768988839781e-17,  1.861140010775703e-18,
 -5.612468589413882e-20,  1.521946091167068e-21, -3.763390053297213e-23,  8.578490510677185e-25, -1.817601927624536e-26,  5.674537829932705e-12, -1.039674472001661e-12,
  1.003267601001254e-13, -6.715368748261630e-15,  3.490005837416677e-16, -1.497148937220316e-17,  5.508007700691838e-19, -1.783722843805558e-20,  5.181260389081481e-22,
 -1.369240705064955e-23,  3.328584472846118e-25, -7.506353636547217e-27,  9.845430386170916e-13, -1.972701179645483e-13,  2.075342845751077e-14, -1.508514980747439e-15,
  8.482729634196278e-17, -3.924517551374898e-18,  1.552575089866076e-19, -5.392237377425944e-21,  1.675754059582195e-22, -4.727428745565937e-24,  1.224297577933867e-25,
 -2.935570345471960e-27,  1.662852914225302e-13, -3.630365648626043e-14,  4.152308904801031e-15, -3.270133094790774e-16,  1.985768734658031e-17, -9.890954035630232e-19,
  4.201100488883438e-20, -1.562580036002823e-21,  5.188492385788972e-23, -1.560581884548843e-24,  4.300510744051089e-26, -1.095146000975145e-27,  2.760209626051297e-14,
 -6.541771969559462e-15,  8.111580727340809e-16, -6.904836892134424e-17,  4.518371581144476e-18, -2.418436823876629e-19,  1.100971350650197e-20, -4.378579458913889e-22,
  1.551138679221771e-23, -4.967345057127026e-25,  1.454644768248975e-26, -3.929210853029912e-28,  4.552742954009645e-15, -1.166866305931489e-15,  1.563856687849720e-16,
 -1.435152195819285e-17,  1.009715456555087e-18, -5.795568746272218e-20,  2.822456181917414e-21, -1.198101181251892e-22,  4.520712855039951e-24, -1.538950203769204e-25,
  4.781932457214438e-27, -1.368104057662784e-28,  7.555915738234841e-16, -2.085899600167705e-16,  3.011891141044540e-17, -2.971491032636407e-18,  2.242076879746590e-19,
 -1.376847587968864e-20,  7.157692028168626e-22, -3.236477987718656e-23,  1.298237611803962e-24, -4.689511462427814e-26,  1.543469223612773e-27, -4.669303801327269e-29,
  1.279725257974530e-16, -3.789194441921875e-17,  5.874204495578486e-18, -6.211157723949313e-19,  5.011813819706241e-20, -3.284201013484859e-21,  1.818050940284330e-22,
 -8.736379523217364e-24,  3.717261432921526e-25, -1.421792546113602e-26,  4.946727067802815e-28, -1.579279794644932e-29,  2.246870597188636e-17, -7.103579544853007e-18,
  1.177811048126041e-18, -1.330104876543914e-19,  1.144105135853930e-20, -7.976275595856855e-22,  4.688545853860365e-23, -2.387936522768454e-24,  1.075003089917601e-25,
 -4.343027081323679e-27,  1.593509146258895e-28, -5.356533517627337e-30,  4.160092726852679e-18, -1.397580244501411e-18,  2.467950153282088e-19, -2.965146798474403e-20,
  2.708978466508262e-21, -2.002389188714344e-22,  1.245750351320287e-23, -6.703793053317446e-25,  3.183489670383912e-26, -1.354580219704409e-27,  5.226832078285942e-29,
 -1.844947631299452e-30,  8.271451422877796e-19, -2.937518654125541e-19,  5.498759083648149e-20, -6.997968173086836e-21,  6.762587546211762e-22, -5.279026368264740e-23,
  3.462940612021191e-24, -1.961866559611805e-25,  9.793465884912773e-27, -4.374179617081076e-28,  1.769252651461825e-29, -6.537040252188073e-31,  1.799140095422414e-19,
 -6.716992563451413e-20,  1.325931898933199e-20, -1.778617512173152e-21,  1.809509956209430e-22, -1.485053744484720e-23,  1.022730066384840e-24, -6.074466556220030e-26,
  3.174749883886222e-27, -1.482640777043884e-28,  6.262507109411802e-30, -2.413199446531627e-31,  4.357561659563777e-20, -1.700129467389391e-20,  3.518730228769111e-21,
 -4.947617884799238e-22,  5.271085842067953e-23, -4.524757439941114e-24,  3.255324417148298e-25, -2.017386537196778e-26,  1.098795884929296e-27, -5.341510487047552e-29,
  2.345891286511089e-30, -9.388028896104664e-32,  1.192716722339532e-20, -4.832341335462702e-21,  1.041990970809895e-21, -1.526316525181246e-22,  1.692708120404119e-23,
 -1.511068574983098e-24,  1.129372012512500e-25, -7.263229694301097e-27,  4.101157898681573e-28, -2.064735563746393e-29,  9.381973219189379e-31, -3.880609599638529e-32,
  3.718585515524151e-21, -1.554105037333717e-21,  3.467266874184552e-22, -5.255192374045591e-23,  6.026824494523049e-24, -5.559173353067697e-25,  4.289559138435417e-26,
 -2.845636659767496e-27,  1.655991979788174e-28, -8.585272903073045e-30,  4.013907200829926e-31, -1.706794231802749e-32,  1.310257625230086e-21, -5.609292105911271e-22,
  1.285243740533502e-22, -2.000802360271692e-23,  2.355775912054124e-24, -2.229590638115739e-25,  1.764054716887160e-26, -1.199145511706661e-27,  7.145847463251167e-29,
 -3.791122907464628e-30,  1.812680924383832e-31, -7.877333905833977e-33,  4.960097208269370e-22, -2.159474762060155e-22,  5.041640428611486e-23, -7.998100386615057e-24,
  9.593758057580434e-25, -9.246403733283513e-26,  7.446535961843959e-27, -5.149968663653356e-28,  3.120851708120817e-29, -1.682958024286654e-30,  8.175542706487838e-32,
 -3.607897416071597e-33,  1.589330691803956e-22, -6.984891645173994e-23,  1.648015781777857e-23, -2.642340420379897e-24,  3.202847319907376e-25, -3.118650501652071e-26,
  2.536786054953562e-27, -1.771558756647323e-28,  1.083755089306496e-29, -5.898281778905421e-31,  2.891029790862239e-32, -1.286930922074302e-33,  5.866552902672214e-02,
 -1.419000241258036e-04,  3.546964995521214e-07, -9.118922147776649e-10,  2.396224513144096e-12, -6.400573281335152e-15,  1.727698092371517e-17, -4.698582303699658e-20,
  1.281191960515553e-22, -3.504848957683153e-25,  9.562195601350652e-28, -2.617669236283505e-30,  5.401175130320732e-02, -1.567004404383055e-04,  5.427010369194608e-07,
 -1.983948372210811e-09,  7.250191790909525e-12, -2.607972978755177e-14,  9.213309019820117e-17, -3.201845862538344e-19,  1.096656931630090e-21, -3.709566042077592e-24,
  1.240717889583311e-26, -4.109563899055556e-29,  4.578388474201023e-02, -1.770982734437931e-04,  8.588236149266621e-07, -4.077314330089679e-09,  1.846626349094695e-11,
 -8.043346297650890e-14,  3.396772915805626e-16, -1.398548454318025e-18,  5.635325996090550e-21, -2.228483787898445e-23,  8.667229926970843e-26, -3.321119799103129e-28,
  3.573422761578302e-02, -1.902352653388506e-04,  1.200868725057985e-06, -6.941335686439330e-09,  3.744062964748617e-11, -1.920232943439981e-13,  9.464526632272644e-16,
 -4.513618063218816e-18,  2.092859241846337e-20, -9.469763862028634e-23,  4.193492715121689e-25, -1.821566512580854e-27,  2.568309747474853e-02, -1.868145337512664e-04,
  1.458009515917300e-06, -1.000624251256875e-08,  6.322139022642132e-11, -3.759126407652470e-13,  2.129545732785417e-15, -1.158945841706373e-17,  6.095858554197799e-20,
 -3.113005291428771e-22,  1.548961651926125e-24, -7.530723544403920e-27,  1.700054689822109e-02, -1.653650617105614e-04,  1.550865106269588e-06, -1.247649224302795e-08,
  9.126616204360536e-11, -6.218604697999320e-13,  4.004155819862361e-15, -2.460659646151365e-17,  1.453492944639129e-19, -8.296995650967481e-22,  4.596000743347233e-24,
 -2.478644794821325e-26,  1.036601861685934e-02, -1.315823733201244e-04,  1.459570489399113e-06, -1.363868476149302e-08,  1.144306606459119e-10, -8.855181099779176e-13,
  6.426747642073053e-15, -4.424411997727204e-17,  2.912919662557798e-19, -1.845258757682875e-21,  1.130031027847615e-23, -6.714915861345109e-26,  5.823697947992110e-03,
 -9.426301561029274e-05,  1.224570211924072e-06, -1.318952671864355e-08,  1.259623583319966e-10, -1.099272496773400e-12,  8.933428453642776e-15, -6.847088636278977e-17,
  4.994795542185500e-19, -3.491418756768075e-21,  2.350910693095061e-23, -1.531122823003568e-25,  3.015467919220751e-03, -6.097036022540991e-05,  9.210290362162164e-07,
 -1.135856535494549e-08,  1.227039969944162e-10, -1.200744339871120e-12,  1.086844634225853e-14, -9.227678405369232e-17,  7.422699533558351e-19, -5.699129428790203e-21,
  4.200744489048360e-23, -2.985874919490172e-25,  1.439603443962334e-03, -3.571631527839423e-05,  6.236871164870787e-07, -8.755788372101269e-09,  1.064349381079625e-10,
 -1.162356874988620e-12,  1.166647134509458e-14, -1.092675398285446e-16,  9.653774825687211e-19, -8.110721345413892e-21,  6.520446168378951e-23, -5.040399852838314e-25,
  6.339640884348158e-04, -1.900442617669840e-05,  3.815893018421803e-07, -6.067220435195998e-09,  8.262273936662885e-11, -1.002923221917916e-12,  1.112058218216940e-14,
 -1.144933252388821e-16,  1.107324995024226e-18, -1.014774930856233e-20,  8.870713034180868e-23, -7.435421983482326e-25,  2.576716558699008e-04, -9.209826976593840e-06,
  2.115846107765137e-07, -3.793060741610111e-09,  5.764279893652135e-11, -7.750277879953129e-13,  9.463352473066334e-15, -1.067812437203236e-16,  1.127313551926501e-18,
 -1.123813543651817e-20,  1.065427894228448e-22, -9.659187065571429e-25,  9.672736541523835e-05, -4.075073042737151e-06,  1.066167123835817e-07, -2.146360246314707e-09,
  3.627680222939062e-11, -5.386267620258418e-13,  7.222297418112456e-15, -8.908316077694264e-17,  1.024085875644902e-18, -1.107969913203649e-20,  1.136653576897172e-22,
 -1.112188860919664e-24,  3.356429291127115e-05, -1.650147510950684e-06,  4.894877403674518e-08, -1.102612399526666e-09,  2.066362611555784e-11, -3.379004004829094e-13,
  4.963360558855072e-15, -6.677012963920139e-17,  8.340425541515646e-19, -9.773331227661847e-21,  1.082859265472124e-22, -1.141422758338837e-24,  1.077685907319144e-05,
 -6.129134361530814e-07,  2.052689918784701e-08, -5.156813651484832e-10,  1.068658478262294e-11, -1.920022393146824e-13,  3.082861644594098e-15, -4.514184822599771e-17,
  6.115584444738878e-19, -7.747930048663180e-21,  9.255710493331155e-23, -1.049305702507724e-24,  3.205718984336979e-06, -2.092915542605912e-07,  7.882441332397537e-09,
 -2.201841521750399e-10,  5.033166089730608e-12, -9.914226376602853e-14,  1.736711344406303e-15, -2.763127702873033e-17,  4.053153830489870e-19, -5.543134008336817e-21,
  7.128986203304767e-23, -8.679950240170091e-25,  8.847430400084312e-07, -6.585691354206552e-08,  2.778923970285407e-09, -8.607110198219813e-11,  2.165325450642277e-12,
 -4.667034922354923e-14,  8.903760302668080e-16, -1.536750863084191e-17,  2.437177998600337e-19, -3.593027472417627e-21,  4.968303201023625e-23, -6.488515653636711e-25,
  2.269526650315290e-07, -1.914410688846874e-08,  9.018942533994034e-10, -3.089319090602048e-11,  8.535444031833632e-13, -2.009391099328508e-14,  4.168410713222947e-16,
 -7.793478043987575e-18,  1.334530639208400e-19, -2.118220872326692e-21,  3.145438406233153e-23, -4.401246054248775e-25,  5.422499556922038e-08, -5.155125286001722e-09,
  2.702558724914861e-10, -1.021292343992384e-11,  3.092851494253366e-13, -7.939539162263578e-15,  1.788297624711455e-16, -3.617084507342216e-18,  6.679482513620700e-20,
 -1.140154491728471e-21,  1.816236539835301e-23, -2.720077666876163e-25,  1.209787300381175e-08, -1.289836453792145e-09,  7.501344957874823e-11, -3.120198855397031e-12,
  1.033795736591205e-13, -2.889294901987032e-15,  7.056398949094762e-17, -1.542159200662668e-18,  3.067711937699441e-20, -5.625514228191588e-22,  9.603840026810209e-24,
 -1.538024600789597e-25,  2.527987030103704e-09, -3.008951076082019e-10,  1.935594862327341e-11, -8.842492138121098e-13,  3.199686483996973e-14, -9.721724704861002e-16,
  2.571119609367970e-17, -6.064516283111873e-19,  1.298157802895231e-20, -2.554936982064851e-22,  4.670260498191766e-24, -7.990835424204494e-26,  4.965439687442090e-10,
 -6.570361647155389e-11,  4.661991236903492e-12, -2.334186208975315e-13,  9.209026335253441e-15, -3.037458843740668e-16,  8.688406826812448e-18, -2.209344288428990e-19,
  5.084001696542075e-21, -1.072905460673747e-22,  2.098089874614698e-24, -3.832214374734944e-26,  9.206862279369362e-11, -1.349047714066876e-11,  1.053002149025376e-12,
 -5.766476758344817e-14,  2.476377612775639e-15, -8.854614770753738e-17,  2.736053428250789e-18, -7.492539575900824e-20,  1.851642188009791e-21, -4.186232375921467e-23,
  8.750247809588117e-25, -1.704791948116881e-26,  1.619697693163155e-11, -2.618262547967945e-12,  2.242365772175627e-13, -1.340395342561638e-14,  6.255408448390890e-16,
 -2.421372231954017e-17,  8.072643093988541e-19, -2.378111482965893e-20,  6.305496351409049e-22, -1.525815034941463e-23,  3.406154599818360e-25, -7.072771594806467e-27,
  2.719705703207872e-12, -4.832841884210543e-13,  4.529782815579237e-14, -2.949699867151477e-15,  1.493475306864156e-16, -6.249464700585488e-18,  2.245212944052044e-19,
 -7.107275500378342e-21,  2.019802091208265e-22, -5.226367592152552e-24,  1.244931486474188e-25, -2.752836964184091e-27,  4.389709381991470e-13, -8.544499439968807e-14,
  8.742467494491739e-15, -6.189032517830051e-16,  3.393902907144634e-17, -1.533003956808296e-18,  5.927241207304174e-20, -2.013802597327613e-21,  6.127356189292974e-23,
 -1.693704764111440e-24,  4.300877153072057e-26, -1.011837823388816e-27,  6.867006783985171e-14, -1.459018363465591e-14,  1.625372021549513e-15, -1.248279657095106e-16,
  7.400567488924507e-18, -3.602683011525696e-19,  1.496996050466635e-20, -5.451920312144865e-22,  1.773964461271323e-23, -5.232450667549434e-25,  1.414969680100402e-26,
 -3.538242599756652e-28,  1.051266278039830e-14, -2.429387168861677e-15,  2.938759479287192e-16, -2.442997994482582e-17,  1.562839467551445e-18, -8.185580352679239e-20,
  3.649706096529035e-21, -1.422771235000526e-22,  4.944209414926410e-24, -1.554226961145126e-25,  4.470628187801266e-27, -1.186875266228047e-28,  1.592731713137131e-15,
 -3.988540838251757e-16,  5.224215894694953e-17, -4.689580248763340e-18,  3.230309737224758e-19, -1.816883751199134e-20,  8.677491698431272e-22, -3.615099405088032e-23,
  1.339656065976472e-24, -4.481764787118469e-26,  1.369384456113543e-27, -3.854691315768973e-29,  2.419179828910412e-16, -6.539498084732943e-17,  9.246174058437606e-18,
 -8.938824540644142e-19,  6.614299157022019e-20, -3.986393752152594e-21,  2.035365173107871e-22, -9.045034178241327e-24,  3.568070654705179e-25, -1.268247312850082e-26,
  4.109702907285087e-28, -1.224711809671618e-29,  3.738410663893447e-17, -1.086373260670879e-17,  1.652549565101489e-18, -1.715530283346578e-19,  1.359984185906978e-20,
 -8.761377850040956e-22,  4.771223185605393e-23, -2.256822904838446e-24,  9.457510403383311e-26, -3.564578444572423e-27,  1.222713871053110e-28, -3.850473412388937e-30,
  5.975804819271142e-18, -1.858586472335912e-18,  3.030453842698648e-19, -3.366923375591875e-20,  2.850835474624224e-21, -1.957553021767651e-22,  1.133962982537984e-23,
 -5.694548127615347e-25,  2.528937257093431e-26, -1.008362703718310e-27,  3.653149350592570e-29, -1.213043936539673e-30,  1.006346780473958e-18, -3.333887152213755e-19,
  5.802679942642109e-20, -6.873751937297078e-21,  6.194497616973192e-22, -4.518653619109320e-23,  2.775587094939377e-24, -1.475376535787063e-25,  6.923568372815337e-27,
 -2.912406348665010e-28,  1.111408922054198e-29, -3.881279656298627e-31,  1.820986271955109e-19, -6.392544941363132e-20,  1.182189766867875e-20, -1.486680291556048e-21,
  1.420158140880077e-22, -1.096285509109313e-23,  7.114232836128098e-25, -3.988665849162124e-26,  1.971174299569273e-27, -8.718942586065611e-29,  3.493629315083084e-30,
 -1.279176038445897e-31,  3.613813891818852e-20, -1.336762544045849e-20,  2.612983943806130e-21, -3.471306732968403e-22,  3.498512303579234e-23, -2.845166753830779e-24,
  1.942237169885479e-25, -1.143812086986378e-26,  5.929067478938146e-28, -2.747027906098466e-29,  1.151437369509344e-30, -4.404199082327038e-32,  8.024485982445476e-21,
 -3.108767774156353e-21,  6.385589626220611e-22, -8.911535244900829e-23,  9.425013019881292e-24, -8.033418069178184e-25,  5.740144322982486e-26, -3.533784290569668e-27,
  1.912433410731573e-28, -9.239410160005898e-30,  4.033552358410177e-31, -1.604888747963764e-32,  2.028682485619226e-21, -8.177763007542452e-22,  1.753693804605718e-22,
 -2.554830686094443e-23,  2.818278706185524e-24, -2.502872354655604e-25,  1.861295744760722e-26, -1.191249605892635e-27,  6.694886302671219e-29, -3.355302837571099e-30,
  1.517946411372293e-31, -6.252068162138913e-33,  5.901965635246278e-22, -2.458386728658333e-22,  5.464727150882131e-23, -8.252499292378336e-24,  9.430524561463197e-25,
 -8.668652579108989e-26,  6.666444238237799e-27, -4.408060078409553e-28,  2.557161393780646e-29, -1.321691036925086e-30,  6.161148693462980e-32, -2.612392286893752e-33,
  1.965875842793578e-22, -8.399704895083822e-23,  1.920473802722776e-23, -2.983274846304951e-24,  3.505158837373512e-25, -3.310607952223593e-26,  2.614144500569089e-27,
 -1.773579414800958e-28,  1.054920292030648e-29, -5.586582363384584e-31,  2.666469678892728e-32, -1.156797156226481e-33,  7.144794281609787e-23, -3.107710046614484e-23,
  7.247862034444312e-24, -1.148598526258771e-24,  1.376325057888893e-25, -1.325154477290961e-26,  1.066156394500429e-27, -7.366411885790082e-29,  4.459858370172779e-30,
 -2.402864260625445e-31,  1.166250258617273e-32, -5.142336099569992e-34,  2.236542442939369e-23, -9.825712778318913e-24,  2.317325035786289e-24, -3.713924614451617e-25,
  4.499878842530881e-26, -4.379801299225840e-27,  3.561213395668635e-28, -2.485991808777866e-29,  1.520228325094082e-30, -8.270661799705389e-32,  4.052358597458869e-33,
 -1.803245939668859e-34,  5.810353567790861e-02, -1.391055807673166e-04,  3.439796779252015e-07, -8.745546242261203e-10,  2.272255304854464e-12, -6.001261096768318e-15,
  1.601692980862938e-17, -4.308072547346111e-20,  1.161633479996172e-22, -3.144428032151284e-25,  8.481996985391107e-28, -2.299763973790870e-30,  5.339348471074352e-02,
 -1.524521284881354e-04,  5.195728432530932e-07, -1.872000897133131e-09,  6.750002941057228e-12, -2.397227218835346e-14,  8.363981086928116e-17, -2.871359171512324e-19,
  9.716267083166502e-22, -3.247616553484774e-24,  1.073366128460374e-26, -3.513866464910217e-29,  4.508892988358749e-02, -1.704184922343166e-04,  8.116169174552721e-07,
 -3.794293485956023e-09,  1.693604712573397e-11, -7.273146096966742e-14,  3.029265653239821e-16, -1.230412534926737e-18,  4.892109467948747e-21, -1.909330330431060e-23,
  7.330329665260742e-26, -2.773130652662128e-28,  3.499198691475033e-02, -1.809515998650707e-04,  1.121044145492203e-06, -6.371816812250014e-09,  3.381745366977667e-11,
 -1.707523663480251e-13,  8.289570674873888e-16, -3.895362006766938e-18,  1.780305020037070e-20, -7.942258881504930e-23,  3.468445762338173e-25, -1.486102073889982e-27,
  2.495843056332937e-02, -1.756141149241980e-04,  1.343764459886913e-06, -9.052175858295493e-09,  5.618904025430016e-11, -3.284871180426223e-13,  1.830747229598401e-15,
 -9.806753839142170e-18,  5.079155543517757e-20, -2.554921292615444e-22,  1.252583026908256e-24, -6.001810493070919e-27,  1.636298612102515e-02, -1.535331005224929e-04,
  1.409514618502623e-06, -1.111073504666700e-08,  7.973674590961025e-11, -5.335293449344469e-13,  3.376038398173379e-15, -2.039987267359489e-17,  1.185423019412641e-19,
 -6.659462090131003e-22,  3.631668872869025e-24, -1.928768994606743e-26,  9.862047944287793e-03, -1.205306346907376e-04,  1.306333213397448e-06, -1.194149962011537e-08,
  9.816756632634916e-11, -7.451472781105483e-13,  5.309014584489425e-15, -3.590387447038684e-17,  2.323339262112234e-19, -1.447234383790297e-21,  8.718495662863736e-24,
 -5.098153115525656e-26,  5.465282863057535e-03, -8.506688775533231e-05,  1.077698786689810e-06, -1.133898416893651e-08,  1.059745033167915e-10, -9.061802753017364e-13,
  7.222336369878410e-15, -5.432950998501857e-17,  3.892082070921221e-19, -2.673156305164271e-21,  1.769335053028830e-23, -1.133198329045151e-25,  2.785504514868999e-03,
 -5.411570081280095e-05,  7.957569635851464e-07, -9.574080548089223e-09,  1.011013609128772e-10, -9.684011660895889e-13,  8.588560995598775e-15, -7.150660677687646e-17,
  5.644269673683350e-19, -4.254941581416224e-21,  3.080805574224510e-23, -2.152043802023691e-25,  1.306090396947103e-03, -3.111981875013213e-05,  5.281148354368966e-07,
 -7.224574093734621e-09,  8.575689329438599e-11, -9.158374674848834e-13,  8.998926499372064e-15, -8.258425291869050e-17,  7.154428158111779e-19, -5.897635844805035e-21,
  4.654462249986217e-23, -3.533757361211070e-25,  5.636205334904134e-04, -1.622190032061882e-05,  3.160966698553272e-07, -4.892245114518264e-09,  6.499288938731042e-11,
 -7.708094862748599e-13,  8.360466336149281e-15, -8.427846400913190e-17,  7.987028124129203e-19, -7.177000824300817e-21,  6.155255373733629e-23, -5.064418923735897e-25,
  2.239501059739380e-04, -7.684640798225634e-06,  1.711274344936525e-07, -2.983387926228882e-09,  4.419084964252093e-11, -5.800558139328537e-13,  6.923108722232868e-15,
 -7.643438898834063e-17,  7.902011773407380e-19, -7.719596912652836e-21,  7.176286780149013e-23, -6.383063925498897e-25,  8.198274039422712e-05, -3.316058826007083e-06,
  8.401580919914671e-08, -1.643479695194764e-09,  2.705325897965412e-11, -3.918598712349797e-13,  5.132538228149926e-15, -6.190439378399212e-17,  6.964847057190396e-19,
 -7.380365026220373e-21,  7.420548810557811e-23, -7.120266724667781e-25,  2.767039175715588e-05, -1.306336715618500e-06,  3.749746958478389e-08, -8.201715039045413e-10,
  1.495969851314253e-11, -2.384960895336644e-13,  3.419990188007264e-15, -4.496353625255854e-17,  5.494046939395080e-19, -6.302503738060492e-21,  6.840787778443517e-23,
 -7.068204200510238e-25,  8.618193286463343e-06, -4.708119052605796e-07,  1.524985029139179e-08, -3.717893466028910e-10,  7.494466533990538e-12, -1.312040773573776e-13,
  2.055551125175886e-15, -2.940178534978332e-17,  3.894600730491456e-19, -4.828305841618674e-21,  5.648231761130103e-23, -6.274441532497174e-25,  2.479688948054016e-06,
 -1.555690310749324e-07,  5.664657366821110e-09, -1.534904487848272e-10,  3.411322015569015e-12, -6.544609464513032e-14,  1.118146962296450e-15, -1.737065064417330e-17,
  2.490426073626582e-19, -3.331699546103293e-21,  4.194577688149780e-23, -5.002818575799745e-25,  6.599834105514983e-07, -4.723202868635807e-08,  1.926535848070944e-09,
 -5.786394986000260e-11,  1.414848450818786e-12, -2.969059630207238e-14,  5.522675721653798e-16, -9.304271040380375e-18,  1.441779276018083e-19, -2.078633288803129e-21,
  2.812937868287480e-23, -3.597725987785607e-25,  1.627501938531360e-07, -1.320700919753578e-08,  6.014313461755233e-10, -1.997428144395455e-11,  5.362562447187511e-13,
 -1.228840084068731e-14,  2.484807366655027e-16, -4.533701575759330e-18,  7.583764433447592e-20, -1.176906041092109e-21,  1.710022259399255e-23, -2.342877671514969e-25,
  3.725698007829342e-08, -3.409880982277814e-09,  1.728228509205433e-10, -6.332023259541968e-12,  1.863138337600653e-13, -4.654873125154273e-15,  1.021834839915509e-16,
 -2.016675000890188e-18,  3.637426979469441e-20, -6.069781097408327e-22,  9.459762946503318e-24, -1.387064876147266e-25,  7.936187821467538e-09, -8.152386109833179e-10,
  4.585084467743171e-11, -1.849299042249083e-12,  5.953399692469575e-14, -1.619353012615325e-15,  3.854294823831894e-17, -8.218785078956693e-19,  1.596787596419911e-20,
 -2.862425948128403e-22,  4.780792685267522e-24, -7.495737588279440e-26,  1.577480521328737e-09, -1.810737867112690e-10,  1.126967101627602e-11, -4.993458742568391e-13,
  1.755940458236166e-14, -5.192920091102304e-16,  1.338555351779867e-17, -3.080729117386694e-19,  6.441136527254107e-21, -1.239302628975648e-22,  2.216382319415572e-24,
 -3.712936462044365e-26,  2.935905285067834e-10, -3.750425274973828e-11,  2.576221722486857e-12, -1.251570150502819e-13,  4.799985036605832e-15, -1.541366291640283e-16,
  4.298015232619157e-18, -1.066622992502074e-19,  2.397735814074657e-21, -4.947506840405005e-23,  9.467190691700643e-25, -1.693302834844620e-26,  5.137110745391958e-11,
 -7.275311835364134e-12,  5.501802170984217e-13, -2.925084600392704e-14,  1.221646303922105e-15, -4.254325692279908e-17,  1.281920267177269e-18, -3.427006762443802e-20,
  8.275838324594550e-22, -1.829880346902567e-23,  3.743719081833434e-25, -7.144172366153090e-27,  8.492114337805340e-12, -1.328555740817126e-12,  1.103375138858377e-13,
 -6.407881611035491e-15,  2.910036014281636e-16, -1.097647608835366e-17,  3.570224074496747e-19, -1.027183642440235e-20,  2.662436700158867e-22, -6.303375065061483e-24,
  1.377780456995764e-25, -2.803239106773972e-27,  1.334024570276904e-12, -2.297510389047896e-13,  2.090502455680727e-14, -1.323729506641152e-15,  6.526945210821826e-17,
 -2.663213872354344e-18,  9.340402405100605e-20, -2.889313908853219e-21,  8.031147917650484e-23, -2.034240545201530e-24,  4.746858007500329e-26, -1.028973944842374e-27,
  2.005274428857471e-13, -3.789038735608408e-14,  3.768204117222028e-15, -2.596734022974632e-16,  1.388020230632637e-17, -6.118615854460092e-19,  2.311217591545134e-20,
 -7.678923926295414e-22,  2.286802470402050e-23, -6.191677297519477e-25,  1.541192876320934e-26, -3.556615341801484e-28,  2.908133267895911e-14, -6.008530170478177e-15,
  6.515245466923365e-16, -4.876692625210233e-17,  2.821277091451489e-18, -1.341698993031679e-19,  5.451697672149149e-21, -1.943279607257333e-22,  6.193880308510081e-24,
 -1.790945598832049e-25,  4.751000012480864e-27, -1.166198774218435e-28,  4.108615522431476e-15, -9.250428219622720e-16,  1.090903328030001e-16, -8.850922466217876e-18,
  5.532213860415385e-19, -2.833949736470477e-20,  1.236970348596606e-21, -4.724558161493222e-23,  1.609842148817616e-24, -4.965583180038224e-26,  1.402425165240545e-27,
 -3.658014196461925e-29,  5.719476668561808e-16, -1.398285137098122e-16,  1.788630342924645e-17, -1.569500480055035e-18,  1.057840394649356e-19, -5.827030732202730e-21,
  2.727874387272276e-22, -1.114801790995398e-23,  4.055360325530371e-25, -1.332700162307697e-26,  4.002434931303167e-28, -1.108058934826131e-29,  7.949646312276020e-17,
 -2.102509286227893e-17,  2.908749172497538e-18, -2.753679675249725e-19,  1.996969752671578e-20, -1.180522631382151e-21,  5.916603382932205e-23, -2.582753536555968e-24,
  1.001461039738589e-25, -3.501049005011807e-27,  1.116468709236557e-28, -3.276071957610837e-30,  1.120219079807778e-17, -3.192328925269597e-18,  4.761398542683148e-19,
 -4.849539227835104e-20,  3.774596893066511e-21, -2.389194642780490e-22,  1.279214652895476e-23, -5.952784689286572e-25,  2.455645162237108e-26, -9.115992882077827e-28,
  3.081440514083426e-29, -9.567490010473165e-31,  1.628452168116168e-18, -4.978682902972172e-19,  7.977218004212120e-20, -8.713603560539006e-21,  7.258031508555035e-22,
 -4.905761169110896e-23,  2.798930345613439e-24, -1.385140469172473e-25,  6.065146631664057e-27, -2.385629480151849e-28,  8.529796379961714e-30, -2.796614611809465e-31,
  2.490112027494990e-19, -8.129083153319568e-20,  1.393603399576268e-20, -1.626589301700123e-21,  1.445028821038381e-22, -1.039649787799381e-23,  6.301682756528799e-25,
 -3.307006096174294e-26,  1.532812410363644e-27, -6.371241183286212e-29,  2.403451374726987e-30, -8.300450540672211e-32,  4.091439160951386e-20, -1.418841872282260e-20,
  2.590622005538204e-21, -3.217343385302125e-22,  3.036319644542411e-23, -2.316570114004694e-24,  1.486412349876777e-25, -8.243293218567702e-27,  4.031112211961578e-28,
 -1.765011456502356e-29,  7.003156389456803e-31, -2.539983729168974e-32,  7.387589636010802e-21, -2.706029272099337e-21,  5.234951024140229e-22, -6.883897602833564e-23,
  6.869383478581394e-24, -5.533198656570837e-25,  3.742373372666518e-26, -2.184310813086137e-27,  1.122520982570641e-28, -5.157594581458456e-30,  2.144482560125193e-31,
 -8.138998580062265e-33,  1.499143844059109e-21, -5.764412167640969e-22,  1.174571590894249e-22, -1.626227855635142e-23,  1.706684107790163e-24, -1.443841515288466e-25,
  1.024230951341622e-26, -6.261483715870045e-28,  3.365801991978167e-29, -1.615513064932184e-30,  7.008301970159264e-32, -2.771570643279064e-33,  3.488724220157593e-22,
 -1.398759314100544e-22,  2.982112772962857e-23, -4.319292812725843e-24,  4.737800811376057e-25, -4.184542973771961e-26,  3.095409375438206e-27, -1.970948007607686e-28,
  1.102198067570598e-29, -5.497484782842881e-31,  2.475561607359311e-32, -1.015072856366730e-33,  9.439187419473906e-23, -3.917789054831717e-23,  8.674933235715781e-24,
 -1.304956689919808e-24,  1.485585438770205e-25, -1.360542332521618e-26,  1.042565614795618e-27, -6.869978225329989e-29,  3.972040860718183e-30, -2.046353962621585e-31,
  9.509411145191627e-33, -4.019935555867539e-34,  2.963268172643901e-23, -1.263508224194774e-23,  2.882220110029646e-24, -4.467008388133489e-25,  5.236683330310249e-26,
 -4.935235797717346e-27,  3.888745757556907e-28, -2.632927545622565e-29,  1.562947143183691e-30, -8.261036783516262e-32,  3.935638184946662e-33, -1.704329665457083e-34,
  1.031551839598749e-23, -4.482376374642300e-24,  1.044226131906295e-24, -1.652979937805114e-25,  1.978533124335292e-26, -1.902932158924969e-27,  1.529412960548879e-28,
 -1.055649405054491e-29,  6.384947513649903e-31, -3.436770103591679e-32,  1.666518173336822e-33, -7.341564769963571e-35,  3.150175666764213e-24, -1.383423990090012e-24,
  3.261298887264169e-25, -5.224523318874498e-26,  6.327411398037141e-27, -6.155940490694102e-28,  5.003297808924443e-29, -3.491243819736239e-30,  2.134102408876496e-31,
 -1.160583613924167e-32,  5.684306670310326e-34, -2.528495419625967e-35,  5.755255142422270e-02, -1.363951129006622e-04,  3.336992646642303e-07, -8.391382577505374e-10,
  2.155978566300051e-12, -5.630920088775854e-15,  1.486105447443510e-17, -3.953826213027304e-20,  1.054304947039824e-22, -2.824545458306745e-25,  7.532224361286542e-28,
 -2.023801676192397e-30,  5.279184963505190e-02, -1.483836015269495e-04,  4.977413570449772e-07, -1.767730018991743e-09,  6.289997537531358e-12, -2.205798613275867e-14,
  7.601829158030952e-17, -2.578345562955699e-19,  8.620823097481668e-22, -2.847647901280614e-24,  9.301452383297626e-27, -3.009999430114614e-29,  4.441995977987626e-02,
 -1.641031844194982e-04,  7.676645016887361e-07, -3.534570152664190e-09,  1.555141850682313e-11, -6.585756760834800e-14,  2.705672469891001e-16, -1.084319892881117e-18,
  4.254716396836061e-21, -1.639126377537261e-23,  6.212793076462045e-26, -2.320791686833025e-28,  3.428564561588227e-02, -1.722801482609167e-04,  1.047719525640319e-06,
 -5.857012930702945e-09,  3.059284318913141e-11, -1.521044117862010e-13,  7.274512374558546e-16, -3.368856970819964e-18,  1.517857733365367e-20, -6.677276287546709e-23,
  2.876144794887393e-25, -1.215719957650143e-27,  2.427680730691694e-02, -1.652837045081348e-04,  1.240323181660385e-06, -8.203412020271144e-09,  5.003734985831956e-11,
 -2.876687568892075e-13,  1.577596078873257e-15, -8.319411266530325e-18,  4.243550850007180e-20, -2.102953630471457e-22,  1.016009719803536e-24, -4.798683272232483e-27,
  1.577059112157492e-02, -1.427693937584461e-04,  1.283502143891796e-06, -9.916096222299039e-09,  6.983226615403036e-11, -4.589513208933882e-13,  2.854535485837708e-15,
 -1.696364666790050e-17,  9.699071566456126e-20, -5.363288070031546e-22,  2.879921734388082e-24, -1.506490980776002e-26,  9.399955440697749e-03, -1.106275486708191e-04,
  1.171989033551822e-06, -1.048344645227067e-08,  8.446150027426367e-11, -6.290003491424979e-13,  4.400414873737602e-15, -2.923964310343861e-17,  1.860054299193218e-19,
 -1.139540231325608e-21,  6.754282366929055e-24, -3.887283031992866e-26,  5.141435682114176e-03, -7.696206231221305e-05,  9.512356024900473e-07, -9.779456022558139e-09,
  8.946795243997519e-11, -7.497758082114118e-13,  5.861928393414650e-15, -4.328718075440887e-17,  3.045972526716015e-19, -2.055931927273289e-21,  1.337903924651341e-23,
 -8.427886232240204e-26,  2.581083162866865e-03, -4.818310384434997e-05,  6.899690855377053e-07, -8.100849232665661e-09,  8.364239220070432e-11, -7.843944241678022e-13,
  6.817805692523521e-15, -5.567531193958003e-17,  4.313237284198852e-19, -3.193091733869095e-21,  2.271509348110454e-23, -1.559621303648528e-25,  1.189543078483706e-03,
 -2.721967330479129e-05,  4.490841254284929e-07, -5.988005245883343e-09,  6.942516740067632e-11, -7.252085460894301e-13,  6.977563651232685e-15, -6.275615159735211e-17,
  5.332024941238966e-19, -4.313386688008597e-21,  3.342432042732222e-23, -2.492785930085644e-25,  5.034421654695769e-04, -1.391138124434607e-05,  2.631535526916802e-07,
 -3.965539623352548e-09,  5.140603967695042e-11, -5.958105153352474e-13,  6.322797400505631e-15, -6.241915413155986e-17,  5.797553412755242e-19, -5.109122846797702e-21,
  4.299726006728075e-23, -3.473238233205432e-25,  1.957387208193333e-04, -6.447630478558971e-06,  1.392136360552424e-07, -2.360794880785805e-09,  3.409167186420512e-11,
 -4.369640492052440e-13,  5.098830423538963e-15, -5.509107343160020e-17,  5.578409822398911e-19, -5.341364148020818e-21,  4.869749765541524e-23, -4.250300599816176e-25,
  6.994750815870863e-05, -2.716015787644500e-06,  6.665271038598566e-08, -1.267179274722162e-09,  2.031951567234051e-11, -2.871867817145111e-13,  3.675052583401070e-15,
 -4.335126135033281e-17,  4.774384076144776e-19, -4.955995986656063e-21,  4.884460123031488e-23, -4.596771679192216e-25,  2.298797202122499e-05, -1.041991681815947e-06,
  2.894749215762202e-08, -6.149108563551141e-10,  1.091803891593483e-11, -1.697295953298781e-13,  2.376475150932484e-15, -3.054011417025112e-17,  3.650883062290459e-19,
 -4.100637570948133e-21,  4.360852836980203e-23, -4.417366339410913e-25,  6.953322578992576e-06, -3.648038056856977e-07,  1.142922687076129e-08, -2.704465778006219e-10,
  5.303683445007120e-12, -9.048782209850911e-14,  1.383470050481798e-15, -1.933297574381109e-17,  2.504260780537105e-19, -3.038463089782743e-21,  3.481138560016031e-23,
 -3.789723758156574e-25,  1.937571865933491e-06, -1.167821990261145e-07,  4.111371798811345e-09, -1.080730884542649e-10,  2.335581547123741e-12, -4.364680019785466e-14,
  7.273897219556656e-16, -1.103520926460733e-17,  1.546515789956311e-19, -2.024069048677212e-21,  2.494851166115804e-23, -2.915096465108649e-25,  4.979714106324193e-07,
 -3.425322813322531e-08,  1.350509653000848e-09, -3.933672508770805e-11,  9.349056312416278e-13, -1.910314564407194e-14,  3.464756655838725e-16, -5.698331324788824e-18,
  8.628504268578268e-20, -1.216628733597050e-21,  1.611429364862344e-23, -2.018572985452103e-25,  1.182107221317767e-07, -9.225231332645805e-09,  4.060527449395137e-10,
 -1.307499261481359e-11,  3.411080046675578e-13, -7.608842403499397e-15,  1.499788628011125e-16, -2.670632370636319e-18,  4.364209693724476e-20, -6.622187866115749e-22,
  9.415328117999055e-24, -1.263163459705614e-25,  2.596458889726658e-08, -2.286854168483415e-09,  1.120368286957338e-10, -3.979601834375192e-12,  1.137693094246335e-13,
 -2.766390641124753e-15,  5.918605019516727e-17, -1.139773709162767e-18,  2.007985301451924e-20, -3.275722694560826e-22,  4.994855684801825e-24, -7.170620022532551e-26,
  5.288284570776906e-09, -5.231748546128396e-10,  2.844943211317052e-11, -1.112487190590841e-12,  3.479556380954414e-14, -9.210796291096074e-16,  2.136473036216528e-17,
 -4.444940170183948e-19,  8.434349641527591e-21, -1.477991177609534e-22,  2.414988439333653e-24, -3.706982081052702e-26,  1.001378901550372e-09, -1.107978094546633e-10,
  6.669922174150496e-12, -2.865885399035155e-13,  9.792263591918391e-15, -2.818416107281801e-16,  7.080087981072812e-18, -1.589894000917500e-19,  3.246593309999898e-21,
 -6.106336078470830e-23,  1.068395443617648e-24, -1.752287258080257e-26,  1.768558345488031e-10, -2.179876850505309e-11,  1.449120438870881e-12, -6.829271129460280e-14,
  2.545538306694120e-15, -7.956911408109678e-17,  2.162614274803663e-18, -5.237080172778091e-20,  1.149953758176706e-21, -2.319803641907287e-23,  4.343274722529262e-25,
 -7.606410590793567e-27,  2.924547229532776e-11, -4.000853590757913e-12,  2.930073933118727e-13, -1.511910342856008e-14,  6.139329209803353e-16, -2.081817500177334e-17,
  6.115954599177964e-19, -1.595850742649698e-20,  3.765211365245245e-22, -8.141049962526080e-24,  1.629987315372962e-25, -3.046302327129201e-27,  4.549333303847762e-12,
 -6.883639628893519e-13,  5.541218619290466e-14, -3.125324320692469e-15,  1.380701553535486e-16, -5.073420920362578e-18,  1.609543697494912e-19, -4.521603089392721e-21,
  1.145450298556559e-22, -2.652746871858095e-24,  5.676312525874420e-26, -1.131420762887119e-27,  6.694761927223722e-13, -1.116713346683250e-13,  9.858714858487586e-15,
 -6.067685697236350e-16,  2.912438522713320e-17, -1.158392192270740e-18,  3.964840396471873e-20, -1.198160788734045e-21,  3.256571722480203e-23, -8.072560256110266e-25,
  1.844895672277284e-26, -3.919546002492040e-28,  9.383445821393631e-14, -1.719894075756404e-14,  1.661525340144546e-15, -1.113996780597350e-16,  5.801628720201898e-18,
 -2.494861528290070e-19,  9.203502182375868e-21, -2.989238451634464e-22,  8.710102415111264e-24, -2.309342386819856e-25,  5.633046550253797e-27, -1.274769692467093e-28,
  1.262847161581012e-14, -2.535288989117103e-15,  2.674112117570829e-16, -1.949686153408554e-17,  1.100102921551101e-18, -5.108482623202464e-20,  2.028931246297853e-21,
 -7.075790684134587e-23,  2.208383854095973e-24, -6.257521064062880e-26,  1.627878311994929e-27, -3.921202064112247e-29,  1.647774349695157e-15, -3.611556637985818e-16,
  4.149305331291262e-17, -3.283628827076591e-18,  2.004204969054294e-19, -1.003625715395825e-20,  4.286394760173964e-22, -1.603343804277240e-23,  5.354613804149340e-25,
 -1.619993172417223e-26,  4.490708878023592e-28, -1.150413142660110e-29,  2.108526477959140e-16, -5.028348598655474e-17,  6.276998086810308e-18, -5.380666911207084e-19,
  3.546359591356321e-20, -1.912111276367518e-21,  8.769513205611806e-23, -3.513864397799135e-24,  1.254227184764757e-25, -4.047038596543200e-27,  1.194165342818635e-28,
 -3.250162017789658e-30,  2.681963857794385e-17, -6.934142287573649e-18,  9.379633166124479e-19, -8.689288556910776e-20,  6.171946437645059e-21, -3.576642957044353e-22,
  1.758611447925589e-23, -7.536973703301726e-25,  2.871189925937288e-26, -9.867706128878627e-28,  3.095368533348949e-29, -8.939575532675316e-31,  3.444721687301107e-18,
 -9.618598962209602e-19,  1.405598072022639e-19, -1.403605972690769e-20,  1.071931489274632e-21, -6.662318837052119e-23,  3.505116287614525e-24, -1.603807816409887e-25,
  6.509385816676363e-27, -2.378878515024486e-28,  7.920483777084809e-30, -2.423572906537422e-31,  4.549480950462362e-19, -1.366180199321556e-19,  2.149478449509868e-20,
 -2.306735269495677e-21,  1.888936731288109e-22, -1.255984354287912e-23,  7.053717272801691e-25, -3.438127482678501e-26,  1.483579259317207e-27, -5.753585663285986e-29,
  2.029327088334597e-30, -6.566478223299566e-32,  6.306854200051042e-20, -2.027360664838513e-20,  3.420888325308679e-21, -3.931507878876813e-22,  3.440873571967645e-23,
 -2.440205831310278e-24,  1.458722541061024e-25, -7.553477614604462e-27,  3.456243442076182e-28, -1.418858325375213e-29,  5.288538059302142e-31, -1.805393492412249e-32,
  9.388954068184985e-21, -3.214207138491233e-21,  5.790486912361027e-22, -7.097408556790673e-23,  6.613375047239634e-24, -4.984108454182142e-25,  3.160372023626058e-26,
 -1.732766305325822e-27,  8.380685838035015e-29, -3.630647678756055e-30,  1.425838820512353e-31, -5.120426910166042e-33,  1.538194089048038e-21, -5.576097782385296e-22,
  1.066980623344106e-22, -1.388041159977669e-23,  1.370718846328151e-24, -1.093003896676974e-25,  7.320821075449610e-27, -4.232943933057053e-28,  2.155660159388039e-29,
 -9.818085777803535e-31,  4.047862010169978e-32, -1.523803477738941e-33,  2.843400862212835e-22, -1.084639627153014e-22,  2.191352144370294e-23, -3.008581484920566e-24,
  3.131711250432291e-25, -2.628515622187897e-26,  1.850408706812666e-27, -1.122896742659821e-28,  5.993137081816445e-30, -2.856834750055035e-31,  1.231112864362028e-32,
 -4.837543186081882e-34,  6.069680589892550e-23, -2.419597142259932e-23,  5.126537689713794e-24, -7.379641729304849e-25,  8.046186815929999e-26, -7.065331160288943e-27,
  5.197050177466394e-28, -3.291172228787398e-29,  1.830845749155019e-30, -9.085525132815402e-32,  4.071250564828787e-33, -1.661482118523343e-34,  1.521936359679253e-23,
 -6.292886885634151e-24,  1.387615522277682e-24, -2.078746421226290e-25,  2.356934682647823e-26, -2.150097729782840e-27,  1.641345519860085e-28, -1.077597543936882e-29,
  6.208297263914101e-31, -3.187486881326829e-32,  1.476316855788467e-33, -6.220919283709840e-35,  4.488815586639008e-24, -1.909746793027961e-24,  4.345724981451370e-25,
 -6.718776274960592e-26,  7.857610865652011e-27, -7.388082944640294e-28,  5.808363464595784e-29, -3.924049197365821e-30,  2.324457074756077e-31, -1.226092021790506e-32,
  5.829664265702928e-34, -2.519716722043626e-35,  1.492992229142746e-24, -6.480563095170086e-25,  1.507941487261188e-25, -2.384191659193627e-26,  2.850425779374545e-27,
 -2.738388834782867e-28,  2.198445161328567e-29, -1.515805689232933e-30,  9.158574134867970e-32, -4.924715712269172e-33,  2.385689614653880e-34, -1.049976397746659e-35,
  4.441265551975836e-25, -1.949630804128026e-25,  4.593996425927879e-26, -7.356093311916536e-27,  8.904900431149229e-28, -8.659707053766100e-29,  7.035173550004275e-30,
 -4.906958447329380e-31,  2.998232405641462e-32, -1.629852747228032e-33,  7.979493323514897e-35, -3.548054326540860e-36,  5.701224720311485e-02, -1.337652194284874e-04,
  3.238329248672076e-07, -8.055245387525935e-10,  2.046839075978302e-12, -5.287167592699682e-15,  1.379972782273811e-17, -3.632153499904876e-20,  9.578366007365055e-23,
 -2.540335786628123e-25,  6.695714146569419e-28, -1.784069297218842e-30,  5.220614711512691e-02, -1.444848437282457e-04,  4.771181928367143e-07, -1.670522608010002e-09,
  5.866513153860865e-12, -2.031715447566960e-14,  6.917022274726539e-17, -2.318188715865395e-19,  7.659568538700824e-22, -2.500769748789756e-24,  8.073540406229295e-27,
 -2.583004563912352e-29,  4.377556688948615e-02, -1.581273956488882e-04,  7.267002453609377e-07, -3.295941900430989e-09,  1.429682131572695e-11, -5.971342868286526e-14,
  2.420270007054019e-16, -9.571499818579850e-19,  3.707007965529220e-21, -1.409884597746222e-23,  5.276538726382680e-26, -1.946523929297498e-28,  3.361285485267454e-02,
 -1.641714326141711e-04,  9.802748819461239e-07, -5.390946660895666e-09,  2.771797719565136e-11, -1.357247765531921e-13,  6.395771153526071e-16, -2.919483734511395e-18,
  1.296957138048883e-20, -5.627031799869164e-23,  2.390982970394592e-25, -9.971753791332215e-28,  2.363491285470124e-02, -1.557416969460791e-04,  1.146502415440929e-06,
 -7.446860765375709e-09,  4.464449369437127e-11, -2.524550511115134e-13,  1.362579170924180e-15, -7.075156488930397e-18,  3.554824105560492e-20, -1.735819376263371e-22,
  8.265736939602809e-25, -3.848768099829448e-27,  1.521932188289788e-02, -1.329590290488847e-04,  1.170921609908898e-06, -8.868645265910968e-09,  6.130159435344400e-11,
 -3.958086125893115e-13,  2.420253917266713e-15, -1.414787045360586e-17,  7.960607086453322e-20, -4.333694239527516e-22,  2.291730988448129e-24, -1.180952001928289e-26,
  8.975431546653109e-03, -1.017327884387230e-04,  1.053898694797542e-06, -9.227231091158991e-09,  7.287459909917207e-11, -5.325784376167239e-13,  3.659221353873806e-15,
 -2.389487150433229e-17,  1.494593291801870e-19, -9.007077969297582e-22,  5.253592928195100e-24, -2.976407402235253e-26,  4.848096877146739e-03, -6.979834806366290e-05,
  8.419998822810878e-07, -8.460682077233435e-09,  7.578653876310057e-11, -6.225974635149151e-13,  4.775916614826457e-15, -3.462783907277105e-17,  2.393852533128638e-19,
 -1.588187006902728e-21,  1.016309931143650e-23, -6.297856160789636e-26,  2.398805204750015e-03, -4.303057823363031e-05,  6.002982789616183e-07, -6.879686916705486e-09,
  6.947213713754838e-11, -6.380145880946560e-13,  5.436025570852211e-15, -4.354940728517060e-17,  3.311982313407241e-19, -2.408243022993012e-21,  1.683505391030416e-23,
 -1.136350950539859e-25,  1.087419919827587e-03, -2.389658694204510e-05,  3.834421613925488e-07, -4.984701693348037e-09,  5.646266839594702e-11, -5.770397848051710e-13,
  5.437644561288351e-15, -4.794017257809745e-17,  3.995576469471199e-19, -3.172566133291832e-21,  2.414269757012365e-23, -1.769043233715733e-25,  4.517243262924707e-04,
 -1.198337115140139e-05,  2.201339921983916e-07, -3.230686322518472e-09,  4.087588834270555e-11, -4.630986005731092e-13,  4.809344942473513e-15, -4.650565134500265e-17,
  4.234236883536649e-19, -3.660166646839393e-21,  3.023175938936403e-23, -2.397954674659959e-25,  1.720084636035927e-04, -5.438590061663135e-06,  1.138886887928634e-07,
 -1.879083830361373e-09,  2.646088078053178e-11, -3.312506540788999e-13,  3.779768031540312e-15, -3.997461389850609e-17,  3.965290728542563e-19, -3.722023343032218e-21,
  3.328563542419378e-23, -2.851177309813587e-25,  6.006084678501947e-05, -2.238499120098613e-06,  5.322215550327861e-08, -9.836082704949955e-10,  1.536774091886003e-11,
 -2.119774195917953e-13,  2.650763218429021e-15, -3.058711572683778e-17,  3.298043461131197e-19, -3.354211928775887e-21,  3.240958527276247e-23, -2.991939244704997e-25,
  1.924030804209156e-05, -8.371969672735538e-07,  2.251396949446558e-08, -4.645486717994149e-10,  8.030820993302883e-12, -1.217607567371646e-13,  1.664915449780011e-15,
 -2.091727737707776e-17,  2.446799334323071e-19, -2.691237095025435e-21,  2.804551814466675e-23, -2.785518096861069e-25,  5.658290047176525e-06, -2.850354970995347e-07,
  8.638677046238103e-09, -1.984306135491475e-10,  3.786396250079343e-12, -6.296709344880763e-14,  9.396357274620497e-16, -1.283031395139644e-17,  1.625445700499866e-19,
 -1.930409953194585e-21,  2.166326785493765e-23, -2.311472515122962e-25,  1.528828031123312e-06, -8.850411889887442e-08,  3.012711589659516e-09, -7.683454896873437e-11,
  1.614818855813083e-12, -2.939907385959014e-14,  4.779737951130589e-16, -7.082207028683336e-18,  9.703128137752043e-20, -1.242546483009519e-21,  1.499608365483409e-23,
 -1.716780033142018e-25,  3.799011768708188e-07, -2.510936902481817e-08,  9.569395685589335e-10, -2.703204657078878e-11,  6.245287370141964e-13, -1.242678000497772e-14,
  2.197891626624555e-16, -3.529116516912181e-18,  5.222362304605664e-20, -7.202337768477997e-22,  9.337627798412996e-24, -1.145703171048265e-25,  8.693013796525203e-08,
 -6.522038062081088e-09,  2.774476750185978e-10, -8.661950697180526e-12,  2.195998615613690e-13, -4.768547781032400e-15,  9.163023394965620e-17, -1.592484147078038e-18,
  2.542464136561527e-20, -3.772400522973001e-22,  5.248715173687048e-24, -6.895715749744632e-26,  1.834602705220669e-08, -1.554387675632111e-09,  7.360086196058295e-11,
 -2.534408235613540e-12,  7.039472474257514e-14, -1.665937281303394e-15,  3.473818392160894e-17, -6.527739310047386e-19,  1.123315835223017e-20, -1.791556161979518e-22,
  2.672814335090114e-24, -3.756930242834461e-26,  3.577947498993369e-09, -3.407524089007988e-10,  1.791192543144567e-11, -6.790111728439953e-13,  2.063234793101528e-14,
 -5.314986735994595e-16,  1.201405321609022e-17, -2.438699619508143e-19,  4.519465531129986e-21, -7.741743852615779e-23,  1.237538221940611e-24, -1.859748147484727e-26,
  6.463884290211462e-10, -6.890634195015339e-11,  4.011129197285193e-12, -1.671003021528435e-13,  5.547082292412595e-15, -1.553700958585604e-16,  3.803461583362040e-18,
 -8.332890889842846e-20,  1.661822582712638e-21, -3.055317768329641e-23,  5.229670052948166e-25, -8.397140069167949e-27,  1.084948582900148e-10, -1.289629457123247e-11,
  8.293972570423091e-13, -3.790768829248444e-14,  1.373011798701273e-15, -4.177095913438462e-17,  1.106440347661789e-18, -2.614320992411778e-20,  5.606726316017301e-22,
 -1.105676403185787e-23,  2.025303284396313e-25, -3.472703804744136e-27,  1.698086798049367e-11, -2.242649448467767e-12,  1.589961841681659e-13, -7.960067056230634e-15,
  3.141908287450200e-16, -1.037200276632507e-17,  2.970285049045906e-19, -7.563646001334006e-21,  1.743273361123891e-22, -3.685349678566805e-24,  7.220230388612959e-26,
 -1.321380141211359e-27,  2.489288634019115e-12, -3.640618998898304e-13,  2.839257699250509e-14, -1.554651888799783e-15,  6.679210777050209e-17, -2.390271903396837e-18,
  7.394624461910922e-20, -2.027916729403127e-21,  5.019970980432691e-23, -1.137016736078328e-24,  2.381364457529467e-26, -4.649323633194959e-28,  3.436413066908526e-13,
 -5.547861274414032e-14,  4.749641669441182e-15, -2.840073270798465e-16,  1.326553793458621e-17, -5.141434553320711e-19,  1.716868248697263e-20, -5.067217041930732e-22,
  1.346384506936619e-23, -3.265456653168606e-25,  7.307431278952874e-27, -1.521256998563847e-28,  4.496796051385637e-14, -7.989253779039342e-15,  7.493012367293999e-16,
 -4.885416443715512e-17,  2.477858961036824e-18, -1.039066715564558e-19,  3.742101210078721e-21, -1.187761361491861e-22,  3.385276813104955e-24, -8.786589751479910e-26,
  2.099732028954054e-27, -4.658522596415502e-29,  5.622374027113982e-15, -1.095922018185162e-15,  1.123678882733229e-16, -7.975834597835389e-18,  4.387106400174170e-19,
 -1.988343915555839e-20,  7.715908403329492e-22, -2.631679737483065e-23,  8.039876910856368e-25, -2.231715272788512e-26,  5.691624456377990e-28, -1.344962863686755e-29,
  6.781281211712970e-16, -1.445717713785647e-16,  1.617038629652419e-17, -1.247413093492993e-18,  7.430826114707925e-20, -3.635672183390136e-21,  1.518645010696799e-22,
 -5.560767742614446e-24,  1.819442543588596e-25, -5.397015986894130e-27,  1.467872030041545e-28, -3.691882612316008e-30,  7.981056478799832e-17, -1.855013201686270e-17,
  2.258173378338627e-18, -1.889729030892128e-19,  1.217234664951464e-20, -6.420492006762741e-22,  2.883320397356857e-23, -1.132216787580984e-24,  3.963538220339134e-26,
 -1.255207108589387e-27,  3.637473137445256e-29, -9.729087057372835e-31,  9.291711604712452e-18, -2.346461312534680e-18,  3.100993714589784e-19, -2.809248980012431e-20,
  1.953132460991545e-21, -1.108866087081761e-22,  5.346006455919378e-24, -2.248263580514834e-25,  8.410315093454573e-27, -2.840231371627510e-28,  8.760000970083350e-30,
 -2.488979044930690e-31,  1.087471287999591e-18, -2.972752676974589e-19,  4.252992344332734e-20, -4.160903935823458e-21,  3.115834291299080e-22, -1.900387062242129e-23,
  9.818660548430900e-25, -4.415067730403379e-26,  1.762145424901407e-27, -6.336556138258599e-29,  2.077100832583963e-30, -6.260747392619429e-32,  1.303756973035080e-19,
 -3.842294966715531e-20,  5.931582771893438e-21, -6.249474266449333e-22,  5.027727991369851e-23, -3.286589057470417e-24,  1.815809499110295e-25, -8.712302892027409e-27,
  3.702812731839338e-28, -1.415159424161248e-29,  4.921371745538393e-31, -1.570911582786608e-32,  1.636147952928835e-20, -5.174856769982257e-21,  8.588064474155553e-22,
 -9.711699528994581e-23,  8.368192089399138e-24, -5.846128362835107e-25,  3.444588852996018e-26, -1.759001996080299e-27,  7.941409695383360e-29, -3.218200410535812e-30,
  1.184638299371274e-31, -3.995689383421436e-33,  2.202218832502190e-21, -7.437187302551350e-22,  1.321060070469168e-22, -1.597038432624519e-23,  1.468397926777359e-24,
 -1.092496888313397e-25,  6.842051618194934e-27, -3.706796417998412e-28,  1.772289775315598e-29, -7.592976670237563e-31,  2.950111454205138e-32, -1.048531361456019e-33,
  3.264639919548104e-22, -1.170515645350506e-22,  2.214032730095767e-23, -2.847736730942056e-24,  2.781421006183529e-25, -2.194445571123249e-26,  1.454826060283520e-27,
 -8.329144177800153e-29,  4.201424744261436e-30, -1.896035293380985e-31,  7.747945773567860e-33, -2.891813353322828e-34,  5.479380963935033e-23, -2.072505078773427e-23,
  4.149557906140787e-24, -5.646562300953179e-25,  5.827021177518123e-26, -4.849998947771231e-27,  3.386804879573025e-28, -2.039277371310946e-29,  1.080246532349211e-30,
 -5.112100005346419e-32,  2.187590574890626e-33, -8.538020855898956e-35,  1.069049883239983e-23, -4.235545783008215e-24,  8.914914403430583e-25, -1.274917948259096e-25,
  1.381229375995150e-26, -1.205381167872046e-27,  8.813632160441515e-29, -5.549368338434408e-30,  3.069911354115813e-31, -1.515263946764943e-32,  6.754760671333184e-34,
 -2.742858344504311e-35,  2.475149191884245e-24, -1.019265380253921e-24,  2.237582926320074e-25, -3.337297416424664e-26,  3.767651433522972e-27, -3.422689746178873e-28,
  2.602282280935740e-29, -1.701824139757954e-30,  9.767682572836687e-32, -4.996705688751381e-33,  2.306134362799766e-34, -9.684659508275053e-36,  6.835639525746664e-25,
 -2.901298961396580e-25,  6.584811663673422e-26, -1.015401345102497e-26,  1.184484379575516e-27, -1.110947107797727e-28,  8.713079004961297e-30, -5.872758448718293e-31,
  3.470979260522748e-32, -1.826873040014817e-33,  8.667913947929384e-35, -3.738873200431660e-36,  2.166495577516303e-25, -9.393336685138207e-26,  2.182946922076985e-26,
 -3.447067985523124e-27,  4.116030589522696e-28, -3.949461529268279e-29,  3.166993717432850e-30, -2.181117102353388e-31,  1.316382553098240e-32, -7.070803689595713e-34,
  3.421756025850346e-35, -1.504447465627880e-36,  6.267785115312335e-26, -2.750272246501318e-26,  6.477490528233803e-27, -1.036701515551162e-27,  1.254377057175938e-28,
 -1.219265860118527e-29,  9.900802555794445e-31, -6.902600109085904e-32,  4.215749351555873e-33, -2.290716626208498e-34,  1.121027063980121e-35, -4.982571239204800e-37,
  5.648230720786976e-02, -1.312126723884564e-04,  3.143596947828817e-07, -7.736034051628367e-10,  1.944327036368076e-12, -4.967840076095338e-15,  1.282429707557059e-17,
 -3.339776183130899e-20,  8.710220597333585e-23, -2.287572524198418e-25,  5.957618075880610e-28, -1.575733205815748e-30,  5.163571688433164e-02, -1.407465178859812e-04,
  4.576219837440327e-07, -1.579821102423320e-09,  5.476259121750922e-12, -1.873227158164239e-14,  6.300934067133147e-17, -2.086885236554782e-19,  6.814783754789261e-22,
 -2.199448535841376e-24,  7.018911272735677e-27, -2.220493425268172e-29,  4.315443939207450e-02, -1.524681989200621e-04,  6.884830245315324e-07, -3.076440181530754e-09,
  1.315853574424311e-11, -5.421343334339987e-14,  2.168140478682528e-16, -8.462554856668301e-19,  3.235464281246214e-21, -1.214996755061216e-23,  4.490446702891461e-26,
 -1.636136746361639e-28,  3.297145418675486e-02, -1.565806607263319e-04,  9.181574970858584e-07, -4.968367954531725e-09,  2.515059344929589e-11, -1.213107821951732e-13,
  5.633500831714542e-16, -2.535105799883253e-18,  1.110592088160733e-20, -4.752906438943087e-23,  1.992535670909974e-25, -8.200405879901660e-28,  2.302974079585607e-02,
 -1.469153561501696e-04,  1.061264914222955e-06, -6.771229985837410e-09,  3.990700584686676e-11, -2.220074149746935e-13,  1.179504622351239e-15, -6.031531792469842e-18,
  2.985576766286938e-20, -1.436717166330863e-22,  6.744126355732497e-25, -3.096335477952851e-27,  1.470556926707038e-02, -1.240012588816873e-04,  1.070131453305939e-06,
 -7.948122810634901e-09,  5.393562440235941e-11, -3.422021548292281e-13,  2.057552156849747e-15, -1.183337306610937e-17,  6.553685362512846e-20, -3.513042461616684e-22,
  1.829855035677940e-24, -9.290470700417887e-27,  8.584688456730587e-03, -9.372546369123289e-05,  9.498312390428758e-07, -8.141896556847554e-09,  6.304972094260987e-11,
 -4.522739290838728e-13,  3.052523076274668e-15, -1.959285212077072e-17,  1.205207924748232e-19, -7.145909599563936e-22,  4.102304189447925e-24, -2.288258406349249e-26,
  4.581760374561937e-03, -6.344875526882549e-05,  7.473555995487984e-07, -7.341799989554719e-09,  6.440653279100026e-11, -5.187949544953962e-13,  3.905515935176452e-15,
 -2.780896337196164e-17,  1.889060092468255e-19, -1.232115701920565e-21,  7.754631359957100e-24, -4.727967515224698e-26,  2.235790262396347e-03, -3.854044625504254e-05,
  5.240121501809603e-07, -5.863520505317440e-09,  5.792358712640490e-11, -5.210606546846314e-13,  4.352858460054667e-15, -3.421743101648446e-17,  2.555072274086300e-19,
 -1.825159649617561e-21,  1.254018265495123e-23, -8.322807573546873e-26,  9.976103899781211e-04, -2.105379068390601e-05,  3.286870923222586e-07, -4.166966361848600e-09,
  4.612522129791508e-11, -4.612986398753235e-13,  4.258397195110327e-15, -3.680957229499526e-17,  3.010021999226357e-19, -2.346318926741177e-21,  1.753762188395485e-23,
 -1.262781086980324e-25,  4.070822704654194e-04, -1.036691917211147e-05,  1.850033645673974e-07, -2.644913168047913e-09,  3.267010940975560e-11, -3.618830121438815e-13,
  3.678623316125959e-15, -3.485014493095102e-17,  3.111002827087086e-19, -2.638336388222734e-21,  2.139130444847884e-23, -1.666371224976911e-25,  1.519430473109818e-04,
 -4.610952484239162e-06,  9.367628668486865e-08, -1.504137286708606e-09,  2.065926615433712e-11, -2.526490376403704e-13,  2.819679374779949e-15, -2.919528984722161e-17,
  2.837568715773347e-19, -2.611500981857510e-21,  2.291211897277115e-23, -1.926450235807968e-25,  5.188915359833215e-05, -1.856056159175309e-06,  4.276470418013254e-08,
 -7.684552871436397e-10,  1.170072467557461e-11, -1.575470285091125e-13,  1.925568327263157e-15, -2.173887064999006e-17,  2.295272511778859e-19, -2.287507561232885e-21,
  2.167270842636437e-23, -1.962920111877418e-25,  1.621929444763615e-05, -6.773710631882705e-07,  1.763650661315298e-08, -3.535504967342203e-10,  5.951964268320905e-12,
 -8.802856380953491e-14,  1.175698353892199e-15, -1.444306596572486e-17,  1.653446294382729e-19, -1.781197977392821e-21,  1.819200072801093e-23, -1.771886385032940e-25,
  4.642623291358348e-06, -2.245091659401649e-07,  6.583104493740316e-09, -1.468100609249881e-10,  2.726253237266861e-12, -4.419775243439821e-14,  6.438457351814034e-16,
 -8.591627240545896e-18,  1.064704903290684e-19, -1.237857246618788e-21,  1.360852079222100e-23, -1.423345667642571e-25,  1.217741411231085e-06, -6.769220181961461e-08,
  2.228165079916298e-09, -5.513962281346271e-11,  1.127140546721592e-12, -1.999399088710367e-14,  3.171643460753170e-16, -4.590471617221424e-18,  6.149292747612677e-20,
 -7.705647532133637e-22,  9.106912707518502e-24, -1.021609868207063e-25,  2.929373715672234e-07, -1.859869954228870e-08,  6.851522403756514e-10, -1.877174956205960e-11,
  4.216214456880445e-13, -8.170388045254955e-15,  1.409341144588539e-16, -2.209562627248220e-18,  3.195693622564185e-20, -4.311205430864522e-22,  5.471584608523121e-24,
 -6.576436020611531e-26,  6.469850393497081e-08, -4.665040101618638e-09,  1.917878918685700e-10, -5.805488718460744e-12,  1.430351328909578e-13, -3.023795739320110e-15,
  5.664707436101160e-17, -9.609444413526909e-19,  1.498988677499257e-20, -2.175002871383929e-22,  2.961601884436578e-24, -3.810520186066614e-26,  1.313750450437927e-08,
 -1.070351062204613e-09,  4.897769838024848e-11, -1.634897300239339e-12,  4.411973812994917e-14, -1.016228423024025e-15,  2.065365107962939e-17, -3.787265468358641e-19,
  6.366193580229910e-21, -9.926778965980073e-23,  1.449061944549307e-24, -1.994337948991571e-26,  2.456896977549206e-09, -2.251540752913169e-10,  1.143875347770118e-11,
 -4.203246071502391e-13,  1.240730931798882e-14, -3.110288301507636e-16,  6.851266672427768e-18, -1.356873690704688e-19,  2.455913101633453e-21, -4.112435167694223e-23,
  6.431301046451321e-25, -9.462102643013281e-27,  4.240964860125223e-10, -4.353679672525110e-11,  2.450033941173266e-12, -9.894339480298393e-14,  3.190737885598167e-15,
 -8.696445262115318e-17,  2.074467469674923e-18, -4.433951007981523e-20,  8.635608514656367e-22, -1.551921038709687e-23,  2.598612260643724e-25, -4.084796489233224e-27,
  6.775303960176318e-11, -7.762446763872032e-12,  4.828173965132199e-13, -2.139667770119661e-14,  7.529446784815938e-16, -2.229162088307029e-17,  5.753964758804995e-19,
 -1.326412258821249e-20,  2.778130116385607e-22, -5.355335334073451e-24,  9.596536087460591e-26, -1.610937432042087e-27,  1.005189089191932e-11, -1.280868646295769e-12,
  8.787431132824603e-14, -4.267268418774183e-15,  1.636853245770141e-16, -5.259495282570059e-18,  1.467988790490396e-19, -3.647524496728894e-21,  8.211320073067786e-23,
 -1.697055133770110e-24,  3.253027502939615e-26, -5.829154586771930e-28,  1.390713098151065e-12, -1.964679506540433e-13,  1.483773738000912e-14, -7.884626341760549e-16,
  3.293318168456649e-17, -1.147541407603039e-18,  3.461054488722706e-20, -9.264042333797169e-22,  2.240473381999730e-23, -4.962241495945440e-25,  1.017082237282026e-26,
 -1.944732575043732e-28,  1.803579422766490e-13, -2.816247109795095e-14,  2.336890928523139e-15, -1.357033975966699e-16,  6.165847494348493e-18, -2.327969029625227e-19,
  7.582125161247843e-21, -2.185022258192291e-22,  5.674231656209220e-24, -1.346201811513346e-25,  2.949176052066985e-27, -6.014866502383387e-29,  2.206413865242551e-14,
 -3.796935148880745e-15,  3.455229783436766e-16, -2.189674319384147e-17,  1.081136516966724e-18, -4.419314287648468e-20,  1.553262261802683e-21, -4.816470461283436e-23,
  1.342362563757296e-24, -3.409874370622383e-26,  7.981012513981780e-28, -1.735525230229639e-29,  2.565964026509950e-15, -4.852358622219604e-16,  4.833356626780736e-17,
 -3.338056545504044e-18,  1.789035231076165e-19, -7.910381506732708e-21,  2.998055561220717e-22, -9.996853594568081e-24,  2.988451809603120e-25, -8.123733960298111e-27,
  2.030470361328490e-28, -4.705645138496205e-30,  2.863616482361224e-16, -5.933396095222670e-17,  6.456482828158317e-18, -4.852149242647373e-19,  2.819446532912680e-20,
 -1.347145781760218e-21,  5.500968245827012e-23, -1.970956560047949e-24,  6.315525079305755e-26, -1.836079196327806e-27,  4.897822900476514e-29, -1.209023752301791e-30,
  3.101943831376593e-17, -7.020842295814014e-18,  8.328436027406996e-19, -6.799530515862619e-20,  4.277827007784553e-21, -2.206190896800050e-22,  9.696371414248156e-24,
 -3.729636971851947e-25,  1.279934425184243e-26, -3.976555039130473e-28,  1.131288445946786e-29, -2.972417299811576e-31,  3.306534743179097e-18, -8.148718997500381e-19,
  1.051324763015123e-19, -9.307110456050489e-21,  6.329692129442382e-22, -3.518577344478824e-23,  1.662393184321973e-24, -6.856726362367013e-26,  2.517497947031091e-27,
 -8.350178322717476e-29,  2.531092530323720e-30, -7.072185569075466e-32,  3.525801610640108e-19, -9.427630307196715e-20,  1.319417977603313e-20, -1.263777959520985e-21,
  9.273249824348138e-23, -5.546746367844820e-24,  2.812727808759722e-25, -1.242248863620685e-26,  4.873072808768521e-28, -1.723368541805155e-29,  5.559064558337862e-31,
 -1.649825161313185e-32,  3.834506405198096e-20, -1.108103660375278e-20,  1.677152790397088e-21, -1.733549912761507e-22,  1.369232682176409e-23, -8.793871742348956e-25,
  4.776772700379252e-26, -2.254803447746595e-27,  9.433714816944763e-29, -3.551229070347016e-30,  1.217064292630806e-31, -3.830541613407114e-33,  4.350479401594881e-21,
 -1.352751689737669e-21,  2.206335093197518e-22, -2.453236790217394e-23,  2.079744789566837e-24, -1.430375018106660e-25,  8.301967224587797e-27, -4.178470680251549e-28,
  1.860318825377231e-29, -7.438057133215879e-31,  2.702677178647143e-32, -9.002539883684809e-34,  5.283702873484971e-22, -1.758958062881087e-22,  3.078435743491060e-23,
 -3.668055614982496e-24,  3.325757120843079e-25, -2.441266509214031e-26,  1.509198789798665e-27, -8.074795561339911e-29,  3.814497897193311e-30, -1.615367327460689e-31,
  6.206275133592378e-33, -2.182145195948527e-34,  7.068513433221293e-23, -2.505013445604557e-23,  4.680776899126150e-24, -5.948900827503454e-25,  5.743422467333177e-26,
 -4.480975382670413e-27,  2.938852208943992e-28, -1.665157488455085e-29,  8.315755922170717e-31, -3.716687117988998e-32,  1.504690789103196e-33, -5.565824724868540e-35,
  1.073660713572805e-23, -4.024520630741199e-24,  7.981108817199844e-25, -1.075846311379554e-25,  1.100113589394312e-26, -9.075932137078169e-28,  6.283959279450674e-29,
 -3.752707526430950e-30,  1.972165168532772e-31, -9.261750170146236e-33,  3.934132125536354e-34, -1.524567874712074e-35,  1.907503792732257e-24, -7.508129355025737e-25,
  1.569208308143963e-25, -2.228534295276855e-26,  2.398052658101229e-27, -2.079065578092686e-28,  1.510591136912381e-29, -9.453217327430951e-31,  5.198749388154467e-32,
 -2.551453303856424e-33,  1.131152643485773e-34, -4.568925438158231e-36,  4.062406889362593e-25, -1.665627339870929e-25,  3.639245030574624e-26, -5.402344943098767e-27,
  6.071059237858949e-28, -5.490718327885212e-29,  4.156692556207699e-30, -2.707095676938255e-31,  1.547525579667342e-32, -7.885827683764359e-34,  3.625959048072093e-35,
 -1.517248518799811e-36,  1.046802719046560e-25, -4.431737189440062e-26,  1.003021371541600e-26, -1.542386248930386e-27,  1.794323684232835e-28, -1.678476914770319e-29,
  1.313048066065414e-30, -8.828249535648565e-32,  5.205275861010177e-33, -2.733342635330109e-34,  1.293980618996556e-35, -5.569499742650628e-37,  3.152580636714944e-26,
 -1.365216036852217e-26,  3.168394824595249e-27, -4.996425757491250e-28,  5.958170654851248e-29, -5.709683517054028e-30,  4.572749110287586e-31, -3.145441378836993e-32,
  1.896152965728675e-33, -1.017336116365259e-34,  4.917727447608069e-36, -2.159873284307728e-37,  8.854815124184607e-27, -3.883713291528043e-27,  9.142398603463224e-28,
 -1.462468628753624e-28,  1.768653687838758e-29, -1.718299898681089e-30,  1.394637490006693e-31, -9.718489190489985e-33,  5.932813161782528e-34, -3.222268960844686e-35,
  1.576215642609413e-36, -7.002726824526432e-38,  5.596242821637466e-02, -1.287344063807126e-04,  3.052598838564884e-07, -7.432726164857702e-10,  1.847973916084261e-12,
 -4.670971080922372e-15,  1.192697552003126e-17, -3.073778841373813e-20,  7.927968970775132e-23, -2.062582879750979e-25,  5.305044257880600e-28, -1.394716339892324e-30,
  5.107993476412848e-02, -1.371599118353884e-04,  4.391777489191640e-07, -1.495117899046934e-09,  5.116275058216128e-12, -1.728777379511020e-14,  5.745983644001614e-17,
 -1.880957658517962e-19,  6.071250412632897e-22, -1.937288754927553e-24,  6.111522989732162e-27, -1.912185689710729e-29,  4.255535346183303e-02, -1.471045053375311e-04,
  6.527940752239888e-07, -2.874302884362154e-09,  1.212444193477850e-11, -4.928293070113709e-14,  1.945050190058108e-16, -7.493859466928659e-19,  2.828734627078512e-21,
 -1.048982938395585e-23,  3.829023763639180e-26, -1.378145323140734e-28,  3.235945388842883e-02, -1.494672211866849e-04,  8.608737888300928e-07, -4.584657007407145e-09,
  2.285403323864306e-11, -1.086035444462663e-13,  4.970959175487635e-16, -2.205622702517147e-18,  9.530050900641212e-21, -4.023601961685245e-23,  1.664464285727165e-25,
 -6.760806688505975e-28,  2.245855988804065e-02, -1.387397289060164e-04,  9.836995319413137e-07, -6.166756541969301e-09,  3.573679746437060e-11, -1.956225396048262e-13,
  1.023255196908174e-15, -5.153950825189381e-18,  2.513804081996195e-20, -1.192340329135656e-22,  5.518224118859990e-25, -2.498438834350063e-27,  1.422610232426585e-02,
 -1.158075499184877e-04,  9.797143393360761e-07, -7.137330651952655e-09,  4.755973267494105e-11, -2.965711349848563e-13,  1.753773231412334e-15, -9.925180760303551e-18,
  5.411451596450952e-20, -2.856739369337953e-22,  1.465894540192460e-24, -7.334063029692745e-27,  8.224388453872029e-03, -8.650113778013591e-05,  8.578951552180957e-07,
 -7.201663337352534e-09,  5.469456670639742e-11, -3.851834551577303e-13,  2.554264045961345e-15, -1.611799040201782e-17,  9.752166672937344e-20, -5.689942024732446e-22,
  3.215509286385366e-24, -1.766197789769500e-26,  4.339388798858132e-03, -5.780555504202569e-05,  6.651104241643074e-07, -6.389462821338647e-09,  5.490825063421307e-11,
 -4.337622409251326e-13,  3.205231002856939e-15, -2.241764797396440e-17,  1.496657569546508e-19, -9.598613021189302e-22,  5.942634522625755e-24, -3.565430896839972e-26,
  2.089588287231680e-03, -3.461479950927329e-05,  4.588842032431536e-07, -5.014746561166365e-09,  4.847398427378398e-11, -4.272226146103349e-13,  3.500010709428894e-15,
 -2.700241603424105e-17,  1.980123999856535e-19, -1.389810457698775e-21,  9.386943752258855e-24, -6.126776895198037e-26,  9.183543623337412e-04, -1.861242903086465e-05,
  2.828241351515247e-07, -3.497549452702144e-09,  3.784309044951869e-11, -3.704501629665481e-13,  3.350785669619834e-15, -2.840375874712912e-17,  2.279281935016677e-19,
 -1.744544101383734e-21,  1.281005833026015e-23, -9.065400787517687e-26,  3.683854916610973e-04, -9.005482283453883e-06,  1.561765726288736e-07, -2.175608377725350e-09,
  2.624174047194369e-11, -2.842629566084630e-13,  2.829012739650337e-15, -2.626282511622114e-17,  2.299042804370181e-19, -1.913199984060069e-21,  1.522958306406936e-23,
 -1.165338933989296e-25,  1.348911988707771e-04, -3.928482906937292e-06,  7.745437345824219e-08, -1.210596544940544e-09,  1.622174952955517e-11, -1.938412177121013e-13,
  2.116372046671064e-15, -2.145776214673902e-17,  2.043817204029387e-19, -1.844603317455134e-21,  1.587995549555987e-23, -1.310803895142759e-25,  4.509495834601774e-05,
 -1.547865910508653e-06,  3.457013132521755e-08, -6.041332166170154e-10,  8.966603766477814e-12, -1.178781816252368e-13,  1.408429835752385e-15, -1.555984215327551e-17,
  1.609012646975160e-19, -1.571650087842327e-21,  1.460309231690561e-23, -1.297812442647268e-25,  1.376724537177229e-05, -5.517549841887400e-07,  1.391180515922929e-08,
 -2.709979816484329e-10,  4.443659398202985e-12, -6.412136927169903e-14,  8.366464334920393e-16, -1.005152264710327e-17,  1.126347755968450e-19, -1.188590493759778e-21,
  1.189935318407204e-23, -1.136723278552098e-25,  3.839723451272328e-06, -1.782117776252654e-07,  5.056445269205852e-09, -1.094974331418655e-10,  1.979163106937469e-12,
 -3.128494680200470e-14,  4.449632254981867e-16, -5.803662716034788e-18,  7.036235776145235e-20, -8.009562864222819e-22,  8.627306565219342e-24, -8.846404277497898e-26,
  9.788285262294574e-07, -5.223490648225328e-08,  1.662728320124391e-09, -3.993083630780943e-11,  7.940178918473037e-13, -1.372540691186892e-14,  2.124641956489263e-16,
 -3.004184762204178e-18,  3.935288793557406e-20, -4.826127149795088e-22,  5.586121156399404e-24, -6.141177946530187e-26,  2.282252715212178e-07, -1.391516614573433e-08,
  4.955169107145315e-10, -1.316841634678840e-11,  2.875680206318620e-13, -5.427785904599133e-15,  9.132109416822113e-17, -1.398106829230031e-18,  1.976534139065172e-20,
 -2.608619076590469e-22,  3.241307433678367e-24, -3.816642187175659e-26,  4.871515198328428e-08, -3.374652880981892e-09,  1.340741363572692e-10, -3.935124362777990e-12,
  9.422725854808186e-14, -1.939431853117666e-15,  3.542477058476420e-17, -5.866081760360878e-19,  8.941369043885617e-21, -1.268815881343891e-22,  1.690948707858340e-24,
 -2.130841226799189e-26,  9.530597125648680e-09, -7.463900200997105e-10,  3.300201650556475e-11, -1.067875667626893e-12,  2.799938391338476e-14, -6.277136217513752e-16,
  1.243492413425005e-17, -2.225186207639461e-19,  3.653905328013698e-21, -5.570671488974130e-23,  7.956968338871678e-25, -1.072326856348703e-26,  1.711563170879835e-09,
 -1.508653805369315e-10,  7.406440728790996e-12, -2.637861144073390e-13,  7.563975938699440e-15, -1.845175416415465e-16,  3.960880733770924e-18, -7.653579080644174e-20,
  1.352973535716762e-21, -2.214710468702011e-23,  3.388474122236670e-25, -4.880827596539687e-27,  2.827009412078314e-10, -2.793442700343988e-11,  1.519358806351628e-12,
 -5.947269800631253e-14,  1.862942303214735e-15, -4.940502511239299e-17,  1.148339554506564e-18, -2.394463172780023e-20,  4.554202861942521e-22, -7.999907277992603e-24,
  1.310396855178432e-25, -2.016490104513925e-27,  4.305209689853247e-11, -4.751716384607541e-12,  2.857519383582290e-13, -1.227615233925123e-14,  4.196466757592880e-16,
 -1.208900521843927e-17,  3.040516974942768e-19, -6.837618609991524e-21,  1.398532470483216e-22, -2.635087446087771e-24,  4.619167205081092e-26, -7.590852831401060e-28,
  6.063787625784831e-12, -7.450843515904098e-13,  4.944625640057281e-14, -2.328422921367706e-15,  8.677864790260829e-17, -2.713545899065331e-18,  7.380655427168448e-20,
 -1.789190374926411e-21,  3.933698852627579e-23, -7.947073856886698e-25,  1.490304019654171e-26, -2.614521983591615e-28,  7.929908526682345e-13, -1.081439991363790e-13,
  7.905588612933828e-15, -4.075547951659992e-16,  1.654548544050205e-17, -5.612096569098841e-19,  1.649861805326237e-20, -4.309412575363075e-22,  1.018058349624637e-23,
 -2.204527967020527e-25,  4.421293515948512e-27, -8.278133693747545e-29,  9.675591600201976e-14, -1.460261711986208e-14,  1.173846649933291e-15, -6.617151443642082e-17,
  2.923692281301124e-18, -1.075009273783811e-19,  3.414068689472303e-21, -9.604290149367644e-23,  2.437091731239065e-24, -5.654750203617451e-26,  1.212519880059760e-27,
 -2.422259770604371e-29,  1.108137723619927e-14, -1.845706552590075e-15,  1.628742027037864e-16, -1.002783079843107e-17,  4.817892246098191e-19, -1.919032619648499e-20,
  6.580345731972709e-22, -1.992845580798361e-23,  5.429628956683068e-25, -1.349485322716863e-26,  3.092837039514416e-28, -6.590473585962646e-30,  1.200216940261726e-15,
 -2.200201801483513e-16,  2.127734044431686e-17, -1.429023737113708e-18,  7.459034326635049e-20, -3.216193678258296e-21,  1.190044441977594e-22, -3.878013940846551e-24,
  1.134002571422828e-25, -3.017916429694457e-27,  7.390306665949645e-29, -1.679229494615298e-30,  1.240707630449971e-16, -2.496396911340829e-17,  2.640965966886369e-18,
 -1.932363809779991e-19,  1.094685432067356e-20, -5.105431539851212e-22,  2.037118027679525e-23, -7.138934936911914e-25,  2.239369918193910e-26, -6.378447986408038e-28,
  1.668217031353550e-29, -4.040283443938349e-31,  1.237990571883853e-17, -2.726245309268058e-18,  3.149070089274721e-19, -2.506610549903974e-20,  1.539373118391121e-21,
 -7.758082120810102e-23,  3.335371436834742e-24, -1.256083888942874e-25,  4.223923759906403e-27, -1.286889208100715e-28,  3.592669191395630e-30, -9.269433903199977e-32,
  1.208831945445862e-18, -2.904653962294446e-19,  3.655646983452291e-20, -3.160290200825012e-21,  2.101083394067091e-22, -1.142900597409787e-23,  5.288742983266165e-25,
 -2.138339857628411e-26,  7.702023595757398e-28, -2.507934307531463e-29,  7.467915445873105e-31, -2.051120205469096e-32,  1.174421237011029e-19, -3.068901851031173e-20,
  4.198153886885080e-21, -3.933907502478033e-22,  2.826614892706499e-23, -1.657062592588952e-24,  8.242371313554641e-26, -3.573455839034801e-27,  1.377035642692880e-28,
 -4.787051941533933e-30,  1.518815684525343e-31, -4.436209540051571e-33,  1.158028948302952e-20, -3.278565913156080e-21,  4.861130204841364e-22, -4.925694920205188e-23,
  3.816975917910282e-24, -2.406962407954780e-25,  1.284659105379721e-26, -5.962422216717955e-28,  2.454337795827088e-29, -9.095498024482761e-31,  3.070433123499500e-32,
 -9.524038975074677e-34,  1.186422895747772e-21, -3.623755446375144e-22,  5.803962881338028e-23, -6.340732864241031e-24,  5.284978956414653e-25, -3.576047091097136e-26,
  2.043285894351529e-27, -1.013024037247801e-28,  4.445166674066866e-30, -1.752620072266445e-31,  6.282981309194898e-33, -2.065820198079354e-34,  1.297729691965032e-22,
 -4.255311733869822e-23,  7.332319230692034e-24, -8.605047516107181e-25,  7.688554289845962e-26, -5.564729794162893e-27,  3.393762165778314e-28, -1.792227883067385e-29,
  8.360550442365926e-31, -3.497858213692863e-32,  1.328257026478394e-33, -4.617857900967902e-35,  1.562608218151365e-23, -5.469818153193237e-24,  1.008991476964440e-24,
 -1.266277638051577e-25,  1.207714327579581e-26, -9.312311035265211e-28,  6.038679357543277e-29, -3.384385453568772e-30,  1.672473337818136e-31, -7.399639810881081e-33,
  2.966571313455202e-34, -1.087041798228231e-35,  2.140926880318227e-24, -7.948449698214224e-25,  1.560353420350241e-25, -2.082442895621863e-26,  2.108894619727406e-27,
 -1.723645564293963e-28,  1.182700715824291e-29, -7.001844001869829e-31,  3.648993655510211e-32, -1.699866671481192e-33,  7.164510657929732e-35, -2.755658150370703e-36,
  3.450540922148000e-25, -1.348700869142159e-25,  2.797735720204062e-26, -3.943904242458637e-27,  4.213441647335111e-28, -3.627613951908535e-29,  2.618061367953820e-30,
 -1.627781312196654e-31,  8.896085007336307e-33, -4.339777040607472e-34,  1.912814153018013e-35, -7.683006489949910e-37,  6.732755418484483e-26, -2.747651236918661e-26,
  5.973037248630027e-27, -8.822331731265178e-28,  9.865954012418853e-29, -8.880644849897519e-30,  6.692271372921261e-31, -4.339188222920461e-32,  2.469954979683378e-33,
 -1.253457176967694e-34,  5.740613235000208e-36, -2.392925389915096e-37,  1.612696315064452e-26, -6.808910529373893e-27,  1.536431687232922e-27, -2.355593789825199e-28,
  2.732389645423473e-29, -2.548763733578903e-30,  1.988414630464142e-31, -1.333376432433649e-32,  7.841743780452653e-34, -4.107630356004845e-35,  1.939946407975695e-36,
 -8.330679849142471e-38,  4.601118735605863e-27, -1.989916642198603e-27,  4.611553577732878e-28, -7.261747928904445e-29,  8.647308766184571e-30, -8.275283140563959e-31,
  6.618639166750382e-32, -4.546857178688187e-33,  2.737531258914043e-34, -1.466977080374327e-35,  7.082931919043230e-37, -3.107306134290326e-38,  1.252354724133836e-27,
 -5.490228611406889e-28,  1.291735250215807e-28, -2.065226151447857e-29,  2.496285550616556e-30, -2.423958371567235e-31,  1.966378767068273e-32, -1.369586113289415e-33,
  8.356821349572958e-35, -4.536669405963136e-36,  2.218149461250096e-37, -9.850256911706783e-39,  5.545231896066156e-02, -1.263275087468096e-04,  2.965149847059100e-07,
 -7.144371239778692e-10,  1.757348708274590e-12, -4.394771607461266e-15,  1.110074699359445e-17, -2.831566476025589e-20,  7.222200381224356e-23, -1.862175862128130e-25,
  4.726746599359061e-28, -1.237600759000949e-30,  5.053821026241680e-02, -1.337168896757225e-04,  4.217163245163992e-07, -1.415950366279581e-09,  4.783894420370077e-12,
 -1.596980532871528e-14,  5.245498949449721e-17, -1.697380589000762e-19,  5.415875469235333e-22, -1.708851460107292e-24,  5.329463280464962e-27, -1.649534751448894e-29,
  4.197716625772344e-02, -1.420168947228772e-04,  6.194346628327472e-07, -2.687950402268335e-09,  1.118381633824536e-11, -4.485671387017469e-14,  1.747347554318501e-16,
 -6.646244393054212e-19,  2.477269062405764e-21, -9.072886265044288e-24,  3.271335989812215e-26, -1.163231407375556e-28,  3.177501911385890e-02, -1.427942390831365e-04,
  8.079822574092442e-07, -4.235741223865564e-09,  2.079643559846584e-11, -9.738116485921574e-14,  4.393990224300960e-16, -1.922608035375781e-18,  8.194559886389784e-21,
 -3.413684371698511e-23,  1.393661603855168e-25, -5.587730263421065e-28,  2.191888483296399e-02, -1.311567054699586e-04,  9.130042671124117e-07, -5.624980543670289e-09,
  3.205869224619738e-11, -1.727090622504634e-13,  8.895902929420128e-16, -4.414158257558706e-18,  2.121779727237870e-20, -9.921164986912987e-23,  4.527648022648691e-25,
 -2.021867792594063e-27,  1.377802280366135e-02, -1.082999272131801e-04,  8.984435268816399e-07, -6.421630475549358e-09,  4.202767763304903e-11, -2.576288732235355e-13,
  1.498642576488057e-15, -8.347349866213682e-18,  4.481231616518902e-20, -2.330157361408670e-22,  1.178110211973000e-24, -5.809195011092400e-27,  7.891583155987271e-03,
 -7.996934403241641e-05,  7.764820372041558e-07, -6.384996195425466e-09,  4.756911065513257e-11, -3.289622002147066e-13,  2.143739179591477e-15, -1.330165772473229e-17,
  7.917727183664686e-20, -4.546673282475864e-22,  2.529763108767020e-24, -1.368521984414446e-26,  4.118342994770736e-03, -5.277706400522793e-05,  5.934347576358829e-07,
 -5.576357221243604e-09,  4.695408523214208e-11, -3.638581966707452e-13,  2.639702485901101e-15, -1.813824806980422e-17,  1.190365802743745e-19, -7.508004235698295e-22,
  4.573309636733802e-24, -2.700568443122268e-26,  1.958107909419623e-03, -3.117186974673009e-05,  4.030928914998537e-07, -4.303199165882771e-09,  4.071180637998837e-11,
 -3.516229210813662e-13,  2.825618614471589e-15, -2.139904528972700e-17,  1.541349261964272e-19, -1.063185252233014e-21,  7.060234822653112e-24, -4.532541926198437e-26,
  8.481778421703966e-04, -1.650796098390310e-05,  2.442554303155351e-07, -2.947218892690225e-09,  3.117788157659241e-11, -2.988054602606855e-13,  2.648813108799894e-15,
 -2.202332749895639e-17,  1.734610608502930e-19, -1.303863326976410e-21,  9.407255977178036e-24, -6.544109506617575e-26,  3.347065773648703e-04, -7.853770446694679e-06,
  1.324121665371827e-07, -1.797769411697926e-09,  2.117992124754549e-11, -2.244192989717418e-13,  2.187080045998983e-15, -1.989966511210012e-17,  1.708614459610878e-19,
 -1.395468233743081e-21,  1.090796412308290e-23, -8.199929058191466e-26,  1.203303939855261e-04, -3.362821909085466e-06,  6.436497944204279e-08, -9.794951246711825e-10,
  1.280776247841918e-11, -1.495762921814166e-13,  1.597947496233364e-15, -1.586790326074827e-17,  1.481433757903041e-19, -1.311407114716654e-21,  1.107972194326149e-23,
 -8.980154975149645e-26,  3.941392381077365e-05, -1.298032275816305e-06,  2.810909536570555e-08, -4.778297670460498e-10,  6.914572483351889e-12, -8.877066258723187e-14,
  1.037075634446243e-15, -1.121383410336633e-17,  1.135908192987209e-19, -1.087631978050572e-21,  9.912430132363926e-24, -8.645550943746784e-26,  1.176380471984875e-05,
 -4.523505940707223e-07,  1.104738970838357e-08, -2.091567022510030e-10,  3.341178670996357e-12, -4.704835903900324e-14,  5.998338465326468e-16, -7.048943212647293e-18,
  7.732996313937397e-20, -7.994937508964482e-22,  7.846856995404793e-24, -7.353039087733004e-26,  3.200159398766926e-06, -1.425218001190047e-07,  3.913566543834734e-09,
 -8.230717548668098e-11,  1.448302611899569e-12, -2.232586741067838e-14,  3.100823341049899e-16, -3.953753114910105e-18,  4.690284667430109e-20, -5.228280198499193e-22,
  5.518392556798770e-24, -5.548233342354728e-26,  7.937373128983089e-07, -4.065298208192122e-08,  1.251550280385718e-09, -2.917179296042301e-11,  5.643601936414286e-13,
 -9.508005554498780e-15,  1.436445432153534e-16, -1.984538573363762e-18,  2.542441122031324e-20, -3.051884408949088e-22,  3.460059944140738e-24, -3.728243649605599e-26,
  1.795925265047671e-07, -1.051243412392001e-08,  3.618723480515997e-10, -9.328818124379575e-12,  1.980940256376468e-13, -3.642229876195506e-15,  5.977820655629032e-17,
 -8.938044895728577e-19,  1.235268806687089e-20, -1.595102527016200e-22,  1.940614935308976e-24, -2.238866859754901e-26,  3.709530069014241e-08, -2.467989300630822e-09,
  9.475410211935265e-11, -2.696656046353029e-12,  6.276088953103758e-14, -1.257801315413965e-15,  2.240221199333115e-17, -3.621524728439674e-19,  5.394383800131749e-21,
 -7.486986998420437e-23,  9.766524581140863e-25, -1.205475172805523e-26,  7.001525525599702e-09, -5.268744917060631e-10,  2.250841979728118e-11, -7.060069749811862e-13,
  1.798597386824013e-14, -3.924834701724694e-16,  7.578836712856887e-18, -1.323564979314642e-19,  2.123238036976981e-21, -3.165162862939795e-23,  4.424072890632536e-25,
 -5.838390091926410e-27,  1.209129999272750e-09, -1.024683869094841e-10,  4.860300384621267e-12, -1.677695117516399e-13,  4.673121369182891e-15, -1.109327046273829e-16,
  2.320618450170205e-18, -4.375120763296449e-20,  7.553995809925776e-22, -1.208808298222501e-23,  1.809437415223246e-25, -2.551786425792240e-27,  1.913804169168389e-10,
 -1.819391488422955e-11,  9.562138554765383e-13, -3.627439958821620e-14,  1.103637627418618e-15, -2.847729394083855e-17,  6.449396566133566e-19, -1.311903399422867e-20,
  2.436701606518695e-22, -4.183758345454049e-24,  6.703893813301541e-26, -1.009907311251297e-27,  2.782408337016985e-11, -2.956901426856992e-12,  1.718715846046227e-13,
 -7.156567863194943e-15,  2.376145868298711e-16, -6.659850767699962e-18,  1.631992937731853e-19, -3.580085781331272e-21,  7.150400314842963e-23, -1.316799110775322e-24,
  2.257922699204279e-26, -3.632283401475960e-28,  3.726210913263138e-12, -4.412493434458610e-13,  2.831570524008996e-14, -1.292664305596434e-15,  4.679973457123382e-17,
 -1.423932365364495e-18,  3.773712257925434e-20, -8.924144894210466e-22,  1.916003560157992e-23, -3.783421813056290e-25,  6.940489657760124e-27, -1.191985101985318e-28,
  4.613130084281828e-13, -6.069278196094498e-14,  4.292791003296368e-15, -2.146298212190995e-16,  8.466657974805048e-18, -2.794950291649551e-19,  8.007498056221765e-21,
 -2.040669387690474e-22,  4.708429227766016e-24, -9.966948687809183e-26,  1.955661443627200e-27, -3.585096970881876e-29,  5.303680382225240e-14, -7.731279832485340e-15,
  6.017701106662115e-16, -3.291759195028998e-17,  1.413858266318602e-18, -5.061283533516431e-20,  1.566964027276241e-21, -4.302119589114882e-23,  1.066484794413775e-24,
 -2.419640934773135e-26,  5.077294478914601e-28, -9.933344420287739e-30,  5.694996893689649e-15, -9.174126875658858e-16,  7.846153130943758e-17, -4.690984023743736e-18,
  2.192262320299832e-19, -8.505868767978728e-21,  2.844635631397870e-22, -8.411416992676669e-24,  2.239788788413196e-25, -5.445372623660128e-27,  1.221756499045486e-28,
 -2.550553622276286e-30,  5.752428960073089e-16, -1.021436826634190e-16,  9.584150630539363e-18, -6.256392045456442e-19,  3.178961773461825e-20, -1.336126496375416e-21,
  4.824865577343999e-23, -1.536047358720886e-24,  4.392299196034143e-26, -1.144031669339247e-27,  2.743997582306536e-29, -6.111364247483438e-31,  5.514717956945820e-17,
 -1.076613118908055e-17,  1.106540845782683e-18, -7.878152292713417e-20,  4.348780701123904e-21, -1.978777235896764e-22,  7.711713169615120e-24, -2.642239618391033e-25,
  8.110743354178841e-27, -2.262572376600091e-28,  5.799882610727972e-30, -1.377735848535612e-31,  5.073551900800177e-18, -1.086103568011822e-18,  1.220704112024733e-19,
 -9.467191980123814e-21,  5.672005073192064e-22, -2.791935974620071e-23,  1.173557740990553e-24, -4.325099072802520e-26,  1.424563890466478e-27, -4.254370455995102e-29,
  1.165071038830159e-30, -2.950711930541680e-32,  4.540865292721184e-19, -1.062884849767519e-19,  1.303880124651519e-20, -1.099968610434570e-21,  7.144434189333739e-23,
 -3.800652981413936e-24,  1.721639208909195e-25, -6.820014056036215e-27,  2.408683174507193e-28, -7.696215636986831e-30,  2.250311395065808e-31, -6.072954605109437e-33,
  4.020222083715292e-20, -1.025710828333934e-20,  1.370382060741279e-21, -1.255345901427538e-22,  8.826565299614822e-24, -5.068224109113916e-25,  2.471364300297710e-26,
 -1.051205265222139e-27,  3.977216257946299e-29, -1.358419559962382e-30,  4.237196142276984e-32, -1.217474214545659e-33,  3.592801706682124e-21, -9.956253531956663e-22,
  1.444942810200824e-22, -1.434223063505922e-23,  1.089614597328178e-24, -6.741918154437050e-26,  3.533437209791410e-27, -1.611533463716753e-28,  6.523014018445093e-30,
 -2.378528651045012e-31,  7.905006728489916e-33, -2.415408726472627e-34,  3.320515820171927e-22, -9.953639070382034e-23,  1.564244533253987e-23, -1.677782872114572e-24,
  1.373927750852506e-25, -9.140163690595742e-27,  5.138085672596105e-28, -2.507769536181299e-29,  1.083948806867822e-30, -4.212137391268504e-32,  1.489021560296374e-33,
 -4.830261367841904e-35,  3.265356876455231e-23, -1.053786282126733e-23,  1.786318268028986e-24, -2.063279303874165e-25,  1.815458221408075e-26, -1.294724676742615e-27,
  7.784902123183762e-29, -4.055438969691511e-30,  1.867127485703692e-31, -7.713380833860703e-33,  2.893512522418117e-34, -9.942139835033340e-36,  3.529950476662427e-24,
 -1.219595114493154e-24,  2.219358487684883e-25, -2.748511395114987e-26,  2.587949197218871e-27, -1.970955476109845e-28,  1.262962576191056e-29, -6.997628365013627e-31,
  3.420084777030909e-32, -1.497164409561768e-33,  5.941012724689918e-35, -2.155580038415274e-36,  4.348166140927600e-25, -1.597916270477605e-25,  3.103267406948856e-26,
 -4.098043983401852e-27,  4.107800759369047e-28, -3.324377425121360e-29,  2.259445014726347e-30, -1.325427223994214e-31,  6.846660613260820e-33, -3.162436152636378e-34,
  1.321986346406761e-35, -5.044669197210493e-37,  6.332854345560940e-26, -2.456872787483035e-26,  5.055951908378827e-27, -7.071272596265917e-28,  7.496912120356275e-29,
 -6.406977618890044e-30,  4.591058815412518e-31, -2.834926502369141e-32,  1.539094544986402e-33, -7.460327369781141e-35,  3.268031547942275e-36, -1.304872854944348e-37,
  1.127449211631248e-26, -4.578199729448691e-27,  9.898646503599437e-28, -1.454227276081676e-28,  1.617776677504297e-29, -1.448865196262601e-30,  1.086517525543858e-31,
 -7.011746887230866e-33,  3.973141196241254e-34, -2.007482096146654e-35,  9.155136942855238e-37, -3.800746577262824e-38,  2.500456246866603e-27, -1.052623575823249e-27,
  2.367635593936893e-28, -3.618383793524877e-29,  4.184110720348437e-30, -3.891148885068143e-31,  3.026818382299510e-32, -2.023981850046076e-33,  1.187088758213900e-34,
 -6.201824949622309e-36,  2.921560372207605e-37, -1.251535733185600e-38,  6.736544767438677e-28, -2.909408548318523e-28,  6.732056921878128e-29, -1.058454629810966e-29,
  1.258509587142537e-30, -1.202599516444225e-31,  9.604811091929482e-33, -6.589203142802749e-34,  3.961879944896667e-35, -2.120336744068196e-36,  1.022473099699468e-37,
 -4.480216837432529e-39,  1.773307467772231e-28, -7.770178136924137e-29,  1.827138195494628e-29, -2.919580803812967e-30,  3.526997654964533e-31, -3.422936319853258e-32,
  2.775293544596618e-33, -1.931989209941287e-34,  1.178244962776710e-35, -6.393168638192859e-37,  3.124350112994623e-38, -1.386794366138871e-39,  5.495169953433983e-02,
 -1.239892104395914e-04,  2.881075903090572e-07, -6.870084976733123e-10,  1.672054559342001e-12, -4.137612654679192e-15,  1.033928143991769e-17, -2.610827692105803e-20,
  6.584575329704898e-23, -1.683582014085362e-25,  4.212851911365398e-28, -1.101553595241122e-30,  5.000998435824048e-02, -1.304098473154777e-04,  4.051738511517890e-07,
 -1.341896404486556e-09,  4.476712430576484e-12, -1.476601459470912e-14,  4.793599207814320e-17, -1.533517905046188e-19,  4.837374791601704e-22, -1.509503394012831e-24,
  4.654255933565257e-27, -1.425423638790940e-29,  4.141880955572654e-02, -1.371874637741038e-04,  5.882240201139408e-07, -2.515964730796326e-09,  1.032715608053208e-11,
 -4.087772875949198e-14,  1.571877294213392e-16, -5.903349411184612e-19,  2.173015934658139e-21, -7.861200510477630e-24,  2.800153074984991e-26, -9.838160753166952e-29,
  3.121645575257229e-02, -1.365281843576617e-04,  7.590873562344349e-07, -3.918024048639398e-09,  1.895005604930772e-11, -8.745305131129770e-14,  3.890598127341832e-16,
 -1.679015324173351e-18,  7.060324118113705e-21, -2.902430424128008e-23,  1.169583489597486e-25, -4.629362783624180e-28,  2.140845055451132e-02, -1.241142056191979e-04,
  8.484717931042834e-07, -5.138555575461312e-09,  2.880838431607145e-11, -1.527685082236013e-13,  7.749864493587568e-16, -3.789006115460011e-18,  1.795181739308436e-20,
 -8.276197028872815e-23,  3.724919192981295e-25, -1.640854030329300e-27,  1.335872578518871e-02, -1.014095650150487e-04,  8.252547031140659e-07, -5.788530670844826e-09,
  3.721664830402272e-11, -2.243115574317718e-13,  1.283793676324212e-15, -7.038955056891728e-18,  3.721381724318081e-20, -1.906311126390266e-22,  9.497988478683938e-25,
 -4.616531710138944e-27,  7.583661862175827e-03, -7.405151122327317e-05,  7.042203235718752e-07, -5.673850608969437e-09,  4.147561383219217e-11, -2.817099657808553e-13,
  1.804436226053160e-15, -1.101146313500726e-17,  6.449435789577214e-20, -3.645654370781533e-22,  1.997456185053094e-24, -1.064389078850234e-26,  3.916323220081887e-03,
 -4.828501110738557e-05,  5.307966130128708e-07, -4.880032236921634e-09,  4.027143534283327e-11, -3.061931196634256e-13,  2.181335466244673e-15, -1.472843203031938e-17,
  9.503299697500233e-20, -5.895940703957092e-22,  3.534015120713338e-24, -2.054260228627224e-26,  1.839557831209909e-03, -2.814311806375325e-05,  3.551421657624188e-07,
 -3.704579450534418e-09,  3.431170058774955e-11, -2.904743111371966e-13,  2.290110955397916e-15, -1.702829201548362e-17,  1.204970855347694e-19, -8.169722857708862e-22,
  5.334995999801815e-24, -3.369331329252412e-26,  7.858414970357082e-04, -1.468733640492726e-05,  2.116953103492310e-07, -2.492926517222822e-09,  2.579060522898976e-11,
 -2.420474566111619e-13,  2.103300880472890e-15, -1.715625531921897e-17,  1.326542177019427e-19, -9.794362230568174e-22,  6.944553071633678e-24, -4.749589382934221e-26,
  3.052811653660234e-04, -6.875328593342865e-06,  1.127328354133167e-07, -1.492124702679026e-09,  1.717430854624733e-11, -1.780414044234522e-13,  1.699444918249226e-15,
 -1.515826326232766e-17,  1.276799774289568e-19, -1.023622291070206e-21,  7.858409404046766e-24, -5.804638015237130e-26,  1.078391390039507e-04, -2.891648658983247e-06,
  5.374822180447074e-08, -7.965613631366708e-10,  1.016634957089021e-11, -1.160622268596776e-13,  1.213484914360191e-15, -1.180432419541509e-17,  1.080412800816714e-19,
 -9.382453314882516e-22,  7.780838017644305e-24, -6.193245945798644e-26,  3.463771292585029e-05, -1.094341224824779e-06,  2.298445422510762e-08, -3.801473704943527e-10,
  5.364603069282802e-12, -6.727156784004290e-14,  7.685960161177835e-16, -8.135749804030461e-18,  8.074200955504903e-20, -7.579752095900088e-22,  6.776936507768056e-24,
 -5.801754052717017e-26,  1.011645941543698e-05, -3.731689430771590e-07,  8.829572265758850e-09, -1.625057932843592e-10,  2.529524310454948e-12, -3.476574204002320e-14,
  4.331782069065953e-16, -4.980125374122153e-18,  5.349597061908648e-20, -5.419588565844314e-22,  5.215594762141463e-24, -4.794893989488016e-26,  2.686948420062851e-06,
 -1.148015573901848e-07,  3.051396246786216e-09, -6.233692219198201e-11,  1.068045820948760e-12, -1.605873039324821e-14,  2.178383190444316e-16, -2.715767619051274e-18,
  3.152839862118930e-20, -3.442056308197471e-22,  3.560584619563256e-24, -3.510536401507726e-26,  6.491322191689779e-07, -3.190064264436891e-08,  9.499509082477638e-10,
 -2.149335828957293e-11,  4.046091301260066e-13, -6.644677446657391e-15,  9.798925501218194e-17, -1.322945298252312e-18,  1.657813446230609e-20, -1.948077910357952e-22,
  2.163623724142964e-24, -2.285257271020553e-26,  1.426931165475289e-07, -8.016425984869039e-09,  2.667707349773238e-10, -6.671888162100349e-12,  1.377791877747955e-13,
 -2.468018368091199e-15,  3.951901072712414e-17, -5.771517347583784e-19,  7.798590492422933e-21, -9.854038103100821e-23,  1.173962783391315e-24, -1.327140237288408e-26,
  2.855626259119371e-08, -1.824062873116861e-09,  6.767511290079891e-11, -1.867643732278582e-12,  4.225117916710783e-14, -8.245699180115436e-16,  1.432171676922411e-17,
 -2.260463877956903e-19,  3.290668042623916e-21, -4.467456236134245e-23,  5.704705305866120e-25, -6.897409709064100e-27,  5.206699693143977e-09, -3.763413883316105e-10,
  1.553282598262204e-11, -4.722802260238400e-13,  1.169065970086098e-14, -2.483276854529863e-16,  4.674484103672035e-18, -7.967554031977280e-20,  1.248734809216775e-21,
 -1.820302252223680e-23,  2.489910486171625e-25, -3.217899449923806e-27,  8.658654068921834e-10, -7.051867358209850e-11,  3.231242523095954e-12, -1.080947833663950e-13,
  2.924764363300339e-15, -6.756384892849427e-17,  1.377398713120856e-18, -2.533805715156922e-20,  4.273041238855792e-22, -6.684767513505278e-24,  9.790089715822742e-26,
 -1.351803382912232e-27,  1.315202497855630e-10, -1.202356869928309e-11,  6.104928393147807e-13, -2.244222056329406e-14,  6.631474969385191e-16, -1.664823899950152e-17,
  3.673687960406319e-19, -7.289984078142463e-21,  1.322276877668947e-22, -2.219109368374885e-24,  3.478427191952585e-26, -5.129788686295184e-28,  1.828197726971890e-11,
 -1.869705282236374e-12,  1.050145843851665e-13, -4.237434750314110e-15,  1.366365920017186e-16, -3.725684051072874e-18,  8.894642003752828e-20, -1.903262822511899e-21,
  3.711812531189576e-23, -6.680752606180664e-25,  1.120523177005196e-26, -1.764497466507242e-28,  2.331496606179353e-12, -2.659243527908863e-13,  1.649558419489123e-14,
 -7.298820305788812e-16,  2.566489593787990e-17, -7.597064436285689e-19,  1.961535077045789e-20, -4.524665258906004e-22,  9.485551903895917e-24, -1.830619883900411e-25,
  3.284796959051227e-27, -5.522317855972438e-29,  2.736807797780229e-13, -3.471528108155384e-14,  2.374735446267178e-15, -1.151148335222582e-16,  4.411400345101264e-18,
 -1.416992797259017e-19,  3.955629086673827e-21, -9.833998844726911e-23,  2.215756897884295e-24, -4.584541668000394e-26,  8.799803770662404e-28, -1.579263994842464e-29,
  2.969430396704151e-14, -4.178033690007497e-15,  3.147317327086604e-16, -1.669985530832116e-17,  6.970654645138725e-19, -2.428778036109291e-20,  7.328641399715843e-22,
 -1.963298806001869e-23,  4.753798843303289e-25, -1.054421395235602e-26,  2.164854036646529e-28, -4.147185556176365e-30,  2.993966079093331e-15, -4.661226108863963e-16,
  3.861495351714979e-17, -2.240895438724289e-18,  1.018274094837962e-19, -3.847233101128771e-21,  1.254498018019696e-22, -3.620873981410484e-24,  9.420737395680951e-26,
 -2.239892349039172e-27,  4.918777725240840e-29, -1.005787973266590e-30,  2.824340659272839e-16, -4.853901856915684e-17,  4.416234379730467e-18, -2.800571751837252e-19,
  1.384625472711766e-20, -5.670548229118311e-22,  1.997668696508873e-23, -6.211161913246429e-25,  1.736239629411650e-26, -4.424699477867041e-28,  1.039205931307158e-29,
 -2.268036672878773e-31,  2.514257779223266e-17, -4.758527402471527e-18,  4.748351781459342e-19, -3.287586856623244e-20,  1.767419618343359e-21, -7.842496599369296e-23,
  2.983972675842720e-24, -9.991952543559276e-26,  3.000379185389877e-27, -8.194475113150619e-29,  2.058142087624870e-30, -4.793738352264267e-32,  2.135028017906786e-18,
 -4.439043320277928e-19,  4.850972962905850e-20, -3.663236526331927e-21,  2.139870193533292e-22, -1.028219921436775e-23,  4.223608081126215e-25, -1.522637300368363e-26,
  4.910062890924600e-28, -1.436796436208930e-29,  3.858234922067830e-31, -9.588357639572793e-33,  1.752825115613126e-19, -3.993059763821731e-20,  4.770850059426136e-21,
 -3.924760470609704e-22,  2.488831195146660e-23, -1.294068381809110e-24,  5.735162693365623e-26, -2.224783426775677e-27,  7.700899205462957e-29, -2.413400177255289e-30,
  6.926130190629632e-32, -1.835844457758901e-33,  1.414667007091790e-20, -3.520766272298266e-21,  4.590247065161322e-22, -4.107611190479105e-23,  2.824270957151918e-24,
 -1.587403540305839e-25,  7.583673977282896e-27, -3.163037319801671e-28,  1.174366997705859e-29, -3.938900736595450e-31,  1.207320216822498e-32, -3.411003390852531e-34,
  1.145629166761901e-21, -3.104542661877770e-22,  4.406420436720400e-23, -4.281057646857873e-24,  3.186400433594777e-25, -1.933221912894739e-26,  9.943041766107143e-28,
 -4.453612691577169e-29,  1.771645034826534e-30, -6.352940867154635e-32,  2.077640168731721e-33, -6.250522599741345e-35,  9.543377025086275e-23, -2.805041512760562e-23,
  4.321680274200231e-24, -4.547371746676377e-25,  3.655918209357743e-26, -2.389572367297128e-27,  1.320717707382981e-28, -6.342030476374781e-30,  2.698686168486835e-31,
 -1.033005140203633e-32,  3.599107217773235e-34, -1.151306146872943e-35,  8.423799562447315e-24, -2.673206437585618e-24,  4.454328865310543e-25, -5.059855055492992e-26,
  4.381196707661232e-27, -3.076687805101331e-28,  1.822726519901266e-29, -9.360899873499363e-31,  4.251084861855820e-32, -1.733155661536045e-33,  6.419381904046711e-35,
 -2.178854705836617e-36,  8.155610272057016e-25, -2.779030087795515e-25,  4.985135737713312e-26, -6.087903161843085e-27,  5.655329440029653e-28, -4.251396513541841e-29,
  2.690380530064154e-30, -1.472818032260369e-31,  7.115513059689621e-33, -3.080318918664569e-34,  1.209258767083066e-35, -4.342407694922568e-37,  9.002500148670887e-26,
 -3.272611119879287e-26,  6.283493209447816e-27, -8.205313100000697e-28,  8.136201373993613e-29, -6.516078681992318e-30,  4.384401615711643e-31, -2.547183866827609e-32,
  1.303572704889229e-33, -5.967315339376336e-35,  2.473012547055838e-36, -9.358715744989867e-38,  1.180201665987675e-26, -4.542249586954705e-27,  9.268135970419257e-28,
 -1.285410713628054e-28,  1.351732594845674e-29, -1.146167427022640e-30,  8.151132272750682e-32, -4.996638774098883e-33,  2.693697914156534e-34, -1.296881523576856e-35,
  5.644088405624997e-37, -2.239487712573750e-38,  1.908892222861181e-27, -7.709932235947573e-28,  1.657349803668346e-28, -2.420909183904215e-29,  2.678190339744441e-30,
 -2.385655888638536e-31,  1.779737576996294e-32, -1.142789299283079e-33,  6.444265468937001e-35, -3.240905480799200e-36,  1.471388630371264e-37, -6.082099578427967e-39,
  3.903515660073412e-28, -1.638112076029160e-28,  3.671893348812725e-29, -5.592461791955751e-30,  6.445285039191955e-31, -5.974655143286453e-32,  4.633027203413517e-33,
 -3.088700492899012e-34,  1.806296750922564e-35, -9.410367877709225e-37,  4.421054919021969e-38, -1.888958035147822e-39,  9.896528126602350e-29, -4.267784657050765e-29,
  9.858901006064500e-30, -1.547520596693235e-30,  1.837044529724858e-31, -1.752681746196900e-32,  1.397690277081463e-33, -9.574506322193670e-35,  5.748666199668404e-36,
 -3.072367833191658e-37,  1.479593632927728e-38, -6.474887601128856e-40,  2.514074036015184e-29, -1.101022874090828e-29,  2.587499613471901e-30, -4.132098446994039e-31,
  4.988844666777499e-32, -4.838864425444660e-33,  3.921111385319622e-34, -2.728139327998775e-35,  1.662895674612930e-36, -9.018182086446400e-38,  4.404957111884853e-39,
 -1.954246738503421e-40,  5.446030083526662e-02, -1.217168775289609e-04,  2.800213177544762e-07, -6.609044046633236e-10,  1.591725727398638e-12, -3.898009669219013e-15,
  9.636860078150471e-18, -2.409502745321102e-20,  6.007683092556722e-23, -1.524403477374276e-25,  3.754614575088458e-28, -9.842758797386458e-31,  4.949472745643962e-02,
 -1.272316719132485e-04,  3.894913116886757e-07, -1.272570488468509e-09,  4.192557806513259e-12, -1.366537674894487e-14,  4.385093614208702e-17, -1.387069255715090e-19,
  4.326006402867395e-22, -1.335291361093169e-24,  4.070288001887204e-27, -1.233917819783862e-29,  4.087928395698552e-02, -1.325996897636087e-04,  5.589975199654644e-07,
 -2.357071179205701e-09,  9.546027207909958e-12, -3.729597213875502e-14,  1.415908109356337e-16, -5.251184981170442e-19,  1.909172927055373e-21, -6.823103025133226e-24,
  2.401260501360199e-26, -8.337203440372597e-29,  3.068219774863677e-02, -1.306385259569323e-04,  7.138341548110771e-07, -3.628323843028972e-09,  1.729068933223340e-11,
 -7.865516896473088e-14,  3.450595432237902e-16, -1.468938401975128e-18,  6.094972983034758e-21, -2.472911426633231e-23,  9.837246457492524e-26, -3.844427357422848e-28,
  2.092518951482976e-02, -1.175654718783589e-04,  7.894770815972383e-07, -4.701088743128982e-09,  2.593074159826769e-11, -1.353796792947865e-13,  6.765084970637324e-16,
 -3.259478662154793e-18,  1.522405332159502e-20, -6.921142643896170e-23,  3.072586492983839e-25, -1.335337501665250e-27,  1.296586552702633e-02, -9.507558433439627e-05,
  7.592223329762013e-07, -5.227344748796504e-09,  3.302323275473863e-11, -1.957371214435706e-13,  1.102393092906952e-15, -5.950963493476402e-18,  3.098868715974233e-20,
 -1.564097493759012e-22,  7.680799516296104e-25, -3.680522981546132e-27,  7.298307510544581e-03, -6.867922551285912e-05,  6.399371918951462e-07, -5.053062180790980e-09,
  3.625066095960058e-11, -2.418817338106321e-13,  1.523140557671577e-15, -9.143084357257657e-18,  5.270205058575001e-20, -2.933017642773634e-22,  1.582714215814769e-24,
 -8.308920757558200e-27,  3.731319912090036e-03, -4.426237352536852e-05,  4.759090417022538e-07, -4.281969983266608e-09,  3.463938554597945e-11, -2.584648611914960e-13,
  1.808508003542237e-15, -1.200137415989783e-17,  7.614837440465871e-20, -4.647820938440772e-22,  2.741867673676987e-24, -1.569155183429144e-26,  1.732398702646636e-03,
 -2.547089066200634e-05,  3.137986711952273e-07, -3.199236430629895e-09,  2.901536249745578e-11, -2.408232088376036e-13,  1.863157681331233e-15, -1.360450930515045e-17,
  9.459495885010521e-20, -6.305200211458212e-22,  4.049639086936317e-24, -2.516425654777864e-26,  7.302992539934026e-04, -1.310677022052419e-05,  1.841047968982286e-07,
 -2.116416819058694e-09,  2.141788537803733e-11, -1.968838193515733e-13,  1.677413908038978e-15, -1.342570013134477e-17,  1.019287830032222e-19, -7.393584197513042e-22,
  5.152703762156945e-24, -3.465316232707943e-26,  2.794764303227460e-04, -6.040673393234606e-06,  9.636536851851785e-08, -1.243742730498526e-09,  1.398921740883571e-11,
 -1.419182103691158e-13,  1.327079556231041e-15, -1.160610974554087e-17,  9.592169146405746e-20, -7.550100991666865e-22,  5.693684427124198e-24, -4.133133541370218e-26,
  9.707566084528920e-05, -2.497299247535117e-06,  4.509368873060460e-08, -6.509930700112563e-10,  8.111463259048826e-12, -9.054335173197382e-14,  9.266877962153365e-16,
 -8.832318310007615e-18,  7.926651510039416e-20, -6.754055329337496e-22,  5.498782897958127e-24, -4.298983144367425e-26,  3.060114104709622e-05, -9.273495982730733e-07,
  1.889633533694704e-08, -3.041474280870429e-10,  4.186591224215708e-12, -5.129037166105270e-14,  5.732112290178844e-16, -5.940897842948384e-18,  5.777567891296352e-20,
 -5.318530893359112e-22,  4.665750109224495e-24, -3.921288179001553e-26,  8.753612377690395e-06, -3.096940084653448e-07,  7.101099793231335e-09, -1.270752067306996e-10,
  1.927805478654758e-12, -2.586602989920698e-14,  3.150326212699433e-16, -3.543952897091410e-18,  3.728208084409313e-20, -3.701641251885139e-22,  3.493465646660590e-24,
 -3.151377532259136e-26,  2.272207049878820e-06, -9.311473547083540e-08,  2.396140959746057e-09, -4.755746529135220e-11,  7.935370170218158e-13, -1.163963882497173e-14,
  1.542384672828062e-16, -1.880396032113836e-18,  2.136719657949302e-20, -2.284999753824437e-22,  2.316873366098293e-24, -2.240396326807430e-26,  5.352383962629469e-07,
 -2.523199105644104e-08,  7.268695186083258e-10, -1.596657603110177e-11,  2.925169041868014e-13, -4.683426653301148e-15,  6.742807540252792e-17, -8.897386569041015e-19,
  1.090740045245534e-20, -1.254889116297927e-22,  1.365519642652761e-24, -1.413965197372445e-26,  1.144370329453270e-07, -6.168476735264354e-09,  1.984590380955625e-10,
 -4.815797453197412e-12,  9.672732839010011e-14, -1.688265416239034e-15,  2.637777897820032e-17, -3.763247106975033e-19,  4.972220649195095e-21, -6.148536527095469e-23,
  7.173832257420609e-25, -7.947582457107944e-27,  2.221558477330981e-08, -1.361958437104853e-09,  4.883037690473789e-11, -1.306836012009401e-12,  2.874003899368833e-14,
 -5.462433963852005e-16,  9.253122221181561e-18, -1.426061441893050e-19,  2.029108689478903e-21, -2.694855739586603e-23,  3.368911906140990e-25, -3.990400101928283e-27,
  3.918003280879926e-09, -2.719096885944921e-10,  1.084172273410378e-11, -3.195509769588504e-13,  7.686274802236364e-15, -1.589386937520387e-16,  2.916737971153296e-18,
 -4.852552224520919e-20,  7.430875233864341e-22, -1.059305479469175e-23,  1.418098579318015e-25, -1.794909704992523e-27,  6.282764640237462e-10, -4.915386863678391e-11,
  2.175510599567775e-12, -7.052866461190510e-14,  1.853728099321526e-15, -4.167270312781257e-17,  8.279689058222960e-19, -1.486186347366523e-20,  2.448123704390221e-22,
 -3.744298704002315e-24,  5.365424222592358e-26, -7.253960098081845e-28,  9.171307571524889e-11, -8.058982062171050e-12,  3.952414731202635e-13, -1.407818744551711e-14,
  4.040071171009198e-16, -9.867894078356675e-18,  2.121631425715019e-19, -4.107120859136686e-21,  7.274990913769942e-23, -1.193399125798533e-24,  1.829948602607231e-26,
 -2.641938556275617e-28,  1.220719679795371e-11, -1.200810859739612e-12,  6.515497871965510e-14, -2.547333865815877e-15,  7.976297362602269e-17, -2.115716082565884e-18,
  4.920693746765550e-20, -1.027010463957889e-21,  1.955685192657680e-23, -3.440147477230184e-25,  5.643756355135630e-27, -8.699381118703094e-29,  1.484776330695912e-12,
 -1.630208627130897e-13,  9.771840935973227e-15, -4.189786312666834e-16,  1.430664180724076e-17, -4.119551166257375e-19,  1.036159847644363e-20, -2.331160753913127e-22,
  4.771577788013405e-24, -8.999431660977197e-26,  1.579439654391845e-27, -2.599094064672272e-29,  1.655138799316665e-13, -2.022900316311299e-14,  1.337789645600299e-15,
 -6.285560796283431e-17,  2.339454444896574e-18, -7.310628169571351e-20,  1.988197511909983e-21, -4.821175790334591e-23,  1.060668116642235e-24, -2.144822470996283e-26,
  4.026870158869339e-28, -7.074238673871011e-30,  1.697451115981752e-14, -2.303695992443690e-15,  1.678724526738134e-16, -8.637145870905699e-18,  3.502573421878194e-19,
 -1.187554230570747e-20,  3.491663626751003e-22, -9.125373221606922e-24,  2.157795926978538e-25, -4.678316511417885e-27,  9.396582665333653e-29, -1.762351802675446e-30,
  1.609555011703491e-15, -2.420030869852586e-16,  1.940909078541293e-17, -1.092805700864269e-18,  4.826625198794120e-20, -1.775206289742822e-21,  5.642384208200330e-23,
 -1.589267762889949e-24,  4.039251005684498e-26, -9.390100632173181e-28,  2.017827876327743e-29, -4.040617916858948e-31,  1.420161598779062e-16, -2.360373458681039e-17,
  2.081115679398835e-18, -1.281435026640545e-19,  6.161958539209843e-21, -2.457968067822015e-22,  8.444735617111392e-24, -2.563472387111487e-25,  7.003063436070812e-27,
 -1.745706407688095e-28,  4.013735445328812e-30, -8.581909898059568e-32,  1.175569632087871e-17, -2.155111298565575e-18,  2.086453502554727e-19, -1.404013505042295e-20,
  7.347418271188069e-22, -3.177892845595967e-23,  1.180017125248339e-24, -3.860235542019439e-26,  1.133505915093600e-27, -3.029897627065553e-29,  7.453894576490200e-31,
 -1.701783373377910e-32,  9.224886072595050e-19, -1.861164662277348e-19,  1.976075496444506e-20, -1.452066657543514e-21,  8.265484240980082e-23, -3.875004087979922e-24,
  1.554755929906641e-25, -5.480308267245416e-27,  1.729502257119485e-28, -4.956957149261082e-30,  1.304741860960746e-31, -3.180594346286144e-33,  6.953380240256547e-20,
 -1.540200478316080e-20,  1.790856485949937e-21, -1.435648416653514e-22,  8.882806120932147e-24, -4.511613177660498e-25,  1.955205187712320e-26, -7.423627643234651e-28,
  2.517243482923100e-29, -7.734116141635219e-31,  2.177633316632686e-32, -5.666865715860912e-34,  5.118435870719222e-21, -1.241400258026396e-21,  1.578080138606446e-22,
 -1.378437475383401e-23,  9.261785148540033e-25, -5.092342599423006e-26,  2.382129721990582e-27, -9.736978516978443e-29,  3.545729432234457e-30, -1.167291210992112e-31,
  3.514194880545455e-33, -9.758196649145177e-35,  3.756038274555651e-22, -9.943868957341192e-23,  1.379119419778537e-23, -1.310460840079948e-24,  9.548853628896730e-26,
 -5.676891479748517e-27,  2.863504974100559e-28, -1.258881287034193e-29,  4.918819811948765e-31, -1.733668622188672e-32,  5.576264658232726e-34, -1.650961653857043e-35,
  2.818288392797487e-23, -8.114704845895984e-24,  1.224614506903652e-24, -1.263094231695636e-25,  9.962218664581193e-27, -6.393092010022085e-28,  3.471834680363235e-29,
 -1.639235160626746e-30,  6.863004268559321e-32, -2.586303000891071e-33,  8.876374403413610e-35, -2.798584792422425e-36,  2.229681718730610e-24, -6.951532590472646e-25,
  1.137646099564982e-25, -1.269922468904689e-26,  1.081278882903680e-27, -7.471823481830572e-29,  4.358558311155542e-30, -2.205369897228438e-31,  9.873123117889134e-33,
 -3.970238778741398e-34,  1.451162002921330e-35, -4.863070432712844e-37,  1.928815875143278e-25, -6.476852227770686e-26,  1.144401475300152e-26, -1.377106815988887e-27,
  1.261206032855856e-28, -9.352454360910601e-30,  5.841236043968830e-31, -3.157604731998793e-32,  1.507097777644620e-33, -6.448442406541675e-35,  2.503161005530553e-36,
 -8.891924365993957e-38,  1.901815417202403e-26, -6.834084579680728e-27,  1.296368915051105e-27, -1.672911740811729e-28,  1.639917243446303e-29, -1.298951530819292e-30,
  8.647794401775484e-32, -4.973008175273940e-33,  2.520144293581508e-34, -1.142771791453491e-35,  4.692974661034865e-37, -1.760478890046506e-38,  2.235266138844687e-27,
 -8.529736128448583e-28,  1.724701577168151e-28, -2.370736326215829e-29,  2.471564822716421e-30, -2.078272694559462e-31,  1.466154726617414e-32, -8.918212743221607e-34,
  4.772130354393115e-35, -2.281114983586850e-36,  9.859126963831205e-38, -3.886034443335444e-39,  3.270023882495757e-28, -1.313168879421524e-28,  2.805359719022335e-29,
 -4.072749312529033e-30,  4.478798496225263e-31, -3.966675541178209e-32,  2.942818743655429e-33, -1.879536346360821e-34,  1.054436614116942e-35, -5.276646280750848e-37,
  2.384196837736132e-38, -9.810053183205601e-40,  6.138597381541811e-29, -2.567361671758915e-29,  5.733604643574052e-30, -8.700532909659246e-31,  9.991520773186384e-32,
 -9.229940883170132e-33,  7.133447622854280e-34, -4.740351090490638e-35,  2.763592835679688e-36, -1.435457014425003e-37,  6.724416476222139e-39, -2.865126921240093e-40,
  1.459164691172964e-29, -6.282434399673144e-30,  1.448720906851553e-30, -2.269994119040488e-31,  2.690031218501261e-32, -2.562193796487431e-33,  2.039925790761338e-34,
 -1.395203712737862e-35,  8.364287715536254e-37, -4.463729354797213e-38,  2.146600464077313e-39, -9.380960676959382e-41,  3.568948687270301e-30, -1.562126989611411e-30,
  3.668840596229374e-31, -5.855252008856877e-32,  7.064884882474665e-33, -6.848325666591845e-34,  5.546158558964008e-35, -3.856543963514891e-36,  2.349372299496654e-37,
 -1.273407145806736e-38,  6.216666778962424e-40, -2.756573513477202e-41,  };
  int offset = -41;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 41;
    if (std::isnan(t)) {
      fill_n(rr+offset, 41, 0.5);
      fill_n(ww+offset, 41, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 41; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=41; ++j) {
        const int boxof = it*492+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
