/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.Options;
import $installer$.org.aspectj.WizardPane;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ConfigureLauncherPane
extends WizardPane {
    private JTextField javaLocation;
    public static final String[] windowsPaths = new String[]{"c:\\jdk", "c:\\apps\\jdk", "${user.home}\\jdk"};
    public static final String[] unixPaths = new String[]{"/usr/local/bin/jdk", "/usr/bin/jdk", "/usr/bin/jdk", "${user.home}/jdk"};
    public static final String[] suffixes = new String[]{"1.3.1", "1.3", "1.2", "13", "12", "2", "", "1.4"};
    public static boolean windows = true;

    ConfigureLauncherPane() {
    }

    public static String getDefaultJavaHomeLocation() {
        File javaHome;
        if (!Options.forceHandConfigure && (javaHome = ConfigureLauncherPane.findJavaHome()) != null) {
            return javaHome.getPath();
        }
        return null;
    }

    public void chooseFile(JTextField field) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showDialog(field, "Select");
        if (returnVal == 0) {
            String name = chooser.getSelectedFile().getPath();
            field.setText(name);
            field.selectAll();
        }
    }

    public ActionListener makeJavaLocationBrowseListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureLauncherPane.this.chooseFile(ConfigureLauncherPane.this.javaLocation);
            }
        };
    }

    public JPanel makePanel() {
        JEditorPane text;
        String javaPath = ConfigureLauncherPane.getDefaultJavaHomeLocation();
        if (javaPath == null) {
            javaPath = "<java home not found>";
            text = this.makeHTMLArea("configure-hand.html");
        } else {
            text = this.makeHTMLArea("configure-auto.html");
        }
        this.javaLocation = new JTextField(javaPath);
        JButton javaLocationBrowse = new JButton("Browse...");
        javaLocationBrowse.addActionListener(this.makeJavaLocationBrowseListener());
        JPanel javaLocationBox = this.makeLocationBox("java home directory", this.javaLocation, javaLocationBrowse);
        GridBagLayout bag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel(bag);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        bag.setConstraints(text, c);
        panel.add(text);
        c.weighty = 0.0;
        bag.setConstraints(javaLocationBox, c);
        panel.add(javaLocationBox);
        c.weighty = 0.5;
        JLabel space = new JLabel();
        bag.setConstraints(space, c);
        panel.add(space);
        return panel;
    }

    public void finish() {
        WizardPane.context.javaPath = new File(this.javaLocation.getText());
    }

    public static boolean isLegalJavaHome(File home) {
        File bin = new File(home, "bin");
        return new File(bin, "java").isFile() || new File(bin, "java.exe").isFile();
    }

    public static boolean isLegalJDKHome(File home) {
        File lib = new File(home, "lib");
        return new File(lib, "tools.jar").isFile();
    }

    public static File findJavaHome() {
        String s = System.getProperty("java.home");
        File javaHome = null;
        if (s != null) {
            File parent;
            javaHome = new File(s);
            if (ConfigureLauncherPane.isLegalJDKHome(javaHome)) {
                return javaHome;
            }
            if (ConfigureLauncherPane.isLegalJavaHome(javaHome) && (parent = javaHome.getParentFile()) != null && ConfigureLauncherPane.isLegalJDKHome(parent)) {
                return parent;
            }
        }
        String[] paths = windows ? windowsPaths : unixPaths;
        for (int suffixIndex = 0; suffixIndex < suffixes.length; ++suffixIndex) {
            String suffix = suffixes[suffixIndex];
            for (int prefixIndex = 0; prefixIndex < paths.length; ++prefixIndex) {
                String prefix = paths[prefixIndex];
                File test = new File((prefix = WizardPane.applyProperties(prefix)) + suffix);
                if (!ConfigureLauncherPane.isLegalJavaHome(test)) continue;
                if (ConfigureLauncherPane.isLegalJDKHome(test)) {
                    return test;
                }
                if (javaHome != null) continue;
                javaHome = test;
            }
        }
        return javaHome;
    }
}

