/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.value.SequenceType;

public class ApplyImports
extends Instruction {
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;

    public ApplyImports(WithParam[] withParamArray, WithParam[] withParamArray2) {
        this.actualParams = withParamArray;
        this.tunnelParams = withParamArray2;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("apply-imports");
    }

    public SequenceType getResultType() {
        return SequenceType.ANY_SEQUENCE;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        ParameterSet parameterSet = this.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = this.assembleTunnelParams(xPathContext, this.tunnelParams);
        Template template = xPathContext.getController().getCurrentTemplate();
        if (template == null) {
            throw new TransformerException("There is no current template rule");
        }
        int n = template.getMinImportPrecedence();
        int n2 = template.getPrecedence() - 1;
        controller.applyImports(n, n2, parameterSet, parameterSet2);
        return null;
    }
}

