/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class UnparsedText
extends SystemFunction
implements XSLTFunction {
    String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.expressionBaseURI = staticContext.getBaseURI();
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string = this.argument[0].evaluateItem(xPathContext).getStringValue();
        String string2 = this.argument[1].evaluateItem(xPathContext).getStringValue();
        return new StringValue(this.readFile(string, this.expressionBaseURI, string2));
    }

    private CharSequence readFile(String string, String string2, String string3) throws XPathException {
        URL uRL;
        if (string2 == null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathException.Dynamic("Cannot resolve absolute URI", malformedURLException);
            }
        }
        try {
            uRL = new URL(new URL(string2), string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XPathException.Dynamic("Cannot resolve relative URI", malformedURLException);
        }
        try {
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string3));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[2048];
            int n = 0;
            while ((n = bufferedReader.read(cArray, 0, 2048)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            return stringBuffer;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XPathException.Dynamic("Unknown encoding \"" + string3 + "\"", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new XPathException.Dynamic("Failed to read input file", iOException);
        }
    }
}

