/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class CastAsQName
extends ComputedExpression {
    private Expression input;
    private NamespaceResolver nsContext;
    private NamePool namePool;

    public CastAsQName(Expression expression) {
        this.input = expression;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (!(staticContext instanceof ExpressionContext)) {
            throw new XPathException.Static("cast as xs:QName is currently implemented only in XSLT");
        }
        this.nsContext = ((ExpressionContext)staticContext).getNamespaceContext();
        this.namePool = staticContext.getNamePool();
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        return super.promote(promotionOffer);
    }

    public int computeCardinality() {
        return 512;
    }

    public ItemType getItemType() {
        return Type.QNAME_TYPE;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.input};
        return expressionArray;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.input.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        StringValue stringValue = (StringValue)atomicValue.getPrimitiveValue();
        try {
            String[] stringArray = Name.getQNameParts(stringValue.getStringValue());
            String string = this.nsContext.getURIForPrefix(stringArray[0], true, this.namePool);
            if (string == null) {
                throw new XPathException.Dynamic("Prefix '" + stringArray[0] + "' has not been declared");
            }
            return new QNameValue(string, stringArray[1]);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Dynamic(qNameException);
        }
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "cast as QName");
        this.input.display(n + 1, namePool);
    }
}

