/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.agent;

import java.io.FileOutputStream;
import java.util.Properties;
import net.sf.jiapi.agent.Transformer;
import net.sf.jiapi.reflect.JiapiClass;
import net.sf.jiapi.reflect.util.HotSpotAdvice;
import net.sf.jiapi.reflect.util.HotSpotAdvisor;
import net.sf.jiapi.reflect.util.InstrumentationContext;
import net.sf.jiapi.reflect.util.InstrumentationDescriptor;

public class HotSpotTransformer
extends Transformer {
    private InstrumentationContext context;
    private Properties properties;

    @Override
    public void init(Properties p) {
        this.properties = p;
        String aName = p.getProperty("advice", "net.sf.jiapi.agent.DefaultAdvice");
        String iRule = p.getProperty("inclusion-rule");
        String eRule = p.getProperty("exclusion-rule");
        String resolution = p.getProperty("resolution", "*");
        if (iRule == null) {
            iRule = p.getProperty("ir");
        }
        if (eRule == null) {
            eRule = p.getProperty("er");
        }
        if (iRule != null) {
            try {
                Class<?> c = Class.forName(aName);
                Object o = c.newInstance();
                HotSpotAdvice hsa = (HotSpotAdvice)o;
                InstrumentationContext ctx = new InstrumentationContext();
                InstrumentationDescriptor id = new InstrumentationDescriptor();
                id.addInclusionRule(iRule);
                if (eRule != null) {
                    id.addExclusionRule(eRule);
                }
                ctx.addInstrumentationDescriptor(id);
                HotSpotAdvisor hsi = new HotSpotAdvisor(id, hsa, HotSpotAdvisor.INVOCATIONS, resolution);
                this.context = ctx;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Warning: No inclusion rule given. This Transformer will do nothing.");
        }
    }

    @Override
    public boolean transform(JiapiClass clazz) {
        if (this.context != null) {
            this.context.instrument(clazz);
            if (this.properties.getProperty("dump") != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(clazz.getName() + ".clazz");
                    clazz.dump(fos);
                }
                catch (Exception e) {
                    System.out.println("Failed to dump " + clazz.getName() + e);
                }
            }
            return true;
        }
        return false;
    }
}

