/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.attribute.Attribute;

public class LineNumberTableAttribute
extends Attribute {
    public static final String ATTRIBUTE_NAME = "LineNumberTable";
    private List<Entry> lineNumbers = new LinkedList<Entry>();

    LineNumberTableAttribute(short nameIndex, int attributeLength, DataInputStream dis) throws IOException {
        super(nameIndex, attributeLength, dis);
        dis = this.getDataInputStream();
        int line_number_table_length = dis.readShort();
        for (int i = 0; i < line_number_table_length; ++i) {
            short start_pc = dis.readShort();
            short line_number = dis.readShort();
            this.lineNumbers.add(new Entry(start_pc, line_number));
        }
    }

    public List<Entry> getEntries() {
        return this.lineNumbers;
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.lineNumbers.size());
            for (Entry lnte : this.lineNumbers) {
                dos.writeShort(lnte.getStartPc());
                dos.writeShort(lnte.getLineNumber());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    @Override
    public String toString() {
        return "LineNumberTable, size " + this.lineNumbers.size();
    }

    public class Entry {
        private short start_pc;
        private short line_number;

        public Entry(short start_pc, short line_number) {
            this.start_pc = start_pc;
            this.line_number = line_number;
        }

        public short getStartPc() {
            return this.start_pc;
        }

        public void setStartPc(short start_pc) {
            this.start_pc = start_pc;
        }

        public short getLineNumber() {
            return this.line_number;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("start_pc: " + this.start_pc);
            sb.append(", line_number: " + this.line_number);
            return sb.toString();
        }
    }
}

