/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.attribute.Attribute;

public class InnerClassesAttribute
extends Attribute {
    private List<InnerClass> innerClasses = new LinkedList<InnerClass>();

    public InnerClassesAttribute(short nameIndex, int attributeLength, DataInputStream dis) throws IOException {
        super(nameIndex, attributeLength, dis);
        dis = this.getDataInputStream();
        int count = dis.readShort();
        for (int i = 0; i < count; ++i) {
            short inner_class_info_index = dis.readShort();
            short outer_class_info_index = dis.readShort();
            short inner_name_index = dis.readShort();
            short inner_class_access_flags = dis.readShort();
            this.innerClasses.add(new InnerClass(inner_class_info_index, outer_class_info_index, inner_name_index, inner_class_access_flags));
        }
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.innerClasses.size());
            for (InnerClass ic : this.innerClasses) {
                dos.writeShort(ic.getInnerClassInfoIndex());
                dos.writeShort(ic.getOuterClassInfoIndex());
                dos.writeShort(ic.getInnerNameIndex());
                dos.writeShort(ic.getInnerClassAccessFlags());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    public class InnerClass {
        public static final short ACC_PUBLIC = 1;
        public static final short ACC_PRIVATE = 2;
        public static final short ACC_PROTECTED = 4;
        public static final short ACC_STATIC = 8;
        public static final short ACC_FINAL = 16;
        public static final short ACC_INTERFACE = 512;
        public static final short ACC_ABSTRACT = 1024;
        public static final short ACC_SYNTHETIC = 4096;
        public static final short ACC_ANNOTATION = 8192;
        public static final short ACC_ENUM = 16384;
        private short inner_class_info_index;
        private short outer_class_info_index;
        private short inner_name_index;
        private short inner_class_access_flags;

        public InnerClass(short inner_class_info_index, short outer_class_info_index, short inner_name_index, short inner_class_access_flags) {
            this.inner_class_info_index = inner_class_info_index;
            this.outer_class_info_index = outer_class_info_index;
            this.inner_name_index = inner_name_index;
            this.inner_class_access_flags = inner_class_access_flags;
        }

        public short getInnerClassInfoIndex() {
            return this.inner_class_info_index;
        }

        public short getOuterClassInfoIndex() {
            return this.outer_class_info_index;
        }

        public short getInnerNameIndex() {
            return this.inner_name_index;
        }

        public short getInnerClassAccessFlags() {
            return this.inner_class_access_flags;
        }
    }
}

