/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.ProgramElement;
import net.sf.jiapi.file.attribute.Attribute;
import net.sf.jiapi.file.attribute.CodeAttribute;
import net.sf.jiapi.file.attribute.ExceptionsAttribute;

public class Method
extends ProgramElement {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_BRIDGE = 64;
    public static final short ACC_VARARGS = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_STRICT = 2048;
    public static final short ACC_SYNTHETIC = 2048;
    private short name_index;
    private short descriptor_index;

    public Method(ConstantPool cp, short access_flags, String name, String descriptor, LinkedList<Attribute> attributes) {
        super(cp, access_flags, attributes);
        this.name_index = cp.addUtf8Info(name).getEntryIndex();
        this.descriptor_index = cp.addUtf8Info(descriptor).getEntryIndex();
    }

    Method(ConstantPool cp, DataInputStream dis) throws IOException {
        super(cp);
        this.access_flags = dis.readShort();
        this.name_index = dis.readShort();
        this.descriptor_index = dis.readShort();
        this.readAttributes(dis);
    }

    public String getName() {
        return this.constantPool.getUtf8(this.name_index);
    }

    public String getDescriptor() {
        return this.constantPool.getUtf8(this.descriptor_index);
    }

    short getNameIndex() {
        return this.name_index;
    }

    short getDescriptorIndex() {
        return this.descriptor_index;
    }

    public CodeAttribute getCodeAttribute() {
        return (CodeAttribute)this.getAttribute("Code");
    }

    public ExceptionsAttribute getExceptionsAttribute() {
        return (ExceptionsAttribute)this.getAttribute("Exceptions");
    }

    public String toString() {
        return this.getDescriptor() + " " + this.getName();
    }
}

