/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import jd.io.FileUtil;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.CanXmlResultBuilder;
import jd.xml.xslt.result.DefaultResultBuilder;
import jd.xml.xslt.result.EmptyResultBuilder;
import jd.xml.xslt.result.HtmlResultBuilder;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.result.TextResultBuilder;
import jd.xml.xslt.result.XmlResultBuilder;

public class XsltResult {
    private String uri_;
    private File file_;
    private Writer writer_;
    private OutputStream out_;
    private ResultBuilder builder_;
    private boolean closeOutput_;

    public XsltResult(String string) throws IOException {
        this(new File(string));
    }

    public XsltResult(File file) throws IOException {
        String string = file.getParent();
        if (string != null) {
            File file2 = new File(string);
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    throw new IOException("cannot create directory '" + file2 + "' because a file with this name already exists");
                }
            } else if (!file2.mkdirs()) {
                throw new IOException("cannot create directory '" + file2 + "' for output file '" + file + "'");
            }
        }
        this.uri_ = file.getAbsolutePath();
        this.file_ = file;
        this.out_ = new FileOutputStream(file);
        this.closeOutput_ = true;
    }

    public XsltResult(String string, OutputStream outputStream, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream is null");
        }
        this.uri_ = string;
        this.out_ = outputStream;
        this.closeOutput_ = bl;
    }

    public XsltResult(String string, Writer writer, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        this.uri_ = string;
        this.writer_ = writer;
        this.closeOutput_ = bl;
    }

    public XsltResult(ResultBuilder resultBuilder) {
        this.builder_ = resultBuilder;
    }

    public ResultBuilder getResultBuilder(OutputFormat outputFormat) {
        if (this.builder_ != null) {
            return this.builder_;
        }
        try {
            String string = outputFormat.getMethod();
            if (string == "xml") {
                return new XmlResultBuilder(this);
            }
            if (string == "html") {
                return new HtmlResultBuilder(this);
            }
            if (string == "text") {
                return new TextResultBuilder(this);
            }
            if (string == "canonical-xml") {
                return new CanXmlResultBuilder(this);
            }
            if (string == "empty") {
                return new EmptyResultBuilder(this.getUri());
            }
            return new DefaultResultBuilder(this);
        }
        catch (XsltException xsltException) {
            throw xsltException;
        }
        catch (Exception exception) {
            throw new XsltException("cannot create the result builder", exception);
        }
    }

    public String getUri() {
        return this.uri_;
    }

    public Writer getWriter() {
        return this.writer_;
    }

    public OutputStream getOutputStream() {
        if (this.out_ == null) {
            if (this.writer_ != null) {
                throw new XsltException("this result contains a writer");
            }
            throw new XsltException("no outputstream available");
        }
        return this.out_;
    }

    public void reset() throws IOException {
        if (this.file_ != null) {
            this.out_ = new FileOutputStream(this.file_);
        } else if (this.out_ instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.out_).reset();
        }
    }

    public void cleanup() {
        if (this.closeOutput_) {
            if (this.writer_ != null) {
                FileUtil.close(this.writer_);
            }
            if (this.out_ != null) {
                FileUtil.close(this.out_);
            }
        }
    }
}

