/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.build;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import jd.io.FileUtil;
import jd.util.StringUtil;
import jd.xml.util.XmlSource;
import jd.xml.xpath.XPathException;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.model.build.ModelBuilder;
import jd.xml.xpath.model.build.normal.NormalModelBuilderFactory;

public abstract class ModelBuilderFactory {
    public static final String PROPERTY_NAME = "jd.xml.xpath.model.factory";
    protected String defaultModelName_;
    private static ModelBuilderFactory instance_;
    private static ModelBuilderFactory defaultInstance_;
    static /* synthetic */ Class class$jd$xml$xpath$model$build$ModelBuilderFactory;

    public static synchronized void setInstance(ModelBuilderFactory modelBuilderFactory) {
        if (modelBuilderFactory == null) {
            throw new IllegalArgumentException("instance is null");
        }
        instance_ = modelBuilderFactory;
    }

    public static synchronized ModelBuilderFactory getInstance() {
        if (instance_ == null) {
            ModelBuilderFactory.createFactory();
        }
        return instance_;
    }

    public static ModelBuilderFactory getDefaultInstance() {
        return defaultInstance_;
    }

    public static ModelBuilder getModelBuilder(XmlSource xmlSource, ModelBuilder modelBuilder) throws XPathException {
        ModelBuilderFactory modelBuilderFactory = ModelBuilderFactory.getInstance();
        if (!modelBuilderFactory.canBeUsedFor(xmlSource)) {
            modelBuilderFactory = ModelBuilderFactory.getDefaultInstance();
        }
        return modelBuilderFactory.getModelBuilder(modelBuilder);
    }

    public abstract ModelBuilder getModelBuilder(ModelBuilder var1) throws XPathException;

    public abstract boolean canBeUsedFor(XmlSource var1);

    public abstract ModelBuilder createModelBuilder() throws XPathException;

    public XPathRootNode createTextNodeFragment(String string, NodeNamePool nodeNamePool, int n) {
        return defaultInstance_.createTextNodeFragment(string, nodeNamePool, n);
    }

    public void setProperties(String string) {
        String[] stringArray = StringUtil.split(string, ";");
        for (int i = 0; i < stringArray.length; ++i) {
            this.setProperty(stringArray[i]);
        }
    }

    public void setProperty(String string) {
        int n = string.indexOf(61);
        if (n == -1) {
            throw new IllegalArgumentException("illegal property '" + string + "'");
        }
        this.setProperty(string.substring(0, n).trim(), string.substring(n + 1).trim());
    }

    public abstract void setProperty(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFactory() throws XPathException {
        try {
            String string = ModelBuilderFactory.findFactoryClass();
            if (string != null) {
                ModelBuilderFactory.createFactory(string);
            }
            Object var2_1 = null;
            if (instance_ == null) {
                instance_ = defaultInstance_;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (instance_ == null) {
                instance_ = defaultInstance_;
            }
            throw throwable;
        }
    }

    private static void createFactory(String string) throws XPathException {
        ModelBuilderFactory modelBuilderFactory;
        String string2 = null;
        int n = string.indexOf(35);
        if (n != -1) {
            if (n <= string.length() - 1) {
                string2 = string.substring(n + 1);
            }
            string = string.substring(n);
        }
        try {
            modelBuilderFactory = (ModelBuilderFactory)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new XPathException("invalid ModelBuilderFactory '" + string + "'", exception);
        }
        if (string2 != null) {
            modelBuilderFactory.setProperties(string2);
        }
        instance_ = modelBuilderFactory;
    }

    private static String findFactoryClass() {
        InputStream inputStream;
        block7: {
            String string;
            String string2;
            try {
                string2 = System.getProperty(PROPERTY_NAME);
                if (string2 != null) {
                    return string2;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string2 = "META-INF/services/jd.xml.xpath.model.factory";
            inputStream = null;
            try {
                BufferedReader bufferedReader;
                String string3;
                ClassLoader classLoader = (class$jd$xml$xpath$model$build$ModelBuilderFactory == null ? (class$jd$xml$xpath$model$build$ModelBuilderFactory = ModelBuilderFactory.class$("jd.xml.xpath.model.build.ModelBuilderFactory")) : class$jd$xml$xpath$model$build$ModelBuilderFactory).getClassLoader();
                InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
                if (inputStream == null || (string3 = (bufferedReader = new BufferedReader(new InputStreamReader(inputStream))).readLine()) == null || (string3 = string3.trim()).length() <= 0) break block7;
                string = string3;
            }
            catch (Exception exception) {
                try {
                    throw new XPathException("cannot read " + string2);
                }
                catch (Throwable throwable) {
                    FileUtil.close(inputStream);
                    throw throwable;
                }
            }
            FileUtil.close(inputStream);
            return string;
        }
        FileUtil.close(inputStream);
        return null;
    }

    public static void main(String[] stringArray) {
        ModelBuilderFactory modelBuilderFactory = ModelBuilderFactory.getInstance();
        System.out.println("ModelBuilderFactory is:");
        System.out.println(modelBuilderFactory.getClass().getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultInstance_ = new NormalModelBuilderFactory();
    }
}

