/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.JumpData;
import net.sourceforge.cobertura.coveragedata.SwitchData;
import net.sourceforge.cobertura.util.StringUtil;

public class LineData
implements Comparable,
CoverageData,
HasBeenInstrumented,
Serializable {
    private static final long serialVersionUID = 4L;
    private long hits = 0L;
    private List jumps = null;
    private List switches;
    private final int lineNumber;
    private String methodDescriptor;
    private String methodName;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$LineData;

    LineData(int lineNumber) {
        this(lineNumber, null, null);
    }

    LineData(int lineNumber, String methodName, String methodDescriptor) {
        this.lineNumber = lineNumber;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(class$net$sourceforge$cobertura$coveragedata$LineData == null ? (class$net$sourceforge$cobertura$coveragedata$LineData = LineData.class$("net.sourceforge.cobertura.coveragedata.LineData")) : class$net$sourceforge$cobertura$coveragedata$LineData)) {
            return Integer.MAX_VALUE;
        }
        return this.lineNumber - ((LineData)o).lineNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        LineData lineData = (LineData)obj;
        return this.hits == lineData.hits && (this.jumps == lineData.jumps || this.jumps != null && this.jumps.equals(lineData.jumps)) && (this.switches == lineData.switches || this.switches != null && this.switches.equals(lineData.switches)) && this.lineNumber == lineData.lineNumber && this.methodDescriptor.equals(lineData.methodDescriptor) && this.methodName.equals(lineData.methodName);
    }

    public double getBranchCoverageRate() {
        if (this.getNumberOfValidBranches() == 0) {
            return 1.0;
        }
        return (double)this.getNumberOfCoveredBranches() / (double)this.getNumberOfValidBranches();
    }

    public String getConditionCoverage() {
        StringBuffer ret = new StringBuffer();
        if (this.getNumberOfValidBranches() == 0) {
            ret.append(StringUtil.getPercentValue(1.0));
        } else {
            ret.append(StringUtil.getPercentValue(this.getBranchCoverageRate()));
            ret.append(" (").append(this.getNumberOfCoveredBranches()).append("/").append(this.getNumberOfValidBranches()).append(")");
        }
        return ret.toString();
    }

    public long getHits() {
        return this.hits;
    }

    public boolean isCovered() {
        return this.getHits() > 0L && (this.getNumberOfValidBranches() == 0 || 1.0 - this.getBranchCoverageRate() < 1.0E-4);
    }

    public double getLineCoverageRate() {
        return this.getHits() > 0L ? 1.0 : 0.0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getNumberOfCoveredLines() {
        return this.getHits() > 0L ? 1 : 0;
    }

    public int getNumberOfValidBranches() {
        int ret = 0;
        if (this.jumps != null) {
            int i = this.jumps.size() - 1;
            while (i >= 0) {
                ret += ((JumpData)this.jumps.get(i)).getNumberOfValidBranches();
                --i;
            }
        }
        if (this.switches != null) {
            int i = this.switches.size() - 1;
            while (i >= 0) {
                ret += ((SwitchData)this.switches.get(i)).getNumberOfValidBranches();
                --i;
            }
        }
        return ret;
    }

    public int getNumberOfCoveredBranches() {
        int ret = 0;
        if (this.jumps != null) {
            int i = this.jumps.size() - 1;
            while (i >= 0) {
                ret += ((JumpData)this.jumps.get(i)).getNumberOfCoveredBranches();
                --i;
            }
        }
        if (this.switches != null) {
            int i = this.switches.size() - 1;
            while (i >= 0) {
                ret += ((SwitchData)this.switches.get(i)).getNumberOfCoveredBranches();
                --i;
            }
        }
        return ret;
    }

    public int getNumberOfValidLines() {
        return 1;
    }

    public int hashCode() {
        return this.lineNumber;
    }

    public boolean hasBranch() {
        return this.jumps != null || this.switches != null;
    }

    public void merge(CoverageData coverageData) {
        int i;
        int i2;
        LineData lineData = (LineData)coverageData;
        this.hits += lineData.hits;
        if (lineData.jumps != null) {
            if (this.jumps == null) {
                this.jumps = lineData.jumps;
            } else {
                i2 = Math.min(this.jumps.size(), lineData.jumps.size()) - 1;
                while (i2 >= 0) {
                    ((JumpData)this.jumps.get(i2)).merge((JumpData)lineData.jumps.get(i2));
                    --i2;
                }
                i = Math.min(this.jumps.size(), lineData.jumps.size());
                while (i < lineData.jumps.size()) {
                    this.jumps.add(lineData.jumps.get(i));
                    ++i;
                }
            }
        }
        if (lineData.switches != null) {
            if (this.switches == null) {
                this.switches = lineData.switches;
            } else {
                i2 = Math.min(this.switches.size(), lineData.switches.size()) - 1;
                while (i2 >= 0) {
                    ((SwitchData)this.switches.get(i2)).merge((SwitchData)lineData.switches.get(i2));
                    --i2;
                }
                i = Math.min(this.switches.size(), lineData.switches.size());
                while (i < lineData.switches.size()) {
                    this.switches.add(lineData.switches.get(i));
                    ++i;
                }
            }
        }
        if (lineData.methodName != null) {
            this.methodName = lineData.methodName;
        }
        if (lineData.methodDescriptor != null) {
            this.methodDescriptor = lineData.methodDescriptor;
        }
    }

    void addJump(int jumpNumber) {
        this.getJumpData(jumpNumber);
    }

    void addSwitch(int switchNumber, int[] keys) {
        this.getSwitchData(switchNumber, new SwitchData(switchNumber, keys));
    }

    void addSwitch(int switchNumber, int min, int max) {
        this.getSwitchData(switchNumber, new SwitchData(switchNumber, min, max));
    }

    void setMethodNameAndDescriptor(String name, String descriptor) {
        this.methodName = name;
        this.methodDescriptor = descriptor;
    }

    void touch() {
        ++this.hits;
    }

    void touchJump(int jumpNumber, boolean branch) {
        this.getJumpData(jumpNumber).touchBranch(branch);
    }

    void touchSwitch(int switchNumber, int branch) {
        this.getSwitchData(switchNumber, null).touchBranch(branch);
    }

    public int getConditionSize() {
        return (this.jumps == null ? 0 : this.jumps.size()) + (this.switches == null ? 0 : this.switches.size());
    }

    public Object getConditionData(int index) {
        int switchesSize;
        Object branchData = null;
        int jumpsSize = this.jumps == null ? 0 : this.jumps.size();
        int n = switchesSize = this.switches == null ? 0 : this.switches.size();
        if (index < jumpsSize) {
            branchData = this.jumps.get(index);
        } else if (index < jumpsSize + switchesSize) {
            branchData = this.switches.get(index - jumpsSize);
        }
        return branchData;
    }

    public String getConditionCoverage(int index) {
        Object branchData = this.getConditionData(index);
        if (branchData == null) {
            return StringUtil.getPercentValue(1.0);
        }
        if (branchData instanceof JumpData) {
            JumpData jumpData = (JumpData)branchData;
            return StringUtil.getPercentValue(jumpData.getBranchCoverageRate());
        }
        SwitchData switchData = (SwitchData)branchData;
        return StringUtil.getPercentValue(switchData.getBranchCoverageRate());
    }

    JumpData getJumpData(int jumpNumber) {
        if (this.jumps == null) {
            this.jumps = new ArrayList();
        }
        if (this.jumps.size() <= jumpNumber) {
            int i = this.jumps.size();
            while (i <= jumpNumber) {
                this.jumps.add(new JumpData(i++));
            }
        }
        return (JumpData)this.jumps.get(jumpNumber);
    }

    SwitchData getSwitchData(int switchNumber, SwitchData data) {
        if (this.switches == null) {
            this.switches = new ArrayList();
        }
        if (this.switches.size() < switchNumber) {
            int i = this.switches.size();
            while (i < switchNumber) {
                this.switches.add(new SwitchData(i++));
            }
        }
        if (this.switches.size() == switchNumber) {
            if (data != null) {
                this.switches.add(data);
            } else {
                this.switches.add(new SwitchData(switchNumber));
            }
        }
        return (SwitchData)this.switches.get(switchNumber);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

