/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:56:18 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.CodonUsageAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageWeight;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class CodonUsageAlgorithm_ESTest extends CodonUsageAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CodonUsageAlgorithm codonUsageAlgorithm0 = null;
      try {
        codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, (CodonUsageWeight) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MockFile mockFile0 = new MockFile("+");
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      Integer integer0 = codonUsageAlgorithm0.getDefaultStepSize((-5));
      assertEquals("Reverse Codon Usage Scores from +", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(integer0);
      assertTrue(codonUsageAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      MockFile mockFile0 = new MockFile("+", "+");
      Strand strand0 = bases0.getReverseStrand();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      Integer integer0 = codonUsageAlgorithm0.getDefaultMinWindowSize();
      assertEquals("Reverse Codon Usage Scores from +", codonUsageAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      assertTrue(codonUsageAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MockFile mockFile0 = new MockFile("+");
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      Integer integer0 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("Reverse Codon Usage Scores from +", codonUsageAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      assertEquals(500, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      MockFile mockFile0 = new MockFile("+", "+");
      Strand strand0 = bases0.getReverseStrand();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("Reverse Codon Usage Scores from +", codonUsageAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      assertEquals(120, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      MockFile mockFile0 = new MockFile("+");
      Strand strand0 = bases0.getReverseStrand();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      float[] floatArray0 = new float[7];
      // Undeclared exception!
      try { 
        codonUsageAlgorithm0.getValues((-1305), 1, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      MockFile mockFile0 = new MockFile("+", "+");
      Strand strand0 = bases0.getReverseStrand();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      float[] floatArray0 = new float[7];
      // Undeclared exception!
      try { 
        codonUsageAlgorithm0.getValues(5, 1, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 5 > end: 1
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      MockFile mockFile0 = new MockFile("+");
      Strand strand0 = bases0.getReverseStrand();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      Float float0 = codonUsageAlgorithm0.getMaximumInternal();
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(2.0F, (float)float0, 0.01F);
      assertEquals("Reverse Codon Usage Scores from +", codonUsageAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      MockFile mockFile0 = new MockFile("+", "+");
      Strand strand0 = bases0.getReverseStrand();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("Reverse Codon Usage Scores from +", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MockFile mockFile0 = new MockFile("+");
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      Float float0 = codonUsageAlgorithm0.getMinimumInternal();
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("Reverse Codon Usage Scores from +", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(0.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FileSystemHandling.shouldAllThrowIOExceptions();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("+");
      Bases bases0 = new Bases(emblStreamSequence0);
      MockFile mockFile0 = new MockFile("+", "+");
      Strand strand0 = bases0.getReverseStrand();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(mockFile0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      codonUsageAlgorithm0.getAverage();
  }
}
