/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:25:24 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.variant.CDSFeature;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class CDSFeature_ESTest extends CDSFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Range range0 = new Range((-4414), 0);
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.add(range0);
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, 0, 99, "/,5rQS{kh+");
      String string0 = cDSFeature0.toString();
      assertEquals("false\t0\t99\t/,5rQS{kh+\t2\t-4414-0\t-4414-0\t", string0);
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Range range0 = new Range(102, 102);
      RangeVector rangeVector0 = new RangeVector(range0);
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, 102, 102, "");
      String string0 = cDSFeature0.toString();
      assertEquals("false\t102\t102\t\t1\t102-102\t", string0);
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      RangeVector rangeVector0 = new RangeVector();
      CDSFeature cDSFeature0 = new CDSFeature(true, rangeVector0, 0, 0, "+1ERSYcku!@");
      rangeVector0.add((Range) null);
      // Undeclared exception!
      try { 
        cDSFeature0.toString();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.CDSFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      CDSFeature cDSFeature0 = null;
      try {
        cDSFeature0 = new CDSFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.CDSFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("HG:1/Fh[g-&V&rf");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("HG:1/Fh[g-&V&rf");
      Feature feature0 = entry0.createFeature();
      CDSFeature cDSFeature0 = new CDSFeature(feature0);
  }
}
