/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.instr;

import org.jacoco.asm.ClassReader;
import org.jacoco.core.internal.data.CRC64;
import org.jacoco.core.internal.flow.ClassProbesAdapter;
import org.jacoco.core.internal.instr.ClassFieldProbeArrayStrategy;
import org.jacoco.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.core.internal.instr.InterfaceFieldProbeArrayStrategy;
import org.jacoco.core.internal.instr.LocalProbeArrayStrategy;
import org.jacoco.core.internal.instr.NoneProbeArrayStrategy;
import org.jacoco.core.internal.instr.ProbeCounter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;

public final class ProbeArrayStrategyFactory {
    private ProbeArrayStrategyFactory() {
    }

    public static IProbeArrayStrategy createFor(ClassReader reader, IExecutionDataAccessorGenerator accessorGenerator) {
        boolean withFrames;
        String className = reader.getClassName();
        int version = ProbeArrayStrategyFactory.getVersion(reader);
        long classId = CRC64.checksum(reader.b);
        boolean bl = withFrames = version >= 50;
        if (ProbeArrayStrategyFactory.isInterface(reader)) {
            ProbeCounter counter = ProbeArrayStrategyFactory.getProbeCounter(reader);
            if (counter.getCount() == 0) {
                return new NoneProbeArrayStrategy();
            }
            if (version >= 52 && counter.hasMethods()) {
                return new InterfaceFieldProbeArrayStrategy(className, classId, counter.getCount(), accessorGenerator);
            }
            return new LocalProbeArrayStrategy(className, classId, counter.getCount(), accessorGenerator);
        }
        return new ClassFieldProbeArrayStrategy(className, classId, withFrames, accessorGenerator);
    }

    private static boolean isInterface(ClassReader reader) {
        return (reader.getAccess() & 0x200) != 0;
    }

    private static int getVersion(ClassReader reader) {
        return reader.readShort(6);
    }

    private static ProbeCounter getProbeCounter(ClassReader reader) {
        ProbeCounter counter = new ProbeCounter();
        reader.accept(new ClassProbesAdapter(counter, false), 0);
        return counter;
    }
}

