/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import net.sourceforge.cobertura.dsl.ArgumentsBuilder;
import net.sourceforge.cobertura.dsl.Cobertura;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentMain {
    private static final LoggerWrapper logger = new LoggerWrapper();
    public static URLClassLoader urlClassLoader;

    public static int instrument(String[] args) {
        Header.print(System.out);
        long startTime = System.currentTimeMillis();
        try {
            args = CommandLineBuilder.preprocessCommandLineArguments(args);
        }
        catch (Exception ex) {
            System.err.println("Error: Cannot process arguments: " + ex.getMessage());
            return 1;
        }
        try {
            new Cobertura(InstrumentMain.createArgumentsFromCMDParams(args).build()).instrumentCode().saveProjectData();
        }
        catch (Throwable throwable) {
            System.err.println(String.format("Failed while instrumenting code: %s", throwable.getMessage()));
            throwable.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        logger.info("Instrument time: " + (stopTime - startTime) + "ms");
        return 0;
    }

    public static void main(String[] args) {
        int returnValue = InstrumentMain.instrument(args);
        if (returnValue != 0) {
            System.exit(returnValue);
        }
    }

    private static ArgumentsBuilder createArgumentsFromCMDParams(String[] args) {
        ArgumentsBuilder builder = new ArgumentsBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--basedir")) {
                String baseDir = args[++i];
                builder.setBaseDirectory(baseDir);
                continue;
            }
            if (args[i].equals("--datafile")) {
                builder.setDataFile(args[++i]);
                continue;
            }
            if (args[i].equals("--destination")) {
                builder.setDestinationDirectory(args[++i]);
                continue;
            }
            if (args[i].equals("--ignore")) {
                builder.addIgnoreRegex(args[++i]);
                continue;
            }
            if (args[i].equals("--ignoreMethodAnnotation")) {
                builder.addIgnoreMethodAnnotation(args[++i]);
                continue;
            }
            if (args[i].equals("--ignoreClassAnnotation")) {
                builder.addIgnoreClassAnnotation(args[++i]);
                continue;
            }
            if (args[i].equals("--ignoreTrivial")) {
                builder.ignoreTrivial(true);
                continue;
            }
            if (args[i].equals("--includeClasses")) {
                builder.addIncludeClassesRegex(args[++i]);
                continue;
            }
            if (args[i].equals("--excludeClasses")) {
                builder.addExcludeClassesRegex(args[++i]);
                continue;
            }
            if (args[i].equals("--failOnError")) {
                builder.failOnError(true);
                logger.setFailOnError(true);
                continue;
            }
            if (args[i].equals("--threadsafeRigorous")) {
                builder.threadsafeRigorous(true);
                continue;
            }
            if (args[i].equals("--auxClasspath")) {
                InstrumentMain.addElementsToJVM(args[++i]);
                continue;
            }
            if (args[i].equals("--listOfFilesToInstrument")) {
                builder.listOfFilesToInstrument(args[++i]);
                continue;
            }
            builder.addFileToInstrument(args[i]);
        }
        return builder;
    }

    private static void addElementsToJVM(String classpath) {
        String[] classpathParsed;
        ArrayList<URL> urlsArray = new ArrayList<URL>();
        for (String element : classpathParsed = classpath.split(File.pathSeparator)) {
            File f = null;
            try {
                f = new File(element);
                urlsArray.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.debug("Warning - could not convert file: " + element + " to a URL.", e);
            }
        }
        urlClassLoader = new URLClassLoader(urlsArray.toArray(new URL[urlsArray.size()]));
    }

    private static class LoggerWrapper {
        private final Logger logger = LoggerFactory.getLogger(InstrumentMain.class);
        private boolean failOnError = false;

        private LoggerWrapper() {
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        public void debug(String message) {
            this.logger.debug(message);
        }

        public void debug(String message, Throwable t) {
            this.logger.debug(message, t);
        }

        public void info(String message) {
            this.logger.debug(message);
        }

        public void warn(String message, Throwable t) {
            this.logger.warn(message, t);
            if (this.failOnError) {
                throw new RuntimeException("Warning detected and failOnError is true", t);
            }
        }
    }
}

